/* whoopsie
 * 
 * Copyright © 2011-2013 Canonical Ltd.
 * Author: Evan Dandrea <evan.dandrea@canonical.com>
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef WHOOPSIE_H
#define WHOOPSIE_H

GHashTable* parse_report (const char* report_path, gboolean full_report, GError** error);
void get_system_uuid (char* res, GError** error);
char* get_crash_db_url (void);
gsize get_report_max_size (void);
void destroy_key_and_value (gpointer key, gpointer value, gpointer user_data);
void drop_privileges (GError** error);
gboolean process_existing_files (const char* report_dir);
char* last_uploaded_oopsid;

#endif /* WHOOPSIE_H */
