/****************************************************************************
**
** Copyright (C) 2013 Jolla Ltd.
** Contact: Aaron McCarthy <aaron.mccarthy@jollamobile.com>
** Copyright (C) 2013 Digia Plc and/or its subsidiary(-ies).
** Contact: http://www.qt-project.org/legal
**
** This file is part of the QtPositioning module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Digia.  For licensing terms and
** conditions see http://qt.digia.com/licensing.  For further information
** use the contact form at http://qt.digia.com/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Digia gives you certain additional
** rights.  These rights are described in the Digia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QGEOPOSITIONINFOSOURCE_GEOCLUEMASTER_H
#define QGEOPOSITIONINFOSOURCE_GEOCLUEMASTER_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include "qgeocluemaster.h"

#include <qgeopositioninfosource.h>
#include <geoclue/geoclue-velocity.h>
#include <QTimer>

//#define Q_LOCATION_GEOCLUE_DEBUG

QT_BEGIN_NAMESPACE

class QGeoPositionInfoSourceGeoclueMaster : public QGeoPositionInfoSource, public QGeoclueMaster
{
    Q_OBJECT
public:
    QGeoPositionInfoSourceGeoclueMaster(QObject *parent = 0);
    ~QGeoPositionInfoSourceGeoclueMaster();

    // From QGeoPositionInfoSource
    void setUpdateInterval(int msec);
    QGeoPositionInfo lastKnownPosition(bool fromSatellitePositioningMethodsOnly = false) const;
    PositioningMethods supportedPositioningMethods() const;
    void setPreferredPositioningMethods(PositioningMethods methods);
    int minimumUpdateInterval() const;
    bool init();

    void singleUpdateSucceeded(GeocluePositionFields fields,
                               int                   timestamp,
                               double                latitude,
                               double                longitude,
                               double                altitude,
                               GeoclueAccuracy      *accuracy);
    void regularUpdateFailed();
    void regularUpdateSucceeded(GeocluePositionFields fields,
                                int                   timestamp,
                                double                latitude,
                                double                longitude,
                                double                altitude,
                                GeoclueAccuracy      *accuracy);
    void velocityUpdateFailed();
    void velocityUpdateSucceeded(double speed);

    Error error() const;

public slots:
    virtual void startUpdates();
    virtual void stopUpdates();
    virtual void requestUpdate(int timeout = 5000);

private slots:
    void requestUpdateTimeout();
    void startUpdatesTimeout();
    void positionProviderChanged(const QByteArray &service, const QByteArray &path);

private:
    bool configurePositionSource();
    void cleanupPositionSource();
    QGeoPositionInfo geoclueToPositionInfo(GeocluePositionFields fields,
                                           int                   timestamp,
                                           double                latitude,
                                           double                longitude,
                                           double                altitude,
                                           GeoclueAccuracy *     accuracy);
private:
    int m_updateInterval;
    GeocluePosition *m_pos;
    GeoclueVelocity *m_vel;
    QTimer m_updateTimer;
    QTimer m_requestTimer;
    bool m_lastPositionIsFresh;
    bool m_lastVelocityIsFresh;
    double m_lastVelocity;
    bool m_lastPositionFromSatellite;
    QGeoPositionInfo m_lastPosition;
    PositioningMethods m_methods;
    bool m_running;
};

QT_END_NAMESPACE

#endif // QGEOPOSITIONINFOSOURCE_GEOCLUEMASTER_H
