/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.bytecode;

import java.io.IOException;
import org.gjt.jclasslib.bytecode.AbstractInstruction;
import org.gjt.jclasslib.io.ByteCodeInput;
import org.gjt.jclasslib.io.ByteCodeOutput;

public class ImmediateShortInstruction
extends AbstractInstruction {
    private int immediateShort;

    public int getSize() {
        return super.getSize() + 2;
    }

    public ImmediateShortInstruction(int n) {
        super(n);
    }

    public ImmediateShortInstruction(int n, int n2) {
        super(n);
        this.immediateShort = n2;
    }

    public int getImmediateShort() {
        return this.immediateShort;
    }

    public void setImmediateShort(int n) {
        this.immediateShort = n;
    }

    public void read(ByteCodeInput byteCodeInput) throws IOException {
        super.read(byteCodeInput);
        this.immediateShort = byteCodeInput.readUnsignedShort();
    }

    public void write(ByteCodeOutput byteCodeOutput) throws IOException {
        super.write(byteCodeOutput);
        byteCodeOutput.writeShort(this.immediateShort);
    }
}

