#include <stdio.h>

const unsigned int mem[] = {
   0x00000000, 0xffffffff, 0x80000000, 0x7fffffff,
   0x12345678, 0x90abcdef, 0xfffffffe, 0x00000001,
   0x24232221, 0x00000003, 0x34333231, 0x04030201,
};




#define TEST_3R(instruction, RSval, RTval, RD, RS, RT)    \
{                                                         \
   unsigned int out;                                      \
   __asm__ volatile (                                     \
      "li   $" #RD ", -1\n\t"                             \
      "move $" #RS ", %1\n\t"                             \
      "move $" #RT ", %2\n\t"                             \
      instruction " $" #RD ", $" #RS ", $" #RT "\n\t"     \
      "move %0, $" #RD "\n\t"                             \
      : "=&r" (out)                                       \
      : "r" (RSval), "r" (RTval)                          \
      : #RD, #RS, #RT, "memory"                           \
        );                                                \
   printf("%s :: rd 0x%08x rs 0x%08x, rt 0x%08x\n",       \
          instruction, out, RSval, RTval);                \
}


#define TEST_3R2b(instruction, RSval, RTval, RD, RS, RT, val)  \
{                                                              \
   unsigned int out;                                           \
   __asm__ volatile (                                          \
      "li   $" #RD ", -1\n\t"                                  \
      "move $" #RS ", %1\n\t"                                  \
      "move $" #RT ", %2\n\t"                                  \
      instruction " $" #RD ", $" #RS ", $" #RT ", " #val"\n\t" \
      "move %0, $" #RD "\n\t"                                  \
      : "=&r" (out)                                            \
      : "r" (RSval), "r" (RTval)                               \
      : #RD, #RS, #RT, "memory"                                \
        );                                                     \
   printf("%s :: rd 0x%08x rs 0x%08x, rt 0x%08x\n",            \
          instruction, out, RSval, RTval);                     \
}

#define TEST_2R(instruction, RSval, RD, RS)               \
{                                                         \
   unsigned int out;                                      \
   __asm__ volatile (                                     \
      "li   $" #RD ", -1\n\t"                             \
      "move $" #RS ", %1\n\t"                             \
      instruction " $" #RD ", $" #RS "\n\t"               \
      "move %0, $" #RD "\n\t"                             \
      : "=&r" (out)                                       \
      : "r" (RSval)                                       \
      : #RD, #RS, "memory"                                \
        );                                                \
   printf("%s :: rd 0x%08x rs 0x%08x\n",                  \
          instruction, out, RSval);                       \
}

#define TEST_2Rb(instruction, RSval, RD, RS, val)         \
{                                                         \
   unsigned int out;                                      \
   __asm__ volatile(                                      \
      "li   $" #RD ", -1\n\t"                             \
      "move $" #RS ", %1\n\t"                             \
      instruction " $" #RD ", $" #RS ", " #val "\n\t"     \
      "move %0, $" #RD "\n\t"                             \
      : "=&r" (out)                                       \
      : "r" (RSval)                                       \
      : #RD, #RS, "memory"                                \
        );                                                \
   printf("%s :: rd 0x%08x rs 0x%08x\n",                  \
          instruction, out, RSval);                       \
}

#define TEST_Rb(instruction, RSval, RS, val)              \
{                                                         \
   unsigned int out;                                      \
   __asm__ volatile(                                      \
      "move $" #RS ", %1\n\t"                             \
      instruction " $" #RS ", " #val "\n\t"               \
      "move %0, $" #RS "\n\t"                             \
      : "=&r" (out)                                       \
      : "r" (RSval)                                       \
      : #RS, "memory"                                     \
        );                                                \
   printf("%s :: rd 0x%08x rs 0x%08x\n",                  \
          instruction, out, RSval);                       \
}


int main(int argc, char **argv){

#if (__mips_isa_rev>=6)
   printf("div\n");
   TEST_3R("div", mem[0], mem[1], t1, t2, t0)
   TEST_3R("div", mem[0], mem[2], t2, t0, t1)
   TEST_3R("div", mem[0], mem[3], t0, t1, t2)
   TEST_3R("div", mem[0], mem[4], t1, t2, t0)
   TEST_3R("div", mem[0], mem[5], t2, t0, t1)
   TEST_3R("div", mem[0], mem[6], t0, t1, t2)
   TEST_3R("div", mem[0], mem[7], t1, t2, t0)
   TEST_3R("div", mem[0], mem[8], t2, t0, t1)
   TEST_3R("div", mem[0], mem[9], t0, t1, t2)
   TEST_3R("div", mem[0], mem[10], t1, t2, t0)
   TEST_3R("div", mem[0], mem[11], t2, t0, t1)
   TEST_3R("div", mem[1], mem[1], t2, t0, t1)
   TEST_3R("div", mem[1], mem[2], t0, t1, t2)
   TEST_3R("div", mem[1], mem[3], t1, t2, t0)
   TEST_3R("div", mem[1], mem[4], t2, t0, t1)
   TEST_3R("div", mem[1], mem[5], t0, t1, t2)
   TEST_3R("div", mem[1], mem[6], t1, t2, t0)
   TEST_3R("div", mem[1], mem[7], t2, t0, t1)
   TEST_3R("div", mem[1], mem[8], t0, t1, t2)
   TEST_3R("div", mem[1], mem[9], t1, t2, t0)
   TEST_3R("div", mem[1], mem[10], t2, t0, t1)
   TEST_3R("div", mem[1], mem[11], t0, t1, t2)
   TEST_3R("div", mem[2], mem[1], t0, t1, t2)
   TEST_3R("div", mem[2], mem[2], t1, t2, t0)
   TEST_3R("div", mem[2], mem[3], t2, t0, t1)
   TEST_3R("div", mem[2], mem[4], t0, t1, t2)
   TEST_3R("div", mem[2], mem[5], t1, t2, t0)
   TEST_3R("div", mem[2], mem[6], t2, t0, t1)
   TEST_3R("div", mem[2], mem[7], t0, t1, t2)
   TEST_3R("div", mem[2], mem[8], t1, t2, t0)
   TEST_3R("div", mem[2], mem[9], t2, t0, t1)
   TEST_3R("div", mem[2], mem[10], t0, t1, t2)
   TEST_3R("div", mem[2], mem[11], t1, t2, t0)
   TEST_3R("div", mem[3], mem[1], t1, t2, t0)
   TEST_3R("div", mem[3], mem[2], t2, t0, t1)
   TEST_3R("div", mem[3], mem[3], t0, t1, t2)
   TEST_3R("div", mem[3], mem[4], t1, t2, t0)
   TEST_3R("div", mem[3], mem[5], t2, t0, t1)
   TEST_3R("div", mem[3], mem[6], t0, t1, t2)
   TEST_3R("div", mem[3], mem[7], t0, t2, t0)
   TEST_3R("div", mem[3], mem[8], t2, t0, t1)
   TEST_3R("div", mem[3], mem[9], t0, t1, t2)
   TEST_3R("div", mem[3], mem[10], t1, t2, t0)
   TEST_3R("div", mem[3], mem[11], t2, t0, t1)
   TEST_3R("div", mem[4], mem[1], t2, t0, t1)
   TEST_3R("div", mem[4], mem[2], t0, t1, t2)
   TEST_3R("div", mem[4], mem[3], t1, t2, t0)
   TEST_3R("div", mem[4], mem[4], t2, t0, t1)
   TEST_3R("div", mem[4], mem[5], t0, t1, t2)
   TEST_3R("div", mem[4], mem[6], t1, t2, t0)
   TEST_3R("div", mem[4], mem[7], t2, t0, t1)
   TEST_3R("div", mem[4], mem[8], t0, t1, t2)
   TEST_3R("div", mem[4], mem[9], t1, t2, t0)
   TEST_3R("div", mem[4], mem[10], t2, t0, t1)
   TEST_3R("div", mem[4], mem[11], t0, t1, t2)
   TEST_3R("div", mem[5], mem[1], t0, t1, t2)
   TEST_3R("div", mem[5], mem[2], t1, t2, t0)
   TEST_3R("div", mem[5], mem[3], t2, t0, t1)
   TEST_3R("div", mem[5], mem[4], t0, t1, t2)
   TEST_3R("div", mem[5], mem[5], t1, t2, t0)
   TEST_3R("div", mem[5], mem[6], t2, t0, t1)
   TEST_3R("div", mem[5], mem[7], t0, t1, t1)
   TEST_3R("div", mem[5], mem[8], t1, t2, t0)
   TEST_3R("div", mem[5], mem[9], t2, t0, t1)
   TEST_3R("div", mem[5], mem[10], t0, t1, t2)
   TEST_3R("div", mem[5], mem[11], t1, t2, t0)
   TEST_3R("div", mem[6], mem[1], t2, t2, t0)
   TEST_3R("div", mem[6], mem[2], t2, t0, t1)
   TEST_3R("div", mem[6], mem[3], t0, t1, t2)
   TEST_3R("div", mem[6], mem[4], t1, t2, t0)
   TEST_3R("div", mem[6], mem[5], t2, t0, t1)
   TEST_3R("div", mem[6], mem[6], t0, t1, t2)
   TEST_3R("div", mem[6], mem[7], t1, t2, t0)
   TEST_3R("div", mem[6], mem[8], t2, t0, t1)
   TEST_3R("div", mem[6], mem[9], t0, t1, t2)
   TEST_3R("div", mem[6], mem[10], t1, t2, t0)
   TEST_3R("div", mem[6], mem[11], t2, t0, t1)
   TEST_3R("div", mem[7], mem[1], t2, t0, t1)
   TEST_3R("div", mem[7], mem[2], t0, t1, t2)
   TEST_3R("div", mem[7], mem[3], t1, t2, t0)
   TEST_3R("div", mem[7], mem[4], t2, t0, t1)
   TEST_3R("div", mem[7], mem[5], t0, t1, t2)
   TEST_3R("div", mem[7], mem[6], t1, t2, t0)
   TEST_3R("div", mem[7], mem[7], t2, t0, t1)
   TEST_3R("div", mem[7], mem[8], t0, t1, t2)
   TEST_3R("div", mem[7], mem[9], t1, t2, t0)
   TEST_3R("div", mem[7], mem[10], t2, t0, t1)
   TEST_3R("div", mem[7], mem[11], t0, t1, t2)
   TEST_3R("div", mem[8], mem[1], t0, t1, t2)
   TEST_3R("div", mem[8], mem[2], t1, t2, t0)
   TEST_3R("div", mem[8], mem[3], t2, t0, t1)
   TEST_3R("div", mem[8], mem[4], t0, t1, t2)
   TEST_3R("div", mem[8], mem[5], t1, t2, t0)
   TEST_3R("div", mem[8], mem[6], t2, t0, t1)
   TEST_3R("div", mem[8], mem[7], t0, t1, t2)
   TEST_3R("div", mem[8], mem[8], t1, t2, t0)
   TEST_3R("div", mem[8], mem[9], t2, t0, t1)
   TEST_3R("div", mem[8], mem[10], t0, t1, t2)
   TEST_3R("div", mem[8], mem[11], t1, t2, t0)
   TEST_3R("div", mem[9], mem[1], t1, t2, t0)
   TEST_3R("div", mem[9], mem[2], t2, t0, t1)
   TEST_3R("div", mem[9], mem[3], t0, t1, t2)
   TEST_3R("div", mem[9], mem[4], t1, t2, t0)
   TEST_3R("div", mem[9], mem[5], t2, t0, t1)
   TEST_3R("div", mem[9], mem[6], t0, t1, t2)
   TEST_3R("div", mem[9], mem[7], t1, t2, t0)
   TEST_3R("div", mem[9], mem[8], t2, t0, t1)
   TEST_3R("div", mem[9], mem[9], t0, t1, t2)
   TEST_3R("div", mem[9], mem[10], t1, t2, t0)
   TEST_3R("div", mem[9], mem[11], t2, t0, t1)
   TEST_3R("div", mem[10], mem[1], t2, t0, t1)
   TEST_3R("div", mem[10], mem[2], t0, t1, t2)
   TEST_3R("div", mem[10], mem[3], t1, t2, t0)
   TEST_3R("div", mem[10], mem[4], t2, t0, t1)
   TEST_3R("div", mem[10], mem[5], t0, t1, t2)
   TEST_3R("div", mem[10], mem[6], t1, t2, t0)
   TEST_3R("div", mem[10], mem[7], t2, t0, t1)
   TEST_3R("div", mem[10], mem[8], t0, t1, t2)
   TEST_3R("div", mem[10], mem[9], t1, t2, t0)
   TEST_3R("div", mem[10], mem[10], t2, t0, t1)
   TEST_3R("div", mem[10], mem[11], t0, t1, t2)
   TEST_3R("div", mem[11], mem[1], t0, t1, t2)
   TEST_3R("div", mem[11], mem[2], t1, t2, t0)
   TEST_3R("div", mem[11], mem[3], t2, t0, t1)
   TEST_3R("div", mem[11], mem[4], t0, t1, t2)
   TEST_3R("div", mem[11], mem[5], t1, t2, t0)
   TEST_3R("div", mem[11], mem[6], t2, t0, t1)
   TEST_3R("div", mem[11], mem[7], t0, t1, t2)
   TEST_3R("div", mem[11], mem[8], t1, t2, t0)
   TEST_3R("div", mem[11], mem[9], t2, t0, t1)
   TEST_3R("div", mem[11], mem[10], t0, t1, t2)
   TEST_3R("div", mem[11], mem[11], t2, t2, t2)

   printf("\nmod\n");
   TEST_3R("mod", mem[0], mem[1], t1, t2, t0)
   TEST_3R("mod", mem[0], mem[2], t2, t0, t1)
   TEST_3R("mod", mem[0], mem[3], t0, t1, t2)
   TEST_3R("mod", mem[0], mem[4], t1, t2, t0)
   TEST_3R("mod", mem[0], mem[5], t2, t0, t1)
   TEST_3R("mod", mem[0], mem[6], t0, t1, t2)
   TEST_3R("mod", mem[0], mem[7], t1, t2, t0)
   TEST_3R("mod", mem[0], mem[8], t2, t0, t1)
   TEST_3R("mod", mem[0], mem[9], t0, t1, t2)
   TEST_3R("mod", mem[0], mem[10], t1, t2, t0)
   TEST_3R("mod", mem[0], mem[11], t2, t0, t1)
   TEST_3R("mod", mem[1], mem[1], t2, t0, t1)
   TEST_3R("mod", mem[1], mem[2], t0, t1, t2)
   TEST_3R("mod", mem[1], mem[3], t1, t2, t0)
   TEST_3R("mod", mem[1], mem[4], t2, t0, t1)
   TEST_3R("mod", mem[1], mem[5], t0, t1, t2)
   TEST_3R("mod", mem[1], mem[6], t1, t0, t0)
   TEST_3R("mod", mem[1], mem[7], t2, t0, t1)
   TEST_3R("mod", mem[1], mem[8], t0, t1, t2)
   TEST_3R("mod", mem[1], mem[9], t1, t2, t0)
   TEST_3R("mod", mem[1], mem[10], t2, t0, t1)
   TEST_3R("mod", mem[1], mem[11], t0, t1, t2)
   TEST_3R("mod", mem[2], mem[1], t0, t1, t2)
   TEST_3R("mod", mem[2], mem[2], t1, t2, t0)
   TEST_3R("mod", mem[2], mem[3], t2, t0, t1)
   TEST_3R("mod", mem[2], mem[4], t0, t1, t2)
   TEST_3R("mod", mem[2], mem[5], t1, t2, t0)
   TEST_3R("mod", mem[2], mem[6], t2, t0, t1)
   TEST_3R("mod", mem[2], mem[7], t0, t1, t0)
   TEST_3R("mod", mem[2], mem[8], t1, t2, t0)
   TEST_3R("mod", mem[2], mem[9], t2, t0, t1)
   TEST_3R("mod", mem[2], mem[10], t0, t1, t2)
   TEST_3R("mod", mem[2], mem[11], t1, t2, t0)
   TEST_3R("mod", mem[3], mem[1], t1, t2, t0)
   TEST_3R("mod", mem[3], mem[2], t2, t0, t1)
   TEST_3R("mod", mem[3], mem[3], t0, t1, t2)
   TEST_3R("mod", mem[3], mem[4], t1, t2, t0)
   TEST_3R("mod", mem[3], mem[5], t2, t0, t1)
   TEST_3R("mod", mem[3], mem[6], t0, t1, t2)
   TEST_3R("mod", mem[3], mem[7], t1, t2, t0)
   TEST_3R("mod", mem[3], mem[8], t2, t0, t1)
   TEST_3R("mod", mem[3], mem[9], t0, t1, t2)
   TEST_3R("mod", mem[3], mem[10], t1, t2, t1)
   TEST_3R("mod", mem[3], mem[11], t2, t0, t1)
   TEST_3R("mod", mem[4], mem[1], t2, t0, t1)
   TEST_3R("mod", mem[4], mem[2], t0, t1, t2)
   TEST_3R("mod", mem[4], mem[3], t1, t2, t0)
   TEST_3R("mod", mem[4], mem[4], t2, t0, t1)
   TEST_3R("mod", mem[4], mem[5], t0, t0, t0)
   TEST_3R("mod", mem[4], mem[6], t1, t2, t0)
   TEST_3R("mod", mem[4], mem[7], t2, t0, t1)
   TEST_3R("mod", mem[4], mem[8], t0, t1, t2)
   TEST_3R("mod", mem[4], mem[9], t1, t2, t0)
   TEST_3R("mod", mem[4], mem[10], t2, t0, t1)
   TEST_3R("mod", mem[4], mem[11], t0, t1, t2)
   TEST_3R("mod", mem[5], mem[1], t0, t1, t2)
   TEST_3R("mod", mem[5], mem[2], t1, t2, t0)
   TEST_3R("mod", mem[5], mem[3], t2, t0, t1)
   TEST_3R("mod", mem[5], mem[4], t0, t1, t2)
   TEST_3R("mod", mem[5], mem[5], t1, t2, t0)
   TEST_3R("mod", mem[5], mem[6], t2, t0, t1)
   TEST_3R("mod", mem[5], mem[7], t0, t1, t2)
   TEST_3R("mod", mem[5], mem[8], t1, t2, t0)
   TEST_3R("mod", mem[5], mem[9], t2, t0, t1)
   TEST_3R("mod", mem[5], mem[10], t0, t1, t2)
   TEST_3R("mod", mem[5], mem[11], t1, t2, t0)
   TEST_3R("mod", mem[6], mem[1], t1, t2, t0)
   TEST_3R("mod", mem[6], mem[2], t2, t0, t1)
   TEST_3R("mod", mem[6], mem[3], t0, t1, t2)
   TEST_3R("mod", mem[6], mem[4], t1, t2, t0)
   TEST_3R("mod", mem[6], mem[5], t2, t0, t1)
   TEST_3R("mod", mem[6], mem[6], t0, t1, t2)
   TEST_3R("mod", mem[6], mem[7], t1, t2, t0)
   TEST_3R("mod", mem[6], mem[8], t2, t0, t1)
   TEST_3R("mod", mem[6], mem[9], t0, t1, t2)
   TEST_3R("mod", mem[6], mem[10], t1, t2, t0)
   TEST_3R("mod", mem[6], mem[11], t2, t0, t1)
   TEST_3R("mod", mem[7], mem[1], t2, t0, t1)
   TEST_3R("mod", mem[7], mem[2], t0, t1, t2)
   TEST_3R("mod", mem[7], mem[3], t1, t2, t0)
   TEST_3R("mod", mem[7], mem[4], t2, t0, t1)
   TEST_3R("mod", mem[7], mem[5], t0, t1, t2)
   TEST_3R("mod", mem[7], mem[6], t1, t2, t0)
   TEST_3R("mod", mem[7], mem[7], t2, t0, t1)
   TEST_3R("mod", mem[7], mem[8], t0, t1, t2)
   TEST_3R("mod", mem[7], mem[9], t1, t2, t0)
   TEST_3R("mod", mem[7], mem[10], t2, t0, t1)
   TEST_3R("mod", mem[7], mem[11], t0, t1, t2)
   TEST_3R("mod", mem[8], mem[1], t0, t1, t2)
   TEST_3R("mod", mem[8], mem[2], t1, t2, t0)
   TEST_3R("mod", mem[8], mem[3], t2, t0, t1)
   TEST_3R("mod", mem[8], mem[4], t0, t1, t2)
   TEST_3R("mod", mem[8], mem[5], t1, t2, t0)
   TEST_3R("mod", mem[8], mem[6], t2, t0, t1)
   TEST_3R("mod", mem[8], mem[7], t0, t1, t2)
   TEST_3R("mod", mem[8], mem[8], t1, t2, t0)
   TEST_3R("mod", mem[8], mem[9], t2, t0, t1)
   TEST_3R("mod", mem[8], mem[10], t0, t1, t2)
   TEST_3R("mod", mem[8], mem[11], t1, t2, t0)
   TEST_3R("mod", mem[9], mem[1], t1, t2, t0)
   TEST_3R("mod", mem[9], mem[2], t2, t0, t1)
   TEST_3R("mod", mem[9], mem[3], t0, t1, t2)
   TEST_3R("mod", mem[9], mem[4], t1, t2, t0)
   TEST_3R("mod", mem[9], mem[5], t2, t0, t1)
   TEST_3R("mod", mem[9], mem[6], t0, t1, t2)
   TEST_3R("mod", mem[9], mem[7], t1, t2, t0)
   TEST_3R("mod", mem[9], mem[8], t2, t0, t1)
   TEST_3R("mod", mem[9], mem[9], t0, t1, t2)
   TEST_3R("mod", mem[9], mem[10], t1, t2, t0)
   TEST_3R("mod", mem[9], mem[11], t2, t0, t1)
   TEST_3R("mod", mem[10], mem[1], t2, t0, t1)
   TEST_3R("mod", mem[10], mem[2], t0, t1, t2)
   TEST_3R("mod", mem[10], mem[3], t1, t2, t0)
   TEST_3R("mod", mem[10], mem[4], t2, t0, t1)
   TEST_3R("mod", mem[10], mem[5], t0, t1, t2)
   TEST_3R("mod", mem[10], mem[6], t1, t2, t0)
   TEST_3R("mod", mem[10], mem[7], t2, t0, t1)
   TEST_3R("mod", mem[10], mem[8], t0, t1, t2)
   TEST_3R("mod", mem[10], mem[9], t1, t2, t0)
   TEST_3R("mod", mem[10], mem[10], t2, t0, t1)
   TEST_3R("mod", mem[10], mem[11], t0, t1, t2)
   TEST_3R("mod", mem[11], mem[1], t0, t1, t2)
   TEST_3R("mod", mem[11], mem[2], t1, t2, t0)
   TEST_3R("mod", mem[11], mem[3], t2, t0, t1)
   TEST_3R("mod", mem[11], mem[4], t0, t1, t2)
   TEST_3R("mod", mem[11], mem[5], t1, t2, t0)
   TEST_3R("mod", mem[11], mem[6], t2, t0, t1)
   TEST_3R("mod", mem[11], mem[7], t0, t1, t2)
   TEST_3R("mod", mem[11], mem[8], t1, t2, t0)
   TEST_3R("mod", mem[11], mem[9], t2, t0, t1)
   TEST_3R("mod", mem[11], mem[10], t0, t1, t2)
   TEST_3R("mod", mem[11], mem[11], t1, t2, t0)

   printf("\ndivu\n");
   TEST_3R("divu", mem[0], mem[1], t1, t2, t0)
   TEST_3R("divu", mem[0], mem[2], t2, t0, t1)
   TEST_3R("divu", mem[0], mem[3], t0, t1, t2)
   TEST_3R("divu", mem[0], mem[4], t1, t2, t0)
   TEST_3R("divu", mem[0], mem[5], t2, t0, t1)
   TEST_3R("divu", mem[0], mem[6], t0, t1, t2)
   TEST_3R("divu", mem[0], mem[7], t1, t2, t0)
   TEST_3R("divu", mem[0], mem[8], t2, t0, t1)
   TEST_3R("divu", mem[0], mem[9], t0, t1, t2)
   TEST_3R("divu", mem[0], mem[10], t1, t2, t0)
   TEST_3R("divu", mem[0], mem[11], t2, t0, t1)
   TEST_3R("divu", mem[1], mem[1], t2, t0, t1)
   TEST_3R("divu", mem[1], mem[2], t0, t1, t2)
   TEST_3R("divu", mem[1], mem[3], t1, t2, t0)
   TEST_3R("divu", mem[1], mem[4], t2, t0, t1)
   TEST_3R("divu", mem[1], mem[5], t0, t1, t2)
   TEST_3R("divu", mem[1], mem[6], t1, t2, t0)
   TEST_3R("divu", mem[1], mem[7], t2, t0, t1)
   TEST_3R("divu", mem[1], mem[8], t0, t1, t2)
   TEST_3R("divu", mem[1], mem[9], t1, t2, t0)
   TEST_3R("divu", mem[1], mem[10], t2, t0, t1)
   TEST_3R("divu", mem[1], mem[11], t0, t1, t2)
   TEST_3R("divu", mem[2], mem[1], t0, t1, t2)
   TEST_3R("divu", mem[2], mem[2], t1, t2, t0)
   TEST_3R("divu", mem[2], mem[3], t2, t0, t1)
   TEST_3R("divu", mem[2], mem[4], t0, t1, t2)
   TEST_3R("divu", mem[2], mem[5], t1, t2, t0)
   TEST_3R("divu", mem[2], mem[6], t2, t0, t1)
   TEST_3R("divu", mem[2], mem[7], t0, t1, t2)
   TEST_3R("divu", mem[2], mem[8], t1, t2, t0)
   TEST_3R("divu", mem[2], mem[9], t2, t0, t1)
   TEST_3R("divu", mem[2], mem[10], t0, t1, t2)
   TEST_3R("divu", mem[2], mem[11], t1, t2, t0)
   TEST_3R("divu", mem[3], mem[1], t1, t2, t0)
   TEST_3R("divu", mem[3], mem[2], t2, t0, t1)
   TEST_3R("divu", mem[3], mem[3], t0, t1, t2)
   TEST_3R("divu", mem[3], mem[4], t1, t2, t0)
   TEST_3R("divu", mem[3], mem[5], t2, t0, t1)
   TEST_3R("divu", mem[3], mem[6], t0, t1, t2)
   TEST_3R("divu", mem[3], mem[7], t1, t2, t0)
   TEST_3R("divu", mem[3], mem[8], t2, t0, t1)
   TEST_3R("divu", mem[3], mem[9], t0, t1, t2)
   TEST_3R("divu", mem[3], mem[10], t1, t2, t0)
   TEST_3R("divu", mem[3], mem[11], t2, t0, t1)
   TEST_3R("divu", mem[4], mem[1], t2, t0, t1)
   TEST_3R("divu", mem[4], mem[2], t0, t1, t2)
   TEST_3R("divu", mem[4], mem[3], t1, t2, t0)
   TEST_3R("divu", mem[4], mem[4], t2, t0, t1)
   TEST_3R("divu", mem[4], mem[5], t0, t1, t2)
   TEST_3R("divu", mem[4], mem[6], t1, t2, t0)
   TEST_3R("divu", mem[4], mem[7], t2, t0, t1)
   TEST_3R("divu", mem[4], mem[8], t0, t1, t2)
   TEST_3R("divu", mem[4], mem[9], t1, t2, t0)
   TEST_3R("divu", mem[4], mem[10], t2, t0, t1)
   TEST_3R("divu", mem[4], mem[11], t0, t1, t2)
   TEST_3R("divu", mem[5], mem[1], t0, t1, t2)
   TEST_3R("divu", mem[5], mem[2], t1, t2, t0)
   TEST_3R("divu", mem[5], mem[3], t2, t0, t1)
   TEST_3R("divu", mem[5], mem[4], t0, t1, t2)
   TEST_3R("divu", mem[5], mem[5], t1, t2, t0)
   TEST_3R("divu", mem[5], mem[6], t2, t0, t1)
   TEST_3R("divu", mem[5], mem[7], t0, t1, t2)
   TEST_3R("divu", mem[5], mem[8], t1, t2, t0)
   TEST_3R("divu", mem[5], mem[9], t2, t0, t1)
   TEST_3R("divu", mem[5], mem[10], t0, t1, t2)
   TEST_3R("divu", mem[5], mem[11], t1, t2, t0)
   TEST_3R("divu", mem[6], mem[1], t1, t2, t0)
   TEST_3R("divu", mem[6], mem[2], t2, t0, t1)
   TEST_3R("divu", mem[6], mem[3], t0, t1, t2)
   TEST_3R("divu", mem[6], mem[4], t1, t2, t0)
   TEST_3R("divu", mem[6], mem[5], t2, t0, t1)
   TEST_3R("divu", mem[6], mem[6], t0, t1, t2)
   TEST_3R("divu", mem[6], mem[7], t1, t2, t0)
   TEST_3R("divu", mem[6], mem[8], t2, t0, t1)
   TEST_3R("divu", mem[6], mem[9], t0, t1, t2)
   TEST_3R("divu", mem[6], mem[10], t1, t2, t0)
   TEST_3R("divu", mem[6], mem[11], t2, t0, t1)
   TEST_3R("divu", mem[7], mem[1], t2, t0, t1)
   TEST_3R("divu", mem[7], mem[2], t0, t1, t2)
   TEST_3R("divu", mem[7], mem[3], t1, t2, t0)
   TEST_3R("divu", mem[7], mem[4], t2, t0, t1)
   TEST_3R("divu", mem[7], mem[5], t0, t1, t2)
   TEST_3R("divu", mem[7], mem[6], t1, t2, t0)
   TEST_3R("divu", mem[7], mem[7], t2, t0, t1)
   TEST_3R("divu", mem[7], mem[8], t0, t1, t2)
   TEST_3R("divu", mem[7], mem[9], t1, t2, t0)
   TEST_3R("divu", mem[7], mem[10], t2, t0, t1)
   TEST_3R("divu", mem[7], mem[11], t0, t1, t2)
   TEST_3R("divu", mem[8], mem[1], t0, t1, t2)
   TEST_3R("divu", mem[8], mem[2], t1, t2, t0)
   TEST_3R("divu", mem[8], mem[3], t2, t0, t1)
   TEST_3R("divu", mem[8], mem[4], t0, t1, t2)
   TEST_3R("divu", mem[8], mem[5], t1, t2, t0)
   TEST_3R("divu", mem[8], mem[6], t2, t0, t1)
   TEST_3R("divu", mem[8], mem[7], t0, t1, t2)
   TEST_3R("divu", mem[8], mem[8], t1, t2, t0)
   TEST_3R("divu", mem[8], mem[9], t2, t0, t1)
   TEST_3R("divu", mem[8], mem[10], t0, t1, t2)
   TEST_3R("divu", mem[8], mem[11], t1, t2, t0)
   TEST_3R("divu", mem[9], mem[1], t1, t2, t0)
   TEST_3R("divu", mem[9], mem[2], t2, t0, t1)
   TEST_3R("divu", mem[9], mem[3], t0, t1, t2)
   TEST_3R("divu", mem[9], mem[4], t1, t2, t0)
   TEST_3R("divu", mem[9], mem[5], t2, t0, t1)
   TEST_3R("divu", mem[9], mem[6], t0, t1, t2)
   TEST_3R("divu", mem[9], mem[7], t1, t2, t0)
   TEST_3R("divu", mem[9], mem[8], t2, t0, t1)
   TEST_3R("divu", mem[9], mem[9], t0, t1, t2)
   TEST_3R("divu", mem[9], mem[10], t1, t2, t0)
   TEST_3R("divu", mem[9], mem[11], t2, t0, t1)
   TEST_3R("divu", mem[10], mem[1], t2, t0, t1)
   TEST_3R("divu", mem[10], mem[2], t0, t1, t2)
   TEST_3R("divu", mem[10], mem[3], t1, t2, t0)
   TEST_3R("divu", mem[10], mem[4], t2, t0, t1)
   TEST_3R("divu", mem[10], mem[5], t0, t1, t2)
   TEST_3R("divu", mem[10], mem[6], t1, t2, t0)
   TEST_3R("divu", mem[10], mem[7], t2, t0, t1)
   TEST_3R("divu", mem[10], mem[8], t0, t1, t2)
   TEST_3R("divu", mem[10], mem[9], t1, t2, t0)
   TEST_3R("divu", mem[10], mem[10], t2, t0, t1)
   TEST_3R("divu", mem[10], mem[11], t0, t1, t2)
   TEST_3R("divu", mem[11], mem[1], t0, t1, t2)
   TEST_3R("divu", mem[11], mem[2], t1, t2, t0)
   TEST_3R("divu", mem[11], mem[3], t2, t0, t1)
   TEST_3R("divu", mem[11], mem[4], t0, t1, t2)
   TEST_3R("divu", mem[11], mem[5], t1, t2, t0)
   TEST_3R("divu", mem[11], mem[6], t2, t0, t1)
   TEST_3R("divu", mem[11], mem[7], t0, t1, t2)
   TEST_3R("divu", mem[11], mem[8], t1, t2, t0)
   TEST_3R("divu", mem[11], mem[9], t2, t0, t1)
   TEST_3R("divu", mem[11], mem[10], t0, t1, t2)
   TEST_3R("divu", mem[11], mem[11], t1, t2, t0)

   printf("\nmodu\n");
   TEST_3R("modu", mem[0], mem[1], t1, t2, t0)
   TEST_3R("modu", mem[0], mem[2], t2, t0, t1)
   TEST_3R("modu", mem[0], mem[3], t0, t1, t2)
   TEST_3R("modu", mem[0], mem[4], t1, t2, t0)
   TEST_3R("modu", mem[0], mem[5], t2, t0, t1)
   TEST_3R("modu", mem[0], mem[6], t0, t1, t2)
   TEST_3R("modu", mem[0], mem[7], t1, t2, t0)
   TEST_3R("modu", mem[0], mem[8], t2, t0, t1)
   TEST_3R("modu", mem[0], mem[9], t0, t1, t2)
   TEST_3R("modu", mem[0], mem[10], t1, t2, t0)
   TEST_3R("modu", mem[0], mem[11], t2, t0, t1)
   TEST_3R("modu", mem[1], mem[1], t2, t0, t1)
   TEST_3R("modu", mem[1], mem[2], t0, t1, t2)
   TEST_3R("modu", mem[1], mem[3], t1, t2, t0)
   TEST_3R("modu", mem[1], mem[4], t2, t0, t1)
   TEST_3R("modu", mem[1], mem[5], t0, t1, t2)
   TEST_3R("modu", mem[1], mem[6], t1, t2, t0)
   TEST_3R("modu", mem[1], mem[7], t2, t0, t1)
   TEST_3R("modu", mem[1], mem[8], t0, t1, t2)
   TEST_3R("modu", mem[1], mem[9], t1, t2, t0)
   TEST_3R("modu", mem[1], mem[10], t2, t0, t1)
   TEST_3R("modu", mem[1], mem[11], t0, t1, t2)
   TEST_3R("modu", mem[2], mem[1], t0, t1, t2)
   TEST_3R("modu", mem[2], mem[2], t1, t2, t0)
   TEST_3R("modu", mem[2], mem[3], t2, t0, t1)
   TEST_3R("modu", mem[2], mem[4], t0, t1, t2)
   TEST_3R("modu", mem[2], mem[5], t1, t2, t0)
   TEST_3R("modu", mem[2], mem[6], t2, t0, t1)
   TEST_3R("modu", mem[2], mem[7], t0, t1, t2)
   TEST_3R("modu", mem[2], mem[8], t1, t2, t0)
   TEST_3R("modu", mem[2], mem[9], t2, t0, t1)
   TEST_3R("modu", mem[2], mem[10], t0, t1, t2)
   TEST_3R("modu", mem[2], mem[11], t1, t2, t0)
   TEST_3R("modu", mem[3], mem[1], t1, t2, t0)
   TEST_3R("modu", mem[3], mem[2], t2, t0, t1)
   TEST_3R("modu", mem[3], mem[3], t0, t1, t2)
   TEST_3R("modu", mem[3], mem[4], t1, t2, t0)
   TEST_3R("modu", mem[3], mem[5], t2, t0, t1)
   TEST_3R("modu", mem[3], mem[6], t0, t1, t2)
   TEST_3R("modu", mem[3], mem[7], t1, t2, t0)
   TEST_3R("modu", mem[3], mem[8], t2, t0, t1)
   TEST_3R("modu", mem[3], mem[9], t0, t1, t2)
   TEST_3R("modu", mem[3], mem[10], t1, t2, t0)
   TEST_3R("modu", mem[3], mem[11], t2, t0, t1)
   TEST_3R("modu", mem[4], mem[1], t2, t0, t1)
   TEST_3R("modu", mem[4], mem[2], t0, t1, t2)
   TEST_3R("modu", mem[4], mem[3], t1, t2, t0)
   TEST_3R("modu", mem[4], mem[4], t2, t0, t1)
   TEST_3R("modu", mem[4], mem[5], t0, t1, t2)
   TEST_3R("modu", mem[4], mem[6], t1, t2, t0)
   TEST_3R("modu", mem[4], mem[7], t2, t0, t1)
   TEST_3R("modu", mem[4], mem[8], t0, t1, t2)
   TEST_3R("modu", mem[4], mem[9], t1, t2, t0)
   TEST_3R("modu", mem[4], mem[10], t2, t0, t1)
   TEST_3R("modu", mem[4], mem[11], t0, t1, t2)
   TEST_3R("modu", mem[5], mem[1], t0, t1, t2)
   TEST_3R("modu", mem[5], mem[2], t1, t2, t0)
   TEST_3R("modu", mem[5], mem[3], t2, t0, t1)
   TEST_3R("modu", mem[5], mem[4], t0, t1, t2)
   TEST_3R("modu", mem[5], mem[5], t1, t2, t0)
   TEST_3R("modu", mem[5], mem[6], t2, t0, t1)
   TEST_3R("modu", mem[5], mem[7], t0, t1, t2)
   TEST_3R("modu", mem[5], mem[8], t1, t2, t0)
   TEST_3R("modu", mem[5], mem[9], t2, t0, t1)
   TEST_3R("modu", mem[5], mem[10], t0, t1, t2)
   TEST_3R("modu", mem[5], mem[11], t1, t2, t0)
   TEST_3R("modu", mem[6], mem[1], t1, t2, t0)
   TEST_3R("modu", mem[6], mem[2], t2, t0, t1)
   TEST_3R("modu", mem[6], mem[3], t0, t1, t2)
   TEST_3R("modu", mem[6], mem[4], t1, t2, t0)
   TEST_3R("modu", mem[6], mem[5], t2, t0, t1)
   TEST_3R("modu", mem[6], mem[6], t0, t1, t2)
   TEST_3R("modu", mem[6], mem[7], t1, t2, t0)
   TEST_3R("modu", mem[6], mem[8], t2, t0, t1)
   TEST_3R("modu", mem[6], mem[9], t0, t1, t2)
   TEST_3R("modu", mem[6], mem[10], t1, t2, t0)
   TEST_3R("modu", mem[6], mem[11], t2, t0, t1)
   TEST_3R("modu", mem[7], mem[1], t2, t0, t1)
   TEST_3R("modu", mem[7], mem[2], t0, t1, t2)
   TEST_3R("modu", mem[7], mem[3], t1, t2, t0)
   TEST_3R("modu", mem[7], mem[4], t2, t0, t1)
   TEST_3R("modu", mem[7], mem[5], t0, t1, t2)
   TEST_3R("modu", mem[7], mem[6], t1, t2, t0)
   TEST_3R("modu", mem[7], mem[7], t2, t0, t1)
   TEST_3R("modu", mem[7], mem[8], t0, t1, t2)
   TEST_3R("modu", mem[7], mem[9], t1, t2, t0)
   TEST_3R("modu", mem[7], mem[10], t2, t0, t1)
   TEST_3R("modu", mem[7], mem[11], t0, t1, t2)
   TEST_3R("modu", mem[8], mem[1], t0, t1, t2)
   TEST_3R("modu", mem[8], mem[2], t1, t2, t0)
   TEST_3R("modu", mem[8], mem[3], t2, t0, t1)
   TEST_3R("modu", mem[8], mem[4], t0, t1, t2)
   TEST_3R("modu", mem[8], mem[5], t1, t2, t0)
   TEST_3R("modu", mem[8], mem[6], t2, t0, t1)
   TEST_3R("modu", mem[8], mem[7], t0, t1, t2)
   TEST_3R("modu", mem[8], mem[8], t1, t2, t0)
   TEST_3R("modu", mem[8], mem[9], t2, t0, t1)
   TEST_3R("modu", mem[8], mem[10], t0, t1, t2)
   TEST_3R("modu", mem[8], mem[11], t1, t2, t0)
   TEST_3R("modu", mem[9], mem[1], t1, t2, t0)
   TEST_3R("modu", mem[9], mem[2], t2, t0, t1)
   TEST_3R("modu", mem[9], mem[3], t0, t1, t2)
   TEST_3R("modu", mem[9], mem[4], t1, t2, t0)
   TEST_3R("modu", mem[9], mem[5], t2, t0, t1)
   TEST_3R("modu", mem[9], mem[6], t0, t1, t2)
   TEST_3R("modu", mem[9], mem[7], t1, t2, t0)
   TEST_3R("modu", mem[9], mem[8], t2, t0, t1)
   TEST_3R("modu", mem[9], mem[9], t0, t1, t2)
   TEST_3R("modu", mem[9], mem[10], t1, t2, t0)
   TEST_3R("modu", mem[9], mem[11], t2, t0, t1)
   TEST_3R("modu", mem[10], mem[1], t2, t0, t1)
   TEST_3R("modu", mem[10], mem[2], t0, t1, t2)
   TEST_3R("modu", mem[10], mem[3], t1, t2, t0)
   TEST_3R("modu", mem[10], mem[4], t2, t0, t1)
   TEST_3R("modu", mem[10], mem[5], t0, t1, t2)
   TEST_3R("modu", mem[10], mem[6], t1, t2, t0)
   TEST_3R("modu", mem[10], mem[7], t2, t0, t1)
   TEST_3R("modu", mem[10], mem[8], t0, t1, t2)
   TEST_3R("modu", mem[10], mem[9], t1, t2, t0)
   TEST_3R("modu", mem[10], mem[10], t2, t0, t1)
   TEST_3R("modu", mem[10], mem[11], t0, t1, t2)
   TEST_3R("modu", mem[11], mem[1], t0, t1, t2)
   TEST_3R("modu", mem[11], mem[2], t1, t2, t0)
   TEST_3R("modu", mem[11], mem[3], t2, t0, t1)
   TEST_3R("modu", mem[11], mem[4], t0, t1, t2)
   TEST_3R("modu", mem[11], mem[5], t1, t2, t0)
   TEST_3R("modu", mem[11], mem[6], t2, t0, t1)
   TEST_3R("modu", mem[11], mem[7], t0, t1, t2)
   TEST_3R("modu", mem[11], mem[8], t1, t2, t0)
   TEST_3R("modu", mem[11], mem[9], t2, t0, t1)
   TEST_3R("modu", mem[11], mem[10], t0, t1, t2)
   TEST_3R("modu", mem[11], mem[11], t1, t2, t0)

   printf("\nmul\n");
   TEST_3R("mul", mem[0], mem[0], t0, t1, t2)
   TEST_3R("mul", mem[0], mem[1], t1, t2, t0)
   TEST_3R("mul", mem[0], mem[2], t2, t0, t1)
   TEST_3R("mul", mem[0], mem[3], t0, t1, t2)
   TEST_3R("mul", mem[0], mem[4], t1, t2, t0)
   TEST_3R("mul", mem[0], mem[5], t2, t0, t1)
   TEST_3R("mul", mem[0], mem[6], t0, t1, t2)
   TEST_3R("mul", mem[0], mem[7], t1, t2, t0)
   TEST_3R("mul", mem[0], mem[8], t2, t0, t1)
   TEST_3R("mul", mem[0], mem[9], t0, t1, t2)
   TEST_3R("mul", mem[0], mem[10], t1, t2, t0)
   TEST_3R("mul", mem[0], mem[11], t2, t0, t1)
   TEST_3R("mul", mem[1], mem[0], t1, t2, t0)
   TEST_3R("mul", mem[1], mem[1], t2, t0, t1)
   TEST_3R("mul", mem[1], mem[2], t0, t1, t2)
   TEST_3R("mul", mem[1], mem[3], t1, t2, t0)
   TEST_3R("mul", mem[1], mem[4], t2, t0, t1)
   TEST_3R("mul", mem[1], mem[5], t0, t1, t2)
   TEST_3R("mul", mem[1], mem[6], t1, t2, t0)
   TEST_3R("mul", mem[1], mem[7], t2, t0, t1)
   TEST_3R("mul", mem[1], mem[8], t0, t1, t2)
   TEST_3R("mul", mem[1], mem[9], t1, t2, t0)
   TEST_3R("mul", mem[1], mem[10], t2, t0, t1)
   TEST_3R("mul", mem[1], mem[11], t0, t1, t2)
   TEST_3R("mul", mem[2], mem[0], t2, t0, t1)
   TEST_3R("mul", mem[2], mem[1], t0, t1, t2)
   TEST_3R("mul", mem[2], mem[2], t1, t2, t0)
   TEST_3R("mul", mem[2], mem[3], t2, t0, t1)
   TEST_3R("mul", mem[2], mem[4], t0, t1, t2)
   TEST_3R("mul", mem[2], mem[5], t1, t2, t0)
   TEST_3R("mul", mem[2], mem[6], t2, t0, t1)
   TEST_3R("mul", mem[2], mem[7], t0, t1, t2)
   TEST_3R("mul", mem[2], mem[8], t1, t2, t0)
   TEST_3R("mul", mem[2], mem[9], t2, t0, t1)
   TEST_3R("mul", mem[2], mem[10], t0, t1, t2)
   TEST_3R("mul", mem[2], mem[11], t1, t2, t0)
   TEST_3R("mul", mem[3], mem[0], t0, t1, t2)
   TEST_3R("mul", mem[3], mem[1], t1, t2, t0)
   TEST_3R("mul", mem[3], mem[2], t2, t0, t1)
   TEST_3R("mul", mem[3], mem[3], t0, t1, t2)
   TEST_3R("mul", mem[3], mem[4], t1, t2, t0)
   TEST_3R("mul", mem[3], mem[5], t2, t0, t1)
   TEST_3R("mul", mem[3], mem[6], t0, t1, t2)
   TEST_3R("mul", mem[3], mem[7], t1, t2, t0)
   TEST_3R("mul", mem[3], mem[8], t2, t0, t1)
   TEST_3R("mul", mem[3], mem[9], t0, t1, t2)
   TEST_3R("mul", mem[3], mem[10], t1, t2, t0)
   TEST_3R("mul", mem[3], mem[11], t2, t0, t1)
   TEST_3R("mul", mem[4], mem[0], t1, t2, t0)
   TEST_3R("mul", mem[4], mem[1], t2, t0, t1)
   TEST_3R("mul", mem[4], mem[2], t0, t1, t2)
   TEST_3R("mul", mem[4], mem[3], t1, t2, t0)
   TEST_3R("mul", mem[4], mem[4], t2, t0, t1)
   TEST_3R("mul", mem[4], mem[5], t0, t1, t2)
   TEST_3R("mul", mem[4], mem[6], t1, t2, t0)
   TEST_3R("mul", mem[4], mem[7], t2, t0, t1)
   TEST_3R("mul", mem[4], mem[8], t0, t1, t2)
   TEST_3R("mul", mem[4], mem[9], t1, t2, t0)
   TEST_3R("mul", mem[4], mem[10], t2, t0, t1)
   TEST_3R("mul", mem[4], mem[11], t0, t1, t2)
   TEST_3R("mul", mem[5], mem[0], t2, t0, t1)
   TEST_3R("mul", mem[5], mem[1], t0, t1, t2)
   TEST_3R("mul", mem[5], mem[2], t1, t2, t0)
   TEST_3R("mul", mem[5], mem[3], t2, t0, t1)
   TEST_3R("mul", mem[5], mem[4], t0, t1, t2)
   TEST_3R("mul", mem[5], mem[5], t1, t2, t0)
   TEST_3R("mul", mem[5], mem[6], t2, t0, t1)
   TEST_3R("mul", mem[5], mem[7], t0, t1, t2)
   TEST_3R("mul", mem[5], mem[8], t1, t2, t0)
   TEST_3R("mul", mem[5], mem[9], t2, t0, t1)
   TEST_3R("mul", mem[5], mem[10], t0, t1, t2)
   TEST_3R("mul", mem[5], mem[11], t1, t2, t0)
   TEST_3R("mul", mem[6], mem[0], t0, t1, t2)
   TEST_3R("mul", mem[6], mem[1], t1, t2, t0)
   TEST_3R("mul", mem[6], mem[2], t2, t0, t1)
   TEST_3R("mul", mem[6], mem[3], t0, t1, t2)
   TEST_3R("mul", mem[6], mem[4], t1, t2, t0)
   TEST_3R("mul", mem[6], mem[5], t2, t0, t1)
   TEST_3R("mul", mem[6], mem[6], t0, t1, t2)
   TEST_3R("mul", mem[6], mem[7], t1, t2, t0)
   TEST_3R("mul", mem[6], mem[8], t2, t0, t1)
   TEST_3R("mul", mem[6], mem[9], t0, t1, t2)
   TEST_3R("mul", mem[6], mem[10], t1, t2, t0)
   TEST_3R("mul", mem[6], mem[11], t2, t0, t1)
   TEST_3R("mul", mem[7], mem[0], t1, t2, t0)
   TEST_3R("mul", mem[7], mem[1], t2, t0, t1)
   TEST_3R("mul", mem[7], mem[2], t0, t1, t2)
   TEST_3R("mul", mem[7], mem[3], t1, t2, t0)
   TEST_3R("mul", mem[7], mem[4], t2, t0, t1)
   TEST_3R("mul", mem[7], mem[5], t0, t1, t2)
   TEST_3R("mul", mem[7], mem[6], t1, t2, t0)
   TEST_3R("mul", mem[7], mem[7], t2, t0, t1)
   TEST_3R("mul", mem[7], mem[8], t0, t1, t2)
   TEST_3R("mul", mem[7], mem[9], t1, t2, t0)
   TEST_3R("mul", mem[7], mem[10], t2, t0, t1)
   TEST_3R("mul", mem[7], mem[11], t0, t1, t2)
   TEST_3R("mul", mem[8], mem[0], t2, t0, t1)
   TEST_3R("mul", mem[8], mem[1], t0, t1, t2)
   TEST_3R("mul", mem[8], mem[2], t1, t2, t0)
   TEST_3R("mul", mem[8], mem[3], t2, t0, t1)
   TEST_3R("mul", mem[8], mem[4], t0, t1, t2)
   TEST_3R("mul", mem[8], mem[5], t1, t2, t0)
   TEST_3R("mul", mem[8], mem[6], t2, t0, t1)
   TEST_3R("mul", mem[8], mem[7], t0, t1, t2)
   TEST_3R("mul", mem[8], mem[8], t1, t2, t0)
   TEST_3R("mul", mem[8], mem[9], t2, t0, t1)
   TEST_3R("mul", mem[8], mem[10], t0, t1, t2)
   TEST_3R("mul", mem[8], mem[11], t1, t2, t0)
   TEST_3R("mul", mem[9], mem[0], t0, t1, t2)
   TEST_3R("mul", mem[9], mem[1], t1, t2, t0)
   TEST_3R("mul", mem[9], mem[2], t2, t0, t1)
   TEST_3R("mul", mem[9], mem[3], t0, t1, t2)
   TEST_3R("mul", mem[9], mem[4], t1, t2, t0)
   TEST_3R("mul", mem[9], mem[5], t2, t0, t1)
   TEST_3R("mul", mem[9], mem[6], t0, t1, t2)
   TEST_3R("mul", mem[9], mem[7], t1, t2, t0)
   TEST_3R("mul", mem[9], mem[8], t2, t0, t1)
   TEST_3R("mul", mem[9], mem[9], t0, t1, t2)
   TEST_3R("mul", mem[9], mem[10], t1, t2, t0)
   TEST_3R("mul", mem[9], mem[11], t2, t0, t1)
   TEST_3R("mul", mem[10], mem[0], t1, t2, t0)
   TEST_3R("mul", mem[10], mem[1], t2, t0, t1)
   TEST_3R("mul", mem[10], mem[2], t0, t1, t2)
   TEST_3R("mul", mem[10], mem[3], t1, t2, t0)
   TEST_3R("mul", mem[10], mem[4], t2, t0, t1)
   TEST_3R("mul", mem[10], mem[5], t0, t1, t2)
   TEST_3R("mul", mem[10], mem[6], t1, t2, t0)
   TEST_3R("mul", mem[10], mem[7], t2, t0, t1)
   TEST_3R("mul", mem[10], mem[8], t0, t1, t2)
   TEST_3R("mul", mem[10], mem[9], t1, t2, t0)
   TEST_3R("mul", mem[10], mem[10], t2, t0, t1)
   TEST_3R("mul", mem[10], mem[11], t0, t1, t2)
   TEST_3R("mul", mem[11], mem[0], t2, t0, t1)
   TEST_3R("mul", mem[11], mem[1], t0, t1, t2)
   TEST_3R("mul", mem[11], mem[2], t1, t2, t0)
   TEST_3R("mul", mem[11], mem[3], t2, t0, t1)
   TEST_3R("mul", mem[11], mem[4], t0, t1, t2)
   TEST_3R("mul", mem[11], mem[5], t1, t2, t0)
   TEST_3R("mul", mem[11], mem[6], t2, t0, t1)
   TEST_3R("mul", mem[11], mem[7], t0, t1, t2)
   TEST_3R("mul", mem[11], mem[8], t1, t2, t0)
   TEST_3R("mul", mem[11], mem[9], t2, t0, t1)
   TEST_3R("mul", mem[11], mem[10], t0, t1, t2)
   TEST_3R("mul", mem[11], mem[11], t1, t2, t0)

   printf("\nmuh\n");
   TEST_3R("muh", mem[0], mem[0], t0, t1, t2)
   TEST_3R("muh", mem[0], mem[1], t1, t2, t0)
   TEST_3R("muh", mem[0], mem[2], t2, t0, t1)
   TEST_3R("muh", mem[0], mem[3], t0, t1, t2)
   TEST_3R("muh", mem[0], mem[4], t1, t2, t0)
   TEST_3R("muh", mem[0], mem[5], t2, t0, t1)
   TEST_3R("muh", mem[0], mem[6], t0, t1, t2)
   TEST_3R("muh", mem[0], mem[7], t1, t2, t0)
   TEST_3R("muh", mem[0], mem[8], t2, t0, t1)
   TEST_3R("muh", mem[0], mem[9], t0, t1, t2)
   TEST_3R("muh", mem[0], mem[10], t1, t2, t0)
   TEST_3R("muh", mem[0], mem[11], t2, t0, t1)
   TEST_3R("muh", mem[1], mem[0], t1, t2, t0)
   TEST_3R("muh", mem[1], mem[1], t2, t0, t1)
   TEST_3R("muh", mem[1], mem[2], t0, t1, t2)
   TEST_3R("muh", mem[1], mem[3], t1, t2, t0)
   TEST_3R("muh", mem[1], mem[4], t2, t0, t1)
   TEST_3R("muh", mem[1], mem[5], t0, t1, t2)
   TEST_3R("muh", mem[1], mem[6], t1, t2, t0)
   TEST_3R("muh", mem[1], mem[7], t2, t0, t1)
   TEST_3R("muh", mem[1], mem[8], t0, t1, t2)
   TEST_3R("muh", mem[1], mem[9], t1, t2, t0)
   TEST_3R("muh", mem[1], mem[10], t2, t0, t1)
   TEST_3R("muh", mem[1], mem[11], t0, t1, t2)
   TEST_3R("muh", mem[2], mem[0], t2, t0, t1)
   TEST_3R("muh", mem[2], mem[1], t0, t1, t2)
   TEST_3R("muh", mem[2], mem[2], t1, t2, t0)
   TEST_3R("muh", mem[2], mem[3], t2, t0, t1)
   TEST_3R("muh", mem[2], mem[4], t0, t1, t2)
   TEST_3R("muh", mem[2], mem[5], t1, t2, t0)
   TEST_3R("muh", mem[2], mem[6], t2, t0, t1)
   TEST_3R("muh", mem[2], mem[7], t0, t1, t2)
   TEST_3R("muh", mem[2], mem[8], t1, t2, t0)
   TEST_3R("muh", mem[2], mem[9], t2, t0, t1)
   TEST_3R("muh", mem[2], mem[10], t0, t1, t2)
   TEST_3R("muh", mem[2], mem[11], t1, t2, t0)
   TEST_3R("muh", mem[3], mem[0], t0, t1, t2)
   TEST_3R("muh", mem[3], mem[1], t1, t2, t0)
   TEST_3R("muh", mem[3], mem[2], t2, t0, t1)
   TEST_3R("muh", mem[3], mem[3], t0, t1, t2)
   TEST_3R("muh", mem[3], mem[4], t1, t2, t0)
   TEST_3R("muh", mem[3], mem[5], t2, t0, t1)
   TEST_3R("muh", mem[3], mem[6], t0, t1, t2)
   TEST_3R("muh", mem[3], mem[7], t1, t2, t0)
   TEST_3R("muh", mem[3], mem[8], t2, t0, t1)
   TEST_3R("muh", mem[3], mem[9], t0, t1, t2)
   TEST_3R("muh", mem[3], mem[10], t1, t2, t0)
   TEST_3R("muh", mem[3], mem[11], t2, t0, t1)
   TEST_3R("muh", mem[4], mem[0], t1, t2, t0)
   TEST_3R("muh", mem[4], mem[1], t2, t0, t1)
   TEST_3R("muh", mem[4], mem[2], t0, t1, t2)
   TEST_3R("muh", mem[4], mem[3], t1, t2, t0)
   TEST_3R("muh", mem[4], mem[4], t2, t0, t1)
   TEST_3R("muh", mem[4], mem[5], t0, t1, t2)
   TEST_3R("muh", mem[4], mem[6], t1, t2, t0)
   TEST_3R("muh", mem[4], mem[7], t2, t0, t1)
   TEST_3R("muh", mem[4], mem[8], t0, t1, t2)
   TEST_3R("muh", mem[4], mem[9], t1, t2, t0)
   TEST_3R("muh", mem[4], mem[10], t2, t0, t1)
   TEST_3R("muh", mem[4], mem[11], t0, t1, t2)
   TEST_3R("muh", mem[5], mem[0], t2, t0, t1)
   TEST_3R("muh", mem[5], mem[1], t0, t1, t2)
   TEST_3R("muh", mem[5], mem[2], t1, t2, t0)
   TEST_3R("muh", mem[5], mem[3], t2, t0, t1)
   TEST_3R("muh", mem[5], mem[4], t0, t1, t2)
   TEST_3R("muh", mem[5], mem[5], t1, t2, t0)
   TEST_3R("muh", mem[5], mem[6], t2, t0, t1)
   TEST_3R("muh", mem[5], mem[7], t0, t1, t2)
   TEST_3R("muh", mem[5], mem[8], t1, t2, t0)
   TEST_3R("muh", mem[5], mem[9], t2, t0, t1)
   TEST_3R("muh", mem[5], mem[10], t0, t1, t2)
   TEST_3R("muh", mem[5], mem[11], t1, t2, t0)
   TEST_3R("muh", mem[6], mem[0], t0, t1, t2)
   TEST_3R("muh", mem[6], mem[1], t1, t2, t0)
   TEST_3R("muh", mem[6], mem[2], t2, t0, t1)
   TEST_3R("muh", mem[6], mem[3], t0, t1, t2)
   TEST_3R("muh", mem[6], mem[4], t1, t2, t0)
   TEST_3R("muh", mem[6], mem[5], t2, t0, t1)
   TEST_3R("muh", mem[6], mem[6], t0, t1, t2)
   TEST_3R("muh", mem[6], mem[7], t1, t2, t0)
   TEST_3R("muh", mem[6], mem[8], t2, t0, t1)
   TEST_3R("muh", mem[6], mem[9], t0, t1, t2)
   TEST_3R("muh", mem[6], mem[10], t1, t2, t0)
   TEST_3R("muh", mem[6], mem[11], t2, t0, t1)
   TEST_3R("muh", mem[7], mem[0], t1, t2, t0)
   TEST_3R("muh", mem[7], mem[1], t2, t0, t1)
   TEST_3R("muh", mem[7], mem[2], t0, t1, t2)
   TEST_3R("muh", mem[7], mem[3], t1, t2, t0)
   TEST_3R("muh", mem[7], mem[4], t2, t0, t1)
   TEST_3R("muh", mem[7], mem[5], t0, t1, t2)
   TEST_3R("muh", mem[7], mem[6], t1, t2, t0)
   TEST_3R("muh", mem[7], mem[7], t2, t0, t1)
   TEST_3R("muh", mem[7], mem[8], t0, t1, t2)
   TEST_3R("muh", mem[7], mem[9], t1, t2, t0)
   TEST_3R("muh", mem[7], mem[10], t2, t0, t1)
   TEST_3R("muh", mem[7], mem[11], t0, t1, t2)
   TEST_3R("muh", mem[8], mem[0], t2, t0, t1)
   TEST_3R("muh", mem[8], mem[1], t0, t1, t2)
   TEST_3R("muh", mem[8], mem[2], t1, t2, t0)
   TEST_3R("muh", mem[8], mem[3], t2, t0, t1)
   TEST_3R("muh", mem[8], mem[4], t0, t1, t2)
   TEST_3R("muh", mem[8], mem[5], t1, t2, t0)
   TEST_3R("muh", mem[8], mem[6], t2, t0, t1)
   TEST_3R("muh", mem[8], mem[7], t0, t1, t2)
   TEST_3R("muh", mem[8], mem[8], t1, t2, t0)
   TEST_3R("muh", mem[8], mem[9], t2, t0, t1)
   TEST_3R("muh", mem[8], mem[10], t0, t1, t2)
   TEST_3R("muh", mem[8], mem[11], t1, t2, t0)
   TEST_3R("muh", mem[9], mem[0], t0, t1, t2)
   TEST_3R("muh", mem[9], mem[1], t1, t2, t0)
   TEST_3R("muh", mem[9], mem[2], t2, t0, t1)
   TEST_3R("muh", mem[9], mem[3], t0, t1, t2)
   TEST_3R("muh", mem[9], mem[4], t1, t2, t0)
   TEST_3R("muh", mem[9], mem[5], t2, t0, t1)
   TEST_3R("muh", mem[9], mem[6], t0, t1, t2)
   TEST_3R("muh", mem[9], mem[7], t1, t2, t0)
   TEST_3R("muh", mem[9], mem[8], t2, t0, t1)
   TEST_3R("muh", mem[9], mem[9], t0, t1, t2)
   TEST_3R("muh", mem[9], mem[10], t1, t2, t0)
   TEST_3R("muh", mem[9], mem[11], t2, t0, t1)
   TEST_3R("muh", mem[10], mem[0], t1, t2, t0)
   TEST_3R("muh", mem[10], mem[1], t2, t0, t1)
   TEST_3R("muh", mem[10], mem[2], t0, t1, t2)
   TEST_3R("muh", mem[10], mem[3], t1, t2, t0)
   TEST_3R("muh", mem[10], mem[4], t2, t0, t1)
   TEST_3R("muh", mem[10], mem[5], t0, t1, t2)
   TEST_3R("muh", mem[10], mem[6], t1, t2, t0)
   TEST_3R("muh", mem[10], mem[7], t2, t0, t1)
   TEST_3R("muh", mem[10], mem[8], t0, t1, t2)
   TEST_3R("muh", mem[10], mem[9], t1, t2, t0)
   TEST_3R("muh", mem[10], mem[10], t2, t0, t1)
   TEST_3R("muh", mem[10], mem[11], t0, t1, t2)
   TEST_3R("muh", mem[11], mem[0], t2, t0, t1)
   TEST_3R("muh", mem[11], mem[1], t0, t1, t2)
   TEST_3R("muh", mem[11], mem[2], t1, t2, t0)
   TEST_3R("muh", mem[11], mem[3], t2, t0, t1)
   TEST_3R("muh", mem[11], mem[4], t0, t1, t2)
   TEST_3R("muh", mem[11], mem[5], t1, t2, t0)
   TEST_3R("muh", mem[11], mem[6], t2, t0, t1)
   TEST_3R("muh", mem[11], mem[7], t0, t1, t2)
   TEST_3R("muh", mem[11], mem[8], t1, t2, t0)
   TEST_3R("muh", mem[11], mem[9], t2, t0, t1)
   TEST_3R("muh", mem[11], mem[10], t0, t1, t2)
   TEST_3R("muh", mem[11], mem[11], t1, t2, t0)

   printf("\nmulu\n");
   TEST_3R("mulu", mem[0], mem[0], t0, t1, t2)
   TEST_3R("mulu", mem[0], mem[1], t1, t2, t0)
   TEST_3R("mulu", mem[0], mem[2], t2, t0, t1)
   TEST_3R("mulu", mem[0], mem[3], t0, t1, t2)
   TEST_3R("mulu", mem[0], mem[4], t1, t2, t0)
   TEST_3R("mulu", mem[0], mem[5], t2, t0, t1)
   TEST_3R("mulu", mem[0], mem[6], t0, t1, t2)
   TEST_3R("mulu", mem[0], mem[7], t1, t2, t0)
   TEST_3R("mulu", mem[0], mem[8], t2, t0, t1)
   TEST_3R("mulu", mem[0], mem[9], t0, t1, t2)
   TEST_3R("mulu", mem[0], mem[10], t1, t2, t0)
   TEST_3R("mulu", mem[0], mem[11], t2, t0, t1)
   TEST_3R("mulu", mem[1], mem[0], t1, t2, t0)
   TEST_3R("mulu", mem[1], mem[1], t2, t0, t1)
   TEST_3R("mulu", mem[1], mem[2], t0, t1, t2)
   TEST_3R("mulu", mem[1], mem[3], t1, t2, t0)
   TEST_3R("mulu", mem[1], mem[4], t2, t0, t1)
   TEST_3R("mulu", mem[1], mem[5], t0, t1, t2)
   TEST_3R("mulu", mem[1], mem[6], t1, t2, t0)
   TEST_3R("mulu", mem[1], mem[7], t2, t0, t1)
   TEST_3R("mulu", mem[1], mem[8], t0, t1, t2)
   TEST_3R("mulu", mem[1], mem[9], t1, t2, t0)
   TEST_3R("mulu", mem[1], mem[10], t2, t0, t1)
   TEST_3R("mulu", mem[1], mem[11], t0, t1, t2)
   TEST_3R("mulu", mem[2], mem[0], t2, t0, t1)
   TEST_3R("mulu", mem[2], mem[1], t0, t1, t2)
   TEST_3R("mulu", mem[2], mem[2], t1, t2, t0)
   TEST_3R("mulu", mem[2], mem[3], t2, t0, t1)
   TEST_3R("mulu", mem[2], mem[4], t0, t1, t2)
   TEST_3R("mulu", mem[2], mem[5], t1, t2, t0)
   TEST_3R("mulu", mem[2], mem[6], t2, t0, t1)
   TEST_3R("mulu", mem[2], mem[7], t0, t1, t2)
   TEST_3R("mulu", mem[2], mem[8], t1, t2, t0)
   TEST_3R("mulu", mem[2], mem[9], t2, t0, t1)
   TEST_3R("mulu", mem[2], mem[10], t0, t1, t2)
   TEST_3R("mulu", mem[2], mem[11], t1, t2, t0)
   TEST_3R("mulu", mem[3], mem[0], t0, t1, t2)
   TEST_3R("mulu", mem[3], mem[1], t1, t2, t0)
   TEST_3R("mulu", mem[3], mem[2], t2, t0, t1)
   TEST_3R("mulu", mem[3], mem[3], t0, t1, t2)
   TEST_3R("mulu", mem[3], mem[4], t1, t2, t0)
   TEST_3R("mulu", mem[3], mem[5], t2, t0, t1)
   TEST_3R("mulu", mem[3], mem[6], t0, t1, t2)
   TEST_3R("mulu", mem[3], mem[7], t1, t2, t0)
   TEST_3R("mulu", mem[3], mem[8], t2, t0, t1)
   TEST_3R("mulu", mem[3], mem[9], t0, t1, t2)
   TEST_3R("mulu", mem[3], mem[10], t1, t2, t0)
   TEST_3R("mulu", mem[3], mem[11], t2, t0, t1)
   TEST_3R("mulu", mem[4], mem[0], t1, t2, t0)
   TEST_3R("mulu", mem[4], mem[1], t2, t0, t1)
   TEST_3R("mulu", mem[4], mem[2], t0, t1, t2)
   TEST_3R("mulu", mem[4], mem[3], t1, t2, t0)
   TEST_3R("mulu", mem[4], mem[4], t2, t0, t1)
   TEST_3R("mulu", mem[4], mem[5], t0, t1, t2)
   TEST_3R("mulu", mem[4], mem[6], t1, t2, t0)
   TEST_3R("mulu", mem[4], mem[7], t2, t0, t1)
   TEST_3R("mulu", mem[4], mem[8], t0, t1, t2)
   TEST_3R("mulu", mem[4], mem[9], t1, t2, t0)
   TEST_3R("mulu", mem[4], mem[10], t2, t0, t1)
   TEST_3R("mulu", mem[4], mem[11], t0, t1, t2)
   TEST_3R("mulu", mem[5], mem[0], t2, t0, t1)
   TEST_3R("mulu", mem[5], mem[1], t0, t1, t2)
   TEST_3R("mulu", mem[5], mem[2], t1, t2, t0)
   TEST_3R("mulu", mem[5], mem[3], t2, t0, t1)
   TEST_3R("mulu", mem[5], mem[4], t0, t1, t2)
   TEST_3R("mulu", mem[5], mem[5], t1, t2, t0)
   TEST_3R("mulu", mem[5], mem[6], t2, t0, t1)
   TEST_3R("mulu", mem[5], mem[7], t0, t1, t2)
   TEST_3R("mulu", mem[5], mem[8], t1, t2, t0)
   TEST_3R("mulu", mem[5], mem[9], t2, t0, t1)
   TEST_3R("mulu", mem[5], mem[10], t0, t1, t2)
   TEST_3R("mulu", mem[5], mem[11], t1, t2, t0)
   TEST_3R("mulu", mem[6], mem[0], t0, t1, t2)
   TEST_3R("mulu", mem[6], mem[1], t1, t2, t0)
   TEST_3R("mulu", mem[6], mem[2], t2, t0, t1)
   TEST_3R("mulu", mem[6], mem[3], t0, t1, t2)
   TEST_3R("mulu", mem[6], mem[4], t1, t2, t0)
   TEST_3R("mulu", mem[6], mem[5], t2, t0, t1)
   TEST_3R("mulu", mem[6], mem[6], t0, t1, t2)
   TEST_3R("mulu", mem[6], mem[7], t1, t2, t0)
   TEST_3R("mulu", mem[6], mem[8], t2, t0, t1)
   TEST_3R("mulu", mem[6], mem[9], t0, t1, t2)
   TEST_3R("mulu", mem[6], mem[10], t1, t2, t0)
   TEST_3R("mulu", mem[6], mem[11], t2, t0, t1)
   TEST_3R("mulu", mem[7], mem[0], t1, t2, t0)
   TEST_3R("mulu", mem[7], mem[1], t2, t0, t1)
   TEST_3R("mulu", mem[7], mem[2], t0, t1, t2)
   TEST_3R("mulu", mem[7], mem[3], t1, t2, t0)
   TEST_3R("mulu", mem[7], mem[4], t2, t0, t1)
   TEST_3R("mulu", mem[7], mem[5], t0, t1, t2)
   TEST_3R("mulu", mem[7], mem[6], t1, t2, t0)
   TEST_3R("mulu", mem[7], mem[7], t2, t0, t1)
   TEST_3R("mulu", mem[7], mem[8], t0, t1, t2)
   TEST_3R("mulu", mem[7], mem[9], t1, t2, t0)
   TEST_3R("mulu", mem[7], mem[10], t2, t0, t1)
   TEST_3R("mulu", mem[7], mem[11], t0, t1, t2)
   TEST_3R("mulu", mem[8], mem[0], t2, t0, t1)
   TEST_3R("mulu", mem[8], mem[1], t0, t1, t2)
   TEST_3R("mulu", mem[8], mem[2], t1, t2, t0)
   TEST_3R("mulu", mem[8], mem[3], t2, t0, t1)
   TEST_3R("mulu", mem[8], mem[4], t0, t1, t2)
   TEST_3R("mulu", mem[8], mem[5], t1, t2, t0)
   TEST_3R("mulu", mem[8], mem[6], t2, t0, t1)
   TEST_3R("mulu", mem[8], mem[7], t0, t1, t2)
   TEST_3R("mulu", mem[8], mem[8], t1, t2, t0)
   TEST_3R("mulu", mem[8], mem[9], t2, t0, t1)
   TEST_3R("mulu", mem[8], mem[10], t0, t1, t2)
   TEST_3R("mulu", mem[8], mem[11], t1, t2, t0)
   TEST_3R("mulu", mem[9], mem[0], t0, t1, t2)
   TEST_3R("mulu", mem[9], mem[1], t1, t2, t0)
   TEST_3R("mulu", mem[9], mem[2], t2, t0, t1)
   TEST_3R("mulu", mem[9], mem[3], t0, t1, t2)
   TEST_3R("mulu", mem[9], mem[4], t1, t2, t0)
   TEST_3R("mulu", mem[9], mem[5], t2, t0, t1)
   TEST_3R("mulu", mem[9], mem[6], t0, t1, t2)
   TEST_3R("mulu", mem[9], mem[7], t1, t2, t0)
   TEST_3R("mulu", mem[9], mem[8], t2, t0, t1)
   TEST_3R("mulu", mem[9], mem[9], t0, t1, t2)
   TEST_3R("mulu", mem[9], mem[10], t1, t2, t0)
   TEST_3R("mulu", mem[9], mem[11], t2, t0, t1)
   TEST_3R("mulu", mem[10], mem[0], t1, t2, t0)
   TEST_3R("mulu", mem[10], mem[1], t2, t0, t1)
   TEST_3R("mulu", mem[10], mem[2], t0, t1, t2)
   TEST_3R("mulu", mem[10], mem[3], t1, t2, t0)
   TEST_3R("mulu", mem[10], mem[4], t2, t0, t1)
   TEST_3R("mulu", mem[10], mem[5], t0, t1, t2)
   TEST_3R("mulu", mem[10], mem[6], t1, t2, t0)
   TEST_3R("mulu", mem[10], mem[7], t2, t0, t1)
   TEST_3R("mulu", mem[10], mem[8], t0, t1, t2)
   TEST_3R("mulu", mem[10], mem[9], t1, t2, t0)
   TEST_3R("mulu", mem[10], mem[10], t2, t0, t1)
   TEST_3R("mulu", mem[10], mem[11], t0, t1, t2)
   TEST_3R("mulu", mem[11], mem[0], t2, t0, t1)
   TEST_3R("mulu", mem[11], mem[1], t0, t1, t2)
   TEST_3R("mulu", mem[11], mem[2], t1, t2, t0)
   TEST_3R("mulu", mem[11], mem[3], t2, t0, t1)
   TEST_3R("mulu", mem[11], mem[4], t0, t1, t2)
   TEST_3R("mulu", mem[11], mem[5], t1, t2, t0)
   TEST_3R("mulu", mem[11], mem[6], t2, t0, t1)
   TEST_3R("mulu", mem[11], mem[7], t0, t1, t2)
   TEST_3R("mulu", mem[11], mem[8], t1, t2, t0)
   TEST_3R("mulu", mem[11], mem[9], t2, t0, t1)
   TEST_3R("mulu", mem[11], mem[10], t0, t1, t2)
   TEST_3R("mulu", mem[11], mem[11], t1, t2, t0)

   printf("\nmuhu\n");
   TEST_3R("muhu", mem[0], mem[0], t0, t1, t2)
   TEST_3R("muhu", mem[0], mem[1], t1, t2, t0)
   TEST_3R("muhu", mem[0], mem[2], t2, t0, t1)
   TEST_3R("muhu", mem[0], mem[3], t0, t1, t2)
   TEST_3R("muhu", mem[0], mem[4], t1, t2, t0)
   TEST_3R("muhu", mem[0], mem[5], t2, t0, t1)
   TEST_3R("muhu", mem[0], mem[6], t0, t1, t2)
   TEST_3R("muhu", mem[0], mem[7], t1, t2, t0)
   TEST_3R("muhu", mem[0], mem[8], t2, t0, t1)
   TEST_3R("muhu", mem[0], mem[9], t0, t1, t2)
   TEST_3R("muhu", mem[0], mem[10], t1, t2, t0)
   TEST_3R("muhu", mem[0], mem[11], t2, t0, t1)
   TEST_3R("muhu", mem[1], mem[0], t1, t2, t0)
   TEST_3R("muhu", mem[1], mem[1], t2, t0, t1)
   TEST_3R("muhu", mem[1], mem[2], t0, t1, t2)
   TEST_3R("muhu", mem[1], mem[3], t1, t2, t0)
   TEST_3R("muhu", mem[1], mem[4], t2, t0, t1)
   TEST_3R("muhu", mem[1], mem[5], t0, t1, t2)
   TEST_3R("muhu", mem[1], mem[6], t1, t2, t0)
   TEST_3R("muhu", mem[1], mem[7], t2, t0, t1)
   TEST_3R("muhu", mem[1], mem[8], t0, t1, t2)
   TEST_3R("muhu", mem[1], mem[9], t1, t2, t0)
   TEST_3R("muhu", mem[1], mem[10], t2, t0, t1)
   TEST_3R("muhu", mem[1], mem[11], t0, t1, t2)
   TEST_3R("muhu", mem[2], mem[0], t2, t0, t1)
   TEST_3R("muhu", mem[2], mem[1], t0, t1, t2)
   TEST_3R("muhu", mem[2], mem[2], t1, t2, t0)
   TEST_3R("muhu", mem[2], mem[3], t2, t0, t1)
   TEST_3R("muhu", mem[2], mem[4], t0, t1, t2)
   TEST_3R("muhu", mem[2], mem[5], t1, t2, t0)
   TEST_3R("muhu", mem[2], mem[6], t2, t0, t1)
   TEST_3R("muhu", mem[2], mem[7], t0, t1, t2)
   TEST_3R("muhu", mem[2], mem[8], t1, t2, t0)
   TEST_3R("muhu", mem[2], mem[9], t2, t0, t1)
   TEST_3R("muhu", mem[2], mem[10], t0, t1, t2)
   TEST_3R("muhu", mem[2], mem[11], t1, t2, t0)
   TEST_3R("muhu", mem[3], mem[0], t0, t1, t2)
   TEST_3R("muhu", mem[3], mem[1], t1, t2, t0)
   TEST_3R("muhu", mem[3], mem[2], t2, t0, t1)
   TEST_3R("muhu", mem[3], mem[3], t0, t1, t2)
   TEST_3R("muhu", mem[3], mem[4], t1, t2, t0)
   TEST_3R("muhu", mem[3], mem[5], t2, t0, t1)
   TEST_3R("muhu", mem[3], mem[6], t0, t1, t2)
   TEST_3R("muhu", mem[3], mem[7], t1, t2, t0)
   TEST_3R("muhu", mem[3], mem[8], t2, t0, t1)
   TEST_3R("muhu", mem[3], mem[9], t0, t1, t2)
   TEST_3R("muhu", mem[3], mem[10], t1, t2, t0)
   TEST_3R("muhu", mem[3], mem[11], t2, t0, t1)
   TEST_3R("muhu", mem[4], mem[0], t1, t2, t0)
   TEST_3R("muhu", mem[4], mem[1], t2, t0, t1)
   TEST_3R("muhu", mem[4], mem[2], t0, t1, t2)
   TEST_3R("muhu", mem[4], mem[3], t1, t2, t0)
   TEST_3R("muhu", mem[4], mem[4], t2, t0, t1)
   TEST_3R("muhu", mem[4], mem[5], t0, t1, t2)
   TEST_3R("muhu", mem[4], mem[6], t1, t2, t0)
   TEST_3R("muhu", mem[4], mem[7], t2, t0, t1)
   TEST_3R("muhu", mem[4], mem[8], t0, t1, t2)
   TEST_3R("muhu", mem[4], mem[9], t1, t2, t0)
   TEST_3R("muhu", mem[4], mem[10], t2, t0, t1)
   TEST_3R("muhu", mem[4], mem[11], t0, t1, t2)
   TEST_3R("muhu", mem[5], mem[0], t2, t0, t1)
   TEST_3R("muhu", mem[5], mem[1], t0, t1, t2)
   TEST_3R("muhu", mem[5], mem[2], t1, t2, t0)
   TEST_3R("muhu", mem[5], mem[3], t2, t0, t1)
   TEST_3R("muhu", mem[5], mem[4], t0, t1, t2)
   TEST_3R("muhu", mem[5], mem[5], t1, t2, t0)
   TEST_3R("muhu", mem[5], mem[6], t2, t0, t1)
   TEST_3R("muhu", mem[5], mem[7], t0, t1, t2)
   TEST_3R("muhu", mem[5], mem[8], t1, t2, t0)
   TEST_3R("muhu", mem[5], mem[9], t2, t0, t1)
   TEST_3R("muhu", mem[5], mem[10], t0, t1, t2)
   TEST_3R("muhu", mem[5], mem[11], t1, t2, t0)
   TEST_3R("muhu", mem[6], mem[0], t0, t1, t2)
   TEST_3R("muhu", mem[6], mem[1], t1, t2, t0)
   TEST_3R("muhu", mem[6], mem[2], t2, t0, t1)
   TEST_3R("muhu", mem[6], mem[3], t0, t1, t2)
   TEST_3R("muhu", mem[6], mem[4], t1, t2, t0)
   TEST_3R("muhu", mem[6], mem[5], t2, t0, t1)
   TEST_3R("muhu", mem[6], mem[6], t0, t1, t2)
   TEST_3R("muhu", mem[6], mem[7], t1, t2, t0)
   TEST_3R("muhu", mem[6], mem[8], t2, t0, t1)
   TEST_3R("muhu", mem[6], mem[9], t0, t1, t2)
   TEST_3R("muhu", mem[6], mem[10], t1, t2, t0)
   TEST_3R("muhu", mem[6], mem[11], t2, t0, t1)
   TEST_3R("muhu", mem[7], mem[0], t1, t2, t0)
   TEST_3R("muhu", mem[7], mem[1], t2, t0, t1)
   TEST_3R("muhu", mem[7], mem[2], t0, t1, t2)
   TEST_3R("muhu", mem[7], mem[3], t1, t2, t0)
   TEST_3R("muhu", mem[7], mem[4], t2, t0, t1)
   TEST_3R("muhu", mem[7], mem[5], t0, t1, t2)
   TEST_3R("muhu", mem[7], mem[6], t1, t2, t0)
   TEST_3R("muhu", mem[7], mem[7], t2, t0, t1)
   TEST_3R("muhu", mem[7], mem[8], t0, t1, t2)
   TEST_3R("muhu", mem[7], mem[9], t1, t2, t0)
   TEST_3R("muhu", mem[7], mem[10], t2, t0, t1)
   TEST_3R("muhu", mem[7], mem[11], t0, t1, t2)
   TEST_3R("muhu", mem[8], mem[0], t2, t0, t1)
   TEST_3R("muhu", mem[8], mem[1], t0, t1, t2)
   TEST_3R("muhu", mem[8], mem[2], t1, t2, t0)
   TEST_3R("muhu", mem[8], mem[3], t2, t0, t1)
   TEST_3R("muhu", mem[8], mem[4], t0, t1, t2)
   TEST_3R("muhu", mem[8], mem[5], t1, t2, t0)
   TEST_3R("muhu", mem[8], mem[6], t2, t0, t1)
   TEST_3R("muhu", mem[8], mem[7], t0, t1, t2)
   TEST_3R("muhu", mem[8], mem[8], t1, t2, t0)
   TEST_3R("muhu", mem[8], mem[9], t2, t0, t1)
   TEST_3R("muhu", mem[8], mem[10], t0, t1, t2)
   TEST_3R("muhu", mem[8], mem[11], t1, t2, t0)
   TEST_3R("muhu", mem[9], mem[0], t0, t1, t2)
   TEST_3R("muhu", mem[9], mem[1], t1, t2, t0)
   TEST_3R("muhu", mem[9], mem[2], t2, t0, t1)
   TEST_3R("muhu", mem[9], mem[3], t0, t1, t2)
   TEST_3R("muhu", mem[9], mem[4], t1, t2, t0)
   TEST_3R("muhu", mem[9], mem[5], t2, t0, t1)
   TEST_3R("muhu", mem[9], mem[6], t0, t1, t2)
   TEST_3R("muhu", mem[9], mem[7], t1, t2, t0)
   TEST_3R("muhu", mem[9], mem[8], t2, t0, t1)
   TEST_3R("muhu", mem[9], mem[9], t0, t1, t2)
   TEST_3R("muhu", mem[9], mem[10], t1, t2, t0)
   TEST_3R("muhu", mem[9], mem[11], t2, t0, t1)
   TEST_3R("muhu", mem[10], mem[0], t1, t2, t0)
   TEST_3R("muhu", mem[10], mem[1], t2, t0, t1)
   TEST_3R("muhu", mem[10], mem[2], t0, t1, t2)
   TEST_3R("muhu", mem[10], mem[3], t1, t2, t0)
   TEST_3R("muhu", mem[10], mem[4], t2, t0, t1)
   TEST_3R("muhu", mem[10], mem[5], t0, t1, t2)
   TEST_3R("muhu", mem[10], mem[6], t1, t2, t0)
   TEST_3R("muhu", mem[10], mem[7], t2, t0, t1)
   TEST_3R("muhu", mem[10], mem[8], t0, t1, t2)
   TEST_3R("muhu", mem[10], mem[9], t1, t2, t0)
   TEST_3R("muhu", mem[10], mem[10], t2, t0, t1)
   TEST_3R("muhu", mem[10], mem[11], t0, t1, t2)
   TEST_3R("muhu", mem[11], mem[0], t2, t0, t1)
   TEST_3R("muhu", mem[11], mem[1], t0, t1, t2)
   TEST_3R("muhu", mem[11], mem[2], t1, t2, t0)
   TEST_3R("muhu", mem[11], mem[3], t2, t0, t1)
   TEST_3R("muhu", mem[11], mem[4], t0, t1, t2)
   TEST_3R("muhu", mem[11], mem[5], t1, t2, t0)
   TEST_3R("muhu", mem[11], mem[6], t2, t0, t1)
   TEST_3R("muhu", mem[11], mem[7], t0, t1, t2)
   TEST_3R("muhu", mem[11], mem[8], t1, t2, t0)
   TEST_3R("muhu", mem[11], mem[9], t2, t0, t1)
   TEST_3R("muhu", mem[11], mem[10], t0, t1, t2)
   TEST_3R("muhu", mem[11], mem[11], t1, t2, t0)

   printf("\nseleqz\n");
   TEST_3R("seleqz", mem[0], mem[0], t0, t1, t2)
   TEST_3R("seleqz", mem[0], mem[1], t1, t2, t0)
   TEST_3R("seleqz", mem[0], mem[2], t2, t0, t1)
   TEST_3R("seleqz", mem[0], mem[3], t0, t1, t2)
   TEST_3R("seleqz", mem[0], mem[4], t1, t2, t0)
   TEST_3R("seleqz", mem[0], mem[5], t2, t0, t1)
   TEST_3R("seleqz", mem[0], mem[6], t0, t1, t2)
   TEST_3R("seleqz", mem[0], mem[7], t1, t2, t0)
   TEST_3R("seleqz", mem[0], mem[8], t2, t0, t1)
   TEST_3R("seleqz", mem[0], mem[9], t0, t1, t2)
   TEST_3R("seleqz", mem[0], mem[10], t1, t2, t0)
   TEST_3R("seleqz", mem[0], mem[11], t2, t0, t1)
   TEST_3R("seleqz", mem[1], mem[0], t1, t2, t0)
   TEST_3R("seleqz", mem[1], mem[1], t2, t0, t1)
   TEST_3R("seleqz", mem[1], mem[2], t0, t1, t2)
   TEST_3R("seleqz", mem[1], mem[3], t1, t2, t0)
   TEST_3R("seleqz", mem[1], mem[4], t2, t0, t1)
   TEST_3R("seleqz", mem[1], mem[5], t0, t1, t2)
   TEST_3R("seleqz", mem[1], mem[6], t1, t2, t0)
   TEST_3R("seleqz", mem[1], mem[7], t2, t0, t1)
   TEST_3R("seleqz", mem[1], mem[8], t0, t1, t2)
   TEST_3R("seleqz", mem[1], mem[9], t1, t2, t0)
   TEST_3R("seleqz", mem[1], mem[10], t2, t0, t1)
   TEST_3R("seleqz", mem[1], mem[11], t0, t1, t2)
   TEST_3R("seleqz", mem[2], mem[0], t2, t0, t1)
   TEST_3R("seleqz", mem[2], mem[1], t0, t1, t2)
   TEST_3R("seleqz", mem[2], mem[2], t1, t2, t0)
   TEST_3R("seleqz", mem[2], mem[3], t2, t0, t1)
   TEST_3R("seleqz", mem[2], mem[4], t0, t1, t2)
   TEST_3R("seleqz", mem[2], mem[5], t1, t2, t0)
   TEST_3R("seleqz", mem[2], mem[6], t2, t0, t1)
   TEST_3R("seleqz", mem[2], mem[7], t0, t1, t2)
   TEST_3R("seleqz", mem[2], mem[8], t1, t2, t0)
   TEST_3R("seleqz", mem[2], mem[9], t2, t0, t1)
   TEST_3R("seleqz", mem[2], mem[10], t0, t1, t2)
   TEST_3R("seleqz", mem[2], mem[11], t1, t2, t0)
   TEST_3R("seleqz", mem[3], mem[0], t0, t1, t2)
   TEST_3R("seleqz", mem[3], mem[1], t1, t2, t0)
   TEST_3R("seleqz", mem[3], mem[2], t2, t0, t1)
   TEST_3R("seleqz", mem[3], mem[3], t0, t1, t2)
   TEST_3R("seleqz", mem[3], mem[4], t1, t2, t0)
   TEST_3R("seleqz", mem[3], mem[5], t2, t0, t1)
   TEST_3R("seleqz", mem[3], mem[6], t0, t1, t2)
   TEST_3R("seleqz", mem[3], mem[7], t1, t2, t0)
   TEST_3R("seleqz", mem[3], mem[8], t2, t0, t1)
   TEST_3R("seleqz", mem[3], mem[9], t0, t1, t2)
   TEST_3R("seleqz", mem[3], mem[10], t1, t2, t0)
   TEST_3R("seleqz", mem[3], mem[11], t2, t0, t1)
   TEST_3R("seleqz", mem[4], mem[0], t1, t2, t0)
   TEST_3R("seleqz", mem[4], mem[1], t2, t0, t1)
   TEST_3R("seleqz", mem[4], mem[2], t0, t1, t2)
   TEST_3R("seleqz", mem[4], mem[3], t1, t2, t0)
   TEST_3R("seleqz", mem[4], mem[4], t2, t0, t1)
   TEST_3R("seleqz", mem[4], mem[5], t0, t1, t2)
   TEST_3R("seleqz", mem[4], mem[6], t1, t2, t0)
   TEST_3R("seleqz", mem[4], mem[7], t2, t0, t1)
   TEST_3R("seleqz", mem[4], mem[8], t0, t1, t2)
   TEST_3R("seleqz", mem[4], mem[9], t1, t2, t0)
   TEST_3R("seleqz", mem[4], mem[10], t2, t0, t1)
   TEST_3R("seleqz", mem[4], mem[11], t0, t1, t2)
   TEST_3R("seleqz", mem[5], mem[0], t2, t0, t1)
   TEST_3R("seleqz", mem[5], mem[1], t0, t1, t2)
   TEST_3R("seleqz", mem[5], mem[2], t1, t2, t0)
   TEST_3R("seleqz", mem[5], mem[3], t2, t0, t1)
   TEST_3R("seleqz", mem[5], mem[4], t0, t1, t2)
   TEST_3R("seleqz", mem[5], mem[5], t1, t2, t0)
   TEST_3R("seleqz", mem[5], mem[6], t2, t0, t1)
   TEST_3R("seleqz", mem[5], mem[7], t0, t1, t2)
   TEST_3R("seleqz", mem[5], mem[8], t1, t2, t0)
   TEST_3R("seleqz", mem[5], mem[9], t2, t0, t1)
   TEST_3R("seleqz", mem[5], mem[10], t0, t1, t2)
   TEST_3R("seleqz", mem[5], mem[11], t1, t2, t0)
   TEST_3R("seleqz", mem[6], mem[0], t0, t1, t2)
   TEST_3R("seleqz", mem[6], mem[1], t1, t2, t0)
   TEST_3R("seleqz", mem[6], mem[2], t2, t0, t1)
   TEST_3R("seleqz", mem[6], mem[3], t0, t1, t2)
   TEST_3R("seleqz", mem[6], mem[4], t1, t2, t0)
   TEST_3R("seleqz", mem[6], mem[5], t2, t0, t1)
   TEST_3R("seleqz", mem[6], mem[6], t0, t1, t2)
   TEST_3R("seleqz", mem[6], mem[7], t1, t2, t0)
   TEST_3R("seleqz", mem[6], mem[8], t2, t0, t1)
   TEST_3R("seleqz", mem[6], mem[9], t0, t1, t2)
   TEST_3R("seleqz", mem[6], mem[10], t1, t2, t0)
   TEST_3R("seleqz", mem[6], mem[11], t2, t0, t1)
   TEST_3R("seleqz", mem[7], mem[0], t1, t2, t0)
   TEST_3R("seleqz", mem[7], mem[1], t2, t0, t1)
   TEST_3R("seleqz", mem[7], mem[2], t0, t1, t2)
   TEST_3R("seleqz", mem[7], mem[3], t1, t2, t0)
   TEST_3R("seleqz", mem[7], mem[4], t2, t0, t1)
   TEST_3R("seleqz", mem[7], mem[5], t0, t1, t2)
   TEST_3R("seleqz", mem[7], mem[6], t1, t2, t0)
   TEST_3R("seleqz", mem[7], mem[7], t2, t0, t1)
   TEST_3R("seleqz", mem[7], mem[8], t0, t1, t2)
   TEST_3R("seleqz", mem[7], mem[9], t1, t2, t0)
   TEST_3R("seleqz", mem[7], mem[10], t2, t0, t1)
   TEST_3R("seleqz", mem[7], mem[11], t0, t1, t2)
   TEST_3R("seleqz", mem[8], mem[0], t2, t0, t1)
   TEST_3R("seleqz", mem[8], mem[1], t0, t1, t2)
   TEST_3R("seleqz", mem[8], mem[2], t1, t2, t0)
   TEST_3R("seleqz", mem[8], mem[3], t2, t0, t1)
   TEST_3R("seleqz", mem[8], mem[4], t0, t1, t2)
   TEST_3R("seleqz", mem[8], mem[5], t1, t2, t0)
   TEST_3R("seleqz", mem[8], mem[6], t2, t0, t1)
   TEST_3R("seleqz", mem[8], mem[7], t0, t1, t2)
   TEST_3R("seleqz", mem[8], mem[8], t1, t2, t0)
   TEST_3R("seleqz", mem[8], mem[9], t2, t0, t1)
   TEST_3R("seleqz", mem[8], mem[10], t0, t1, t2)
   TEST_3R("seleqz", mem[8], mem[11], t1, t2, t0)
   TEST_3R("seleqz", mem[9], mem[0], t0, t1, t2)
   TEST_3R("seleqz", mem[9], mem[1], t1, t2, t0)
   TEST_3R("seleqz", mem[9], mem[2], t2, t0, t1)
   TEST_3R("seleqz", mem[9], mem[3], t0, t1, t2)
   TEST_3R("seleqz", mem[9], mem[4], t1, t2, t0)
   TEST_3R("seleqz", mem[9], mem[5], t2, t0, t1)
   TEST_3R("seleqz", mem[9], mem[6], t0, t1, t2)
   TEST_3R("seleqz", mem[9], mem[7], t1, t2, t0)
   TEST_3R("seleqz", mem[9], mem[8], t2, t0, t1)
   TEST_3R("seleqz", mem[9], mem[9], t0, t1, t2)
   TEST_3R("seleqz", mem[9], mem[10], t1, t2, t0)
   TEST_3R("seleqz", mem[9], mem[11], t2, t0, t1)
   TEST_3R("seleqz", mem[10], mem[0], t1, t2, t0)
   TEST_3R("seleqz", mem[10], mem[1], t2, t0, t1)
   TEST_3R("seleqz", mem[10], mem[2], t0, t1, t2)
   TEST_3R("seleqz", mem[10], mem[3], t1, t2, t0)
   TEST_3R("seleqz", mem[10], mem[4], t2, t0, t1)
   TEST_3R("seleqz", mem[10], mem[5], t0, t1, t2)
   TEST_3R("seleqz", mem[10], mem[6], t1, t2, t0)
   TEST_3R("seleqz", mem[10], mem[7], t2, t0, t1)
   TEST_3R("seleqz", mem[10], mem[8], t0, t1, t2)
   TEST_3R("seleqz", mem[10], mem[9], t1, t2, t0)
   TEST_3R("seleqz", mem[10], mem[10], t2, t0, t1)
   TEST_3R("seleqz", mem[10], mem[11], t0, t1, t2)
   TEST_3R("seleqz", mem[11], mem[0], t2, t0, t1)
   TEST_3R("seleqz", mem[11], mem[1], t0, t1, t2)
   TEST_3R("seleqz", mem[11], mem[2], t1, t2, t0)
   TEST_3R("seleqz", mem[11], mem[3], t2, t0, t1)
   TEST_3R("seleqz", mem[11], mem[4], t0, t1, t2)
   TEST_3R("seleqz", mem[11], mem[5], t1, t2, t0)
   TEST_3R("seleqz", mem[11], mem[6], t2, t0, t1)
   TEST_3R("seleqz", mem[11], mem[7], t0, t1, t2)
   TEST_3R("seleqz", mem[11], mem[8], t1, t2, t0)
   TEST_3R("seleqz", mem[11], mem[9], t2, t0, t1)
   TEST_3R("seleqz", mem[11], mem[10], t0, t1, t2)
   TEST_3R("seleqz", mem[11], mem[11], t1, t2, t0)

   printf("\nselnez\n");
   TEST_3R("selnez", mem[0], mem[0], t0, t1, t2)
   TEST_3R("selnez", mem[0], mem[1], t1, t2, t0)
   TEST_3R("selnez", mem[0], mem[2], t2, t0, t1)
   TEST_3R("selnez", mem[0], mem[3], t0, t1, t2)
   TEST_3R("selnez", mem[0], mem[4], t1, t2, t0)
   TEST_3R("selnez", mem[0], mem[5], t2, t0, t1)
   TEST_3R("selnez", mem[0], mem[6], t0, t1, t2)
   TEST_3R("selnez", mem[0], mem[7], t1, t2, t0)
   TEST_3R("selnez", mem[0], mem[8], t2, t0, t1)
   TEST_3R("selnez", mem[0], mem[9], t0, t1, t2)
   TEST_3R("selnez", mem[0], mem[10], t1, t2, t0)
   TEST_3R("selnez", mem[0], mem[11], t2, t0, t1)
   TEST_3R("selnez", mem[1], mem[0], t1, t2, t0)
   TEST_3R("selnez", mem[1], mem[1], t2, t0, t1)
   TEST_3R("selnez", mem[1], mem[2], t0, t1, t2)
   TEST_3R("selnez", mem[1], mem[3], t1, t2, t0)
   TEST_3R("selnez", mem[1], mem[4], t2, t0, t1)
   TEST_3R("selnez", mem[1], mem[5], t0, t1, t2)
   TEST_3R("selnez", mem[1], mem[6], t1, t2, t0)
   TEST_3R("selnez", mem[1], mem[7], t2, t0, t1)
   TEST_3R("selnez", mem[1], mem[8], t0, t1, t2)
   TEST_3R("selnez", mem[1], mem[9], t1, t2, t0)
   TEST_3R("selnez", mem[1], mem[10], t2, t0, t1)
   TEST_3R("selnez", mem[1], mem[11], t0, t1, t2)
   TEST_3R("selnez", mem[2], mem[0], t2, t0, t1)
   TEST_3R("selnez", mem[2], mem[1], t0, t1, t2)
   TEST_3R("selnez", mem[2], mem[2], t1, t2, t0)
   TEST_3R("selnez", mem[2], mem[3], t2, t0, t1)
   TEST_3R("selnez", mem[2], mem[4], t0, t1, t2)
   TEST_3R("selnez", mem[2], mem[5], t1, t2, t0)
   TEST_3R("selnez", mem[2], mem[6], t2, t0, t1)
   TEST_3R("selnez", mem[2], mem[7], t0, t1, t2)
   TEST_3R("selnez", mem[2], mem[8], t1, t2, t0)
   TEST_3R("selnez", mem[2], mem[9], t2, t0, t1)
   TEST_3R("selnez", mem[2], mem[10], t0, t1, t2)
   TEST_3R("selnez", mem[2], mem[11], t1, t2, t0)
   TEST_3R("selnez", mem[3], mem[0], t0, t1, t2)
   TEST_3R("selnez", mem[3], mem[1], t1, t2, t0)
   TEST_3R("selnez", mem[3], mem[2], t2, t0, t1)
   TEST_3R("selnez", mem[3], mem[3], t0, t1, t2)
   TEST_3R("selnez", mem[3], mem[4], t1, t2, t0)
   TEST_3R("selnez", mem[3], mem[5], t2, t0, t1)
   TEST_3R("selnez", mem[3], mem[6], t0, t1, t2)
   TEST_3R("selnez", mem[3], mem[7], t1, t2, t0)
   TEST_3R("selnez", mem[3], mem[8], t2, t0, t1)
   TEST_3R("selnez", mem[3], mem[9], t0, t1, t2)
   TEST_3R("selnez", mem[3], mem[10], t1, t2, t0)
   TEST_3R("selnez", mem[3], mem[11], t2, t0, t1)
   TEST_3R("selnez", mem[4], mem[0], t1, t2, t0)
   TEST_3R("selnez", mem[4], mem[1], t2, t0, t1)
   TEST_3R("selnez", mem[4], mem[2], t0, t1, t2)
   TEST_3R("selnez", mem[4], mem[3], t1, t2, t0)
   TEST_3R("selnez", mem[4], mem[4], t2, t0, t1)
   TEST_3R("selnez", mem[4], mem[5], t0, t1, t2)
   TEST_3R("selnez", mem[4], mem[6], t1, t2, t0)
   TEST_3R("selnez", mem[4], mem[7], t2, t0, t1)
   TEST_3R("selnez", mem[4], mem[8], t0, t1, t2)
   TEST_3R("selnez", mem[4], mem[9], t1, t2, t0)
   TEST_3R("selnez", mem[4], mem[10], t2, t0, t1)
   TEST_3R("selnez", mem[4], mem[11], t0, t1, t2)
   TEST_3R("selnez", mem[5], mem[0], t2, t0, t1)
   TEST_3R("selnez", mem[5], mem[1], t0, t1, t2)
   TEST_3R("selnez", mem[5], mem[2], t1, t2, t0)
   TEST_3R("selnez", mem[5], mem[3], t2, t0, t1)
   TEST_3R("selnez", mem[5], mem[4], t0, t1, t2)
   TEST_3R("selnez", mem[5], mem[5], t1, t2, t0)
   TEST_3R("selnez", mem[5], mem[6], t2, t0, t1)
   TEST_3R("selnez", mem[5], mem[7], t0, t1, t2)
   TEST_3R("selnez", mem[5], mem[8], t1, t2, t0)
   TEST_3R("selnez", mem[5], mem[9], t2, t0, t1)
   TEST_3R("selnez", mem[5], mem[10], t0, t1, t2)
   TEST_3R("selnez", mem[5], mem[11], t1, t2, t0)
   TEST_3R("selnez", mem[6], mem[0], t0, t1, t2)
   TEST_3R("selnez", mem[6], mem[1], t1, t2, t0)
   TEST_3R("selnez", mem[6], mem[2], t2, t0, t1)
   TEST_3R("selnez", mem[6], mem[3], t0, t1, t2)
   TEST_3R("selnez", mem[6], mem[4], t1, t2, t0)
   TEST_3R("selnez", mem[6], mem[5], t2, t0, t1)
   TEST_3R("selnez", mem[6], mem[6], t0, t1, t2)
   TEST_3R("selnez", mem[6], mem[7], t1, t2, t0)
   TEST_3R("selnez", mem[6], mem[8], t2, t0, t1)
   TEST_3R("selnez", mem[6], mem[9], t0, t1, t2)
   TEST_3R("selnez", mem[6], mem[10], t1, t2, t0)
   TEST_3R("selnez", mem[6], mem[11], t2, t0, t1)
   TEST_3R("selnez", mem[7], mem[0], t1, t2, t0)
   TEST_3R("selnez", mem[7], mem[1], t2, t0, t1)
   TEST_3R("selnez", mem[7], mem[2], t0, t1, t2)
   TEST_3R("selnez", mem[7], mem[3], t1, t2, t0)
   TEST_3R("selnez", mem[7], mem[4], t2, t0, t1)
   TEST_3R("selnez", mem[7], mem[5], t0, t1, t2)
   TEST_3R("selnez", mem[7], mem[6], t1, t2, t0)
   TEST_3R("selnez", mem[7], mem[7], t2, t0, t1)
   TEST_3R("selnez", mem[7], mem[8], t0, t1, t2)
   TEST_3R("selnez", mem[7], mem[9], t1, t2, t0)
   TEST_3R("selnez", mem[7], mem[10], t2, t0, t1)
   TEST_3R("selnez", mem[7], mem[11], t0, t1, t2)
   TEST_3R("selnez", mem[8], mem[0], t2, t0, t1)
   TEST_3R("selnez", mem[8], mem[1], t0, t1, t2)
   TEST_3R("selnez", mem[8], mem[2], t1, t2, t0)
   TEST_3R("selnez", mem[8], mem[3], t2, t0, t1)
   TEST_3R("selnez", mem[8], mem[4], t0, t1, t2)
   TEST_3R("selnez", mem[8], mem[5], t1, t2, t0)
   TEST_3R("selnez", mem[8], mem[6], t2, t0, t1)
   TEST_3R("selnez", mem[8], mem[7], t0, t1, t2)
   TEST_3R("selnez", mem[8], mem[8], t1, t2, t0)
   TEST_3R("selnez", mem[8], mem[9], t2, t0, t1)
   TEST_3R("selnez", mem[8], mem[10], t0, t1, t2)
   TEST_3R("selnez", mem[8], mem[11], t1, t2, t0)
   TEST_3R("selnez", mem[9], mem[0], t0, t1, t2)
   TEST_3R("selnez", mem[9], mem[1], t1, t2, t0)
   TEST_3R("selnez", mem[9], mem[2], t2, t0, t1)
   TEST_3R("selnez", mem[9], mem[3], t0, t1, t2)
   TEST_3R("selnez", mem[9], mem[4], t1, t2, t0)
   TEST_3R("selnez", mem[9], mem[5], t2, t0, t1)
   TEST_3R("selnez", mem[9], mem[6], t0, t1, t2)
   TEST_3R("selnez", mem[9], mem[7], t1, t2, t0)
   TEST_3R("selnez", mem[9], mem[8], t2, t0, t1)
   TEST_3R("selnez", mem[9], mem[9], t0, t1, t2)
   TEST_3R("selnez", mem[9], mem[10], t1, t2, t0)
   TEST_3R("selnez", mem[9], mem[11], t2, t0, t1)
   TEST_3R("selnez", mem[10], mem[0], t1, t2, t0)
   TEST_3R("selnez", mem[10], mem[1], t2, t0, t1)
   TEST_3R("selnez", mem[10], mem[2], t0, t1, t2)
   TEST_3R("selnez", mem[10], mem[3], t1, t2, t0)
   TEST_3R("selnez", mem[10], mem[4], t2, t0, t1)
   TEST_3R("selnez", mem[10], mem[5], t0, t1, t2)
   TEST_3R("selnez", mem[10], mem[6], t1, t2, t0)
   TEST_3R("selnez", mem[10], mem[7], t2, t0, t1)
   TEST_3R("selnez", mem[10], mem[8], t0, t1, t2)
   TEST_3R("selnez", mem[10], mem[9], t1, t2, t0)
   TEST_3R("selnez", mem[10], mem[10], t2, t0, t1)
   TEST_3R("selnez", mem[10], mem[11], t0, t1, t2)
   TEST_3R("selnez", mem[11], mem[0], t2, t0, t1)
   TEST_3R("selnez", mem[11], mem[1], t0, t1, t2)
   TEST_3R("selnez", mem[11], mem[2], t1, t2, t0)
   TEST_3R("selnez", mem[11], mem[3], t2, t0, t1)
   TEST_3R("selnez", mem[11], mem[4], t0, t1, t2)
   TEST_3R("selnez", mem[11], mem[5], t1, t2, t0)
   TEST_3R("selnez", mem[11], mem[6], t2, t0, t1)
   TEST_3R("selnez", mem[11], mem[7], t0, t1, t2)
   TEST_3R("selnez", mem[11], mem[8], t1, t2, t0)
   TEST_3R("selnez", mem[11], mem[9], t2, t0, t1)
   TEST_3R("selnez", mem[11], mem[10], t0, t1, t2)
   TEST_3R("selnez", mem[11], mem[11], t1, t2, t0)

   printf("\nalign\n");
   TEST_3R2b("align", mem[0], mem[0], t0, t1, t2, 0)
   TEST_3R2b("align", mem[0], mem[0], t0, t1, t2, 1)
   TEST_3R2b("align", mem[0], mem[0], t0, t1, t2, 2)
   TEST_3R2b("align", mem[0], mem[0], t0, t1, t2, 3)
   TEST_3R2b("align", mem[0], mem[1], t1, t2, t0, 0)
   TEST_3R2b("align", mem[0], mem[1], t1, t2, t0, 1)
   TEST_3R2b("align", mem[0], mem[1], t1, t2, t0, 2)
   TEST_3R2b("align", mem[0], mem[1], t1, t2, t0, 3)
   TEST_3R2b("align", mem[0], mem[2], t2, t0, t1, 0)
   TEST_3R2b("align", mem[0], mem[2], t2, t0, t1, 1)
   TEST_3R2b("align", mem[0], mem[2], t2, t0, t1, 2)
   TEST_3R2b("align", mem[0], mem[2], t2, t0, t1, 3)
   TEST_3R2b("align", mem[0], mem[3], t0, t1, t2, 0)
   TEST_3R2b("align", mem[0], mem[3], t0, t1, t2, 1)
   TEST_3R2b("align", mem[0], mem[3], t0, t1, t2, 2)
   TEST_3R2b("align", mem[0], mem[3], t0, t1, t2, 3)
   TEST_3R2b("align", mem[0], mem[4], t1, t2, t0, 0)
   TEST_3R2b("align", mem[0], mem[4], t1, t2, t0, 1)
   TEST_3R2b("align", mem[0], mem[4], t1, t2, t0, 2)
   TEST_3R2b("align", mem[0], mem[4], t1, t2, t0, 3)
   TEST_3R2b("align", mem[0], mem[5], t2, t0, t1, 0)
   TEST_3R2b("align", mem[0], mem[5], t2, t0, t1, 1)
   TEST_3R2b("align", mem[0], mem[5], t2, t0, t1, 2)
   TEST_3R2b("align", mem[0], mem[5], t2, t0, t1, 3)
   TEST_3R2b("align", mem[0], mem[6], t0, t1, t2, 0)
   TEST_3R2b("align", mem[0], mem[6], t0, t1, t2, 1)
   TEST_3R2b("align", mem[0], mem[6], t0, t1, t2, 2)
   TEST_3R2b("align", mem[0], mem[6], t0, t1, t2, 3)
   TEST_3R2b("align", mem[0], mem[7], t1, t2, t0, 0)
   TEST_3R2b("align", mem[0], mem[7], t1, t2, t0, 1)
   TEST_3R2b("align", mem[0], mem[7], t1, t2, t0, 2)
   TEST_3R2b("align", mem[0], mem[7], t1, t2, t0, 3)
   TEST_3R2b("align", mem[0], mem[8], t2, t0, t1, 0)
   TEST_3R2b("align", mem[0], mem[8], t2, t0, t1, 1)
   TEST_3R2b("align", mem[0], mem[8], t2, t0, t1, 2)
   TEST_3R2b("align", mem[0], mem[8], t2, t0, t1, 3)
   TEST_3R2b("align", mem[0], mem[9], t0, t1, t2, 0)
   TEST_3R2b("align", mem[0], mem[9], t0, t1, t2, 1)
   TEST_3R2b("align", mem[0], mem[9], t0, t1, t2, 2)
   TEST_3R2b("align", mem[0], mem[9], t0, t1, t2, 3)
   TEST_3R2b("align", mem[0], mem[10], t1, t2, t0, 0)
   TEST_3R2b("align", mem[0], mem[10], t1, t2, t0, 1)
   TEST_3R2b("align", mem[0], mem[10], t1, t2, t0, 2)
   TEST_3R2b("align", mem[0], mem[10], t1, t2, t0, 3)
   TEST_3R2b("align", mem[0], mem[11], t2, t0, t1, 0)
   TEST_3R2b("align", mem[0], mem[11], t2, t0, t1, 1)
   TEST_3R2b("align", mem[0], mem[11], t2, t0, t1, 2)
   TEST_3R2b("align", mem[0], mem[11], t2, t0, t1, 3)
   TEST_3R2b("align", mem[1], mem[0], t1, t2, t0, 0)
   TEST_3R2b("align", mem[1], mem[0], t1, t2, t0, 1)
   TEST_3R2b("align", mem[1], mem[0], t1, t2, t0, 2)
   TEST_3R2b("align", mem[1], mem[0], t1, t2, t0, 3)
   TEST_3R2b("align", mem[1], mem[1], t2, t0, t1, 0)
   TEST_3R2b("align", mem[1], mem[1], t2, t0, t1, 1)
   TEST_3R2b("align", mem[1], mem[1], t2, t0, t1, 2)
   TEST_3R2b("align", mem[1], mem[1], t2, t0, t1, 3)
   TEST_3R2b("align", mem[1], mem[2], t0, t1, t2, 0)
   TEST_3R2b("align", mem[1], mem[2], t0, t1, t2, 1)
   TEST_3R2b("align", mem[1], mem[2], t0, t1, t2, 2)
   TEST_3R2b("align", mem[1], mem[2], t0, t1, t2, 3)
   TEST_3R2b("align", mem[1], mem[3], t1, t2, t0, 0)
   TEST_3R2b("align", mem[1], mem[3], t1, t2, t0, 1)
   TEST_3R2b("align", mem[1], mem[3], t1, t2, t0, 2)
   TEST_3R2b("align", mem[1], mem[3], t1, t2, t0, 3)
   TEST_3R2b("align", mem[1], mem[4], t2, t0, t1, 0)
   TEST_3R2b("align", mem[1], mem[4], t2, t0, t1, 1)
   TEST_3R2b("align", mem[1], mem[4], t2, t0, t1, 2)
   TEST_3R2b("align", mem[1], mem[4], t2, t0, t1, 3)
   TEST_3R2b("align", mem[1], mem[5], t0, t1, t2, 0)
   TEST_3R2b("align", mem[1], mem[5], t0, t1, t2, 1)
   TEST_3R2b("align", mem[1], mem[5], t0, t1, t2, 2)
   TEST_3R2b("align", mem[1], mem[5], t0, t1, t2, 3)
   TEST_3R2b("align", mem[1], mem[6], t1, t2, t0, 0)
   TEST_3R2b("align", mem[1], mem[6], t1, t2, t0, 1)
   TEST_3R2b("align", mem[1], mem[6], t1, t2, t0, 2)
   TEST_3R2b("align", mem[1], mem[6], t1, t2, t0, 3)
   TEST_3R2b("align", mem[1], mem[7], t2, t0, t1, 0)
   TEST_3R2b("align", mem[1], mem[7], t2, t0, t1, 1)
   TEST_3R2b("align", mem[1], mem[7], t2, t0, t1, 2)
   TEST_3R2b("align", mem[1], mem[7], t2, t0, t1, 3)
   TEST_3R2b("align", mem[1], mem[8], t0, t1, t2, 0)
   TEST_3R2b("align", mem[1], mem[8], t0, t1, t2, 1)
   TEST_3R2b("align", mem[1], mem[8], t0, t1, t2, 2)
   TEST_3R2b("align", mem[1], mem[8], t0, t1, t2, 3)
   TEST_3R2b("align", mem[1], mem[9], t1, t2, t0, 0)
   TEST_3R2b("align", mem[1], mem[9], t1, t2, t0, 1)
   TEST_3R2b("align", mem[1], mem[9], t1, t2, t0, 2)
   TEST_3R2b("align", mem[1], mem[9], t1, t2, t0, 3)
   TEST_3R2b("align", mem[1], mem[10], t2, t0, t1, 0)
   TEST_3R2b("align", mem[1], mem[10], t2, t0, t1, 1)
   TEST_3R2b("align", mem[1], mem[10], t2, t0, t1, 2)
   TEST_3R2b("align", mem[1], mem[10], t2, t0, t1, 3)
   TEST_3R2b("align", mem[1], mem[11], t0, t1, t2, 0)
   TEST_3R2b("align", mem[1], mem[11], t0, t1, t2, 1)
   TEST_3R2b("align", mem[1], mem[11], t0, t1, t2, 2)
   TEST_3R2b("align", mem[1], mem[11], t0, t1, t2, 3)
   TEST_3R2b("align", mem[2], mem[0], t2, t0, t1, 0)
   TEST_3R2b("align", mem[2], mem[0], t2, t0, t1, 1)
   TEST_3R2b("align", mem[2], mem[0], t2, t0, t1, 2)
   TEST_3R2b("align", mem[2], mem[0], t2, t0, t1, 3)
   TEST_3R2b("align", mem[2], mem[1], t0, t1, t2, 0)
   TEST_3R2b("align", mem[2], mem[1], t0, t1, t2, 1)
   TEST_3R2b("align", mem[2], mem[1], t0, t1, t2, 2)
   TEST_3R2b("align", mem[2], mem[1], t0, t1, t2, 3)
   TEST_3R2b("align", mem[2], mem[2], t1, t2, t0, 0)
   TEST_3R2b("align", mem[2], mem[2], t1, t2, t0, 1)
   TEST_3R2b("align", mem[2], mem[2], t1, t2, t0, 2)
   TEST_3R2b("align", mem[2], mem[2], t1, t2, t0, 3)
   TEST_3R2b("align", mem[2], mem[3], t2, t0, t1, 0)
   TEST_3R2b("align", mem[2], mem[3], t2, t0, t1, 1)
   TEST_3R2b("align", mem[2], mem[3], t2, t0, t1, 2)
   TEST_3R2b("align", mem[2], mem[3], t2, t0, t1, 3)
   TEST_3R2b("align", mem[2], mem[4], t0, t1, t2, 0)
   TEST_3R2b("align", mem[2], mem[4], t0, t1, t2, 1)
   TEST_3R2b("align", mem[2], mem[4], t0, t1, t2, 2)
   TEST_3R2b("align", mem[2], mem[4], t0, t1, t2, 3)
   TEST_3R2b("align", mem[2], mem[5], t1, t2, t0, 0)
   TEST_3R2b("align", mem[2], mem[5], t1, t2, t0, 1)
   TEST_3R2b("align", mem[2], mem[5], t1, t2, t0, 2)
   TEST_3R2b("align", mem[2], mem[5], t1, t2, t0, 3)
   TEST_3R2b("align", mem[2], mem[6], t2, t0, t1, 0)
   TEST_3R2b("align", mem[2], mem[6], t2, t0, t1, 1)
   TEST_3R2b("align", mem[2], mem[6], t2, t0, t1, 2)
   TEST_3R2b("align", mem[2], mem[6], t2, t0, t1, 3)
   TEST_3R2b("align", mem[2], mem[7], t0, t1, t2, 0)
   TEST_3R2b("align", mem[2], mem[7], t0, t1, t2, 1)
   TEST_3R2b("align", mem[2], mem[7], t0, t1, t2, 2)
   TEST_3R2b("align", mem[2], mem[7], t0, t1, t2, 3)
   TEST_3R2b("align", mem[2], mem[8], t1, t2, t0, 0)
   TEST_3R2b("align", mem[2], mem[8], t1, t2, t0, 1)
   TEST_3R2b("align", mem[2], mem[8], t1, t2, t0, 2)
   TEST_3R2b("align", mem[2], mem[8], t1, t2, t0, 3)
   TEST_3R2b("align", mem[2], mem[9], t2, t0, t1, 0)
   TEST_3R2b("align", mem[2], mem[9], t2, t0, t1, 1)
   TEST_3R2b("align", mem[2], mem[9], t2, t0, t1, 2)
   TEST_3R2b("align", mem[2], mem[9], t2, t0, t1, 3)
   TEST_3R2b("align", mem[2], mem[10], t0, t1, t2, 0)
   TEST_3R2b("align", mem[2], mem[10], t0, t1, t2, 1)
   TEST_3R2b("align", mem[2], mem[10], t0, t1, t2, 2)
   TEST_3R2b("align", mem[2], mem[10], t0, t1, t2, 3)
   TEST_3R2b("align", mem[2], mem[11], t1, t2, t0, 0)
   TEST_3R2b("align", mem[2], mem[11], t1, t2, t0, 1)
   TEST_3R2b("align", mem[2], mem[11], t1, t2, t0, 2)
   TEST_3R2b("align", mem[2], mem[11], t1, t2, t0, 3)
   TEST_3R2b("align", mem[3], mem[0], t0, t1, t2, 0)
   TEST_3R2b("align", mem[3], mem[0], t0, t1, t2, 1)
   TEST_3R2b("align", mem[3], mem[0], t0, t1, t2, 2)
   TEST_3R2b("align", mem[3], mem[0], t0, t1, t2, 3)
   TEST_3R2b("align", mem[3], mem[1], t1, t2, t0, 0)
   TEST_3R2b("align", mem[3], mem[1], t1, t2, t0, 1)
   TEST_3R2b("align", mem[3], mem[1], t1, t2, t0, 2)
   TEST_3R2b("align", mem[3], mem[1], t1, t2, t0, 3)
   TEST_3R2b("align", mem[3], mem[2], t2, t0, t1, 0)
   TEST_3R2b("align", mem[3], mem[2], t2, t0, t1, 1)
   TEST_3R2b("align", mem[3], mem[2], t2, t0, t1, 2)
   TEST_3R2b("align", mem[3], mem[2], t2, t0, t1, 3)
   TEST_3R2b("align", mem[3], mem[3], t0, t1, t2, 0)
   TEST_3R2b("align", mem[3], mem[3], t0, t1, t2, 1)
   TEST_3R2b("align", mem[3], mem[3], t0, t1, t2, 2)
   TEST_3R2b("align", mem[3], mem[3], t0, t1, t2, 3)
   TEST_3R2b("align", mem[3], mem[4], t1, t2, t0, 0)
   TEST_3R2b("align", mem[3], mem[4], t1, t2, t0, 1)
   TEST_3R2b("align", mem[3], mem[4], t1, t2, t0, 2)
   TEST_3R2b("align", mem[3], mem[4], t1, t2, t0, 3)
   TEST_3R2b("align", mem[3], mem[5], t2, t0, t1, 0)
   TEST_3R2b("align", mem[3], mem[5], t2, t0, t1, 1)
   TEST_3R2b("align", mem[3], mem[5], t2, t0, t1, 2)
   TEST_3R2b("align", mem[3], mem[5], t2, t0, t1, 3)
   TEST_3R2b("align", mem[3], mem[6], t0, t1, t2, 0)
   TEST_3R2b("align", mem[3], mem[6], t0, t1, t2, 1)
   TEST_3R2b("align", mem[3], mem[6], t0, t1, t2, 2)
   TEST_3R2b("align", mem[3], mem[6], t0, t1, t2, 3)
   TEST_3R2b("align", mem[3], mem[7], t1, t2, t0, 0)
   TEST_3R2b("align", mem[3], mem[7], t1, t2, t0, 1)
   TEST_3R2b("align", mem[3], mem[7], t1, t2, t0, 2)
   TEST_3R2b("align", mem[3], mem[7], t1, t2, t0, 3)
   TEST_3R2b("align", mem[3], mem[8], t2, t0, t1, 0)
   TEST_3R2b("align", mem[3], mem[8], t2, t0, t1, 1)
   TEST_3R2b("align", mem[3], mem[8], t2, t0, t1, 2)
   TEST_3R2b("align", mem[3], mem[8], t2, t0, t1, 3)
   TEST_3R2b("align", mem[3], mem[9], t0, t1, t2, 0)
   TEST_3R2b("align", mem[3], mem[9], t0, t1, t2, 1)
   TEST_3R2b("align", mem[3], mem[9], t0, t1, t2, 2)
   TEST_3R2b("align", mem[3], mem[9], t0, t1, t2, 3)
   TEST_3R2b("align", mem[3], mem[10], t1, t2, t0, 0)
   TEST_3R2b("align", mem[3], mem[10], t1, t2, t0, 1)
   TEST_3R2b("align", mem[3], mem[10], t1, t2, t0, 2)
   TEST_3R2b("align", mem[3], mem[10], t1, t2, t0, 3)
   TEST_3R2b("align", mem[3], mem[11], t2, t0, t1, 0)
   TEST_3R2b("align", mem[3], mem[11], t2, t0, t1, 1)
   TEST_3R2b("align", mem[3], mem[11], t2, t0, t1, 2)
   TEST_3R2b("align", mem[3], mem[11], t2, t0, t1, 3)
   TEST_3R2b("align", mem[4], mem[0], t1, t2, t0, 0)
   TEST_3R2b("align", mem[4], mem[0], t1, t2, t0, 1)
   TEST_3R2b("align", mem[4], mem[0], t1, t2, t0, 2)
   TEST_3R2b("align", mem[4], mem[0], t1, t2, t0, 3)
   TEST_3R2b("align", mem[4], mem[1], t2, t0, t1, 0)
   TEST_3R2b("align", mem[4], mem[1], t2, t0, t1, 1)
   TEST_3R2b("align", mem[4], mem[1], t2, t0, t1, 2)
   TEST_3R2b("align", mem[4], mem[1], t2, t0, t1, 3)
   TEST_3R2b("align", mem[4], mem[2], t0, t1, t2, 0)
   TEST_3R2b("align", mem[4], mem[2], t0, t1, t2, 1)
   TEST_3R2b("align", mem[4], mem[2], t0, t1, t2, 2)
   TEST_3R2b("align", mem[4], mem[2], t0, t1, t2, 3)
   TEST_3R2b("align", mem[4], mem[3], t1, t2, t0, 0)
   TEST_3R2b("align", mem[4], mem[3], t1, t2, t0, 1)
   TEST_3R2b("align", mem[4], mem[3], t1, t2, t0, 2)
   TEST_3R2b("align", mem[4], mem[3], t1, t2, t0, 3)
   TEST_3R2b("align", mem[4], mem[4], t2, t0, t1, 0)
   TEST_3R2b("align", mem[4], mem[4], t2, t0, t1, 1)
   TEST_3R2b("align", mem[4], mem[4], t2, t0, t1, 2)
   TEST_3R2b("align", mem[4], mem[4], t2, t0, t1, 3)
   TEST_3R2b("align", mem[4], mem[5], t0, t1, t2, 0)
   TEST_3R2b("align", mem[4], mem[5], t0, t1, t2, 1)
   TEST_3R2b("align", mem[4], mem[5], t0, t1, t2, 2)
   TEST_3R2b("align", mem[4], mem[5], t0, t1, t2, 3)
   TEST_3R2b("align", mem[4], mem[6], t1, t2, t0, 0)
   TEST_3R2b("align", mem[4], mem[6], t1, t2, t0, 1)
   TEST_3R2b("align", mem[4], mem[6], t1, t2, t0, 2)
   TEST_3R2b("align", mem[4], mem[6], t1, t2, t0, 3)
   TEST_3R2b("align", mem[4], mem[7], t2, t0, t1, 0)
   TEST_3R2b("align", mem[4], mem[7], t2, t0, t1, 1)
   TEST_3R2b("align", mem[4], mem[7], t2, t0, t1, 2)
   TEST_3R2b("align", mem[4], mem[7], t2, t0, t1, 3)
   TEST_3R2b("align", mem[4], mem[8], t0, t1, t2, 0)
   TEST_3R2b("align", mem[4], mem[8], t0, t1, t2, 1)
   TEST_3R2b("align", mem[4], mem[8], t0, t1, t2, 2)
   TEST_3R2b("align", mem[4], mem[8], t0, t1, t2, 3)
   TEST_3R2b("align", mem[4], mem[9], t1, t2, t0, 0)
   TEST_3R2b("align", mem[4], mem[9], t1, t2, t0, 1)
   TEST_3R2b("align", mem[4], mem[9], t1, t2, t0, 2)
   TEST_3R2b("align", mem[4], mem[9], t1, t2, t0, 3)
   TEST_3R2b("align", mem[4], mem[10], t2, t0, t1, 0)
   TEST_3R2b("align", mem[4], mem[10], t2, t0, t1, 1)
   TEST_3R2b("align", mem[4], mem[10], t2, t0, t1, 2)
   TEST_3R2b("align", mem[4], mem[10], t2, t0, t1, 3)
   TEST_3R2b("align", mem[4], mem[11], t0, t1, t2, 0)
   TEST_3R2b("align", mem[4], mem[11], t0, t1, t2, 1)
   TEST_3R2b("align", mem[4], mem[11], t0, t1, t2, 2)
   TEST_3R2b("align", mem[4], mem[11], t0, t1, t2, 3)
   TEST_3R2b("align", mem[5], mem[0], t2, t0, t1, 0)
   TEST_3R2b("align", mem[5], mem[0], t2, t0, t1, 1)
   TEST_3R2b("align", mem[5], mem[0], t2, t0, t1, 2)
   TEST_3R2b("align", mem[5], mem[0], t2, t0, t1, 3)
   TEST_3R2b("align", mem[5], mem[1], t0, t1, t2, 0)
   TEST_3R2b("align", mem[5], mem[1], t0, t1, t2, 1)
   TEST_3R2b("align", mem[5], mem[1], t0, t1, t2, 2)
   TEST_3R2b("align", mem[5], mem[1], t0, t1, t2, 3)
   TEST_3R2b("align", mem[5], mem[2], t1, t2, t0, 0)
   TEST_3R2b("align", mem[5], mem[2], t1, t2, t0, 1)
   TEST_3R2b("align", mem[5], mem[2], t1, t2, t0, 2)
   TEST_3R2b("align", mem[5], mem[2], t1, t2, t0, 3)
   TEST_3R2b("align", mem[5], mem[3], t2, t0, t1, 0)
   TEST_3R2b("align", mem[5], mem[3], t2, t0, t1, 1)
   TEST_3R2b("align", mem[5], mem[3], t2, t0, t1, 2)
   TEST_3R2b("align", mem[5], mem[3], t2, t0, t1, 3)
   TEST_3R2b("align", mem[5], mem[4], t0, t1, t2, 0)
   TEST_3R2b("align", mem[5], mem[4], t0, t1, t2, 1)
   TEST_3R2b("align", mem[5], mem[4], t0, t1, t2, 2)
   TEST_3R2b("align", mem[5], mem[4], t0, t1, t2, 3)
   TEST_3R2b("align", mem[5], mem[5], t1, t2, t0, 0)
   TEST_3R2b("align", mem[5], mem[5], t1, t2, t0, 1)
   TEST_3R2b("align", mem[5], mem[5], t1, t2, t0, 2)
   TEST_3R2b("align", mem[5], mem[5], t1, t2, t0, 3)
   TEST_3R2b("align", mem[5], mem[6], t2, t0, t1, 0)
   TEST_3R2b("align", mem[5], mem[6], t2, t0, t1, 1)
   TEST_3R2b("align", mem[5], mem[6], t2, t0, t1, 2)
   TEST_3R2b("align", mem[5], mem[6], t2, t0, t1, 3)
   TEST_3R2b("align", mem[5], mem[7], t0, t1, t2, 0)
   TEST_3R2b("align", mem[5], mem[7], t0, t1, t2, 1)
   TEST_3R2b("align", mem[5], mem[7], t0, t1, t2, 2)
   TEST_3R2b("align", mem[5], mem[7], t0, t1, t2, 3)
   TEST_3R2b("align", mem[5], mem[8], t1, t2, t0, 0)
   TEST_3R2b("align", mem[5], mem[8], t1, t2, t0, 1)
   TEST_3R2b("align", mem[5], mem[8], t1, t2, t0, 2)
   TEST_3R2b("align", mem[5], mem[8], t1, t2, t0, 3)
   TEST_3R2b("align", mem[5], mem[9], t2, t0, t1, 0)
   TEST_3R2b("align", mem[5], mem[9], t2, t0, t1, 1)
   TEST_3R2b("align", mem[5], mem[9], t2, t0, t1, 2)
   TEST_3R2b("align", mem[5], mem[9], t2, t0, t1, 3)
   TEST_3R2b("align", mem[5], mem[10], t0, t1, t2, 0)
   TEST_3R2b("align", mem[5], mem[10], t0, t1, t2, 1)
   TEST_3R2b("align", mem[5], mem[10], t0, t1, t2, 2)
   TEST_3R2b("align", mem[5], mem[10], t0, t1, t2, 3)
   TEST_3R2b("align", mem[5], mem[11], t1, t2, t0, 0)
   TEST_3R2b("align", mem[5], mem[11], t1, t2, t0, 1)
   TEST_3R2b("align", mem[5], mem[11], t1, t2, t0, 2)
   TEST_3R2b("align", mem[5], mem[11], t1, t2, t0, 3)
   TEST_3R2b("align", mem[6], mem[0], t0, t1, t2, 0)
   TEST_3R2b("align", mem[6], mem[0], t0, t1, t2, 1)
   TEST_3R2b("align", mem[6], mem[0], t0, t1, t2, 2)
   TEST_3R2b("align", mem[6], mem[0], t0, t1, t2, 3)
   TEST_3R2b("align", mem[6], mem[1], t1, t2, t0, 0)
   TEST_3R2b("align", mem[6], mem[1], t1, t2, t0, 1)
   TEST_3R2b("align", mem[6], mem[1], t1, t2, t0, 2)
   TEST_3R2b("align", mem[6], mem[1], t1, t2, t0, 3)
   TEST_3R2b("align", mem[6], mem[2], t2, t0, t1, 0)
   TEST_3R2b("align", mem[6], mem[2], t2, t0, t1, 1)
   TEST_3R2b("align", mem[6], mem[2], t2, t0, t1, 2)
   TEST_3R2b("align", mem[6], mem[2], t2, t0, t1, 3)
   TEST_3R2b("align", mem[6], mem[3], t0, t1, t2, 0)
   TEST_3R2b("align", mem[6], mem[3], t0, t1, t2, 1)
   TEST_3R2b("align", mem[6], mem[3], t0, t1, t2, 2)
   TEST_3R2b("align", mem[6], mem[3], t0, t1, t2, 3)
   TEST_3R2b("align", mem[6], mem[4], t1, t2, t0, 0)
   TEST_3R2b("align", mem[6], mem[4], t1, t2, t0, 1)
   TEST_3R2b("align", mem[6], mem[4], t1, t2, t0, 2)
   TEST_3R2b("align", mem[6], mem[4], t1, t2, t0, 3)
   TEST_3R2b("align", mem[6], mem[5], t2, t0, t1, 0)
   TEST_3R2b("align", mem[6], mem[5], t2, t0, t1, 1)
   TEST_3R2b("align", mem[6], mem[5], t2, t0, t1, 2)
   TEST_3R2b("align", mem[6], mem[5], t2, t0, t1, 3)
   TEST_3R2b("align", mem[6], mem[6], t0, t1, t2, 0)
   TEST_3R2b("align", mem[6], mem[6], t0, t1, t2, 1)
   TEST_3R2b("align", mem[6], mem[6], t0, t1, t2, 2)
   TEST_3R2b("align", mem[6], mem[6], t0, t1, t2, 3)
   TEST_3R2b("align", mem[6], mem[7], t1, t2, t0, 0)
   TEST_3R2b("align", mem[6], mem[7], t1, t2, t0, 1)
   TEST_3R2b("align", mem[6], mem[7], t1, t2, t0, 2)
   TEST_3R2b("align", mem[6], mem[7], t1, t2, t0, 3)
   TEST_3R2b("align", mem[6], mem[8], t2, t0, t1, 0)
   TEST_3R2b("align", mem[6], mem[8], t2, t0, t1, 1)
   TEST_3R2b("align", mem[6], mem[8], t2, t0, t1, 2)
   TEST_3R2b("align", mem[6], mem[8], t2, t0, t1, 3)
   TEST_3R2b("align", mem[6], mem[9], t0, t1, t2, 0)
   TEST_3R2b("align", mem[6], mem[9], t0, t1, t2, 1)
   TEST_3R2b("align", mem[6], mem[9], t0, t1, t2, 2)
   TEST_3R2b("align", mem[6], mem[9], t0, t1, t2, 3)
   TEST_3R2b("align", mem[6], mem[10], t1, t2, t0, 0)
   TEST_3R2b("align", mem[6], mem[10], t1, t2, t0, 1)
   TEST_3R2b("align", mem[6], mem[10], t1, t2, t0, 2)
   TEST_3R2b("align", mem[6], mem[10], t1, t2, t0, 3)
   TEST_3R2b("align", mem[6], mem[11], t2, t0, t1, 0)
   TEST_3R2b("align", mem[6], mem[11], t2, t0, t1, 1)
   TEST_3R2b("align", mem[6], mem[11], t2, t0, t1, 2)
   TEST_3R2b("align", mem[6], mem[11], t2, t0, t1, 3)
   TEST_3R2b("align", mem[7], mem[0], t1, t2, t0, 0)
   TEST_3R2b("align", mem[7], mem[0], t1, t2, t0, 1)
   TEST_3R2b("align", mem[7], mem[0], t1, t2, t0, 2)
   TEST_3R2b("align", mem[7], mem[0], t1, t2, t0, 3)
   TEST_3R2b("align", mem[7], mem[1], t2, t0, t1, 0)
   TEST_3R2b("align", mem[7], mem[1], t2, t0, t1, 1)
   TEST_3R2b("align", mem[7], mem[1], t2, t0, t1, 2)
   TEST_3R2b("align", mem[7], mem[1], t2, t0, t1, 3)
   TEST_3R2b("align", mem[7], mem[2], t0, t1, t2, 0)
   TEST_3R2b("align", mem[7], mem[2], t0, t1, t2, 1)
   TEST_3R2b("align", mem[7], mem[2], t0, t1, t2, 2)
   TEST_3R2b("align", mem[7], mem[2], t0, t1, t2, 3)
   TEST_3R2b("align", mem[7], mem[3], t1, t2, t0, 0)
   TEST_3R2b("align", mem[7], mem[3], t1, t2, t0, 1)
   TEST_3R2b("align", mem[7], mem[3], t1, t2, t0, 2)
   TEST_3R2b("align", mem[7], mem[3], t1, t2, t0, 3)
   TEST_3R2b("align", mem[7], mem[4], t2, t0, t1, 0)
   TEST_3R2b("align", mem[7], mem[4], t2, t0, t1, 1)
   TEST_3R2b("align", mem[7], mem[4], t2, t0, t1, 2)
   TEST_3R2b("align", mem[7], mem[4], t2, t0, t1, 3)
   TEST_3R2b("align", mem[7], mem[5], t0, t1, t2, 0)
   TEST_3R2b("align", mem[7], mem[5], t0, t1, t2, 1)
   TEST_3R2b("align", mem[7], mem[5], t0, t1, t2, 2)
   TEST_3R2b("align", mem[7], mem[5], t0, t1, t2, 3)
   TEST_3R2b("align", mem[7], mem[6], t1, t2, t0, 0)
   TEST_3R2b("align", mem[7], mem[6], t1, t2, t0, 1)
   TEST_3R2b("align", mem[7], mem[6], t1, t2, t0, 2)
   TEST_3R2b("align", mem[7], mem[6], t1, t2, t0, 3)
   TEST_3R2b("align", mem[7], mem[7], t2, t0, t1, 0)
   TEST_3R2b("align", mem[7], mem[7], t2, t0, t1, 1)
   TEST_3R2b("align", mem[7], mem[7], t2, t0, t1, 2)
   TEST_3R2b("align", mem[7], mem[7], t2, t0, t1, 3)
   TEST_3R2b("align", mem[7], mem[8], t0, t1, t2, 0)
   TEST_3R2b("align", mem[7], mem[8], t0, t1, t2, 1)
   TEST_3R2b("align", mem[7], mem[8], t0, t1, t2, 2)
   TEST_3R2b("align", mem[7], mem[8], t0, t1, t2, 3)
   TEST_3R2b("align", mem[7], mem[9], t1, t2, t0, 0)
   TEST_3R2b("align", mem[7], mem[9], t1, t2, t0, 1)
   TEST_3R2b("align", mem[7], mem[9], t1, t2, t0, 2)
   TEST_3R2b("align", mem[7], mem[9], t1, t2, t0, 3)
   TEST_3R2b("align", mem[7], mem[10], t2, t0, t1, 0)
   TEST_3R2b("align", mem[7], mem[10], t2, t0, t1, 1)
   TEST_3R2b("align", mem[7], mem[10], t2, t0, t1, 2)
   TEST_3R2b("align", mem[7], mem[10], t2, t0, t1, 3)
   TEST_3R2b("align", mem[7], mem[11], t0, t1, t2, 0)
   TEST_3R2b("align", mem[7], mem[11], t0, t1, t2, 1)
   TEST_3R2b("align", mem[7], mem[11], t0, t1, t2, 2)
   TEST_3R2b("align", mem[7], mem[11], t0, t1, t2, 3)
   TEST_3R2b("align", mem[8], mem[0], t2, t0, t1, 0)
   TEST_3R2b("align", mem[8], mem[0], t2, t0, t1, 1)
   TEST_3R2b("align", mem[8], mem[0], t2, t0, t1, 2)
   TEST_3R2b("align", mem[8], mem[0], t2, t0, t1, 3)
   TEST_3R2b("align", mem[8], mem[1], t0, t1, t2, 0)
   TEST_3R2b("align", mem[8], mem[1], t0, t1, t2, 1)
   TEST_3R2b("align", mem[8], mem[1], t0, t1, t2, 2)
   TEST_3R2b("align", mem[8], mem[1], t0, t1, t2, 3)
   TEST_3R2b("align", mem[8], mem[2], t1, t2, t0, 0)
   TEST_3R2b("align", mem[8], mem[2], t1, t2, t0, 1)
   TEST_3R2b("align", mem[8], mem[2], t1, t2, t0, 2)
   TEST_3R2b("align", mem[8], mem[2], t1, t2, t0, 3)
   TEST_3R2b("align", mem[8], mem[3], t2, t0, t1, 0)
   TEST_3R2b("align", mem[8], mem[3], t2, t0, t1, 1)
   TEST_3R2b("align", mem[8], mem[3], t2, t0, t1, 2)
   TEST_3R2b("align", mem[8], mem[3], t2, t0, t1, 3)
   TEST_3R2b("align", mem[8], mem[4], t0, t1, t2, 0)
   TEST_3R2b("align", mem[8], mem[4], t0, t1, t2, 1)
   TEST_3R2b("align", mem[8], mem[4], t0, t1, t2, 2)
   TEST_3R2b("align", mem[8], mem[4], t0, t1, t2, 3)
   TEST_3R2b("align", mem[8], mem[5], t1, t2, t0, 0)
   TEST_3R2b("align", mem[8], mem[5], t1, t2, t0, 1)
   TEST_3R2b("align", mem[8], mem[5], t1, t2, t0, 2)
   TEST_3R2b("align", mem[8], mem[5], t1, t2, t0, 3)
   TEST_3R2b("align", mem[8], mem[6], t2, t0, t1, 0)
   TEST_3R2b("align", mem[8], mem[6], t2, t0, t1, 1)
   TEST_3R2b("align", mem[8], mem[6], t2, t0, t1, 2)
   TEST_3R2b("align", mem[8], mem[6], t2, t0, t1, 3)
   TEST_3R2b("align", mem[8], mem[7], t0, t1, t2, 0)
   TEST_3R2b("align", mem[8], mem[7], t0, t1, t2, 1)
   TEST_3R2b("align", mem[8], mem[7], t0, t1, t2, 2)
   TEST_3R2b("align", mem[8], mem[7], t0, t1, t2, 3)
   TEST_3R2b("align", mem[8], mem[8], t1, t2, t0, 0)
   TEST_3R2b("align", mem[8], mem[8], t1, t2, t0, 1)
   TEST_3R2b("align", mem[8], mem[8], t1, t2, t0, 2)
   TEST_3R2b("align", mem[8], mem[8], t1, t2, t0, 3)
   TEST_3R2b("align", mem[8], mem[9], t2, t0, t1, 0)
   TEST_3R2b("align", mem[8], mem[9], t2, t0, t1, 1)
   TEST_3R2b("align", mem[8], mem[9], t2, t0, t1, 2)
   TEST_3R2b("align", mem[8], mem[9], t2, t0, t1, 3)
   TEST_3R2b("align", mem[8], mem[10], t0, t1, t2, 0)
   TEST_3R2b("align", mem[8], mem[10], t0, t1, t2, 1)
   TEST_3R2b("align", mem[8], mem[10], t0, t1, t2, 2)
   TEST_3R2b("align", mem[8], mem[10], t0, t1, t2, 3)
   TEST_3R2b("align", mem[8], mem[11], t1, t2, t0, 0)
   TEST_3R2b("align", mem[8], mem[11], t1, t2, t0, 1)
   TEST_3R2b("align", mem[8], mem[11], t1, t2, t0, 2)
   TEST_3R2b("align", mem[8], mem[11], t1, t2, t0, 3)
   TEST_3R2b("align", mem[9], mem[0], t0, t1, t2, 0)
   TEST_3R2b("align", mem[9], mem[0], t0, t1, t2, 1)
   TEST_3R2b("align", mem[9], mem[0], t0, t1, t2, 2)
   TEST_3R2b("align", mem[9], mem[0], t0, t1, t2, 3)
   TEST_3R2b("align", mem[9], mem[1], t1, t2, t0, 0)
   TEST_3R2b("align", mem[9], mem[1], t1, t2, t0, 1)
   TEST_3R2b("align", mem[9], mem[1], t1, t2, t0, 2)
   TEST_3R2b("align", mem[9], mem[1], t1, t2, t0, 3)
   TEST_3R2b("align", mem[9], mem[2], t2, t0, t1, 0)
   TEST_3R2b("align", mem[9], mem[2], t2, t0, t1, 1)
   TEST_3R2b("align", mem[9], mem[2], t2, t0, t1, 2)
   TEST_3R2b("align", mem[9], mem[2], t2, t0, t1, 3)
   TEST_3R2b("align", mem[9], mem[3], t0, t1, t2, 0)
   TEST_3R2b("align", mem[9], mem[3], t0, t1, t2, 1)
   TEST_3R2b("align", mem[9], mem[3], t0, t1, t2, 2)
   TEST_3R2b("align", mem[9], mem[3], t0, t1, t2, 3)
   TEST_3R2b("align", mem[9], mem[4], t1, t2, t0, 0)
   TEST_3R2b("align", mem[9], mem[4], t1, t2, t0, 1)
   TEST_3R2b("align", mem[9], mem[4], t1, t2, t0, 2)
   TEST_3R2b("align", mem[9], mem[4], t1, t2, t0, 3)
   TEST_3R2b("align", mem[9], mem[5], t2, t0, t1, 0)
   TEST_3R2b("align", mem[9], mem[5], t2, t0, t1, 1)
   TEST_3R2b("align", mem[9], mem[5], t2, t0, t1, 2)
   TEST_3R2b("align", mem[9], mem[5], t2, t0, t1, 3)
   TEST_3R2b("align", mem[9], mem[6], t0, t1, t2, 0)
   TEST_3R2b("align", mem[9], mem[6], t0, t1, t2, 1)
   TEST_3R2b("align", mem[9], mem[6], t0, t1, t2, 2)
   TEST_3R2b("align", mem[9], mem[6], t0, t1, t2, 3)
   TEST_3R2b("align", mem[9], mem[7], t1, t2, t0, 0)
   TEST_3R2b("align", mem[9], mem[7], t1, t2, t0, 1)
   TEST_3R2b("align", mem[9], mem[7], t1, t2, t0, 2)
   TEST_3R2b("align", mem[9], mem[7], t1, t2, t0, 3)
   TEST_3R2b("align", mem[9], mem[8], t2, t0, t1, 0)
   TEST_3R2b("align", mem[9], mem[8], t2, t0, t1, 1)
   TEST_3R2b("align", mem[9], mem[8], t2, t0, t1, 2)
   TEST_3R2b("align", mem[9], mem[8], t2, t0, t1, 3)
   TEST_3R2b("align", mem[9], mem[9], t0, t1, t2, 0)
   TEST_3R2b("align", mem[9], mem[9], t0, t1, t2, 1)
   TEST_3R2b("align", mem[9], mem[9], t0, t1, t2, 2)
   TEST_3R2b("align", mem[9], mem[9], t0, t1, t2, 3)
   TEST_3R2b("align", mem[9], mem[10], t1, t2, t0, 0)
   TEST_3R2b("align", mem[9], mem[10], t1, t2, t0, 1)
   TEST_3R2b("align", mem[9], mem[10], t1, t2, t0, 2)
   TEST_3R2b("align", mem[9], mem[10], t1, t2, t0, 3)
   TEST_3R2b("align", mem[9], mem[11], t2, t0, t1, 0)
   TEST_3R2b("align", mem[9], mem[11], t2, t0, t1, 1)
   TEST_3R2b("align", mem[9], mem[11], t2, t0, t1, 2)
   TEST_3R2b("align", mem[9], mem[11], t2, t0, t1, 3)
   TEST_3R2b("align", mem[10], mem[0], t1, t2, t0, 0)
   TEST_3R2b("align", mem[10], mem[0], t1, t2, t0, 1)
   TEST_3R2b("align", mem[10], mem[0], t1, t2, t0, 2)
   TEST_3R2b("align", mem[10], mem[0], t1, t2, t0, 3)
   TEST_3R2b("align", mem[10], mem[1], t2, t0, t1, 0)
   TEST_3R2b("align", mem[10], mem[1], t2, t0, t1, 1)
   TEST_3R2b("align", mem[10], mem[1], t2, t0, t1, 2)
   TEST_3R2b("align", mem[10], mem[1], t2, t0, t1, 3)
   TEST_3R2b("align", mem[10], mem[2], t0, t1, t2, 0)
   TEST_3R2b("align", mem[10], mem[2], t0, t1, t2, 1)
   TEST_3R2b("align", mem[10], mem[2], t0, t1, t2, 2)
   TEST_3R2b("align", mem[10], mem[2], t0, t1, t2, 3)
   TEST_3R2b("align", mem[10], mem[3], t1, t2, t0, 0)
   TEST_3R2b("align", mem[10], mem[3], t1, t2, t0, 1)
   TEST_3R2b("align", mem[10], mem[3], t1, t2, t0, 2)
   TEST_3R2b("align", mem[10], mem[3], t1, t2, t0, 3)
   TEST_3R2b("align", mem[10], mem[4], t2, t0, t1, 0)
   TEST_3R2b("align", mem[10], mem[4], t2, t0, t1, 1)
   TEST_3R2b("align", mem[10], mem[4], t2, t0, t1, 2)
   TEST_3R2b("align", mem[10], mem[4], t2, t0, t1, 3)
   TEST_3R2b("align", mem[10], mem[5], t0, t1, t2, 0)
   TEST_3R2b("align", mem[10], mem[5], t0, t1, t2, 1)
   TEST_3R2b("align", mem[10], mem[5], t0, t1, t2, 2)
   TEST_3R2b("align", mem[10], mem[5], t0, t1, t2, 3)
   TEST_3R2b("align", mem[10], mem[6], t1, t2, t0, 0)
   TEST_3R2b("align", mem[10], mem[6], t1, t2, t0, 1)
   TEST_3R2b("align", mem[10], mem[6], t1, t2, t0, 2)
   TEST_3R2b("align", mem[10], mem[6], t1, t2, t0, 3)
   TEST_3R2b("align", mem[10], mem[7], t2, t0, t1, 0)
   TEST_3R2b("align", mem[10], mem[7], t2, t0, t1, 1)
   TEST_3R2b("align", mem[10], mem[7], t2, t0, t1, 2)
   TEST_3R2b("align", mem[10], mem[7], t2, t0, t1, 3)
   TEST_3R2b("align", mem[10], mem[8], t0, t1, t2, 0)
   TEST_3R2b("align", mem[10], mem[8], t0, t1, t2, 1)
   TEST_3R2b("align", mem[10], mem[8], t0, t1, t2, 2)
   TEST_3R2b("align", mem[10], mem[8], t0, t1, t2, 3)
   TEST_3R2b("align", mem[10], mem[9], t1, t2, t0, 0)
   TEST_3R2b("align", mem[10], mem[9], t1, t2, t0, 1)
   TEST_3R2b("align", mem[10], mem[9], t1, t2, t0, 2)
   TEST_3R2b("align", mem[10], mem[9], t1, t2, t0, 3)
   TEST_3R2b("align", mem[10], mem[10], t2, t0, t1, 0)
   TEST_3R2b("align", mem[10], mem[10], t2, t0, t1, 1)
   TEST_3R2b("align", mem[10], mem[10], t2, t0, t1, 2)
   TEST_3R2b("align", mem[10], mem[10], t2, t0, t1, 3)
   TEST_3R2b("align", mem[10], mem[11], t0, t1, t2, 0)
   TEST_3R2b("align", mem[10], mem[11], t0, t1, t2, 1)
   TEST_3R2b("align", mem[10], mem[11], t0, t1, t2, 2)
   TEST_3R2b("align", mem[10], mem[11], t0, t1, t2, 3)
   TEST_3R2b("align", mem[11], mem[0], t2, t0, t1, 0)
   TEST_3R2b("align", mem[11], mem[0], t2, t0, t1, 1)
   TEST_3R2b("align", mem[11], mem[0], t2, t0, t1, 2)
   TEST_3R2b("align", mem[11], mem[0], t2, t0, t1, 3)
   TEST_3R2b("align", mem[11], mem[1], t0, t1, t2, 0)
   TEST_3R2b("align", mem[11], mem[1], t0, t1, t2, 1)
   TEST_3R2b("align", mem[11], mem[1], t0, t1, t2, 2)
   TEST_3R2b("align", mem[11], mem[1], t0, t1, t2, 3)
   TEST_3R2b("align", mem[11], mem[2], t1, t2, t0, 0)
   TEST_3R2b("align", mem[11], mem[2], t1, t2, t0, 1)
   TEST_3R2b("align", mem[11], mem[2], t1, t2, t0, 2)
   TEST_3R2b("align", mem[11], mem[2], t1, t2, t0, 3)
   TEST_3R2b("align", mem[11], mem[3], t2, t0, t1, 0)
   TEST_3R2b("align", mem[11], mem[3], t2, t0, t1, 1)
   TEST_3R2b("align", mem[11], mem[3], t2, t0, t1, 2)
   TEST_3R2b("align", mem[11], mem[3], t2, t0, t1, 3)
   TEST_3R2b("align", mem[11], mem[4], t0, t1, t2, 0)
   TEST_3R2b("align", mem[11], mem[4], t0, t1, t2, 1)
   TEST_3R2b("align", mem[11], mem[4], t0, t1, t2, 2)
   TEST_3R2b("align", mem[11], mem[4], t0, t1, t2, 3)
   TEST_3R2b("align", mem[11], mem[5], t1, t2, t0, 0)
   TEST_3R2b("align", mem[11], mem[5], t1, t2, t0, 1)
   TEST_3R2b("align", mem[11], mem[5], t1, t2, t0, 2)
   TEST_3R2b("align", mem[11], mem[5], t1, t2, t0, 3)
   TEST_3R2b("align", mem[11], mem[6], t2, t0, t1, 0)
   TEST_3R2b("align", mem[11], mem[6], t2, t0, t1, 1)
   TEST_3R2b("align", mem[11], mem[6], t2, t0, t1, 2)
   TEST_3R2b("align", mem[11], mem[6], t2, t0, t1, 3)
   TEST_3R2b("align", mem[11], mem[7], t0, t1, t2, 0)
   TEST_3R2b("align", mem[11], mem[7], t0, t1, t2, 1)
   TEST_3R2b("align", mem[11], mem[7], t0, t1, t2, 2)
   TEST_3R2b("align", mem[11], mem[7], t0, t1, t2, 3)
   TEST_3R2b("align", mem[11], mem[8], t1, t2, t0, 0)
   TEST_3R2b("align", mem[11], mem[8], t1, t2, t0, 1)
   TEST_3R2b("align", mem[11], mem[8], t1, t2, t0, 2)
   TEST_3R2b("align", mem[11], mem[8], t1, t2, t0, 3)
   TEST_3R2b("align", mem[11], mem[9], t2, t0, t1, 0)
   TEST_3R2b("align", mem[11], mem[9], t2, t0, t1, 1)
   TEST_3R2b("align", mem[11], mem[9], t2, t0, t1, 2)
   TEST_3R2b("align", mem[11], mem[9], t2, t0, t1, 3)
   TEST_3R2b("align", mem[11], mem[10], t0, t1, t2, 0)
   TEST_3R2b("align", mem[11], mem[10], t0, t1, t2, 1)
   TEST_3R2b("align", mem[11], mem[10], t0, t1, t2, 2)
   TEST_3R2b("align", mem[11], mem[10], t0, t1, t2, 3)
   TEST_3R2b("align", mem[11], mem[11], t1, t2, t0, 0)
   TEST_3R2b("align", mem[11], mem[11], t1, t2, t0, 1)
   TEST_3R2b("align", mem[11], mem[11], t1, t2, t0, 2)
   TEST_3R2b("align", mem[11], mem[11], t1, t2, t0, 3)

   printf("\nlsa\n");
   TEST_3R2b("lsa", mem[0], mem[0], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[0], mem[0], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[0], mem[0], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[0], mem[0], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[0], mem[1], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[0], mem[1], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[0], mem[1], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[0], mem[1], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[0], mem[2], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[0], mem[2], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[0], mem[2], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[0], mem[2], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[0], mem[3], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[0], mem[3], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[0], mem[3], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[0], mem[3], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[0], mem[4], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[0], mem[4], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[0], mem[4], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[0], mem[4], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[0], mem[5], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[0], mem[5], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[0], mem[5], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[0], mem[5], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[0], mem[6], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[0], mem[6], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[0], mem[6], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[0], mem[6], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[0], mem[7], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[0], mem[7], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[0], mem[7], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[0], mem[7], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[0], mem[8], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[0], mem[8], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[0], mem[8], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[0], mem[8], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[0], mem[9], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[0], mem[9], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[0], mem[9], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[0], mem[9], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[0], mem[10], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[0], mem[10], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[0], mem[10], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[0], mem[10], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[0], mem[11], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[0], mem[11], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[0], mem[11], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[0], mem[11], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[1], mem[0], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[1], mem[0], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[1], mem[0], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[1], mem[0], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[1], mem[1], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[1], mem[1], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[1], mem[1], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[1], mem[1], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[1], mem[2], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[1], mem[2], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[1], mem[2], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[1], mem[2], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[1], mem[3], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[1], mem[3], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[1], mem[3], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[1], mem[3], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[1], mem[4], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[1], mem[4], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[1], mem[4], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[1], mem[4], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[1], mem[5], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[1], mem[5], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[1], mem[5], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[1], mem[5], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[1], mem[6], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[1], mem[6], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[1], mem[6], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[1], mem[6], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[1], mem[7], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[1], mem[7], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[1], mem[7], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[1], mem[7], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[1], mem[8], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[1], mem[8], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[1], mem[8], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[1], mem[8], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[1], mem[9], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[1], mem[9], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[1], mem[9], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[1], mem[9], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[1], mem[10], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[1], mem[10], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[1], mem[10], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[1], mem[10], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[1], mem[11], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[1], mem[11], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[1], mem[11], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[1], mem[11], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[2], mem[0], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[2], mem[0], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[2], mem[0], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[2], mem[0], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[2], mem[1], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[2], mem[1], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[2], mem[1], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[2], mem[1], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[2], mem[2], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[2], mem[2], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[2], mem[2], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[2], mem[2], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[2], mem[3], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[2], mem[3], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[2], mem[3], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[2], mem[3], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[2], mem[4], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[2], mem[4], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[2], mem[4], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[2], mem[4], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[2], mem[5], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[2], mem[5], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[2], mem[5], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[2], mem[5], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[2], mem[6], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[2], mem[6], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[2], mem[6], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[2], mem[6], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[2], mem[7], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[2], mem[7], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[2], mem[7], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[2], mem[7], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[2], mem[8], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[2], mem[8], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[2], mem[8], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[2], mem[8], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[2], mem[9], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[2], mem[9], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[2], mem[9], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[2], mem[9], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[2], mem[10], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[2], mem[10], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[2], mem[10], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[2], mem[10], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[2], mem[11], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[2], mem[11], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[2], mem[11], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[2], mem[11], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[3], mem[0], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[3], mem[0], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[3], mem[0], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[3], mem[0], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[3], mem[1], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[3], mem[1], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[3], mem[1], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[3], mem[1], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[3], mem[2], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[3], mem[2], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[3], mem[2], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[3], mem[2], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[3], mem[3], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[3], mem[3], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[3], mem[3], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[3], mem[3], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[3], mem[4], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[3], mem[4], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[3], mem[4], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[3], mem[4], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[3], mem[5], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[3], mem[5], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[3], mem[5], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[3], mem[5], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[3], mem[6], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[3], mem[6], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[3], mem[6], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[3], mem[6], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[3], mem[7], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[3], mem[7], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[3], mem[7], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[3], mem[7], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[3], mem[8], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[3], mem[8], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[3], mem[8], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[3], mem[8], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[3], mem[9], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[3], mem[9], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[3], mem[9], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[3], mem[9], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[3], mem[10], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[3], mem[10], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[3], mem[10], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[3], mem[10], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[3], mem[11], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[3], mem[11], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[3], mem[11], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[3], mem[11], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[4], mem[0], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[4], mem[0], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[4], mem[0], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[4], mem[0], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[4], mem[1], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[4], mem[1], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[4], mem[1], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[4], mem[1], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[4], mem[2], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[4], mem[2], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[4], mem[2], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[4], mem[2], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[4], mem[3], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[4], mem[3], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[4], mem[3], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[4], mem[3], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[4], mem[4], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[4], mem[4], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[4], mem[4], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[4], mem[4], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[4], mem[5], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[4], mem[5], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[4], mem[5], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[4], mem[5], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[4], mem[6], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[4], mem[6], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[4], mem[6], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[4], mem[6], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[4], mem[7], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[4], mem[7], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[4], mem[7], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[4], mem[7], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[4], mem[8], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[4], mem[8], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[4], mem[8], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[4], mem[8], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[4], mem[9], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[4], mem[9], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[4], mem[9], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[4], mem[9], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[4], mem[10], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[4], mem[10], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[4], mem[10], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[4], mem[10], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[4], mem[11], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[4], mem[11], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[4], mem[11], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[4], mem[11], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[5], mem[0], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[5], mem[0], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[5], mem[0], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[5], mem[0], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[5], mem[1], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[5], mem[1], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[5], mem[1], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[5], mem[1], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[5], mem[2], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[5], mem[2], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[5], mem[2], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[5], mem[2], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[5], mem[3], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[5], mem[3], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[5], mem[3], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[5], mem[3], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[5], mem[4], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[5], mem[4], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[5], mem[4], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[5], mem[4], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[5], mem[5], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[5], mem[5], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[5], mem[5], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[5], mem[5], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[5], mem[6], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[5], mem[6], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[5], mem[6], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[5], mem[6], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[5], mem[7], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[5], mem[7], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[5], mem[7], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[5], mem[7], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[5], mem[8], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[5], mem[8], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[5], mem[8], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[5], mem[8], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[5], mem[9], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[5], mem[9], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[5], mem[9], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[5], mem[9], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[5], mem[10], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[5], mem[10], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[5], mem[10], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[5], mem[10], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[5], mem[11], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[5], mem[11], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[5], mem[11], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[5], mem[11], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[6], mem[0], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[6], mem[0], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[6], mem[0], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[6], mem[0], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[6], mem[1], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[6], mem[1], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[6], mem[1], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[6], mem[1], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[6], mem[2], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[6], mem[2], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[6], mem[2], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[6], mem[2], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[6], mem[3], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[6], mem[3], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[6], mem[3], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[6], mem[3], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[6], mem[4], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[6], mem[4], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[6], mem[4], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[6], mem[4], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[6], mem[5], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[6], mem[5], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[6], mem[5], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[6], mem[5], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[6], mem[6], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[6], mem[6], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[6], mem[6], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[6], mem[6], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[6], mem[7], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[6], mem[7], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[6], mem[7], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[6], mem[7], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[6], mem[8], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[6], mem[8], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[6], mem[8], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[6], mem[8], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[6], mem[9], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[6], mem[9], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[6], mem[9], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[6], mem[9], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[6], mem[10], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[6], mem[10], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[6], mem[10], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[6], mem[10], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[6], mem[11], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[6], mem[11], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[6], mem[11], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[6], mem[11], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[7], mem[0], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[7], mem[0], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[7], mem[0], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[7], mem[0], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[7], mem[1], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[7], mem[1], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[7], mem[1], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[7], mem[1], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[7], mem[2], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[7], mem[2], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[7], mem[2], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[7], mem[2], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[7], mem[3], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[7], mem[3], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[7], mem[3], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[7], mem[3], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[7], mem[4], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[7], mem[4], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[7], mem[4], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[7], mem[4], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[7], mem[5], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[7], mem[5], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[7], mem[5], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[7], mem[5], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[7], mem[6], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[7], mem[6], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[7], mem[6], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[7], mem[6], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[7], mem[7], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[7], mem[7], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[7], mem[7], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[7], mem[7], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[7], mem[8], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[7], mem[8], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[7], mem[8], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[7], mem[8], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[7], mem[9], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[7], mem[9], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[7], mem[9], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[7], mem[9], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[7], mem[10], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[7], mem[10], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[7], mem[10], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[7], mem[10], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[7], mem[11], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[7], mem[11], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[7], mem[11], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[7], mem[11], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[8], mem[0], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[8], mem[0], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[8], mem[0], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[8], mem[0], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[8], mem[1], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[8], mem[1], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[8], mem[1], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[8], mem[1], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[8], mem[2], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[8], mem[2], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[8], mem[2], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[8], mem[2], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[8], mem[3], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[8], mem[3], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[8], mem[3], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[8], mem[3], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[8], mem[4], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[8], mem[4], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[8], mem[4], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[8], mem[4], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[8], mem[5], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[8], mem[5], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[8], mem[5], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[8], mem[5], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[8], mem[6], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[8], mem[6], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[8], mem[6], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[8], mem[6], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[8], mem[7], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[8], mem[7], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[8], mem[7], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[8], mem[7], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[8], mem[8], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[8], mem[8], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[8], mem[8], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[8], mem[8], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[8], mem[9], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[8], mem[9], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[8], mem[9], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[8], mem[9], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[8], mem[10], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[8], mem[10], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[8], mem[10], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[8], mem[10], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[8], mem[11], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[8], mem[11], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[8], mem[11], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[8], mem[11], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[9], mem[0], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[9], mem[0], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[9], mem[0], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[9], mem[0], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[9], mem[1], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[9], mem[1], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[9], mem[1], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[9], mem[1], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[9], mem[2], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[9], mem[2], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[9], mem[2], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[9], mem[2], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[9], mem[3], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[9], mem[3], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[9], mem[3], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[9], mem[3], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[9], mem[4], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[9], mem[4], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[9], mem[4], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[9], mem[4], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[9], mem[5], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[9], mem[5], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[9], mem[5], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[9], mem[5], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[9], mem[6], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[9], mem[6], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[9], mem[6], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[9], mem[6], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[9], mem[7], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[9], mem[7], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[9], mem[7], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[9], mem[7], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[9], mem[8], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[9], mem[8], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[9], mem[8], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[9], mem[8], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[9], mem[9], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[9], mem[9], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[9], mem[9], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[9], mem[9], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[9], mem[10], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[9], mem[10], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[9], mem[10], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[9], mem[10], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[9], mem[11], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[9], mem[11], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[9], mem[11], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[9], mem[11], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[10], mem[0], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[10], mem[0], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[10], mem[0], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[10], mem[0], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[10], mem[1], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[10], mem[1], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[10], mem[1], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[10], mem[1], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[10], mem[2], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[10], mem[2], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[10], mem[2], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[10], mem[2], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[10], mem[3], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[10], mem[3], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[10], mem[3], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[10], mem[3], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[10], mem[4], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[10], mem[4], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[10], mem[4], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[10], mem[4], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[10], mem[5], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[10], mem[5], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[10], mem[5], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[10], mem[5], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[10], mem[6], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[10], mem[6], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[10], mem[6], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[10], mem[6], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[10], mem[7], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[10], mem[7], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[10], mem[7], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[10], mem[7], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[10], mem[8], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[10], mem[8], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[10], mem[8], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[10], mem[8], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[10], mem[9], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[10], mem[9], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[10], mem[9], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[10], mem[9], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[10], mem[10], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[10], mem[10], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[10], mem[10], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[10], mem[10], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[10], mem[11], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[10], mem[11], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[10], mem[11], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[10], mem[11], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[11], mem[0], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[11], mem[0], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[11], mem[0], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[11], mem[0], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[11], mem[1], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[11], mem[1], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[11], mem[1], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[11], mem[1], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[11], mem[2], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[11], mem[2], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[11], mem[2], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[11], mem[2], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[11], mem[3], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[11], mem[3], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[11], mem[3], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[11], mem[3], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[11], mem[4], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[11], mem[4], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[11], mem[4], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[11], mem[4], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[11], mem[5], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[11], mem[5], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[11], mem[5], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[11], mem[5], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[11], mem[6], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[11], mem[6], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[11], mem[6], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[11], mem[6], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[11], mem[7], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[11], mem[7], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[11], mem[7], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[11], mem[7], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[11], mem[8], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[11], mem[8], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[11], mem[8], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[11], mem[8], t1, t2, t0, 3)
   TEST_3R2b("lsa", mem[11], mem[9], t2, t0, t1, 4)
   TEST_3R2b("lsa", mem[11], mem[9], t2, t0, t1, 1)
   TEST_3R2b("lsa", mem[11], mem[9], t2, t0, t1, 2)
   TEST_3R2b("lsa", mem[11], mem[9], t2, t0, t1, 3)
   TEST_3R2b("lsa", mem[11], mem[10], t0, t1, t2, 4)
   TEST_3R2b("lsa", mem[11], mem[10], t0, t1, t2, 1)
   TEST_3R2b("lsa", mem[11], mem[10], t0, t1, t2, 2)
   TEST_3R2b("lsa", mem[11], mem[10], t0, t1, t2, 3)
   TEST_3R2b("lsa", mem[11], mem[11], t1, t2, t0, 4)
   TEST_3R2b("lsa", mem[11], mem[11], t1, t2, t0, 1)
   TEST_3R2b("lsa", mem[11], mem[11], t1, t2, t0, 2)
   TEST_3R2b("lsa", mem[11], mem[11], t1, t2, t0, 3)

   printf("\naui\n");
   TEST_2Rb("aui", mem[0], t0, t1, 2)
   TEST_2Rb("aui", mem[0], t1, t0, 4)
   TEST_2Rb("aui", mem[0], t0, t1, 8)
   TEST_2Rb("aui", mem[0], t1, t0, 16)
   TEST_2Rb("aui", mem[0], t0, t1, 32)
   TEST_2Rb("aui", mem[0], t1, t0, 64)
   TEST_2Rb("aui", mem[0], t0, t1, 128)
   TEST_2Rb("aui", mem[0], t1, t0, 256)
   TEST_2Rb("aui", mem[0], t0, t1, 512)
   TEST_2Rb("aui", mem[1], t1, t0, 2)
   TEST_2Rb("aui", mem[1], t0, t1, 4)
   TEST_2Rb("aui", mem[1], t1, t0, 8)
   TEST_2Rb("aui", mem[1], t0, t1, 16)
   TEST_2Rb("aui", mem[1], t1, t0, 32)
   TEST_2Rb("aui", mem[1], t0, t1, 64)
   TEST_2Rb("aui", mem[1], t1, t0, 128)
   TEST_2Rb("aui", mem[1], t0, t1, 256)
   TEST_2Rb("aui", mem[1], t1, t0, 512)
   TEST_2Rb("aui", mem[2], t0, t1, 2)
   TEST_2Rb("aui", mem[2], t1, t0, 4)
   TEST_2Rb("aui", mem[2], t0, t1, 8)
   TEST_2Rb("aui", mem[2], t1, t0, 16)
   TEST_2Rb("aui", mem[2], t0, t1, 32)
   TEST_2Rb("aui", mem[2], t1, t0, 64)
   TEST_2Rb("aui", mem[2], t0, t1, 128)
   TEST_2Rb("aui", mem[2], t1, t0, 256)
   TEST_2Rb("aui", mem[2], t0, t1, 512)
   TEST_2Rb("aui", mem[3], t1, t0, 2)
   TEST_2Rb("aui", mem[3], t0, t1, 4)
   TEST_2Rb("aui", mem[3], t1, t0, 8)
   TEST_2Rb("aui", mem[3], t0, t1, 16)
   TEST_2Rb("aui", mem[3], t1, t0, 32)
   TEST_2Rb("aui", mem[3], t0, t1, 64)
   TEST_2Rb("aui", mem[3], t1, t0, 128)
   TEST_2Rb("aui", mem[3], t0, t1, 256)
   TEST_2Rb("aui", mem[3], t1, t0, 512)
   TEST_2Rb("aui", mem[4], t0, t1, 2)
   TEST_2Rb("aui", mem[4], t1, t0, 4)
   TEST_2Rb("aui", mem[4], t0, t1, 8)
   TEST_2Rb("aui", mem[4], t1, t0, 16)
   TEST_2Rb("aui", mem[4], t0, t1, 32)
   TEST_2Rb("aui", mem[4], t1, t0, 64)
   TEST_2Rb("aui", mem[4], t0, t1, 128)
   TEST_2Rb("aui", mem[4], t1, t0, 256)
   TEST_2Rb("aui", mem[4], t0, t1, 512)
   TEST_2Rb("aui", mem[5], t1, t0, 2)
   TEST_2Rb("aui", mem[5], t0, t1, 4)
   TEST_2Rb("aui", mem[5], t1, t0, 8)
   TEST_2Rb("aui", mem[5], t0, t1, 16)
   TEST_2Rb("aui", mem[5], t1, t0, 32)
   TEST_2Rb("aui", mem[5], t0, t1, 64)
   TEST_2Rb("aui", mem[5], t1, t0, 128)
   TEST_2Rb("aui", mem[5], t0, t1, 256)
   TEST_2Rb("aui", mem[5], t1, t0, 512)
   TEST_2Rb("aui", mem[6], t0, t1, 2)
   TEST_2Rb("aui", mem[6], t1, t0, 4)
   TEST_2Rb("aui", mem[6], t0, t1, 8)
   TEST_2Rb("aui", mem[6], t1, t0, 16)
   TEST_2Rb("aui", mem[6], t0, t1, 32)
   TEST_2Rb("aui", mem[6], t1, t0, 64)
   TEST_2Rb("aui", mem[6], t0, t1, 128)
   TEST_2Rb("aui", mem[6], t1, t0, 256)
   TEST_2Rb("aui", mem[6], t0, t1, 512)
   TEST_2Rb("aui", mem[7], t1, t0, 2)
   TEST_2Rb("aui", mem[7], t0, t1, 4)
   TEST_2Rb("aui", mem[7], t1, t0, 8)
   TEST_2Rb("aui", mem[7], t0, t1, 16)
   TEST_2Rb("aui", mem[7], t1, t0, 32)
   TEST_2Rb("aui", mem[7], t0, t1, 64)
   TEST_2Rb("aui", mem[7], t1, t0, 128)
   TEST_2Rb("aui", mem[7], t0, t1, 256)
   TEST_2Rb("aui", mem[7], t1, t0, 512)
   TEST_2Rb("aui", mem[8], t0, t1, 2)
   TEST_2Rb("aui", mem[8], t1, t0, 4)
   TEST_2Rb("aui", mem[8], t0, t1, 8)
   TEST_2Rb("aui", mem[8], t1, t0, 16)
   TEST_2Rb("aui", mem[8], t0, t1, 32)
   TEST_2Rb("aui", mem[8], t1, t0, 64)
   TEST_2Rb("aui", mem[8], t0, t1, 128)
   TEST_2Rb("aui", mem[8], t1, t0, 256)
   TEST_2Rb("aui", mem[8], t0, t1, 512)
   TEST_2Rb("aui", mem[9], t1, t0, 2)
   TEST_2Rb("aui", mem[9], t0, t1, 4)
   TEST_2Rb("aui", mem[9], t1, t0, 8)
   TEST_2Rb("aui", mem[9], t0, t1, 16)
   TEST_2Rb("aui", mem[9], t1, t0, 32)
   TEST_2Rb("aui", mem[9], t0, t1, 64)
   TEST_2Rb("aui", mem[9], t1, t0, 128)
   TEST_2Rb("aui", mem[9], t0, t1, 256)
   TEST_2Rb("aui", mem[9], t1, t0, 512)
   TEST_2Rb("aui", mem[10], t0, t1, 2)
   TEST_2Rb("aui", mem[10], t1, t0, 4)
   TEST_2Rb("aui", mem[10], t0, t1, 8)
   TEST_2Rb("aui", mem[10], t1, t0, 16)
   TEST_2Rb("aui", mem[10], t0, t1, 32)
   TEST_2Rb("aui", mem[10], t1, t0, 64)
   TEST_2Rb("aui", mem[10], t0, t1, 128)
   TEST_2Rb("aui", mem[10], t1, t0, 256)
   TEST_2Rb("aui", mem[10], t0, t1, 512)
   TEST_2Rb("aui", mem[11], t1, t0, 2)
   TEST_2Rb("aui", mem[11], t0, t1, 4)
   TEST_2Rb("aui", mem[11], t1, t0, 8)
   TEST_2Rb("aui", mem[11], t0, t1, 16)
   TEST_2Rb("aui", mem[11], t1, t0, 32)
   TEST_2Rb("aui", mem[11], t0, t1, 64)
   TEST_2Rb("aui", mem[11], t1, t0, 128)
   TEST_2Rb("aui", mem[11], t0, t1, 256)
   TEST_2Rb("aui", mem[11], t1, t0, 512)

   printf("\nlui\n");
   TEST_Rb("lui", mem[0], t0, 2)
   TEST_Rb("lui", mem[0], t1, 4)
   TEST_Rb("lui", mem[0], t0, 8)
   TEST_Rb("lui", mem[0], t1, 16)
   TEST_Rb("lui", mem[0], t0, 32)
   TEST_Rb("lui", mem[0], t1, 64)
   TEST_Rb("lui", mem[0], t0, 128)
   TEST_Rb("lui", mem[0], t1, 256)
   TEST_Rb("lui", mem[0], t0, 512)
   TEST_Rb("lui", mem[1], t1, 2)
   TEST_Rb("lui", mem[1], t0, 4)
   TEST_Rb("lui", mem[1], t1, 8)
   TEST_Rb("lui", mem[1], t0, 16)
   TEST_Rb("lui", mem[1], t1, 32)
   TEST_Rb("lui", mem[1], t0, 64)
   TEST_Rb("lui", mem[1], t1, 128)
   TEST_Rb("lui", mem[1], t0, 256)
   TEST_Rb("lui", mem[1], t1, 512)
   TEST_Rb("lui", mem[2], t0, 2)
   TEST_Rb("lui", mem[2], t1, 4)
   TEST_Rb("lui", mem[2], t0, 8)
   TEST_Rb("lui", mem[2], t1, 16)
   TEST_Rb("lui", mem[2], t0, 32)
   TEST_Rb("lui", mem[2], t1, 64)
   TEST_Rb("lui", mem[2], t0, 128)
   TEST_Rb("lui", mem[2], t1, 256)
   TEST_Rb("lui", mem[2], t0, 512)
   TEST_Rb("lui", mem[3], t1, 2)
   TEST_Rb("lui", mem[3], t0, 4)
   TEST_Rb("lui", mem[3], t1, 8)
   TEST_Rb("lui", mem[3], t0, 16)
   TEST_Rb("lui", mem[3], t1, 32)
   TEST_Rb("lui", mem[3], t0, 64)
   TEST_Rb("lui", mem[3], t1, 128)
   TEST_Rb("lui", mem[3], t0, 256)
   TEST_Rb("lui", mem[3], t1, 512)
   TEST_Rb("lui", mem[4], t0, 2)
   TEST_Rb("lui", mem[4], t1, 4)
   TEST_Rb("lui", mem[4], t0, 8)
   TEST_Rb("lui", mem[4], t1, 16)
   TEST_Rb("lui", mem[4], t0, 32)
   TEST_Rb("lui", mem[4], t1, 64)
   TEST_Rb("lui", mem[4], t0, 128)
   TEST_Rb("lui", mem[4], t1, 256)
   TEST_Rb("lui", mem[4], t0, 512)
   TEST_Rb("lui", mem[5], t1, 2)
   TEST_Rb("lui", mem[5], t0, 4)
   TEST_Rb("lui", mem[5], t1, 8)
   TEST_Rb("lui", mem[5], t0, 16)
   TEST_Rb("lui", mem[5], t1, 32)
   TEST_Rb("lui", mem[5], t0, 64)
   TEST_Rb("lui", mem[5], t1, 128)
   TEST_Rb("lui", mem[5], t0, 256)
   TEST_Rb("lui", mem[5], t1, 512)
   TEST_Rb("lui", mem[6], t0, 2)
   TEST_Rb("lui", mem[6], t1, 4)
   TEST_Rb("lui", mem[6], t0, 8)
   TEST_Rb("lui", mem[6], t1, 16)
   TEST_Rb("lui", mem[6], t0, 32)
   TEST_Rb("lui", mem[6], t1, 64)
   TEST_Rb("lui", mem[6], t0, 128)
   TEST_Rb("lui", mem[6], t1, 256)
   TEST_Rb("lui", mem[6], t0, 512)
   TEST_Rb("lui", mem[7], t1, 2)
   TEST_Rb("lui", mem[7], t0, 4)
   TEST_Rb("lui", mem[7], t1, 8)
   TEST_Rb("lui", mem[7], t0, 16)
   TEST_Rb("lui", mem[7], t1, 32)
   TEST_Rb("lui", mem[7], t0, 64)
   TEST_Rb("lui", mem[7], t1, 128)
   TEST_Rb("lui", mem[7], t0, 256)
   TEST_Rb("lui", mem[7], t1, 512)
   TEST_Rb("lui", mem[8], t0, 2)
   TEST_Rb("lui", mem[8], t1, 4)
   TEST_Rb("lui", mem[8], t0, 8)
   TEST_Rb("lui", mem[8], t1, 16)
   TEST_Rb("lui", mem[8], t0, 32)
   TEST_Rb("lui", mem[8], t1, 64)
   TEST_Rb("lui", mem[8], t0, 128)
   TEST_Rb("lui", mem[8], t1, 256)
   TEST_Rb("lui", mem[8], t0, 512)
   TEST_Rb("lui", mem[9], t1, 2)
   TEST_Rb("lui", mem[9], t0, 4)
   TEST_Rb("lui", mem[9], t1, 8)
   TEST_Rb("lui", mem[9], t0, 16)
   TEST_Rb("lui", mem[9], t1, 32)
   TEST_Rb("lui", mem[9], t0, 64)
   TEST_Rb("lui", mem[9], t1, 128)
   TEST_Rb("lui", mem[9], t0, 256)
   TEST_Rb("lui", mem[9], t1, 512)
   TEST_Rb("lui", mem[10], t0, 2)
   TEST_Rb("lui", mem[10], t1, 4)
   TEST_Rb("lui", mem[10], t0, 8)
   TEST_Rb("lui", mem[10], t1, 16)
   TEST_Rb("lui", mem[10], t0, 32)
   TEST_Rb("lui", mem[10], t1, 64)
   TEST_Rb("lui", mem[10], t0, 128)
   TEST_Rb("lui", mem[10], t1, 256)
   TEST_Rb("lui", mem[10], t0, 512)
   TEST_Rb("lui", mem[11], t1, 2)
   TEST_Rb("lui", mem[11], t0, 4)
   TEST_Rb("lui", mem[11], t1, 8)
   TEST_Rb("lui", mem[11], t0, 16)
   TEST_Rb("lui", mem[11], t1, 32)
   TEST_Rb("lui", mem[11], t0, 64)
   TEST_Rb("lui", mem[11], t1, 128)
   TEST_Rb("lui", mem[11], t0, 256)
   TEST_Rb("lui", mem[11], t1, 512)

   printf("\nbitswap\n");
   TEST_2R("bitswap", mem[0], t0, t1);
   TEST_2R("bitswap", mem[1], t0, t1);
   TEST_2R("bitswap", mem[2], t0, t1);
   TEST_2R("bitswap", mem[3], t0, t1);
   TEST_2R("bitswap", mem[4], t0, t1);
   TEST_2R("bitswap", mem[5], t0, t1);
   TEST_2R("bitswap", mem[6], t0, t1);
   TEST_2R("bitswap", mem[7], t0, t1);
   TEST_2R("bitswap", mem[8], t0, t1);
   TEST_2R("bitswap", mem[9], t0, t1);
   TEST_2R("bitswap", mem[10], t0, t1);
   TEST_2R("bitswap", mem[11], t0, t1);
#endif

   return 0;
}

