// Locale support -*- C++ -*-

// Copyright (C) 1997-1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

// Warning: this file is not meant for user inclusion.  Use <locale>.

#ifndef _CPP_BITS_LOCFACETS_TCC
#define _CPP_BITS_LOCFACETS_TCC 1

#include <bits/std_vector.h>
#include <bits/std_cerrno.h>

namespace std
{
  // __match_parallel
  // matches input __s against a set of __ntargs strings in __targets,
  // placing in __matches a vector of indices into __targets which
  // match, and in __remain the number of such matches. If it hits
  // end of sequence before it minimizes the set, sets __eof.
  // Empty strings are never matched.
  template<typename _InIter, typename _CharT>
    _InIter 
    __match_parallel(_InIter __s, _InIter __end, int __ntargs, 
		     const basic_string<_CharT>* __targets,
		     int* __matches, int& __remain, bool& __eof)
    {
      typedef basic_string<_CharT> __string_type;
      __eof = false;
      for (int __ti = 0; __ti < __ntargs; ++__ti) 
	__matches[__ti] = __ti;
      __remain = __ntargs;
      size_t __pos = 0;
      do 
	{
	  {
	    int __ti = 0;
	    for (;__ti < __remain &&
		   __pos == __targets[__matches[__ti]].size(); ++__ti)
	      { }
	    if (__ti == __remain) 
	      {
		if (__pos == 0) __remain = 0;
		return __s;
	      }
	  }
	  if (__s == __end) 
	    __eof = true;
	  bool __matched = false;
	  for (int __ti = 0; __ti < __remain; ) 
	    {
	      const __string_type& __target = __targets[__matches[__ti]];
	      if (__pos < __target.size()) 
		{
		  if (__eof || __target[__pos] != *__s)
		    { 
		      __matches[__ti] = __matches[--__remain]; 
		      continue; 
		    }
		  __matched = true;
		}
	      ++__ti;
	    }
	  if (__matched) 
	    { 
	      ++__s; 
	      ++__pos; 
	    }
	  for (int __ti = 0; __ti < __remain;) 
	    {
	      if (__pos > __targets[__matches[__ti]].size())
		{ 
		  __matches[__ti] = __matches[--__remain]; 
		  continue; 
		}
	      ++__ti;
	    }
	} 
      while (__remain);
      return __s;
    }
  
  template<typename _CharT>
    locale::id ctype<_CharT>::id;

  template<typename _InternT, typename _ExternT, typename _StateT>
    locale::id  codecvt<_InternT,_ExternT,_StateT>::id;

  template<typename _CharT>
    int _Format_cache<_CharT>::_S_pword_ix;

  template<typename _CharT>
    const char _Format_cache<_CharT>::
    _S_literals[] = "-+xX0123456789abcdef0123456789ABCDEF";

  template<typename _CharT>
    _Format_cache<_CharT>::_Format_cache()
    : _M_valid(true), _M_use_grouping(false)
    { }

  template<>
    _Format_cache<char>::_Format_cache()
    : _M_valid(true), 
    _M_decimal_point('.'), _M_thousands_sep(','), 
    _M_truename("true"), _M_falsename("false"), _M_use_grouping(false)
    { }
 
  template<>
    _Format_cache<wchar_t>::_Format_cache()
    : _M_valid(true), 
    _M_decimal_point(L'.'), _M_thousands_sep(L','), 
    _M_truename(L"true"), _M_falsename(L"false"), _M_use_grouping(false)
    { }
  
  template<typename _CharT>
    void
    _Format_cache<_CharT>::_M_populate(ios_base& __io)
    {
      locale __loc = __io.getloc ();
      numpunct<_CharT> const& __np = use_facet<numpunct<_CharT> >(__loc);
      _M_truename = __np.truename();
      _M_falsename = __np.falsename();
      _M_thousands_sep = __np.thousands_sep();
      _M_decimal_point = __np.decimal_point();
      _M_grouping = __np.grouping();
      _M_use_grouping = _M_grouping.size() != 0 && _M_grouping.data()[0] != 0;
      _M_valid = true;
    }

  // This function is always called via a pointer installed in
  // an ios_base by ios_base::register_callback.
  template<typename _CharT>
    void
    _Format_cache<_CharT>::
    _S_callback(ios_base::event __ev, ios_base& __ios, int __ix) throw()
    {
      void*& __p = __ios.pword(__ix);
      switch (__ev)
	{
	case ios_base::erase_event:
	  delete static_cast<_Format_cache<_CharT>*> (__p); __p = 0;   
	  break;
	case ios_base::copyfmt_event:
	  // If just stored zero, the callback would get registered again.
	  try { 
	    __p = new _Format_cache<_CharT>; 
	  } 
	  catch(...) { 
	  }      
	  break;
	case ios_base::imbue_event:
	  static_cast<_Format_cache<_CharT>*>(__p)->_M_valid = false; 
	  break;
	}
    }
  
  template<typename _CharT>
    _Format_cache<_CharT>*
    _Format_cache<_CharT>::_S_get(ios_base& __ios)
    {
      if (!_S_pword_ix) 
	_S_pword_ix = ios_base::xalloc();  // XXX MT
      void*& __p = __ios.pword(_S_pword_ix);
      
      // XXX What if pword fails? must check failbit, throw.
      if (__p == 0)  // XXX MT?  maybe sentry takes care of it
	{
	  auto_ptr<_Format_cache<_CharT> > __ap(new _Format_cache<_CharT>);
	  __ios.register_callback(&_Format_cache<_CharT>::_S_callback,
				  _S_pword_ix);
	  __p = __ap.release();
	}
      _Format_cache<_CharT>* __ncp = static_cast<_Format_cache<_CharT>*>(__p);
      if (!__ncp->_M_valid) 
	__ncp->_M_populate(__ios);
      
      return __ncp;
    }

  template<typename _CharT, typename _InIter>
    locale::id num_get<_CharT, _InIter>::id;

  // This member function takes an (w)istreambuf_iterator object and
  // parses it into a generic char array suitable for parsing with
  // strto[l,ll,f,d]. The thought was to encapsulate the conversion
  // into this one function, and thus the num_get::do_get member
  // functions can just adjust for the type of the overloaded
  // argument and process the char array returned from _M_extract.
  // Other things were also considered, including a fused
  // multiply-add loop that would obviate the need for any call to
  // strto... at all: however, it would b e a bit of a pain, because
  // you'd have to be able to return either floating or integral
  // types, etc etc. The current approach seems to be smack dab in
  // the middle between an unoptimized approach using sscanf, and
  // some kind of hyper-optimized approach alluded to above.
  
  // XXX
  // Need to do partial specialization to account for differences
  // between character sets. For char, this is pretty
  // straightforward, but for wchar_t, the conversion to a plain-jane
  // char type is a bit more involved.
  template<typename _CharT, typename _InIter>
    void
    num_get<_CharT, _InIter>::    
    _M_extract(iter_type __beg, iter_type __end, ios_base& __io, 
	       ios_base::iostate& __err, char* __xtrc, int& __base) const
    {
      // XXX Not currently done: need to expand upon char version below.
    }

  template<>
    void
    num_get<char, istreambuf_iterator<char> >::    
    _M_extract(istreambuf_iterator<char> __beg, 
	       istreambuf_iterator<char> __end, ios_base& __io, 
	       ios_base::iostate& __err, char* __xtrc, int& __base) const
    {
      // Stage 1: determine a conversion specifier.
      ios_base::fmtflags __basefield = __io.flags() & ios_base::basefield;
      if (__basefield == ios_base::oct)
	__base = 8;
      else if (__basefield == ios_base::hex)
	__base = 16;
      else
	__base = 10;
      
      // Stage 2: extract characters.
      _Format_cache<char> const* __fmt =_Format_cache<char>::_S_get(__io);
      bool __valid = __beg != __end;
      string __grp;
      int __i;
      int __pos = 0;

      // XXX Need to deal with discarding leading zeros for non-octal numbers!
      for (__i = 0; __valid && __beg != __end; ++__i, ++__beg)
	{
	  __valid = false;
	  char __c = *__beg;
	  if (strchr(__fmt->_S_literals, __c))
	    {
	      __xtrc[__pos] = __c;
	      ++__pos;
	      __valid = true;
	    }
	  else if (__c == __fmt->_M_thousands_sep)
	    {
	      if (__fmt->_M_use_grouping)
		__grp += static_cast<char>(__i);
	      __valid = true;
	    }
	  else if (__c == __fmt->_M_decimal_point)
	    {
	      __xtrc[__pos] = '.';
	      ++__pos;
	      __valid = true;
	    }
	}
      __xtrc[__pos] = '\0';
      if (__beg == __end)
	__err |= ios_base::eofbit;
      
      // Digit grouping is checked. If _M_groupings() doesn't
      // match, then get very very upset, and set failbit.
      if (__fmt->_M_use_grouping && __grp != __fmt->_M_grouping)
	__err |= ios_base::failbit;
    }
  
  template<typename _CharT, typename _InIter>
    _InIter 
    num_get<_CharT, _InIter>::
    do_get(iter_type __beg, iter_type __end, ios_base& __io, 
	   ios_base::iostate& __err, bool& __v) const
    {
      // Parse bool values as long
      if (!(__io.flags() & ios_base::boolalpha))
	{
	  unsigned long __l = 0;
	  this->do_get(__beg, __end, __io, __err, __l);
	  if ((__err & ios_base::failbit) == 0)
	    {
	      if (__l <= 1) 
		__v = __l;
	      else 
		__err |= ios_base::failbit; 
	    }
	}
      
      // Parse bool values as alphanumeric
      else
	{
	  typedef _Format_cache<char_type> __fcache_type;
	  __fcache_type* __fmt = __fcache_type::_S_get(__io);
	  const char_type* __true = __fmt->_M_truename.c_str();
	  const char_type* __false = __fmt->_M_falsename.c_str();
	  int __name_len = max(sizeof(__false), sizeof(__true));
	  char_type __itrue[sizeof(__true)]; 
	  char_type __ifalse[sizeof(__false)];

	  bool __valid = __beg != __end;
	  int __pos = 0;
	  for (; __valid; ++__pos)
	    {
	      __valid = false;
	      char_type __c = *__beg++;
	      if (__c == __false[__pos])
		{
		  __ifalse[__pos] = __c;
		  __valid = true;
		  if (__pos == sizeof(__false) - sizeof(char_type))
		    {
		      __err |= ios_base::goodbit;
		      __v = 0;
		    }
		}
	      else if (__c == __true[__pos])
		{
		  __itrue[__pos] = __c;
		  __valid = true;
		  if (__pos == sizeof(__true) - sizeof(char_type))
		    {
		      __err |= ios_base::goodbit;
		      __v = 1;
		    }
		}
	    }

	  if (__beg == __end)
	    __err |= ios_base::eofbit;
	  
	  if (!((__err & ios_base::goodbit) == 0 || __err & ios_base::eofbit))
	    __err |= ios_base::failbit;
	}
      
      return __beg;
    }
  
#ifdef _G_RESOLVE_LIB_DEFECTS
  template<typename _CharT, typename _InIter>
    _InIter 
    num_get<_CharT, _InIter>::
    do_get(iter_type __beg, iter_type __end, ios_base& __io, 
	   ios_base::iostate& __err, short& __v) const
    {
      // Stage 1: extract and determine the conversin specifier.
      // Assuming leading zeros eliminated, thus the size of 32 for
      // integral types.
      char __xtrc[32]= "";
      int __base;
      _M_extract(__beg, __end, __io, __err, __xtrc, __base);
      
      // Stage 2: convert and store results.
      char* __sanity;
      errno = 0;
      long __vl = strtol(__xtrc, &__sanity, __base);
      if (__sanity != __xtrc && *__sanity == '\0' && errno == 0
	  && __vl >= SHRT_MIN && __vl <= SHRT_MAX) 
	{
	  __v = static_cast<short>(__vl);
	  __err = ios_base::goodbit;
	}
      else
	__err |= ios_base::failbit;
      
      return __beg;
    }

  template<typename _CharT, typename _InIter>
    _InIter 
    num_get<_CharT, _InIter>::
    do_get(iter_type __beg, iter_type __end, ios_base& __io, 
	   ios_base::iostate& __err, int& __v) const
    {
      // Stage 1: extract and determine the conversin specifier.
      // Assuming leading zeros eliminated, thus the size of 32 for
      // integral types.
      char __xtrc[32]= "";
      int __base;
      _M_extract(__beg, __end, __io, __err, __xtrc, __base);
      
      // Stage 2: convert and store results.
      char* __sanity;
      errno = 0;
      long __vl = strtol(__xtrc, &__sanity, __base);
      if (__sanity != __xtrc && *__sanity == '\0' && errno == 0
	  && __vl >= INT_MIN && __vl <= INT_MAX) 
	{
	  __v = static_cast<int>(__vl);
	  __err = ios_base::goodbit;
	}
      else
	__err |= ios_base::failbit;
      
      return __beg;
    }
#endif
   
  template<typename _CharT, typename _InIter>
    _InIter 
    num_get<_CharT, _InIter>::
    do_get(iter_type __beg, iter_type __end, ios_base& __io, 
	   ios_base::iostate& __err, long& __v) const
    {
      // Stage 1: extract and determine the conversin specifier.
      // Assuming leading zeros eliminated, thus the size of 32 for
      // integral types.
      char __xtrc[32]= "";
      int __base;
      _M_extract(__beg, __end, __io, __err, __xtrc, __base);
      
      // Stage 2: convert and store results.
      char* __sanity;
      errno = 0;
      __v = strtol(__xtrc, &__sanity, __base);
      if (__sanity != __xtrc && *__sanity == '\0' && errno == 0)
	__err = ios_base::goodbit;
      else
	__err |= ios_base::failbit;
      
      return __beg;
    }
   
#ifdef _G_USE_LONG_LONG
  template<typename _CharT, typename _InIter>
    _InIter 
    num_get<_CharT, _InIter>::
    do_get(iter_type __beg, iter_type __end, ios_base& __io, 
	   ios_base::iostate& __err, long long& __v) const
    {
      // Stage 1: extract and determine the conversin specifier.
      // Assuming leading zeros eliminated, thus the size of 32 for
      // integral types.
      char __xtrc[32]= "";
      int __base;
      _M_extract(__beg, __end, __io, __err, __xtrc, __base);
      
      // Stage 2: convert and store results.
      char* __sanity;
      errno = 0;
      __v = strtoll(__xtrc, &__sanity, __base);
      if (__sanity != __xtrc && *__sanity == '\0' && errno == 0)
	__err = ios_base::goodbit;
      else
	__err |= ios_base::failbit;
      
      return __beg;
    }
#endif

  template<typename _CharT, typename _InIter>
    _InIter 
    num_get<_CharT, _InIter>::
    do_get(iter_type __beg, iter_type __end, ios_base& __io, 
	   ios_base::iostate& __err, unsigned short& __v) const
    {
      // Stage 1: extract and determine the conversin specifier.
      // Assuming leading zeros eliminated, thus the size of 32 for
      // integral types.
      char __xtrc[32]= "";
      int __base;
      _M_extract(__beg, __end, __io, __err, __xtrc, __base);
      
      // Stage 2: convert and store results.
      char* __sanity;
      errno = 0;
      unsigned long __vl = strtoul(__xtrc, &__sanity, __base);
      if (__sanity != __xtrc && *__sanity == '\0' && errno == 0
	  && __vl <= USHRT_MAX) 
	{
	  __v = static_cast<unsigned short>(__vl);
	  __err = ios_base::goodbit;
	}
      else
	__err |= ios_base::failbit;
      
      return __beg;
    }

  template<typename _CharT, typename _InIter>
    _InIter 
    num_get<_CharT, _InIter>::
    do_get(iter_type __beg, iter_type __end, ios_base& __io, 
	   ios_base::iostate& __err, unsigned int& __v) const
    {
      // Stage 1: extract and determine the conversin specifier.
      // Assuming leading zeros eliminated, thus the size of 32 for
      // integral types.
      char __xtrc[32]= "";
      int __base;
      _M_extract(__beg, __end, __io, __err, __xtrc, __base);
      
      // Stage 2: convert and store results.
      char* __sanity;
      errno = 0;
      unsigned long __vl = strtoul(__xtrc, &__sanity, __base);
      if (__sanity != __xtrc && *__sanity == '\0' && errno == 0
	  && __vl <= UINT_MAX) 
	{
	  __v = static_cast<unsigned int>(__vl);
	  __err = ios_base::goodbit;
	}
      else
	__err |= ios_base::failbit;
      
      return __beg;
    }

  template<typename _CharT, typename _InIter>
    _InIter 
    num_get<_CharT, _InIter>::
    do_get(iter_type __beg, iter_type __end, ios_base& __io, 
	   ios_base::iostate& __err, unsigned long& __v) const
    {
      // Stage 1: extract and determine the conversin specifier.
      // Assuming leading zeros eliminated, thus the size of 32 for
      // integral types.
      char __xtrc[32]= "";
      int __base;
      _M_extract(__beg, __end, __io, __err, __xtrc, __base);
      
      // Stage 2: convert and store results.
      char* __sanity;
      errno = 0;
      __v = strtoul(__xtrc, &__sanity, __base);
      if (__sanity != __xtrc && *__sanity == '\0' && errno == 0)
	__err = ios_base::goodbit;
      else
	__err |= ios_base::failbit;
      
      return __beg;
    }

#ifdef _G_USE_LONG_LONG
  template<typename _CharT, typename _InIter>
    _InIter 
    num_get<_CharT, _InIter>::
    do_get(iter_type __beg, iter_type __end, ios_base& __io, 
	   ios_base::iostate& __err, unsigned long long& __v) const
    {
      // Stage 1: extract and determine the conversin specifier.
      // Assuming leading zeros eliminated, thus the size of 32 for
      // integral types.
      char __xtrc[32]= "";
      int __base;
      _M_extract(__beg, __end, __io, __err, __xtrc, __base);
      
      // Stage 2: convert and store results.
      char* __sanity;
      errno = 0;
      __v = strtoull(__xtrc, &__sanity, __base);
      if (__sanity != __xtrc && *__sanity == '\0' && errno == 0)
	__err = ios_base::goodbit;
      else
	__err |= ios_base::failbit;
      
      return __beg;
    }
#endif

  template<typename _CharT, typename _InIter>
    _InIter 
    num_get<_CharT, _InIter>::
    do_get(iter_type __beg, iter_type __end, ios_base& __io, 
	   ios_base::iostate& __err, float& __v) const
    {
      // Stage 1: extract and determine the conversin specifier.
      // Assuming leading zeros eliminated, thus the size of 256 for
      // floating-point types.
      char __xtrc[256]= "";
      int __base;
      _M_extract(__beg, __end, __io, __err, __xtrc, __base);
      
      // Stage 2: convert and store results.
      char* __sanity;
      errno = 0;
#if _G_USE_STRTOF
      __v = strtof(__xtrc, &__sanity);
#else
      __v = static_cast<float>(strtod(__xtrc, &__sanity));
#endif
      if (__sanity != __xtrc && *__sanity == '\0' && errno == 0)
	__err = ios_base::goodbit;
      else
	__err |= ios_base::failbit;
      
      return __beg;
    }

  template<typename _CharT, typename _InIter>
    _InIter 
    num_get<_CharT, _InIter>::
    do_get(iter_type __beg, iter_type __end, ios_base& __io, 
	   ios_base::iostate& __err, double& __v) const
    {
      // Stage 1: extract and determine the conversin specifier.
      // Assuming leading zeros eliminated, thus the size of 256 for
      // floating-point types.
      char __xtrc[256]= "";
      int __base;
      _M_extract(__beg, __end, __io, __err, __xtrc, __base);
      
      // Stage 2: convert and store results.
      char* __sanity;
      errno = 0;
      __v = strtod(__xtrc, &__sanity);
      if (__sanity != __xtrc && *__sanity == '\0' && errno == 0)
	__err = ios_base::goodbit;
      else
	__err |= ios_base::failbit;
      
      return __beg;
    }

#ifdef _G_USE_STRTOLD
  template<typename _CharT, typename _InIter>
    _InIter 
    num_get<_CharT, _InIter>::
    do_get(iter_type __beg, iter_type __end, ios_base& __io, 
	   ios_base::iostate& __err, long double& __v) const
    {
      // Stage 1: extract and determine the conversin specifier.
      // Assuming leading zeros eliminated, thus the size of 256 for
      // floating-point types.
      char __xtrc[256]= "";
      int __base;
      _M_extract(__beg, __end, __io, __err, __xtrc, __base);
      
      // Stage 2: convert and store results.
      char* __sanity;
      errno = 0;
      __v = strtold(__xtrc, &__sanity);
      if (__sanity != __xtrc && *__sanity == '\0' && errno == 0)
	__err = ios_base::goodbit;
      else
	__err |= ios_base::failbit;
      
      return __beg;
    }
#else
  template<typename _CharT, typename _InIter>
    _InIter 
    num_get<_CharT, _InIter>::
    do_get(iter_type __beg, iter_type __end, ios_base& __io, 
	   ios_base::iostate& __err, long double& __v) const
    {
      // Stage 1: extract
      char __xtrc[256]= "";
      int __base;
      _M_extract(__beg, __end, __io, __err, __xtrc, __base);

      // Stage 2: determine a conversion specifier.
      ios_base::fmtflags __basefield = __io.flags() & ios_base::basefield;
      const char* __conv;
      if (__basefield == ios_base::oct)
	__conv = "%Lo";
      else if (__basefield == ios_base::hex)
	__conv = "%LX";
      else if (__basefield == 0)
	__conv = "%Li";
      else
	__conv = "%Lg";

      // Stage 3: store results.
      int __ok = sscanf(__xtrc, __conv, &__v);
      if (__ok && __ok != __traits_type::eof())
	__err = ios_base::goodbit;
      else
	__err |= ios_base::failbit;
      
      return __beg;
    }
#endif

  template<typename _CharT, typename _InIter>
    _InIter 
    num_get<_CharT, _InIter>::
    do_get(iter_type __beg, iter_type __end, ios_base& __io, 
	   ios_base::iostate& __err, void*& __v) const
    {
      // Stage 1: extract and determine the conversin specifier.
      // Assuming leading zeros eliminated, thus the size of 32 for
      // integral types.
      char __xtrc[32]= "";
      int __base;
      _M_extract(__beg, __end, __io, __err, __xtrc, __base);
      
      // Stage 2: convert and store results.
      char* __sanity;
      errno = 0;
      __v = reinterpret_cast<void*>(strtol(__xtrc, &__sanity, __base));
      if (__sanity != __xtrc && *__sanity == '\0' && errno == 0)
	__err = ios_base::goodbit;
      else
	__err |= ios_base::failbit;
      
      return __beg;
    }

  template <typename _CharT, typename _OutIter>
    locale::id num_put<_CharT, _OutIter>::id;

  // _S_fill is specialized for ostreambuf_iterator, random access iterator.
  template <typename _CharT, typename _OutIter>
    inline _OutIter
    _S_fill(_OutIter __s, _CharT __fill, int __padding);

#if 0 
  // XXX Not optimal.
  // Generic version is better for an optimal ostreambuf_iterator,
  // which we don't have yet.  But this can be improved too.
  template <typename _CharT, typename _Traits>
    ostreambuf_iterator<_CharT,_Traits>
    _S_fill(ostreambuf_iterator<_CharT,_Traits> __s,
            _CharT __fill, int __padding)
    {
      // XXX  Could do a lot better by breaking into the streambuf.
      basic_streambuf<_CharT,_Traits>* __buf = __s._M_sbuf;
      typename _Traits::int_type __ifill = _Traits::to_int_type(__fill);
      while (__padding--) __buf->sputc(__ifill);
    }
#endif

  template <typename _CharT, typename _RaIter>
    _RaIter
    _S_fill(_RaIter __s, _CharT __fill, int __padding,
            random_access_iterator_tag)
    {
      fill_n(__s, __fill);
      return __s + __padding;
    }

  template <typename _CharT, typename _OutIter, typename _Tag>
    _OutIter
    _S_fill(_OutIter __s, _CharT __fill, int __padding, _Tag)
    {
      while (--__padding >= 0) { *__s = __fill; ++__s; }
      return __s;
    }

  template <typename _CharT, typename _OutIter>
    inline _OutIter
    _S_fill(_OutIter __s, _CharT __fill, int __padding)
    {
      return _S_fill(__s,__fill,__padding,
		     iterator_traits<_OutIter>::iterator_category());
    }

  template <typename _CharT, typename _OutIter>
    _OutIter
    _S_pad_numeric(_OutIter __s, ios_base::fmtflags __flags,
                   _CharT __fill, int __width, _CharT const* __first,
                   _CharT const* __middle, _CharT const* __last)
    {
      int __padding = __width - (__last - __first);
      if (__padding < 0) __padding = 0;
      ios_base::fmtflags __adjfield = __flags & ios_base::adjustfield;
      // This bit is pretty complicated because output iterators don't assign.
      _OutIter __s2 = (__first == __middle) ? __s : copy(__first,__middle,
       (__padding == 0 || __adjfield == ios_base::left ||
                          __adjfield == ios_base::internal) ? __s :
          (_S_fill(__s,__fill, __padding), (__padding = 0), __s));

      if (__padding && __adjfield != ios_base::left) 
	{
	  _S_fill(__s2,__fill, __padding);
	  __padding = 0;
	}
      _OutIter __s3 = copy(__middle,__last, __s2);
      if (__padding)
	_S_fill(__s3,__fill, __padding);
      return __s3;
    }

  template <typename _CharT, typename _OutIter>
    _OutIter 
    num_put<_CharT, _OutIter>::
    do_put(iter_type __s, ios_base& __io, char_type __fill, bool __v) const
    {
      const _Format_cache<_CharT>* __fmt = _Format_cache<_CharT>::_S_get(__io);
      ios_base::fmtflags __flags = __io.flags();

      if ((__flags & ios_base::boolalpha) == 0)
	this->do_put(__s, __io, __fill, static_cast<unsigned long>(__v));
      else
	{
	  const char_type* __first;
	  const char_type* __last;
	  if (__v)
	    {
	      __first = __fmt->_M_truename.data();
	      __last = __first + __fmt->_M_truename.size();
	    }
	  else
	    {
	      __first = __fmt->_M_falsename.data();
	      __last = __first + __fmt->_M_falsename.size();
	    }
	  copy(__first, __last, __s);
	}
      return __s;
    }

  // _S_group_digits inserts "group separator" characters into an array 
  // of characters.  It's recursive, one iteration per group.  It moves
  // the characters in the buffer this way: "xxxx12345" -> "12,345xxx".
  // Call this only with __grouping != __grend.
  template <typename _CharT>
    _CharT*
    _S_group_digits(_CharT* __s, _CharT __grsep,  char const* __grouping, 
		    char const* __grend, _CharT const* __first, 
		    _CharT const* __last)
    {
      if (__last - __first > *__grouping) 
	{
	  __s = _S_group_digits(__s,  __grsep, 
              (__grouping + 1 == __grend ? __grouping : __grouping + 1),
	      __grend, __first, __last - *__grouping);
	  __first = __last - *__grouping;
	  *__s++ = __grsep;
	}
      do 
	{
	  *__s++ = *__first++;
	} 
      while (__first != __last);
      return __s;
    }

  template <typename _CharT, typename _OutIter>
    _OutIter
    _S_format_long(_OutIter __s, ios_base& __io, _CharT __fill, bool __neg,
		   unsigned long __v)
    {
      // Leave room for "-0x" and commas.
      const int _M_room = numeric_limits<unsigned long>::digits10 * 2 + 4;
      _CharT __digits[_M_room];
      _CharT* __front = __digits + _M_room;
      ios_base::fmtflags __flags = __io.flags();
      const _Format_cache<_CharT>* __fmt = _Format_cache<_CharT>::_S_get(__io);
      char const* __table = __fmt->_S_literals + __fmt->_S_digits;

      ios_base::fmtflags __basefield = (__flags & __io.basefield);
      _CharT* __sign_end = __front;
      if (__basefield == __io.hex) 
	{
	  if (__flags & ios_base::uppercase) 
	    __table += 16;  // use ABCDEF
	  do 
	    {
	      *--__front = __table[__v & 15];
	    } 
	  while ((__v >>= 4) != 0);
	  __sign_end = __front;
	  if (__flags & __io.showbase) 
	    {
	      *--__front = __fmt->_S_literals[__fmt->_S_ecks +
                       ((__flags & ios_base::uppercase) ? 1 : 0)];
	      *--__front = __table[0];
	    }
	} 
      else if (__basefield == __io.oct) 
	{
	  do 
	    {
	      *--__front = __table[__v & 7];
	    } 
	  while ((__v >>= 3) != 0);
	  if (__flags & __io.showbase && *__front != __table[0])
	    *--__front = __table[0];
	  __sign_end = __front;
	} 
      else 
	{
	  // note: this is _lots_ faster than using ldiv.
	  do 
	    { 
	      *--__front = __table[__v % 10];
	    } 
	  while ((__v /= 10) != 0);
	  __sign_end = __front;
	}
      if (__neg || (__flags & __io.showpos))
	*--__front = __fmt->_S_literals[__fmt->_S_plus - __neg];

      if (!__fmt->_M_use_grouping && !__io.width())
	return copy(__front, __digits+_M_room, __s);  // XXX should specialize!

      if (!__fmt->_M_use_grouping)
	return _S_pad_numeric(__s, __flags, __fill, __io.width(0),
			      __front, __sign_end, __digits + _M_room);

      _CharT* __p = __digits;
      while (__front < __sign_end)
	*__p++ = *__front++;
      const char* __gr = __fmt->_M_grouping.data();
      __front = _S_group_digits(__p, __fmt->_M_thousands_sep, __gr, 
        __gr + __fmt->_M_grouping.size(), __sign_end, __digits + _M_room);
      return _S_pad_numeric(__s, __flags, __fill, __io.width(0),
			    __digits, __p, __front);
    }

  template <typename _CharT, typename _OutIter>
    _OutIter 
    num_put<_CharT, _OutIter>::
    do_put(iter_type __s, ios_base& __io, char_type __fill, long __v) const
    {
      unsigned long __uv = __v;
      bool __neg = false;
      if (__v < 0) { __neg = true; __uv = -__uv; }
      return _S_format_long(__s, __io, __fill, __neg, __uv);
    }

#ifdef _G_USE_LONG_LONG 
  template <typename _CharT, typename _OutIter>
    _OutIter 
    num_put<_CharT, _OutIter>::
    do_put(iter_type __s, ios_base& __b, char_type __fill, long long __v) const
    {
      unsigned long long __uv = __v;
      bool __neg = false;
      if (__v < 0) { __neg = true; __uv = -__uv; }
      return _S_format_long(__s, __b, __fill, __neg, __uv);
    }
#endif

  template <typename _CharT, typename _OutIter>
    _OutIter 
    num_put<_CharT, _OutIter>::
    do_put(iter_type __s, ios_base& __io, char_type __fill, 
	   unsigned long __v) const
    {
      return _S_format_long(__s, __io, __fill, false, __v);
    }

  template <typename _CharT, typename _OutIter>
    _OutIter 
    num_put<_CharT, _OutIter>::
    do_put(iter_type __s, ios_base& __io, char_type __fill, double __v) const
    {
      return __s;  // XXX not done
    }

  template <typename _CharT, typename _OutIter>
    _OutIter 
    num_put<_CharT, _OutIter>::
    do_put(iter_type __s, ios_base& __io, char_type __fill,
	   long double __v) const
    {
      return __s;  // XXX not done
    }

  template <typename _CharT, typename _OutIter>
    _OutIter 
    num_put<_CharT, _OutIter>::
    do_put(iter_type __s, ios_base& __io, char_type __fill,
	   const void* __v) const
    {
      ios_base::fmtflags __oldflags = __io.flags(__io.flags() &
       ~(__io.showpos|__io.basefield|__io.uppercase|__io.internal) |
						 (__io.hex|__io.showbase));
      try {
	_OutIter __s2 = _S_format_long(__s, __io, __fill, false, 
				       reinterpret_cast<unsigned long>(__v));
	__io.flags(__oldflags);
	return __s2;
      } 
      catch (...) {
	__io.flags(__oldflags); 
	throw;
      }
    }

  template<typename _CharT>
    locale::id numpunct<_CharT>::id;

  template<typename _CharT>
    locale::id collate<_CharT>::id;

  // Support for time_get:
  // Note that these partial specializations could, and maybe should,
  // be changed to full specializations (by eliminating the _Dummy
  // argument) and moved to a .cc file.
  template<typename _CharT, typename _Dummy = int>
    struct _Weekdaynames;

  template<typename _Dummy>
    struct _Weekdaynames<char, _Dummy>
    { static const char* const _S_names[14]; };

  template<typename _Dummy>
    const char* const
    _Weekdaynames<char,_Dummy>::_S_names[14] = 
    { 
      "Sun", "Sunday",
      "Mon", "Monday",   "Tue", "Tuesday", "Wed", "Wednesday",
      "Thu", "Thursday", "Fri", "Friday",  "Sat", "Saturday"
    };

  template<typename _Dummy>
    struct _Weekdaynames<wchar_t,_Dummy>
    { static const wchar_t* const _S_names[14]; };

  template<typename _Dummy>
    const wchar_t* const
    _Weekdaynames<wchar_t,_Dummy>::_S_names[14] = 
    { 
      L"Sun", L"Sunday",
      L"Mon", L"Monday",   L"Tue", L"Tuesday", L"Wed", L"Wednesday",
      L"Thu", L"Thursday", L"Fri", L"Friday",  L"Sat", L"Saturday"
    };

  template<typename _CharT, typename _Dummy = int>
    struct _Monthnames;

  template<typename _Dummy>
    struct _Monthnames<char,_Dummy>
    { static const char* const _S_names[24]; };

  template<typename _Dummy>
    const char* const
    _Monthnames<char,_Dummy>::_S_names[24] = 
    {
      "Jan", "January", "Feb", "February", "Mar", "March",
      "Apr", "April",   "May", "May",      "Jun", "June",
      "Jul", "July",    "Aug", "August",   "Sep", "September",
      "Oct", "October", "Nov", "November", "Dec", "December"
    };

  template<typename _Dummy>
    struct _Monthnames<wchar_t, _Dummy>
    { static const wchar_t* const _S_names[24]; };

  template<typename _Dummy>
    const wchar_t* const
    _Monthnames<wchar_t,_Dummy>::_S_names[24] = 
    {
      L"Jan", L"January", L"Feb", L"February", L"Mar", L"March",
      L"Apr", L"April",   L"May", L"May",      L"Jun", L"June",
      L"Jul", L"July",    L"Aug", L"August",   L"Sep", L"September",
      L"Oct", L"October", L"Nov", L"November", L"Dec", L"December"
    };

  template<typename _CharT, typename _InIter>
    locale::id time_get<_CharT, _InIter>::id;

  template<typename _CharT, typename _InIter>
    _InIter 
    time_get<_CharT, _InIter>::
    do_get_weekday(iter_type __s, iter_type __end,
		   ios_base& __io, ios_base::iostate& __err, tm* __t) const
    {
      if (!_M_daynames) 
	{
	  _M_daynames = new basic_string<_CharT>[14];
	  for (int __i = 0; __i < 14; ++__i)
	    _M_daynames[__i] = _Weekdaynames<_CharT>::_S_names[__i];
	}
      bool __at_eof = false;
      int __remain = 0;
      int __matches[14];
      iter_type __out = __match_parallel(__s, __end, 14, _M_daynames, 
					 __matches, __remain, __at_eof);
      __err = ios_base::iostate(0);
      if (__at_eof) __err |= __io.eofbit;
      if (__remain == 1 ||
	  __remain == 2 && (__matches[0]>>1) == (__matches[1]>>1))
	__t->tm_wday = (__matches[0]>>1);
      else
	__err |= __io.failbit;
      return __out;
    }

  template<typename _CharT, typename _InIter>
    _InIter 
    time_get<_CharT, _InIter>::
    do_get_monthname(iter_type __s, iter_type __end,
		     ios_base& __io, ios_base::iostate& __err, tm* __t) const
    {
      if (!_M_monthnames) 
	{
	  _M_monthnames = new basic_string<_CharT>[24];
	  for (int __i = 0; __i < 24; ++__i)
	    _M_monthnames[__i] = _Monthnames<_CharT>::_S_names[__i];
	}
      bool __at_eof = false;
      int __remain = 0;
      int __matches[24];
      iter_type __out = __match_parallel( __s, __end, 24, _M_monthnames, 
					  __matches, __remain, __at_eof);
      __err = ios_base::iostate(0);
      if (__at_eof) __err |= __io.eofbit;
      if (__remain == 1 ||
	  __remain == 2 && (__matches[0]>>1) == (__matches[1]>>1))
	__t->tm_mon = (__matches[0]>>1);
      else
	__err |= __io.failbit;
      return __out;
    }
  
  template<typename _CharT, typename _OutIter>
    locale::id time_put<_CharT, _OutIter>::id;

  template<typename _CharT, typename _InIter>
    locale::id money_get<_CharT, _InIter>::id;

  template<typename _CharT, typename _OutIter>
    locale::id money_put<_CharT, _OutIter>::id;

  template<typename _CharT, bool _Intl>
    locale::id moneypunct<_CharT,_Intl>::id;

  template<typename _CharT>
    locale::id messages<_CharT>::id;

  template<>
    inline const ctype<char>&
    use_facet<const ctype<char> > (const locale& __loc)
    {
      size_t __i = ctype<char>::id._M_index;
      const locale::_Impl* __tmp = __loc._M_impl;
      return static_cast<const ctype<char>&>(* (*(__tmp->_M_facets))[__i]);
    }

  template<>
    inline const ctype<wchar_t>&
    use_facet< const ctype<wchar_t> > (const locale& __loc)
    {
      size_t __i = ctype<wchar_t>::id._M_index;
      const locale::_Impl* __tmp = __loc._M_impl;
      return static_cast<const ctype<wchar_t>&>(* (*(__tmp->_M_facets))[__i]);
    }
} // std::

#endif /* _CPP_BITS_LOCFACETS_TCC */

// Local Variables:
// mode:c++
// End:





