// Input streams -*- C++ -*-

// Copyright (C) 1997-1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

//
// ISO C++ 14882: 27.6.1  Input streams
//

#ifndef _CPP_ISTREAM
#define _CPP_ISTREAM	1

#include <bits/c++config.h>
#include <bits/std_ios.h>
#include <bits/std_ostream.h>
#include <bits/stl_string_fwd.h>

namespace std {

  template <class _CharT, class _Traits>
  class basic_istream : virtual public basic_ios<_CharT,_Traits>
  {
  protected:
    streamsize _M_gcount;

  public:
    // Types (inherited from basic_ios:
    typedef _CharT                     char_type;
    typedef typename _Traits::int_type int_type;
    typedef typename _Traits::pos_type pos_type;
    typedef typename _Traits::off_type off_type;
    typedef _Traits                    traits_type;

    // Constructor/destructor:
    explicit basic_istream (basic_streambuf<_CharT,_Traits>* __sb);
    virtual ~basic_istream ();

    // Prefix/suffix:
    class sentry;

    // Formatted input:
    basic_istream<_CharT,_Traits> &
    operator >> (basic_istream<_CharT,_Traits>& (*__pf)(
                   basic_istream<_CharT,_Traits>&))
      {
	__pf (*this);
	return *this;
      }

    basic_istream<_CharT,_Traits> &
    operator >> (basic_ios<_CharT,_Traits>& (*__pf
      ) (basic_ios<_CharT,_Traits>&))
      {
	__pf (*this);
	return *this;
      }

    basic_istream<_CharT,_Traits> &
    operator >> (ios_base& (*__pf) (ios_base&))
      {
	__pf (*this);
	return *this;
      }

    basic_istream<_CharT,_Traits>& operator >> (bool& __n);
    basic_istream<_CharT,_Traits>& operator >> (short& __n);
    basic_istream<_CharT,_Traits>& operator >> (unsigned short& __n);
    basic_istream<_CharT,_Traits>& operator >> (int& __n);
    basic_istream<_CharT,_Traits>& operator >> (unsigned int& __n);
    basic_istream<_CharT,_Traits>& operator >> (long& __n);
    basic_istream<_CharT,_Traits>& operator >> (unsigned long& __n);
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
    basic_istream<_CharT,_Traits>& operator >> (long long& __n);
    basic_istream<_CharT,_Traits>& operator >> (unsigned long long& __n);
#endif
    basic_istream<_CharT,_Traits>& operator >> (float& __f);
    basic_istream<_CharT,_Traits>& operator >> (double& __f);
    basic_istream<_CharT,_Traits>& operator >> (long double& __f);
    basic_istream<_CharT,_Traits>& operator >> (void*& __p);
    basic_istream<_CharT,_Traits>& operator >> (basic_streambuf<char_type,
							       _Traits>* __sb);

    // Unformatted input:
    streamsize gcount () const { return _M_gcount; }

    int_type get ();
    basic_istream<_CharT,_Traits>& get (char_type& __c);
    basic_istream<_CharT,_Traits>& get (char_type* __s, streamsize __n)
      { return get (__s, __n, widen('\n')); }
    basic_istream<_CharT,_Traits>& get (char_type* __s, streamsize __n,
				       char_type __delim)
      { return get (__s, __n, widen(__delim)); }
    basic_istream<_CharT,_Traits>&
      get (basic_streambuf<char_type,_Traits>& __sb)
        { return get (__sb, widen('\n')); }
    basic_istream<_CharT,_Traits>&
      get (basic_streambuf<char_type,_Traits>& __sb, char_type __delim)
        { return get (__sb, widen(__delim)); }
    basic_istream<_CharT,_Traits>& getline (char_type* __s, streamsize __n)
      { return getline (__s, __n, widen ('\n')); }
    basic_istream<_CharT,_Traits>& getline (char_type* __s, streamsize __n,
					   char_type __delim)
      { return getline (__s, __n, widen (__delim)); }
    basic_istream<_CharT,_Traits>& ignore (streamsize __n = 1,
					  int_type __delim = _Traits::eof ());

    int_type peek ();

    basic_istream<_CharT,_Traits>& read (char_type* __s, streamsize __n);
    streamsize readsome (char_type* __s, streamsize __n);

    basic_istream<_CharT,_Traits>& putback (char_type __c)
      {
	if (good () && _M_strbuf->sputbackc (__c) == traits_type::eof ())
	  clear (ios_base::badbit);
        return *this;
      }
    basic_istream<_CharT,_Traits>& unget ()
      {
        if (good () && _M_strbuf->sungetc () == traits_type::eof ())
	  clear (ios_base::badbit);
        return *this;
      }
    int sync ();
    pos_type tellg ();
    basic_istream<_CharT,_Traits>& seekg (pos_type);
    basic_istream<_CharT,_Traits>& seekg (off_type, ios_base::seekdir);

    // this crashes the compiler.  Why?
    template <class _Ch, class _Tr, class _Alloc>
      friend basic_istream<_Ch,_Tr>&
      getline (basic_istream<_Ch,_Tr>& __is,
               basic_string<_Ch,_Tr,_Alloc>& __s, _Ch __delim);
  };

  template <class _CharT, class _Traits>
  basic_istream<_CharT,_Traits>::
    basic_istream (basic_streambuf<_CharT,_Traits>* __sb)
      : basic_ios<_CharT,_Traits> ()  // virtual base, often ignored.
      { this->init (__sb); }

  template <class _CharT, class _Traits>
  basic_istream<_CharT,_Traits>::~basic_istream ()
    { } // XXX done?


  template <class _CharT, class _Traits>
  class basic_istream<_CharT,_Traits>::sentry
  {
    typedef _Traits traits_type;
    bool _M_ok;
  public:
    explicit sentry (basic_istream<_CharT,_Traits>& __is,
                     bool __noskipws = false);
    operator bool () { return _M_ok; }
  };

  template <class _CharT, class _Traits>
  basic_istream<_CharT,_Traits>::sentry::sentry (
    basic_istream<_CharT,_Traits>& __is, bool __noskipws)
  {
    if (!__is.good ())
      {
	_M_ok = false;
	return;
      }

    // Synchronize with associated stream.
    if (__is.tie ())
      __is.tie ()->flush ();

    if (!__noskipws && (__is.flags () & ios_base::skipws))
      {
	typename _Traits::int_type __c = __is.rdbuf ()->sgetc ();
#if 1  /* XXX should use getloc */
	while (__c != _Traits::eof () && isspace(__c))
#else
	typedef ctype<_CharT> _Ctype;
	const _Ctype& __ctype = use_facet<_Ctype> (__is.getloc ());
	while (__c != _Traits::eof () && __ctype.is (__ctype.space, __c))
#endif
	       __c = __is.rdbuf ()->snextc ();
      }

    _M_ok = true;
  }


  // Character extraction templates:
  template <class _CharT, class _Traits>
    typename _Traits::int_type
    basic_istream<_CharT,_Traits>::get ()
    {
      sentry __cerb (*this);
      if (!__cerb)
	{
	  _M_gcount = 0;
	  return traits_type::eof ();
	}
      int_type __ch = _M_strbuf->sbumpc ();
      if (__ch == traits_type::eof ())
	{
	  setstate (ios_base::eofbit);
	  _M_gcount = 0;
	}
      else
	_M_gcount = 1;
      return __ch;
    }

  template <class _CharT, class _Traits>
  inline basic_istream<_CharT,_Traits> &
  operator >> (basic_istream<_CharT,_Traits>& __in, _CharT& __c)
  {
    return __in.get (__c);
  }

  template <class _Traits>
  inline basic_istream<char,_Traits> &
  operator >> (basic_istream<char,_Traits>& __in, unsigned char& __c)
  {
    return __in.get (static_cast<char&> (__c));
  }

  template <class _Traits>
  inline basic_istream<char,_Traits> &
  operator >> (basic_istream<char,_Traits>& __in, signed char& __c)
  {
    return __in.get (static_cast<char&> (__c));
  }

  template <class _CharT, class _Traits>
  basic_istream<_CharT,_Traits> &
  operator >> (basic_istream<_CharT,_Traits>&, _CharT*);

  template <class _Traits>
  basic_istream<char,_Traits> &
  operator >> (basic_istream<char,_Traits>&, unsigned char*);

  template <class _Traits>
  basic_istream<char,_Traits> &
  operator >> (basic_istream<char,_Traits>&, signed char*);

  template <class _CharT, class _Traits>
  basic_istream<_CharT,_Traits>& ws (basic_istream<_CharT,_Traits>& __is);

  // 27.6.1.5
  template<typename _CharT, typename _Traits>
    class basic_iostream
      : public basic_istream<_CharT,_Traits>
      , public basic_ostream<_CharT,_Traits>
  {
  public:
    explicit basic_iostream(basic_streambuf<_CharT,_Traits>* __sb);
    virtual ~basic_iostream();
  };

  template<typename _CharT, typename _Traits>
    basic_iostream<_CharT,_Traits>::
      basic_iostream(basic_streambuf<_CharT,_Traits>* __sb)
      { }  // done?

  template<typename _CharT, typename _Traits>
    basic_iostream<_CharT,_Traits>::~basic_iostream()
      { }  // done?


} // namespace std

#endif	/* _CPP_ISTREAM */
