// The template and inlines for the -*- C++ -*- internal _Meta class.

// Copyright (C) 1997,1998 Cygnus Solutions
//
// This file is part of the libstdc++ version 3 distribution.
//
// This software is a copyrighted work licensed under the terms of the
// Cygnus libstdc++ license. Please consult the file LICENSE.STD for
// details.

// Written by Gabriel Dos Reis <Gabriel.Dos-Reis@DPTMaths.ENS-Cachan.Fr>

#ifndef _CPP_VALARRAY_META_H
#define _CPP_VALARRAY_META_H

namespace std {

template<typename _Tp>
class _Constant
{
public:
    typedef _Tp value_type;
    
    _Constant (const _Tp& __t) : _M_value (__t) {}
    value_type operator[] (size_t) const { return _M_value; }
    const value_type& operator() () const { return _M_value; }
    size_t size () const { return static_cast<size_t> (-1); }
    
private:
    const _Tp& _M_value;
    _Constant ();
};

template<class _Expr, class _Oper>
class _UnaryExpression {
public:
    typedef typename _Oper::result_type value_type;

    _UnaryExpression (const _Expr& __e) : _M_expr(__e) {}
    value_type operator[] (size_t __i) const;	
    size_t size () const { return _M_expr.size(); } 

private:
    _UnaryExpression ();

    const _Expr& _M_expr;
};

template<class _Expr, class _Oper>
inline typename _UnaryExpression<_Expr,_Oper>::value_type
_UnaryExpression<_Expr,_Oper>::operator[] (size_t __i) const
  { return _Oper() (_M_expr[__i]); }

template<class _Expr1, class _Expr2, class _Oper>
class _BinaryExpression {
public:
    typedef typename _Oper::result_type value_type;

    _BinaryExpression (const _Expr1& __e1,
                       const _Expr2& __e2)
            : _M_expr1 (__e1), _M_expr2 (__e2) {}
    value_type operator[] (size_t __i) const;
    size_t size () const { return min (_M_expr1.size(), _M_expr2.size()); }

private:
    _BinaryExpression ();

    const _Expr1& _M_expr1;
    const _Expr2& _M_expr2;
};

    
template<class _Expr1, class _Expr2, class _Oper>
inline typename _BinaryExpression<_Expr1,_Expr2,_Oper>::value_type
_BinaryExpression<_Expr1,_Expr2,_Oper>::operator[] (size_t __i) const
  { return _Oper() (_M_expr1[__i], _M_expr2[__i]); }


template<typename _Tp, class _Expr, class _Oper>
class _BinaryExpression<_Constant<_Tp>, _Expr, _Oper> {
public:
    typedef typename _Oper::result_type value_type;
    _BinaryExpression (const _Constant<_Tp>& __c, const _Expr& __e)
            : _M_expr1(__c()), _M_expr2(__e) {}
    value_type operator[] (size_t __i) const;
    size_t size() const { return _M_expr2.size(); }

private:
    const _Tp& _M_expr1;
    const _Expr& _M_expr2;
};


template<typename _Tp, class _Expr, class _Oper>
inline typename _BinaryExpression<_Constant<_Tp>,_Expr,_Oper>::value_type
_BinaryExpression<_Constant<_Tp>,_Expr,_Oper>::operator[] (size_t __i) const
  { return _Oper() (_M_expr1, _M_expr2[__i]); }

    
template<class _Expr, typename _Tp, class _Oper>
class _BinaryExpression<_Expr, _Constant<_Tp>, _Oper> {
public:
    typedef typename _Oper::result_type value_type;
    _BinaryExpression (const _Expr& __e, const _Constant<_Tp>& __c)
            : _M_expr1(__e), _M_expr2(__c()) {}
    value_type operator[] (size_t __i) const;
    size_t size() const { return _M_expr1.size(); }

private:
    const _Expr& _M_expr1;
    const _Tp& _M_expr2;
};


template<class _Expr, typename _Tp, class _Oper>
inline typename _BinaryExpression<_Expr,_Constant<_Tp>,_Oper>::value_type
_BinaryExpression<_Expr,_Constant<_Tp>,_Oper>::operator[] (size_t __i) const
  { return _Oper() (_M_expr1[__i], _M_expr2); }

    
template<class _Expr> class _SliceExpression {
public:
    typedef typename _Expr::value_type value_type;

    _SliceExpression (const _Expr& __e, const slice& __s)
            : _M_expr (__e), _M_s (__s) {}
    value_type operator[] (size_t __i) const
      { return _M_expr[_M_s.start () + __i * _M_s._M_stride()]; }
    size_t size () const { return _M_s.size(); }

private:
    _SliceExpression();
    const _Expr& _M_expr;
    const slice& _M_s;
};

template<typename _Tp> class _SliceExpression<_Array<_Tp> > {
public:
    typedef _Tp value_type;

    _SliceExpression (_Array<_Tp> __a, const slice& __s)
      : _M_array (__a._M_data+__s.start()), _M_sz (__s.size()), 
        _M_stride (__s.stride()) 
      {}
    value_type operator[] (size_t __i) const
      { return _M_array._M_data[__i*_M_stride]; }
    size_t size () const { return _M_sz; }

private:
    _SliceExpression ();
    const _Array<_Tp> _M_array;
    const size_t     _M_sz;
    const size_t     _M_stride;
};

template<class _Expr> class _GsliceExpression {
public:
    typedef typename _Expr::value_type value_type;

    _GsliceExpression (const _Expr& __e, const gslice& __gs)
            : _M_expr (__e), _M_sz (__gs._M_index_size), 
	      _M_index (__gs._M_index) {}
    value_type operator[] (size_t __i) const
    { return _M_expr[_M_index._M_data[__i]]; }
    size_t size () const { return _M_sz; }

private:
    _GsliceExpression ();

    const _Expr&	 _M_expr;
    const size_t 	 _M_sz;
    const _Array<size_t> _M_index;
};

template<typename _Tp> class _GsliceExpression<_Array<_Tp> > {
public:
    typedef _Tp value_type;

    _GsliceExpression (_Array<_Tp> __a, const gslice& __gs)
      : _M_array (__a), _M_sz(__gs._M_index_size), 
        _M_index (__gs._M_index) 
      {}
    value_type operator[] (size_t __i) const
      { return _M_array._M_data[_M_index._M_data[__i]]; }
    size_t size () const { return _M_sz; }

private:
    _GsliceExpression ();

    const _Array<_Tp>     _M_array;
    const size_t         _M_sz;
    const _Array<size_t> _M_index;
};

template<class _Expr> class _IndirectExpression {
public:
    typedef typename _Expr::value_type value_type;

    _IndirectExpression (const _Expr& __e, const valarray<size_t>& __i)
      : _M_expr (__e), _M_index (__i) 
      {}
    value_type operator[] (size_t __i) const
      { return _M_expr[_M_index[__i]]; }
    size_t size() const { return _M_index.size(); }

private:
    const _Expr& 	    _M_expr;
    const valarray<size_t>& _M_index;
};



template<class _Expr, typename _Value>
class _Meta
{
public:
    typedef _Value value_type;

    _Meta (const _Expr&);

    const _Expr& operator() () const;

    value_type operator[] (size_t) const;
    valarray<value_type> operator[] (slice) const;
    valarray<value_type> operator[] (const gslice&) const;
    valarray<value_type> operator[] (const valarray<bool>&) const;
    valarray<value_type> operator[] (const valarray<size_t>&) const;
    
    _Meta<_UnaryExpression<_Expr, _Unary_plus<value_type> >, value_type>
    operator+ () const;

    _Meta<_UnaryExpression<_Expr, negate<value_type> >, value_type>
    operator- () const;

    _Meta<_UnaryExpression<_Expr, _Bitwise_not<value_type> >, value_type>
    operator~ () const;

    _Meta<_UnaryExpression<_Expr, logical_not<value_type> >, bool>
    operator! () const;

    size_t size () const;
    value_type sum () const;

    valarray<value_type> shift (int) const;
    valarray<value_type> cshift (int) const;
    _Meta<_ApplyFunctionWithValue<_Expr>, value_type>
    apply (value_type _M_func (value_type)) const;
    _Meta<_ApplyFunctionWithConstRef<_Expr>, value_type>
    apply (value_type _M_func (const value_type&)) const;

  private:
    _Meta ();

    const _Expr _M_expr;
};

template<class _Expr, typename _Tp>
inline
_Meta<_Expr,_Tp>::_Meta (const _Expr& __e) : _M_expr(__e) {}

template<class _Expr, typename _Tp>
inline const _Expr&
_Meta<_Expr,_Tp>::operator() () const
  { return _M_expr; }

template<class _Expr, typename _Tp>
inline _Tp
_Meta<_Expr,_Tp>::operator[] (size_t __i) const
  { return _M_expr[__i]; }

template<class _Expr, typename _Tp>
inline valarray<_Tp>
_Meta<_Expr,_Tp>::operator[] (slice __s) const
  { return _M_expr[__s]; }

template<class _Expr, typename _Tp>
inline valarray<_Tp>
_Meta<_Expr,_Tp>::operator[] (const gslice& __gs) const
  { return _M_expr[__gs]; }

template<class _Expr, typename _Tp>
inline valarray<_Tp>
_Meta<_Expr,_Tp>::operator[] (const valarray<bool>& __m) const
  { return _M_expr[__m]; }

template<class _Expr, typename _Tp>
inline valarray<_Tp>
_Meta<_Expr,_Tp>::operator[] (const valarray<size_t>& __i) const
  { return _M_expr[__i]; }

#undef _DEFINE_VALARRAY_OPERATOR

#define _DEFINE_VALARRAY_OPERATOR(op, name)				\
template<class _Expr, typename _Tp>					\
inline _Meta<_UnaryExpression<_Expr, name##<_Tp> >, _Tp>		\
_Meta<_Expr,_Tp>::operator##op () const					\
{									\
    typedef _UnaryExpression<_Expr, name##<_Tp> > _Expr1;		\
    return _Meta<_Expr1,_Tp>(_Expr1(this->_M_expr));			\
}

_DEFINE_VALARRAY_OPERATOR(+, _Unary_plus)
_DEFINE_VALARRAY_OPERATOR(-, negate)
_DEFINE_VALARRAY_OPERATOR(~, _Bitwise_not)

#undef _DEFINE_VALARRAY_OPERATOR
    
template<class _Expr, typename _Tp>
inline _Meta<_UnaryExpression<_Expr, logical_not<_Tp> >, bool>
_Meta<_Expr,_Tp>::operator! () const
{
    typedef _UnaryExpression<_Expr, logical_not<_Tp> > _Expr1;
    return _Meta<_Expr1,_Tp>(_Expr1(this->_M_expr));
}

template<class _Expr, typename _Tp>
inline size_t
_Meta<_Expr,_Tp>::size () const
{ return _M_expr.size (); }

template<class _Expr, typename _Tp>
inline _Tp
_Meta<_Expr,_Tp>::sum () const
{
    _Tp __s(_Tp());
    for (register size_t __i=0; __i<_M_expr.size(); ++__i)
        __s += _M_expr[__i];
    return __s;
}

#undef _DEFINE_VALARRAY_OPERATOR

#define _DEFINE_VALARRAY_OPERATOR(op, name)				\
template<class _Expr1, class _Expr2>					\
inline _Meta<_BinaryExpression<_Expr1,_Expr2, 				\
                               name##<typename _Expr1::value_type> >,	\
             typename _Expr1::value_type> 				\
operator##op (const _Meta<_Expr1, typename _Expr1::value_type>& __v,	\
              const _Meta<_Expr2, typename _Expr2::value_type>& __w)	\
{									\
    typedef typename _Expr1::value_type _Tp;				\
    typedef _BinaryExpression<_Expr1,_Expr2, name##<_Tp> > _Expr_def;	\
    return _Meta<_Expr_def,_Tp> (_Expr_def (__v (), __w ()));			\
}									\
									\
template<class _Expr>							\
inline _Meta<_BinaryExpression<_Expr,  					\
                               _Constant<typename _Expr::value_type>,	\
                               name##<typename _Expr::value_type> >,	\
             typename _Expr::value_type>				\
operator##op (const _Meta<_Expr, typename _Expr::value_type>& __e,	\
              const typename _Expr::value_type& __t)			\
{									\
    typedef typename _Expr::value_type _Tp;				\
    typedef _BinaryExpression<_Expr, _Constant<_Tp>, name##<_Tp> > _Expr1; \
    return _Meta<_Expr1,_Tp> (_Expr1 (__e (), _Constant<_Tp> (__t)));	\
}									\
									\
template<class _Expr>							\
inline _Meta<_BinaryExpression<_Constant<typename _Expr::value_type>, 	\
                               _Expr, 					\
			       name##<typename _Expr::value_type> >, 	\
	     typename _Expr::value_type>				\
operator##op (const typename _Expr::value_type& __t,			\
              const _Meta<_Expr,typename _Expr::value_type>& __e)	\
{									\
    typedef typename _Expr::value_type _Tp;				\
    typedef _BinaryExpression<_Constant<_Tp>, _Expr, name##<_Tp> > _Expr1; \
    return _Meta<_Expr1,_Tp> (_Expr1 (_Constant<_Tp> (__t), __e ()));	\
}									\
									\
template<class _Expr>							\
inline _Meta<_BinaryExpression<_Expr, 					\
                               valarray<typename _Expr::value_type>,	\
                               name##<typename _Expr::value_type> >, 	\
             typename _Expr::value_type>				\
operator##op (const _Meta<_Expr, typename _Expr::value_type>& __e,	\
              const valarray<typename _Expr::value_type>& __v) 		\
{									\
    typedef typename _Expr::value_type _Tp;				\
    typedef _BinaryExpression<_Expr,valarray<_Tp>,name##<_Tp> > _Expr1; 	\
    return _Meta<_Expr1,_Tp> (_Expr1 (__e (), __v));			\
}									\
									\
template<class _Expr>							\
inline _Meta<_BinaryExpression<valarray<typename _Expr::value_type>, 	\
                               _Expr,					\
                               name##<typename _Expr::value_type> >, 	\
	     typename _Expr::value_type>				\
operator##op (const valarray<typename _Expr::value_type>& __v,		\
              const _Meta<_Expr, typename _Expr::value_type>& __e)	\
{									\
    typedef typename _Expr::value_type _Tp;				\
    typedef _BinaryExpression<valarray<_Tp>, _Expr, name##<_Tp> > _Expr1; \
    return _Meta<_Expr1,_Tp> (_Expr1 (__v, __e ()));			\
}									\

_DEFINE_VALARRAY_OPERATOR(+, plus)
_DEFINE_VALARRAY_OPERATOR(-, minus)
_DEFINE_VALARRAY_OPERATOR(*, multiplies)
_DEFINE_VALARRAY_OPERATOR(/, divides)
_DEFINE_VALARRAY_OPERATOR(%, modulus)
_DEFINE_VALARRAY_OPERATOR(^, _Bitwise_xor)
_DEFINE_VALARRAY_OPERATOR(&, _Bitwise_and)
_DEFINE_VALARRAY_OPERATOR(|, _Bitwise_or)
_DEFINE_VALARRAY_OPERATOR(<<, _Shift_left)
_DEFINE_VALARRAY_OPERATOR(>>, _Shift_right)

#undef _DEFINE_VALARRAY_OPERATOR    
    
#define _DEFINE_VALARRAY_OPERATOR(op, name)				\
template<class _Expr1, class _Expr2>					\
inline _Meta<_BinaryExpression<_Expr1,_Expr2, 				\
                               name##<typename _Expr1::value_type> >,	\
	     bool>							\
operator##op (const _Meta<_Expr1, typename _Expr1::value_type>& __v,	\
                const _Meta<_Expr2, typename _Expr2::value_type>& __w)	\
{									\
    typedef typename _Expr1::value_type _Tp;				\
    typedef _BinaryExpression<_Expr1,_Expr2, name##<_Tp> > _Expr_def;	\
    return _Meta<_Expr_def, bool> (_Expr_def (__v (), __w ()));			\
}									\
									\
template<class _Expr>							\
inline _Meta<_BinaryExpression<_Expr,  					\
                               _Constant<typename _Expr::value_type>,	\
                               name##<typename _Expr::value_type> >, 	\
             bool>							\
operator##op (const _Meta<_Expr, typename _Expr::value_type>& __e,	\
              const typename _Expr::value_type& __t)			\
{									\
    typedef typename _Expr::value_type _Tp;				\
    typedef _BinaryExpression<_Expr, _Constant<_Tp>, name##<_Tp> > _Expr1; \
    return _Meta<_Expr1, bool> (_Expr1 (__e (), _Constant<_Tp> (__t)));	\
}									\
									\
template<class _Expr>							\
inline _Meta<_BinaryExpression<_Constant<typename _Expr::value_type>, 	\
                               _Expr,					\
                               name##<typename _Expr::value_type> >, 	\
	     bool>							\
operator##op (const typename _Expr::value_type& __t,			\
              const _Meta<_Expr, typename _Expr::value_type>& __e)	\
{									\
    typedef typename _Expr::value_type _Tp;				\
    typedef _BinaryExpression<_Constant<_Tp>, _Expr, name##<_Tp> > _Expr1; \
    return _Meta<_Expr1, bool> (_Expr1 (_Constant<_Tp> (__t), __e ()));	\
}									\
									\
template<class _Expr>							\
inline _Meta<_BinaryExpression<_Expr, 					\
                               valarray<typename _Expr::value_type>,	\
                               name##<typename _Expr::value_type> >, 	\
	     bool>							\
operator##op (const _Meta<_Expr, typename _Expr::value_type>& __e,	\
              const valarray<typename _Expr::value_type>& __v) 		\
{									\
    typedef typename _Expr::value_type _Tp;				\
    typedef _BinaryExpression<_Expr, valarray<_Tp>, name##<_Tp> > _Expr1; \
    return _Meta<_Expr1, bool> (_Expr1 (__e (), __v));			\
}									\
									\
template<class _Expr>							\
inline _Meta<_BinaryExpression<valarray<typename _Expr::value_type>, 	\
                               _Expr,					\
  			       name##<typename _Expr::value_type> >, 	\
	     bool>							\
operator##op (const valarray<typename _Expr::value_type>& __v,		\
              const _Meta<_Expr, typename _Expr::value_type>& __e) 	\
{									\
    typedef typename _Expr::value_type _Tp;				\
    typedef _BinaryExpression<valarray<_Tp>, _Expr, name##<_Tp> > _Expr1; \
    return _Meta<_Expr1, bool> (_Expr1 (__v, __e ()));			\
}									\

_DEFINE_VALARRAY_OPERATOR(&&, logical_and)
_DEFINE_VALARRAY_OPERATOR(||, logical_or)
_DEFINE_VALARRAY_OPERATOR(==, equal_to)
_DEFINE_VALARRAY_OPERATOR(!=, not_equal_to)
_DEFINE_VALARRAY_OPERATOR(<, less)
_DEFINE_VALARRAY_OPERATOR(>, greater)
_DEFINE_VALARRAY_OPERATOR(<=, less_equal)
_DEFINE_VALARRAY_OPERATOR(>=, greater_equal)

#undef _DEFINE_VALARRAY_OPERATOR

    
template<class _Expr, typename _Tp>
inline _Tp
min (const _Meta<_Expr,_Tp>& __e)
{
    _Tp  __m (__e[0]);
    for (register size_t __i = 0; __i < __e.size (); ++__i)
        if (__m > __e[__i])
            __m = __e[__i];
    return __m;
}

template<class _Expr, typename _Tp>
inline _Tp
max (const _Meta<_Expr,_Tp>& __e)
{
    _Tp __m (__e[0]);
    for (register size_t __i = 0; __i < __e.size (); ++__i)
        if (__m < __e[__i])
            __m = __e[__i];
    return __m;
}

template<class _Expr>
class _ApplyUnaryFunctionToValarray
{
public:
    typedef typename _Expr::value_type value_type;
    typedef value_type _Tp;

    _ApplyUnaryFunctionToValarray (const _Expr& __e, _Tp __f(_Tp))
            : _M_expr(__e), _M_func(__f) {}

    value_type operator[] (size_t __i) const { return _M_func(_M_expr[__i]); }
    size_t size () const { return _M_expr.size(); }

private:
    const _Expr& _M_expr;
    _Tp (*_M_func)(_Tp);
};

#undef _DEFINE_VALARRAY_FUNCTION

#define _DEFINE_VALARRAY_FUNCTION(name)					\
template<class _Expr>							\
inline 									\
_Meta<_ApplyUnaryFunctionToValarray<_Expr>, 				\
      typename _Expr::value_type> 					\
name(const _Meta<_Expr,typename _Expr::value_type>& __e)		\
{									\
    typedef typename _Expr::value_type _Tp;				\
    typedef _ApplyUnaryFunctionToValarray<_Expr> _Expr1;			\
    return _Meta<_Expr1,_Tp> (_Expr1(__e, static_cast<_Tp(*)(_Tp)> (&name))); \
}									\
									\
template<typename _Tp>							\
inline _Meta<_ApplyUnaryFunctionToValarray<valarray<_Tp> >, _Tp>		\
name(const valarray<_Tp>& __v)						\
{									\
    typedef _ApplyUnaryFunctionToValarray<valarray<_Tp> > _Expr1;		\
    return _Meta<_Expr1,_Tp> (_Expr1(__v, static_cast<_Tp(*)(_Tp)> (&name))); \
}

_DEFINE_VALARRAY_FUNCTION(abs)
_DEFINE_VALARRAY_FUNCTION(cos)
_DEFINE_VALARRAY_FUNCTION(acos)
_DEFINE_VALARRAY_FUNCTION(cosh)    
_DEFINE_VALARRAY_FUNCTION(sin)
_DEFINE_VALARRAY_FUNCTION(asin)
_DEFINE_VALARRAY_FUNCTION(sinh)    
_DEFINE_VALARRAY_FUNCTION(tan)    
_DEFINE_VALARRAY_FUNCTION(atan)
_DEFINE_VALARRAY_FUNCTION(exp)    
_DEFINE_VALARRAY_FUNCTION(log)
_DEFINE_VALARRAY_FUNCTION(log10)
_DEFINE_VALARRAY_FUNCTION(sqrt)

#undef _DEFINE_VALARRAY_FUNCTION    

template<class _Expr1, class _Expr2>
class _ApplyBinaryFunction
{
public:
    typedef typename _Expr1::value_type value_type;
    typedef value_type _Tp;

    _ApplyBinaryFunction (const _Expr1& __e1, const _Expr2& __e2,
                          _Tp __f (_Tp, _Tp))
            : _M_expr1 (__e1), _M_expr2 (__e2), _M_func (__f) {}

    value_type operator[] (size_t __i) const
      { return _M_func (_M_expr1[__i], _M_expr2[__i]); }
    size_t size () const { return min (_M_expr1.size (), _M_expr2.size ()); }

private:
    const _Expr1& _M_expr1;
    const _Expr2& _M_expr2;
    _Tp (*_M_func)(_Tp,_Tp);
};

template<typename _Tp, class _Expr>
class _ApplyBinaryFunction<_Constant<_Tp>, _Expr>
{
public:
    typedef _Tp value_type ;

    _ApplyBinaryFunction (const _Constant<_Tp>& __c, const _Expr& __e,
                          _Tp __f (_Tp, _Tp))
            : _M_expr1 (__c()), _M_expr2 (__e), _M_func (__f) {}

    value_type operator[] (size_t __i) const
      { return _M_func (_M_expr1, _M_expr2[__i]); }
    size_t size () const { return _M_expr2.size (); }

private:
    const _Tp& _M_expr1;
    const _Expr& _M_expr2;
    _Tp (*_M_func)(_Tp,_Tp);
};

template<class _Expr, typename _Tp>
class _ApplyBinaryFunction<_Expr, _Constant<_Tp> >
{
public:
    typedef _Tp value_type;

    _ApplyBinaryFunction (const _Expr& __e, const _Constant<_Tp>& __c,
                          _Tp __f (_Tp, _Tp))
            : _M_expr1 (__e), _M_expr2 (__c()), _M_func (__f) {}

    value_type operator[] (size_t __i) const
      { return _M_func (_M_expr1[__i], _M_expr2); }
    size_t size () const { return _M_expr1.size (); }

private:
    const _Expr& _M_expr1;
    const _Tp& _M_expr2;
    _Tp (*_M_func)(_Tp,_Tp);
};


#define _DEFINE_VALARRAY_FUNCTION(name)					\
template<class _Expr1, class _Expr2>					\
inline _Meta<_ApplyBinaryFunction<_Expr1,_Expr2>,			\
             typename _ApplyBinaryFunction<_Expr1,_Expr2>::value_type>	\
name(const _Meta<_Expr1,typename _Expr1::value_type>& __e1,		\
     const _Meta<_Expr2,typename _Expr2::value_type>& __e2)		\
{									\
    typedef typename _Expr1::value_type _Tp;				\
    typedef _ApplyBinaryFunction<_Expr1,_Expr2> _Expr_def;		\
    return _Meta<_Expr_def,_Tp>						\
        (_Expr_def(__e1(), __e2(), static_cast<_Tp(*)(_Tp, _Tp)>(&name)));	\
}									\
									\
template<class _Expr>							\
inline _Meta<_ApplyBinaryFunction<_Constant<typename _Expr::value_type>, \
                                  _Expr>, 				\
	     typename _Expr::value_type>				\
name(const typename _Expr::value_type& __t,				\
     const _Meta<_Expr,typename _Expr::value_type>& __e)		\
{									\
    typedef typename _Expr::value_type _Tp;				\
    typedef _ApplyBinaryFunction<_Constant<_Tp>,_Expr> _Expr1;		\
    return _Meta<_Expr1,_Tp>(_Expr1(_Constant<_Tp>(__t), __e(),		\
                                 static_cast<_Tp(*)(_Tp, _Tp)>(&name))); 	\
}									\
									\
template<class _Expr>							\
inline _Meta<_ApplyBinaryFunction<_Expr, 				\
                                  _Constant<typename _Expr::value_type> >, \
	     typename _Expr::value_type>				\
name(const _Meta<_Expr,typename _Expr::value_type>& __e,		\
     const typename _Expr::value_type& __t)				\
{									\
    typedef typename _Expr::value_type _Tp;				\
    typedef _ApplyBinaryFunction<_Expr, _Constant<_Tp> > _Expr1;		\
    return _Meta<_Expr1,_Tp>(_Expr1(__e(), _Constant<_Tp>(__t),		\
                                 static_cast<_Tp(*)(_Tp, _Tp)>(&name))); \
}									\
									\
template<class _Expr>							\
inline _Meta<_ApplyBinaryFunction<_Expr, 				\
                                  valarray<typename _Expr::value_type> >, \
	     typename _Expr::value_type>				\
name(const _Meta<_Expr,typename _Expr::value_type>& __e,		\
     const valarray<typename _Expr::value_type>& __v)			\
{									\
    typedef typename _Expr::value_type _Tp;				\
    typedef _ApplyBinaryFunction<_Expr, valarray<_Tp> > _Expr1;		\
    return _Meta<_Expr1,_Tp>(_Expr1(__e(), __v,				\
                                 static_cast<_Tp(*)(_Tp, _Tp)>(&name))); \
}									\
									\
template<class _Expr>							\
inline _Meta<_ApplyBinaryFunction<valarray<typename _Expr::value_type>, \
                                  _Expr>, 				\
	     typename _Expr::value_type>				\
name(const valarray<typename _Expr::value_type>& __v,			\
     const _Meta<_Expr,typename _Expr::value_type>& __e)		\
{									\
    typedef typename _Expr::value_type _Tp;				\
    typedef _ApplyBinaryFunction<valarray<_Tp>, _Expr> _Expr1;		\
    return _Meta<_Expr1,_Tp>(_Expr1(__v, __e(),				\
                                 static_cast<_Tp(*)(_Tp, _Tp)>(&name))); \
}									\
									\
template<typename _Tp>							\
inline _Meta<_ApplyBinaryFunction<valarray<_Tp>, valarray<_Tp> >, _Tp>	\
name(const valarray<_Tp>& __v, const valarray<_Tp>& __w)		\
{									\
    typedef _ApplyBinaryFunction<valarray<_Tp>, valarray<_Tp> > _Expr1;	\
    return _Meta<_Expr1,_Tp>(_Expr1(__v, __w,				\
                                    static_cast<_Tp(*)(_Tp, _Tp)>(&name))); \
}									\
									\
template<typename _Tp>							\
inline _Meta<_ApplyBinaryFunction<valarray<_Tp>, _Constant<_Tp> >, _Tp>	\
name(const valarray<_Tp>& __v, const _Tp& __t)				\
{									\
    typedef _ApplyBinaryFunction<valarray<_Tp>, _Constant<_Tp> > _Expr1;	\
    return _Meta<_Expr1,_Tp>(_Expr1(__v, _Constant<_Tp>(__t),		\
                                 static_cast<_Tp(*)(_Tp, _Tp)>(&name))); \
}									\
									\
template<typename _Tp>							\
inline _Meta<_ApplyBinaryFunction<_Constant<_Tp>, valarray<_Tp> >, _Tp>	\
name(const _Tp& __t, const valarray<_Tp>& __v)				\
{									\
    typedef _ApplyBinaryFunction<_Constant<_Tp>, valarray<_Tp> > _Expr1;	\
    return _Meta<_Expr1,_Tp>(_Expr1(_Constant<_Tp>(__t), __v,		\
                                 static_cast<_Tp(*)(_Tp, _Tp)>(&name))); \
}

_DEFINE_VALARRAY_FUNCTION(atan2)
_DEFINE_VALARRAY_FUNCTION(pow)

#undef _DEFINE_VALARRAY_FUNCTION    
    
template<class _Expr>
class _ApplyFunctionWithValue
{
public:
    typedef typename _Expr::value_type value_type;
    
    _ApplyFunctionWithValue (const _Expr& __e,
                             value_type __f (value_type))
      : _M_expr (__e), _M_func (__f) {}
    
    value_type operator[] (size_t __i) const { return _M_func (_M_expr[__i]); }
    size_t size () const { return _M_expr.size (); }

  private:
    const _Expr& _M_expr;
    value_type (*_M_func) (value_type);

    _ApplyFunctionWithValue ();
};

template<class _Expr>
class _ApplyFunctionWithConstRef
{
  public:
    typedef typename _Expr::value_type value_type;

    _ApplyFunctionWithConstRef (const _Expr& __e,
                                value_type __f (const value_type&))
      : _M_expr (__e), _M_func (__f) {}

    value_type operator[] (size_t __i) const { return _M_func (_M_expr[__i]); }
    size_t size () const { return _M_expr.size (); }

  private:
    const _Expr& _M_expr;
    value_type (*_M_func) (const value_type&);

    _ApplyFunctionWithConstRef ();
};

} // std::


#endif /* _CPP_VALARRAY_META_H */

// Local Variables:
// mode:c++
// End:
