/* Copyright (C) 1993 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#include <ansidecl.h>
#include <errno.h>
#include <sys/types.h>
#include <grp.h>
#include <hurd.h>

/* Set the group set for the current user to GROUPS (N of them).  */
int
DEFUN(setgroups, (n, groups), size_t n AND CONST gid_t *groups)
{
  error_t err;
  auth_t newauth;
  size_t i;
  gid_t new[2 + n];

  for (i = 0; i < n; ++i)
    new[2 + i] = groups[i];

  __mutex_lock (&_hurd_idlock);
  err = _hurd_check_ids ();
  if (! err)
    {
      /* Set up the new group idlist.  */
      new[0] = _hurd_gid->rid;
      new[1] = _hurd_gid->svid;

      /* Get a new auth port using those IDs.  */
      err = _HURD_PORT_USE (&_hurd_ports[INIT_PORT_AUTH],
			    __auth_makeauth (port,
					     _hurd_uid, _hurd_nuids,
					     new, 2 + n,
					     &newauth));
    }
  __mutex_unlock (&_hurd_idlock);

  if (err)
    return __hurd_fail (err);

  /* Install the new auth port and reauthenticate everything.  */
  err = __setauth (newauth);
  __mach_port_deallocate (__mach_task_self (), newauth);
  return err;
}
