'\"
'\" Copyright (c) 1990 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /rel/cvsfiles/devo/tk/doc/tkerror.n,v 1.1 1994/06/03 23:43:42 rob Exp $ SPRITE (Berkeley)
'/" 
.so man.macros
.HS tkerror tk 7.0
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
tkerror \- Command invoked to process background errors
.SH SYNOPSIS
\fBtkerror \fImessage\fR
.BE

.SH DESCRIPTION
.PP
The \fBtkerror\fR command doesn't exist as built-in part of Tk.  Instead,
individual applications or users can define a \fBtkerror\fR
command (e.g. as a Tcl procedure) if they wish to handle background
errors.
.PP
A background error is one that occurs in a command that didn't
originate with the application.  For example, if an error occurs
while executing a command specified with a \fBbind\fR of \fBafter\fR
command, then it is a background error.  For a non-background error,
the error can simply be returned up through nested Tcl command
evaluations until it reaches the top-level code in the application;
then the application can report the error in whatever way it
wishes.  When a background error occurs, the unwinding ends in
the Tk library and there is no obvious way for Tk to report
the error.
.PP
When Tk detects a background error, it invokes the \fBtkerror\fR
command, passing it the error message as its only argument.
Tk assumes that the application has implemented the \fBtkerror\fR
command, and that the command will report the error in a way that
makes sense for the application.  Tk will ignore any result returned
by the \fBtkerror\fR command.
.PP
If another Tcl error occurs within the \fBtkerror\fR command
then Tk reports the error itself by writing a message
to stderr.
.PP
.VS
The Tk script library includes a default \fBtkerror\fR procedure
that posts a dialog box containing the error message and offers
the user a chance to see a stack trace that shows where the
error occurred.
.VE

.SH KEYWORDS
background error, reporting
