'\"
'\" Copyright (c) 1992 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /rel/cvsfiles/devo/tk/doc/place.n,v 1.1 1994/06/03 23:43:28 rob Exp $ SPRITE (Berkeley)
'/" 
.so man.macros
.HS place tk
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
place \- Geometry manager for fixed or rubber-sheet placement
.VS
.SH SYNOPSIS
\fBplace \fIwindow option value \fR?\fIoption value ...\fR?
.sp
\fBplace configure \fIwindow option value \fR?\fIoption value ...\fR?
.sp
\fBplace forget \fIwindow\fR
.sp
\fBplace info \fIwindow\fR
.sp
\fBplace slaves \fIwindow\fR
.VS
.VE
.BE

.SH DESCRIPTION
.PP
The placer is a geometry manager for Tk.
It provides simple fixed placement of windows, where you specify
the exact size and location of one window, called the \fIslave\fR,
within another window, called the \fImaster\fR.
The placer also provides rubber-sheet placement, where you specify the
size and location of the slave in terms of the dimensions of
the master, so that the slave changes size and location
in response to changes in the size of the master.
Lastly, the placer allows you to mix these styles of placement so
that, for example, the slave has a fixed width and height but is
centered inside the master.
.PP
If the first argument to the \fBplace\fR command is a window path
name or \fBconfigure\fR then the command arranges for the placer
to manage the geometry of a slave whose path name is \fIwindow\fR.
The remaining arguments consist of one or more \fIoption\-value\fR
pairs that specify the way in which \fIwindow\fR's
geometry is managed.
If the placer is already managing \fIwindow\fR, then the
\fIoption\-value\fR pairs modify the configuration for \fIwindow\fR.
In this form the \fBplace\fR command returns an empty string as result.
The following \fIoption\-value\fR pairs are supported:
.TP
\fB\-in \fImaster\fR
\fIMaster\fR specifes the path name of the window relative
to which \fIwindow\fR is to be placed.
\fIMaster\fR must either be \fIwindow\fR's parent or a descendant
of \fIwindow\fR's parent.
In addition, \fImaster\fR and \fIwindow\fR must both be descendants
of the same top-level window.
These restrictions are necessary to guarantee
that \fIwindow\fR is visible whenever \fImaster\fR is visible.
If this option isn't specified then the master defaults to
\fIwindow\fR's parent.
.TP
\fB\-x \fIlocation\fR
\fILocation\fR specifies the x-coordinate within the master window
of the anchor point for \fIwindow\fR.
The location is specified in screen units (i.e. any of the forms
accepted by \fBTk_GetPixels\fR) and need not lie within the bounds
of the master window.
.TP
\fB\-relx \fIlocation\fR
\fILocation\fR specifies the x-coordinate within the master window
of the anchor point for \fIwindow\fR.
In this case the location is specified in a relative fashion
as a floating-point number:  0.0 corresponds to the left edge
of the master and 1.0 corresponds to the right edge of the master.
\fILocation\fR need not be in the range 0.0\-1.0.
.TP
\fB\-y \fIlocation\fR
\fILocation\fR specifies the y-coordinate within the master window
of the anchor point for \fIwindow\fR.
The location is specified in screen units (i.e. any of the forms
accepted by \fBTk_GetPixels\fR) and need not lie within the bounds
of the master window.
.TP
\fB\-rely \fIlocation\fR
\fILocation\fR specifies the y-coordinate within the master window
of the anchor point for \fIwindow\fR.
In this case the value is specified in a relative fashion
as a floating-point number:  0.0 corresponds to the top edge
of the master and 1.0 corresponds to the bottom edge of the master.
\fILocation\fR need not be in the range 0.0\-1.0.
.TP
\fB\-anchor \fIwhere\fR
\fIWhere\fR specifies which point of \fIwindow\fR is to be positioned
at the (x,y) location selected by the \fB\-x\fR, \fB\-y\fR,
\fB\-relx\fR, and \fB\-rely\fR options.
The anchor point is in terms of the outer area of \fIwindow\fR
including its border, if any.
Thus if \fIwhere\fR is \fBse\fR then the lower-right corner of
\fIwindow\fR's border will appear at the given (x,y) location
in the master.
The anchor position defaults to \fBnw\fR.
.TP
\fB\-width \fIsize\fR
\fISize\fR specifies the width for \fIwindow\fR in screen units
(i.e. any of the forms accepted by \fBTk_GetPixels\fR).
The width will be the outer width of \fIwindow\fR including its
border, if any.
If \fIsize\fR is an empty string, or if no \fB\-width\fR
or \fB\-relwidth\fR option is specified, then the width requested
internally by the window will be used.
.TP
\fB\-relwidth \fIsize\fR
\fISize\fR specifies the width for \fIwindow\fR.
In this case the width is specified as a floating-point number
relative to the width of the master: 0.5 means \fIwindow\fR will
be half as wide as the master, 1.0 means \fIwindow\fR will have
the same width as the master, and so on.
.TP
\fB\-height \fIsize\fR
\fISize\fR specifies the height for \fIwindow\fR in screen units
(i.e. any of the forms accepted by \fBTk_GetPixels\fR).
The height will be the outer dimension of \fIwindow\fR including its
border, if any.
If \fIsize\fR is an empty string, or if no \fB\-height\fR or
\fB\-relheight\fR option is specified, then the height requested
internally by the window will be used.
.TP
\fB\-relheight \fIsize\fR
\fISize\fR specifies the height for \fIwindow\fR.
In this case the height is specified as a floating-point number
relative to the height of the master: 0.5 means \fIwindow\fR will
be half as high as the master, 1.0 means \fIwindow\fR will have
the same height as the master, and so on.
.TP
\fB\-bordermode \fImode\fR
\fIMode\fR determines the degree to which borders within the
master are used in determining the placement of the slave.
The default and most common value is \fBinside\fR.
In this case the placer considers the area of the master to
be the innermost area of the master, inside any border:
an option of \fB\-x 0\fR corresponds to an x-coordinate just
inside the border and an option of \fB\-relwidth 1.0\fR
means \fIwindow\fR will fill the area inside the master's
border.
If \fImode\fR is \fBoutside\fR then the placer considers
the area of the master to include its border;
this mode is typically used when placing \fIwindow\fR
outside its master, as with the options \fB\-x 0 \-y 0 \-anchor ne\fR.
Lastly, \fImode\fR may be specified as \fBignore\fR, in which
case borders are ignored:  the area of the master is considered
to be its official X area, which includes any internal border but
no external border.  A bordermode of \fBignore\fR is probably
not very useful.
.PP
If the same value is specified separately with
two different options, such as \fB\-x\fR and \fB\-relx\fR, then
the most recent option is used and the older one is ignored.
.PP
The \fBplace slaves\fR command returns a list of all the slave
.VS
.VE
windows for which \fIwindow\fR is the master.
If there are no slaves for \fIwindow\fR then an empty string is
returned.
.PP
The \fBplace forget\fR command causes the placer to stop managing
the geometry of \fIwindow\fR.  As a side effect of this command
\fIwindow\fR will be unmapped so that it doesn't appear on the
screen.
If \fIwindow\fR isn't currently managed by the placer then the
command has no effect.
\fBPlace forget\fR returns an empty string as result.
.PP
The \fBplace info\fR command returns a list giving the current
configuration of \fIwindow\fR.
The list consists of \fIoption\-value\fR pairs in exactly the
same form as might be specified to the \fBplace configure\fR
command.
If the configuration of a window has been retrieved with
\fBplace info\fR, that configuration can be restored later by
first using \fBplace forget\fR to erase any existing information
for the window and then invoking \fBplace configure\fR with
the saved information.

.SH "FINE POINTS"
.PP
It is not necessary for the master window to be the parent
of the slave window.
This feature is useful in at least two situations.
First, for complex window layouts it means you can create a
hierarchy of subwindows whose only purpose
is to assist in the layout of the parent.
The ``real children'' of the parent (i.e. the windows that
are significant for the application's user interface) can be
children of the parent yet be placed inside the windows
of the geometry-management hierarchy.
This means that the path names of the ``real children''
don't reflect the geometry-management hierarchy and users
can specify options for the real children
without being aware of the structure of the geometry-management
hierarchy.
.PP
A second reason for having a master different than the slave's
parent is to tie two siblings together.
For example, the placer can be used to force a window always to
be positioned centered just below one of its
siblings by specifying the configuration
.DS C
\fB\-in \fIsibling\fB \-relx 0.5 \-rely 1.0 \-anchor n \-bordermode outside\fR
.DE
Whenever the sibling is repositioned in the future, the slave
will be repositioned as well.
.PP
Unlike many other geometry managers (such as the packer)
the placer does not make any attempt to manipulate the geometry of
the master windows or the parents of slave windows (i.e. it doesn't
set their requested sizes).
To control the sizes of these windows, make them windows like
frames and canvases that provide configuration options for this purpose.

.SH KEYWORDS
geometry manager, height, location, master, place, rubber sheet, slave, width
.VE
