/* Complex square root of double value.
   Copyright (C) 1997,1998 Cygnus Solutions

   This file is part of the libstdc++ version 3 distribution.

   This software is a copyrighted work licensed under the terms of the
   Cygnus libstdc++ license. Please consult the file LICENSE.STD for
   details.  */

#include <math.h>
#include "mathconf.h"


__complex__ double
csqrt (__complex__ double x)
{
  __complex__ double res;

  if (!FINITE_P (__real__ x) || !FINITE_P (__imag__ x))
    {
      if (INFINITE_P (__imag__ x))
	{
	  __real__ res = HUGE_VAL;
	  __imag__ res = __imag__ x;
	}
      else if (INFINITE_P (__real__ x))
	{
	  if (__real__ x < 0.0)
	    {
	      __real__ res = __imag__ x != __imag__ x ? NAN : 0;
	      __imag__ res = __copysign (HUGE_VAL, __imag__ x);
	    }
	  else
	    {
	      __real__ res = __real__ x;
	      __imag__ res = (__imag__ x != __imag__ x
			      ? NAN : __copysign (0.0, __imag__ x));
	    }
	}
      else
	{
	  __real__ res = NAN;
	  __imag__ res = NAN;
	}
    }
  else
    {
      if (__imag__ x == 0.0)
	{
	  if (__real__ x < 0.0)
	    {
	      __real__ res = 0.0;
	      __imag__ res = __copysign (sqrt (-__real__ x), __imag__ x);
	    }
	  else
	    {
	      __real__ res = fabs (sqrt (__real__ x));
	      __imag__ res = __copysign (0.0, __imag__ x);
	    }
	}
      else if (__real__ x == 0.0)
	{
	  double r = sqrt (0.5 * fabs (__imag__ x));

	  __real__ res = __copysign (r, __imag__ x);
	  __imag__ res = r;
	}
      else
	{
	  __complex__ double q;
	  double t, r;

	  if (fabs (__imag__ x) < 2.0e-4 * fabs (__real__ x))
	    t = 0.25 * __imag__ x * (__imag__ x / __real__ x);
	  else
	    t = 0.5 * (hypot (__real__ x, __imag__ x) - __real__ x);

	  r = sqrt (t);

	  __real__ q = __imag__ x / (2.0 * r);
	  __imag__ q = r;

	  /* Heron iteration in complex arithmetic.  */
	  res = 0.5 * (q + q / x);
	}
    }

  return res;
}
