/* 
Copyright (C) 1993 Free Software Foundation

This file is part of the GNU IO Library.  This library is free
software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option)
any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

As a special exception, if you link this library with files
compiled with a GNU compiler to produce an executable, this does not cause
the resulting executable to be covered by the GNU General Public License.
This exception does not however invalidate any other reasons why
the executable file might be covered by the GNU General Public License. */

/*  written by Per Bothner (bothner@cygnus.com) */

#include "libioP.h"

#if _IO_HAVE_SYS_WAIT
#include <signal.h>
#include <unistd.h>
#include <sys/wait.h>

#ifndef _IO_fork
#define _IO_fork vfork /* defined in libiberty, if needed */
_IO_pid_t _IO_fork();
#endif

#endif /* _IO_HAVE_SYS_WAIT */

#ifndef _IO_pipe
#define _IO_pipe pipe
extern int _IO_pipe();
#endif

#ifndef _IO_dup2
#define _IO_dup2 dup2
extern int _IO_dup2();
#endif

#ifndef _IO_execl
#define _IO_execl execl
#endif
#ifndef _IO__exit
#define _IO__exit _exit
#endif

#ifdef TODO
/* Ditto for signal, sigxxxmask, wait etc */
#endif

struct _IO_proc_file
{
  struct _IO_FILE_plus _file;
  /* Following fields must match those in class procbuf (procbuf.h) */
  _IO_pid_t _pid;
};
typedef struct _IO_proc_file _IO_proc_file;

_IO_FILE *
_IO_proc_open(fp, command, mode)
     _IO_FILE* fp;
     const char *command;
     const char *mode;
{
#if _IO_HAVE_SYS_WAIT
  int read_or_write;
  int pipe_fds[2];
  int parent_end, child_end;
  _IO_pid_t child_pid;
  if (_IO_file_is_open(fp))
    return NULL;
  if (_IO_pipe(pipe_fds) < 0)
    return NULL;
  if (mode[0] == 'r')
    {
      parent_end = pipe_fds[0];
      child_end = pipe_fds[1];
      read_or_write = _IO_NO_WRITES;
    }
  else
    {
      parent_end = pipe_fds[1];
      child_end = pipe_fds[0];
      read_or_write = _IO_NO_READS;
    }
  ((_IO_proc_file*)fp)->_pid = child_pid = _IO_fork();
  if (child_pid == 0)
    {
      int child_std_end = mode[0] == 'r' ? 1 : 0;
      _IO_close(parent_end);
      if (child_end != child_std_end)
	{
	  _IO_dup2(child_end, child_std_end);
	  _IO_close(child_end);
	}
      _IO_execl("/bin/sh", "sh", "-c", command, NULL);
      _IO__exit(127);
    }
  _IO_close(child_end);
  if (child_pid < 0)
    {
      _IO_close(parent_end);
      return NULL;
    }
  _IO_fileno(fp) = parent_end;
  fp->_IO_file_flags
    = read_or_write | (fp->_IO_file_flags & ~(_IO_NO_READS|_IO_NO_WRITES));
  return fp;
#else /* !_IO_HAVE_SYS_WAIT */
  return NULL;
#endif
}

_IO_FILE *
_IO_popen(command, mode)
     const char *command;
     const char *mode;
{
  _IO_proc_file *fpx = (_IO_proc_file*)malloc(sizeof(_IO_proc_file));
  _IO_FILE *fp = (_IO_FILE*)fpx;
  _IO_init(fp, 0);
  fp->_jumps = &_IO_proc_jumps;
  _IO_file_init(fp);
  if (fp == NULL)
    return NULL;
  ((struct _IO_FILE_plus*)fp)->_vtable = NULL;
  if (_IO_proc_open (fp, command, mode) != NULL)
    return fp;
  free (fpx);
  return NULL;
}

int
_IO_proc_close(fp)
     _IO_FILE *fp;
{
  /* This is not name-space clean. FIXME! */
#if _IO_HAVE_SYS_WAIT
  int wstatus;
  _IO_pid_t wait_pid;
  int status = _IO_close(_IO_fileno(fp));
#if defined(SIG_BLOCK) && defined(SIG_SETMASK)
  sigset_t set, oset;
#endif
  if (status < 0)
    return status;
#if defined(SIG_BLOCK) && defined(SIG_SETMASK)
  sigemptyset (&set);
  sigaddset (&set, SIGINT);
  sigaddset (&set, SIGQUIT);
  sigaddset (&set, SIGHUP);
  sigprocmask (SIG_BLOCK, &set, &oset);
#else
#ifdef USE_SIGMASK
  int mask = sigblock(sigmask(SIGINT) | sigmask(SIGQUIT) | sigmask(SIGHUP));
#else
  typedef void (*void_func)(int);
  void_func intsave = (void_func)signal(SIGINT, SIG_IGN);
  void_func quitsave = (void_func)signal(SIGQUIT, SIG_IGN);
  void_func hupsave = (void_func)signal(SIGHUP, SIG_IGN);
#endif
#endif
  while ((wait_pid = wait(&wstatus)) != ((_IO_proc_file*)fp)->_pid
	 && wait_pid != -1) { }
#if defined(SIG_BLOCK) && defined(SIG_SETMASK)
  sigprocmask (SIG_SETMASK, &oset, (sigset_t *)NULL);
#else
#ifdef USE_SIGMASK
  (void) sigsetmask(mask);
#else
  signal(SIGINT, intsave);
  signal(SIGQUIT, quitsave);
  signal(SIGHUP, hupsave);
#endif
#endif
  if (wait_pid == -1)
    return -1;
  return 0;
#else /* !_IO_HAVE_SYS_WAIT */
  return -1;
#endif
}

struct _IO_jump_t _IO_proc_jumps = {
  _IO_file_overflow,
  _IO_file_underflow,
  _IO_file_xsputn,
  _IO_default_xsgetn,
  _IO_file_read,
  _IO_file_write,
  _IO_file_doallocate,
  _IO_default_pbackfail,
  _IO_file_setbuf,
  _IO_file_sync,
  _IO_file_finish,
  _IO_proc_close,
  _IO_file_stat,
  _IO_file_seek,
  _IO_file_seekoff,
  _IO_default_seekpos,
};
