// This may look like C code, but it is really -*- C++ -*-

/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of GNU CC.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU CC General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU CC, but only under the conditions described in the
GNU CC General Public License.   A copy of this license is
supposed to have been given to you along with GNU CC so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  
*/

/*
  arithmetic, etc. functions on built in types
*/


#ifndef _builtin_h
#define _builtin_h 1


overload abs;
overload ceil;
overload clearbit;
overload cos;
overload cosh;
overload dec;
overload exp;
overload floor;
overload gcd;
overload hex;
overload lcm;
overload lg;
overload log;
overload oct;
overload pow;
overload setbit;
overload sign;
overload sin;
overload sinh;
overload sqr;
overload sqrt;
overload testbit;

#include <std.h>
#include <math.h>

long         abs(long x);
double       abs(double x);
void         clearbit(long& x, long b);
void         setbit(long& x, long b);
int          testbit(long x, long b);
int          even(long y);
long         gcd(long x, long y);
long         lg(long x); 
long         lcm(long x, long y);
int          odd(long y);
double       pow(double x, long p);
long         pow(long x, long y);
int          sign(long x);
int          sign(double x);
long         sqr(long x);
double       sqr(double x);
long         sqrt(long y);

char*        itoa(long x, int base = 10, int width = 0);
char*        hex(long x, int width = 0);
char*        oct(long x, int width = 0);
char*        dec(long x, int width = 0);
char*        form(const char* fmt ...);


//#ifdef __OPTIMIZE__

inline double abs(double x) 
{
  return (x < 0.0)? -x : x;
}

inline long abs(long x) 
{
  return (x < 0)? -x : x;
}

inline int sign(long x)
{
  return (x == 0) ? 0 : ( (x > 0) ? 1 : -1 );
}

inline int sign(double x)
{
  return (x == 0.0) ? 0 : ( (x > 0.0) ? 1 : -1 );
}

inline long sqr(long x)
{
  return x * x;
}

inline double sqr(double x)
{
  return x * x;
}

inline int even(long y)
{
  return !(y & 1);
}

inline int odd(long y)
{
  return (y & 1);
}

inline long lcm(long x, long y)
{
  return x / gcd(x, y) * y;
}

inline void setbit(long& x, long b)
{
  x |= (1 << b);
}

inline void clearbit(long& x, long b)
{
  x &= ~(1 << b);
}

inline int testbit(long x, long b)
{
  return ((x & (1 << b)) != 0);
}

//#endif

#endif
