/* Definitions for C++ parsing and type checking.
   Copyright (C) 1987 Free Software Foundation, Inc.
   Hacked by Michael Tiemann (tiemann@mcc.com)

This file is part of GNU CC.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU CC General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU CC, but only under the conditions described in the
GNU CC General Public License.   A copy of this license is
supposed to have been given to you along with GNU CC so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */

/* Borrow everything that is C from c-tree.h  */
#include "c-tree.h"

/* An enumeration of the kind of tags that C++ accepts.  */
enum tag_types { record_type, class_type, union_type, enum_type };

/* Zero means prototype weakly, as in ANSI C (no args means nothing).  */
extern int strict_prototype;
/* Non-zero means that if a label exists, and no other identifier
   applies, use the value of the label.  */
extern int flag_labels_ok;

/* in decl.c */
extern tree vtable_entry_type;
extern tree build_vtable_entry ();
extern tree build_vtable_ref ();
extern tree finish_table ();

extern tree lookup_some_tag ();
extern void hack_incomplete_structures ();

/* The largest size a virtual function table can be.
   Must be a (power of 2).  */
#define VINDEX_MAX ((unsigned)128)
/* This is the integer ~ (vindex_max - 1).  */
extern tree vtbl_mask;

/* Array type `(void *)[]' */
extern tree vtbl_type_node;

extern tree get_parm_types ();
extern tree grokopexpr (), getaggrs (), groktypefield ();
extern void finish_anon_union();
extern tree long_long_integer_type_node, long_long_unsigned_type_node;
extern tree get_first_matching_virtual ();

/* in typecheck.c */
extern tree build_x_conditional_expr ();
extern tree build_x_unary_op (), build_x_binary_op ();
extern tree build_x_function_call ();
extern tree build_x_indirect_ref (), build_x_array_ref ();
extern tree build_x_modify_expr (), build_x_modify_op_expr ();

extern tree build_m_component_ref ();
extern tree build_component_type_expr ();
extern tree build_x_arrow ();

extern tree datatype (), unary_complex_lvalue ();
extern tree build_return_stmt ();
extern tree actualparameterlist ();

/* in tree.c */
extern tree build_let ();

/* in overload.c */
extern tree current_class_name;
extern tree current_class_type;

extern tree hack_identifier (), hack_operator (), hack_wrapper ();
extern tree convert_to_nonzero_pointer (), convert_to_reference (), convert_to_aggr ();
extern tree build_x_new (), build_x_delete ();
extern tree build_new (), build_vec_new (), build_delete (), build_vec_delete ();
extern tree make_destructor_name ();
extern tree build_scoped_ref (), build_classfn_ref (), build_virtual_ref ();
extern tree build_type_pathname ();
extern tree do_actual_overload ();
extern tree start_method (), start_type_method ();
extern void finish_method ();

extern tree lookup_field (), lookup_fnfields ();

void pushclass (), popclass (), pushclasstype ();
extern tree build_operator_fnname (), build_opfncall (), build_type_conversion ();
extern tree build_wrapper ();

/* Points to the name of that function. May not be the DECL_NAME
   of CURRENT_FUNCTION_DECL due to overloading */
extern tree current_function_name;

/* See comments in `overload.c' */
# define IS_AGGR_TYPE(t) \
  (TREE_CODE (t) == RECORD_TYPE \
   || TREE_CODE (t) == UNION_TYPE)

# define IS_AGGR_TYPE_CODE(t) \
  (t == RECORD_TYPE \
   || t == UNION_TYPE)

extern tree do_decl_overload (), do_typename_overload ();
extern tree build_destructor_call ();
extern tree current_class_name, current_class_type, current_class_decl, C_C_D;
extern tree current_vtable_decl;

/* in init.c  */
extern tree purpose_member (), value_member ();
extern void check_base_init ();
extern void do_member_init ();
extern tree global_base_init_list;
extern tree current_base_init_list, current_member_init_list;
#ifdef SOS
extern tree get_linktable_name (), get_dtable_name (), get_sos_dtable ();
#endif

extern tree build_member_call (), build_member_ref ();

extern int current_function_assigns_this;
extern int current_function_just_assigned_this;

/* Cannot use '$' up front, because this confuses gdb.
   Note that any format of this kind *must* make the
   format for `this' lexicgraphically less than any other
   parameter name, i.e. "$this" is less than anything else can be.

   Note that all forms in which the '$' is significant are long enough
   for direct indexing.  */

#define THIS_NAME "$this"
#define VPTR_NAME "$vptr"
#define DESTRUCTOR_NAME_FORMAT "~%s"
#define DESTRUCTOR_DECL_FORMAT "_$_%s"
#define WRAPPER_NAME_FORMAT "()%s"
#define WRAPPER_DECL_FORMAT "__W$%s"
#define WRAPPER_PRED_NAME_FORMAT "()?%s"
#define WRAPPER_PRED_DECL_FORMAT "__P$%s"
#define ANTI_WRAPPER_NAME_FORMAT "~()%s"
#define ANTI_WRAPPER_DECL_FORMAT "__w$%s"
#define AUTO_DELETE_NAME "__delete$me__"
#define AUTO_VTABLE_NAME "__vtbl$me__"
#define AUTO_TEMP_NAME "_$tmp_"
#define AUTO_TEMP_FORMAT "_$tmp_%d"
#define OPERATOR_ASSIGN_FORMAT "op$assign_%s"
#define OPERATOR_FORMAT "op$%s"
#define VTABLE_NAME_FORMAT "_vt$%s"
#define VFIELD_NAME "_vptr$"
#define VFIELD_NAME_FORMAT "_vptr$%s"
#define STATIC_NAME_FORMAT "_%s$%s"
#define OPERATOR_TYPENAME_FORMAT "type$"
#define FILE_FUNCTION_FORMAT "_GLOBAL_$D$%s"
#define VTABLE_OFFSET_NAME "offset"
#define VTABLE_DELTA_NAME "delta"
#define VTABLE_PFN_NAME "pfn"

#define THIS_NAME_P(ID_NODE) (IDENTIFIER_POINTER (ID_NODE)[0] == '$' \
			      && IDENTIFIER_POINTER (ID_NODE)[1] == 't')
#define VPTR_NAME_P(ID_NODE) (IDENTIFIER_POINTER (ID_NODE)[0] == '$' \
			      && IDENTIFIER_POINTER (ID_NODE)[1] == 'v')
#define DESTRUCTOR_NAME_P(ID_NODE) (IDENTIFIER_POINTER (ID_NODE)[1] == '$')

#define WRAPPER_NAME_P(ID_NODE) (IDENTIFIER_POINTER (ID_NODE)[1] == '_' \
				 && IDENTIFIER_POINTER (ID_NODE)[2] == 'W' \
				 && IDENTIFIER_POINTER (ID_NODE)[3] == '$')
#define WRAPPER_PRED_NAME_P(ID_NODE) (IDENTIFIER_POINTER (ID_NODE)[1] == '_' \
				 && IDENTIFIER_POINTER (ID_NODE)[2] == 'P' \
				 && IDENTIFIER_POINTER (ID_NODE)[3] == '$')
#define ANTI_WRAPPER_NAME_P(ID_NODE) (IDENTIFIER_POINTER (ID_NODE)[1] == '_' \
				      && IDENTIFIER_POINTER (ID_NODE)[2] == 'w' \
				      && IDENTIFIER_POINTER (ID_NODE)[3] == '$')
#define WRAPPER_OR_ANTI_WRAPPER_NAME_P(ID_NODE) \
  (IDENTIFIER_POINTER (ID_NODE)[1] == '_' \
   && (IDENTIFIER_POINTER (ID_NODE)[2]|('W'^'w')) == 'w' \
   && IDENTIFIER_POINTER (ID_NODE)[3] == '$')

#define OPERATOR_NAME_P(ID_NODE) (IDENTIFIER_POINTER (ID_NODE)[2] == '$' \
  && IDENTIFIER_POINTER (ID_NODE)[1])

#define VTABLE_NAME_P(ID_NODE) (IDENTIFIER_POINTER (ID_NODE)[3] == '$' \
  && IDENTIFIER_POINTER (ID_NODE)[2] == 't'\
  && IDENTIFIER_POINTER (ID_NODE)[1] == 'v')

#define OPERATOR_TYPENAME_P(ID_NODE) (IDENTIFIER_POINTER (ID_NODE)[4] == '$' \
  && IDENTIFIER_POINTER (ID_NODE)[3] \
  && IDENTIFIER_POINTER (ID_NODE)[2] \
  && IDENTIFIER_POINTER (ID_NODE)[1])

#define TEMP_NAME_P(ID_NODE) (!strncmp (IDENTIFIER_POINTER (ID_NODE), AUTO_TEMP_NAME, sizeof (AUTO_TEMP_NAME)-1))
#define VFIELD_NAME_P(ID_NODE) (!strncmp (IDENTIFIER_POINTER (ID_NODE), VFIELD_NAME, sizeof(VFIELD_NAME)-1))

/* For anonymous aggregate types, we need some sort of name to
   hold on to.  In practice, this should not appear, but it should
   not be harmful if it does.  */
#define ANON_AGGRNAME_FORMAT "$_%d"
#define ANON_AGGRNAME_P(ID_NODE) (IDENTIFIER_POINTER (ID_NODE)[0] == '$')

#define ANON_PARMNAME_FORMAT "_%d"
#define ANON_PARMNAME_P(ID_NODE) (IDENTIFIER_POINTER (ID_NODE)[0] == '_' \
				  && IDENTIFIER_POINTER (ID_NODE)[1] <= '9')

enum visibility_type {
  visibility_default,
  visibility_public,
  visibility_private,
  visibility_protected,
  visibility_default_virtual,
  visibility_public_virtual,
  visibility_private_virtual,
};

enum visibility_type compute_visibility ();

/* in lex.c  */
/* Things for handling inline functions.  */

struct pending_inline
{
  struct pending_inline *next;	/* pointer to next in chain */
  int lineno;			/* line number we got the text from */
  char *filename;		/* name of file we were processing */
  tree fndecl;			/* FUNCTION_DECL that brought us here */
  int token;			/* token we were scanning */
  int token_value;		/* value of token we were scanning (YYSTYPE) */

  char *buf;			/* pointer to character stream */
  int len;			/* length of stream */
};

extern tree combine_strings ();

/* in method.c */
extern tree wrapper_name, wrapper_pred_name, anti_wrapper_name;
extern struct pending_inline *pending_inlines;
extern struct pending_inline *stash_inline_prefix ();
extern char *print_fndecl_with_types ();

/* 1 for -fall-virtual: make every member function (except
   constructors) lay down in the virtual function table.
   Calls can then either go through the virtual function table or not,
   depending on whether we know what function will actually be called.

   2 for -fSOS: make every member function (including constructors)
   lay down in the virtual function table.  All calls go through the
   virtual function table: this takes the place of using a linker.  */

extern int flag_all_virtual;

/* Nonzero to make characters constants have the data type `char'.
   This data type is signed or unsigned depending on flag_signed_char.  */

extern int flag_char_charconst;

/* Nonzero used to enable ANSI brain-damaged interpretation of `const'.  */

extern int flag_const_is_variable;

/* Nonzero means that we cannot make optimizing assumptions about `this'.  */

extern int flag_this_is_variable;

enum overload_flags { NO_SPECIAL = 0, DTOR_FLAG, OP_FLAG, TYPENAME_FLAG, WRAPPER_FLAG, WRAPPER_PRED_FLAG, ANTI_WRAPPER_FLAG };

extern tree default_conversion (), pushdecl (), pushdecl_top_level ();
extern tree make_instance_name (), do_decl_overload ();
extern tree maybe_build_cleanup ();
extern tree build_instantiated_decl (), instantiate_type ();
extern tree build_vtbl_ref ();
extern tree make_anon_parm_name ();
extern int resolves_to_fixed_type_p ();

extern tree do_friend ();
extern void grokclassfn ();

extern tree current_class_decl, C_C_D;	/* PARM_DECL: the class instance variable */

/* The following two can be derived from the previous one */
extern tree current_class_name;	/* IDENTIFIER_NODE: name of current class */
extern tree current_class_type;	/* _TYPE: the type of the current class */

/* The following structure is used when comparing various alternatives
   for overloading.  The unsigned quantity `strikes.i' is used
   for fast comparison of two possibilities.  This number is an
   aggregate of four constituents:

     EVIL: if this is non-zero, then the candidate should not be considered
     USER: if this is non-zero, then a user-defined type conversion is needed
     B_OR_D: if this is non-zero, then use a base pointer instead of the
             type of the pointer we started with.
     EASY: if this is non-zero, then we have a builtin conversion
           (such as int to long, int to float, etc) to do.

   If two candidates require user-defined type conversions, and the
   type conversions are not identical, then an ambiguity error
   is reported.

   If two candidates agree on user-defined type conversions,
   and one uses pointers of strictly higher type (derived where
   another uses base), then that alternative is silently chosen.

   If two candidates have a non-monotonic derived/base pointer
   relationship, and/or a non-monotonic easy conversion relationship,
   then a warning is emitted to show which paths are possible, and
   which one is being chosen.

   For example:

   int i;
   double x;

   overload f;
   int f (int, int);
   double f (double, double);

   f (i, x);	// draws a warning

   struct B
   {
     f (int);
   } *bb;
   struct D : B
   {
     f (double);
   } *dd;

   dd->f (x);	// exact match
   dd->f (i);	// draws warning

   Note that this technique really only works for 255 arguments.  Perhaps
   this is not enough.  */

struct candidate
{
  tree function;		/* A FUNCTION_DECL */

  unsigned char evil;		/* ~0 if this will never convert.  */
  unsigned char user;		/* ~0 if at least one user-defined type conv.  */
  unsigned short b_or_d;	/* count number of derived->base conv.  */
  unsigned short easy;		/* count number of builtin type conv.  */

  tree arg;			/* an _EXPR node that is first parm to function */
  union
    {
      tree field;		/* If no evil strikes, the FIELD_DECL of
				   the function (if a member function).  */
      int bad_arg;		/* the index of the first bad argument:
				   0 if no bad arguements
				   > 0 is first bad argument
				   -1 if extra actual arguments
				   -2 if too few actual arguments.  */
    } u;
};
int rank_for_overload ();

/* Anatomy of a DECL_FRIENDLIST (which is a TREE_LIST):
   purpose = friend name (IDENTIFIER_NODE);
   value = TREE_LIST of FUNCTION_DECLS;
   chain, type = EMPTY;  */
#define FRIEND_NAME(LIST) (TREE_PURPOSE (LIST))
#define FRIEND_DECLS(LIST) (TREE_VALUE (LIST))

/* Nonzero means warn about unused local variables.  */

extern int warn_unused_locals;
  
