//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that if multiple declarations of the same single
// function are present in different places in the same file,
// and if these declarations differ (as allowed) in the number
// of argument defaults provided, that correct values are
// passed at all call points anyway.

void receiver (int ii, int jj);

void sender_1 ()
{
	receiver (3,7);
}

void receiver (int ii, int jj = 9);

void sender_2 ()
{
	receiver (5);
}

int ii_sum = 0;
int jj_sum = 0;

void sender_3 ();

int main ()
{
	sender_1 ();
	sender_2 ();
	sender_3 ();
	return (ii_sum != 13 || jj_sum != 25);
}

void receiver (int ii, int jj)
{
	ii_sum += ii;
	jj_sum += jj;
}

void sender_3 ()
{
	receiver (5);
}
