//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Options: -O
//
// Check that when an int value is assigned to a short int, the proper
// half of the int (i.e. the low order half) ends up in the short.
//
// This fails with 1.32.0 with -O and f1() is inline.
//
// Workaround - declare "f1_arg" as type "short int".

short int v2;

int v1 = 0x11117777;

inline void f1 (int f1_arg)
{
	v2 = f1_arg;
}

int main ()
{
	f1 (v1);
	return (v2 != 0x00007777);
}
