//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that virtual destructors work correctly.  Specifically,
// check that when you destruct an object of a derived class for
// which the base class had an explicitly declared virtual destructor
// no infinite recursion occurs.
//
// Bug description:
//    The generated g++ code apparently calls the base class destructor via
//    the virtual table, rather than directly. This, of course, results in the
//    infinite recursion.

int errors = 0;

struct base {
	int member;
	base();
	virtual ~base();
};
  
base::base()
{
}

base::~base()
{
}

struct derived : public base
{
	int member;
	derived();
	~derived();
};
  
derived::derived() : ()
{
}

int derived_destructor_calls = 0;

extern void exit (int);

derived::~derived()
{
	if (++derived_destructor_calls > 2)
		errors++;
}

void test ();

int main ()
{
	test ();
	return errors;
}

base* bp;

void test()
{
	derived a;

	a.member = 99;
	bp = new derived;
	delete bp;
}
