//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that it is illegal to specify a return type in a
// declaration of either a constructor or a destructor.
//
// Cases:
//	void type
//	int type
//	void* type
//	class type
//	class* type
//
// Cases:
//	constructors & destructors

struct class1 {
	int member;
	void class1 ();		// ERROR
	void ~class1 ();	// ERROR
};

struct class2 {
	int member;
	int class2 ();		// ERROR
	int ~class2 ();		// ERROR
};

struct class3 {
	int member;
	void* class3 ();	// ERROR
	void* ~class3 ();	// ERROR
};

struct class4 {
	int member;
	class4 class4 ();	// ERROR
	class4 ~class4 ();	// ERROR
};

struct class5 {
	int member;
	class5* class5 ();	// ERROR
	class5* ~class5 ();	// ERROR
};
