//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that it is possible to use the address of member function
// in an initialization or in an assignment.
//
// Cases:
//	overloaded member functions
//	overloaded virtual member functions
//
// Cases:
//	initialization for storage class 'static' objects
//	initialization for storage class 'auto' objects
//	assignment to storage class 'auto' objects
//
// Cases:
//	member function name preceeded by &
//	member function name *not* preceeded by &

struct base {
	int data_member;

	int member_function_1 () { return 0; }
	int member_function_1 (int i, int j) { return i+j; }
	virtual int member_function_2 () { return 0; }
	virtual int member_function_2 (int i, int j) { return 0; }
};

typedef base* (base::*base_mfp_basep_void) ();
typedef base* (base::*base_mfp_basep_int_int) (int, int);
typedef int (base::*base_mfp_int_void) ();
typedef int (base::*base_mfp_int_int_int) (int, int);
typedef void (base::*base_mfp_void_void) ();

base_mfp_int_void	static_p2 = base::member_function_1;
base_mfp_int_int_int	static_p3 = base::member_function_1;
base_mfp_int_void	static_p4 = base::member_function_2;
base_mfp_int_int_int	static_p5 = base::member_function_2;

base_mfp_int_void	static_q2 = &base::member_function_1;
base_mfp_int_int_int	static_q3 = &base::member_function_1;
base_mfp_int_void	static_q4 = &base::member_function_2;
base_mfp_int_int_int	static_q5 = &base::member_function_2;

void test ()
{
	base_mfp_int_void	auto_p2 = base::member_function_1;
	base_mfp_int_int_int	auto_p3 = base::member_function_1;
	base_mfp_int_void	auto_p4 = base::member_function_2;
	base_mfp_int_int_int	auto_p5 = base::member_function_2;
	
	base_mfp_int_void	auto_q2 = &base::member_function_1;
	base_mfp_int_int_int	auto_q3 = &base::member_function_1;
	base_mfp_int_void	auto_q4 = &base::member_function_2;
	base_mfp_int_int_int	auto_q5 = &base::member_function_2;

	auto_p2 = base::member_function_1;
	auto_p3 = base::member_function_1;
	auto_p4 = base::member_function_2;
	auto_p5 = base::member_function_2;
	
	auto_q2 = &base::member_function_1;
	auto_q3 = &base::member_function_1;
	auto_q4 = &base::member_function_2;
	auto_q5 = &base::member_function_2;
}

int main ()
{
	return 0;
}
