//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that it is legal to declare binary operators with
// either one or two default values for their formal arguments.
// Check the subscripting operator [] as well as normal operators.

struct s1 {
	int v;
};

struct s2 {
	int v;
};

s1 s1_object;
s2 s2_object;

int operator + (s1 st1, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator - (s1 st1, s1 st2 = s1_object) { return st1.v + st2.v; }

int operator * (s1 st1, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator / (s1 st1, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator % (s1 st1, s1 st2 = s1_object) { return st1.v + st2.v; }

int operator & (s1 st1, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator | (s1 st1, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator ^ (s1 st1, s1 st2 = s1_object) { return st1.v + st2.v; }

int operator && (s1 st1, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator || (s1 st1, s1 st2 = s1_object) { return st1.v + st2.v; }

int operator >> (s1 st1, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator << (s1 st1, s1 st2 = s1_object) { return st1.v + st2.v; }

// 6 comparison operators
int operator == (s1 st1, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator != (s1 st1, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator >= (s1 st1, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator <= (s1 st1, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator > (s1 st1, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator < (s1 st1, s1 st2 = s1_object) { return st1.v + st2.v; }

// operate and replace operators
int operator += (s1 st1, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator -= (s1 st1, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator *= (s1 st1, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator /= (s1 st1, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator %= (s1 st1, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator ^= (s1 st1, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator &= (s1 st1, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator |= (s1 st1, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator >>= (s1 st1, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator <<= (s1 st1, s1 st2 = s1_object) { return st1.v + st2.v; }

int operator + (s2 st1 = s2_object, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator - (s2 st1 = s2_object, s1 st2 = s1_object) { return st1.v + st2.v; }

int operator * (s2 st1 = s2_object, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator / (s2 st1 = s2_object, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator % (s2 st1 = s2_object, s1 st2 = s1_object) { return st1.v + st2.v; }

int operator & (s2 st1 = s2_object, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator | (s2 st1 = s2_object, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator ^ (s2 st1 = s2_object, s1 st2 = s1_object) { return st1.v + st2.v; }

int operator && (s2 st1 = s2_object, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator || (s2 st1 = s2_object, s1 st2 = s1_object) { return st1.v + st2.v; }

int operator >> (s2 st1 = s2_object, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator << (s2 st1 = s2_object, s1 st2 = s1_object) { return st1.v + st2.v; }

// 6 comparison operators
int operator == (s2 st1 = s2_object, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator != (s2 st1 = s2_object, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator >= (s2 st1 = s2_object, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator <= (s2 st1 = s2_object, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator > (s2 st1 = s2_object, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator < (s2 st1 = s2_object, s1 st2 = s1_object) { return st1.v + st2.v; }

// operate and replace operators
int operator += (s2 st1 = s2_object, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator -= (s2 st1 = s2_object, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator *= (s2 st1 = s2_object, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator /= (s2 st1 = s2_object, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator %= (s2 st1 = s2_object, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator ^= (s2 st1 = s2_object, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator &= (s2 st1 = s2_object, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator |= (s2 st1 = s2_object, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator >>= (s2 st1 = s2_object, s1 st2 = s1_object) { return st1.v + st2.v; }
int operator <<= (s2 st1 = s2_object, s1 st2 = s1_object) { return st1.v + st2.v; }

struct base {
	int operator + (s1 st1 = s1_object) { return st1.v; }
	int operator - (s1 st1 = s1_object) { return st1.v; }

	int operator * (s1 st1 = s1_object) { return st1.v; }
	int operator / (s1 st1 = s1_object) { return st1.v; }
	int operator % (s1 st1 = s1_object) { return st1.v; }

	int operator & (s1 st1 = s1_object) { return st1.v; }
	int operator | (s1 st1 = s1_object) { return st1.v; }
	int operator ^ (s1 st1 = s1_object) { return st1.v; }

	int operator && (s1 st1 = s1_object) { return st1.v; }
	int operator || (s1 st1 = s1_object) { return st1.v; }

	int operator >> (s1 st1 = s1_object) { return st1.v; }
	int operator << (s1 st1 = s1_object) { return st1.v; }

	// 6 comparison operators
	int operator == (s1 st1 = s1_object) { return st1.v; }
	int operator != (s1 st1 = s1_object) { return st1.v; }
	int operator >= (s1 st1 = s1_object) { return st1.v; }
	int operator <= (s1 st1 = s1_object) { return st1.v; }
	int operator > (s1 st1 = s1_object) { return st1.v; }
	int operator < (s1 st1 = s1_object) { return st1.v; }

	// operate and replace operators
	int operator = (s1 st1 = s1_object) { return st1.v; }
	int operator += (s1 st1 = s1_object) { return st1.v; }
	int operator -= (s1 st1 = s1_object) { return st1.v; }
	int operator *= (s1 st1 = s1_object) { return st1.v; }
	int operator /= (s1 st1 = s1_object) { return st1.v; }
	int operator %= (s1 st1 = s1_object) { return st1.v; }
	int operator ^= (s1 st1 = s1_object) { return st1.v; }
	int operator &= (s1 st1 = s1_object) { return st1.v; }
	int operator |= (s1 st1 = s1_object) { return st1.v; }
	int operator >>= (s1 st1 = s1_object) { return st1.v; }
	int operator <<= (s1 st1 = s1_object) { return st1.v; }

	int operator [] (s1 st1 = s1_object) { return st1.v; }
};

int main ()
{
	return 0;
}
