//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that a redeclaration of a member may add some new formal
// argument defaults.
//
// The c++ "manual" says that "... a declaration may add default
// arguments not given in previous declarations"  This privledge
// should probably extend to member declarations and function
// declarations alike.

struct base {
	int base_member;

	base () {}

	void member1 (int arg1, int arg2);

	void member2 ()
	{
		member1 (33,44);
	}

	void member1 (int arg1, int arg2 = 11);	// add a default

	void member3 ()
	{
		member1 (7);
	}
};

int main ()
{
	base base_object;

	base_object.member1 (88,99);
	base_object.member1 (77);
	return 0;
}

void member1 (int arg1 = 22, int arg2 = 11)	// add another default
{
	return;
}

void test ()
{
	base base_object;

	base_object.member1 ();
}
