//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Options: -fall-virtual
//
// Check that overloaded method call operators are properly called
// even when their results are subsequently re-cast and then
// assigned to a reference variable.
//
// Note: this fails on 1.32.0.5 with -fall-virtual

struct future
{
    int operator int();
};

struct futref
{
    futref() {};
    futref(int*);
    int operator int();
    future operator future();
};

struct add_stuff;

//typedef int (add_stuff::*MF)(int);
typedef int MF;

struct add_stuff
{
  int iii;

  int add_stuff_function(int);
  futref operator->()(MF , int , ...);
};


void test()
{
	add_stuff* add_stuff_pointer_object;
	add_stuff_pointer_object = new add_stuff;
	future& v = add_stuff_pointer_object->add_stuff_function(17);
	v = v;
}

int method_call_op_called = 0;

int main ()
{
	test ();
        return (method_call_op_called == 0) ? 1
	         : (method_call_op_called != 1) ? 1
		   : 0;
}

int future::operator int ()
{
	return 0;
}

future future_dummy;
futref futref_dummy;

futref::futref(int* i)
{
	//printf ("futref::futref(int*) called\n");
}


int futref::operator int()
{
	//printf ("futref::operator int() called\n");
	return futref_dummy;
}

future futref::operator future()
{
	// printf ("futref::operator future() called\n");
	return future_dummy;
}

int add_stuff::add_stuff_function(int)
{
	//printf ("add_stuff::add_stuff_function(int) called\n");
	return 0;
}

futref add_stuff::operator->()(MF member_function, int arg_count , ...)
{
	method_call_op_called++;
	return futref_dummy;
}
