#ifndef CYGONCE_LIBM_MODF_H
#define CYGONCE_LIBM_MODF_H
//===========================================================================
//
//      modf.h
//
//      Test vectors for testing of modf() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   jlarmour
// Contributors:  jlarmour
// Date:        1998-02-13
// Purpose:     
// Description: 
// Usage:       #include "vectors/modf.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support.h"// extra support for math tests

#define MODF_TOLERANCE 1.0E-04

static const Cyg_libm_test_double_vec_t modf_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{ 1, 1077999148u, 2506787616u, 1077968896u, 0u, 1072532261u, 1520617472u, 0, MODF_TOLERANCE, 0},
{ 2, 1090024059u, 3619148316u, 1090024048u, 0u, 1072148335u, 2755133440u, 0, MODF_TOLERANCE, 0},
{ 3, 3218153654u, 3176730980u, 2147483648u, 0u, 3218153654u, 3176730980u, 0, MODF_TOLERANCE, 0},
{ 4, 1051524793u, 2993920299u, 0u, 0u, 1051524793u, 2993920299u, 0, MODF_TOLERANCE, 0},
{ 5, 3239659803u, 2725707538u, 3239659800u, 0u, 3219985335u, 4170186752u, 0, MODF_TOLERANCE, 0},
{ 6, 3232101343u, 2346810316u, 3232100864u, 0u, 3220043966u, 398245888u, 0, MODF_TOLERANCE, 0},
{ 7, 1092554362u, 2088062470u, 1092554360u, 0u, 1071899562u, 1882193920u, 0, MODF_TOLERANCE, 0},
{ 8, 3201242716u, 420891118u, 2147483648u, 0u, 3201242716u, 420891118u, 0, MODF_TOLERANCE, 0},
{ 9, 3221200677u, 2636405208u, 3220176896u, 0u, 3220127307u, 977843120u, 0, MODF_TOLERANCE, 0},
{ 10, 1100049309u, 471635570u, 1100049309u, 469762048u, 1067226738u, 0u, 0, MODF_TOLERANCE, 0},
{ 11, 1089363191u, 1746012320u, 1089363168u, 0u, 1072130066u, 144703488u, 0, MODF_TOLERANCE, 0},
{ 12, 1054478713u, 3333988501u, 0u, 0u, 1054478713u, 3333988501u, 0, MODF_TOLERANCE, 0},
{ 13, 1047953160u, 183014794u, 0u, 0u, 1047953160u, 183014794u, 0, MODF_TOLERANCE, 0},
{ 14, 3202039382u, 2016785810u, 2147483648u, 0u, 3202039382u, 2016785810u, 0, MODF_TOLERANCE, 0},
{ 15, 3213486034u, 2688957927u, 2147483648u, 0u, 3213486034u, 2688957927u, 0, MODF_TOLERANCE, 0},
{ 16, 1046089230u, 2709029994u, 0u, 0u, 1046089230u, 2709029994u, 0, MODF_TOLERANCE, 0},
{ 17, 1058795730u, 624574473u, 0u, 0u, 1058795730u, 624574473u, 0, MODF_TOLERANCE, 0},
{ 18, 1045840574u, 3473266330u, 0u, 0u, 1045840574u, 3473266330u, 0, MODF_TOLERANCE, 0},
{ 19, 3204919842u, 1605286142u, 2147483648u, 0u, 3204919842u, 1605286142u, 0, MODF_TOLERANCE, 0},
{ 20, 1068931671u, 4233776869u, 0u, 0u, 1068931671u, 4233776869u, 0, MODF_TOLERANCE, 0},
{ 21, 1060343410u, 1857607719u, 0u, 0u, 1060343410u, 1857607719u, 0, MODF_TOLERANCE, 0},
{ 22, 3222889559u, 3417070006u, 3222798336u, 0u, 3218490748u, 3133512544u, 0, MODF_TOLERANCE, 0},
{ 23, 1103599987u, 3981151660u, 1103599987u, 3976200192u, 1071833963u, 0u, 0, MODF_TOLERANCE, 0},
{ 24, 1088899021u, 1332651746u, 1088899008u, 0u, 1071292125u, 1304690688u, 0, MODF_TOLERANCE, 0},
{ 25, 1085298022u, 3824988054u, 1085297920u, 0u, 1071233279u, 736460800u, 0, MODF_TOLERANCE, 0},
{ 26, 1066856791u, 2070129652u, 0u, 0u, 1066856791u, 2070129652u, 0, MODF_TOLERANCE, 0},
{ 27, 3207559790u, 1372884064u, 2147483648u, 0u, 3207559790u, 1372884064u, 0, MODF_TOLERANCE, 0},
{ 28, 1080833116u, 3229926662u, 1080827904u, 0u, 1071930560u, 2227504640u, 0, MODF_TOLERANCE, 0},
{ 29, 1093826501u, 3217805330u, 1093826501u, 0u, 1072167290u, 37748736u, 0, MODF_TOLERANCE, 0},
{ 30, 3191644264u, 2014578707u, 2147483648u, 0u, 3191644264u, 2014578707u, 0, MODF_TOLERANCE, 0},
{ 31, 1102287487u, 265058758u, 1102287487u, 251658240u, 1072271160u, 3221225472u, 0, MODF_TOLERANCE, 0},
{ 32, 3239903247u, 1630600647u, 3239903244u, 0u, 3219851655u, 3996647424u, 0, MODF_TOLERANCE, 0},
{ 33, 1071124229u, 1946677669u, 0u, 0u, 1071124229u, 1946677669u, 0, MODF_TOLERANCE, 0},
{ 34, 3198462609u, 926009897u, 2147483648u, 0u, 3198462609u, 926009897u, 0, MODF_TOLERANCE, 0},
{ 35, 1072130299u, 2271884183u, 0u, 0u, 1072130299u, 2271884183u, 0, MODF_TOLERANCE, 0},
{ 36, 3203741999u, 2118617783u, 2147483648u, 0u, 3203741999u, 2118617783u, 0, MODF_TOLERANCE, 0},
{ 37, 3194849109u, 213658772u, 2147483648u, 0u, 3194849109u, 213658772u, 0, MODF_TOLERANCE, 0},
{ 38, 3249401130u, 314151656u, 3249401130u, 301989888u, 3218551389u, 0u, 0, MODF_TOLERANCE, 0},
{ 39, 3254112288u, 1564829925u, 3254112288u, 1564475392u, 3218449300u, 0u, 0, MODF_TOLERANCE, 0},
{ 40, 3197817016u, 497230814u, 2147483648u, 0u, 3197817016u, 497230814u, 0, MODF_TOLERANCE, 0},
{ 41, 3216262634u, 2075329122u, 2147483648u, 0u, 3216262634u, 2075329122u, 0, MODF_TOLERANCE, 0},
{ 42, 3231746400u, 169900577u, 3231746048u, 0u, 3219521698u, 128061440u, 0, MODF_TOLERANCE, 0},
{ 43, 1049848642u, 541549344u, 0u, 0u, 1049848642u, 541549344u, 0, MODF_TOLERANCE, 0},
{ 44, 1096608669u, 3119070100u, 1096608669u, 2147483648u, 1072493725u, 3388997632u, 0, MODF_TOLERANCE, 0},
{ 45, 1085427055u, 567496114u, 1085426944u, 0u, 1071368308u, 3547103232u, 0, MODF_TOLERANCE, 0},
{ 46, 1045286891u, 1969998540u, 0u, 0u, 1045286891u, 1969998540u, 0, MODF_TOLERANCE, 0},
{ 47, 1060548195u, 1299369769u, 0u, 0u, 1060548195u, 1299369769u, 0, MODF_TOLERANCE, 0},
{ 48, 1049342524u, 4167404066u, 0u, 0u, 1049342524u, 4167404066u, 0, MODF_TOLERANCE, 0},
{ 49, 3208865645u, 3348930841u, 2147483648u, 0u, 3208865645u, 3348930841u, 0, MODF_TOLERANCE, 0},
{ 50, 1078472138u, 358457347u, 1078460416u, 0u, 1071047946u, 2932867456u, 0, MODF_TOLERANCE, 0},
{ 51, 1071069297u, 2192461366u, 0u, 0u, 1071069297u, 2192461366u, 0, MODF_TOLERANCE, 0},
{ 52, 1099527247u, 3184735642u, 1099527247u, 3087007744u, 1072123094u, 1744830464u, 0, MODF_TOLERANCE, 0},
{ 53, 1052861772u, 331696577u, 0u, 0u, 1052861772u, 331696577u, 0, MODF_TOLERANCE, 0},
{ 54, 3189610016u, 793242270u, 2147483648u, 0u, 3189610016u, 793242270u, 0, MODF_TOLERANCE, 0},
{ 55, 3252528934u, 2322696981u, 3252528934u, 2319450112u, 3219703178u, 2147483648u, 0, MODF_TOLERANCE, 0},
{ 56, 1083791358u, 3020766674u, 1083790336u, 0u, 1072690592u, 1777242112u, 0, MODF_TOLERANCE, 0},
{ 57, 1044902177u, 252085215u, 0u, 0u, 1044902177u, 252085215u, 0, MODF_TOLERANCE, 0},
{ 58, 3214426435u, 4139068910u, 2147483648u, 0u, 3214426435u, 4139068910u, 0, MODF_TOLERANCE, 0},
{ 59, 3222505725u, 105589263u, 3222274048u, 0u, 3219933160u, 844714104u, 0, MODF_TOLERANCE, 0},
{ 60, 1056316170u, 261630827u, 0u, 0u, 1056316170u, 261630827u, 0, MODF_TOLERANCE, 0},
{ 61, 1107213408u, 428765703u, 1107213408u, 427819008u, 1072489486u, 0u, 0, MODF_TOLERANCE, 0},
{ 62, 3251828686u, 2009972239u, 3251828686u, 2009071616u, 3217783838u, 0u, 0, MODF_TOLERANCE, 0},
{ 63, 1098568019u, 3517376586u, 1098568019u, 3489660928u, 1069182596u, 2684354560u, 0, MODF_TOLERANCE, 0},
{ 64, 3240257920u, 3304487302u, 3240257920u, 0u, 3218644687u, 817889280u, 0, MODF_TOLERANCE, 0},
{ 65, 3233537912u, 237004814u, 3233537792u, 0u, 3218998152u, 436436992u, 0, MODF_TOLERANCE, 0},
{ 66, 3237899261u, 3364008659u, 3237899248u, 0u, 3219886341u, 1705377792u, 0, MODF_TOLERANCE, 0},
{ 67, 3195247552u, 472004928u, 2147483648u, 0u, 3195247552u, 472004928u, 0, MODF_TOLERANCE, 0},
{ 68, 3226869477u, 1186387580u, 3226861568u, 0u, 3219055942u, 3067509760u, 0, MODF_TOLERANCE, 0},
{ 69, 1054226850u, 4085763910u, 0u, 0u, 1054226850u, 4085763910u, 0, MODF_TOLERANCE, 0},
{ 70, 1106394906u, 2684738273u, 1106394906u, 2684354560u, 1071082372u, 0u, 0, MODF_TOLERANCE, 0},
{ 71, 1057053639u, 2055490142u, 0u, 0u, 1057053639u, 2055490142u, 0, MODF_TOLERANCE, 0},
{ 72, 3231581370u, 3879040079u, 3231581184u, 0u, 3217513702u, 2928271360u, 0, MODF_TOLERANCE, 0},
{ 73, 3188976647u, 3725731239u, 2147483648u, 0u, 3188976647u, 3725731239u, 0, MODF_TOLERANCE, 0},
{ 74, 1061652681u, 591292963u, 0u, 0u, 1061652681u, 591292963u, 0, MODF_TOLERANCE, 0},
{ 75, 3225014981u, 1147041027u, 3224961024u, 0u, 3219806376u, 2345574496u, 0, MODF_TOLERANCE, 0},
{ 76, 3215417793u, 624695933u, 2147483648u, 0u, 3215417793u, 624695933u, 0, MODF_TOLERANCE, 0},
{ 77, 3206052774u, 705725219u, 2147483648u, 0u, 3206052774u, 705725219u, 0, MODF_TOLERANCE, 0},
{ 78, 3238067573u, 1116238321u, 3238067568u, 0u, 3219458593u, 3351511040u, 0, MODF_TOLERANCE, 0},
{ 79, 3207367088u, 7287411u, 2147483648u, 0u, 3207367088u, 7287411u, 0, MODF_TOLERANCE, 0},
{ 80, 1045917232u, 116067742u, 0u, 0u, 1045917232u, 116067742u, 0, MODF_TOLERANCE, 0},
{ 81, 3240055222u, 3604989074u, 3240055220u, 0u, 3219568382u, 613416960u, 0, MODF_TOLERANCE, 0},
{ 82, 1066381836u, 545298780u, 0u, 0u, 1066381836u, 545298780u, 0, MODF_TOLERANCE, 0},
{ 83, 3219080936u, 1681476121u, 2147483648u, 0u, 3219080936u, 1681476121u, 0, MODF_TOLERANCE, 0},
{ 84, 1060345752u, 3553822398u, 0u, 0u, 1060345752u, 3553822398u, 0, MODF_TOLERANCE, 0},
{ 85, 1102831658u, 3410480388u, 1102831658u, 3405774848u, 1070723905u, 0u, 0, MODF_TOLERANCE, 0},
{ 86, 1052460275u, 1660607230u, 0u, 0u, 1052460275u, 1660607230u, 0, MODF_TOLERANCE, 0},
{ 87, 1089216869u, 1494984673u, 1089216864u, 0u, 1069900910u, 2676228096u, 0, MODF_TOLERANCE, 0},
{ 88, 3196647153u, 287894723u, 2147483648u, 0u, 3196647153u, 287894723u, 0, MODF_TOLERANCE, 0},
{ 89, 1054885127u, 644548665u, 0u, 0u, 1054885127u, 644548665u, 0, MODF_TOLERANCE, 0},
{ 90, 1081948134u, 2442134629u, 1081946112u, 0u, 1071618630u, 1074893824u, 0, MODF_TOLERANCE, 0},
{ 91, 1087554095u, 2312530895u, 1087554048u, 0u, 1072153835u, 904364032u, 0, MODF_TOLERANCE, 0},
{ 92, 3221584595u, 3379665576u, 3221225472u, 0u, 3219516239u, 633760416u, 0, MODF_TOLERANCE, 0},
{ 93, 1096085375u, 3018463866u, 1096085375u, 2147483648u, 1072297229u, 1023410176u, 0, MODF_TOLERANCE, 0},
{ 94, 1086226574u, 404012923u, 1086226432u, 0u, 1071760130u, 2549047296u, 0, MODF_TOLERANCE, 0},
{ 95, 1064733299u, 1710279345u, 0u, 0u, 1064733299u, 1710279345u, 0, MODF_TOLERANCE, 0},
{ 96, 3251401196u, 3528946000u, 3251401196u, 3523215360u, 3219512404u, 0u, 0, MODF_TOLERANCE, 0},
{ 97, 1061536351u, 2164450219u, 0u, 0u, 1061536351u, 2164450219u, 0, MODF_TOLERANCE, 0},
{ 98, 1083520023u, 3312018966u, 1083520000u, 0u, 1066911081u, 1712717824u, 0, MODF_TOLERANCE, 0},
{ 99, 1057248676u, 2648986431u, 0u, 0u, 1057248676u, 2648986431u, 0, MODF_TOLERANCE, 0},
{ 100, 1050330591u, 1474376550u, 0u, 0u, 1050330591u, 1474376550u, 0, MODF_TOLERANCE, 0},
{ 101, 3194422028u, 1839068700u, 2147483648u, 0u, 3194422028u, 1839068700u, 0, MODF_TOLERANCE, 0},
{ 102, 1077406406u, 3013052171u, 1077346304u, 0u, 1072519382u, 1928388960u, 0, MODF_TOLERANCE, 0},
{ 103, 1046493630u, 772102380u, 0u, 0u, 1046493630u, 772102380u, 0, MODF_TOLERANCE, 0},
{ 104, 3220729740u, 4219039958u, 3220176896u, 0u, 3219185433u, 4143112620u, 0, MODF_TOLERANCE, 0},
{ 105, 3229472221u, 3058618779u, 3229470720u, 0u, 3218568921u, 994470912u, 0, MODF_TOLERANCE, 0},
{ 106, 1046304788u, 3338676024u, 0u, 0u, 1046304788u, 3338676024u, 0, MODF_TOLERANCE, 0},
{ 107, 1051172137u, 506286854u, 0u, 0u, 1051172137u, 506286854u, 0, MODF_TOLERANCE, 0},
{ 108, 1094907481u, 2217000199u, 1094907481u, 2147483648u, 1067487988u, 469762048u, 0, MODF_TOLERANCE, 0},
{ 109, 1082428310u, 1147428263u, 1082427392u, 0u, 1071428131u, 585971712u, 0, MODF_TOLERANCE, 0},
{ 110, 1065432625u, 3034786717u, 0u, 0u, 1065432625u, 3034786717u, 0, MODF_TOLERANCE, 0},
{ 111, 1082016752u, 2844125311u, 1082015744u, 0u, 1070564684u, 792983552u, 0, MODF_TOLERANCE, 0},
{ 112, 1082985198u, 2561492677u, 1082984448u, 0u, 1071084741u, 1781934080u, 0, MODF_TOLERANCE, 0},
{ 113, 3211536916u, 704542600u, 2147483648u, 0u, 3211536916u, 704542600u, 0, MODF_TOLERANCE, 0},
{ 114, 3222902057u, 2762779203u, 3222798336u, 0u, 3218690714u, 1254794288u, 0, MODF_TOLERANCE, 0},
{ 115, 3199680614u, 184131949u, 2147483648u, 0u, 3199680614u, 184131949u, 0, MODF_TOLERANCE, 0},
{ 116, 3249723525u, 1667366082u, 3249723525u, 1660944384u, 3218636592u, 2147483648u, 0, MODF_TOLERANCE, 0},
{ 117, 3223609598u, 3904224140u, 3223584768u, 0u, 3217571770u, 762241792u, 0, MODF_TOLERANCE, 0},
{ 118, 1067056698u, 2942159914u, 0u, 0u, 1067056698u, 2942159914u, 0, MODF_TOLERANCE, 0},
{ 119, 1100636863u, 426114282u, 1100636863u, 402653184u, 1071013838u, 2684354560u, 0, MODF_TOLERANCE, 0},
{ 120, 3209056785u, 1083606355u, 2147483648u, 0u, 3209056785u, 1083606355u, 0, MODF_TOLERANCE, 0},
{ 121, 1106165945u, 3774123863u, 1106165945u, 3772776448u, 1071943511u, 0u, 0, MODF_TOLERANCE, 0},
{ 122, 1106787580u, 2722107965u, 1106787580u, 2722103296u, 1064451328u, 0u, 0, MODF_TOLERANCE, 0},
{ 123, 1088005092u, 1377734762u, 1088005056u, 0u, 1071786255u, 1211432960u, 0, MODF_TOLERANCE, 0},
{ 124, 1104232051u, 2377063483u, 1104232051u, 2373976064u, 1072139805u, 2147483648u, 0, MODF_TOLERANCE, 0},
{ 125, 1069380559u, 1029739074u, 0u, 0u, 1069380559u, 1029739074u, 0, MODF_TOLERANCE, 0},
{ 126, 1105467109u, 3062201018u, 1105467109u, 3061841920u, 1069935336u, 0u, 0, MODF_TOLERANCE, 0},
{ 127, 3234741597u, 773857656u, 3234741504u, 0u, 3219606408u, 140378112u, 0, MODF_TOLERANCE, 0},
{ 128, 3214251949u, 335833884u, 2147483648u, 0u, 3214251949u, 335833884u, 0, MODF_TOLERANCE, 0},
{ 129, 3203224610u, 1473865960u, 2147483648u, 0u, 3203224610u, 1473865960u, 0, MODF_TOLERANCE, 0},
{ 130, 1103073830u, 4000427507u, 1103073830u, 3992977408u, 1071410044u, 3221225472u, 0, MODF_TOLERANCE, 0},
{ 131, 1103185231u, 4242092620u, 1103185231u, 4236247040u, 1072057491u, 0u, 0, MODF_TOLERANCE, 0},
{ 132, 1067009473u, 14539161u, 0u, 0u, 1067009473u, 14539161u, 0, MODF_TOLERANCE, 0},
{ 133, 3192516074u, 1732245037u, 2147483648u, 0u, 3192516074u, 1732245037u, 0, MODF_TOLERANCE, 0},
{ 134, 1101371955u, 1533536108u, 1101371955u, 1509949440u, 1072070262u, 3221225472u, 0, MODF_TOLERANCE, 0},
{ 135, 3249153995u, 1833841275u, 3249153995u, 1811939328u, 3219448615u, 2952790016u, 0, MODF_TOLERANCE, 0},
{ 136, 1099430098u, 4144145552u, 1099430098u, 4026531840u, 1072433810u, 1073741824u, 0, MODF_TOLERANCE, 0},
{ 137, 3244270463u, 935007012u, 3244270463u, 0u, 3219905929u, 2449473536u, 0, MODF_TOLERANCE, 0},
{ 138, 3188865420u, 604442938u, 2147483648u, 0u, 3188865420u, 604442938u, 0, MODF_TOLERANCE, 0},
{ 139, 3206903253u, 2211464602u, 2147483648u, 0u, 3206903253u, 2211464602u, 0, MODF_TOLERANCE, 0},
{ 140, 1046255144u, 1635910526u, 0u, 0u, 1046255144u, 1635910526u, 0, MODF_TOLERANCE, 0},
{ 141, 1077871417u, 2549219008u, 1077870592u, 0u, 1065995455u, 2415263744u, 0, MODF_TOLERANCE, 0},
{ 142, 3231633258u, 3733639385u, 3231632384u, 0u, 3219871476u, 1451673600u, 0, MODF_TOLERANCE, 0},
{ 143, 1082095089u, 1819374372u, 1082093568u, 0u, 1071105457u, 3318517760u, 0, MODF_TOLERANCE, 0},
{ 144, 3202219056u, 2617077637u, 2147483648u, 0u, 3202219056u, 2617077637u, 0, MODF_TOLERANCE, 0},
{ 145, 1094345280u, 546465680u, 1094345280u, 0u, 1069566259u, 3355443200u, 0, MODF_TOLERANCE, 0},
{ 146, 1048653554u, 532401530u, 0u, 0u, 1048653554u, 532401530u, 0, MODF_TOLERANCE, 0},
{ 147, 1044571091u, 2759019783u, 0u, 0u, 1044571091u, 2759019783u, 0, MODF_TOLERANCE, 0},
{ 148, 3221570188u, 3554409630u, 3221225472u, 0u, 3219458611u, 1332736632u, 0, MODF_TOLERANCE, 0},
{ 149, 3212931282u, 2527221960u, 2147483648u, 0u, 3212931282u, 2527221960u, 0, MODF_TOLERANCE, 0},
{ 150, 1099107978u, 2696971136u, 1099107978u, 2684354560u, 1069027440u, 0u, 0, MODF_TOLERANCE, 0},
{ 151, 1097158000u, 173134582u, 1097158000u, 0u, 1070900133u, 3959422976u, 0, MODF_TOLERANCE, 0},
{ 152, 1087299442u, 2877794600u, 1087299328u, 0u, 1072474849u, 3930718208u, 0, MODF_TOLERANCE, 0},
{ 153, 1086400474u, 547642046u, 1086400384u, 0u, 1072072745u, 380600320u, 0, MODF_TOLERANCE, 0},
{ 154, 3197285510u, 3521286127u, 2147483648u, 0u, 3197285510u, 3521286127u, 0, MODF_TOLERANCE, 0},
{ 155, 1074860702u, 1231582831u, 1074790400u, 0u, 1070672356u, 2525456112u, 0, MODF_TOLERANCE, 0},
{ 156, 1090971734u, 1653446832u, 1090971728u, 0u, 1072269878u, 1656750080u, 0, MODF_TOLERANCE, 0},
{ 157, 1061342535u, 3762182190u, 0u, 0u, 1061342535u, 3762182190u, 0, MODF_TOLERANCE, 0},
{ 158, 3252967851u, 2615360375u, 3252967851u, 2615148544u, 3216628664u, 0u, 0, MODF_TOLERANCE, 0},
{ 159, 3200834423u, 2588067350u, 2147483648u, 0u, 3200834423u, 2588067350u, 0, MODF_TOLERANCE, 0},
{ 160, 3206610957u, 3551059728u, 2147483648u, 0u, 3206610957u, 3551059728u, 0, MODF_TOLERANCE, 0},
{ 161, 3206978856u, 845263327u, 2147483648u, 0u, 3206978856u, 845263327u, 0, MODF_TOLERANCE, 0},
{ 162, 1073415902u, 1749010288u, 1072693248u, 0u, 1072041404u, 3498020576u, 0, MODF_TOLERANCE, 0},
{ 163, 3205576370u, 3092685191u, 2147483648u, 0u, 3205576370u, 3092685191u, 0, MODF_TOLERANCE, 0},
{ 164, 3190678390u, 2872219490u, 2147483648u, 0u, 3190678390u, 2872219490u, 0, MODF_TOLERANCE, 0},
{ 165, 3218315055u, 4107255722u, 2147483648u, 0u, 3218315055u, 4107255722u, 0, MODF_TOLERANCE, 0},
{ 166, 3205337291u, 3069068345u, 2147483648u, 0u, 3205337291u, 3069068345u, 0, MODF_TOLERANCE, 0},
{ 167, 3243990857u, 2294867524u, 3243990857u, 2147483648u, 3217134028u, 2281701376u, 0, MODF_TOLERANCE, 0},
{ 168, 3216653996u, 2860384670u, 2147483648u, 0u, 3216653996u, 2860384670u, 0, MODF_TOLERANCE, 0},
{ 169, 3193326350u, 2265437201u, 2147483648u, 0u, 3193326350u, 2265437201u, 0, MODF_TOLERANCE, 0},
{ 170, 3240198679u, 1234948614u, 3240198678u, 0u, 3219429821u, 543162368u, 0, MODF_TOLERANCE, 0},
{ 171, 3216359929u, 1186945904u, 2147483648u, 0u, 3216359929u, 1186945904u, 0, MODF_TOLERANCE, 0},
{ 172, 3251167793u, 1896750851u, 3251167793u, 1895825408u, 3216784902u, 0u, 0, MODF_TOLERANCE, 0},
{ 173, 1081575478u, 3686084548u, 1081573376u, 0u, 1071672759u, 1784645632u, 0, MODF_TOLERANCE, 0},
{ 174, 1079286273u, 3309277689u, 1079279616u, 0u, 1071251909u, 1066531072u, 0, MODF_TOLERANCE, 0},
{ 175, 3223476240u, 3006860614u, 3223453696u, 0u, 3217425452u, 3460518272u, 0, MODF_TOLERANCE, 0},
{ 176, 3231412671u, 2504194724u, 3231412224u, 0u, 3218864468u, 799686656u, 0, MODF_TOLERANCE, 0},
{ 177, 3236149260u, 1948717780u, 3236149248u, 0u, 3218663502u, 631767040u, 0, MODF_TOLERANCE, 0},
{ 178, 1048317852u, 3791803982u, 0u, 0u, 1048317852u, 3791803982u, 0, MODF_TOLERANCE, 0},
{ 179, 1064345015u, 4272034420u, 0u, 0u, 1064345015u, 4272034420u, 0, MODF_TOLERANCE, 0},
{ 180, 3192982124u, 1526175922u, 2147483648u, 0u, 3192982124u, 1526175922u, 0, MODF_TOLERANCE, 0},
{ 181, 3245817826u, 4108948538u, 3245817826u, 4026531840u, 3218318928u, 3892314112u, 0, MODF_TOLERANCE, 0},
{ 182, 1104691287u, 640541190u, 1104691287u, 637534208u, 1072099587u, 0u, 0, MODF_TOLERANCE, 0},
{ 183, 3207257417u, 3259274853u, 2147483648u, 0u, 3207257417u, 3259274853u, 0, MODF_TOLERANCE, 0},
{ 184, 1082507103u, 3677038020u, 1082505216u, 0u, 1072529260u, 2895581184u, 0, MODF_TOLERANCE, 0},
{ 185, 1083132498u, 3781708548u, 1083131904u, 0u, 1070765835u, 1113071616u, 0, MODF_TOLERANCE, 0},
{ 186, 1096584871u, 1207386447u, 1096584871u, 1073741824u, 1069538565u, 1006632960u, 0, MODF_TOLERANCE, 0},
{ 187, 3188695272u, 3011191657u, 2147483648u, 0u, 3188695272u, 3011191657u, 0, MODF_TOLERANCE, 0},
{ 188, 1103798670u, 1096124830u, 1103798670u, 1090519040u, 1071997543u, 2147483648u, 0, MODF_TOLERANCE, 0},
{ 189, 1063235023u, 2540404725u, 0u, 0u, 1063235023u, 2540404725u, 0, MODF_TOLERANCE, 0},
{ 190, 3240157452u, 4122845725u, 3240157452u, 0u, 3219044276u, 1134559232u, 0, MODF_TOLERANCE, 0},
{ 191, 1083643710u, 311336721u, 1083642880u, 0u, 1072296084u, 1962444800u, 0, MODF_TOLERANCE, 0},
{ 192, 3214382367u, 4212533768u, 2147483648u, 0u, 3214382367u, 4212533768u, 0, MODF_TOLERANCE, 0},
{ 193, 1051139427u, 1769686293u, 0u, 0u, 1051139427u, 1769686293u, 0, MODF_TOLERANCE, 0},
{ 194, 3240200923u, 3538602249u, 3240200922u, 0u, 3219992236u, 2425356288u, 0, MODF_TOLERANCE, 0},
{ 195, 1078227549u, 508056696u, 1078198272u, 0u, 1072469831u, 2450857472u, 0, MODF_TOLERANCE, 0},
{ 196, 1103793878u, 776520138u, 1103793878u, 771751936u, 1071788146u, 2147483648u, 0, MODF_TOLERANCE, 0},
{ 197, 1102910577u, 4064962760u, 1102910577u, 4060086272u, 1070766642u, 0u, 0, MODF_TOLERANCE, 0},
{ 198, 1077424413u, 819766631u, 1077411840u, 0u, 1070108312u, 1850913664u, 0, MODF_TOLERANCE, 0},
{ 199, 1074178362u, 2112385259u, 1073741824u, 0u, 1072342249u, 4154573740u, 0, MODF_TOLERANCE, 0},
{ 200, 3227593179u, 1187058516u, 3227590656u, 0u, 3218323085u, 2183571456u, 0, MODF_TOLERANCE, 0},
{ 201, 1082295059u, 2514398118u, 1082294272u, 0u, 1071160494u, 4116525056u, 0, MODF_TOLERANCE, 0},
{ 202, 1076579751u, 870169764u, 1076494336u, 0u, 1071962739u, 1037814336u, 0, MODF_TOLERANCE, 0},
{ 203, 3246851392u, 1190259653u, 3246851392u, 1073741824u, 3219900335u, 335544320u, 0, MODF_TOLERANCE, 0},
{ 204, 1069112254u, 3417249840u, 0u, 0u, 1069112254u, 3417249840u, 0, MODF_TOLERANCE, 0},
{ 205, 3193663083u, 3467757357u, 2147483648u, 0u, 3193663083u, 3467757357u, 0, MODF_TOLERANCE, 0},
{ 206, 3215075200u, 2168175352u, 2147483648u, 0u, 3215075200u, 2168175352u, 0, MODF_TOLERANCE, 0},
{ 207, 3239643135u, 1508888184u, 3239643132u, 0u, 3219836798u, 1941962752u, 0, MODF_TOLERANCE, 0},
{ 208, 1060430241u, 3524949092u, 0u, 0u, 1060430241u, 3524949092u, 0, MODF_TOLERANCE, 0},
{ 209, 3197412883u, 166402802u, 2147483648u, 0u, 3197412883u, 166402802u, 0, MODF_TOLERANCE, 0},
{ 210, 3237198975u, 3572369260u, 3237198960u, 0u, 3220154844u, 249036800u, 0, MODF_TOLERANCE, 0},
{ 211, 1081866822u, 2441536203u, 1081864192u, 0u, 1071942947u, 231052800u, 0, MODF_TOLERANCE, 0},
{ 212, 3202753937u, 3658194573u, 2147483648u, 0u, 3202753937u, 3658194573u, 0, MODF_TOLERANCE, 0},
{ 213, 1062392908u, 2479742828u, 0u, 0u, 1062392908u, 2479742828u, 0, MODF_TOLERANCE, 0},
{ 214, 1062342831u, 4214154303u, 0u, 0u, 1062342831u, 4214154303u, 0, MODF_TOLERANCE, 0},
{ 215, 1082396794u, 426896765u, 1082396672u, 0u, 1068402268u, 2069839872u, 0, MODF_TOLERANCE, 0},
{ 216, 1066474375u, 2201754442u, 0u, 0u, 1066474375u, 2201754442u, 0, MODF_TOLERANCE, 0},
{ 217, 3195629021u, 2055773734u, 2147483648u, 0u, 3195629021u, 2055773734u, 0, MODF_TOLERANCE, 0},
{ 218, 3239267288u, 291396537u, 3239267288u, 0u, 3213975131u, 3103784960u, 0, MODF_TOLERANCE, 0},
{ 219, 3236968033u, 874125203u, 3236968032u, 0u, 3216196001u, 2033188864u, 0, MODF_TOLERANCE, 0},
{ 220, 3210508124u, 4091098764u, 2147483648u, 0u, 3210508124u, 4091098764u, 0, MODF_TOLERANCE, 0},
{ 221, 1065716026u, 120488169u, 0u, 0u, 1065716026u, 120488169u, 0, MODF_TOLERANCE, 0},
{ 222, 3241241441u, 1985269424u, 3241241441u, 0u, 3218969907u, 2885681152u, 0, MODF_TOLERANCE, 0},
{ 223, 3206539410u, 2243036871u, 2147483648u, 0u, 3206539410u, 2243036871u, 0, MODF_TOLERANCE, 0},
{ 224, 3243941101u, 740033495u, 3243941101u, 0u, 3219525121u, 3951034368u, 0, MODF_TOLERANCE, 0},
{ 225, 3209424906u, 1176656356u, 2147483648u, 0u, 3209424906u, 1176656356u, 0, MODF_TOLERANCE, 0},
{ 226, 1074261978u, 3588756231u, 1073741824u, 0u, 1072676715u, 1470123036u, 0, MODF_TOLERANCE, 0},
{ 227, 3252816791u, 3037249392u, 3252816791u, 3036676096u, 3218177760u, 0u, 0, MODF_TOLERANCE, 0},
{ 228, 1061635587u, 1173102190u, 0u, 0u, 1061635587u, 1173102190u, 0, MODF_TOLERANCE, 0},
{ 229, 3237209581u, 2882725208u, 3237209568u, 0u, 3219871653u, 3400531968u, 0, MODF_TOLERANCE, 0},
{ 230, 1071440059u, 69225090u, 0u, 0u, 1071440059u, 69225090u, 0, MODF_TOLERANCE, 0},
{ 231, 3212663474u, 272319256u, 2147483648u, 0u, 3212663474u, 272319256u, 0, MODF_TOLERANCE, 0},
{ 232, 1072073912u, 2493997123u, 0u, 0u, 1072073912u, 2493997123u, 0, MODF_TOLERANCE, 0},
{ 233, 1057720186u, 188610379u, 0u, 0u, 1057720186u, 188610379u, 0, MODF_TOLERANCE, 0},
{ 234, 3232757923u, 2209647371u, 3232757760u, 0u, 3218370678u, 2439077888u, 0, MODF_TOLERANCE, 0},
{ 235, 3236758517u, 1990439193u, 3236758496u, 0u, 3219486371u, 2971205632u, 0, MODF_TOLERANCE, 0},
{ 236, 1078073146u, 622849962u, 1078067200u, 0u, 1070021157u, 535800320u, 0, MODF_TOLERANCE, 0},
{ 237, 1057135741u, 756052458u, 0u, 0u, 1057135741u, 756052458u, 0, MODF_TOLERANCE, 0},
{ 238, 1081649113u, 2247475162u, 1081647104u, 0u, 1071605271u, 3607062528u, 0, MODF_TOLERANCE, 0},
{ 239, 1061623064u, 3878055211u, 0u, 0u, 1061623064u, 3878055211u, 0, MODF_TOLERANCE, 0},
{ 240, 3222407050u, 2979438623u, 3222274048u, 0u, 3219143765u, 2360672504u, 0, MODF_TOLERANCE, 0},
{ 241, 3195290997u, 2676398686u, 2147483648u, 0u, 3195290997u, 2676398686u, 0, MODF_TOLERANCE, 0},
{ 242, 1105124431u, 3631096636u, 1105124431u, 3628072960u, 1072107934u, 0u, 0, MODF_TOLERANCE, 0},
{ 243, 1065079390u, 1697791764u, 0u, 0u, 1065079390u, 1697791764u, 0, MODF_TOLERANCE, 0},
{ 244, 3198136112u, 2299842819u, 2147483648u, 0u, 3198136112u, 2299842819u, 0, MODF_TOLERANCE, 0},
{ 245, 1078084768u, 1931502677u, 1078067200u, 0u, 1071720476u, 3357087040u, 0, MODF_TOLERANCE, 0},
{ 246, 3215264397u, 3016456382u, 2147483648u, 0u, 3215264397u, 3016456382u, 0, MODF_TOLERANCE, 0},
{ 247, 1072253426u, 343404215u, 0u, 0u, 1072253426u, 343404215u, 0, MODF_TOLERANCE, 0},
{ 248, 1061072607u, 4266232536u, 0u, 0u, 1061072607u, 4266232536u, 0, MODF_TOLERANCE, 0},
{ 249, 3241230836u, 4140316002u, 3241230836u, 0u, 3220101382u, 2889875456u, 0, MODF_TOLERANCE, 0},
{ 250, 1082896196u, 868256971u, 1082894336u, 0u, 1072500943u, 36908032u, 0, MODF_TOLERANCE, 0},
{ 251, 1075422810u, 1864139509u, 1075314688u, 0u, 1071277478u, 4056428368u, 0, MODF_TOLERANCE, 0},
{ 252, 3187675097u, 3084482407u, 2147483648u, 0u, 3187675097u, 3084482407u, 0, MODF_TOLERANCE, 0},
{ 253, 3220191323u, 2427162817u, 3220176896u, 0u, 3213635016u, 1439195264u, 0, MODF_TOLERANCE, 0},
{ 254, 3234748208u, 2715105792u, 3234748160u, 0u, 3218624746u, 2634022912u, 0, MODF_TOLERANCE, 0},
{ 255, 1064600512u, 3943389284u, 0u, 0u, 1064600512u, 3943389284u, 0, MODF_TOLERANCE, 0},
{ 256, 1046724025u, 3626825684u, 0u, 0u, 1046724025u, 3626825684u, 0, MODF_TOLERANCE, 0},
{ 257, 1045423002u, 967350972u, 0u, 0u, 1045423002u, 967350972u, 0, MODF_TOLERANCE, 0},
{ 258, 1093012318u, 448002663u, 1093012318u, 0u, 1068151802u, 1728053248u, 0, MODF_TOLERANCE, 0},
{ 259, 3251845859u, 105058217u, 3251845859u, 104857600u, 3215490376u, 0u, 0, MODF_TOLERANCE, 0},
{ 260, 1069733884u, 171786224u, 0u, 0u, 1069733884u, 171786224u, 0, MODF_TOLERANCE, 0},
{ 261, 3189614508u, 2863482262u, 2147483648u, 0u, 3189614508u, 2863482262u, 0, MODF_TOLERANCE, 0},
{ 262, 3204997271u, 877784425u, 2147483648u, 0u, 3204997271u, 877784425u, 0, MODF_TOLERANCE, 0},
{ 263, 3202629313u, 2801782962u, 2147483648u, 0u, 3202629313u, 2801782962u, 0, MODF_TOLERANCE, 0},
{ 264, 3213604117u, 762347195u, 2147483648u, 0u, 3213604117u, 762347195u, 0, MODF_TOLERANCE, 0},
{ 265, 3233486727u, 2317950339u, 3233486592u, 0u, 3219190085u, 598761472u, 0, MODF_TOLERANCE, 0},
{ 266, 3246333414u, 2135700283u, 3246333414u, 1879048192u, 3220084838u, 1979711488u, 0, MODF_TOLERANCE, 0},
{ 267, 1056516397u, 4171919805u, 0u, 0u, 1056516397u, 4171919805u, 0, MODF_TOLERANCE, 0},
{ 268, 1082858682u, 2180920863u, 1082857472u, 0u, 1071835655u, 4174937088u, 0, MODF_TOLERANCE, 0},
{ 269, 3220149084u, 1918836931u, 2147483648u, 0u, 3220149084u, 1918836931u, 0, MODF_TOLERANCE, 0},
{ 270, 1083603224u, 3137821660u, 1083602944u, 0u, 1070697392u, 1975369728u, 0, MODF_TOLERANCE, 0},
{ 271, 1103902874u, 3456203663u, 1103902874u, 3456106496u, 1065859312u, 0u, 0, MODF_TOLERANCE, 0},
{ 272, 3235600523u, 2335688936u, 3235600512u, 0u, 3217495663u, 2446327808u, 0, MODF_TOLERANCE, 0},
{ 273, 1042279322u, 4170235262u, 0u, 0u, 1042279322u, 4170235262u, 0, MODF_TOLERANCE, 0},
{ 274, 1051824459u, 521583737u, 0u, 0u, 1051824459u, 521583737u, 0, MODF_TOLERANCE, 0},
{ 275, 1081348303u, 1296623194u, 1081348096u, 0u, 1068100009u, 483082240u, 0, MODF_TOLERANCE, 0},
{ 276, 3250673860u, 2442872540u, 3250673860u, 2441084928u, 3217770204u, 0u, 0, MODF_TOLERANCE, 0},
{ 277, 1061684277u, 289979405u, 0u, 0u, 1061684277u, 289979405u, 0, MODF_TOLERANCE, 0},
{ 278, 1049514449u, 3865737145u, 0u, 0u, 1049514449u, 3865737145u, 0, MODF_TOLERANCE, 0},
{ 279, 1075298944u, 3699090239u, 1075052544u, 0u, 1072567302u, 3822918136u, 0, MODF_TOLERANCE, 0},
{ 280, 1054539840u, 3259249360u, 0u, 0u, 1054539840u, 3259249360u, 0, MODF_TOLERANCE, 0},
{ 281, 1096418100u, 1619819023u, 1096418100u, 1073741824u, 1071662653u, 125829120u, 0, MODF_TOLERANCE, 0},
{ 282, 1045993352u, 1022642459u, 0u, 0u, 1045993352u, 1022642459u, 0, MODF_TOLERANCE, 0},
{ 283, 1081433004u, 19455098u, 1081430016u, 0u, 1072125954u, 1371075584u, 0, MODF_TOLERANCE, 0},
{ 284, 3229182089u, 2096003654u, 3229179904u, 0u, 3219198713u, 3707014144u, 0, MODF_TOLERANCE, 0},
{ 285, 1076297936u, 3803689997u, 1076232192u, 0u, 1071648014u, 729497808u, 0, MODF_TOLERANCE, 0},
{ 286, 1071630912u, 2263729518u, 0u, 0u, 1071630912u, 2263729518u, 0, MODF_TOLERANCE, 0},
{ 287, 1101357261u, 2816837387u, 1101357261u, 2785017856u, 1072584816u, 2952790016u, 0, MODF_TOLERANCE, 0},
{ 288, 1063422305u, 2597606398u, 0u, 0u, 1063422305u, 2597606398u, 0, MODF_TOLERANCE, 0},
{ 289, 1069100169u, 3680967506u, 0u, 0u, 1069100169u, 3680967506u, 0, MODF_TOLERANCE, 0},
{ 290, 1040201163u, 179224723u, 0u, 0u, 1040201163u, 179224723u, 0, MODF_TOLERANCE, 0},
{ 291, 3188629767u, 978126928u, 2147483648u, 0u, 3188629767u, 978126928u, 0, MODF_TOLERANCE, 0},
{ 292, 1101553990u, 4047893399u, 1101553990u, 4026531840u, 1071931193u, 1879048192u, 0, MODF_TOLERANCE, 0},
{ 293, 3222322045u, 4059818629u, 3222274048u, 0u, 3217518526u, 1065177248u, 0, MODF_TOLERANCE, 0},
{ 294, 1042678728u, 3640293589u, 0u, 0u, 1042678728u, 3640293589u, 0, MODF_TOLERANCE, 0},
{ 295, 3248464040u, 3383497159u, 3248464040u, 3355443200u, 3218784540u, 1879048192u, 0, MODF_TOLERANCE, 0},
{ 296, 1070002807u, 1527313008u, 0u, 0u, 1070002807u, 1527313008u, 0, MODF_TOLERANCE, 0},
{ 297, 3202707679u, 2599946514u, 2147483648u, 0u, 3202707679u, 2599946514u, 0, MODF_TOLERANCE, 0},
{ 298, 1104170406u, 2738675352u, 1104170406u, 2734686208u, 1072590668u, 0u, 0, MODF_TOLERANCE, 0},
{ 299, 1105232623u, 3616571377u, 1105232623u, 3615490048u, 1071677425u, 0u, 0, MODF_TOLERANCE, 0},
{ 300, 1060859316u, 1130603218u, 0u, 0u, 1060859316u, 1130603218u, 0, MODF_TOLERANCE, 0},
{ 301, 1076028796u, 3859211180u, 1075970048u, 0u, 1071427484u, 3235673472u, 0, MODF_TOLERANCE, 0},
{ 302, 1067940450u, 1744531824u, 0u, 0u, 1067940450u, 1744531824u, 0, MODF_TOLERANCE, 0},
{ 303, 1042831340u, 1958025850u, 0u, 0u, 1042831340u, 1958025850u, 0, MODF_TOLERANCE, 0},
{ 304, 3236511256u, 2472176453u, 3236511232u, 0u, 3219690330u, 1799684096u, 0, MODF_TOLERANCE, 0},
{ 305, 3233107089u, 182132862u, 3233106944u, 0u, 3219267931u, 1678753792u, 0, MODF_TOLERANCE, 0},
{ 306, 3250520938u, 3924356991u, 3250520938u, 3909091328u, 3219987951u, 3758096384u, 0, MODF_TOLERANCE, 0},
{ 307, 3230501884u, 35632886u, 3230500864u, 0u, 3219120144u, 4256673792u, 0, MODF_TOLERANCE, 0},
{ 308, 3209806504u, 1453402523u, 2147483648u, 0u, 3209806504u, 1453402523u, 0, MODF_TOLERANCE, 0},
{ 309, 1083522102u, 743225214u, 1083522048u, 0u, 1068176934u, 1539244032u, 0, MODF_TOLERANCE, 0},
{ 310, 3202890678u, 142917400u, 2147483648u, 0u, 3202890678u, 142917400u, 0, MODF_TOLERANCE, 0},
{ 311, 1080684976u, 1472665012u, 1080680448u, 0u, 1071755351u, 3340088320u, 0, MODF_TOLERANCE, 0},
{ 312, 3203138231u, 256588219u, 2147483648u, 0u, 3203138231u, 256588219u, 0, MODF_TOLERANCE, 0},
{ 313, 1094982162u, 1062927000u, 1094982162u, 0u, 1071623549u, 1275068416u, 0, MODF_TOLERANCE, 0},
{ 314, 1061134072u, 931677439u, 0u, 0u, 1061134072u, 931677439u, 0, MODF_TOLERANCE, 0},
{ 315, 1058377732u, 2320910576u, 0u, 0u, 1058377732u, 2320910576u, 0, MODF_TOLERANCE, 0},
{ 316, 1055663370u, 288059864u, 0u, 0u, 1055663370u, 288059864u, 0, MODF_TOLERANCE, 0},
{ 317, 1078958093u, 1448349062u, 1078951936u, 0u, 1070075222u, 1410172416u, 0, MODF_TOLERANCE, 0},
{ 318, 3199478070u, 3454027134u, 2147483648u, 0u, 3199478070u, 3454027134u, 0, MODF_TOLERANCE, 0},
{ 319, 3237458798u, 4215445172u, 3237458784u, 0u, 3220043397u, 761790464u, 0, MODF_TOLERANCE, 0},
{ 320, 3196654963u, 2231888973u, 2147483648u, 0u, 3196654963u, 2231888973u, 0, MODF_TOLERANCE, 0},
{ 321, 3246632231u, 40413554u, 3246632231u, 0u, 3218294091u, 2415919104u, 0, MODF_TOLERANCE, 0},
{ 322, 3232578253u, 983832844u, 3232578048u, 0u, 3218712404u, 2200010752u, 0, MODF_TOLERANCE, 0},
{ 323, 3223721534u, 3995725873u, 3223715840u, 0u, 3215343342u, 703607040u, 0, MODF_TOLERANCE, 0},
{ 324, 1050082319u, 777231627u, 0u, 0u, 1050082319u, 777231627u, 0, MODF_TOLERANCE, 0},
{ 325, 1040986626u, 672789828u, 0u, 0u, 1040986626u, 672789828u, 0, MODF_TOLERANCE, 0},
{ 326, 3253385962u, 2982787335u, 3253385962u, 2982150144u, 3218305550u, 0u, 0, MODF_TOLERANCE, 0},
{ 327, 1068390875u, 2075971825u, 0u, 0u, 1068390875u, 2075971825u, 0, MODF_TOLERANCE, 0},
{ 328, 1070166500u, 4034633931u, 0u, 0u, 1070166500u, 4034633931u, 0, MODF_TOLERANCE, 0},
{ 329, 3210046177u, 1018222907u, 2147483648u, 0u, 3210046177u, 1018222907u, 0, MODF_TOLERANCE, 0},
{ 330, 3244621407u, 3090050495u, 3244621407u, 2684354560u, 3219664493u, 3204448256u, 0, MODF_TOLERANCE, 0},
{ 331, 1067680885u, 937732557u, 0u, 0u, 1067680885u, 937732557u, 0, MODF_TOLERANCE, 0},
{ 332, 3200798890u, 2557898276u, 2147483648u, 0u, 3200798890u, 2557898276u, 0, MODF_TOLERANCE, 0},
{ 333, 1078342316u, 130346162u, 1078329344u, 0u, 1071207939u, 3799406848u, 0, MODF_TOLERANCE, 0},
{ 334, 3223590310u, 275568693u, 3223584768u, 0u, 3215304208u, 1826108672u, 0, MODF_TOLERANCE, 0},
{ 335, 1042898869u, 3807416441u, 0u, 0u, 1042898869u, 3807416441u, 0, MODF_TOLERANCE, 0},
{ 336, 1075961161u, 3706820266u, 1075838976u, 0u, 1072551069u, 3474549408u, 0, MODF_TOLERANCE, 0},
{ 337, 3216099005u, 1710131411u, 2147483648u, 0u, 3216099005u, 1710131411u, 0, MODF_TOLERANCE, 0},
{ 338, 1078123323u, 1900790503u, 1078099968u, 0u, 1072090844u, 1391507904u, 0, MODF_TOLERANCE, 0},
{ 339, 3238819361u, 3420420033u, 3238819360u, 0u, 3217866231u, 2081423360u, 0, MODF_TOLERANCE, 0},
{ 340, 3210844787u, 588423066u, 2147483648u, 0u, 3210844787u, 588423066u, 0, MODF_TOLERANCE, 0},
{ 341, 1049684114u, 1160162008u, 0u, 0u, 1049684114u, 1160162008u, 0, MODF_TOLERANCE, 0},
{ 342, 3246307879u, 4265764460u, 3246307879u, 4026531840u, 3219948748u, 3623878656u, 0, MODF_TOLERANCE, 0},
{ 343, 1102543434u, 366653268u, 1102543434u, 352321536u, 1072387562u, 2147483648u, 0, MODF_TOLERANCE, 0},
{ 344, 3188814424u, 466059202u, 2147483648u, 0u, 3188814424u, 466059202u, 0, MODF_TOLERANCE, 0},
{ 345, 3226627739u, 1325936170u, 3226615808u, 0u, 3219606951u, 2216105216u, 0, MODF_TOLERANCE, 0},
{ 346, 3221436876u, 680097612u, 3221225472u, 0u, 3218722401u, 1145813600u, 0, MODF_TOLERANCE, 0},
{ 347, 3240391116u, 1827735934u, 3240391116u, 0u, 3217767490u, 1602224128u, 0, MODF_TOLERANCE, 0},
{ 348, 3200554324u, 2875599271u, 2147483648u, 0u, 3200554324u, 2875599271u, 0, MODF_TOLERANCE, 0},
{ 349, 3191030402u, 3117037091u, 2147483648u, 0u, 3191030402u, 3117037091u, 0, MODF_TOLERANCE, 0},
{ 350, 3239246636u, 15838845u, 3239246636u, 0u, 3209573839u, 2684354560u, 0, MODF_TOLERANCE, 0},
{ 351, 1051974004u, 749718883u, 0u, 0u, 1051974004u, 749718883u, 0, MODF_TOLERANCE, 0},
{ 352, 3223587064u, 1523766569u, 3223584768u, 0u, 3214012597u, 2779402752u, 0, MODF_TOLERANCE, 0},
{ 353, 1044833651u, 1966536294u, 0u, 0u, 1044833651u, 1966536294u, 0, MODF_TOLERANCE, 0},
{ 354, 3250158026u, 699164258u, 3250158026u, 687865856u, 3219492044u, 1073741824u, 0, MODF_TOLERANCE, 0},
{ 355, 1098048435u, 3759049394u, 1098048435u, 3758096384u, 1064113508u, 0u, 0, MODF_TOLERANCE, 0},
{ 356, 1106085272u, 1183789499u, 1106085272u, 1182793728u, 1071539062u, 0u, 0, MODF_TOLERANCE, 0},
{ 357, 1081201623u, 1970107747u, 1081200640u, 0u, 1070513067u, 1806374912u, 0, MODF_TOLERANCE, 0},
{ 358, 1095245453u, 2308233883u, 1095245453u, 2147483648u, 1068706229u, 905969664u, 0, MODF_TOLERANCE, 0},
{ 359, 1084756444u, 1491017852u, 1084755968u, 0u, 1072547213u, 4060594176u, 0, MODF_TOLERANCE, 0},
{ 360, 1041444355u, 1723375725u, 0u, 0u, 1041444355u, 1723375725u, 0, MODF_TOLERANCE, 0},
{ 361, 3216630070u, 1141349287u, 2147483648u, 0u, 3216630070u, 1141349287u, 0, MODF_TOLERANCE, 0},
{ 362, 1097465301u, 3403438584u, 1097465301u, 3221225472u, 1070971059u, 4026531840u, 0, MODF_TOLERANCE, 0},
{ 363, 3230571908u, 1711085243u, 3230570496u, 0u, 3219526039u, 4099599360u, 0, MODF_TOLERANCE, 0},
{ 364, 3250239076u, 1377484108u, 3250239076u, 1375731712u, 3216686412u, 0u, 0, MODF_TOLERANCE, 0},
{ 365, 1098385019u, 2880275004u, 1098385019u, 2684354560u, 1072126724u, 2013265920u, 0, MODF_TOLERANCE, 0},
{ 366, 1084039594u, 1611394950u, 1084039168u, 0u, 1071293952u, 3203948544u, 0, MODF_TOLERANCE, 0},
{ 367, 3234221435u, 2626629370u, 3234221312u, 0u, 3220104995u, 3418259456u, 0, MODF_TOLERANCE, 0},
{ 368, 1063771493u, 1499080813u, 0u, 0u, 1063771493u, 1499080813u, 0, MODF_TOLERANCE, 0},
{ 369, 1055231263u, 3936262414u, 0u, 0u, 1055231263u, 3936262414u, 0, MODF_TOLERANCE, 0},
{ 370, 1103919063u, 3175668759u, 1103919063u, 3170893824u, 1071789829u, 3221225472u, 0, MODF_TOLERANCE, 0},
{ 371, 3207981719u, 1270950554u, 2147483648u, 0u, 3207981719u, 1270950554u, 0, MODF_TOLERANCE, 0},
{ 372, 3194616071u, 3680565379u, 2147483648u, 0u, 3194616071u, 3680565379u, 0, MODF_TOLERANCE, 0},
{ 373, 3208148223u, 1066985223u, 2147483648u, 0u, 3208148223u, 1066985223u, 0, MODF_TOLERANCE, 0},
{ 374, 3221613219u, 4089383168u, 3221225472u, 0u, 3219630735u, 3472630784u, 0, MODF_TOLERANCE, 0},
{ 375, 3217058839u, 4017329311u, 2147483648u, 0u, 3217058839u, 4017329311u, 0, MODF_TOLERANCE, 0},
{ 376, 3208334452u, 1667591498u, 2147483648u, 0u, 3208334452u, 1667591498u, 0, MODF_TOLERANCE, 0},
{ 377, 1088164157u, 3154656624u, 1088164096u, 0u, 1072619012u, 515375104u, 0, MODF_TOLERANCE, 0},
{ 378, 1061894279u, 3886344038u, 0u, 0u, 1061894279u, 3886344038u, 0, MODF_TOLERANCE, 0},
{ 379, 1050652945u, 977586119u, 0u, 0u, 1050652945u, 977586119u, 0, MODF_TOLERANCE, 0},
{ 380, 3209762784u, 953839852u, 2147483648u, 0u, 3209762784u, 953839852u, 0, MODF_TOLERANCE, 0},
{ 381, 1104965247u, 143071571u, 1104965247u, 142606336u, 1069311308u, 0u, 0, MODF_TOLERANCE, 0},
{ 382, 3206165386u, 913097445u, 2147483648u, 0u, 3206165386u, 913097445u, 0, MODF_TOLERANCE, 0},
{ 383, 3190565456u, 1371169579u, 2147483648u, 0u, 3190565456u, 1371169579u, 0, MODF_TOLERANCE, 0},
{ 384, 1057079837u, 2594818628u, 0u, 0u, 1057079837u, 2594818628u, 0, MODF_TOLERANCE, 0},
{ 385, 3251793336u, 2259342224u, 3251793336u, 2256535552u, 3219483080u, 0u, 0, MODF_TOLERANCE, 0},
{ 386, 3217432469u, 1824221478u, 2147483648u, 0u, 3217432469u, 1824221478u, 0, MODF_TOLERANCE, 0},
{ 387, 3246834775u, 1576604497u, 3246834775u, 1476395008u, 3219645517u, 1140850688u, 0, MODF_TOLERANCE, 0},
{ 388, 1079368611u, 185078728u, 1079361536u, 0u, 1071358731u, 135514112u, 0, MODF_TOLERANCE, 0},
{ 389, 3221679427u, 444800035u, 3221225472u, 0u, 3219895564u, 1779200140u, 0, MODF_TOLERANCE, 0},
{ 390, 3243343143u, 1734989302u, 3243343143u, 1073741824u, 3219371242u, 4211081216u, 0, MODF_TOLERANCE, 0},
{ 391, 1072748883u, 130452005u, 1072693248u, 0u, 1068182112u, 4174464160u, 0, MODF_TOLERANCE, 0},
{ 392, 1041548088u, 2158433515u, 0u, 0u, 1041548088u, 2158433515u, 0, MODF_TOLERANCE, 0},
{ 393, 3234695968u, 1941318385u, 3234695936u, 0u, 3218094555u, 360218624u, 0, MODF_TOLERANCE, 0},
{ 394, 1045807374u, 792193370u, 0u, 0u, 1045807374u, 792193370u, 0, MODF_TOLERANCE, 0},
{ 395, 3238299666u, 1299392207u, 3238299664u, 0u, 3218238361u, 913833984u, 0, MODF_TOLERANCE, 0},
{ 396, 3212131720u, 3205732280u, 2147483648u, 0u, 3212131720u, 3205732280u, 0, MODF_TOLERANCE, 0},
{ 397, 1098698804u, 3035093505u, 1098698804u, 2952790016u, 1070833512u, 67108864u, 0, MODF_TOLERANCE, 0},
{ 398, 1052187689u, 3287702190u, 0u, 0u, 1052187689u, 3287702190u, 0, MODF_TOLERANCE, 0},
{ 399, 3246676260u, 2160225215u, 3246676260u, 2147483648u, 3216526711u, 3758096384u, 0, MODF_TOLERANCE, 0},
{ 400, 1102624859u, 836655570u, 1102624859u, 822083584u, 1072417594u, 1073741824u, 0, MODF_TOLERANCE, 0},
{ 401, 1096723626u, 3360816360u, 1096723626u, 3221225472u, 1069589497u, 3489660928u, 0, MODF_TOLERANCE, 0},
{ 402, 3246176356u, 172860634u, 3246176356u, 0u, 3219430217u, 3019898880u, 0, MODF_TOLERANCE, 0},
{ 403, 1070995788u, 146831910u, 0u, 0u, 1070995788u, 146831910u, 0, MODF_TOLERANCE, 0},
{ 404, 1051558014u, 2340722078u, 0u, 0u, 1051558014u, 2340722078u, 0, MODF_TOLERANCE, 0},
{ 405, 3230416351u, 1603798153u, 3230414848u, 0u, 3219619198u, 1611801600u, 0, MODF_TOLERANCE, 0},
{ 406, 3207725532u, 1099413093u, 2147483648u, 0u, 3207725532u, 1099413093u, 0, MODF_TOLERANCE, 0},
{ 407, 3246678378u, 2429340443u, 3246678378u, 2415919104u, 3216611683u, 1610612736u, 0, MODF_TOLERANCE, 0},
{ 408, 3190303581u, 3223770005u, 2147483648u, 0u, 3190303581u, 3223770005u, 0, MODF_TOLERANCE, 0},
{ 409, 1075882959u, 955542166u, 1075838976u, 0u, 1070954983u, 512578240u, 0, MODF_TOLERANCE, 0},
{ 410, 3230415151u, 275583938u, 3230414848u, 0u, 3217223942u, 3510378496u, 0, MODF_TOLERANCE, 0},
{ 411, 1092971882u, 513397822u, 1092971882u, 0u, 1068407252u, 1040187392u, 0, MODF_TOLERANCE, 0},
{ 412, 1090646554u, 2089321329u, 1090646552u, 0u, 1070851140u, 461897728u, 0, MODF_TOLERANCE, 0},
{ 413, 3193169876u, 2782073372u, 2147483648u, 0u, 3193169876u, 2782073372u, 0, MODF_TOLERANCE, 0},
{ 414, 1046063872u, 4023829068u, 0u, 0u, 1046063872u, 4023829068u, 0, MODF_TOLERANCE, 0},
{ 415, 1098564822u, 3242223094u, 1098564822u, 3221225472u, 1068762719u, 1610612736u, 0, MODF_TOLERANCE, 0},
{ 416, 3194111199u, 4264674108u, 2147483648u, 0u, 3194111199u, 4264674108u, 0, MODF_TOLERANCE, 0},
{ 417, 3238510821u, 3506346169u, 3238510816u, 0u, 3219604474u, 1659109376u, 0, MODF_TOLERANCE, 0},
{ 418, 1047020885u, 1742757458u, 0u, 0u, 1047020885u, 1742757458u, 0, MODF_TOLERANCE, 0},
{ 419, 3192664477u, 1265459564u, 2147483648u, 0u, 3192664477u, 1265459564u, 0, MODF_TOLERANCE, 0},
{ 420, 3193450280u, 3650514880u, 2147483648u, 0u, 3193450280u, 3650514880u, 0, MODF_TOLERANCE, 0},
{ 421, 1081755890u, 1525260440u, 1081753600u, 0u, 1071768757u, 3544264704u, 0, MODF_TOLERANCE, 0},
{ 422, 3235452527u, 2612331392u, 3235452480u, 0u, 3219639770u, 2176843776u, 0, MODF_TOLERANCE, 0},
{ 423, 3248668920u, 1263613754u, 3248668920u, 1241513984u, 3219460979u, 2684354560u, 0, MODF_TOLERANCE, 0},
{ 424, 3219096387u, 635677201u, 2147483648u, 0u, 3219096387u, 635677201u, 0, MODF_TOLERANCE, 0},
{ 425, 3206272087u, 4140947288u, 2147483648u, 0u, 3206272087u, 4140947288u, 0, MODF_TOLERANCE, 0},
{ 426, 3200792376u, 2013265346u, 2147483648u, 0u, 3200792376u, 2013265346u, 0, MODF_TOLERANCE, 0},
{ 427, 3249974392u, 1912759945u, 3249974392u, 1912602624u, 3213046856u, 0u, 0, MODF_TOLERANCE, 0},
{ 428, 3237045253u, 1351396825u, 3237045248u, 0u, 3218424370u, 3076784128u, 0, MODF_TOLERANCE, 0},
{ 429, 3248205162u, 1001433078u, 3248205162u, 939524096u, 3220014399u, 2952790016u, 0, MODF_TOLERANCE, 0},
{ 430, 3206926643u, 2741676659u, 2147483648u, 0u, 3206926643u, 2741676659u, 0, MODF_TOLERANCE, 0},
{ 431, 1080923606u, 1088945233u, 1080918016u, 0u, 1072027200u, 3892072704u, 0, MODF_TOLERANCE, 0},
{ 432, 1085095743u, 3986114865u, 1085095424u, 0u, 1071906521u, 1955794944u, 0, MODF_TOLERANCE, 0},
{ 433, 3215734057u, 831239754u, 2147483648u, 0u, 3215734057u, 831239754u, 0, MODF_TOLERANCE, 0},
{ 434, 1099828675u, 3071308141u, 1099828675u, 2952790016u, 1072447941u, 3019898880u, 0, MODF_TOLERANCE, 0},
{ 435, 3225834497u, 3473592372u, 3225812992u, 0u, 3219456115u, 3266579712u, 0, MODF_TOLERANCE, 0},
{ 436, 1102759382u, 1309576357u, 1102759382u, 1308622848u, 1068308810u, 0u, 0, MODF_TOLERANCE, 0},
{ 437, 3251186706u, 2042340367u, 3251186706u, 2038431744u, 3218985479u, 2147483648u, 0, MODF_TOLERANCE, 0},
{ 438, 1091945628u, 2062772374u, 1091945628u, 0u, 1069464794u, 629145600u, 0, MODF_TOLERANCE, 0},
{ 439, 3194765687u, 1840632537u, 2147483648u, 0u, 3194765687u, 1840632537u, 0, MODF_TOLERANCE, 0},
{ 440, 1096533424u, 807510337u, 1096533424u, 0u, 1072173264u, 2692743168u, 0, MODF_TOLERANCE, 0},
{ 441, 3231451722u, 144814872u, 3231451136u, 0u, 3219279941u, 228114432u, 0, MODF_TOLERANCE, 0},
{ 442, 3212698915u, 2282965697u, 2147483648u, 0u, 3212698915u, 2282965697u, 0, MODF_TOLERANCE, 0},
{ 443, 1071236430u, 2552499583u, 0u, 0u, 1071236430u, 2552499583u, 0, MODF_TOLERANCE, 0},
{ 444, 3229111426u, 1470130815u, 3229110272u, 0u, 3218213214u, 2175400960u, 0, MODF_TOLERANCE, 0},
{ 445, 3243093065u, 2858583811u, 3243093065u, 2147483648u, 3218420035u, 2172649472u, 0, MODF_TOLERANCE, 0},
{ 446, 1089760910u, 6360994u, 1089760896u, 0u, 1072431298u, 524550144u, 0, MODF_TOLERANCE, 0},
{ 447, 3198264929u, 1614537194u, 2147483648u, 0u, 3198264929u, 1614537194u, 0, MODF_TOLERANCE, 0},
{ 448, 1075198900u, 4088705365u, 1075052544u, 0u, 1071766951u, 2644871848u, 0, MODF_TOLERANCE, 0},
{ 449, 3250939070u, 3545570051u, 3250939070u, 3539992576u, 3219474112u, 3221225472u, 0, MODF_TOLERANCE, 0},
{ 450, 1065221325u, 1629217700u, 0u, 0u, 1065221325u, 1629217700u, 0, MODF_TOLERANCE, 0},
{ 451, 1072744324u, 1813392963u, 1072693248u, 0u, 1068036237u, 2193999968u, 0, MODF_TOLERANCE, 0},
{ 452, 3235313361u, 3772501596u, 3235313344u, 0u, 3218202843u, 3462135808u, 0, MODF_TOLERANCE, 0},
{ 453, 3196802686u, 2406734491u, 2147483648u, 0u, 3196802686u, 2406734491u, 0, MODF_TOLERANCE, 0},
{ 454, 1042055360u, 89226663u, 0u, 0u, 1042055360u, 89226663u, 0, MODF_TOLERANCE, 0},
{ 455, 3195751081u, 1618759139u, 2147483648u, 0u, 3195751081u, 1618759139u, 0, MODF_TOLERANCE, 0},
{ 456, 3194723421u, 3888234802u, 2147483648u, 0u, 3194723421u, 3888234802u, 0, MODF_TOLERANCE, 0},
{ 457, 1055357248u, 3590035633u, 0u, 0u, 1055357248u, 3590035633u, 0, MODF_TOLERANCE, 0},
{ 458, 3212424262u, 2892456615u, 2147483648u, 0u, 3212424262u, 2892456615u, 0, MODF_TOLERANCE, 0},
{ 459, 3189943060u, 2431246964u, 2147483648u, 0u, 3189943060u, 2431246964u, 0, MODF_TOLERANCE, 0},
{ 460, 3241512456u, 183850734u, 3241512456u, 0u, 3215321773u, 3690987520u, 0, MODF_TOLERANCE, 0},
{ 461, 1089501101u, 3088319870u, 1089501088u, 0u, 1072394280u, 184287232u, 0, MODF_TOLERANCE, 0},
{ 462, 3211544311u, 862225364u, 2147483648u, 0u, 3211544311u, 862225364u, 0, MODF_TOLERANCE, 0},
{ 463, 3235294664u, 3495352775u, 3235294656u, 0u, 3217137837u, 3012427776u, 0, MODF_TOLERANCE, 0},
{ 464, 1058576726u, 596957268u, 0u, 0u, 1058576726u, 596957268u, 0, MODF_TOLERANCE, 0},
{ 465, 1046553348u, 1839214511u, 0u, 0u, 1046553348u, 1839214511u, 0, MODF_TOLERANCE, 0},
{ 466, 3205004060u, 1923240983u, 2147483648u, 0u, 3205004060u, 1923240983u, 0, MODF_TOLERANCE, 0},
{ 467, 1058073864u, 739619702u, 0u, 0u, 1058073864u, 739619702u, 0, MODF_TOLERANCE, 0},
{ 468, 3223356436u, 2689885273u, 3223322624u, 0u, 3218113172u, 176982816u, 0, MODF_TOLERANCE, 0},
{ 469, 3200324971u, 2143376228u, 2147483648u, 0u, 3200324971u, 2143376228u, 0, MODF_TOLERANCE, 0},
{ 470, 1098306332u, 3760236188u, 1098306332u, 3758096384u, 1065374542u, 0u, 0, MODF_TOLERANCE, 0},
{ 471, 1074621795u, 671680995u, 1074266112u, 0u, 1072018828u, 2686723980u, 0, MODF_TOLERANCE, 0},
{ 472, 1091262633u, 2315535361u, 1091262632u, 0u, 1070112836u, 1074790400u, 0, MODF_TOLERANCE, 0},
{ 473, 3214165989u, 2493598049u, 2147483648u, 0u, 3214165989u, 2493598049u, 0, MODF_TOLERANCE, 0},
{ 474, 3194927008u, 1689107592u, 2147483648u, 0u, 3194927008u, 1689107592u, 0, MODF_TOLERANCE, 0},
{ 475, 3189989959u, 1578976988u, 2147483648u, 0u, 3189989959u, 1578976988u, 0, MODF_TOLERANCE, 0},
{ 476, 1066368383u, 2117279163u, 0u, 0u, 1066368383u, 2117279163u, 0, MODF_TOLERANCE, 0},
{ 477, 3222988111u, 3425290087u, 3222798336u, 0u, 3219597950u, 1632516920u, 0, MODF_TOLERANCE, 0},
{ 478, 1098487295u, 1263412017u, 1098487295u, 1073741824u, 1072077894u, 1644167168u, 0, MODF_TOLERANCE, 0},
{ 479, 3208432764u, 3635396812u, 2147483648u, 0u, 3208432764u, 3635396812u, 0, MODF_TOLERANCE, 0},
{ 480, 1070999426u, 3965655689u, 0u, 0u, 1070999426u, 3965655689u, 0, MODF_TOLERANCE, 0},
{ 481, 1060196346u, 2183973116u, 0u, 0u, 1060196346u, 2183973116u, 0, MODF_TOLERANCE, 0},
{ 482, 1101098363u, 1118613350u, 1101098363u, 1107296256u, 1070962156u, 3221225472u, 0, MODF_TOLERANCE, 0},
{ 483, 3221946089u, 199516350u, 3221749760u, 0u, 3218601800u, 1596130800u, 0, MODF_TOLERANCE, 0},
{ 484, 1078368488u, 164621458u, 1078362112u, 0u, 1070131209u, 3488387584u, 0, MODF_TOLERANCE, 0},
{ 485, 3187706018u, 3570940805u, 2147483648u, 0u, 3187706018u, 3570940805u, 0, MODF_TOLERANCE, 0},
{ 486, 3230316437u, 3596080877u, 3230314496u, 0u, 3220068185u, 1599845376u, 0, MODF_TOLERANCE, 0},
{ 487, 3208209565u, 980880313u, 2147483648u, 0u, 3208209565u, 980880313u, 0, MODF_TOLERANCE, 0},
{ 488, 1079833442u, 884465057u, 1079820288u, 0u, 1072279834u, 1542377600u, 0, MODF_TOLERANCE, 0},
{ 489, 1099977124u, 2558179220u, 1099977124u, 2550136832u, 1069460965u, 0u, 0, MODF_TOLERANCE, 0},
{ 490, 1052873711u, 1233598120u, 0u, 0u, 1052873711u, 1233598120u, 0, MODF_TOLERANCE, 0},
{ 491, 1047115221u, 1909994277u, 0u, 0u, 1047115221u, 1909994277u, 0, MODF_TOLERANCE, 0},
{ 492, 1085015978u, 2991527452u, 1085015552u, 0u, 1072343844u, 4049715200u, 0, MODF_TOLERANCE, 0},
{ 493, 1060855260u, 1680290941u, 0u, 0u, 1060855260u, 1680290941u, 0, MODF_TOLERANCE, 0},
{ 494, 1074309900u, 2943870846u, 1074266112u, 0u, 1068851605u, 4009553856u, 0, MODF_TOLERANCE, 0},
{ 495, 1059496132u, 1451927357u, 0u, 0u, 1059496132u, 1451927357u, 0, MODF_TOLERANCE, 0},
{ 496, 3228615456u, 1502585517u, 3228614656u, 0u, 3217621708u, 2098554880u, 0, MODF_TOLERANCE, 0},
{ 497, 3236211951u, 751136990u, 3236211936u, 0u, 3219020170u, 3787194368u, 0, MODF_TOLERANCE, 0},
{ 498, 3230392165u, 3493275472u, 3230390272u, 0u, 3220019008u, 3701293056u, 0, MODF_TOLERANCE, 0},
{ 499, 1098365967u, 1209623292u, 1098365967u, 1073741824u, 1071657669u, 4160749568u, 0, MODF_TOLERANCE, 0},
{ 500, 3238056647u, 979495322u, 3238056640u, 0u, 3219974535u, 2791833600u, 0, MODF_TOLERANCE, 0},
{ 501, 3250424296u, 1717672108u, 3250424296u, 1711276032u, 3218630187u, 0u, 0, MODF_TOLERANCE, 0},
{ 502, 1048120593u, 531240316u, 0u, 0u, 1048120593u, 531240316u, 0, MODF_TOLERANCE, 0},
{ 503, 1054174923u, 3548721654u, 0u, 0u, 1054174923u, 3548721654u, 0, MODF_TOLERANCE, 0},
{ 504, 1086112947u, 3391817224u, 1086112768u, 0u, 1072068933u, 1623261184u, 0, MODF_TOLERANCE, 0},
{ 505, 1077836851u, 2758195125u, 1077805056u, 0u, 1071582441u, 430828864u, 0, MODF_TOLERANCE, 0},
{ 506, 1100880260u, 2028440924u, 1100880260u, 2013265920u, 1070395819u, 2147483648u, 0, MODF_TOLERANCE, 0},
{ 507, 1084223893u, 2750123373u, 1084223488u, 0u, 1071209022u, 3101085696u, 0, MODF_TOLERANCE, 0},
{ 508, 3232200256u, 1086294931u, 3232200192u, 0u, 3217035311u, 3806642176u, 0, MODF_TOLERANCE, 0},
{ 509, 1043958672u, 2986160931u, 0u, 0u, 1043958672u, 2986160931u, 0, MODF_TOLERANCE, 0},
{ 510, 1076097908u, 2540046258u, 1075970048u, 0u, 1072641865u, 1986034464u, 0, MODF_TOLERANCE, 0},
{ 511, 3235476602u, 451471221u, 3235476544u, 0u, 3219983732u, 1941602304u, 0, MODF_TOLERANCE, 0},
{ 512, 1064816262u, 4187644495u, 0u, 0u, 1064816262u, 4187644495u, 0, MODF_TOLERANCE, 0},
{ 513, 1099460228u, 2439500162u, 1099460228u, 2415919104u, 1069972760u, 536870912u, 0, MODF_TOLERANCE, 0},
{ 514, 1065280276u, 1979490284u, 0u, 0u, 1065280276u, 1979490284u, 0, MODF_TOLERANCE, 0},
{ 515, 1040415832u, 2283342035u, 0u, 0u, 1040415832u, 2283342035u, 0, MODF_TOLERANCE, 0},
{ 516, 1078398157u, 1345997553u, 1078394880u, 0u, 1069128352u, 1955979776u, 0, MODF_TOLERANCE, 0},
{ 517, 3213249348u, 179066662u, 2147483648u, 0u, 3213249348u, 179066662u, 0, MODF_TOLERANCE, 0},
{ 518, 1103272172u, 1217337578u, 1103272172u, 1216348160u, 1069429204u, 0u, 0, MODF_TOLERANCE, 0},
{ 519, 3211562377u, 3779303391u, 2147483648u, 0u, 3211562377u, 3779303391u, 0, MODF_TOLERANCE, 0},
{ 520, 3210023352u, 3115946280u, 2147483648u, 0u, 3210023352u, 3115946280u, 0, MODF_TOLERANCE, 0},
{ 521, 3192989874u, 286247089u, 2147483648u, 0u, 3192989874u, 286247089u, 0, MODF_TOLERANCE, 0},
{ 522, 1085153597u, 713645369u, 1085153280u, 0u, 1071895208u, 2513670144u, 0, MODF_TOLERANCE, 0},
{ 523, 1093670500u, 1468283899u, 1093670500u, 0u, 1070981390u, 4273995776u, 0, MODF_TOLERANCE, 0},
{ 524, 1042831668u, 2022736418u, 0u, 0u, 1042831668u, 2022736418u, 0, MODF_TOLERANCE, 0},
{ 525, 1083139105u, 3305564080u, 1083138048u, 0u, 1071679252u, 463388672u, 0, MODF_TOLERANCE, 0},
{ 526, 1065483445u, 482392433u, 0u, 0u, 1065483445u, 482392433u, 0, MODF_TOLERANCE, 0},
{ 527, 3201695807u, 2256346551u, 2147483648u, 0u, 3201695807u, 2256346551u, 0, MODF_TOLERANCE, 0},
{ 528, 3222430705u, 2071674991u, 3222274048u, 0u, 3219333003u, 3688498040u, 0, MODF_TOLERANCE, 0},
{ 529, 3204024695u, 2295269094u, 2147483648u, 0u, 3204024695u, 2295269094u, 0, MODF_TOLERANCE, 0},
{ 530, 1084451053u, 2773103941u, 1084450816u, 0u, 1071494313u, 1185456128u, 0, MODF_TOLERANCE, 0},
{ 531, 1078173946u, 1482721827u, 1078165504u, 0u, 1070628140u, 809832832u, 0, MODF_TOLERANCE, 0},
{ 532, 1092243422u, 3125409590u, 1092243420u, 0u, 1072026191u, 3115319296u, 0, MODF_TOLERANCE, 0},
{ 533, 3221065973u, 1381740563u, 3220176896u, 0u, 3219857898u, 2763481126u, 0, MODF_TOLERANCE, 0},
{ 534, 1071545057u, 2918235653u, 0u, 0u, 1071545057u, 2918235653u, 0, MODF_TOLERANCE, 0},
{ 535, 3238715972u, 1105857967u, 3238715968u, 0u, 3219195816u, 918290432u, 0, MODF_TOLERANCE, 0},
{ 536, 3241990046u, 2703723225u, 3241990046u, 0u, 3219399921u, 1528823808u, 0, MODF_TOLERANCE, 0},
{ 537, 1043015571u, 174689677u, 0u, 0u, 1043015571u, 174689677u, 0, MODF_TOLERANCE, 0},
{ 538, 1079333374u, 3947057014u, 1079328768u, 0u, 1070726891u, 1129281024u, 0, MODF_TOLERANCE, 0},
{ 539, 1090461859u, 2023082423u, 1090461856u, 0u, 1070318766u, 1303904256u, 0, MODF_TOLERANCE, 0},
{ 540, 3242081486u, 1169047927u, 3242081486u, 0u, 3218172816u, 1572864000u, 0, MODF_TOLERANCE, 0},
{ 541, 1064525899u, 3742487766u, 0u, 0u, 1064525899u, 3742487766u, 0, MODF_TOLERANCE, 0},
{ 542, 1043425732u, 194972788u, 0u, 0u, 1043425732u, 194972788u, 0, MODF_TOLERANCE, 0},
{ 543, 3213791827u, 2136071361u, 2147483648u, 0u, 3213791827u, 2136071361u, 0, MODF_TOLERANCE, 0},
{ 544, 3211529757u, 993675115u, 2147483648u, 0u, 3211529757u, 993675115u, 0, MODF_TOLERANCE, 0},
{ 545, 3213663381u, 210772141u, 2147483648u, 0u, 3213663381u, 210772141u, 0, MODF_TOLERANCE, 0},
{ 546, 3241441539u, 580731413u, 3241441539u, 0u, 3217116833u, 176160768u, 0, MODF_TOLERANCE, 0},
{ 547, 1093840413u, 1751560711u, 1093840413u, 0u, 1071258028u, 2176843776u, 0, MODF_TOLERANCE, 0},
{ 548, 1074522705u, 180987057u, 1074266112u, 0u, 1071600264u, 1447896456u, 0, MODF_TOLERANCE, 0},
{ 549, 1066754591u, 2552236599u, 0u, 0u, 1066754591u, 2552236599u, 0, MODF_TOLERANCE, 0},
{ 550, 1088658621u, 2112468655u, 1088658592u, 0u, 1072528873u, 3064922112u, 0, MODF_TOLERANCE, 0},
{ 551, 3189290617u, 1578223762u, 2147483648u, 0u, 3189290617u, 1578223762u, 0, MODF_TOLERANCE, 0},
{ 552, 3224596567u, 2456166162u, 3224567808u, 0u, 3218871780u, 2575811712u, 0, MODF_TOLERANCE, 0},
{ 553, 1058506965u, 2110924310u, 0u, 0u, 1058506965u, 2110924310u, 0, MODF_TOLERANCE, 0},
{ 554, 1086207177u, 3161208323u, 1086206976u, 0u, 1072248717u, 2260754432u, 0, MODF_TOLERANCE, 0},
{ 555, 3231863394u, 2352173188u, 3231863296u, 0u, 3217597196u, 3558932480u, 0, MODF_TOLERANCE, 0},
{ 556, 1079361728u, 4070222179u, 1079361536u, 0u, 1065885267u, 1428971520u, 0, MODF_TOLERANCE, 0},
{ 557, 1101012904u, 2481562701u, 1101012904u, 2449473536u, 1072601668u, 3489660928u, 0, MODF_TOLERANCE, 0},
{ 558, 1090937016u, 3809489716u, 1090937016u, 0u, 1069310470u, 1719664640u, 0, MODF_TOLERANCE, 0},
{ 559, 3197002651u, 330905705u, 2147483648u, 0u, 3197002651u, 330905705u, 0, MODF_TOLERANCE, 0},
{ 560, 1086260896u, 90264431u, 1086260736u, 0u, 1071906988u, 711843840u, 0, MODF_TOLERANCE, 0},
{ 561, 1040729961u, 4162008079u, 0u, 0u, 1040729961u, 4162008079u, 0, MODF_TOLERANCE, 0},
{ 562, 3194387916u, 759522153u, 2147483648u, 0u, 3194387916u, 759522153u, 0, MODF_TOLERANCE, 0},
{ 563, 1081015037u, 1839697482u, 1081008128u, 0u, 1072364909u, 2811120128u, 0, MODF_TOLERANCE, 0},
{ 564, 3216442625u, 2211508949u, 2147483648u, 0u, 3216442625u, 2211508949u, 0, MODF_TOLERANCE, 0},
{ 565, 3249807211u, 3736863454u, 3249807211u, 3724541952u, 3219619931u, 3221225472u, 0, MODF_TOLERANCE, 0},
{ 566, 1063475914u, 3150741666u, 0u, 0u, 1063475914u, 3150741666u, 0, MODF_TOLERANCE, 0},
{ 567, 1060785883u, 4200269406u, 0u, 0u, 1060785883u, 4200269406u, 0, MODF_TOLERANCE, 0},
{ 568, 3236646101u, 1061812176u, 3236646080u, 0u, 3219472201u, 4157603840u, 0, MODF_TOLERANCE, 0},
{ 569, 1080217979u, 106027290u, 1080213504u, 0u, 1071741702u, 1373182464u, 0, MODF_TOLERANCE, 0},
{ 570, 3234978297u, 2245237549u, 3234978240u, 0u, 3219964649u, 3449192448u, 0, MODF_TOLERANCE, 0},
{ 571, 3246984334u, 2132131375u, 3246984334u, 2013265920u, 3219937016u, 3154116608u, 0, MODF_TOLERANCE, 0},
{ 572, 3250483427u, 3449276437u, 3250483427u, 3439329280u, 3219323138u, 2684354560u, 0, MODF_TOLERANCE, 0},
{ 573, 1089388778u, 2334440944u, 1089388768u, 0u, 1070929481u, 2078277632u, 0, MODF_TOLERANCE, 0},
{ 574, 1105423490u, 4004336184u, 1105423490u, 4003463168u, 1071293552u, 0u, 0, MODF_TOLERANCE, 0},
{ 575, 3218772704u, 4090088208u, 2147483648u, 0u, 3218772704u, 4090088208u, 0, MODF_TOLERANCE, 0},
{ 576, 1042030013u, 3898658299u, 0u, 0u, 1042030013u, 3898658299u, 0, MODF_TOLERANCE, 0},
{ 577, 3207908064u, 2272831437u, 2147483648u, 0u, 3207908064u, 2272831437u, 0, MODF_TOLERANCE, 0},
{ 578, 3253082595u, 2639188641u, 3253082595u, 2638217216u, 3218974018u, 0u, 0, MODF_TOLERANCE, 0},
{ 579, 1054766684u, 1856594168u, 0u, 0u, 1054766684u, 1856594168u, 0, MODF_TOLERANCE, 0},
{ 580, 3189515294u, 4101853676u, 2147483648u, 0u, 3189515294u, 4101853676u, 0, MODF_TOLERANCE, 0},
{ 581, 1076012412u, 2211699255u, 1075970048u, 0u, 1070903184u, 2054899424u, 0, MODF_TOLERANCE, 0},
{ 582, 3195060344u, 3865018604u, 2147483648u, 0u, 3195060344u, 3865018604u, 0, MODF_TOLERANCE, 0},
{ 583, 3242767010u, 996259334u, 3242767010u, 0u, 3218976987u, 50331648u, 0, MODF_TOLERANCE, 0},
{ 584, 3241496889u, 3782673116u, 3241496889u, 0u, 3219926752u, 1535115264u, 0, MODF_TOLERANCE, 0},
{ 585, 1099130747u, 3840380763u, 1099130747u, 3758096384u, 1071881789u, 1811939328u, 0, MODF_TOLERANCE, 0},
{ 586, 1048674041u, 550040067u, 0u, 0u, 1048674041u, 550040067u, 0, MODF_TOLERANCE, 0},
{ 587, 3251419593u, 95874100u, 3251419593u, 92274688u, 3218830874u, 0u, 0, MODF_TOLERANCE, 0},
{ 588, 3237232828u, 2645647822u, 3237232816u, 0u, 3219733346u, 3281780736u, 0, MODF_TOLERANCE, 0},
{ 589, 1043665640u, 3441419500u, 0u, 0u, 1043665640u, 3441419500u, 0, MODF_TOLERANCE, 0},
{ 590, 3252367038u, 876710419u, 3252367038u, 876609536u, 3214450992u, 0u, 0, MODF_TOLERANCE, 0},
{ 591, 3238593552u, 2560836004u, 3238593552u, 0u, 3216184424u, 880803840u, 0, MODF_TOLERANCE, 0},
{ 592, 3199616543u, 1180840586u, 2147483648u, 0u, 3199616543u, 1180840586u, 0, MODF_TOLERANCE, 0},
{ 593, 3221602966u, 2218230392u, 3221225472u, 0u, 3219589722u, 282986976u, 0, MODF_TOLERANCE, 0},
{ 594, 3227485787u, 3947214579u, 3227484160u, 0u, 3216601005u, 383503360u, 0, MODF_TOLERANCE, 0},
{ 595, 1079539654u, 1447312532u, 1079525376u, 0u, 1072423723u, 572410368u, 0, MODF_TOLERANCE, 0},
{ 596, 1081476588u, 780366847u, 1081475072u, 0u, 1071100090u, 231734272u, 0, MODF_TOLERANCE, 0},
{ 597, 1072569643u, 2842113832u, 0u, 0u, 1072569643u, 2842113832u, 0, MODF_TOLERANCE, 0},
{ 598, 3216156731u, 225159029u, 2147483648u, 0u, 3216156731u, 225159029u, 0, MODF_TOLERANCE, 0},
{ 599, 1098117193u, 1601981129u, 1098117193u, 1342177280u, 1072625813u, 2449473536u, 0, MODF_TOLERANCE, 0},
{ 600, 3234628869u, 2236538344u, 3234628864u, 0u, 3215332667u, 2006974464u, 0, MODF_TOLERANCE, 0},
{ 601, 1085173524u, 2194185737u, 1085173248u, 0u, 1071728684u, 2313195520u, 0, MODF_TOLERANCE, 0},
{ 602, 3242362684u, 87913366u, 3242362684u, 0u, 3215259086u, 1476395008u, 0, MODF_TOLERANCE, 0},
{ 603, 3199083880u, 1346862963u, 2147483648u, 0u, 3199083880u, 1346862963u, 0, MODF_TOLERANCE, 0},
{ 604, 1077836259u, 3604666660u, 1077805056u, 0u, 1071544565u, 3065399552u, 0, MODF_TOLERANCE, 0},
{ 605, 3212255979u, 3115209742u, 2147483648u, 0u, 3212255979u, 3115209742u, 0, MODF_TOLERANCE, 0},
{ 606, 1099332326u, 1325101950u, 1099332326u, 1207959552u, 1072426445u, 4160749568u, 0, MODF_TOLERANCE, 0},
{ 607, 3224546042u, 3889223100u, 3224502272u, 0u, 3219480412u, 4196054912u, 0, MODF_TOLERANCE, 0},
{ 608, 1053247613u, 3371396923u, 0u, 0u, 1053247613u, 3371396923u, 0, MODF_TOLERANCE, 0},
{ 609, 3220477868u, 4163120793u, 3220176896u, 0u, 3218235059u, 3767581284u, 0, MODF_TOLERANCE, 0},
{ 610, 1075022670u, 1387631215u, 1074790400u, 0u, 1072454258u, 2511115128u, 0, MODF_TOLERANCE, 0},
{ 611, 3205481779u, 1532426189u, 2147483648u, 0u, 3205481779u, 1532426189u, 0, MODF_TOLERANCE, 0},
{ 612, 1063168268u, 3397022615u, 0u, 0u, 1063168268u, 3397022615u, 0, MODF_TOLERANCE, 0},
{ 613, 3201033321u, 89324166u, 2147483648u, 0u, 3201033321u, 89324166u, 0, MODF_TOLERANCE, 0},
{ 614, 1079206060u, 3429424710u, 1079197696u, 0u, 1071666790u, 879698688u, 0, MODF_TOLERANCE, 0},
{ 615, 3192325102u, 747591401u, 2147483648u, 0u, 3192325102u, 747591401u, 0, MODF_TOLERANCE, 0},
{ 616, 1072238381u, 2803213904u, 0u, 0u, 1072238381u, 2803213904u, 0, MODF_TOLERANCE, 0},
{ 617, 1091113780u, 271904221u, 1091113776u, 0u, 1071661267u, 3077832704u, 0, MODF_TOLERANCE, 0},
{ 618, 1044258318u, 1858545114u, 0u, 0u, 1044258318u, 1858545114u, 0, MODF_TOLERANCE, 0},
{ 619, 3228068914u, 314958082u, 3228065792u, 0u, 3218629669u, 2344748032u, 0, MODF_TOLERANCE, 0},
{ 620, 3249912496u, 2966213175u, 3249912496u, 2952790016u, 3219757638u, 3758096384u, 0, MODF_TOLERANCE, 0},
{ 621, 3197179414u, 3119528953u, 2147483648u, 0u, 3197179414u, 3119528953u, 0, MODF_TOLERANCE, 0},
{ 622, 3217179014u, 2908718240u, 2147483648u, 0u, 3217179014u, 2908718240u, 0, MODF_TOLERANCE, 0},
{ 623, 3242467576u, 2018361566u, 3242467576u, 0u, 3220050800u, 931135488u, 0, MODF_TOLERANCE, 0},
{ 624, 1100926600u, 3985805054u, 1100926600u, 3959422976u, 1071196399u, 3758096384u, 0, MODF_TOLERANCE, 0},
{ 625, 1070132580u, 409584884u, 0u, 0u, 1070132580u, 409584884u, 0, MODF_TOLERANCE, 0},
{ 626, 3239758947u, 755795129u, 3239758944u, 0u, 3219744868u, 633864192u, 0, MODF_TOLERANCE, 0},
{ 627, 1075772446u, 1819156379u, 1075576832u, 0u, 1072161011u, 1668349144u, 0, MODF_TOLERANCE, 0},
{ 628, 3251342302u, 2982669005u, 3251342302u, 2977955840u, 3219258035u, 1073741824u, 0, MODF_TOLERANCE, 0},
{ 629, 1101563433u, 2080534280u, 1101563433u, 2080374784u, 1064532032u, 0u, 0, MODF_TOLERANCE, 0},
{ 630, 3188254060u, 449171797u, 2147483648u, 0u, 3188254060u, 449171797u, 0, MODF_TOLERANCE, 0},
{ 631, 1095956900u, 168744837u, 1095956900u, 0u, 1069817263u, 167772160u, 0, MODF_TOLERANCE, 0},
{ 632, 3214950009u, 1322217822u, 2147483648u, 0u, 3214950009u, 1322217822u, 0, MODF_TOLERANCE, 0},
{ 633, 3254226900u, 3250487255u, 3254226900u, 3249537024u, 3219980206u, 0u, 0, MODF_TOLERANCE, 0},
{ 634, 1062120700u, 1876195180u, 0u, 0u, 1062120700u, 1876195180u, 0, MODF_TOLERANCE, 0},
{ 635, 3226343480u, 1336400247u, 3226337280u, 0u, 3217569871u, 2816046848u, 0, MODF_TOLERANCE, 0},
{ 636, 1098057903u, 3314079581u, 1098057903u, 3221225472u, 1070998365u, 1946157056u, 0, MODF_TOLERANCE, 0},
{ 637, 3203678820u, 265025555u, 2147483648u, 0u, 3203678820u, 265025555u, 0, MODF_TOLERANCE, 0},
{ 638, 1063854282u, 3779482256u, 0u, 0u, 1063854282u, 3779482256u, 0, MODF_TOLERANCE, 0},
{ 639, 1067300501u, 887044257u, 0u, 0u, 1067300501u, 887044257u, 0, MODF_TOLERANCE, 0},
{ 640, 1054789618u, 2732056261u, 0u, 0u, 1054789618u, 2732056261u, 0, MODF_TOLERANCE, 0},
{ 641, 1050106742u, 4027115185u, 0u, 0u, 1050106742u, 4027115185u, 0, MODF_TOLERANCE, 0},
{ 642, 3191764868u, 2940199511u, 2147483648u, 0u, 3191764868u, 2940199511u, 0, MODF_TOLERANCE, 0},
{ 643, 3202500155u, 2875684421u, 2147483648u, 0u, 3202500155u, 2875684421u, 0, MODF_TOLERANCE, 0},
{ 644, 3227459837u, 2251967570u, 3227451392u, 0u, 3219160771u, 489040128u, 0, MODF_TOLERANCE, 0},
{ 645, 1063244412u, 284173546u, 0u, 0u, 1063244412u, 284173546u, 0, MODF_TOLERANCE, 0},
{ 646, 3238823679u, 3557800647u, 3238823672u, 0u, 3220131902u, 3944480768u, 0, MODF_TOLERANCE, 0},
{ 647, 1101458560u, 3147771266u, 1101458560u, 3120562176u, 1072296664u, 536870912u, 0, MODF_TOLERANCE, 0},
{ 648, 3220110464u, 2933364246u, 2147483648u, 0u, 3220110464u, 2933364246u, 0, MODF_TOLERANCE, 0},
{ 649, 1064853160u, 3366183281u, 0u, 0u, 1064853160u, 3366183281u, 0, MODF_TOLERANCE, 0},
{ 650, 3234870843u, 537442654u, 3234870784u, 0u, 3220017156u, 1554972672u, 0, MODF_TOLERANCE, 0},
{ 651, 3244118788u, 2529029548u, 3244118788u, 2147483648u, 3218521581u, 2885681152u, 0, MODF_TOLERANCE, 0},
{ 652, 3249882819u, 3781513577u, 3249882819u, 3774873600u, 3218691162u, 1073741824u, 0, MODF_TOLERANCE, 0},
{ 653, 3213436354u, 1080845539u, 2147483648u, 0u, 3213436354u, 1080845539u, 0, MODF_TOLERANCE, 0},
{ 654, 3206760016u, 911778687u, 2147483648u, 0u, 3206760016u, 911778687u, 0, MODF_TOLERANCE, 0},
{ 655, 3191951036u, 469586759u, 2147483648u, 0u, 3191951036u, 469586759u, 0, MODF_TOLERANCE, 0},
{ 656, 1091830022u, 3080528840u, 1091830020u, 0u, 1072020713u, 507510784u, 0, MODF_TOLERANCE, 0},
{ 657, 1080249104u, 2863108169u, 1080246272u, 0u, 1070997845u, 1327534592u, 0, MODF_TOLERANCE, 0},
{ 658, 3225605506u, 2508274250u, 3225583616u, 0u, 3219480741u, 1615762048u, 0, MODF_TOLERANCE, 0},
{ 659, 3210826984u, 4080017377u, 2147483648u, 0u, 3210826984u, 4080017377u, 0, MODF_TOLERANCE, 0},
{ 660, 3206492941u, 1470284690u, 2147483648u, 0u, 3206492941u, 1470284690u, 0, MODF_TOLERANCE, 0},
{ 661, 3207120390u, 3867917386u, 2147483648u, 0u, 3207120390u, 3867917386u, 0, MODF_TOLERANCE, 0},
{ 662, 1102054928u, 3504746045u, 1102054928u, 3489660928u, 1072481735u, 2684354560u, 0, MODF_TOLERANCE, 0},
{ 663, 1064522279u, 2962134101u, 0u, 0u, 1064522279u, 2962134101u, 0, MODF_TOLERANCE, 0},
{ 664, 3244741577u, 3390537350u, 3244741577u, 3221225472u, 3218353917u, 201326592u, 0, MODF_TOLERANCE, 0},
{ 665, 1088201813u, 1702237980u, 1088201792u, 0u, 1070949750u, 387710976u, 0, MODF_TOLERANCE, 0},
{ 666, 1071598971u, 1102587474u, 0u, 0u, 1071598971u, 1102587474u, 0, MODF_TOLERANCE, 0},
{ 667, 3202970118u, 2180218657u, 2147483648u, 0u, 3202970118u, 2180218657u, 0, MODF_TOLERANCE, 0},
{ 668, 3211592260u, 1206527853u, 2147483648u, 0u, 3211592260u, 1206527853u, 0, MODF_TOLERANCE, 0},
{ 669, 3197084744u, 394130786u, 2147483648u, 0u, 3197084744u, 394130786u, 0, MODF_TOLERANCE, 0},
{ 670, 3242511482u, 2437699868u, 3242511482u, 2147483648u, 3217116249u, 469762048u, 0, MODF_TOLERANCE, 0},
{ 671, 1044237059u, 849581558u, 0u, 0u, 1044237059u, 849581558u, 0, MODF_TOLERANCE, 0},
{ 672, 3252006507u, 2008614943u, 3252006507u, 2004877312u, 3219948559u, 2147483648u, 0, MODF_TOLERANCE, 0},
{ 673, 3210140014u, 3128971673u, 2147483648u, 0u, 3210140014u, 3128971673u, 0, MODF_TOLERANCE, 0},
{ 674, 3249137531u, 2773583059u, 3249137531u, 2751463424u, 3219462221u, 805306368u, 0, MODF_TOLERANCE, 0},
{ 675, 1085029866u, 590727700u, 1085029376u, 0u, 1072603699u, 1554071552u, 0, MODF_TOLERANCE, 0},
{ 676, 3248651761u, 2183878539u, 3248651761u, 2181038080u, 3216354245u, 2147483648u, 0, MODF_TOLERANCE, 0},
{ 677, 1101098629u, 820687580u, 1101098629u, 805306368u, 1071470171u, 2147483648u, 0, MODF_TOLERANCE, 0},
{ 678, 3208143496u, 1402434664u, 2147483648u, 0u, 3208143496u, 1402434664u, 0, MODF_TOLERANCE, 0},
{ 679, 3252290835u, 1873709254u, 3252290835u, 1870659584u, 3219604579u, 0u, 0, MODF_TOLERANCE, 0},
{ 680, 3245167989u, 44275991u, 3245167989u, 0u, 3216317640u, 3087007744u, 0, MODF_TOLERANCE, 0},
{ 681, 3189668753u, 1174874204u, 2147483648u, 0u, 3189668753u, 1174874204u, 0, MODF_TOLERANCE, 0},
{ 682, 3208263730u, 2360372288u, 2147483648u, 0u, 3208263730u, 2360372288u, 0, MODF_TOLERANCE, 0},
{ 683, 1103854676u, 937573440u, 1103854676u, 931135488u, 1072205584u, 0u, 0, MODF_TOLERANCE, 0},
{ 684, 3208953761u, 211240241u, 2147483648u, 0u, 3208953761u, 211240241u, 0, MODF_TOLERANCE, 0},
{ 685, 3243548934u, 2469774991u, 3243548934u, 2147483648u, 3218290118u, 2399141888u, 0, MODF_TOLERANCE, 0},
{ 686, 1043117070u, 3380071805u, 0u, 0u, 1043117070u, 3380071805u, 0, MODF_TOLERANCE, 0},
{ 687, 1058121042u, 442507560u, 0u, 0u, 1058121042u, 442507560u, 0, MODF_TOLERANCE, 0},
{ 688, 3254252803u, 3257889649u, 3254252803u, 3256877056u, 3220104930u, 0u, 0, MODF_TOLERANCE, 0},
{ 689, 1068850520u, 1854921625u, 0u, 0u, 1068850520u, 1854921625u, 0, MODF_TOLERANCE, 0},
{ 690, 1049810168u, 2729627545u, 0u, 0u, 1049810168u, 2729627545u, 0, MODF_TOLERANCE, 0},
{ 691, 3254712629u, 4001809575u, 3254712629u, 4001366016u, 3218805404u, 0u, 0, MODF_TOLERANCE, 0},
{ 692, 3240128649u, 278261523u, 3240128648u, 0u, 3219196254u, 4046454784u, 0, MODF_TOLERANCE, 0},
{ 693, 1087224694u, 1793907966u, 1087224576u, 0u, 1072536251u, 926908416u, 0, MODF_TOLERANCE, 0},
{ 694, 3238955714u, 398859249u, 3238955712u, 0u, 3218128432u, 3750232064u, 0, MODF_TOLERANCE, 0},
{ 695, 3200952547u, 2511916952u, 2147483648u, 0u, 3200952547u, 2511916952u, 0, MODF_TOLERANCE, 0},
{ 696, 3219195283u, 1697158299u, 2147483648u, 0u, 3219195283u, 1697158299u, 0, MODF_TOLERANCE, 0},
{ 697, 1069985548u, 3230931724u, 0u, 0u, 1069985548u, 3230931724u, 0, MODF_TOLERANCE, 0},
{ 698, 3243897690u, 3508781585u, 3243897690u, 3221225472u, 3218154434u, 285212672u, 0, MODF_TOLERANCE, 0},
{ 699, 1103847606u, 1674254897u, 1103847606u, 1669332992u, 1071826572u, 1073741824u, 0, MODF_TOLERANCE, 0},
{ 700, 1046547577u, 217148561u, 0u, 0u, 1046547577u, 217148561u, 0, MODF_TOLERANCE, 0},
{ 701, 3211263954u, 3275604304u, 2147483648u, 0u, 3211263954u, 3275604304u, 0, MODF_TOLERANCE, 0},
{ 702, 3194840159u, 2991205850u, 2147483648u, 0u, 3194840159u, 2991205850u, 0, MODF_TOLERANCE, 0},
{ 703, 3195249375u, 3509997278u, 2147483648u, 0u, 3195249375u, 3509997278u, 0, MODF_TOLERANCE, 0},
{ 704, 3248888030u, 3897986511u, 3248888030u, 3892314112u, 3217400691u, 3221225472u, 0, MODF_TOLERANCE, 0},
{ 705, 1047182435u, 2156824613u, 0u, 0u, 1047182435u, 2156824613u, 0, MODF_TOLERANCE, 0},
{ 706, 1042295665u, 1239257646u, 0u, 0u, 1042295665u, 1239257646u, 0, MODF_TOLERANCE, 0},
{ 707, 3213264085u, 1073153314u, 2147483648u, 0u, 3213264085u, 1073153314u, 0, MODF_TOLERANCE, 0},
{ 708, 3250031627u, 2567234990u, 3250031627u, 2566914048u, 3214120632u, 0u, 0, MODF_TOLERANCE, 0},
{ 709, 3190593412u, 4261696995u, 2147483648u, 0u, 3190593412u, 4261696995u, 0, MODF_TOLERANCE, 0},
{ 710, 3197784432u, 323702024u, 2147483648u, 0u, 3197784432u, 323702024u, 0, MODF_TOLERANCE, 0},
{ 711, 3243690997u, 4075177615u, 3243690997u, 3221225472u, 3219747619u, 1199570944u, 0, MODF_TOLERANCE, 0},
{ 712, 3202791065u, 1919006082u, 2147483648u, 0u, 3202791065u, 1919006082u, 0, MODF_TOLERANCE, 0},
{ 713, 3239270013u, 386429966u, 3239270012u, 0u, 3218174087u, 1088421888u, 0, MODF_TOLERANCE, 0},
{ 714, 1086504491u, 3698826164u, 1086504448u, 0u, 1070984763u, 3453616128u, 0, MODF_TOLERANCE, 0},
{ 715, 1078327190u, 1681986446u, 1078296576u, 0u, 1072555417u, 272950144u, 0, MODF_TOLERANCE, 0},
{ 716, 3194985869u, 3072950140u, 2147483648u, 0u, 3194985869u, 3072950140u, 0, MODF_TOLERANCE, 0},
{ 717, 3217311933u, 3719038997u, 2147483648u, 0u, 3217311933u, 3719038997u, 0, MODF_TOLERANCE, 0},
{ 718, 1055433962u, 3331415058u, 0u, 0u, 1055433962u, 3331415058u, 0, MODF_TOLERANCE, 0},
{ 719, 1060749713u, 2420250111u, 0u, 0u, 1060749713u, 2420250111u, 0, MODF_TOLERANCE, 0},
{ 720, 3238002206u, 1928661079u, 3238002192u, 0u, 3219973610u, 279838720u, 0, MODF_TOLERANCE, 0},
{ 721, 1081914210u, 3679866727u, 1081913344u, 0u, 1070274266u, 2994419712u, 0, MODF_TOLERANCE, 0},
{ 722, 3227386672u, 1273835792u, 3227385856u, 0u, 3215557215u, 1770553344u, 0, MODF_TOLERANCE, 0},
{ 723, 1041622738u, 2682092368u, 0u, 0u, 1041622738u, 2682092368u, 0, MODF_TOLERANCE, 0},
{ 724, 3234222284u, 1325425811u, 3234222208u, 0u, 3219329984u, 421838848u, 0, MODF_TOLERANCE, 0},
{ 725, 1056312613u, 4175172697u, 0u, 0u, 1056312613u, 4175172697u, 0, MODF_TOLERANCE, 0},
{ 726, 3208346191u, 2130706153u, 2147483648u, 0u, 3208346191u, 2130706153u, 0, MODF_TOLERANCE, 0},
{ 727, 1092089624u, 1200784450u, 1092089624u, 0u, 1068623009u, 276824064u, 0, MODF_TOLERANCE, 0},
{ 728, 1083605096u, 1248595607u, 1083604992u, 0u, 1069159067u, 61194240u, 0, MODF_TOLERANCE, 0},
{ 729, 3213890863u, 1897285171u, 2147483648u, 0u, 3213890863u, 1897285171u, 0, MODF_TOLERANCE, 0},
{ 730, 3251296075u, 944966123u, 3251296075u, 939524096u, 3219440250u, 3221225472u, 0, MODF_TOLERANCE, 0},
{ 731, 3241371250u, 2270747330u, 3241371250u, 0u, 3219188507u, 1480589312u, 0, MODF_TOLERANCE, 0},
{ 732, 3230692631u, 422503284u, 3230692352u, 0u, 3218174354u, 3996598272u, 0, MODF_TOLERANCE, 0},
{ 733, 1084120037u, 2857564741u, 1084119040u, 0u, 1072639314u, 2547132416u, 0, MODF_TOLERANCE, 0},
{ 734, 1075647403u, 3308906709u, 1075576832u, 0u, 1070676668u, 1402899792u, 0, MODF_TOLERANCE, 0},
{ 735, 3203475098u, 1380066948u, 2147483648u, 0u, 3203475098u, 1380066948u, 0, MODF_TOLERANCE, 0},
{ 736, 3232612906u, 2613634294u, 3232612864u, 0u, 3216330212u, 1920663552u, 0, MODF_TOLERANCE, 0},
{ 737, 1063890856u, 4022784584u, 0u, 0u, 1063890856u, 4022784584u, 0, MODF_TOLERANCE, 0},
{ 738, 1060483857u, 3264056381u, 0u, 0u, 1060483857u, 3264056381u, 0, MODF_TOLERANCE, 0},
{ 739, 1044637404u, 1778509100u, 0u, 0u, 1044637404u, 1778509100u, 0, MODF_TOLERANCE, 0},
{ 740, 3213146285u, 2665833973u, 2147483648u, 0u, 3213146285u, 2665833973u, 0, MODF_TOLERANCE, 0},
{ 741, 3216727300u, 1859175955u, 2147483648u, 0u, 3216727300u, 1859175955u, 0, MODF_TOLERANCE, 0},
{ 742, 1079949560u, 4258450607u, 1079934976u, 0u, 1072462974u, 3915798400u, 0, MODF_TOLERANCE, 0},
{ 743, 1048277388u, 4128020197u, 0u, 0u, 1048277388u, 4128020197u, 0, MODF_TOLERANCE, 0},
{ 744, 1076266146u, 4122840980u, 1076232192u, 0u, 1070634078u, 3081892480u, 0, MODF_TOLERANCE, 0},
{ 745, 3193183163u, 2454653987u, 2147483648u, 0u, 3193183163u, 2454653987u, 0, MODF_TOLERANCE, 0},
{ 746, 3229487005u, 2977478685u, 3229483008u, 0u, 3220126562u, 4050663936u, 0, MODF_TOLERANCE, 0},
{ 747, 3253556483u, 1355181872u, 3253556483u, 1354760192u, 3217669312u, 0u, 0, MODF_TOLERANCE, 0},
{ 748, 1095308770u, 436846481u, 1095308770u, 0u, 1070205375u, 2432696320u, 0, MODF_TOLERANCE, 0},
{ 749, 3246605302u, 2592856453u, 3246605302u, 2550136832u, 3218366156u, 671088640u, 0, MODF_TOLERANCE, 0},
{ 750, 3247825559u, 3195234082u, 3247825559u, 3154116608u, 3219364665u, 268435456u, 0, MODF_TOLERANCE, 0},
{ 751, 3222118023u, 3554670043u, 3221749760u, 0u, 3219552799u, 1333778284u, 0, MODF_TOLERANCE, 0},
{ 752, 1091621009u, 3321236467u, 1091621008u, 0u, 1071406944u, 3207593984u, 0, MODF_TOLERANCE, 0},
{ 753, 1069012833u, 1936670355u, 0u, 0u, 1069012833u, 1936670355u, 0, MODF_TOLERANCE, 0},
{ 754, 1095715713u, 2958468553u, 1095715713u, 2147483648u, 1071131474u, 3833593856u, 0, MODF_TOLERANCE, 0},
{ 755, 3192291109u, 2960339502u, 2147483648u, 0u, 3192291109u, 2960339502u, 0, MODF_TOLERANCE, 0},
{ 756, 1098808013u, 1044068983u, 1098808013u, 805306368u, 1072461428u, 3992977408u, 0, MODF_TOLERANCE, 0},
{ 757, 3196691185u, 4093388677u, 2147483648u, 0u, 3196691185u, 4093388677u, 0, MODF_TOLERANCE, 0},
{ 758, 1095478112u, 1735930261u, 1095478112u, 0u, 1072291340u, 1698693120u, 0, MODF_TOLERANCE, 0},
{ 759, 1091040302u, 1807398746u, 1091040296u, 0u, 1072279274u, 3714580480u, 0, MODF_TOLERANCE, 0},
{ 760, 3195743135u, 4261616162u, 2147483648u, 0u, 3195743135u, 4261616162u, 0, MODF_TOLERANCE, 0},
{ 761, 3209294194u, 3250576797u, 2147483648u, 0u, 3209294194u, 3250576797u, 0, MODF_TOLERANCE, 0},
{ 762, 1059002384u, 3043079652u, 0u, 0u, 1059002384u, 3043079652u, 0, MODF_TOLERANCE, 0},
{ 763, 1069207109u, 666051428u, 0u, 0u, 1069207109u, 666051428u, 0, MODF_TOLERANCE, 0},
{ 764, 3208765404u, 1912684117u, 2147483648u, 0u, 3208765404u, 1912684117u, 0, MODF_TOLERANCE, 0},
{ 765, 1103487420u, 1949030179u, 1103487420u, 1946157056u, 1070984081u, 2147483648u, 0, MODF_TOLERANCE, 0},
{ 766, 1096388934u, 896459246u, 1096388934u, 0u, 1072346992u, 4143972352u, 0, MODF_TOLERANCE, 0},
{ 767, 1054300653u, 622499767u, 0u, 0u, 1054300653u, 622499767u, 0, MODF_TOLERANCE, 0},
{ 768, 1066707637u, 1490260486u, 0u, 0u, 1066707637u, 1490260486u, 0, MODF_TOLERANCE, 0},
{ 769, 1106688493u, 1490616165u, 1106688493u, 1490026496u, 1071775434u, 0u, 0, MODF_TOLERANCE, 0},
{ 770, 3251242436u, 795675736u, 3251242436u, 788529152u, 3219866390u, 0u, 0, MODF_TOLERANCE, 0},
{ 771, 1080943896u, 3662877092u, 1080942592u, 0u, 1069835113u, 1279692800u, 0, MODF_TOLERANCE, 0},
{ 772, 3234317146u, 3200513112u, 3234317056u, 0u, 3219566512u, 4246077440u, 0, MODF_TOLERANCE, 0},
{ 773, 1084088786u, 1356101968u, 1084088320u, 0u, 1071457549u, 1200947200u, 0, MODF_TOLERANCE, 0},
{ 774, 3236536816u, 3062844611u, 3236536800u, 0u, 3219175055u, 1287847936u, 0, MODF_TOLERANCE, 0},
{ 775, 3219922640u, 2284484846u, 2147483648u, 0u, 3219922640u, 2284484846u, 0, MODF_TOLERANCE, 0},
{ 776, 3219498359u, 3240896015u, 2147483648u, 0u, 3219498359u, 3240896015u, 0, MODF_TOLERANCE, 0},
{ 777, 3235759689u, 494503287u, 3235759680u, 0u, 3217177331u, 183369728u, 0, MODF_TOLERANCE, 0},
{ 778, 1092811254u, 142673998u, 1092811254u, 0u, 1066467856u, 2617245696u, 0, MODF_TOLERANCE, 0},
{ 779, 3252125916u, 3394882641u, 3252125916u, 3393191936u, 3218721873u, 0u, 0, MODF_TOLERANCE, 0},
{ 780, 3225306538u, 364852125u, 3225288704u, 0u, 3218172549u, 1875699520u, 0, MODF_TOLERANCE, 0},
{ 781, 3225261763u, 193885269u, 3225223168u, 0u, 3219314785u, 1909361312u, 0, MODF_TOLERANCE, 0},
{ 782, 1088149839u, 1359805831u, 1088149824u, 0u, 1070506521u, 4211998720u, 0, MODF_TOLERANCE, 0},
{ 783, 3200484782u, 592580907u, 2147483648u, 0u, 3200484782u, 592580907u, 0, MODF_TOLERANCE, 0},
{ 784, 3199560872u, 3086438952u, 2147483648u, 0u, 3199560872u, 3086438952u, 0, MODF_TOLERANCE, 0},
{ 785, 1059518664u, 1778008540u, 0u, 0u, 1059518664u, 1778008540u, 0, MODF_TOLERANCE, 0},
{ 786, 1049064687u, 73581647u, 0u, 0u, 1049064687u, 73581647u, 0, MODF_TOLERANCE, 0},
{ 787, 3246733598u, 233240285u, 3246733598u, 134217728u, 3219626971u, 1946157056u, 0, MODF_TOLERANCE, 0},
{ 788, 1081923320u, 2710903921u, 1081921536u, 0u, 1071374982u, 1416741888u, 0, MODF_TOLERANCE, 0},
{ 789, 1069513767u, 3719878805u, 0u, 0u, 1069513767u, 3719878805u, 0, MODF_TOLERANCE, 0},
{ 790, 1079866720u, 3615458228u, 1079853056u, 0u, 1072345195u, 3217152512u, 0, MODF_TOLERANCE, 0},
{ 791, 3221194724u, 3647632375u, 3220176896u, 0u, 3220115401u, 3000297454u, 0, MODF_TOLERANCE, 0},
{ 792, 3247225271u, 3839959621u, 3247225271u, 3758096384u, 3219358857u, 335544320u, 0, MODF_TOLERANCE, 0},
{ 793, 1103401096u, 2232210456u, 1103401096u, 2231369728u, 1069131824u, 0u, 0, MODF_TOLERANCE, 0},
{ 794, 3235434773u, 224271737u, 3235434752u, 0u, 3218410846u, 494469120u, 0, MODF_TOLERANCE, 0},
{ 795, 3193003684u, 2134662911u, 2147483648u, 0u, 3193003684u, 2134662911u, 0, MODF_TOLERANCE, 0},
{ 796, 3190390590u, 4239009051u, 2147483648u, 0u, 3190390590u, 4239009051u, 0, MODF_TOLERANCE, 0},
{ 797, 1080526145u, 2305279897u, 1080524800u, 0u, 1069876773u, 2669569024u, 0, MODF_TOLERANCE, 0},
{ 798, 1077668039u, 1854523320u, 1077608448u, 0u, 1072503021u, 3510171392u, 0, MODF_TOLERANCE, 0},
{ 799, 3219864259u, 538224650u, 2147483648u, 0u, 3219864259u, 538224650u, 0, MODF_TOLERANCE, 0},
{ 800, 3206153057u, 1379649610u, 2147483648u, 0u, 3206153057u, 1379649610u, 0, MODF_TOLERANCE, 0},
{ 801, 3196410507u, 3683897920u, 2147483648u, 0u, 3196410507u, 3683897920u, 0, MODF_TOLERANCE, 0},
{ 802, 3244167599u, 3647579469u, 3244167599u, 3221225472u, 3218696613u, 1291845632u, 0, MODF_TOLERANCE, 0},
{ 803, 1090280933u, 2694093608u, 1090280928u, 0u, 1071022674u, 1822425088u, 0, MODF_TOLERANCE, 0},
{ 804, 1042775347u, 598406111u, 0u, 0u, 1042775347u, 598406111u, 0, MODF_TOLERANCE, 0},
{ 805, 3211635392u, 872706833u, 2147483648u, 0u, 3211635392u, 872706833u, 0, MODF_TOLERANCE, 0},
{ 806, 1084802480u, 2200602798u, 1084802048u, 0u, 1072367666u, 2827673600u, 0, MODF_TOLERANCE, 0},
{ 807, 1042339597u, 904146293u, 0u, 0u, 1042339597u, 904146293u, 0, MODF_TOLERANCE, 0},
{ 808, 1060867322u, 1729685598u, 0u, 0u, 1060867322u, 1729685598u, 0, MODF_TOLERANCE, 0},
{ 809, 3195694970u, 1894173462u, 2147483648u, 0u, 3195694970u, 1894173462u, 0, MODF_TOLERANCE, 0},
{ 810, 3232800651u, 191960416u, 3232800512u, 0u, 3219218798u, 581697536u, 0, MODF_TOLERANCE, 0},
{ 811, 1091225343u, 3521028551u, 1091225336u, 0u, 1072646010u, 2266759168u, 0, MODF_TOLERANCE, 0},
{ 812, 1054522089u, 3287274359u, 0u, 0u, 1054522089u, 3287274359u, 0, MODF_TOLERANCE, 0},
{ 813, 1095386964u, 959640601u, 1095386964u, 0u, 1071421818u, 209715200u, 0, MODF_TOLERANCE, 0},
{ 814, 3201578263u, 4136915018u, 2147483648u, 0u, 3201578263u, 4136915018u, 0, MODF_TOLERANCE, 0},
{ 815, 1064005451u, 1553716379u, 0u, 0u, 1064005451u, 1553716379u, 0, MODF_TOLERANCE, 0},
{ 816, 1106027987u, 984725765u, 1106027987u, 983564288u, 1071757573u, 0u, 0, MODF_TOLERANCE, 0},
{ 817, 3238832641u, 2287646644u, 3238832640u, 0u, 3217589675u, 2067791872u, 0, MODF_TOLERANCE, 0},
{ 818, 3240329321u, 2276183378u, 3240329320u, 0u, 3219684028u, 3575644160u, 0, MODF_TOLERANCE, 0},
{ 819, 1068209174u, 3940225170u, 0u, 0u, 1068209174u, 3940225170u, 0, MODF_TOLERANCE, 0},
{ 820, 3199544434u, 997572161u, 2147483648u, 0u, 3199544434u, 997572161u, 0, MODF_TOLERANCE, 0},
{ 821, 3212768361u, 36116288u, 2147483648u, 0u, 3212768361u, 36116288u, 0, MODF_TOLERANCE, 0},
{ 822, 3206886566u, 4196602670u, 2147483648u, 0u, 3206886566u, 4196602670u, 0, MODF_TOLERANCE, 0},
{ 823, 3241695853u, 3550227562u, 3241695853u, 0u, 3219813253u, 2369781760u, 0, MODF_TOLERANCE, 0},
{ 824, 3207257983u, 2747744117u, 2147483648u, 0u, 3207257983u, 2747744117u, 0, MODF_TOLERANCE, 0},
{ 825, 1104236126u, 507130047u, 1104236126u, 503316480u, 1072502879u, 2147483648u, 0, MODF_TOLERANCE, 0},
{ 826, 1048359321u, 3229888373u, 0u, 0u, 1048359321u, 3229888373u, 0, MODF_TOLERANCE, 0},
{ 827, 3222996778u, 2210969014u, 3222798336u, 0u, 3219667284u, 507882928u, 0, MODF_TOLERANCE, 0},
{ 828, 1081031001u, 1946786091u, 1081024512u, 0u, 1072257396u, 161032960u, 0, MODF_TOLERANCE, 0},
{ 829, 3236306990u, 4059150589u, 3236306976u, 0u, 3218990051u, 1912209408u, 0, MODF_TOLERANCE, 0},
{ 830, 3189759234u, 1177045799u, 2147483648u, 0u, 3189759234u, 1177045799u, 0, MODF_TOLERANCE, 0},
{ 831, 1093103612u, 2664812822u, 1093103612u, 0u, 1070848698u, 583008256u, 0, MODF_TOLERANCE, 0},
{ 832, 1050343198u, 2034180320u, 0u, 0u, 1050343198u, 2034180320u, 0, MODF_TOLERANCE, 0},
{ 833, 3213779117u, 1175750283u, 2147483648u, 0u, 3213779117u, 1175750283u, 0, MODF_TOLERANCE, 0},
{ 834, 3235559706u, 1424491340u, 3235559680u, 0u, 3218756840u, 55312384u, 0, MODF_TOLERANCE, 0},
{ 835, 3213904193u, 1630036121u, 2147483648u, 0u, 3213904193u, 1630036121u, 0, MODF_TOLERANCE, 0},
{ 836, 3231972785u, 3195479448u, 3231972352u, 0u, 3219856359u, 1918468096u, 0, MODF_TOLERANCE, 0},
{ 837, 1090429875u, 2527029044u, 1090429872u, 0u, 1070380283u, 966787072u, 0, MODF_TOLERANCE, 0},
{ 838, 1046927050u, 4000723255u, 0u, 0u, 1046927050u, 4000723255u, 0, MODF_TOLERANCE, 0},
{ 839, 1085208677u, 3335703647u, 1085208576u, 0u, 1070166452u, 3004678144u, 0, MODF_TOLERANCE, 0},
{ 840, 3237349676u, 3869440059u, 3237349664u, 0u, 3219770693u, 4034265088u, 0, MODF_TOLERANCE, 0},
{ 841, 1091433848u, 3888398377u, 1091433848u, 0u, 1069349000u, 85983232u, 0, MODF_TOLERANCE, 0},
{ 842, 3196041693u, 1290567220u, 2147483648u, 0u, 3196041693u, 1290567220u, 0, MODF_TOLERANCE, 0},
{ 843, 1066679070u, 3242451480u, 0u, 0u, 1066679070u, 3242451480u, 0, MODF_TOLERANCE, 0},
{ 844, 3248384948u, 707431021u, 3248384948u, 671088640u, 3219215443u, 1744830464u, 0, MODF_TOLERANCE, 0},
{ 845, 1083230509u, 2739665123u, 1083230208u, 0u, 1070783028u, 3213766656u, 0, MODF_TOLERANCE, 0},
{ 846, 1060777905u, 1733073225u, 0u, 0u, 1060777905u, 1733073225u, 0, MODF_TOLERANCE, 0},
{ 847, 1078517061u, 1297274853u, 1078493184u, 0u, 1072124243u, 1421211968u, 0, MODF_TOLERANCE, 0},
{ 848, 3208848704u, 3341639139u, 2147483648u, 0u, 3208848704u, 3341639139u, 0, MODF_TOLERANCE, 0},
{ 849, 1046570941u, 2228057309u, 0u, 0u, 1046570941u, 2228057309u, 0, MODF_TOLERANCE, 0},
{ 850, 1084318902u, 1317851136u, 1084318720u, 0u, 1071040977u, 2583691264u, 0, MODF_TOLERANCE, 0},
{ 851, 1088255327u, 270039934u, 1088255296u, 0u, 1071583256u, 2071855104u, 0, MODF_TOLERANCE, 0},
{ 852, 3241414679u, 3063626339u, 3241414679u, 0u, 3219575655u, 1281359872u, 0, MODF_TOLERANCE, 0},
{ 853, 3219178350u, 83062251u, 2147483648u, 0u, 3219178350u, 83062251u, 0, MODF_TOLERANCE, 0},
{ 854, 3211262173u, 2659016437u, 2147483648u, 0u, 3211262173u, 2659016437u, 0, MODF_TOLERANCE, 0},
{ 855, 1095743886u, 3833539373u, 1095743886u, 2147483648u, 1072242634u, 3409969152u, 0, MODF_TOLERANCE, 0},
{ 856, 3206667189u, 1567476111u, 2147483648u, 0u, 3206667189u, 1567476111u, 0, MODF_TOLERANCE, 0},
{ 857, 3205195072u, 2382776852u, 2147483648u, 0u, 3205195072u, 2382776852u, 0, MODF_TOLERANCE, 0},
{ 858, 3249232579u, 1546622468u, 3249232579u, 1543503872u, 3216493314u, 0u, 0, MODF_TOLERANCE, 0},
{ 859, 1085536439u, 1714300821u, 1085536256u, 0u, 1072098501u, 3304235008u, 0, MODF_TOLERANCE, 0},
{ 860, 1104130938u, 4167591598u, 1104130938u, 4160749568u, 1072306603u, 2147483648u, 0, MODF_TOLERANCE, 0},
{ 861, 1051092760u, 2798720100u, 0u, 0u, 1051092760u, 2798720100u, 0, MODF_TOLERANCE, 0},
{ 862, 1086978789u, 449990704u, 1086978688u, 0u, 1072252596u, 2483814400u, 0, MODF_TOLERANCE, 0},
{ 863, 3231198415u, 4039516226u, 3231198208u, 0u, 3217686040u, 3288875008u, 0, MODF_TOLERANCE, 0},
{ 864, 3244344107u, 4272932619u, 3244344107u, 3758096384u, 3220090823u, 184549376u, 0, MODF_TOLERANCE, 0},
{ 865, 3222708441u, 1683007544u, 3222536192u, 0u, 3219457739u, 579158464u, 0, MODF_TOLERANCE, 0},
{ 866, 1091105663u, 3805494321u, 1091105656u, 0u, 1072663372u, 4039376896u, 0, MODF_TOLERANCE, 0},
{ 867, 3220852948u, 2072627412u, 3220176896u, 0u, 3219431848u, 4145254824u, 0, MODF_TOLERANCE, 0},
{ 868, 1094383324u, 3394151662u, 1094383324u, 0u, 1072253396u, 2646605824u, 0, MODF_TOLERANCE, 0},
{ 869, 3220570024u, 1120106427u, 3220176896u, 0u, 3218603681u, 185458412u, 0, MODF_TOLERANCE, 0},
{ 870, 3223631624u, 3404608264u, 3223584768u, 0u, 3218530585u, 1573282048u, 0, MODF_TOLERANCE, 0},
{ 871, 1097859997u, 559918757u, 1097859997u, 536870912u, 1068890858u, 1342177280u, 0, MODF_TOLERANCE, 0},
{ 872, 3205077053u, 908100198u, 2147483648u, 0u, 3205077053u, 908100198u, 0, MODF_TOLERANCE, 0},
{ 873, 1042677918u, 2026673913u, 0u, 0u, 1042677918u, 2026673913u, 0, MODF_TOLERANCE, 0},
{ 874, 3244833635u, 2844573214u, 3244833635u, 2684354560u, 3218282876u, 1006632960u, 0, MODF_TOLERANCE, 0},
{ 875, 3254567259u, 3946837259u, 3254567259u, 3945791488u, 3220171286u, 0u, 0, MODF_TOLERANCE, 0},
{ 876, 3234993796u, 3850406820u, 3234993792u, 0u, 3216217602u, 781189120u, 0, MODF_TOLERANCE, 0},
{ 877, 1057479809u, 3139330994u, 0u, 0u, 1057479809u, 3139330994u, 0, MODF_TOLERANCE, 0},
{ 878, 1046133568u, 1539650690u, 0u, 0u, 1046133568u, 1539650690u, 0, MODF_TOLERANCE, 0},
{ 879, 3236705500u, 1554593884u, 3236705472u, 0u, 3219938473u, 945553408u, 0, MODF_TOLERANCE, 0},
{ 880, 3228899878u, 2813752562u, 3228897280u, 0u, 3219410255u, 1827267584u, 0, MODF_TOLERANCE, 0},
{ 881, 1056505004u, 3804703138u, 0u, 0u, 1056505004u, 3804703138u, 0, MODF_TOLERANCE, 0},
{ 882, 1072931071u, 2053677923u, 1072693248u, 0u, 1070401531u, 3544521496u, 0, MODF_TOLERANCE, 0},
{ 883, 3244864299u, 289355864u, 3244864299u, 0u, 3219210040u, 1476395008u, 0, MODF_TOLERANCE, 0},
{ 884, 1078453818u, 2143066338u, 1078427648u, 0u, 1072271007u, 4012259456u, 0, MODF_TOLERANCE, 0},
{ 885, 3203939880u, 2157691971u, 2147483648u, 0u, 3203939880u, 2157691971u, 0, MODF_TOLERANCE, 0},
{ 886, 1106629150u, 110806409u, 1106629150u, 110100480u, 1072007954u, 0u, 0, MODF_TOLERANCE, 0},
{ 887, 1082157019u, 3570399481u, 1082155008u, 0u, 1072656211u, 1071899648u, 0, MODF_TOLERANCE, 0},
{ 888, 1085637605u, 180265334u, 1085637376u, 0u, 1072472407u, 3559833600u, 0, MODF_TOLERANCE, 0},
{ 889, 3200980182u, 558779875u, 2147483648u, 0u, 3200980182u, 558779875u, 0, MODF_TOLERANCE, 0},
{ 890, 3202046748u, 2338464653u, 2147483648u, 0u, 3202046748u, 2338464653u, 0, MODF_TOLERANCE, 0},
{ 891, 1045705464u, 1703969219u, 0u, 0u, 1045705464u, 1703969219u, 0, MODF_TOLERANCE, 0},
{ 892, 3229797258u, 1417521063u, 3229796352u, 0u, 3218887331u, 3980212224u, 0, MODF_TOLERANCE, 0},
{ 893, 3237782261u, 3917440951u, 3237782256u, 0u, 3218580989u, 2665218048u, 0, MODF_TOLERANCE, 0},
{ 894, 1051668894u, 3736066983u, 0u, 0u, 1051668894u, 3736066983u, 0, MODF_TOLERANCE, 0},
{ 895, 1064752080u, 3106613409u, 0u, 0u, 1064752080u, 3106613409u, 0, MODF_TOLERANCE, 0},
{ 896, 1066627453u, 2735392257u, 0u, 0u, 1066627453u, 2735392257u, 0, MODF_TOLERANCE, 0},
{ 897, 1065665372u, 2229777605u, 0u, 0u, 1065665372u, 2229777605u, 0, MODF_TOLERANCE, 0},
{ 898, 1065061963u, 2405869925u, 0u, 0u, 1065061963u, 2405869925u, 0, MODF_TOLERANCE, 0},
{ 899, 3239463229u, 3967957902u, 3239463228u, 0u, 3219048483u, 3101687808u, 0, MODF_TOLERANCE, 0},
{ 900, 1057416138u, 3459188071u, 0u, 0u, 1057416138u, 3459188071u, 0, MODF_TOLERANCE, 0},
{ 901, 1068639210u, 3699016825u, 0u, 0u, 1068639210u, 3699016825u, 0, MODF_TOLERANCE, 0},
{ 902, 3249713090u, 796144848u, 3249713090u, 788529152u, 3218935092u, 0u, 0, MODF_TOLERANCE, 0},
{ 903, 3228816396u, 3285165564u, 3228815360u, 0u, 3218092815u, 1050144768u, 0, MODF_TOLERANCE, 0},
{ 904, 3211948811u, 401510871u, 2147483648u, 0u, 3211948811u, 401510871u, 0, MODF_TOLERANCE, 0},
{ 905, 1094257658u, 634857910u, 1094257658u, 0u, 1069738900u, 3674210304u, 0, MODF_TOLERANCE, 0},
{ 906, 3199607513u, 914218057u, 2147483648u, 0u, 3199607513u, 914218057u, 0, MODF_TOLERANCE, 0},
{ 907, 1083743336u, 2030735578u, 1083743232u, 0u, 1069162050u, 2755035136u, 0, MODF_TOLERANCE, 0},
{ 908, 3233855943u, 965677531u, 3233855872u, 0u, 3219246691u, 3296116736u, 0, MODF_TOLERANCE, 0},
{ 909, 1079556815u, 3957229084u, 1079541760u, 0u, 1072523253u, 4014149120u, 0, MODF_TOLERANCE, 0},
{ 910, 1051050470u, 3123776651u, 0u, 0u, 1051050470u, 3123776651u, 0, MODF_TOLERANCE, 0},
{ 911, 3221863333u, 162122081u, 3221749760u, 0u, 3217799760u, 2593953296u, 0, MODF_TOLERANCE, 0},
{ 912, 3239376395u, 108064594u, 3239376392u, 0u, 3219665799u, 2056257536u, 0, MODF_TOLERANCE, 0},
{ 913, 3237271786u, 869031839u, 3237271776u, 0u, 3219416984u, 3208511488u, 0, MODF_TOLERANCE, 0},
{ 914, 3225020876u, 1344301606u, 3224961024u, 0u, 3219995018u, 67978432u, 0, MODF_TOLERANCE, 0},
{ 915, 3214433474u, 946696117u, 2147483648u, 0u, 3214433474u, 946696117u, 0, MODF_TOLERANCE, 0},
{ 916, 3231825228u, 1700703647u, 3231824896u, 0u, 3219441237u, 3940151296u, 0, MODF_TOLERANCE, 0},
{ 917, 1075492875u, 3394168074u, 1075314688u, 0u, 1072021598u, 1383540816u, 0, MODF_TOLERANCE, 0},
{ 918, 1076939786u, 1666995668u, 1076887552u, 0u, 1072267596u, 1804253824u, 0, MODF_TOLERANCE, 0},
{ 919, 3208774795u, 2488789804u, 2147483648u, 0u, 3208774795u, 2488789804u, 0, MODF_TOLERANCE, 0},
{ 920, 3238508333u, 1506943664u, 3238508328u, 0u, 3219482440u, 2327838720u, 0, MODF_TOLERANCE, 0},
{ 921, 1072788663u, 3844072288u, 1072693248u, 0u, 1068977022u, 1375614464u, 0, MODF_TOLERANCE, 0},
{ 922, 3202592279u, 2630019853u, 2147483648u, 0u, 3202592279u, 2630019853u, 0, MODF_TOLERANCE, 0},
{ 923, 3219934542u, 1244307192u, 2147483648u, 0u, 3219934542u, 1244307192u, 0, MODF_TOLERANCE, 0},
{ 924, 3191297711u, 2540916692u, 2147483648u, 0u, 3191297711u, 2540916692u, 0, MODF_TOLERANCE, 0},
{ 925, 3200062692u, 2871645739u, 2147483648u, 0u, 3200062692u, 2871645739u, 0, MODF_TOLERANCE, 0},
{ 926, 3239081581u, 1440249115u, 3239081580u, 0u, 3218431367u, 1370488832u, 0, MODF_TOLERANCE, 0},
{ 927, 1068350633u, 1231934926u, 0u, 0u, 1068350633u, 1231934926u, 0, MODF_TOLERANCE, 0},
{ 928, 3236746788u, 603977748u, 3236746784u, 0u, 3217068031u, 3763339264u, 0, MODF_TOLERANCE, 0},
{ 929, 3195449689u, 2386312545u, 2147483648u, 0u, 3195449689u, 2386312545u, 0, MODF_TOLERANCE, 0},
{ 930, 1063169277u, 2715234268u, 0u, 0u, 1063169277u, 2715234268u, 0, MODF_TOLERANCE, 0},
{ 931, 1087803418u, 915867083u, 1087803392u, 0u, 1071265431u, 97189888u, 0, MODF_TOLERANCE, 0},
{ 932, 1046790892u, 3347417612u, 0u, 0u, 1046790892u, 3347417612u, 0, MODF_TOLERANCE, 0},
{ 933, 1105984188u, 3553288373u, 1105984188u, 3552575488u, 1070973290u, 0u, 0, MODF_TOLERANCE, 0},
{ 934, 1065698616u, 2906680663u, 0u, 0u, 1065698616u, 2906680663u, 0, MODF_TOLERANCE, 0},
{ 935, 1045506226u, 2342364630u, 0u, 0u, 1045506226u, 2342364630u, 0, MODF_TOLERANCE, 0},
{ 936, 1051356723u, 4019093203u, 0u, 0u, 1051356723u, 4019093203u, 0, MODF_TOLERANCE, 0},
{ 937, 3201169162u, 2911548084u, 2147483648u, 0u, 3201169162u, 2911548084u, 0, MODF_TOLERANCE, 0},
{ 938, 1105282515u, 2476735795u, 1105282515u, 2474639360u, 1072692531u, 0u, 0, MODF_TOLERANCE, 0},
{ 939, 1050472772u, 1836216409u, 0u, 0u, 1050472772u, 1836216409u, 0, MODF_TOLERANCE, 0},
{ 940, 1101062307u, 2519592554u, 1101062307u, 2516582400u, 1068955445u, 0u, 0, MODF_TOLERANCE, 0},
{ 941, 1070178161u, 1235369496u, 0u, 0u, 1070178161u, 1235369496u, 0, MODF_TOLERANCE, 0},
{ 942, 3222946447u, 668087854u, 3222798336u, 0u, 3219264633u, 1049735536u, 0, MODF_TOLERANCE, 0},
{ 943, 3208554596u, 2981820811u, 2147483648u, 0u, 3208554596u, 2981820811u, 0, MODF_TOLERANCE, 0},
{ 944, 1059838516u, 2845580478u, 0u, 0u, 1059838516u, 2845580478u, 0, MODF_TOLERANCE, 0},
{ 945, 3193931414u, 1565550570u, 2147483648u, 0u, 3193931414u, 1565550570u, 0, MODF_TOLERANCE, 0},
{ 946, 3217165795u, 4162017137u, 2147483648u, 0u, 3217165795u, 4162017137u, 0, MODF_TOLERANCE, 0},
{ 947, 3237251378u, 2808968027u, 3237251376u, 0u, 3217374059u, 2597847040u, 0, MODF_TOLERANCE, 0},
{ 948, 1055630096u, 1782326814u, 0u, 0u, 1055630096u, 1782326814u, 0, MODF_TOLERANCE, 0},
{ 949, 1053576974u, 1492622658u, 0u, 0u, 1053576974u, 1492622658u, 0, MODF_TOLERANCE, 0},
{ 950, 3216653077u, 3972512122u, 2147483648u, 0u, 3216653077u, 3972512122u, 0, MODF_TOLERANCE, 0},
{ 951, 3222171679u, 2722693603u, 3221749760u, 0u, 3219767422u, 2300839820u, 0, MODF_TOLERANCE, 0},
{ 952, 3227814791u, 3169731970u, 3227811840u, 0u, 3218542457u, 3700098048u, 0, MODF_TOLERANCE, 0},
{ 953, 3217906631u, 899763203u, 2147483648u, 0u, 3217906631u, 899763203u, 0, MODF_TOLERANCE, 0},
{ 954, 3207606001u, 2804747833u, 2147483648u, 0u, 3207606001u, 2804747833u, 0, MODF_TOLERANCE, 0},
{ 955, 3230670325u, 3789058912u, 3230669824u, 0u, 3219086877u, 2268463104u, 0, MODF_TOLERANCE, 0},
{ 956, 3228095081u, 4135937628u, 3228090368u, 0u, 3219286518u, 2238077952u, 0, MODF_TOLERANCE, 0},
{ 957, 1060199382u, 1682808307u, 0u, 0u, 1060199382u, 1682808307u, 0, MODF_TOLERANCE, 0},
{ 958, 3206960335u, 232877759u, 2147483648u, 0u, 3206960335u, 232877759u, 0, MODF_TOLERANCE, 0},
{ 959, 3242091486u, 2851963139u, 3242091486u, 0u, 3219472304u, 543162368u, 0, MODF_TOLERANCE, 0},
{ 960, 3246852961u, 2590862592u, 3246852961u, 2550136832u, 3218303848u, 0u, 0, MODF_TOLERANCE, 0},
{ 961, 1081200406u, 2422232642u, 1081196544u, 0u, 1072573728u, 3232531456u, 0, MODF_TOLERANCE, 0},
{ 962, 3234779662u, 290458310u, 3234779648u, 0u, 3216777888u, 361496576u, 0, MODF_TOLERANCE, 0},
{ 963, 3210671078u, 1082582386u, 2147483648u, 0u, 3210671078u, 1082582386u, 0, MODF_TOLERANCE, 0},
{ 964, 1075605675u, 2602133689u, 1075576832u, 0u, 1069296358u, 3327798848u, 0, MODF_TOLERANCE, 0},
{ 965, 3239818611u, 1789635787u, 3239818608u, 0u, 3219871069u, 1717043200u, 0, MODF_TOLERANCE, 0},
{ 966, 1059414278u, 1048286093u, 0u, 0u, 1059414278u, 1048286093u, 0, MODF_TOLERANCE, 0},
{ 967, 1098330542u, 231339448u, 1098330542u, 0u, 1072403435u, 1879048192u, 0, MODF_TOLERANCE, 0},
{ 968, 1055573265u, 504907415u, 0u, 0u, 1055573265u, 504907415u, 0, MODF_TOLERANCE, 0},
{ 969, 1063211461u, 1153251200u, 0u, 0u, 1063211461u, 1153251200u, 0, MODF_TOLERANCE, 0},
{ 970, 3204617090u, 1772013857u, 2147483648u, 0u, 3204617090u, 1772013857u, 0, MODF_TOLERANCE, 0},
{ 971, 1099551055u, 1082898276u, 1099551055u, 1073741824u, 1068594924u, 2147483648u, 0, MODF_TOLERANCE, 0},
{ 972, 3212089272u, 1449080862u, 2147483648u, 0u, 3212089272u, 1449080862u, 0, MODF_TOLERANCE, 0},
{ 973, 1086008285u, 3177299045u, 1086008064u, 0u, 1072412588u, 931962880u, 0, MODF_TOLERANCE, 0},
{ 974, 1058862813u, 809400815u, 0u, 0u, 1058862813u, 809400815u, 0, MODF_TOLERANCE, 0},
{ 975, 3230854550u, 1924429710u, 3230854144u, 0u, 3218695979u, 1199104000u, 0, MODF_TOLERANCE, 0},
{ 976, 1056464743u, 3349283177u, 0u, 0u, 1056464743u, 3349283177u, 0, MODF_TOLERANCE, 0},
{ 977, 3245473391u, 42238036u, 3245473391u, 0u, 3217302530u, 2684354560u, 0, MODF_TOLERANCE, 0},
{ 978, 1042379500u, 2113559863u, 0u, 0u, 1042379500u, 2113559863u, 0, MODF_TOLERANCE, 0},
{ 979, 1064761243u, 3304403230u, 0u, 0u, 1064761243u, 3304403230u, 0, MODF_TOLERANCE, 0},
{ 980, 3217556703u, 58952646u, 2147483648u, 0u, 3217556703u, 58952646u, 0, MODF_TOLERANCE, 0},
{ 981, 3212669530u, 1645486982u, 2147483648u, 0u, 3212669530u, 1645486982u, 0, MODF_TOLERANCE, 0},
{ 982, 3224301095u, 3636267471u, 3224240128u, 0u, 3218982139u, 396442080u, 0, MODF_TOLERANCE, 0},
{ 983, 1062762009u, 619402181u, 0u, 0u, 1062762009u, 619402181u, 0, MODF_TOLERANCE, 0},
{ 984, 3235208235u, 557360557u, 3235208192u, 0u, 3219493020u, 1389789184u, 0, MODF_TOLERANCE, 0},
{ 985, 3238238394u, 110029735u, 3238238392u, 0u, 3218093175u, 1563951104u, 0, MODF_TOLERANCE, 0},
{ 986, 1046937383u, 984375729u, 0u, 0u, 1046937383u, 984375729u, 0, MODF_TOLERANCE, 0},
{ 987, 3189496738u, 4063688092u, 2147483648u, 0u, 3189496738u, 4063688092u, 0, MODF_TOLERANCE, 0},
{ 988, 3203235744u, 1049950343u, 2147483648u, 0u, 3203235744u, 1049950343u, 0, MODF_TOLERANCE, 0},
{ 989, 1062350619u, 650996069u, 0u, 0u, 1062350619u, 650996069u, 0, MODF_TOLERANCE, 0},
{ 990, 1054971928u, 3953359826u, 0u, 0u, 1054971928u, 3953359826u, 0, MODF_TOLERANCE, 0},
{ 991, 3227055805u, 66926332u, 3227041792u, 0u, 3219873409u, 4271603200u, 0, MODF_TOLERANCE, 0},
{ 992, 1090561839u, 1379780888u, 1090561832u, 0u, 1072515319u, 610271232u, 0, MODF_TOLERANCE, 0},
{ 993, 3233453307u, 2803378256u, 3233453056u, 0u, 3220141283u, 84541440u, 0, MODF_TOLERANCE, 0},
{ 994, 1086057989u, 498534626u, 1086057984u, 0u, 1066694364u, 596115456u, 0, MODF_TOLERANCE, 0},
{ 995, 1082618553u, 2846400785u, 1082617856u, 0u, 1070976333u, 1158187008u, 0, MODF_TOLERANCE, 0},
{ 996, 1047142525u, 1375153550u, 0u, 0u, 1047142525u, 1375153550u, 0, MODF_TOLERANCE, 0},
{ 997, 1044581201u, 2869128958u, 0u, 0u, 1044581201u, 2869128958u, 0, MODF_TOLERANCE, 0},
{ 998, 1070972315u, 4246440273u, 0u, 0u, 1070972315u, 4246440273u, 0, MODF_TOLERANCE, 0},
{ 999, 1051832506u, 3112381207u, 0u, 0u, 1051832506u, 3112381207u, 0, MODF_TOLERANCE, 0},


// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_MODF_H multiple inclusion protection

// EOF modf.h
