#ifndef CYGONCE_LIBM_TAN_H
#define CYGONCE_LIBM_TAN_H
//===========================================================================
//
//      tan.h
//
//      Test vectors for testing of tan() math library function
//
//===========================================================================
//####COPYRIGHTBEGIN####
//
// -------------------------------------------
// The contents of this file are subject to the Cygnus eCos Public License
// Version 1.0 (the "License"); you may not use this file except in
// compliance with the License.  You may obtain a copy of the License at
// http://sourceware.cygnus.com/ecos
// 
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the
// License for the specific language governing rights and limitations under
// the License.
// 
// The Original Code is eCos - Embedded Cygnus Operating System, released
// September 30, 1998.
// 
// The Initial Developer of the Original Code is Cygnus.  Portions created
// by Cygnus are Copyright (C) 1998 Cygnus Solutions.  All Rights Reserved.
// -------------------------------------------
//
//####COPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   jlarmour@cygnus.co.uk
// Contributors:  jlarmour@cygnus.co.uk
// Date:        1998-02-13
// Purpose:     
// Description: 
// Usage:       #include "vectors/tan.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support.h"// extra support for math tests

#define TAN_TOLERANCE 1.0E-04

static const Cyg_libm_test_double_vec_t tan_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{ 1, 1077999148u, 2506787616u, 1090024059u, 3619148316u, 3219622610u, 2608738099u, 0, TAN_TOLERANCE, 0},
{ 2, 3218153654u, 3176730980u, 1051524793u, 2993920299u, 3218181243u, 1709798879u, 0, TAN_TOLERANCE, 0},
{ 3, 3239659803u, 2725707538u, 3232101343u, 2346810316u, 3217920385u, 4213448196u, 0, TAN_TOLERANCE, 0},
{ 4, 1092554362u, 2088062470u, 3201242716u, 420891118u, 3219436383u, 1559440912u, 0, TAN_TOLERANCE, 0},
{ 5, 3221200677u, 2636405208u, 1100049309u, 471635570u, 1073914339u, 2222366620u, 0, TAN_TOLERANCE, 0},
{ 6, 1089363191u, 1746012320u, 1054478713u, 3333988501u, 3220605628u, 1031861671u, 0, TAN_TOLERANCE, 0},
{ 7, 1047953160u, 183014794u, 3202039382u, 2016785810u, 1047953160u, 183014809u, 0, TAN_TOLERANCE, 0},
{ 8, 3213486034u, 2688957927u, 1046089230u, 2709029994u, 3213486125u, 771400820u, 0, TAN_TOLERANCE, 0},
{ 9, 1058795730u, 624574473u, 1045840574u, 3473266330u, 1058795730u, 654356267u, 0, TAN_TOLERANCE, 0},
{ 10, 3204919842u, 1605286142u, 1068931671u, 4233776869u, 3204919842u, 1609546135u, 0, TAN_TOLERANCE, 0},
{ 11, 1060343410u, 1857607719u, 3222889559u, 3417070006u, 1060343410u, 2020998544u, 0, TAN_TOLERANCE, 0},
{ 12, 1103599987u, 3981151660u, 1088899021u, 1332651746u, 3221582538u, 16706636u, 0, TAN_TOLERANCE, 0},
{ 13, 1085298022u, 3824988054u, 1066856791u, 2070129652u, 3215830604u, 3502545545u, 0, TAN_TOLERANCE, 0},
{ 14, 3207559790u, 1372884064u, 1080833116u, 3229926662u, 3207559790u, 1543229406u, 0, TAN_TOLERANCE, 0},
{ 15, 1093826501u, 3217805330u, 3191644264u, 2014578707u, 3222635354u, 3054668406u, 0, TAN_TOLERANCE, 0},
{ 16, 1102287487u, 265058758u, 3239903247u, 1630600647u, 3214602649u, 265563968u, 0, TAN_TOLERANCE, 0},
{ 17, 1071124229u, 1946677669u, 3198462609u, 926009897u, 1071202952u, 1724614277u, 0, TAN_TOLERANCE, 0},
{ 18, 1072130299u, 2271884183u, 3203741999u, 2118617783u, 1072478793u, 3812297738u, 0, TAN_TOLERANCE, 0},
{ 19, 3194849109u, 213658772u, 3249401130u, 314151656u, 3194849109u, 213658780u, 0, TAN_TOLERANCE, 0},
{ 20, 3254112288u, 1564829925u, 3197817016u, 497230814u, 3219908120u, 4282371679u, 0, TAN_TOLERANCE, 0},
{ 21, 3216262634u, 2075329122u, 3231746400u, 169900577u, 3216265418u, 3766984913u, 0, TAN_TOLERANCE, 0},
{ 22, 1049848642u, 541549344u, 1096608669u, 3119070100u, 1049848642u, 541549497u, 0, TAN_TOLERANCE, 0},
{ 23, 1085427055u, 567496114u, 1045286891u, 1969998540u, 1074735168u, 195000017u, 0, TAN_TOLERANCE, 0},
{ 24, 1060548195u, 1299369769u, 1049342524u, 4167404066u, 1060548195u, 1554262199u, 0, TAN_TOLERANCE, 0},
{ 25, 3208865645u, 3348930841u, 1078472138u, 358457347u, 3208865645u, 3987332184u, 0, TAN_TOLERANCE, 0},
{ 26, 1071069297u, 2192461366u, 1099527247u, 3184735642u, 1071139786u, 997312598u, 0, TAN_TOLERANCE, 0},
{ 27, 1052861772u, 331696577u, 3189610016u, 793242270u, 1052861772u, 331703596u, 0, TAN_TOLERANCE, 0},
{ 28, 3252528934u, 2322696981u, 1083791358u, 3020766674u, 1071988465u, 2823307452u, 0, TAN_TOLERANCE, 0},
{ 29, 1044902177u, 252085215u, 3214426435u, 4139068910u, 1044902177u, 252085215u, 0, TAN_TOLERANCE, 0},
{ 30, 3222505725u, 105589263u, 1056316170u, 261630827u, 1075256347u, 888317792u, 0, TAN_TOLERANCE, 0},
{ 31, 1107213408u, 428765703u, 3251828686u, 2009972239u, 1072804855u, 3093920736u, 0, TAN_TOLERANCE, 0},
{ 32, 1098568019u, 3517376586u, 3240257920u, 3304487302u, 1073171249u, 1991641065u, 0, TAN_TOLERANCE, 0},
{ 33, 3233537912u, 237004814u, 3237899261u, 3364008659u, 3220482895u, 2812950573u, 0, TAN_TOLERANCE, 0},
{ 34, 3195247552u, 472004928u, 3226869477u, 1186387580u, 3195247552u, 472004938u, 0, TAN_TOLERANCE, 0},
{ 35, 1054226850u, 4085763910u, 1106394906u, 2684738273u, 1054226850u, 4085822461u, 0, TAN_TOLERANCE, 0},
{ 36, 1057053639u, 2055490142u, 3231581370u, 3879040079u, 1057053639u, 2057275463u, 0, TAN_TOLERANCE, 0},
{ 37, 3188976647u, 3725731239u, 1061652681u, 591292963u, 3188976647u, 3725731239u, 0, TAN_TOLERANCE, 0},
{ 38, 3225014981u, 1147041027u, 3215417793u, 624695933u, 3219812649u, 3561661677u, 0, TAN_TOLERANCE, 0},
{ 39, 3206052774u, 705725219u, 3238067573u, 1116238321u, 3206052774u, 725762224u, 0, TAN_TOLERANCE, 0},
{ 40, 3207367088u, 7287411u, 1045917232u, 116067742u, 3207367088u, 134216766u, 0, TAN_TOLERANCE, 0},
{ 41, 3240055222u, 3604989074u, 1066381836u, 545298780u, 1076058842u, 2692959828u, 0, TAN_TOLERANCE, 0},
{ 42, 3219080936u, 1681476121u, 1060345752u, 3553822398u, 3219194848u, 942221257u, 0, TAN_TOLERANCE, 0},
{ 43, 1102831658u, 3410480388u, 1052460275u, 1660607230u, 3214525015u, 4241725003u, 0, TAN_TOLERANCE, 0},
{ 44, 1089216869u, 1494984673u, 3196647153u, 287894723u, 1072160929u, 2549431126u, 0, TAN_TOLERANCE, 0},
{ 45, 1054885127u, 644548665u, 1081948134u, 2442134629u, 1054885127u, 644640539u, 0, TAN_TOLERANCE, 0},
{ 46, 1087554095u, 2312530895u, 3221584595u, 3379665576u, 1073452942u, 1180851169u, 0, TAN_TOLERANCE, 0},
{ 47, 1096085375u, 3018463866u, 1086226574u, 404012923u, 1068538907u, 1719554741u, 0, TAN_TOLERANCE, 0},
{ 48, 1064733299u, 1710279345u, 3251401196u, 3528946000u, 1064733314u, 1334898870u, 0, TAN_TOLERANCE, 0},
{ 49, 1061536351u, 2164450219u, 1083520023u, 3312018966u, 1061536351u, 3064676513u, 0, TAN_TOLERANCE, 0},
{ 50, 1057248676u, 2648986431u, 1050330591u, 1474376550u, 1057248676u, 2651856431u, 0, TAN_TOLERANCE, 0},
{ 51, 3194422028u, 1839068700u, 1077406406u, 3013052171u, 3194422028u, 1839068704u, 0, TAN_TOLERANCE, 0},
{ 52, 1046493630u, 772102380u, 3220729740u, 4219039958u, 1046493630u, 772102381u, 0, TAN_TOLERANCE, 0},
{ 53, 3229472221u, 3058618779u, 1046304788u, 3338676024u, 1069813597u, 724043670u, 0, TAN_TOLERANCE, 0},
{ 54, 1051172137u, 506286854u, 1094907481u, 2217000199u, 1051172137u, 506287951u, 0, TAN_TOLERANCE, 0},
{ 55, 1082428310u, 1147428263u, 1065432625u, 3034786717u, 1072851643u, 3329730330u, 0, TAN_TOLERANCE, 0},
{ 56, 1082016752u, 2844125311u, 1082985198u, 2561492677u, 1071527175u, 434342087u, 0, TAN_TOLERANCE, 0},
{ 57, 3211536916u, 704542600u, 3222902057u, 2762779203u, 3211536923u, 1874722944u, 0, TAN_TOLERANCE, 0},
{ 58, 3199680614u, 184131949u, 3249723525u, 1667366082u, 3199680614u, 184136139u, 0, TAN_TOLERANCE, 0},
{ 59, 3223609598u, 3904224140u, 1067056698u, 2942159914u, 3220091696u, 2663063840u, 0, TAN_TOLERANCE, 0},
{ 60, 1100636863u, 426114282u, 3209056785u, 1083606355u, 3220312233u, 624814402u, 0, TAN_TOLERANCE, 0},
{ 61, 1106165945u, 3774123863u, 1106787580u, 2722107965u, 1070796578u, 534470147u, 0, TAN_TOLERANCE, 0},
{ 62, 1088005092u, 1377734762u, 1104232051u, 2377063483u, 1074430559u, 547495352u, 0, TAN_TOLERANCE, 0},
{ 63, 1069380559u, 1029739074u, 1105467109u, 3062201018u, 1069389120u, 2814662813u, 0, TAN_TOLERANCE, 0},
{ 64, 3234741597u, 773857656u, 3214251949u, 335833884u, 3220624065u, 680339648u, 0, TAN_TOLERANCE, 0},
{ 65, 3203224610u, 1473865960u, 1103073830u, 4000427507u, 3203224610u, 1474404149u, 0, TAN_TOLERANCE, 0},
{ 66, 1103185231u, 4242092620u, 1067009473u, 14539161u, 3220426242u, 3000196541u, 0, TAN_TOLERANCE, 0},
{ 67, 3192516074u, 1732245037u, 1101371955u, 1533536108u, 3192516074u, 1732245037u, 0, TAN_TOLERANCE, 0},
{ 68, 3249153995u, 1833841275u, 1099430098u, 4144145552u, 3222141451u, 2395515507u, 0, TAN_TOLERANCE, 0},
{ 69, 3244270463u, 935007012u, 3188865420u, 604442938u, 1075422778u, 489932060u, 0, TAN_TOLERANCE, 0},
{ 70, 3206903253u, 2211464602u, 1046255144u, 1635910526u, 3206903253u, 2265441187u, 0, TAN_TOLERANCE, 0},
{ 71, 1077871417u, 2549219008u, 3231633258u, 3733639385u, 3218820973u, 826451768u, 0, TAN_TOLERANCE, 0},
{ 72, 1082095089u, 1819374372u, 3202219056u, 2617077637u, 1072422924u, 2528742585u, 0, TAN_TOLERANCE, 0},
{ 73, 1094345280u, 546465680u, 1048653554u, 532401530u, 3219190284u, 751670473u, 0, TAN_TOLERANCE, 0},
{ 74, 1044571091u, 2759019783u, 3221570188u, 3554409630u, 1044571091u, 2759019783u, 0, TAN_TOLERANCE, 0},
{ 75, 3212931282u, 2527221960u, 1099107978u, 2696971136u, 3212931310u, 944427847u, 0, TAN_TOLERANCE, 0},
{ 76, 1097158000u, 173134582u, 1087299442u, 2877794600u, 3221389719u, 1587380563u, 0, TAN_TOLERANCE, 0},
{ 77, 1086400474u, 547642046u, 3197285510u, 3521286127u, 3217586653u, 3675080684u, 0, TAN_TOLERANCE, 0},
{ 78, 1074860702u, 1231582831u, 1090971734u, 1653446832u, 1073794854u, 3729772102u, 0, TAN_TOLERANCE, 0},
{ 79, 1061342535u, 3762182190u, 3252967851u, 2615360375u, 1061342536u, 48009287u, 0, TAN_TOLERANCE, 0},
{ 80, 3200834423u, 2588067350u, 3206610957u, 3551059728u, 3200834423u, 2588087829u, 0, TAN_TOLERANCE, 0},
{ 81, 3206978856u, 845263327u, 1073415902u, 1749010288u, 3206978856u, 908420805u, 0, TAN_TOLERANCE, 0},
{ 82, 3205576370u, 3092685191u, 3190678390u, 2872219490u, 3205576370u, 3099649190u, 0, TAN_TOLERANCE, 0},
{ 83, 3218315055u, 4107255722u, 3205337291u, 3069068345u, 3218356717u, 3205080738u, 0, TAN_TOLERANCE, 0},
{ 84, 3243990857u, 2294867524u, 3216653996u, 2860384670u, 1075937062u, 441605080u, 0, TAN_TOLERANCE, 0},
{ 85, 3193326350u, 2265437201u, 3240198679u, 1234948614u, 3193326350u, 2265437202u, 0, TAN_TOLERANCE, 0},
{ 86, 3216359929u, 1186945904u, 3251167793u, 1896750851u, 3216363372u, 2480044998u, 0, TAN_TOLERANCE, 0},
{ 87, 1081575478u, 3686084548u, 1079286273u, 3309277689u, 3219165487u, 3935712921u, 0, TAN_TOLERANCE, 0},
{ 88, 3223476240u, 3006860614u, 3231412671u, 2504194724u, 1070630910u, 4230325485u, 0, TAN_TOLERANCE, 0},
{ 89, 3236149260u, 1948717780u, 1048317852u, 3791803982u, 1072688994u, 3729051438u, 0, TAN_TOLERANCE, 0},
{ 90, 1064345015u, 4272034420u, 3192982124u, 1526175922u, 1064345021u, 4158169529u, 0, TAN_TOLERANCE, 0},
{ 91, 3245817826u, 4108948538u, 1104691287u, 640541190u, 1074813212u, 3505437405u, 0, TAN_TOLERANCE, 0},
{ 92, 3207257417u, 3259274853u, 1082507103u, 3677038020u, 3207257417u, 3365158881u, 0, TAN_TOLERANCE, 0},
{ 93, 1083132498u, 3781708548u, 1096584871u, 1207386447u, 3220390531u, 2314747582u, 0, TAN_TOLERANCE, 0},
{ 94, 3188695272u, 3011191657u, 1103798670u, 1096124830u, 3188695272u, 3011191657u, 0, TAN_TOLERANCE, 0},
{ 95, 1063235023u, 2540404725u, 3240157452u, 4122845725u, 1063235026u, 767486541u, 0, TAN_TOLERANCE, 0},
{ 96, 1083643710u, 311336721u, 3214382367u, 4212533768u, 1074337179u, 3867090367u, 0, TAN_TOLERANCE, 0},
{ 97, 1051139427u, 1769686293u, 3240200923u, 3538602249u, 1051139427u, 1769687322u, 0, TAN_TOLERANCE, 0},
{ 98, 1078227549u, 508056696u, 1103793878u, 776520138u, 1068173843u, 4073142280u, 0, TAN_TOLERANCE, 0},
{ 99, 1102910577u, 4064962760u, 1077424413u, 819766631u, 1070476795u, 2500532800u, 0, TAN_TOLERANCE, 0},
{ 100, 1074178362u, 2112385259u, 3227593179u, 1187058516u, 3218369918u, 296208356u, 0, TAN_TOLERANCE, 0},
{ 101, 1082295059u, 2514398118u, 1076579751u, 870169764u, 3222557284u, 3821041880u, 0, TAN_TOLERANCE, 0},
{ 102, 3246851392u, 1190259653u, 1069112254u, 3417249840u, 1073944628u, 1508796918u, 0, TAN_TOLERANCE, 0},
{ 103, 3193663083u, 3467757357u, 3215075200u, 2168175352u, 3193663083u, 3467757359u, 0, TAN_TOLERANCE, 0},
{ 104, 3239643135u, 1508888184u, 1060430241u, 3524949092u, 1073664477u, 2627356099u, 0, TAN_TOLERANCE, 0},
{ 105, 3197412883u, 166402802u, 3237198975u, 3572369260u, 3197412883u, 166402985u, 0, TAN_TOLERANCE, 0},
{ 106, 1081866822u, 2441536203u, 3202753937u, 3658194573u, 1077725529u, 4095469556u, 0, TAN_TOLERANCE, 0},
{ 107, 1062392908u, 2479742828u, 1062342831u, 4214154303u, 1062392909u, 518131303u, 0, TAN_TOLERANCE, 0},
{ 108, 1082396794u, 426896765u, 1066474375u, 2201754442u, 1073946989u, 1842153396u, 0, TAN_TOLERANCE, 0},
{ 109, 3195629021u, 2055773734u, 3239267288u, 291396537u, 3195629021u, 2055773755u, 0, TAN_TOLERANCE, 0},
{ 110, 3236968033u, 874125203u, 3210508124u, 4091098764u, 1072994339u, 2120920512u, 0, TAN_TOLERANCE, 0},
{ 111, 1065716026u, 120488169u, 3241241441u, 1985269424u, 1065716078u, 229684732u, 0, TAN_TOLERANCE, 0},
{ 112, 3206539410u, 2243036871u, 3243941101u, 740033495u, 3206539410u, 2287393372u, 0, TAN_TOLERANCE, 0},
{ 113, 3209424906u, 1176656356u, 1074261978u, 3588756231u, 3209424906u, 3082067610u, 0, TAN_TOLERANCE, 0},
{ 114, 3252816791u, 3037249392u, 1061635587u, 1173102190u, 3220656564u, 3604743680u, 0, TAN_TOLERANCE, 0},
{ 115, 3237209581u, 2882725208u, 1071440059u, 69225090u, 3219270037u, 1144805256u, 0, TAN_TOLERANCE, 0},
{ 116, 3212663474u, 272319256u, 1072073912u, 2493997123u, 3212663506u, 4289517860u, 0, TAN_TOLERANCE, 0},
{ 117, 1057720186u, 188610379u, 3232757923u, 2209647371u, 1057720186u, 195731687u, 0, TAN_TOLERANCE, 0},
{ 118, 3236758517u, 1990439193u, 1078073146u, 622849962u, 3219034996u, 3232269414u, 0, TAN_TOLERANCE, 0},
{ 119, 1057135741u, 756052458u, 1081649113u, 2247475162u, 1057135741u, 758252889u, 0, TAN_TOLERANCE, 0},
{ 120, 1061623064u, 3878055211u, 3222407050u, 2979438623u, 1061623065u, 657726119u, 0, TAN_TOLERANCE, 0},
{ 121, 3195290997u, 2676398686u, 1105124431u, 3631096636u, 3195290997u, 2676398697u, 0, TAN_TOLERANCE, 0},
{ 122, 1065079390u, 1697791764u, 3198136112u, 2299842819u, 1065079418u, 1875760833u, 0, TAN_TOLERANCE, 0},
{ 123, 1078084768u, 1931502677u, 3215264397u, 3016456382u, 3221390371u, 1549517714u, 0, TAN_TOLERANCE, 0},
{ 124, 1072253426u, 343404215u, 1061072607u, 4266232536u, 1072703528u, 4239724827u, 0, TAN_TOLERANCE, 0},
{ 125, 3241230836u, 4140316002u, 1082896196u, 868256971u, 1077239637u, 3288074299u, 0, TAN_TOLERANCE, 0},
{ 126, 1075422810u, 1864139509u, 3187675097u, 3084482407u, 1069589412u, 935845071u, 0, TAN_TOLERANCE, 0},
{ 127, 3220191323u, 2427162817u, 3234748208u, 2715105792u, 3220811887u, 3230843823u, 0, TAN_TOLERANCE, 0},
{ 128, 1064600512u, 3943389284u, 1046724025u, 3626825684u, 1064600524u, 686990573u, 0, TAN_TOLERANCE, 0},
{ 129, 1045423002u, 967350972u, 1093012318u, 448002663u, 1045423002u, 967350973u, 0, TAN_TOLERANCE, 0},
{ 130, 3251845859u, 105058217u, 1069733884u, 171786224u, 3221748718u, 3998156706u, 0, TAN_TOLERANCE, 0},
{ 131, 3189614508u, 2863482262u, 3204997271u, 877784425u, 3189614508u, 2863482262u, 0, TAN_TOLERANCE, 0},
{ 132, 3202629313u, 2801782962u, 3213604117u, 762347195u, 3202629313u, 2801959982u, 0, TAN_TOLERANCE, 0},
{ 133, 3233486727u, 2317950339u, 3246333414u, 2135700283u, 1073741711u, 1100714238u, 0, TAN_TOLERANCE, 0},
{ 134, 1056516397u, 4171919805u, 1082858682u, 2180920863u, 1056516397u, 4173279042u, 0, TAN_TOLERANCE, 0},
{ 135, 3220149084u, 1918836931u, 1083603224u, 3137821660u, 3220714707u, 436652046u, 0, TAN_TOLERANCE, 0},
{ 136, 1103902874u, 3456203663u, 3235600523u, 2335688936u, 1070111728u, 3070150721u, 0, TAN_TOLERANCE, 0},
{ 137, 1042279322u, 4170235262u, 1051824459u, 521583737u, 1042279322u, 4170235262u, 0, TAN_TOLERANCE, 0},
{ 138, 1081348303u, 1296623194u, 3250673860u, 2442872540u, 1072056099u, 878147212u, 0, TAN_TOLERANCE, 0},
{ 139, 1061684277u, 289979405u, 1049514449u, 3865737145u, 1061684277u, 1500422480u, 0, TAN_TOLERANCE, 0},
{ 140, 1075298944u, 3699090239u, 1054539840u, 3259249360u, 3218530158u, 2204023492u, 0, TAN_TOLERANCE, 0},
{ 141, 1096418100u, 1619819023u, 1045993352u, 1022642459u, 1072486591u, 200878280u, 0, TAN_TOLERANCE, 0},
{ 142, 1081433004u, 19455098u, 3229182089u, 2096003654u, 3219860921u, 2802078233u, 0, TAN_TOLERANCE, 0},
{ 143, 1076297936u, 3803689997u, 1071630912u, 2263729518u, 3221020563u, 3741955633u, 0, TAN_TOLERANCE, 0},
{ 144, 1101357261u, 2816837387u, 1063422305u, 2597606398u, 3225913854u, 4017082295u, 0, TAN_TOLERANCE, 0},
{ 145, 1069100169u, 3680967506u, 1040201163u, 179224723u, 1069105508u, 1440893395u, 0, TAN_TOLERANCE, 0},
{ 146, 3188629767u, 978126928u, 1101553990u, 4047893399u, 3188629767u, 978126928u, 0, TAN_TOLERANCE, 0},
{ 147, 3222322045u, 4059818629u, 1042678728u, 3640293589u, 3220920863u, 1658556398u, 0, TAN_TOLERANCE, 0},
{ 148, 3248464040u, 3383497159u, 1070002807u, 1527313008u, 3218096293u, 3040100589u, 0, TAN_TOLERANCE, 0},
{ 149, 3202707679u, 2599946514u, 1104170406u, 2738675352u, 3202707679u, 2600156789u, 0, TAN_TOLERANCE, 0},
{ 150, 1105232623u, 3616571377u, 1060859316u, 1130603218u, 1072709115u, 3670033279u, 0, TAN_TOLERANCE, 0},
{ 151, 1076028796u, 3859211180u, 1067940450u, 1744531824u, 1066926573u, 3567718329u, 0, TAN_TOLERANCE, 0},
{ 152, 1042831340u, 1958025850u, 3236511256u, 2472176453u, 1042831340u, 1958025850u, 0, TAN_TOLERANCE, 0},
{ 153, 3233107089u, 182132862u, 3250520938u, 3924356991u, 1074211406u, 1409850566u, 0, TAN_TOLERANCE, 0},
{ 154, 3230501884u, 35632886u, 3209806504u, 1453402523u, 1069496128u, 1029233379u, 0, TAN_TOLERANCE, 0},
{ 155, 1083522102u, 743225214u, 3202890678u, 142917400u, 3221790920u, 331029792u, 0, TAN_TOLERANCE, 0},
{ 156, 1080684976u, 1472665012u, 3203138231u, 256588219u, 1070266411u, 390048846u, 0, TAN_TOLERANCE, 0},
{ 157, 1094982162u, 1062927000u, 1061134072u, 931677439u, 1072398089u, 826365235u, 0, TAN_TOLERANCE, 0},
{ 158, 1058377732u, 2320910576u, 1055663370u, 288059864u, 1058377732u, 2334598583u, 0, TAN_TOLERANCE, 0},
{ 159, 1078958093u, 1448349062u, 3199478070u, 3454027134u, 1071107400u, 206034543u, 0, TAN_TOLERANCE, 0},
{ 160, 3237458798u, 4215445172u, 3196654963u, 2231888973u, 3219458995u, 3819290632u, 0, TAN_TOLERANCE, 0},
{ 161, 3246632231u, 40413554u, 3232578253u, 983832844u, 3220432216u, 2842337330u, 0, TAN_TOLERANCE, 0},
{ 162, 3223721534u, 3995725873u, 1050082319u, 777231627u, 1077206840u, 461276196u, 0, TAN_TOLERANCE, 0},
{ 163, 1040986626u, 672789828u, 3253385962u, 2982787335u, 1040986626u, 672789828u, 0, TAN_TOLERANCE, 0},
{ 164, 1068390875u, 2075971825u, 1070166500u, 4034633931u, 1068393208u, 2863853979u, 0, TAN_TOLERANCE, 0},
{ 165, 3210046177u, 1018222907u, 3244621407u, 3090050495u, 3210046178u, 157136623u, 0, TAN_TOLERANCE, 0},
{ 166, 1067680885u, 937732557u, 3200798890u, 2557898276u, 1067681505u, 608928501u, 0, TAN_TOLERANCE, 0},
{ 167, 1078342316u, 130346162u, 3223590310u, 275568693u, 1071388364u, 1761655737u, 0, TAN_TOLERANCE, 0},
{ 168, 1042898869u, 3807416441u, 1075961161u, 3706820266u, 1042898869u, 3807416441u, 0, TAN_TOLERANCE, 0},
{ 169, 3216099005u, 1710131411u, 1078123323u, 1900790503u, 3216100881u, 1904744752u, 0, TAN_TOLERANCE, 0},
{ 170, 3238819361u, 3420420033u, 3210844787u, 588423066u, 1070338117u, 444441192u, 0, TAN_TOLERANCE, 0},
{ 171, 1049684114u, 1160162008u, 3246307879u, 4265764460u, 1049684114u, 1160162109u, 0, TAN_TOLERANCE, 0},
{ 172, 1102543434u, 366653268u, 3188814424u, 466059202u, 3219690076u, 1152439596u, 0, TAN_TOLERANCE, 0},
{ 173, 3226627739u, 1325936170u, 3221436876u, 680097612u, 3223591027u, 807326226u, 0, TAN_TOLERANCE, 0},
{ 174, 3240391116u, 1827735934u, 3200554324u, 2875599271u, 3218949458u, 1564630365u, 0, TAN_TOLERANCE, 0},
{ 175, 3191030402u, 3117037091u, 3239246636u, 15838845u, 3191030402u, 3117037091u, 0, TAN_TOLERANCE, 0},
{ 176, 1051974004u, 749718883u, 3223587064u, 1523766569u, 1051974004u, 749721490u, 0, TAN_TOLERANCE, 0},
{ 177, 1044833651u, 1966536294u, 3250158026u, 699164258u, 1044833651u, 1966536294u, 0, TAN_TOLERANCE, 0},
{ 178, 1098048435u, 3759049394u, 1106085272u, 1183789499u, 1067725226u, 3300256125u, 0, TAN_TOLERANCE, 0},
{ 179, 1081201623u, 1970107747u, 1095245453u, 2308233883u, 3219656964u, 1762316068u, 0, TAN_TOLERANCE, 0},
{ 180, 1084756444u, 1491017852u, 1041444355u, 1723375725u, 3220665076u, 1131376736u, 0, TAN_TOLERANCE, 0},
{ 181, 3216630070u, 1141349287u, 1097465301u, 3403438584u, 3216635871u, 3114581228u, 0, TAN_TOLERANCE, 0},
{ 182, 3230571908u, 1711085243u, 3250239076u, 1377484108u, 1071707322u, 2074334604u, 0, TAN_TOLERANCE, 0},
{ 183, 1098385019u, 2880275004u, 1084039594u, 1611394950u, 1072183089u, 1081655096u, 0, TAN_TOLERANCE, 0},
{ 184, 3234221435u, 2626629370u, 1063771493u, 1499080813u, 1072448767u, 2519934791u, 0, TAN_TOLERANCE, 0},
{ 185, 1055231263u, 3936262414u, 1103919063u, 3175668759u, 1055231263u, 3936475953u, 0, TAN_TOLERANCE, 0},
{ 186, 3207981719u, 1270950554u, 3194616071u, 3680565379u, 3207981719u, 1500917084u, 0, TAN_TOLERANCE, 0},
{ 187, 3208148223u, 1066985223u, 3221613219u, 4089383168u, 3208148223u, 1386557653u, 0, TAN_TOLERANCE, 0},
{ 188, 3217058839u, 4017329311u, 3208334452u, 1667591498u, 3217064784u, 1269168733u, 0, TAN_TOLERANCE, 0},
{ 189, 1088164157u, 3154656624u, 1061894279u, 3886344038u, 3223527257u, 636902076u, 0, TAN_TOLERANCE, 0},
{ 190, 1050652945u, 977586119u, 3209762784u, 953839852u, 1050652945u, 977586782u, 0, TAN_TOLERANCE, 0},
{ 191, 1104965247u, 143071571u, 3206165386u, 913097445u, 1083267508u, 670608201u, 0, TAN_TOLERANCE, 0},
{ 192, 3190565456u, 1371169579u, 1057079837u, 2594818628u, 3190565456u, 1371169579u, 0, TAN_TOLERANCE, 0},
{ 193, 3251793336u, 2259342224u, 3217432469u, 1824221478u, 1074871369u, 1846053325u, 0, TAN_TOLERANCE, 0},
{ 194, 3246834775u, 1576604497u, 1079368611u, 185078728u, 3219323765u, 1214264042u, 0, TAN_TOLERANCE, 0},
{ 195, 3221679427u, 444800035u, 3243343143u, 1734989302u, 1070734297u, 3140344392u, 0, TAN_TOLERANCE, 0},
{ 196, 1072748883u, 130452005u, 1041548088u, 2158433515u, 1073485690u, 2052392104u, 0, TAN_TOLERANCE, 0},
{ 197, 3234695968u, 1941318385u, 1045807374u, 792193370u, 1071783226u, 3456402802u, 0, TAN_TOLERANCE, 0},
{ 198, 3238299666u, 1299392207u, 3212131720u, 3205732280u, 1070843456u, 2640216013u, 0, TAN_TOLERANCE, 0},
{ 199, 1098698804u, 3035093505u, 1052187689u, 3287702190u, 1072848938u, 3118895016u, 0, TAN_TOLERANCE, 0},
{ 200, 3246676260u, 2160225215u, 1102624859u, 836655570u, 3216151840u, 2826603821u, 0, TAN_TOLERANCE, 0},
{ 201, 1096723626u, 3360816360u, 3246176356u, 172860634u, 3223468834u, 2557955513u, 0, TAN_TOLERANCE, 0},
{ 202, 1070995788u, 146831910u, 1051558014u, 2340722078u, 1071056230u, 1074959791u, 0, TAN_TOLERANCE, 0},
{ 203, 3230416351u, 1603798153u, 3207725532u, 1099413093u, 1073450075u, 3789585571u, 0, TAN_TOLERANCE, 0},
{ 204, 3246678378u, 2429340443u, 3190303581u, 3223770005u, 3222436475u, 2331667549u, 0, TAN_TOLERANCE, 0},
{ 205, 1075882959u, 955542166u, 3230415151u, 275583938u, 3221134682u, 869863979u, 0, TAN_TOLERANCE, 0},
{ 206, 1092971882u, 513397822u, 1090646554u, 2089321329u, 3218476915u, 4064660800u, 0, TAN_TOLERANCE, 0},
{ 207, 3193169876u, 2782073372u, 1046063872u, 4023829068u, 3193169876u, 2782073373u, 0, TAN_TOLERANCE, 0},
{ 208, 1098564822u, 3242223094u, 3194111199u, 4264674108u, 3219655919u, 2882209966u, 0, TAN_TOLERANCE, 0},
{ 209, 3238510821u, 3506346169u, 1047020885u, 1742757458u, 1077178631u, 1129955170u, 0, TAN_TOLERANCE, 0},
{ 210, 3192664477u, 1265459564u, 3193450280u, 3650514880u, 3192664477u, 1265459564u, 0, TAN_TOLERANCE, 0},
{ 211, 1081755890u, 1525260440u, 3235452527u, 2612331392u, 3218875360u, 584541142u, 0, TAN_TOLERANCE, 0},
{ 212, 3248668920u, 1263613754u, 3219096387u, 635677201u, 3228095705u, 607239893u, 0, TAN_TOLERANCE, 0},
{ 213, 3206272087u, 4140947288u, 3200792376u, 2013265346u, 3206272087u, 4170374788u, 0, TAN_TOLERANCE, 0},
{ 214, 3249974392u, 1912759945u, 3237045253u, 1351396825u, 1073520127u, 4107509282u, 0, TAN_TOLERANCE, 0},
{ 215, 3248205162u, 1001433078u, 3206926643u, 2741676659u, 3223698549u, 697659170u, 0, TAN_TOLERANCE, 0},
{ 216, 1080923606u, 1088945233u, 1085095743u, 3986114865u, 1073528810u, 2355327902u, 0, TAN_TOLERANCE, 0},
{ 217, 3215734057u, 831239754u, 1099828675u, 3071308141u, 3215735929u, 3454732211u, 0, TAN_TOLERANCE, 0},
{ 218, 3225834497u, 3473592372u, 1102759382u, 1309576357u, 3219754946u, 1779658178u, 0, TAN_TOLERANCE, 0},
{ 219, 3251186706u, 2042340367u, 1091945628u, 2062772374u, 3221848449u, 173695336u, 0, TAN_TOLERANCE, 0},
{ 220, 3194765687u, 1840632537u, 1096533424u, 807510337u, 3194765687u, 1840632544u, 0, TAN_TOLERANCE, 0},
{ 221, 3231451722u, 144814872u, 3212698915u, 2282965697u, 3219929851u, 2085937887u, 0, TAN_TOLERANCE, 0},
{ 222, 1071236430u, 2552499583u, 3229111426u, 1470130815u, 1071334047u, 1224989201u, 0, TAN_TOLERANCE, 0},
{ 223, 3243093065u, 2858583811u, 1089760910u, 6360994u, 3222355264u, 4036068405u, 0, TAN_TOLERANCE, 0},
{ 224, 3198264929u, 1614537194u, 1075198900u, 4088705365u, 3198264929u, 1614537652u, 0, TAN_TOLERANCE, 0},
{ 225, 3250939070u, 3545570051u, 1065221325u, 1629217700u, 3218583691u, 3771335620u, 0, TAN_TOLERANCE, 0},
{ 226, 1072744324u, 1813392963u, 3235313361u, 3772501596u, 1073467220u, 1680674110u, 0, TAN_TOLERANCE, 0},
{ 227, 3196802686u, 2406734491u, 1042055360u, 89226663u, 3196802686u, 2406734597u, 0, TAN_TOLERANCE, 0},
{ 228, 3195751081u, 1618759139u, 3194723421u, 3888234802u, 3195751081u, 1618759165u, 0, TAN_TOLERANCE, 0},
{ 229, 1055357248u, 3590035633u, 3212424262u, 2892456615u, 1055357248u, 3590311564u, 0, TAN_TOLERANCE, 0},
{ 230, 3189943060u, 2431246964u, 3241512456u, 183850734u, 3189943060u, 2431246964u, 0, TAN_TOLERANCE, 0},
{ 231, 1089501101u, 3088319870u, 3211544311u, 862225364u, 1072870485u, 1064431288u, 0, TAN_TOLERANCE, 0},
{ 232, 3235294664u, 3495352775u, 1058576726u, 596957268u, 3219184426u, 1290282712u, 0, TAN_TOLERANCE, 0},
{ 233, 1046553348u, 1839214511u, 3205004060u, 1923240983u, 1046553348u, 1839214513u, 0, TAN_TOLERANCE, 0},
{ 234, 1058073864u, 739619702u, 3223356436u, 2689885273u, 1058073864u, 746240258u, 0, TAN_TOLERANCE, 0},
{ 235, 3200324971u, 2143376228u, 1098306332u, 3760236188u, 3200324971u, 2143382876u, 0, TAN_TOLERANCE, 0},
{ 236, 1074621795u, 671680995u, 1091262633u, 2315535361u, 1071844140u, 2465670249u, 0, TAN_TOLERANCE, 0},
{ 237, 3214165989u, 2493598049u, 3194927008u, 1689107592u, 3214166163u, 1695445981u, 0, TAN_TOLERANCE, 0},
{ 238, 3189989959u, 1578976988u, 1066368383u, 2117279163u, 3189989959u, 1578976988u, 0, TAN_TOLERANCE, 0},
{ 239, 3222988111u, 3425290087u, 1098487295u, 1263412017u, 3219009618u, 3104355163u, 0, TAN_TOLERANCE, 0},
{ 240, 3208432764u, 3635396812u, 1070999426u, 3965655689u, 3208432764u, 4157169065u, 0, TAN_TOLERANCE, 0},
{ 241, 1060196346u, 2183973116u, 1101098363u, 1118613350u, 1060196346u, 2297325783u, 0, TAN_TOLERANCE, 0},
{ 242, 3221946089u, 199516350u, 1078368488u, 164621458u, 3217972188u, 183700192u, 0, TAN_TOLERANCE, 0},
{ 243, 3187706018u, 3570940805u, 3230316437u, 3596080877u, 3187706018u, 3570940805u, 0, TAN_TOLERANCE, 0},
{ 244, 3208209565u, 980880313u, 1079833442u, 884465057u, 3208209565u, 1338566342u, 0, TAN_TOLERANCE, 0},
{ 245, 1099977124u, 2558179220u, 1052873711u, 1233598120u, 1073082635u, 1345485298u, 0, TAN_TOLERANCE, 0},
{ 246, 1047115221u, 1909994277u, 1085015978u, 2991527452u, 1047115221u, 1909994283u, 0, TAN_TOLERANCE, 0},
{ 247, 1060855260u, 1680290941u, 1074309900u, 2943870846u, 1060855260u, 2128028309u, 0, TAN_TOLERANCE, 0},
{ 248, 1059496132u, 1451927357u, 3228615456u, 1502585517u, 1059496132u, 1515203058u, 0, TAN_TOLERANCE, 0},
{ 249, 3236211951u, 751136990u, 3230392165u, 3493275472u, 3221130863u, 2790236806u, 0, TAN_TOLERANCE, 0},
{ 250, 1098365967u, 1209623292u, 3238056647u, 979495322u, 1071982382u, 3259751257u, 0, TAN_TOLERANCE, 0},
{ 251, 3250424296u, 1717672108u, 1048120593u, 531240316u, 3217734469u, 151298977u, 0, TAN_TOLERANCE, 0},
{ 252, 1054174923u, 3548721654u, 1086112947u, 3391817224u, 1054174923u, 3548774163u, 0, TAN_TOLERANCE, 0},
{ 253, 1077836851u, 2758195125u, 1100880260u, 2028440924u, 3220536570u, 2251016583u, 0, TAN_TOLERANCE, 0},
{ 254, 1084223893u, 2750123373u, 3232200256u, 1086294931u, 3220157217u, 2263350424u, 0, TAN_TOLERANCE, 0},
{ 255, 1043958672u, 2986160931u, 1076097908u, 2540046258u, 1043958672u, 2986160931u, 0, TAN_TOLERANCE, 0},
{ 256, 3235476602u, 451471221u, 1064816262u, 4187644495u, 3216848923u, 3904061022u, 0, TAN_TOLERANCE, 0},
{ 257, 1099460228u, 2439500162u, 1065280276u, 1979490284u, 3218731225u, 4259537411u, 0, TAN_TOLERANCE, 0},
{ 258, 1040415832u, 2283342035u, 1078398157u, 1345997553u, 1040415832u, 2283342035u, 0, TAN_TOLERANCE, 0},
{ 259, 3213249348u, 179066662u, 1103272172u, 1217337578u, 3213249405u, 3247146264u, 0, TAN_TOLERANCE, 0},
{ 260, 3211562377u, 3779303391u, 3210023352u, 3115946280u, 3211562385u, 1965050538u, 0, TAN_TOLERANCE, 0},
{ 261, 3192989874u, 286247089u, 1085153597u, 713645369u, 3192989874u, 286247089u, 0, TAN_TOLERANCE, 0},
{ 262, 1093670500u, 1468283899u, 1042831668u, 2022736418u, 3219948625u, 3229834879u, 0, TAN_TOLERANCE, 0},
{ 263, 1083139105u, 3305564080u, 1065483445u, 482392433u, 3220193301u, 2415443999u, 0, TAN_TOLERANCE, 0},
{ 264, 3201695807u, 2256346551u, 3222430705u, 2071674991u, 3201695807u, 2256403348u, 0, TAN_TOLERANCE, 0},
{ 265, 3204024695u, 2295269094u, 1084451053u, 2773103941u, 3204024695u, 2296690203u, 0, TAN_TOLERANCE, 0},
{ 266, 1078173946u, 1482721827u, 1092243422u, 3125409590u, 1079271541u, 3804204308u, 0, TAN_TOLERANCE, 0},
{ 267, 3221065973u, 1381740563u, 1071545057u, 2918235653u, 1074536667u, 3552963698u, 0, TAN_TOLERANCE, 0},
{ 268, 3238715972u, 1105857967u, 3241990046u, 2703723225u, 3219526778u, 759389017u, 0, TAN_TOLERANCE, 0},
{ 269, 1043015571u, 174689677u, 1079333374u, 3947057014u, 1043015571u, 174689677u, 0, TAN_TOLERANCE, 0},
{ 270, 1090461859u, 2023082423u, 3242081486u, 1169047927u, 3217503114u, 3764937440u, 0, TAN_TOLERANCE, 0},
{ 271, 1064525899u, 3742487766u, 1043425732u, 194972788u, 1064525909u, 1475115964u, 0, TAN_TOLERANCE, 0},
{ 272, 3213791827u, 2136071361u, 3211529757u, 993675115u, 3213791976u, 1407302382u, 0, TAN_TOLERANCE, 0},
{ 273, 3213663381u, 210772141u, 3241441539u, 580731413u, 3213663503u, 212614883u, 0, TAN_TOLERANCE, 0},
{ 274, 1093840413u, 1751560711u, 1074522705u, 180987057u, 3219848371u, 2705574052u, 0, TAN_TOLERANCE, 0},
{ 275, 1066754591u, 2552236599u, 1088658621u, 2112468655u, 1066754795u, 1399432567u, 0, TAN_TOLERANCE, 0},
{ 276, 3189290617u, 1578223762u, 3224596567u, 2456166162u, 3189290617u, 1578223762u, 0, TAN_TOLERANCE, 0},
{ 277, 1058506965u, 2110924310u, 1086207177u, 3161208323u, 1058506965u, 2128721607u, 0, TAN_TOLERANCE, 0},
{ 278, 3231863394u, 2352173188u, 1079361728u, 4070222179u, 3227740382u, 336535156u, 0, TAN_TOLERANCE, 0},
{ 279, 1101012904u, 2481562701u, 1090937016u, 3809489716u, 3217879385u, 3053665789u, 0, TAN_TOLERANCE, 0},
{ 280, 3197002651u, 330905705u, 1086260896u, 90264431u, 3197002651u, 330905851u, 0, TAN_TOLERANCE, 0},
{ 281, 1040729961u, 4162008079u, 3194387916u, 759522153u, 1040729961u, 4162008079u, 0, TAN_TOLERANCE, 0},
{ 282, 1081015037u, 1839697482u, 3216442625u, 2211508949u, 3218526105u, 3638731460u, 0, TAN_TOLERANCE, 0},
{ 283, 3249807211u, 3736863454u, 1063475914u, 3150741666u, 1072025981u, 971921172u, 0, TAN_TOLERANCE, 0},
{ 284, 1060785883u, 4200269406u, 3236646101u, 1061812176u, 1060785884u, 303065114u, 0, TAN_TOLERANCE, 0},
{ 285, 1080217979u, 106027290u, 3234978297u, 2245237549u, 3218102952u, 2504847414u, 0, TAN_TOLERANCE, 0},
{ 286, 3246984334u, 2132131375u, 3250483427u, 3449276437u, 1069760767u, 1782102314u, 0, TAN_TOLERANCE, 0},
{ 287, 1089388778u, 2334440944u, 1105423490u, 4004336184u, 1072291864u, 1404277520u, 0, TAN_TOLERANCE, 0},
{ 288, 3218772704u, 4090088208u, 1042030013u, 3898658299u, 3218880206u, 3413233725u, 0, TAN_TOLERANCE, 0},
{ 289, 3207908064u, 2272831437u, 3253082595u, 2639188641u, 3207908064u, 2469202778u, 0, TAN_TOLERANCE, 0},
{ 290, 1054766684u, 1856594168u, 3189515294u, 4101853676u, 1054766684u, 1856744929u, 0, TAN_TOLERANCE, 0},
{ 291, 1076012412u, 2211699255u, 3195060344u, 3865018604u, 3216643832u, 2588986406u, 0, TAN_TOLERANCE, 0},
{ 292, 3242767010u, 996259334u, 3241496889u, 3782673116u, 3218271270u, 734706536u, 0, TAN_TOLERANCE, 0},
{ 293, 1099130747u, 3840380763u, 1048674041u, 550040067u, 1073016227u, 1715888406u, 0, TAN_TOLERANCE, 0},
{ 294, 3251419593u, 95874100u, 3237232828u, 2645647822u, 1074518514u, 88770385u, 0, TAN_TOLERANCE, 0},
{ 295, 1043665640u, 3441419500u, 3252367038u, 876710419u, 1043665640u, 3441419500u, 0, TAN_TOLERANCE, 0},
{ 296, 3238593552u, 2560836004u, 3199616543u, 1180840586u, 3220307943u, 3656831580u, 0, TAN_TOLERANCE, 0},
{ 297, 3221602966u, 2218230392u, 3227485787u, 3947214579u, 1071428530u, 946243539u, 0, TAN_TOLERANCE, 0},
{ 298, 1079539654u, 1447312532u, 1081476588u, 780366847u, 1071693521u, 4116479669u, 0, TAN_TOLERANCE, 0},
{ 299, 1072569643u, 2842113832u, 3216156731u, 225159029u, 1073083620u, 4179140584u, 0, TAN_TOLERANCE, 0},
{ 300, 1098117193u, 1601981129u, 3234628869u, 2236538344u, 1070461966u, 3658006630u, 0, TAN_TOLERANCE, 0},
{ 301, 1085173524u, 2194185737u, 3242362684u, 87913366u, 3215054618u, 3308265431u, 0, TAN_TOLERANCE, 0},
{ 302, 3199083880u, 1346862963u, 1077836259u, 3604666660u, 3199083880u, 1346865246u, 0, TAN_TOLERANCE, 0},
{ 303, 3212255979u, 3115209742u, 1099332326u, 1325101950u, 3212255995u, 3657260390u, 0, TAN_TOLERANCE, 0},
{ 304, 3224546042u, 3889223100u, 1053247613u, 3371396923u, 1070039848u, 636984675u, 0, TAN_TOLERANCE, 0},
{ 305, 3220477868u, 4163120793u, 1075022670u, 1387631215u, 3221974641u, 4043171840u, 0, TAN_TOLERANCE, 0},
{ 306, 3205481779u, 1532426189u, 1063168268u, 3397022615u, 3205481779u, 1543371882u, 0, TAN_TOLERANCE, 0},
{ 307, 3201033321u, 89324166u, 1079206060u, 3429424710u, 3201033321u, 89353099u, 0, TAN_TOLERANCE, 0},
{ 308, 3192325102u, 747591401u, 1072238381u, 2803213904u, 3192325102u, 747591401u, 0, TAN_TOLERANCE, 0},
{ 309, 1091113780u, 271904221u, 1044258318u, 1858545114u, 1076116261u, 919587220u, 0, TAN_TOLERANCE, 0},
{ 310, 3228068914u, 314958082u, 3249912496u, 2966213175u, 3219521784u, 4007754846u, 0, TAN_TOLERANCE, 0},
{ 311, 3197179414u, 3119528953u, 3217179014u, 2908718240u, 3197179414u, 3119529057u, 0, TAN_TOLERANCE, 0},
{ 312, 3242467576u, 2018361566u, 1100926600u, 3985805054u, 1073825020u, 890088773u, 0, TAN_TOLERANCE, 0},
{ 313, 1070132580u, 409584884u, 3239758947u, 755795129u, 1070153550u, 1757091400u, 0, TAN_TOLERANCE, 0},
{ 314, 1075772446u, 1819156379u, 3251342302u, 2982669005u, 1076001886u, 3576153658u, 0, TAN_TOLERANCE, 0},
{ 315, 1101563433u, 2080534280u, 3188254060u, 449171797u, 3225174135u, 2677838542u, 0, TAN_TOLERANCE, 0},
{ 316, 1095956900u, 168744837u, 3214950009u, 1322217822u, 3220353572u, 894592656u, 0, TAN_TOLERANCE, 0},
{ 317, 3254226900u, 3250487255u, 1062120700u, 1876195180u, 3221399760u, 1926104126u, 0, TAN_TOLERANCE, 0},
{ 318, 3226343480u, 1336400247u, 1098057903u, 3314079581u, 3219222587u, 3150545361u, 0, TAN_TOLERANCE, 0},
{ 319, 3203678820u, 265025555u, 1063854282u, 3779482256u, 3203678820u, 265735124u, 0, TAN_TOLERANCE, 0},
{ 320, 1067300501u, 887044257u, 1054789618u, 2732056261u, 1067301047u, 3919915468u, 0, TAN_TOLERANCE, 0},
{ 321, 1050106742u, 4027115185u, 3191764868u, 2940199511u, 1050106742u, 4027115450u, 0, TAN_TOLERANCE, 0},
{ 322, 3202500155u, 2875684421u, 3227459837u, 2251967570u, 3202500155u, 2875814613u, 0, TAN_TOLERANCE, 0},
{ 323, 1063244412u, 284173546u, 3238823679u, 3557800647u, 1063244414u, 2957655509u, 0, TAN_TOLERANCE, 0},
{ 324, 1101458560u, 3147771266u, 3220110464u, 2933364246u, 1072229904u, 3258427445u, 0, TAN_TOLERANCE, 0},
{ 325, 1064853160u, 3366183281u, 3234870843u, 537442654u, 1064853179u, 2700966725u, 0, TAN_TOLERANCE, 0},
{ 326, 3244118788u, 2529029548u, 3249882819u, 3781513577u, 3222066350u, 1805132578u, 0, TAN_TOLERANCE, 0},
{ 327, 3213436354u, 1080845539u, 3206760016u, 911778687u, 3213436437u, 368321244u, 0, TAN_TOLERANCE, 0},
{ 328, 3191951036u, 469586759u, 1091830022u, 3080528840u, 3191951036u, 469586759u, 0, TAN_TOLERANCE, 0},
{ 329, 1080249104u, 2863108169u, 3225605506u, 2508274250u, 1071359258u, 3991537001u, 0, TAN_TOLERANCE, 0},
{ 330, 3210826984u, 4080017377u, 3206492941u, 1470284690u, 3210826986u, 2768909464u, 0, TAN_TOLERANCE, 0},
{ 331, 3207120390u, 3867917386u, 1102054928u, 3504746045u, 3207120390u, 3950952741u, 0, TAN_TOLERANCE, 0},
{ 332, 1064522279u, 2962134101u, 3244741577u, 3390537350u, 1064522289u, 347807104u, 0, TAN_TOLERANCE, 0},
{ 333, 1088201813u, 1702237980u, 1071598971u, 1102587474u, 3219437889u, 1844190515u, 0, TAN_TOLERANCE, 0},
{ 334, 3202970118u, 2180218657u, 3211592260u, 1206527853u, 3202970118u, 2180570126u, 0, TAN_TOLERANCE, 0},
{ 335, 3197084744u, 394130786u, 3242511482u, 2437699868u, 3197084744u, 394130951u, 0, TAN_TOLERANCE, 0},
{ 336, 1044237059u, 849581558u, 3252006507u, 2008614943u, 1044237059u, 849581558u, 0, TAN_TOLERANCE, 0},
{ 337, 3210140014u, 3128971673u, 3249137531u, 2773583059u, 3210140015u, 3003661168u, 0, TAN_TOLERANCE, 0},
{ 338, 1085029866u, 590727700u, 3248651761u, 2183878539u, 3220819737u, 141721044u, 0, TAN_TOLERANCE, 0},
{ 339, 1101098629u, 820687580u, 3208143496u, 1402434664u, 3218501871u, 3201848623u, 0, TAN_TOLERANCE, 0},
{ 340, 3252290835u, 1873709254u, 3245167989u, 44275991u, 1072391033u, 398964073u, 0, TAN_TOLERANCE, 0},
{ 341, 3189668753u, 1174874204u, 3208263730u, 2360372288u, 3189668753u, 1174874204u, 0, TAN_TOLERANCE, 0},
{ 342, 1103854676u, 937573440u, 3208953761u, 211240241u, 3220217779u, 1087740507u, 0, TAN_TOLERANCE, 0},
{ 343, 3243548934u, 2469774991u, 1043117070u, 3380071805u, 1072701508u, 2365704893u, 0, TAN_TOLERANCE, 0},
{ 344, 1058121042u, 442507560u, 3254252803u, 3257889649u, 1058121042u, 450009292u, 0, TAN_TOLERANCE, 0},
{ 345, 1068850520u, 1854921625u, 1049810168u, 2729627545u, 1068853780u, 531700973u, 0, TAN_TOLERANCE, 0},
{ 346, 3254712629u, 4001809575u, 3240128649u, 278261523u, 3219319223u, 2548086449u, 0, TAN_TOLERANCE, 0},
{ 347, 1087224694u, 1793907966u, 3238955714u, 398859249u, 3221668828u, 2845828017u, 0, TAN_TOLERANCE, 0},
{ 348, 3200952547u, 2511916952u, 3219195283u, 1697158299u, 3200952547u, 2511942216u, 0, TAN_TOLERANCE, 0},
{ 349, 1069985548u, 3230931724u, 3243897690u, 3508781585u, 1070001309u, 2120433746u, 0, TAN_TOLERANCE, 0},
{ 350, 1103847606u, 1674254897u, 1046547577u, 217148561u, 3219239077u, 1170656967u, 0, TAN_TOLERANCE, 0},
{ 351, 3211263954u, 3275604304u, 3194840159u, 2991205850u, 3211263959u, 1126519421u, 0, TAN_TOLERANCE, 0},
{ 352, 3195249375u, 3509997278u, 3248888030u, 3897986511u, 3195249375u, 3509997288u, 0, TAN_TOLERANCE, 0},
{ 353, 1047182435u, 2156824613u, 1042295665u, 1239257646u, 1047182435u, 2156824619u, 0, TAN_TOLERANCE, 0},
{ 354, 3213264085u, 1073153314u, 3250031627u, 2567234990u, 3213264144u, 3128333673u, 0, TAN_TOLERANCE, 0},
{ 355, 3190593412u, 4261696995u, 3197784432u, 323702024u, 3190593412u, 4261696995u, 0, TAN_TOLERANCE, 0},
{ 356, 3243690997u, 4075177615u, 3202791065u, 1919006082u, 3223031388u, 2896528219u, 0, TAN_TOLERANCE, 0},
{ 357, 3239270013u, 386429966u, 1086504491u, 3698826164u, 1076373957u, 4112820482u, 0, TAN_TOLERANCE, 0},
{ 358, 1078327190u, 1681986446u, 3194985869u, 3072950140u, 3215497965u, 2409206796u, 0, TAN_TOLERANCE, 0},
{ 359, 3217311933u, 3719038997u, 1055433962u, 3331415058u, 3217323174u, 2513459184u, 0, TAN_TOLERANCE, 0},
{ 360, 1060749713u, 2420250111u, 3238002206u, 1928661079u, 1060749713u, 2793500608u, 0, TAN_TOLERANCE, 0},
{ 361, 1081914210u, 3679866727u, 3227386672u, 1273835792u, 1071850648u, 1052972091u, 0, TAN_TOLERANCE, 0},
{ 362, 1041622738u, 2682092368u, 3234222284u, 1325425811u, 1041622738u, 2682092368u, 0, TAN_TOLERANCE, 0},
{ 363, 1056312613u, 4175172697u, 3208346191u, 2130706153u, 1056312613u, 4176087705u, 0, TAN_TOLERANCE, 0},
{ 364, 1092089624u, 1200784450u, 1083605096u, 1248595607u, 1071297510u, 2267447579u, 0, TAN_TOLERANCE, 0},
{ 365, 3213890863u, 1897285171u, 3251296075u, 944966123u, 3213890950u, 492091915u, 0, TAN_TOLERANCE, 0},
{ 366, 3241371250u, 2270747330u, 3230692631u, 422503284u, 1075781685u, 3800245394u, 0, TAN_TOLERANCE, 0},
{ 367, 1084120037u, 2857564741u, 1075647403u, 3308906709u, 1076086650u, 4264754170u, 0, TAN_TOLERANCE, 0},
{ 368, 3203475098u, 1380066948u, 3232612906u, 2613634294u, 3203475098u, 1380497446u, 0, TAN_TOLERANCE, 0},
{ 369, 1063890856u, 4022784584u, 1060483857u, 3264056381u, 1063890862u, 1946986717u, 0, TAN_TOLERANCE, 0},
{ 370, 1044637404u, 1778509100u, 3213146285u, 2665833973u, 1044637404u, 1778509100u, 0, TAN_TOLERANCE, 0},
{ 371, 3216727300u, 1859175955u, 1079949560u, 4258450607u, 3216734161u, 1076419177u, 0, TAN_TOLERANCE, 0},
{ 372, 1048277388u, 4128020197u, 1076266146u, 4122840980u, 1048277388u, 4128020224u, 0, TAN_TOLERANCE, 0},
{ 373, 3193183163u, 2454653987u, 3229487005u, 2977478685u, 3193183163u, 2454653988u, 0, TAN_TOLERANCE, 0},
{ 374, 3253556483u, 1355181872u, 1095308770u, 436846481u, 1070455744u, 2783739970u, 0, TAN_TOLERANCE, 0},
{ 375, 3246605302u, 2592856453u, 3247825559u, 3195234082u, 1072158682u, 4191053951u, 0, TAN_TOLERANCE, 0},
{ 376, 3222118023u, 3554670043u, 1091621009u, 3321236467u, 3219396934u, 1126482929u, 0, TAN_TOLERANCE, 0},
{ 377, 1069012833u, 1936670355u, 1095715713u, 2958468553u, 1069017366u, 1662345773u, 0, TAN_TOLERANCE, 0},
{ 378, 3192291109u, 2960339502u, 1098808013u, 1044068983u, 3192291109u, 2960339502u, 0, TAN_TOLERANCE, 0},
{ 379, 3196691185u, 4093388677u, 1095478112u, 1735930261u, 3196691185u, 4093388765u, 0, TAN_TOLERANCE, 0},
{ 380, 1091040302u, 1807398746u, 3195743135u, 4261616162u, 3218599037u, 2355104691u, 0, TAN_TOLERANCE, 0},
{ 381, 3209294194u, 3250576797u, 1059002384u, 3043079652u, 3209294195u, 481373147u, 0, TAN_TOLERANCE, 0},
{ 382, 1069207109u, 666051428u, 3208765404u, 1912684117u, 1069213557u, 3613017928u, 0, TAN_TOLERANCE, 0},
{ 383, 1103487420u, 1949030179u, 1096388934u, 896459246u, 3220083347u, 1401180812u, 0, TAN_TOLERANCE, 0},
{ 384, 1054300653u, 622499767u, 1066707637u, 1490260486u, 1054300653u, 622567676u, 0, TAN_TOLERANCE, 0},
{ 385, 1106688493u, 1490616165u, 3251242436u, 795675736u, 1071299621u, 1833357839u, 0, TAN_TOLERANCE, 0},
{ 386, 1080943896u, 3662877092u, 3234317146u, 3200513112u, 1071312158u, 2927807819u, 0, TAN_TOLERANCE, 0},
{ 387, 1084088786u, 1356101968u, 3236536816u, 3062844611u, 3220131839u, 1020215585u, 0, TAN_TOLERANCE, 0},
{ 388, 3219922640u, 2284484846u, 3219498359u, 3240896015u, 3220393550u, 2961364171u, 0, TAN_TOLERANCE, 0},
{ 389, 3235759689u, 494503287u, 1092811254u, 142673998u, 1066221278u, 644259700u, 0, TAN_TOLERANCE, 0},
{ 390, 3252125916u, 3394882641u, 3225306538u, 364852125u, 1072736225u, 2528701453u, 0, TAN_TOLERANCE, 0},
{ 391, 3225261763u, 193885269u, 1088149839u, 1359805831u, 3222178190u, 3117314156u, 0, TAN_TOLERANCE, 0},
{ 392, 3200484782u, 592580907u, 3199560872u, 3086438952u, 3200484782u, 592590827u, 0, TAN_TOLERANCE, 0},
{ 393, 1059518664u, 1778008540u, 1049064687u, 73581647u, 1059518664u, 1844212540u, 0, TAN_TOLERANCE, 0},
{ 394, 3246733598u, 233240285u, 1081923320u, 2710903921u, 1076444640u, 2943138915u, 0, TAN_TOLERANCE, 0},
{ 395, 1069513767u, 3719878805u, 1079866720u, 3615458228u, 1069524234u, 4006435562u, 0, TAN_TOLERANCE, 0},
{ 396, 3221194724u, 3647632375u, 3247225271u, 3839959621u, 1073933717u, 2553172396u, 0, TAN_TOLERANCE, 0},
{ 397, 1103401096u, 2232210456u, 3235434773u, 224271737u, 3219565171u, 2155865246u, 0, TAN_TOLERANCE, 0},
{ 398, 3193003684u, 2134662911u, 3190390590u, 4239009051u, 3193003684u, 2134662911u, 0, TAN_TOLERANCE, 0},
{ 399, 1080526145u, 2305279897u, 1077668039u, 1854523320u, 3218473959u, 1086770027u, 0, TAN_TOLERANCE, 0},
{ 400, 3219864259u, 538224650u, 3206153057u, 1379649610u, 3220324172u, 4086099737u, 0, TAN_TOLERANCE, 0},
{ 401, 3196410507u, 3683897920u, 3244167599u, 3647579469u, 3196410507u, 3683897971u, 0, TAN_TOLERANCE, 0},
{ 402, 1090280933u, 2694093608u, 1042775347u, 598406111u, 3223377708u, 629310991u, 0, TAN_TOLERANCE, 0},
{ 403, 3211635392u, 872706833u, 1084802480u, 2200602798u, 3211635400u, 3018747109u, 0, TAN_TOLERANCE, 0},
{ 404, 1042339597u, 904146293u, 1060867322u, 1729685598u, 1042339597u, 904146293u, 0, TAN_TOLERANCE, 0},
{ 405, 3195694970u, 1894173462u, 3232800651u, 191960416u, 3195694970u, 1894173486u, 0, TAN_TOLERANCE, 0},
{ 406, 1091225343u, 3521028551u, 1054522089u, 3287274359u, 1075379070u, 2589593036u, 0, TAN_TOLERANCE, 0},
{ 407, 1095386964u, 959640601u, 3201578263u, 4136915018u, 1071816287u, 2768052123u, 0, TAN_TOLERANCE, 0},
{ 408, 1064005451u, 1553716379u, 1106027987u, 984725765u, 1064005458u, 358714987u, 0, TAN_TOLERANCE, 0},
{ 409, 3238832641u, 2287646644u, 3240329321u, 2276183378u, 3220726984u, 1232223276u, 0, TAN_TOLERANCE, 0},
{ 410, 1068209174u, 3940225170u, 3199544434u, 997572161u, 1068210924u, 3866659980u, 0, TAN_TOLERANCE, 0},
{ 411, 3212768361u, 36116288u, 3206886566u, 4196602670u, 3212768399u, 2705633912u, 0, TAN_TOLERANCE, 0},
{ 412, 3241695853u, 3550227562u, 3207257983u, 2747744117u, 1068532712u, 2849678857u, 0, TAN_TOLERANCE, 0},
{ 413, 1104236126u, 507130047u, 1048359321u, 3229888373u, 1075934101u, 170837419u, 0, TAN_TOLERANCE, 0},
{ 414, 3222996778u, 2210969014u, 1081031001u, 1946786091u, 3219155104u, 2257647455u, 0, TAN_TOLERANCE, 0},
{ 415, 3236306990u, 4059150589u, 3189759234u, 1177045799u, 1072876040u, 2482392566u, 0, TAN_TOLERANCE, 0},
{ 416, 1093103612u, 2664812822u, 1050343198u, 2034180320u, 1075572080u, 1506141174u, 0, TAN_TOLERANCE, 0},
{ 417, 3213779117u, 1175750283u, 3235559706u, 1424491340u, 3213779263u, 1242749298u, 0, TAN_TOLERANCE, 0},
{ 418, 3213904193u, 1630036121u, 3231972785u, 3195479448u, 3213904283u, 1644097468u, 0, TAN_TOLERANCE, 0},
{ 419, 1090429875u, 2527029044u, 1046927050u, 4000723255u, 3221257439u, 2628398620u, 0, TAN_TOLERANCE, 0},
{ 420, 1085208677u, 3335703647u, 3237349676u, 3869440059u, 3219201429u, 3510636886u, 0, TAN_TOLERANCE, 0},
{ 421, 1091433848u, 3888398377u, 3196041693u, 1290567220u, 3221736636u, 3727668451u, 0, TAN_TOLERANCE, 0},
{ 422, 1066679070u, 3242451480u, 3248384948u, 707431021u, 1066679243u, 1240900922u, 0, TAN_TOLERANCE, 0},
{ 423, 1083230509u, 2739665123u, 1060777905u, 1733073225u, 3217080313u, 3809469110u, 0, TAN_TOLERANCE, 0},
{ 424, 1078517061u, 1297274853u, 3208848704u, 3341639139u, 3219327748u, 2265747130u, 0, TAN_TOLERANCE, 0},
{ 425, 1046570941u, 2228057309u, 1084318902u, 1317851136u, 1046570941u, 2228057311u, 0, TAN_TOLERANCE, 0},
{ 426, 1088255327u, 270039934u, 3241414679u, 3063626339u, 3216402439u, 1024991753u, 0, TAN_TOLERANCE, 0},
{ 427, 3219178350u, 83062251u, 3211262173u, 2659016437u, 3219291255u, 480675725u, 0, TAN_TOLERANCE, 0},
{ 428, 1095743886u, 3833539373u, 3206667189u, 1567476111u, 1072080952u, 3686857265u, 0, TAN_TOLERANCE, 0},
{ 429, 3205195072u, 2382776852u, 3249232579u, 1546622468u, 3205195072u, 2389794914u, 0, TAN_TOLERANCE, 0},
{ 430, 1085536439u, 1714300821u, 1104130938u, 4167591598u, 1074883815u, 2402017247u, 0, TAN_TOLERANCE, 0},
{ 431, 1051092760u, 2798720100u, 1086978789u, 449990704u, 1051092760u, 2798721037u, 0, TAN_TOLERANCE, 0},
{ 432, 3231198415u, 4039516226u, 3244344107u, 4272932619u, 3225414740u, 1989232767u, 0, TAN_TOLERANCE, 0},
{ 433, 3222708441u, 1683007544u, 1091105663u, 3805494321u, 1072112688u, 1057460259u, 0, TAN_TOLERANCE, 0},
{ 434, 3220852948u, 2072627412u, 1094383324u, 3394151662u, 1076559907u, 1870123512u, 0, TAN_TOLERANCE, 0},
{ 435, 3220570024u, 1120106427u, 3223631624u, 3404608264u, 3222546600u, 2319235113u, 0, TAN_TOLERANCE, 0},
{ 436, 1097859997u, 559918757u, 3205077053u, 908100198u, 1073861320u, 484074424u, 0, TAN_TOLERANCE, 0},
{ 437, 1042677918u, 2026673913u, 3244833635u, 2844573214u, 1042677918u, 2026673913u, 0, TAN_TOLERANCE, 0},
{ 438, 3254567259u, 3946837259u, 3234993796u, 3850406820u, 1071188185u, 191486672u, 0, TAN_TOLERANCE, 0},
{ 439, 1057479809u, 3139330994u, 1046133568u, 1539650690u, 1057479809u, 3143968281u, 0, TAN_TOLERANCE, 0},
{ 440, 3236705500u, 1554593884u, 3228899878u, 2813752562u, 1072433226u, 4063726012u, 0, TAN_TOLERANCE, 0},
{ 441, 1056505004u, 3804703138u, 1072931071u, 2053677923u, 1056505004u, 3806034394u, 0, TAN_TOLERANCE, 0},
{ 442, 3244864299u, 289355864u, 1078453818u, 2143066338u, 1071978047u, 2504678044u, 0, TAN_TOLERANCE, 0},
{ 443, 3203939880u, 2157691971u, 1106629150u, 110806409u, 3203939880u, 2158907786u, 0, TAN_TOLERANCE, 0},
{ 444, 1082157019u, 3570399481u, 1085637605u, 180265334u, 1071014074u, 1108110341u, 0, TAN_TOLERANCE, 0},
{ 445, 3200980182u, 558779875u, 3202046748u, 2338464653u, 3200980182u, 558806357u, 0, TAN_TOLERANCE, 0},
{ 446, 1045705464u, 1703969219u, 3229797258u, 1417521063u, 1045705464u, 1703969220u, 0, TAN_TOLERANCE, 0},
{ 447, 3237782261u, 3917440951u, 1051668894u, 3736066983u, 3220361662u, 3501153891u, 0, TAN_TOLERANCE, 0},
{ 448, 1064752080u, 3106613409u, 1066627453u, 2735392257u, 1064752096u, 910406802u, 0, TAN_TOLERANCE, 0},
{ 449, 1065665372u, 2229777605u, 1065061963u, 2405869925u, 1065665419u, 608228727u, 0, TAN_TOLERANCE, 0},
{ 450, 3239463229u, 3967957902u, 1057416138u, 3459188071u, 3219968678u, 452000557u, 0, TAN_TOLERANCE, 0},
{ 451, 1068639210u, 3699016825u, 3249713090u, 796144848u, 1068641204u, 2916876063u, 0, TAN_TOLERANCE, 0},
{ 452, 3228816396u, 3285165564u, 3211948811u, 401510871u, 1068004951u, 4119011697u, 0, TAN_TOLERANCE, 0},
{ 453, 1094257658u, 634857910u, 3199607513u, 914218057u, 3218354966u, 974404261u, 0, TAN_TOLERANCE, 0},
{ 454, 1083743336u, 2030735578u, 3233855943u, 965677531u, 1073910531u, 785127245u, 0, TAN_TOLERANCE, 0},
{ 455, 1079556815u, 3957229084u, 1051050470u, 3123776651u, 1077427671u, 2842011737u, 0, TAN_TOLERANCE, 0},
{ 456, 3221863333u, 162122081u, 3239376395u, 108064594u, 3216195190u, 870993357u, 0, TAN_TOLERANCE, 0},
{ 457, 3237271786u, 869031839u, 3225020876u, 1344301606u, 1073250300u, 2630856992u, 0, TAN_TOLERANCE, 0},
{ 458, 3214433474u, 946696117u, 3231825228u, 1700703647u, 3214433775u, 2279568879u, 0, TAN_TOLERANCE, 0},
{ 459, 1075492875u, 3394168074u, 1076939786u, 1666995668u, 1071303797u, 542229427u, 0, TAN_TOLERANCE, 0},
{ 460, 3208774795u, 2488789804u, 3238508333u, 1506943664u, 3208774795u, 2999907289u, 0, TAN_TOLERANCE, 0},
{ 461, 1072788663u, 3844072288u, 3202592279u, 2630019853u, 1073659779u, 84316650u, 0, TAN_TOLERANCE, 0},
{ 462, 3219934542u, 1244307192u, 3191297711u, 2540916692u, 3220408266u, 2332373750u, 0, TAN_TOLERANCE, 0},
{ 463, 3200062692u, 2871645739u, 3239081581u, 1440249115u, 3200062692u, 2871653937u, 0, TAN_TOLERANCE, 0},
{ 464, 1068350633u, 1231934926u, 3236746788u, 603977748u, 1068352827u, 2493929906u, 0, TAN_TOLERANCE, 0},
{ 465, 3195449689u, 2386312545u, 1063169277u, 2715234268u, 3195449689u, 2386312560u, 0, TAN_TOLERANCE, 0},
{ 466, 1087803418u, 915867083u, 1046790892u, 3347417612u, 1073825687u, 4247788838u, 0, TAN_TOLERANCE, 0},
{ 467, 1105984188u, 3553288373u, 1065698616u, 2906680663u, 1072200540u, 3878244721u, 0, TAN_TOLERANCE, 0},
{ 468, 1045506226u, 2342364630u, 1051356723u, 4019093203u, 1045506226u, 2342364630u, 0, TAN_TOLERANCE, 0},
{ 469, 3201169162u, 2911548084u, 1105282515u, 2476735795u, 3201169162u, 2911583958u, 0, TAN_TOLERANCE, 0},
{ 470, 1050472772u, 1836216409u, 1101062307u, 2519592554u, 1050472772u, 1836216914u, 0, TAN_TOLERANCE, 0},
{ 471, 1070178161u, 1235369496u, 3222946447u, 668087854u, 1070200956u, 984903311u, 0, TAN_TOLERANCE, 0},
{ 472, 3208554596u, 2981820811u, 1059838516u, 2845580478u, 3208554596u, 3611299598u, 0, TAN_TOLERANCE, 0},
{ 473, 3193931414u, 1565550570u, 3217165795u, 4162017137u, 3193931414u, 1565550573u, 0, TAN_TOLERANCE, 0},
{ 474, 3237251378u, 2808968027u, 1055630096u, 1782326814u, 1073199382u, 3093545191u, 0, TAN_TOLERANCE, 0},
{ 475, 1053576974u, 1492622658u, 3216653077u, 3972512122u, 1053576974u, 1492652906u, 0, TAN_TOLERANCE, 0},
{ 476, 3222171679u, 2722693603u, 3227814791u, 3169731970u, 3219717982u, 2347297495u, 0, TAN_TOLERANCE, 0},
{ 477, 3217906631u, 899763203u, 3207606001u, 2804747833u, 3217941096u, 1292535038u, 0, TAN_TOLERANCE, 0},
{ 478, 3230670325u, 3789058912u, 3228095081u, 4135937628u, 3220946737u, 3788028633u, 0, TAN_TOLERANCE, 0},
{ 479, 1060199382u, 1682808307u, 3206960335u, 232877759u, 1060199382u, 1797073325u, 0, TAN_TOLERANCE, 0},
{ 480, 3242091486u, 2851963139u, 3246852961u, 2590862592u, 1071899939u, 3363220171u, 0, TAN_TOLERANCE, 0},
{ 481, 1081200406u, 2422232642u, 3234779662u, 290458310u, 3220569877u, 2524572923u, 0, TAN_TOLERANCE, 0},
{ 482, 3210671078u, 1082582386u, 1075605675u, 2602133689u, 3210671080u, 2857813414u, 0, TAN_TOLERANCE, 0},
{ 483, 3239818611u, 1789635787u, 1059414278u, 1048286093u, 1074416318u, 2900047215u, 0, TAN_TOLERANCE, 0},
{ 484, 1098330542u, 231339448u, 1055573265u, 504907415u, 3215743938u, 3288233724u, 0, TAN_TOLERANCE, 0},
{ 485, 1063211461u, 1153251200u, 3204617090u, 1772013857u, 1063211463u, 3301239304u, 0, TAN_TOLERANCE, 0},
{ 486, 1099551055u, 1082898276u, 3212089272u, 1449080862u, 3218613781u, 3243588953u, 0, TAN_TOLERANCE, 0},
{ 487, 1086008285u, 3177299045u, 1058862813u, 809400815u, 1071222953u, 702551442u, 0, TAN_TOLERANCE, 0},
{ 488, 3230854550u, 1924429710u, 1056464743u, 3349283177u, 1074313482u, 3011874043u, 0, TAN_TOLERANCE, 0},
{ 489, 3245473391u, 42238036u, 1042379500u, 2113559863u, 1073052939u, 1170520627u, 0, TAN_TOLERANCE, 0},
{ 490, 1064761243u, 3304403230u, 3217556703u, 58952646u, 1064761259u, 2338066714u, 0, TAN_TOLERANCE, 0},
{ 491, 3212669530u, 1645486982u, 3224301095u, 3636267471u, 3212669563u, 2707928865u, 0, TAN_TOLERANCE, 0},
{ 492, 1062762009u, 619402181u, 3235208235u, 557360557u, 1062762010u, 1440296348u, 0, TAN_TOLERANCE, 0},
{ 493, 3238238394u, 110029735u, 1046937383u, 984375729u, 1069607562u, 1046851138u, 0, TAN_TOLERANCE, 0},
{ 494, 3189496738u, 4063688092u, 3203235744u, 1049950343u, 3189496738u, 4063688092u, 0, TAN_TOLERANCE, 0},
{ 495, 1062350619u, 650996069u, 1054971928u, 3953359826u, 1062350619u, 2752584734u, 0, TAN_TOLERANCE, 0},
{ 496, 3227055805u, 66926332u, 1090561839u, 1379780888u, 1072277043u, 4160526258u, 0, TAN_TOLERANCE, 0},
{ 497, 3233453307u, 2803378256u, 1086057989u, 498534626u, 3218298031u, 1208122603u, 0, TAN_TOLERANCE, 0},
{ 498, 1082618553u, 2846400785u, 1047142525u, 1375153550u, 3219225392u, 1107778179u, 0, TAN_TOLERANCE, 0},
{ 499, 1044581201u, 2869128958u, 1070972315u, 4246440273u, 1044581201u, 2869128958u, 0, TAN_TOLERANCE, 0},
{ 500, 1051832506u, 3112381207u, 1044430965u, 3981604561u, 1051832506u, 3112383052u, 0, TAN_TOLERANCE, 0},
{ 501, 3231254997u, 243303420u, 1093735824u, 1575581926u, 3218083448u, 3006576476u, 0, TAN_TOLERANCE, 0},
{ 502, 3239137997u, 3218865041u, 3204803496u, 3840388050u, 3218098013u, 2658530377u, 0, TAN_TOLERANCE, 0},
{ 503, 1048415431u, 336846959u, 1052664471u, 3798336786u, 1048415431u, 336846993u, 0, TAN_TOLERANCE, 0},
{ 504, 1055954236u, 3639240976u, 1081202165u, 1844741676u, 1055954236u, 3639630115u, 0, TAN_TOLERANCE, 0},
{ 505, 3211904793u, 717293069u, 3211534283u, 582401011u, 3211904800u, 2074293655u, 0, TAN_TOLERANCE, 0},
{ 506, 3251962512u, 3766248610u, 3196520332u, 1174437546u, 1073325344u, 780358362u, 0, TAN_TOLERANCE, 0},
{ 507, 1083431226u, 756959182u, 3204099341u, 1581804034u, 1073722216u, 1460652646u, 0, TAN_TOLERANCE, 0},
{ 508, 3205806444u, 3560686300u, 3220980617u, 4277975772u, 3205806444u, 3572839184u, 0, TAN_TOLERANCE, 0},
{ 509, 3209906076u, 2598148853u, 3217622194u, 3460421008u, 3209906077u, 808032968u, 0, TAN_TOLERANCE, 0},
{ 510, 1066720824u, 136600515u, 3209934920u, 3340653128u, 1066721013u, 1659952300u, 0, TAN_TOLERANCE, 0},
{ 511, 1096820310u, 1045480938u, 3251354609u, 4133432965u, 3221461219u, 2735258820u, 0, TAN_TOLERANCE, 0},
{ 512, 1091599431u, 1630207738u, 3239996829u, 2393354808u, 3219464252u, 498852281u, 0, TAN_TOLERANCE, 0},
{ 513, 3190626018u, 3739770117u, 1059520750u, 3959551225u, 3190626018u, 3739770117u, 0, TAN_TOLERANCE, 0},
{ 514, 3230730505u, 1498861716u, 1091297147u, 847410798u, 3217049269u, 1133813157u, 0, TAN_TOLERANCE, 0},
{ 515, 1073516688u, 983275314u, 3232538664u, 2244973629u, 3222428802u, 614562084u, 0, TAN_TOLERANCE, 0},
{ 516, 1054849265u, 2353103845u, 3235718771u, 2978889966u, 1054849265u, 2353274099u, 0, TAN_TOLERANCE, 0},
{ 517, 3251357992u, 1546972125u, 3249076079u, 1987349196u, 1077259194u, 2242398903u, 0, TAN_TOLERANCE, 0},
{ 518, 3238219513u, 2769161072u, 1075207126u, 292616282u, 1072821398u, 807086196u, 0, TAN_TOLERANCE, 0},
{ 519, 3199712298u, 36855311u, 1052128202u, 1479039342u, 3199712298u, 36859768u, 0, TAN_TOLERANCE, 0},
{ 520, 1083757053u, 2027463605u, 1066023013u, 3369686340u, 3221343255u, 19927100u, 0, TAN_TOLERANCE, 0},
{ 521, 3197852749u, 3808681655u, 1054161346u, 1821773119u, 3197852749u, 3808682082u, 0, TAN_TOLERANCE, 0},
{ 522, 1040685928u, 3175490326u, 3226879970u, 845687760u, 1040685928u, 3175490326u, 0, TAN_TOLERANCE, 0},
{ 523, 1042302993u, 3124482451u, 3242748377u, 3259417226u, 1042302993u, 3124482451u, 0, TAN_TOLERANCE, 0},
{ 524, 1045245695u, 2751606436u, 3236210939u, 3923142740u, 1045245695u, 2751606437u, 0, TAN_TOLERANCE, 0},
{ 525, 1095694737u, 2016872044u, 3228408064u, 4201274408u, 3220556003u, 304657644u, 0, TAN_TOLERANCE, 0},
{ 526, 3199349254u, 1019916843u, 3219974785u, 1977881787u, 3199349254u, 1019918851u, 0, TAN_TOLERANCE, 0},
{ 527, 3199478752u, 2060433318u, 1075872515u, 366073725u, 3199478752u, 2060436054u, 0, TAN_TOLERANCE, 0},
{ 528, 3191180557u, 1098469906u, 1082900695u, 2349346832u, 3191180557u, 1098469906u, 0, TAN_TOLERANCE, 0},
{ 529, 3209974707u, 3011196295u, 3252479932u, 2459281672u, 3209974708u, 1651824903u, 0, TAN_TOLERANCE, 0},
{ 530, 3221334323u, 2843222682u, 1089275809u, 298982001u, 1073062403u, 2209304510u, 0, TAN_TOLERANCE, 0},
{ 531, 1101737698u, 914741728u, 3203468059u, 2833809843u, 1073172513u, 3841288246u, 0, TAN_TOLERANCE, 0},
{ 532, 3236763878u, 1274901962u, 3241535845u, 3759113509u, 3223536244u, 2526279170u, 0, TAN_TOLERANCE, 0},
{ 533, 3245916442u, 2134927252u, 3253802671u, 3013731444u, 3221779667u, 2145793921u, 0, TAN_TOLERANCE, 0},
{ 534, 1099201341u, 2230655177u, 3254510616u, 1249674366u, 1069935420u, 2610885886u, 0, TAN_TOLERANCE, 0},
{ 535, 1062971253u, 717357389u, 1083533731u, 3746683362u, 1062971254u, 3814343624u, 0, TAN_TOLERANCE, 0},
{ 536, 3213773114u, 834976849u, 3217357661u, 2465861779u, 3213773258u, 3835570390u, 0, TAN_TOLERANCE, 0},
{ 537, 1045656117u, 1385714428u, 1053358395u, 3007113740u, 1045656117u, 1385714429u, 0, TAN_TOLERANCE, 0},
{ 538, 1050527919u, 599268545u, 3201368210u, 2309854744u, 1050527919u, 599269095u, 0, TAN_TOLERANCE, 0},
{ 539, 1069954454u, 2840234388u, 3232496515u, 333365983u, 1069969239u, 824923776u, 0, TAN_TOLERANCE, 0},
{ 540, 1045922781u, 3136078996u, 3194520860u, 2650572904u, 1045922781u, 3136078997u, 0, TAN_TOLERANCE, 0},
{ 541, 3233687691u, 2405805086u, 3251640319u, 324233833u, 1076400826u, 1695372281u, 0, TAN_TOLERANCE, 0},
{ 542, 1106699146u, 2589598340u, 3254677807u, 952438812u, 1073169861u, 1925719938u, 0, TAN_TOLERANCE, 0},
{ 543, 3189114773u, 1922837702u, 3216892718u, 3535907549u, 3189114773u, 1922837702u, 0, TAN_TOLERANCE, 0},
{ 544, 3243615868u, 261447440u, 3209805849u, 1150571079u, 3218537959u, 1179754495u, 0, TAN_TOLERANCE, 0},
{ 545, 1095805232u, 4026487528u, 1073152064u, 27340691u, 1071869216u, 2196895529u, 0, TAN_TOLERANCE, 0},
{ 546, 3229123692u, 338765118u, 1086225786u, 3207238249u, 1071434156u, 2463812124u, 0, TAN_TOLERANCE, 0},
{ 547, 3196182703u, 1085283176u, 3187775111u, 1601194210u, 3196182703u, 1085283206u, 0, TAN_TOLERANCE, 0},
{ 548, 1091520173u, 3031712790u, 3252307859u, 170666844u, 1073788586u, 1490989523u, 0, TAN_TOLERANCE, 0},
{ 549, 3218862231u, 3148395674u, 1041913758u, 3306391490u, 3218988164u, 3732649501u, 0, TAN_TOLERANCE, 0},
{ 550, 3201277070u, 2205233857u, 3208100078u, 3993195511u, 3201277070u, 2205275976u, 0, TAN_TOLERANCE, 0},
{ 551, 1067699608u, 4282766727u, 1072820377u, 1874778218u, 1067700256u, 2388367432u, 0, TAN_TOLERANCE, 0},
{ 552, 3210833092u, 2920860798u, 3218070226u, 3104066154u, 3210833094u, 1727805504u, 0, TAN_TOLERANCE, 0},
{ 553, 3204950351u, 969991373u, 3250596895u, 1734386152u, 3204950351u, 974513035u, 0, TAN_TOLERANCE, 0},
{ 554, 3238915818u, 1218740205u, 3239802737u, 2610078504u, 1071992715u, 2476766203u, 0, TAN_TOLERANCE, 0},
{ 555, 3206031242u, 1485218325u, 3220870240u, 3591664613u, 3206031242u, 1504459448u, 0, TAN_TOLERANCE, 0},
{ 556, 3202074143u, 690157417u, 3190850619u, 4192347699u, 3202074143u, 690271681u, 0, TAN_TOLERANCE, 0},
{ 557, 1096053810u, 4009839784u, 1079670252u, 394167192u, 3225629605u, 4134812175u, 0, TAN_TOLERANCE, 0},
{ 558, 3234559237u, 961532417u, 1092588071u, 2923790239u, 1071989085u, 3456632070u, 0, TAN_TOLERANCE, 0},
{ 559, 3203879091u, 4174125604u, 1050682630u, 2169701868u, 3203879091u, 4175207134u, 0, TAN_TOLERANCE, 0},
{ 560, 3243092475u, 4146748230u, 1087373950u, 2481478351u, 3215224829u, 3105536152u, 0, TAN_TOLERANCE, 0},
{ 561, 1076987866u, 3984715440u, 1050421618u, 2446142566u, 3222213811u, 498812384u, 0, TAN_TOLERANCE, 0},
{ 562, 1084172406u, 936290150u, 1100614426u, 3625806370u, 3220199128u, 1358638649u, 0, TAN_TOLERANCE, 0},
{ 563, 1099787952u, 1866615265u, 3215651428u, 2337013350u, 3219914131u, 2684128678u, 0, TAN_TOLERANCE, 0},
{ 564, 3253198302u, 712227971u, 1106004723u, 973148499u, 3218269318u, 3721193253u, 0, TAN_TOLERANCE, 0},
{ 565, 3230088199u, 3409813738u, 3244817008u, 1933503498u, 1073488242u, 3344297858u, 0, TAN_TOLERANCE, 0},
{ 566, 1079943733u, 3180389060u, 3228735703u, 83422217u, 1065971249u, 1602512451u, 0, TAN_TOLERANCE, 0},
{ 567, 1077878724u, 556972671u, 3204582372u, 841555801u, 3218291211u, 3107455312u, 0, TAN_TOLERANCE, 0},
{ 568, 1070767721u, 4189151332u, 1080874032u, 706326922u, 1070803352u, 407939685u, 0, TAN_TOLERANCE, 0},
{ 569, 1096151307u, 198291836u, 1057281892u, 2188836928u, 1074592119u, 2450977568u, 0, TAN_TOLERANCE, 0},
{ 570, 1078091995u, 1219449298u, 3228734687u, 3504562743u, 3220571385u, 559673929u, 0, TAN_TOLERANCE, 0},
{ 571, 3204570464u, 1776099219u, 1094316777u, 4188083896u, 3204570464u, 1778045339u, 0, TAN_TOLERANCE, 0},
{ 572, 3193845708u, 2614400266u, 1073750227u, 3003203347u, 3193845708u, 2614400268u, 0, TAN_TOLERANCE, 0},
{ 573, 3213982678u, 2959351406u, 1105603716u, 311851587u, 3213982790u, 192456605u, 0, TAN_TOLERANCE, 0},
{ 574, 1084544434u, 865443613u, 1097532516u, 3622237781u, 3218629642u, 1586071075u, 0, TAN_TOLERANCE, 0},
{ 575, 3231786666u, 447506102u, 3195759295u, 3603669725u, 1072160877u, 4222169442u, 0, TAN_TOLERANCE, 0},
{ 576, 1097890173u, 3934398273u, 1040996422u, 2968621268u, 1076341208u, 2443582384u, 0, TAN_TOLERANCE, 0},
{ 577, 3196739825u, 784208771u, 1088764788u, 2182296421u, 3196739825u, 784208867u, 0, TAN_TOLERANCE, 0},
{ 578, 3248332291u, 1527590526u, 3206961556u, 2823164069u, 1073211002u, 2920535413u, 0, TAN_TOLERANCE, 0},
{ 579, 3236644131u, 3876699591u, 3207481130u, 4028148535u, 3220871901u, 876731950u, 0, TAN_TOLERANCE, 0},
{ 580, 1083576186u, 2164249756u, 1059857743u, 1785169952u, 1074542491u, 1306706713u, 0, TAN_TOLERANCE, 0},
{ 581, 1091804009u, 2079273665u, 1080303860u, 625760474u, 3221470601u, 3167060593u, 0, TAN_TOLERANCE, 0},
{ 582, 3226486108u, 3636214836u, 1068367620u, 2932621925u, 1072938327u, 1971428109u, 0, TAN_TOLERANCE, 0},
{ 583, 1043995372u, 4274131512u, 1047707755u, 92550763u, 1043995372u, 4274131512u, 0, TAN_TOLERANCE, 0},
{ 584, 3198822121u, 2648933384u, 1084603503u, 3534304873u, 3198822121u, 2648934875u, 0, TAN_TOLERANCE, 0},
{ 585, 1064563235u, 3216750767u, 3191088629u, 547482628u, 1064563246u, 349415911u, 0, TAN_TOLERANCE, 0},
{ 586, 1061084774u, 1420360746u, 1080063101u, 1690029499u, 1061084774u, 2062923873u, 0, TAN_TOLERANCE, 0},
{ 587, 3229855364u, 1908572179u, 1080112083u, 1228319033u, 3224026442u, 1064578383u, 0, TAN_TOLERANCE, 0},
{ 588, 1048158178u, 500312015u, 3212368508u, 3864619086u, 1048158178u, 500312037u, 0, TAN_TOLERANCE, 0},
{ 589, 3221335610u, 4211343447u, 1087492676u, 4272583781u, 1073055146u, 1668809125u, 0, TAN_TOLERANCE, 0},
{ 590, 1099392394u, 2382118000u, 1042665328u, 567154882u, 1073006307u, 3699440123u, 0, TAN_TOLERANCE, 0},
{ 591, 1058013442u, 1435344339u, 3216303171u, 2275988178u, 1058013442u, 1440940879u, 0, TAN_TOLERANCE, 0},
{ 592, 3214538619u, 3403659753u, 3218043030u, 1926480488u, 3214538984u, 2788475836u, 0, TAN_TOLERANCE, 0},
{ 593, 1076840383u, 1198845185u, 3225556149u, 1130089684u, 3216073797u, 2536472320u, 0, TAN_TOLERANCE, 0},
{ 594, 3222663042u, 2183928090u, 1048403956u, 963834821u, 1072722791u, 2238943892u, 0, TAN_TOLERANCE, 0},
{ 595, 1101672960u, 2120625396u, 1041006976u, 2137548527u, 1073487055u, 4205428157u, 0, TAN_TOLERANCE, 0},
{ 596, 1099230238u, 586700956u, 1059670521u, 303891699u, 3222213898u, 3423099859u, 0, TAN_TOLERANCE, 0},
{ 597, 3218994498u, 2509132460u, 1102827530u, 2205707903u, 3219140003u, 1207181537u, 0, TAN_TOLERANCE, 0},
{ 598, 3204860597u, 1229308263u, 3209170414u, 4206576047u, 3204860597u, 1233089342u, 0, TAN_TOLERANCE, 0},
{ 599, 3224076289u, 4078010749u, 3199236456u, 733478972u, 3221462767u, 2645312571u, 0, TAN_TOLERANCE, 0},
{ 600, 3197712584u, 4277541051u, 3199806921u, 397102023u, 3197712584u, 4277541385u, 0, TAN_TOLERANCE, 0},
{ 601, 3195975013u, 900999594u, 3234720188u, 2530214248u, 3195975013u, 900999632u, 0, TAN_TOLERANCE, 0},
{ 602, 1076543548u, 4000609478u, 1096577064u, 4148592328u, 1072744158u, 901044576u, 0, TAN_TOLERANCE, 0},
{ 603, 1048668084u, 2154187873u, 3224392607u, 3957250362u, 1048668084u, 2154187900u, 0, TAN_TOLERANCE, 0},
{ 604, 3223413488u, 2867079200u, 1101870326u, 921212001u, 1072478681u, 1947808256u, 0, TAN_TOLERANCE, 0},
{ 605, 3233221890u, 674547716u, 1063216239u, 3929755226u, 3221175450u, 1547677557u, 0, TAN_TOLERANCE, 0},
{ 606, 3240415851u, 3158182449u, 1043794244u, 3259056345u, 1071157174u, 814361401u, 0, TAN_TOLERANCE, 0},
{ 607, 3236776656u, 3002823940u, 1059511739u, 2832435794u, 1074816146u, 3432733072u, 0, TAN_TOLERANCE, 0},
{ 608, 3217304822u, 2196511929u, 1049973941u, 3672092877u, 3217315882u, 2570717061u, 0, TAN_TOLERANCE, 0},
{ 609, 1050438056u, 3655292191u, 1086438127u, 3567072906u, 1050438056u, 3655292669u, 0, TAN_TOLERANCE, 0},
{ 610, 3243186948u, 1617573614u, 3201863123u, 3090723732u, 3215739265u, 754649775u, 0, TAN_TOLERANCE, 0},
{ 611, 3233201380u, 679893506u, 3211547753u, 824081024u, 1071687746u, 513845462u, 0, TAN_TOLERANCE, 0},
{ 612, 1089530525u, 2285242807u, 1084999409u, 2221731406u, 3221265077u, 3133657547u, 0, TAN_TOLERANCE, 0},
{ 613, 3206733664u, 1935990727u, 1088822246u, 1058156518u, 3206733664u, 1972701329u, 0, TAN_TOLERANCE, 0},
{ 614, 1102839166u, 521023584u, 1059186903u, 4245163857u, 1069859447u, 743248191u, 0, TAN_TOLERANCE, 0},
{ 615, 1103891140u, 2312887617u, 3191771354u, 1885370807u, 3213444490u, 1904571603u, 0, TAN_TOLERANCE, 0},
{ 616, 3252953815u, 1796441468u, 1100030327u, 2772711004u, 3219317557u, 2229597079u, 0, TAN_TOLERANCE, 0},
{ 617, 3204276820u, 2095685003u, 1077984448u, 2100773742u, 3204276820u, 2097849993u, 0, TAN_TOLERANCE, 0},
{ 618, 3192954620u, 2892538035u, 1042396334u, 4162200338u, 3192954620u, 2892538035u, 0, TAN_TOLERANCE, 0},
{ 619, 3242725751u, 2177698116u, 3227557177u, 150832500u, 1068959958u, 4175788793u, 0, TAN_TOLERANCE, 0},
{ 620, 3191562216u, 607966734u, 3236250630u, 4164600559u, 3191562216u, 607966734u, 0, TAN_TOLERANCE, 0},
{ 621, 3216389812u, 2830122967u, 1046096700u, 3713346883u, 3216393477u, 2001753140u, 0, TAN_TOLERANCE, 0},
{ 622, 3237197963u, 2314640506u, 3203696416u, 3276228872u, 3216462828u, 1983951841u, 0, TAN_TOLERANCE, 0},
{ 623, 3212912307u, 469331883u, 3249037349u, 2999233437u, 3212912333u, 1663316888u, 0, TAN_TOLERANCE, 0},
{ 624, 1097382011u, 560886625u, 1091899487u, 748795120u, 1071993443u, 2804575561u, 0, TAN_TOLERANCE, 0},
{ 625, 1049886858u, 2958421324u, 1092569414u, 3235243477u, 1049886858u, 2958421491u, 0, TAN_TOLERANCE, 0},
{ 626, 3193026497u, 3221475559u, 1043038304u, 915608434u, 3193026497u, 3221475559u, 0, TAN_TOLERANCE, 0},
{ 627, 1071197530u, 3007808652u, 3216682290u, 2531019474u, 1071288269u, 2003569361u, 0, TAN_TOLERANCE, 0},
{ 628, 3242028999u, 1767658578u, 3237045269u, 2313128318u, 1077477368u, 1546619350u, 0, TAN_TOLERANCE, 0},
{ 629, 3210617892u, 1926845182u, 1066835624u, 1783256828u, 3210617894u, 2907970801u, 0, TAN_TOLERANCE, 0},
{ 630, 1040575629u, 90378038u, 1057168870u, 164358218u, 1040575629u, 90378038u, 0, TAN_TOLERANCE, 0},
{ 631, 1106859172u, 1610524680u, 1085283851u, 2903496007u, 3219268505u, 3734210885u, 0, TAN_TOLERANCE, 0},
{ 632, 1078635586u, 4274321404u, 3202913591u, 720121831u, 3215944252u, 3691295869u, 0, TAN_TOLERANCE, 0},
{ 633, 1051205256u, 2034778236u, 1071133763u, 1413236391u, 1051205256u, 2034779405u, 0, TAN_TOLERANCE, 0},
{ 634, 1051063028u, 1489112261u, 1076691395u, 348210906u, 1051063028u, 1489113142u, 0, TAN_TOLERANCE, 0},
{ 635, 3206743917u, 2797651324u, 3224410527u, 2374818327u, 3206743917u, 2835282496u, 0, TAN_TOLERANCE, 0},
{ 636, 1088287256u, 1823161666u, 3197810695u, 3119680047u, 3219861474u, 2047170095u, 0, TAN_TOLERANCE, 0},
{ 637, 1065927336u, 3420950657u, 1087084743u, 2136638961u, 1065927415u, 3709689162u, 0, TAN_TOLERANCE, 0},
{ 638, 1069902224u, 3554566429u, 1062907717u, 2736702589u, 1069915462u, 3518649188u, 0, TAN_TOLERANCE, 0},
{ 639, 3244888667u, 2928437580u, 3187765027u, 1393427873u, 1068333483u, 1818015207u, 0, TAN_TOLERANCE, 0},
{ 640, 3209301561u, 189447067u, 1051643315u, 828663513u, 3209301561u, 1735128209u, 0, TAN_TOLERANCE, 0},
{ 641, 1052313869u, 2852350928u, 1045683757u, 673354280u, 1052313869u, 2852356158u, 0, TAN_TOLERANCE, 0},
{ 642, 1043946301u, 3589563265u, 3248741629u, 812657927u, 1043946301u, 3589563265u, 0, TAN_TOLERANCE, 0},
{ 643, 3190610826u, 1766416701u, 1100392103u, 2185373290u, 3190610826u, 1766416701u, 0, TAN_TOLERANCE, 0},
{ 644, 3220275389u, 3763582673u, 3191965790u, 388374829u, 3221157954u, 1827747543u, 0, TAN_TOLERANCE, 0},
{ 645, 1079635136u, 1187403069u, 1075300235u, 336640304u, 1067143974u, 3696369881u, 0, TAN_TOLERANCE, 0},
{ 646, 1103926251u, 1718795752u, 3243118752u, 683369237u, 3219595101u, 1799803345u, 0, TAN_TOLERANCE, 0},
{ 647, 3210792097u, 1863545307u, 1069449477u, 3418627399u, 3210792098u, 4197087876u, 0, TAN_TOLERANCE, 0},
{ 648, 1069601294u, 3295607249u, 1068878592u, 1633297809u, 1069607684u, 1276743969u, 0, TAN_TOLERANCE, 0},
{ 649, 1058947127u, 2585980994u, 3236670483u, 1286750688u, 1058947127u, 2623777476u, 0, TAN_TOLERANCE, 0},
{ 650, 1046157033u, 15816845u, 3233249283u, 2491924775u, 1046157033u, 15816847u, 0, TAN_TOLERANCE, 0},
{ 651, 1042413021u, 1051983351u, 1049180786u, 1474421917u, 1042413021u, 1051983351u, 0, TAN_TOLERANCE, 0},
{ 652, 3201249525u, 2003816032u, 1086050104u, 668090487u, 3201249525u, 2003856493u, 0, TAN_TOLERANCE, 0},
{ 653, 1052556037u, 3671484625u, 1067020039u, 430024694u, 1052556037u, 3671492530u, 0, TAN_TOLERANCE, 0},
{ 654, 1067397110u, 3991830201u, 3207808714u, 1021245839u, 1067397743u, 564284082u, 0, TAN_TOLERANCE, 0},
{ 655, 1064194391u, 4255801807u, 3207681716u, 1926756877u, 1064194401u, 267289285u, 0, TAN_TOLERANCE, 0},
{ 656, 1052140785u, 4167786896u, 1077097744u, 1775517981u, 1052140785u, 4167790640u, 0, TAN_TOLERANCE, 0},
{ 657, 1085601978u, 3187518564u, 1082437406u, 944672491u, 3218112804u, 3739410670u, 0, TAN_TOLERANCE, 0},
{ 658, 1049366282u, 953085192u, 3227310828u, 3459155777u, 1049366282u, 953085307u, 0, TAN_TOLERANCE, 0},
{ 659, 1069502506u, 1908555460u, 1073640207u, 260441967u, 1069512802u, 1649179346u, 0, TAN_TOLERANCE, 0},
{ 660, 1067219606u, 250762477u, 1072582645u, 2886742039u, 1067220087u, 1752188499u, 0, TAN_TOLERANCE, 0},
{ 661, 3250906006u, 786180031u, 3197734769u, 2788918312u, 3219515699u, 2725543956u, 0, TAN_TOLERANCE, 0},
{ 662, 3234511827u, 2055912467u, 3244244909u, 1394142937u, 1070694857u, 2816615981u, 0, TAN_TOLERANCE, 0},
{ 663, 1069612985u, 91984146u, 3222252812u, 4126276047u, 1069619580u, 4178832687u, 0, TAN_TOLERANCE, 0},
{ 664, 1081340139u, 3942715706u, 3239316352u, 410676547u, 3222618996u, 869458806u, 0, TAN_TOLERANCE, 0},
{ 665, 3198557846u, 86296211u, 1085850694u, 649202596u, 3198557846u, 86297113u, 0, TAN_TOLERANCE, 0},
{ 666, 3245366392u, 3069064472u, 3237358008u, 23209276u, 1071509322u, 3234392254u, 0, TAN_TOLERANCE, 0},
{ 667, 1081235288u, 1867297860u, 1072956607u, 2513414118u, 1074517732u, 2357944421u, 0, TAN_TOLERANCE, 0},
{ 668, 3250533347u, 3171788768u, 3235208783u, 162138697u, 1074879793u, 3994846525u, 0, TAN_TOLERANCE, 0},
{ 669, 1081728455u, 1245110700u, 1081653954u, 2584994077u, 3220272741u, 1136402195u, 0, TAN_TOLERANCE, 0},
{ 670, 3245510120u, 3347226587u, 1058962932u, 2291943376u, 1071151630u, 2408276492u, 0, TAN_TOLERANCE, 0},
{ 671, 1058899062u, 966940828u, 1060726420u, 2798041096u, 1058899062u, 1002054341u, 0, TAN_TOLERANCE, 0},
{ 672, 1072793759u, 2487340727u, 3223786370u, 4105954991u, 1073683919u, 1905677821u, 0, TAN_TOLERANCE, 0},
{ 673, 3248116497u, 1671039260u, 1086395032u, 3745833360u, 3218381141u, 2264716022u, 0, TAN_TOLERANCE, 0},
{ 674, 1057078797u, 651714217u, 1047070645u, 2130549237u, 1057078797u, 653620621u, 0, TAN_TOLERANCE, 0},
{ 675, 3207115731u, 1423000172u, 3247822717u, 1551488170u, 3207115731u, 1505322649u, 0, TAN_TOLERANCE, 0},
{ 676, 3201597307u, 921077236u, 3213332351u, 1431049019u, 3201597307u, 921123170u, 0, TAN_TOLERANCE, 0},
{ 677, 1067510295u, 655715547u, 3190985373u, 1527556471u, 1067510698u, 2547250551u, 0, TAN_TOLERANCE, 0},
{ 678, 3227654979u, 4110878657u, 3251297180u, 879739345u, 3218509109u, 2423441325u, 0, TAN_TOLERANCE, 0},
{ 679, 1085804762u, 2623955764u, 1093699897u, 1216444475u, 1070118810u, 3472479979u, 0, TAN_TOLERANCE, 0},
{ 680, 1091905603u, 107442539u, 3239767031u, 1149813329u, 1071923940u, 457790337u, 0, TAN_TOLERANCE, 0},
{ 681, 3233445240u, 1761361082u, 3226030205u, 1121849716u, 3217653293u, 4119342134u, 0, TAN_TOLERANCE, 0},
{ 682, 3240087115u, 2534144722u, 1044223733u, 3512285706u, 3224103620u, 2429523598u, 0, TAN_TOLERANCE, 0},
{ 683, 3211846077u, 4073670723u, 1050729852u, 3034818849u, 3211846084u, 915461231u, 0, TAN_TOLERANCE, 0},
{ 684, 1101984574u, 1421423503u, 1060278048u, 1397153092u, 1072776793u, 1253204266u, 0, TAN_TOLERANCE, 0},
{ 685, 3217421829u, 1649206019u, 1104525577u, 1267104290u, 3217436119u, 2880193675u, 0, TAN_TOLERANCE, 0},
{ 686, 3189302097u, 3775270392u, 1040251850u, 68667319u, 3189302097u, 3775270392u, 0, TAN_TOLERANCE, 0},
{ 687, 3204330900u, 3099226694u, 3254103006u, 4020102648u, 3204330900u, 3101579254u, 0, TAN_TOLERANCE, 0},
{ 688, 3201591712u, 3718441177u, 3215643451u, 4032951536u, 3201591712u, 3718486539u, 0, TAN_TOLERANCE, 0},
{ 689, 1044131371u, 508048351u, 3210196713u, 1707937896u, 1044131371u, 508048351u, 0, TAN_TOLERANCE, 0},
{ 690, 3198611627u, 2784738160u, 1073435430u, 1109346010u, 3198611627u, 2784739166u, 0, TAN_TOLERANCE, 0},
{ 691, 3225725290u, 3331916473u, 3238794568u, 2707019594u, 3219179196u, 1878996346u, 0, TAN_TOLERANCE, 0},
{ 692, 1093182670u, 3093165197u, 1072894805u, 2853215019u, 3217526033u, 2848721056u, 0, TAN_TOLERANCE, 0},
{ 693, 3216582139u, 2135797997u, 1048399559u, 2941926126u, 3216587461u, 2824369149u, 0, TAN_TOLERANCE, 0},
{ 694, 1048430980u, 2083412145u, 3249335391u, 507212448u, 1048430980u, 2083412179u, 0, TAN_TOLERANCE, 0},
{ 695, 1075363751u, 4270176401u, 3246546709u, 3288753319u, 3216549950u, 3510999752u, 0, TAN_TOLERANCE, 0},
{ 696, 3247932863u, 3692175292u, 3197271515u, 3989064196u, 1075194806u, 1737451979u, 0, TAN_TOLERANCE, 0},
{ 697, 3251691738u, 3111924274u, 1066772558u, 59281695u, 1070740573u, 1549531850u, 0, TAN_TOLERANCE, 0},
{ 698, 1067683911u, 2135245466u, 3208804313u, 3846547392u, 1067684535u, 3577147149u, 0, TAN_TOLERANCE, 0},
{ 699, 1094877811u, 972051266u, 3222814246u, 3539700586u, 1073113122u, 2031122011u, 0, TAN_TOLERANCE, 0},
{ 700, 3202965930u, 330951080u, 1079189813u, 583922384u, 3202965930u, 331299907u, 0, TAN_TOLERANCE, 0},
{ 701, 1089640092u, 1711944085u, 1104170032u, 643991456u, 1074425836u, 759692993u, 0, TAN_TOLERANCE, 0},
{ 702, 3234429549u, 2072550721u, 3250147641u, 4280263530u, 3220634492u, 1689537566u, 0, TAN_TOLERANCE, 0},
{ 703, 3192972706u, 1566376352u, 1067251433u, 72984588u, 3192972706u, 1566376352u, 0, TAN_TOLERANCE, 0},
{ 704, 1095276569u, 3103043079u, 1045853123u, 410067497u, 3219184490u, 2989790297u, 0, TAN_TOLERANCE, 0},
{ 705, 3216672493u, 1910366299u, 1081770885u, 634683073u, 3216678742u, 2219186766u, 0, TAN_TOLERANCE, 0},
{ 706, 1081530688u, 2226525875u, 3224149290u, 2126302825u, 1073875863u, 3373110948u, 0, TAN_TOLERANCE, 0},
{ 707, 1073150247u, 1383818978u, 3193885723u, 1220372650u, 1075672286u, 2180760441u, 0, TAN_TOLERANCE, 0},
{ 708, 1066482943u, 1953339096u, 1077176252u, 1476516558u, 1066483050u, 796594176u, 0, TAN_TOLERANCE, 0},
{ 709, 1066092000u, 1306277326u, 1079089150u, 4093716191u, 1066092105u, 4157158941u, 0, TAN_TOLERANCE, 0},
{ 710, 3233148787u, 51750045u, 3242913901u, 4256866157u, 3222988569u, 439136879u, 0, TAN_TOLERANCE, 0},
{ 711, 3195084967u, 2163853087u, 3232053146u, 2962422808u, 3195084967u, 2163853094u, 0, TAN_TOLERANCE, 0},
{ 712, 1075516945u, 1618388148u, 3233154824u, 3711953164u, 1071710292u, 1922481399u, 0, TAN_TOLERANCE, 0},
{ 713, 3246868002u, 357108214u, 3202294604u, 2306775262u, 1072903322u, 605160679u, 0, TAN_TOLERANCE, 0},
{ 714, 3201904086u, 2571356437u, 3249064063u, 2394851808u, 3201904086u, 2571441574u, 0, TAN_TOLERANCE, 0},
{ 715, 3230488091u, 4273880094u, 1103698617u, 3578832032u, 1071947813u, 4287022097u, 0, TAN_TOLERANCE, 0},
{ 716, 3233426701u, 2091068742u, 3228270226u, 3980489730u, 3215078902u, 1010047045u, 0, TAN_TOLERANCE, 0},
{ 717, 3229016752u, 2772307714u, 1051008486u, 32546576u, 1075245665u, 462916900u, 0, TAN_TOLERANCE, 0},
{ 718, 3241229215u, 2143788498u, 3195498043u, 3630119231u, 3221585624u, 179270373u, 0, TAN_TOLERANCE, 0},
{ 719, 3198632935u, 2527385594u, 3240503648u, 3482095012u, 3198632935u, 2527386643u, 0, TAN_TOLERANCE, 0},
{ 720, 3242168799u, 2690097362u, 1068598730u, 2360266862u, 3220602288u, 418300175u, 0, TAN_TOLERANCE, 0},
{ 721, 1058857869u, 2673272949u, 1082639557u, 522449749u, 1058857869u, 2706190749u, 0, TAN_TOLERANCE, 0},
{ 722, 1104424147u, 3596379400u, 3242016775u, 2002293002u, 3221113564u, 1902628924u, 0, TAN_TOLERANCE, 0},
{ 723, 1099439656u, 4113224369u, 3222122439u, 2152316893u, 1071885781u, 1950205565u, 0, TAN_TOLERANCE, 0},
{ 724, 3220796716u, 31662602u, 1047721249u, 1747087514u, 1078500715u, 94481049u, 0, TAN_TOLERANCE, 0},
{ 725, 3250463757u, 2489659568u, 1097051253u, 277506957u, 3220359518u, 3160316980u, 0, TAN_TOLERANCE, 0},
{ 726, 3191401834u, 3850162281u, 3213841942u, 438724093u, 3191401834u, 3850162281u, 0, TAN_TOLERANCE, 0},
{ 727, 1095392535u, 2431814052u, 1075518084u, 2672434118u, 3213954599u, 974405380u, 0, TAN_TOLERANCE, 0},
{ 728, 3243162735u, 391606792u, 1048184750u, 4168944276u, 3221302992u, 3451129745u, 0, TAN_TOLERANCE, 0},
{ 729, 3247792416u, 457529672u, 3201090276u, 72407935u, 3222315239u, 1160982851u, 0, TAN_TOLERANCE, 0},
{ 730, 3218720719u, 3954981400u, 1052053242u, 2411049585u, 3218818453u, 61902234u, 0, TAN_TOLERANCE, 0},
{ 731, 1086180091u, 485456950u, 1088415093u, 1655397424u, 3220221131u, 2324510511u, 0, TAN_TOLERANCE, 0},
{ 732, 3198234428u, 1551748070u, 3236871640u, 1329701152u, 3198234428u, 1551748493u, 0, TAN_TOLERANCE, 0},
{ 733, 3224639122u, 3099222537u, 1104984570u, 4293792842u, 3221696756u, 3006182604u, 0, TAN_TOLERANCE, 0},
{ 734, 3203949705u, 3603065260u, 3197735968u, 2402359253u, 3203949705u, 3604303771u, 0, TAN_TOLERANCE, 0},
{ 735, 3198824584u, 3961208159u, 3219057584u, 2340553876u, 3198824584u, 3961209656u, 0, TAN_TOLERANCE, 0},
{ 736, 1074881909u, 4014841779u, 3197672877u, 3697233334u, 1074072291u, 3216031119u, 0, TAN_TOLERANCE, 0},
{ 737, 3213275657u, 1403876392u, 3254028950u, 921363393u, 3213275718u, 925891589u, 0, TAN_TOLERANCE, 0},
{ 738, 1107251806u, 1862576361u, 3194031708u, 2476290925u, 1066826438u, 3927706251u, 0, TAN_TOLERANCE, 0},
{ 739, 1049661768u, 1454212851u, 1088378861u, 3400401866u, 1049661768u, 1454212946u, 0, TAN_TOLERANCE, 0},
{ 740, 1074406809u, 552676385u, 3188635745u, 3778112968u, 1069568065u, 3064462875u, 0, TAN_TOLERANCE, 0},
{ 741, 3216409282u, 1199568671u, 3225679997u, 46947405u, 3216413096u, 1759976264u, 0, TAN_TOLERANCE, 0},
{ 742, 1077685537u, 2596231448u, 3253943728u, 2219151748u, 3216584142u, 1488430398u, 0, TAN_TOLERANCE, 0},
{ 743, 1066527035u, 4119719558u, 3222036299u, 1275474618u, 1066527155u, 2928830600u, 0, TAN_TOLERANCE, 0},
{ 744, 3239908663u, 3347296825u, 1101507910u, 1254014794u, 1072809120u, 869332103u, 0, TAN_TOLERANCE, 0},
{ 745, 1084119992u, 673775040u, 1070743626u, 244126093u, 1075534323u, 698300927u, 0, TAN_TOLERANCE, 0},
{ 746, 3203199850u, 1832066983u, 1051358028u, 3262483417u, 3203199850u, 1832584640u, 0, TAN_TOLERANCE, 0},
{ 747, 1077559600u, 3962610501u, 3198598777u, 849269178u, 1073781704u, 804173689u, 0, TAN_TOLERANCE, 0},
{ 748, 3235473900u, 2497516122u, 3254374111u, 2821429629u, 1074308595u, 3100151219u, 0, TAN_TOLERANCE, 0},
{ 749, 1076236288u, 2805941787u, 3217785843u, 779131141u, 3225158579u, 3900803877u, 0, TAN_TOLERANCE, 0},
{ 750, 3226908686u, 723423605u, 1084533420u, 627282213u, 1070465931u, 3949309375u, 0, TAN_TOLERANCE, 0},
{ 751, 3215947680u, 4292778869u, 1078101071u, 1676860147u, 3215950281u, 2069249548u, 0, TAN_TOLERANCE, 0},
{ 752, 1076288502u, 3528118587u, 3194648564u, 2363260897u, 3221307988u, 19736518u, 0, TAN_TOLERANCE, 0},
{ 753, 3192897879u, 1307010018u, 1061248120u, 1468743108u, 3192897879u, 1307010019u, 0, TAN_TOLERANCE, 0},
{ 754, 3246583139u, 107905661u, 3226089788u, 1943427674u, 3222568369u, 1322611276u, 0, TAN_TOLERANCE, 0},
{ 755, 3188230541u, 760006940u, 1054265604u, 1749976597u, 3188230541u, 760006940u, 0, TAN_TOLERANCE, 0},
{ 756, 3237773384u, 2787503556u, 1081282610u, 1195841206u, 1073441083u, 1059539068u, 0, TAN_TOLERANCE, 0},
{ 757, 3191802156u, 545462045u, 3208381743u, 1981311808u, 3191802156u, 545462045u, 0, TAN_TOLERANCE, 0},
{ 758, 1061232136u, 3657978397u, 1104463616u, 3501253426u, 1061232136u, 4096232730u, 0, TAN_TOLERANCE, 0},
{ 759, 1049883857u, 1804177501u, 3210693633u, 3606766729u, 1049883857u, 1804177667u, 0, TAN_TOLERANCE, 0},
{ 760, 1076856879u, 1336278526u, 1043741618u, 3165279431u, 1068350898u, 491456471u, 0, TAN_TOLERANCE, 0},
{ 761, 1055471915u, 1599382075u, 1058018527u, 4212580517u, 1055471915u, 1599724421u, 0, TAN_TOLERANCE, 0},
{ 762, 3207502326u, 3007589929u, 3202026547u, 2792028313u, 3207502326u, 3164093214u, 0, TAN_TOLERANCE, 0},
{ 763, 3253082770u, 1866066996u, 1060329048u, 3727175322u, 1072698640u, 3872927457u, 0, TAN_TOLERANCE, 0},
{ 764, 3198416643u, 150890940u, 1056025306u, 3082724735u, 3198416643u, 150891603u, 0, TAN_TOLERANCE, 0},
{ 765, 1062008939u, 80400395u, 1093584426u, 3478941315u, 1062008939u, 2205021603u, 0, TAN_TOLERANCE, 0},
{ 766, 3251640614u, 4050954182u, 3219263194u, 2537475930u, 1069381185u, 3828509291u, 0, TAN_TOLERANCE, 0},
{ 767, 1064841871u, 2881752155u, 3212589299u, 2559651278u, 1064841890u, 512262744u, 0, TAN_TOLERANCE, 0},
{ 768, 3249016304u, 440309030u, 3214267461u, 3788040806u, 3219236838u, 312619054u, 0, TAN_TOLERANCE, 0},
{ 769, 1100476615u, 918813144u, 3208535698u, 1607035904u, 3221517627u, 3644569098u, 0, TAN_TOLERANCE, 0},
{ 770, 1042137451u, 2497054124u, 1089139147u, 2549609010u, 1042137451u, 2497054124u, 0, TAN_TOLERANCE, 0},
{ 771, 1047037641u, 790219083u, 1054657139u, 2797979479u, 1047037641u, 790219088u, 0, TAN_TOLERANCE, 0},
{ 772, 1057781400u, 1149462078u, 1095765205u, 3879963182u, 1057781400u, 1157333128u, 0, TAN_TOLERANCE, 0},
{ 773, 3202729813u, 2684353926u, 3205212854u, 1732474928u, 3202729813u, 2684574296u, 0, TAN_TOLERANCE, 0},
{ 774, 1095236965u, 2742237025u, 1051317716u, 3386396147u, 1070950125u, 4063976668u, 0, TAN_TOLERANCE, 0},
{ 775, 1063230986u, 3408320912u, 1103071166u, 4233059513u, 1063230989u, 1570710087u, 0, TAN_TOLERANCE, 0},
{ 776, 1064863548u, 1077495917u, 1088399968u, 433115118u, 1064863567u, 2001865724u, 0, TAN_TOLERANCE, 0},
{ 777, 3204547572u, 841366493u, 1051716814u, 4121125128u, 3204547572u, 843200674u, 0, TAN_TOLERANCE, 0},
{ 778, 1064632084u, 321857207u, 1089128010u, 1149988239u, 1064632096u, 547429103u, 0, TAN_TOLERANCE, 0},
{ 779, 3245542663u, 799866606u, 3197637091u, 3924438208u, 3211532957u, 3662721595u, 0, TAN_TOLERANCE, 0},
{ 780, 3191062890u, 2002049816u, 1077053447u, 2240354761u, 3191062890u, 2002049816u, 0, TAN_TOLERANCE, 0},
{ 781, 3229006283u, 478939968u, 1097035749u, 1066716440u, 1072752037u, 2531096848u, 0, TAN_TOLERANCE, 0},
{ 782, 3232473641u, 1653104725u, 1088548129u, 81977716u, 1071090445u, 506086843u, 0, TAN_TOLERANCE, 0},
{ 783, 3196861276u, 3899475018u, 3189694084u, 3330093036u, 3196861276u, 3899475135u, 0, TAN_TOLERANCE, 0},
{ 784, 1089312583u, 2612450289u, 1079065127u, 603380842u, 1073008863u, 3887211481u, 0, TAN_TOLERANCE, 0},
{ 785, 1100636791u, 3962735564u, 1101570429u, 1372490825u, 3220290720u, 1010454053u, 0, TAN_TOLERANCE, 0},
{ 786, 1054806016u, 1479841439u, 1059312257u, 541504905u, 1054806016u, 1480001287u, 0, TAN_TOLERANCE, 0},
{ 787, 1078662178u, 2626148789u, 1057571099u, 4121656076u, 1072550701u, 103347377u, 0, TAN_TOLERANCE, 0},
{ 788, 1081613389u, 1902560314u, 1043130231u, 3557671562u, 3219664068u, 2202748350u, 0, TAN_TOLERANCE, 0},
{ 789, 3193829772u, 41779312u, 1081626342u, 831171823u, 3193829772u, 41779314u, 0, TAN_TOLERANCE, 0},
{ 790, 1058131100u, 1393168821u, 1066457405u, 1381616968u, 1058131100u, 1400868003u, 0, TAN_TOLERANCE, 0},
{ 791, 1072338141u, 3756584649u, 3222267229u, 1423157432u, 1072792768u, 1008405082u, 0, TAN_TOLERANCE, 0},
{ 792, 3254435674u, 1894912556u, 1042426694u, 155024547u, 3218179819u, 2046959496u, 0, TAN_TOLERANCE, 0},
{ 793, 3195453512u, 35164295u, 3203391785u, 1037041084u, 3195453512u, 35164310u, 0, TAN_TOLERANCE, 0},
{ 794, 1084777479u, 3957875950u, 3232195211u, 1590756436u, 3219947575u, 33029473u, 0, TAN_TOLERANCE, 0},
{ 795, 1068844322u, 1447585080u, 1071279485u, 1107922438u, 1068847538u, 3657603058u, 0, TAN_TOLERANCE, 0},
{ 796, 1046252518u, 981897615u, 1051856116u, 430357614u, 1046252518u, 981897617u, 0, TAN_TOLERANCE, 0},
{ 797, 3227524215u, 395145384u, 3219821938u, 50586510u, 3216350661u, 266931658u, 0, TAN_TOLERANCE, 0},
{ 798, 1069775912u, 750827797u, 1082862669u, 230466783u, 1069785868u, 656722732u, 0, TAN_TOLERANCE, 0},
{ 799, 1086668819u, 1365083575u, 3204848310u, 1700831722u, 1072758492u, 877880103u, 0, TAN_TOLERANCE, 0},
{ 800, 3218090390u, 344241827u, 1071538935u, 2715566077u, 3218113497u, 943457430u, 0, TAN_TOLERANCE, 0},
{ 801, 3247582856u, 4069301823u, 3193208760u, 2949125229u, 3220500077u, 3721096040u, 0, TAN_TOLERANCE, 0},
{ 802, 1103231387u, 3585711710u, 1065801594u, 2302229267u, 1073052568u, 2823852135u, 0, TAN_TOLERANCE, 0},
{ 803, 3194118956u, 709803845u, 1048741487u, 2296910194u, 3194118956u, 709803847u, 0, TAN_TOLERANCE, 0},
{ 804, 3193280779u, 744421179u, 1069302001u, 2659232829u, 3193280779u, 744421180u, 0, TAN_TOLERANCE, 0},
{ 805, 1092835968u, 1799949903u, 3192522886u, 4212149209u, 3222671637u, 2782741478u, 0, TAN_TOLERANCE, 0},
{ 806, 3206108502u, 145234164u, 3250614064u, 912384201u, 3206108502u, 167432287u, 0, TAN_TOLERANCE, 0},
{ 807, 3240510664u, 2784620507u, 1102812948u, 3531481022u, 1071861957u, 1209927963u, 0, TAN_TOLERANCE, 0},
{ 808, 3251159663u, 383952592u, 3205659905u, 3633194728u, 1073108607u, 1305867219u, 0, TAN_TOLERANCE, 0},
{ 809, 3203476252u, 3792395543u, 1070072378u, 3864816376u, 3203476252u, 3792827369u, 0, TAN_TOLERANCE, 0},
{ 810, 3205316273u, 2115553675u, 1066288499u, 3538377867u, 3205316273u, 2124091140u, 0, TAN_TOLERANCE, 0},
{ 811, 3252075185u, 1230026762u, 1090719723u, 440819880u, 3220809625u, 1855897437u, 0, TAN_TOLERANCE, 0},
{ 812, 3194595076u, 2991290482u, 1096886719u, 1097971167u, 3194595076u, 2991290487u, 0, TAN_TOLERANCE, 0},
{ 813, 1090048600u, 1098035020u, 3230900504u, 1479059095u, 1074542433u, 1727465346u, 0, TAN_TOLERANCE, 0},
{ 814, 3251056964u, 1719428427u, 3188631907u, 3707377409u, 1074529400u, 867101846u, 0, TAN_TOLERANCE, 0},
{ 815, 1053236165u, 3748932896u, 1084908557u, 1325384361u, 1053236165u, 3748949349u, 0, TAN_TOLERANCE, 0},
{ 816, 1084704076u, 3979168763u, 1057455255u, 2454615952u, 1071422651u, 515448681u, 0, TAN_TOLERANCE, 0},
{ 817, 1053106984u, 1449164578u, 1056960316u, 1654931641u, 1053106984u, 1449177170u, 0, TAN_TOLERANCE, 0},
{ 818, 1071439010u, 2120487381u, 3226298974u, 2364226633u, 1071578601u, 3101860884u, 0, TAN_TOLERANCE, 0},
{ 819, 1075071428u, 1074268944u, 1065730444u, 280016852u, 3221571272u, 473828447u, 0, TAN_TOLERANCE, 0},
{ 820, 3200308256u, 3315127889u, 3236295594u, 2900924954u, 3200308256u, 3315134244u, 0, TAN_TOLERANCE, 0},
{ 821, 3196425891u, 2246037502u, 1049691002u, 1496066550u, 3196425891u, 2246037554u, 0, TAN_TOLERANCE, 0},
{ 822, 3193006859u, 4191285446u, 3217936236u, 2382392789u, 3193006859u, 4191285446u, 0, TAN_TOLERANCE, 0},
{ 823, 1092833308u, 640099844u, 1042152237u, 2064279383u, 1071765815u, 106826017u, 0, TAN_TOLERANCE, 0},
{ 824, 1079913438u, 3468560824u, 1093251038u, 310958750u, 1074618739u, 964701519u, 0, TAN_TOLERANCE, 0},
{ 825, 1096788400u, 1413568905u, 1100941106u, 1627289946u, 3219861883u, 2605802298u, 0, TAN_TOLERANCE, 0},
{ 826, 3191549550u, 3797143370u, 3195497539u, 3843275034u, 3191549550u, 3797143370u, 0, TAN_TOLERANCE, 0},
{ 827, 3252077393u, 2806642640u, 3201943068u, 2515980718u, 3218102760u, 374409247u, 0, TAN_TOLERANCE, 0},
{ 828, 1086877316u, 632580632u, 1078673506u, 3259601317u, 3220185630u, 3401299183u, 0, TAN_TOLERANCE, 0},
{ 829, 3200980575u, 3309678799u, 1049337078u, 3056787074u, 3200980575u, 3309705299u, 0, TAN_TOLERANCE, 0},
{ 830, 3221495289u, 2341164249u, 1080834967u, 2810890005u, 1072115406u, 1493859610u, 0, TAN_TOLERANCE, 0},
{ 831, 1067019674u, 932124675u, 1093915797u, 662682630u, 1067020016u, 3583760323u, 0, TAN_TOLERANCE, 0},
{ 832, 3249230091u, 1367996113u, 3251723684u, 2974064663u, 1069437035u, 832804725u, 0, TAN_TOLERANCE, 0},
{ 833, 1080230731u, 323437999u, 1090499064u, 901457511u, 1074630302u, 1396044198u, 0, TAN_TOLERANCE, 0},
{ 834, 3235778876u, 4184941840u, 3196770014u, 2458988443u, 3222365184u, 3232213730u, 0, TAN_TOLERANCE, 0},
{ 835, 1087618284u, 2023065054u, 3211994098u, 2734612965u, 3222159526u, 1007620686u, 0, TAN_TOLERANCE, 0},
{ 836, 1064074694u, 3679267365u, 3237728785u, 1699558211u, 1064074702u, 1654930644u, 0, TAN_TOLERANCE, 0},
{ 837, 1088079010u, 1826799031u, 1078709629u, 3986905229u, 1069698140u, 1279549780u, 0, TAN_TOLERANCE, 0},
{ 838, 1052843785u, 351061688u, 3194386466u, 4105857588u, 1052843785u, 351068380u, 0, TAN_TOLERANCE, 0},
{ 839, 1054128006u, 1365244058u, 1064457319u, 1452191426u, 1054128006u, 1365291479u, 0, TAN_TOLERANCE, 0},
{ 840, 1064122385u, 2463030625u, 3215975031u, 3773488326u, 1064122393u, 2980179277u, 0, TAN_TOLERANCE, 0},
{ 841, 3251276671u, 752664055u, 1065110394u, 1835931663u, 1070794184u, 1849724958u, 0, TAN_TOLERANCE, 0},
{ 842, 1088045088u, 3496172149u, 1089617208u, 109068701u, 1073455741u, 2200569132u, 0, TAN_TOLERANCE, 0},
{ 843, 3198135087u, 1636966254u, 1086098766u, 2016598298u, 3198135087u, 1636966916u, 0, TAN_TOLERANCE, 0},
{ 844, 1050931318u, 3551516956u, 1097969102u, 1317953425u, 1050931318u, 3551517617u, 0, TAN_TOLERANCE, 0},
{ 845, 3229832217u, 2977627788u, 1045339018u, 516058480u, 1071228652u, 1624784694u, 0, TAN_TOLERANCE, 0},
{ 846, 3237408578u, 3901731263u, 3189566462u, 32272932u, 3218229315u, 1632924751u, 0, TAN_TOLERANCE, 0},
{ 847, 1077281796u, 1956025297u, 3246628529u, 3840733905u, 1067000694u, 1129527548u, 0, TAN_TOLERANCE, 0},
{ 848, 1099818036u, 561057891u, 3198494340u, 4271027193u, 3219784884u, 1730936066u, 0, TAN_TOLERANCE, 0},
{ 849, 3250929921u, 692989850u, 3242630588u, 2492225971u, 1073186106u, 790327840u, 0, TAN_TOLERANCE, 0},
{ 850, 3205479397u, 3439913962u, 1067477011u, 2973333638u, 3205479397u, 3450822138u, 0, TAN_TOLERANCE, 0},
{ 851, 3213993989u, 877613377u, 1044917899u, 809672798u, 3213994103u, 3825407549u, 0, TAN_TOLERANCE, 0},
{ 852, 3222171454u, 905426932u, 1046417457u, 1086320855u, 3219716531u, 431784327u, 0, TAN_TOLERANCE, 0},
{ 853, 3246346629u, 2645567288u, 1051258339u, 557182478u, 3221881274u, 64244743u, 0, TAN_TOLERANCE, 0},
{ 854, 3204057950u, 186287752u, 1061342054u, 4054003419u, 3204057950u, 187795268u, 0, TAN_TOLERANCE, 0},
{ 855, 1097266673u, 3506889716u, 3243866036u, 519056371u, 1071339869u, 2789308492u, 0, TAN_TOLERANCE, 0},
{ 856, 1042654053u, 2171898436u, 3246911982u, 1091500784u, 1042654053u, 2171898436u, 0, TAN_TOLERANCE, 0},
{ 857, 3243647673u, 368493885u, 3222871893u, 1419055230u, 1076440210u, 3154672031u, 0, TAN_TOLERANCE, 0},
{ 858, 1091950572u, 2010971245u, 3188804530u, 1518695799u, 3220286110u, 4209056249u, 0, TAN_TOLERANCE, 0},
{ 859, 3205426509u, 1239207795u, 1040192984u, 2199481342u, 3205426509u, 1249304750u, 0, TAN_TOLERANCE, 0},
{ 860, 3210978637u, 4264613432u, 3203460972u, 3558930895u, 3210978640u, 1980632273u, 0, TAN_TOLERANCE, 0},
{ 861, 1050299283u, 3772748958u, 3227667376u, 309688336u, 1050299283u, 3772749337u, 0, TAN_TOLERANCE, 0},
{ 862, 3230743041u, 1077949160u, 1075769893u, 2405271377u, 1070180192u, 446368177u, 0, TAN_TOLERANCE, 0},
{ 863, 1091835152u, 3751608506u, 3232278094u, 930375071u, 3217726898u, 3481548138u, 0, TAN_TOLERANCE, 0},
{ 864, 3198617153u, 1518334131u, 3205247482u, 791756713u, 3198617153u, 1518335148u, 0, TAN_TOLERANCE, 0},
{ 865, 1047317453u, 2825203170u, 3245054001u, 1822981827u, 1047317453u, 2825203178u, 0, TAN_TOLERANCE, 0},
{ 866, 1100016363u, 514474738u, 1089072073u, 3300845441u, 3217319144u, 2916802364u, 0, TAN_TOLERANCE, 0},
{ 867, 3216391250u, 247369460u, 3197320093u, 687450958u, 3216394925u, 3233522059u, 0, TAN_TOLERANCE, 0},
{ 868, 1104161422u, 2722237629u, 1058272368u, 90602316u, 1073200343u, 2302788437u, 0, TAN_TOLERANCE, 0},
{ 869, 3208098435u, 1845900544u, 3231520830u, 3389751458u, 3208098435u, 2136608077u, 0, TAN_TOLERANCE, 0},
{ 870, 3247535245u, 737689911u, 3195377751u, 3462616966u, 3219253037u, 3883211308u, 0, TAN_TOLERANCE, 0},
{ 871, 3223538384u, 3620285831u, 1055501023u, 2708056059u, 3217870312u, 2224856412u, 0, TAN_TOLERANCE, 0},
{ 872, 3219464996u, 4073430285u, 1056206159u, 172017902u, 3219709169u, 2516376400u, 0, TAN_TOLERANCE, 0},
{ 873, 3212869638u, 2799176222u, 1052706894u, 4083892667u, 3212869662u, 211559933u, 0, TAN_TOLERANCE, 0},
{ 874, 3202279557u, 1562351330u, 1069705601u, 1247765260u, 3202279557u, 1562508809u, 0, TAN_TOLERANCE, 0},
{ 875, 3232717299u, 51853475u, 3189080201u, 2783553144u, 3221383237u, 3613213752u, 0, TAN_TOLERANCE, 0},
{ 876, 3219454353u, 3851781549u, 3241598113u, 514064046u, 3219692168u, 1685602423u, 0, TAN_TOLERANCE, 0},
{ 877, 1100045965u, 934745487u, 3248182437u, 2798581921u, 3217714806u, 3046333778u, 0, TAN_TOLERANCE, 0},
{ 878, 3213082493u, 2948648757u, 3232177250u, 4278702895u, 3213082533u, 3433940202u, 0, TAN_TOLERANCE, 0},
{ 879, 1072485724u, 4259101461u, 1061606772u, 84229920u, 1072968884u, 431127016u, 0, TAN_TOLERANCE, 0},
{ 880, 3198075559u, 3891230598u, 1095924595u, 3049217547u, 3198075559u, 3891231204u, 0, TAN_TOLERANCE, 0},
{ 881, 1077353053u, 3806018919u, 3243191216u, 280177341u, 1073754255u, 3810288957u, 0, TAN_TOLERANCE, 0},
{ 882, 1060624530u, 3900344258u, 1063647809u, 4206745890u, 1060624530u, 4196557767u, 0, TAN_TOLERANCE, 0},
{ 883, 3227707336u, 2126253040u, 3207248026u, 808507485u, 3219040601u, 2852753536u, 0, TAN_TOLERANCE, 0},
{ 884, 1086090317u, 3465685634u, 3230391053u, 3754958214u, 1071200193u, 1669130251u, 0, TAN_TOLERANCE, 0},
{ 885, 1102861084u, 461094531u, 1101110393u, 1316091396u, 1072468733u, 843744847u, 0, TAN_TOLERANCE, 0},
{ 886, 1064980314u, 4197635149u, 1091873113u, 1240127141u, 1064980338u, 2969927074u, 0, TAN_TOLERANCE, 0},
{ 887, 1074333893u, 118603800u, 1105304898u, 4291425557u, 3213440672u, 2883250875u, 0, TAN_TOLERANCE, 0},
{ 888, 3213429165u, 3744663425u, 3212482771u, 953662066u, 3213429247u, 2691908692u, 0, TAN_TOLERANCE, 0},
{ 889, 1085171305u, 3564196690u, 3228101916u, 904305212u, 3221639481u, 1195407422u, 0, TAN_TOLERANCE, 0},
{ 890, 1048333111u, 3566257266u, 3235138829u, 2734275140u, 1048333111u, 3566257295u, 0, TAN_TOLERANCE, 0},
{ 891, 3243948477u, 606044282u, 3241318094u, 2446416887u, 3219064278u, 3185355282u, 0, TAN_TOLERANCE, 0},
{ 892, 1041627284u, 2336116589u, 3197594053u, 2296925138u, 1041627284u, 2336116589u, 0, TAN_TOLERANCE, 0},
{ 893, 1058567659u, 907670625u, 3240769036u, 1827119006u, 1058567659u, 927652723u, 0, TAN_TOLERANCE, 0},
{ 894, 1044467183u, 2818710946u, 3246059905u, 553394170u, 1044467183u, 2818710946u, 0, TAN_TOLERANCE, 0},
{ 895, 3189504094u, 4099522736u, 3232742168u, 3718083858u, 3189504094u, 4099522736u, 0, TAN_TOLERANCE, 0},
{ 896, 1092371276u, 1059279404u, 1080245336u, 175941677u, 1072889821u, 515486077u, 0, TAN_TOLERANCE, 0},
{ 897, 1105189691u, 1650862428u, 1061816101u, 1723201723u, 3218686305u, 2616609059u, 0, TAN_TOLERANCE, 0},
{ 898, 3239012814u, 2462163405u, 3218946201u, 3876535372u, 3219344333u, 2502875662u, 0, TAN_TOLERANCE, 0},
{ 899, 1084392886u, 495844137u, 1073721460u, 772777946u, 3220942669u, 3586727170u, 0, TAN_TOLERANCE, 0},
{ 900, 1052415330u, 458757721u, 3245680321u, 3609892707u, 1052415330u, 458763983u, 0, TAN_TOLERANCE, 0},
{ 901, 3193282956u, 2533012202u, 1079980803u, 3592268374u, 3193282956u, 2533012203u, 0, TAN_TOLERANCE, 0},
{ 902, 3203364780u, 4108274117u, 1063045844u, 571992389u, 3203364780u, 4108938846u, 0, TAN_TOLERANCE, 0},
{ 903, 1090567271u, 3541110973u, 1096296754u, 3118427427u, 3221848883u, 3041741205u, 0, TAN_TOLERANCE, 0},
{ 904, 3193980043u, 1213941007u, 1105433735u, 2172963370u, 3193980043u, 1213941008u, 0, TAN_TOLERANCE, 0},
{ 905, 1096853359u, 272190288u, 1095452370u, 4026581530u, 3220146629u, 3829308268u, 0, TAN_TOLERANCE, 0},
{ 906, 1095583909u, 2843638672u, 1100510986u, 3190536898u, 3223757143u, 2541776483u, 0, TAN_TOLERANCE, 0},
{ 907, 1083757094u, 2014317727u, 3247389683u, 2428462015u, 3221228537u, 1632670009u, 0, TAN_TOLERANCE, 0},
{ 908, 1093976717u, 688442200u, 1047852515u, 3035186380u, 3221648779u, 3546017257u, 0, TAN_TOLERANCE, 0},
{ 909, 1076664212u, 1010095511u, 3221288076u, 405287991u, 3222861453u, 2232630897u, 0, TAN_TOLERANCE, 0},
{ 910, 3252294615u, 2983070435u, 1089546472u, 2907918480u, 3221936746u, 378512360u, 0, TAN_TOLERANCE, 0},
{ 911, 1082988121u, 81928569u, 1056007286u, 2740556321u, 1072918381u, 1311078634u, 0, TAN_TOLERANCE, 0},
{ 912, 1041110867u, 2076689028u, 1081558619u, 3039159031u, 1041110867u, 2076689028u, 0, TAN_TOLERANCE, 0},
{ 913, 1047307438u, 1376882094u, 3211003208u, 1296286481u, 1047307438u, 1376882102u, 0, TAN_TOLERANCE, 0},
{ 914, 1080114314u, 744133164u, 3200943494u, 955832216u, 3218506405u, 2741895831u, 0, TAN_TOLERANCE, 0},
{ 915, 3226290326u, 176522478u, 1069999908u, 2891249491u, 1073785249u, 968808067u, 0, TAN_TOLERANCE, 0},
{ 916, 1043564602u, 3685851715u, 3187829932u, 2363997529u, 1043564602u, 3685851715u, 0, TAN_TOLERANCE, 0},
{ 917, 1040244055u, 3974431579u, 1052505165u, 2589067816u, 1040244055u, 3974431579u, 0, TAN_TOLERANCE, 0},
{ 918, 3191496789u, 3819109588u, 1048561488u, 969143351u, 3191496789u, 3819109588u, 0, TAN_TOLERANCE, 0},
{ 919, 1072639397u, 4246896124u, 1104584799u, 1940097860u, 1073189028u, 394587297u, 0, TAN_TOLERANCE, 0},
{ 920, 1048038468u, 2228686199u, 3220231833u, 777624847u, 1048038468u, 2228686217u, 0, TAN_TOLERANCE, 0},
{ 921, 3231467306u, 4189906558u, 3203004203u, 854242364u, 3217987474u, 2809199807u, 0, TAN_TOLERANCE, 0},
{ 922, 1103910407u, 4089051094u, 3227282692u, 2693170723u, 1072129371u, 3206579039u, 0, TAN_TOLERANCE, 0},
{ 923, 1045883607u, 1278581412u, 3239296746u, 1774588717u, 1045883607u, 1278581413u, 0, TAN_TOLERANCE, 0},
{ 924, 3222372686u, 1794845306u, 1104879344u, 4135865182u, 3221677563u, 3455106662u, 0, TAN_TOLERANCE, 0},
{ 925, 1106449055u, 754938390u, 1061291430u, 2010786993u, 1073861270u, 2475943364u, 0, TAN_TOLERANCE, 0},
{ 926, 1073581409u, 2034303731u, 3240176537u, 314147356u, 3222026453u, 3087782240u, 0, TAN_TOLERANCE, 0},
{ 927, 3231449194u, 567588900u, 3195452230u, 1421366017u, 3222708424u, 1627728438u, 0, TAN_TOLERANCE, 0},
{ 928, 3225089755u, 2708717091u, 1071975971u, 1364590470u, 1074658153u, 719778775u, 0, TAN_TOLERANCE, 0},
{ 929, 3252137283u, 3461956134u, 3207820115u, 1605709634u, 1072185530u, 2879754131u, 0, TAN_TOLERANCE, 0},
{ 930, 1065302996u, 1497124553u, 1051715442u, 916736957u, 1065303036u, 102289035u, 0, TAN_TOLERANCE, 0},
{ 931, 1058468363u, 834914365u, 1064667143u, 2839166298u, 1058468363u, 851408530u, 0, TAN_TOLERANCE, 0},
{ 932, 1057279949u, 2139295776u, 1062816721u, 914592523u, 1057279949u, 2142372604u, 0, TAN_TOLERANCE, 0},
{ 933, 3189636931u, 851569132u, 1058503154u, 1399378677u, 3189636931u, 851569132u, 0, TAN_TOLERANCE, 0},
{ 934, 3233537697u, 3897202342u, 3245382590u, 246600375u, 3216203689u, 401387137u, 0, TAN_TOLERANCE, 0},
{ 935, 3225460308u, 3620429520u, 1055627557u, 229305u, 1074744460u, 4064404770u, 0, TAN_TOLERANCE, 0},
{ 936, 1083958833u, 3641997865u, 3206673888u, 93720614u, 1073787691u, 215264583u, 0, TAN_TOLERANCE, 0},
{ 937, 3227808435u, 32766320u, 1062084905u, 3668443038u, 3217871959u, 3354835440u, 0, TAN_TOLERANCE, 0},
{ 938, 3223298996u, 2039713492u, 3248699388u, 1346210821u, 1077010417u, 482375156u, 0, TAN_TOLERANCE, 0},
{ 939, 1093050016u, 1335820726u, 3191756860u, 1808427032u, 1073512079u, 967050696u, 0, TAN_TOLERANCE, 0},
{ 940, 1061442763u, 650692001u, 1103515670u, 2253348763u, 1061442763u, 1385052594u, 0, TAN_TOLERANCE, 0},
{ 941, 3191395187u, 2372623300u, 3210185343u, 3200572848u, 3191395187u, 2372623300u, 0, TAN_TOLERANCE, 0},
{ 942, 1100796069u, 762317532u, 3194595095u, 3192607437u, 1073352751u, 3603794870u, 0, TAN_TOLERANCE, 0},
{ 943, 1062262701u, 217775356u, 3232827087u, 2969367386u, 1062262701u, 1887701620u, 0, TAN_TOLERANCE, 0},
{ 944, 1057172551u, 3621353969u, 1077994795u, 3873976266u, 1057172551u, 3623759699u, 0, TAN_TOLERANCE, 0},
{ 945, 1091301987u, 268372152u, 3221764390u, 3216978962u, 3215235964u, 874297491u, 0, TAN_TOLERANCE, 0},
{ 946, 3246437611u, 142942404u, 1075322987u, 1746449109u, 3224811534u, 2937642332u, 0, TAN_TOLERANCE, 0},
{ 947, 1104006296u, 496534875u, 3254522293u, 2532372502u, 1072324347u, 3485810959u, 0, TAN_TOLERANCE, 0},
{ 948, 3250225541u, 2999955409u, 3222793392u, 1868977643u, 1069873914u, 3710748236u, 0, TAN_TOLERANCE, 0},
{ 949, 1074319042u, 3353193428u, 3218469191u, 3326244297u, 3215249682u, 302869483u, 0, TAN_TOLERANCE, 0},
{ 950, 1068218799u, 73646871u, 3231442171u, 3711510104u, 1068220577u, 543559658u, 0, TAN_TOLERANCE, 0},
{ 951, 1090483524u, 218135177u, 3198908856u, 3082199105u, 3217418345u, 3997909065u, 0, TAN_TOLERANCE, 0},
{ 952, 1068068480u, 1061628117u, 3248859043u, 86776158u, 1068069852u, 1289410425u, 0, TAN_TOLERANCE, 0},
{ 953, 3208484674u, 938869114u, 1087911145u, 2416710759u, 3208484674u, 1504888383u, 0, TAN_TOLERANCE, 0},
{ 954, 1095576832u, 2970853959u, 3239543429u, 1887505029u, 1072009655u, 2105862278u, 0, TAN_TOLERANCE, 0},
{ 955, 3237728787u, 1337895935u, 1076463812u, 1172733328u, 3222440122u, 597922583u, 0, TAN_TOLERANCE, 0},
{ 956, 1049139928u, 1469010822u, 3229583535u, 551399515u, 1049139928u, 1469010900u, 0, TAN_TOLERANCE, 0},
{ 957, 1074118123u, 1849711538u, 1049053713u, 1744276190u, 3218923673u, 2384358106u, 0, TAN_TOLERANCE, 0},
{ 958, 3242138780u, 2976596113u, 3192137295u, 3033242648u, 1068509184u, 1974852383u, 0, TAN_TOLERANCE, 0},
{ 959, 1098698481u, 876810930u, 3197470945u, 2571587447u, 3220700972u, 2135854542u, 0, TAN_TOLERANCE, 0},
{ 960, 3241770810u, 4007797282u, 3225853845u, 4069319648u, 1074958621u, 2334482095u, 0, TAN_TOLERANCE, 0},
{ 961, 1047279982u, 3840538373u, 1043189552u, 3668774580u, 1047279982u, 3840538380u, 0, TAN_TOLERANCE, 0},
{ 962, 3217611704u, 200857661u, 3229758439u, 3359367736u, 3217632498u, 3651422596u, 0, TAN_TOLERANCE, 0},
{ 963, 3248797869u, 111868139u, 3227902082u, 2366064003u, 3224837493u, 4262218833u, 0, TAN_TOLERANCE, 0},
{ 964, 1044195166u, 3510904416u, 3222131653u, 3822770497u, 1044195166u, 3510904416u, 0, TAN_TOLERANCE, 0},
{ 965, 3242675715u, 789151814u, 1099269239u, 2958956055u, 1071542351u, 2822923563u, 0, TAN_TOLERANCE, 0},
{ 966, 1084679320u, 722163228u, 1105524559u, 1534462169u, 3220227031u, 3860692921u, 0, TAN_TOLERANCE, 0},
{ 967, 1046586062u, 2207037106u, 3208952465u, 1231254630u, 1046586062u, 2207037108u, 0, TAN_TOLERANCE, 0},
{ 968, 3197884060u, 3838689849u, 3198769679u, 1302617170u, 3197884060u, 3838690298u, 0, TAN_TOLERANCE, 0},
{ 969, 1085938906u, 2527556476u, 3240373426u, 124352692u, 3219084764u, 837253910u, 0, TAN_TOLERANCE, 0},
{ 970, 3199540805u, 3502371499u, 1043411944u, 4190072016u, 3199540805u, 3502374638u, 0, TAN_TOLERANCE, 0},
{ 971, 1064676142u, 1798470077u, 3200116917u, 3421833729u, 1064676155u, 2862378974u, 0, TAN_TOLERANCE, 0},
{ 972, 3193514956u, 3653237931u, 3204255012u, 3683870669u, 3193514956u, 3653237932u, 0, TAN_TOLERANCE, 0},
{ 973, 1053588582u, 376530104u, 1073853547u, 565755892u, 1053588582u, 376560924u, 0, TAN_TOLERANCE, 0},
{ 974, 3242503851u, 558292492u, 1051772749u, 4267873474u, 1072080736u, 2047810030u, 0, TAN_TOLERANCE, 0},
{ 975, 3224772709u, 509637100u, 3212030069u, 215050379u, 3217125353u, 3300016857u, 0, TAN_TOLERANCE, 0},
{ 976, 1092057101u, 3571665665u, 3188628584u, 757824767u, 1070419438u, 3036822347u, 0, TAN_TOLERANCE, 0},
{ 977, 3214799337u, 998858159u, 1063077962u, 436029885u, 3214799896u, 3581777165u, 0, TAN_TOLERANCE, 0},
{ 978, 3205946965u, 996300405u, 3193842624u, 80548098u, 3205946965u, 1012629084u, 0, TAN_TOLERANCE, 0},
{ 979, 3228848840u, 3876129407u, 3215332180u, 2226970413u, 1078593226u, 76695377u, 0, TAN_TOLERANCE, 0},
{ 980, 3237608953u, 200013509u, 3224552716u, 414878724u, 3221888552u, 2440171309u, 0, TAN_TOLERANCE, 0},
{ 981, 3230617093u, 309319541u, 1048979765u, 1261662434u, 1071398388u, 1401776306u, 0, TAN_TOLERANCE, 0},
{ 982, 1089252639u, 4062255924u, 3224274128u, 4289485681u, 1068546479u, 529156651u, 0, TAN_TOLERANCE, 0},
{ 983, 3236136084u, 1611969213u, 1053890378u, 3774617276u, 1073236095u, 2860272602u, 0, TAN_TOLERANCE, 0},
{ 984, 1080412763u, 1752164782u, 3239587974u, 612223386u, 1077725009u, 3506920398u, 0, TAN_TOLERANCE, 0},
{ 985, 1041545782u, 2024044989u, 1074932678u, 3259111307u, 1041545782u, 2024044989u, 0, TAN_TOLERANCE, 0},
{ 986, 1053207518u, 2564965629u, 1093571065u, 169360454u, 1053207518u, 2564981166u, 0, TAN_TOLERANCE, 0},
{ 987, 1089599090u, 1860101737u, 3191222372u, 1676437468u, 3220588076u, 3785071853u, 0, TAN_TOLERANCE, 0},
{ 988, 1059802968u, 588387057u, 3192103292u, 2495288012u, 1059802968u, 699627027u, 0, TAN_TOLERANCE, 0},
{ 989, 3193155705u, 659070058u, 1073095700u, 1393632068u, 3193155705u, 659070059u, 0, TAN_TOLERANCE, 0},
{ 990, 3217683263u, 4276187829u, 3217553330u, 1868253275u, 3217706953u, 3445958854u, 0, TAN_TOLERANCE, 0},
{ 991, 3223220272u, 2085481575u, 3215994784u, 800910002u, 3222276535u, 3117891452u, 0, TAN_TOLERANCE, 0},
{ 992, 1056934836u, 1950570756u, 3200582211u, 941022151u, 1056934836u, 1953249555u, 0, TAN_TOLERANCE, 0},
{ 993, 1057530368u, 2075610870u, 3250142022u, 3605152103u, 1057530368u, 2080712643u, 0, TAN_TOLERANCE, 0},
{ 994, 3200839250u, 3792931748u, 3204857863u, 804393211u, 3200839250u, 3792952409u, 0, TAN_TOLERANCE, 0},
{ 995, 3253646370u, 3430071177u, 3226288311u, 3652522729u, 1076083333u, 3008288258u, 0, TAN_TOLERANCE, 0},
{ 996, 3201314702u, 236884699u, 3227874605u, 2193269825u, 3201314702u, 236907314u, 0, TAN_TOLERANCE, 0},
{ 997, 1064936593u, 2744231849u, 1046186036u, 771053722u, 1064936615u, 2553321629u, 0, TAN_TOLERANCE, 0},
{ 998, 1083996036u, 3000189819u, 1096500901u, 2057239777u, 3218072365u, 2964452311u, 0, TAN_TOLERANCE, 0},
{ 999, 1093835581u, 205759408u, 3244643377u, 2702292618u, 3222001752u, 2794274903u, 0, TAN_TOLERANCE, 0},


// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_TAN_H multiple inclusion protection

// EOF tan.h
