#******************************************************************************
#*
#* ====================================================
#* Copyright (C) 1993 by Sun Microsystems, Inc. All rights reserved.
#*
#* Developed at SunPro, a Sun Microsystems, Inc. business.
#* Permission to use, copy, modify, and distribute this
#* software is freely granted, provided that this notice
#* is preserved.
#* ====================================================
#*
#* Copyright (c) 2004 Freescale Semiconductor, Inc
#* All rights reserved.
#*
#* Redistribution and use in source and binary forms, with or without
#* modification, are permitted provided that the following conditions are met:
#*     * Redistributions of source code must retain the above copyright
#*       notice, this list of conditions and the following disclaimer.
#*     * Redistributions in binary form must reproduce the above copyright
#*       notice, this list of conditions and the following disclaimer in the
#*       documentation and/or other materials provided with the distribution.
#*     * Neither the name of Freescale Semiconductor nor the
#*       names of its contributors may be used to endorse or promote products
#*       derived from this software without specific prior written permission.
#*
#* THIS SOFTWARE IS PROVIDED BY Freescale Semiconductor ``AS IS'' AND ANY
#* EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
#* DISCLAIMED. IN NO EVENT SHALL Freescale Semiconductor BE LIABLE FOR ANY
#* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
#* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
#* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
#* ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#*
#*  Functions:    __scalbn
#*
#*  Notes:
#*
#******************************************************************************

#include <powerpc/asm.h>


#define r0 0
#define r1 1
#define r2 2
#define r3 3
#define r4 4
#define r5 5
#define r6 6
#define r7 7
#define r8 8
#define r9 9
#define r10 10
#define r11 11
#define r12 12
#define r13 13
#define r14 14
#define r15 15
#define r16 16
#define r17 17
#define r18 18
#define r19 19
#define r20 20
#define r21 21
#define r22 22
#define r23 23
#define r24 24
#define r25 25
#define r26 26
#define r27 27
#define r28 28
#define r29 29
#define r30 30
#define r31 31


	.extern	__muldf3
	.extern	__adddf3
	.extern	__subdf3
	.section	".text"

/*****************************************************************************************
*	scalbnd -- fast local inmlementation of scalbn() function. returns x*2**n        *
*****************************************************************************************/
	.align  2
ENTRY(scalbn)
#ifdef _SOFT_DOUBLE
#define k r10
#define hx r3
#define lx r4
#define n r5

	stwu	r1, -16(r1)
	mflr	r0
	stw	r0, 20(r1)

	rlwinm.	k, hx, 12, (32-11), 31	# extract exponent

	bne+	cr0, L(scalbnd_check)

	rlwinm	r7, hx, 0, 1, 31
	or.	r7, r7, lx
	beq-	cr0, L(scalbnd_exit)	# x = +-0 -- just return it

	stw	n, 8(r1)
	lis	r5, 0x4350
	li	r6, 0
	bl	JUMP_TARGET(__muldf3)
	rlwinm.	k, hx, 12, (32-11), 31	# extract exponent again

	lwz	n, 8(r1)
	lis	r9, 0xFFFF
	ori	r9, r9, 0x3CB0
	cmpw	cr0, n, r9
	blt-	L(scalbnd_underflow)

L(scalbnd_check):
	cmpwi	cr1, k, 0x7ff
	add	k, k, n
	cmpwi	cr5, k, 0x7fe
	cmpwi	cr6, k, 0
	cmpwi	cr7, k, -54

	beq-	cr1, L(scalbnd_exit)		# NaN or Inf -- just return it
	bgt-	cr5, L(scalbnd_overflow)
	bgt+	cr6, L(scalbnd_normal_result)
	ble-	cr7, L(scalbnd_small_k)

	lis	r8,	0x800f
	ori	r8,	r8,	0xffff
	addi	k,	k,	+54
	slwi	k,	k,	20
	and	hx,	hx,	r8
	or	hx,	hx,	k
	lis	r5, 0x3c90
	li	r6, 0
	bl	JUMP_TARGET(__muldf3)
	b	L(scalbnd_exit)

L(scalbnd_overflow):
	andis.	hx, hx, 0x8000
	oris	hx, hx, 0x7ff0
	li	lx, 0
	b	L(scalbnd_exit)

L(scalbnd_small_k):
	li	r9, 0
	ori	r9, r9, 0xC350
	cmpw	cr0, n, r9
	bgt-	cr0, L(scalbnd_overflow)
L(scalbnd_underflow):
	andis.	hx, hx, 0x8000
	li	lx, 0
	b	L(scalbnd_exit)

L(scalbnd_normal_result):
	rlwimi	hx, k, 20, 1, 11

L(scalbnd_exit):
	lwz	r0, 20(r1)
	mtlr	r0
	addi	r1, r1, +16
	blr
#else
#define tmp r7
#define q0 r0

        /* The main scalbnd code has a custom calling convention.  */
	mflr	r10
	evmergelo	tmp,	r3,	r4
	mr	q0,	r5
	bl	L(scalbnd_entry)
	/* Results are returned in r7.  */
	mtlr	r10
	evmergehi	r3,	r7,	r7
	mr	r4,	r7
	blr

L(scalbnd_entry):
	evmergelohi	r6,	tmp,tmp		# r6 = HI(tmp)
	rlwinm.	r6,	r6,	12,(32-11),31	# extract exponent
	bne+	cr0,	L(scalbnd_check)

	evmergelohi	r6,	tmp,tmp		# r6 = HI(tmp)
	rlwinm	r6,	r6,	0,1,31		# |r6|
	or.	r6,	r6,	r7
	beqlr-	cr0				# tmp = +-0 -- just return it

	lis	r6,	0xffff
	ori	r6, r6,	0x3cb0
	cmpw	cr0,	q0,	r6
	blt-	cr0,	L(scalbnd_underflow)

	lis	r6,	0x4350
	evmergelohi	r6,	r6,	r6
	li	r6,	0
	efdmul		tmp,	tmp,	r6

	evmergelohi	r6,	tmp,tmp		# r6 = HI(tmp)
	rlwinm.	r6,	r6,	12,(32-11),31	# extract exponent
	addi	r6,	r6,	-54

L(scalbnd_check):
	cmpwi	cr0,	r6,	0x7ff
	beqlr-	cr0				# NaN or Inf -- just return it

	add	r6,	r6,	q0
	cmpwi	cr5,	r6,	0x7fe
	cmpwi	cr6,	r6,	0
	cmpwi	cr7,	r6,	-54

	bgt-	cr5,	L(scalbnd_overflow)
	bgt+	cr6,	L(scalbnd_normal_result)
	ble-	cr7,	L(scalbnd_small_k)

	addi	r6,	r6,	+54
	evmergelohi	r7,	r7,r7
	rlwimi	r7,	r6,	20,1,11
	evmergelohi	r7,	r7,r7

	lis	r6,	0x3c90
	evmergelohi	r6,	r6,r6
	li	r6,	0
	efdmul	tmp,	tmp,	r6
	blr

L(scalbnd_overflow):
	andis.	r6,	r6,	0x8000
	oris	r6,	r6,	0x7ff0
	li	r7,	0
	evmergelo	tmp,	r6,r7		# tmp = +-Inf
	blr

L(scalbnd_small_k):
	li	r6,	0
	ori	r6,	r6,	0xc350
	cmpw	cr0,	q0,	r6
	bgt-	cr0,	L(scalbnd_overflow)
L(scalbnd_underflow):
	andis.	r6,	r6,	0x8000
	li	r7,	0
	evmergelo	tmp,	r6,r7		# tmp = +-0
	blr

L(scalbnd_normal_result):
	evmergelohi	r7,	r7,r7
	rlwimi	r7,	r6,	20,1,11
	evmergelohi	r7,	r7,r7
	blr
#endif

END(scalbn)
