//==========================================================================
//
//      evmcan_timer.c
//
//      HAL board support code for timer on EASYCAN3 (EVMCAN)
//
//==========================================================================
//####COPYRIGHTBEGIN####
//
// -------------------------------------------
// The contents of this file are subject to the Cygnus eCos Public License
// Version 1.0 (the "License"); you may not use this file except in
// compliance with the License.  You may obtain a copy of the License at
// http://sourceware.cygnus.com/ecos
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the
// License for the specific language governing rights and limitations under
// the License.
//
// The Original Code is eCos - Embedded Cygnus Operating System, released
// September 30, 1998.
//
// The Initial Developer of the Original Code is Cygnus.  Portions created
// by Cygnus are Copyright (C) 1998,1999 Cygnus Solutions.  All Rights Reserved.
// -------------------------------------------
//
//####COPYRIGHTEND####
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    Eric MINIERE
//   based on Europe Technologies library code
// Contributors: Eric MINIERE
// Date:         2001-07-17
// Purpose:      HAL board support
// Description:  Implementations of HAL timer
//
//####DESCRIPTIONEND####
//
//===========================================================================*/

#include <pkgconf/hal.h>

#include <cyg/infra/cyg_type.h>         // base types
#include <cyg/infra/cyg_trac.h>         // tracing macros
#include <cyg/infra/cyg_ass.h>          // assertion macros

#include <cyg/hal/hal_io.h>             // IO macros
#include <cyg/hal/hal_arch.h>           // Register state info
#include <cyg/hal/hal_intr.h>
#include <cyg/hal/hal_tc.h>
#include <cyg/hal/hal_platform_ints.h>  // IT vectors

static cyg_uint32 _period;

volatile CSP_RTOT3C_T *RTOTimers = RTOTC0_BASE_ADDRESS;
static cyg_uint32 _period;

#define RTOtc RTOTimers->CHANNEL[N0CHANNEL]


void hal_clock_initialize(cyg_uint32 period)
{
   cyg_uint32 i;

   RTOtc.ECR =TIMER;// Clock enable pour timer periph
   /* reset periph  timer*/
   RTOtc.CR =CHANNEL_SWRST;

   RTOtc.ECR =PIO;// Clock enable pour pio periph
   /* Specify pin_mask are not used as PIO pins */
   RTOtc.PDR =TCLK;

   RTOtc.DCR =PIO;// Clock disable pour pio periph
   /* disable counter */
   RTOtc.CR = CLKDIS;
   /* disable all timer irqs */
   RTOtc.IDR = 0xFFFFFFFF;
   hal_interrupt_set_level(CYGNUM_HAL_INTERRUPT_RTC, 6); // prio fixed to 6 (->7 higher)
   hal_interrupt_configure(CYGNUM_HAL_INTERRUPT_RTC, 0, 1);

   // Read Status Register
   i = RTOtc.SR;
   RTOtc.SR = 0;

   // on fixe la period du tick ici : non configurable !!!
   period = (CPU_FREQ/1024)/CLOCK_FREQ;
   RTOtc.RC = period;     /* Clock divider */

   /* Define TC mode */
   RTOtc.MR = CLKS_MCK1024 | WAVE | CPCTRG | CPCSTOP ;

   RTOtc.IER = CPCS_int;   // enable rc_compare interupt

   /* Start TC */
   RTOtc.CR =  CLKEN|SWTRG;

   _period = period;
}

void hal_clock_reset(cyg_uint32 vector, cyg_uint32 period)
{
   register cyg_uint32 value;

   value = RTOtc.SR;  // Read Status Register

   RTOtc.CR = CLKEN | SWTRG;
}

void hal_clock_read(cyg_uint32 *pvalue)
{
   register cyg_uint32 value;
   value = RTOtc.SR;   // Read Status Register
   *pvalue = RTOtc.CV;   // Note: counter is only 16 bits

}

/* End of hal_timer.c */




