#ifndef CYGONCE_ARM_AT91_SERIAL_H
#define CYGONCE_ARM_AT91_SERIAL_H

/****************************************************************************
* USART Module structure
****************************************************************************/
typedef struct
{
    cyg_uint32  PER;               /* PIO Enable Register            */
    cyg_uint32  PDR;               /* PIO Disable Register           */
    cyg_uint32  PSR;               /* PIO Status Register            */
    cyg_uint32  ReservedA;
    cyg_uint32  OER;               /* Output Enable Register         */
    cyg_uint32  ODR;               /* Output Disable Register        */
    cyg_uint32  OSR;               /* Output Status Register         */
    cyg_uint32  ReservedB[5];
    cyg_uint32  SODR;              /* Set Output Data Register       */
    cyg_uint32  CODR;              /* Clear Output Data Register     */
    cyg_uint32  ODSR;              /* Output Data Status Register    */ 
    cyg_uint32  PDSR;              /* Pin Data Status Register       */
    cyg_uint32  MDER;              /* Multi-Driver Enable Register   */
    cyg_uint32  MDDR;              /* Multi-Driver Disable Register  */
    cyg_uint32  MDSR;              /* Multi-Driver Status Register   */
    cyg_uint32  ReservedC;
    cyg_uint32  ECR;               /* Enable Clock Register          */
    cyg_uint32  DCR;               /* Disable Clock Register         */
    cyg_uint32  PMSR;              /* Power Managt Status Register   */
    cyg_uint32  ReservedD;
    cyg_uint32  CR;                /* Control Register               */
    cyg_uint32  MR;                /* Mode Register                  */
    cyg_uint32  ReservedE[2];
    cyg_uint32  SR;                /* Status Register                */
    cyg_uint32  IER;               /* Interrupt Enable Register      */
    cyg_uint32  IDR;               /* Interrupt Disable Register     */
    cyg_uint32  IMR;               /* Interrupt Mask Register        */
    cyg_uint32  RHR;               /* Receive Holding Register       */
    cyg_uint32  THR;               /* Transmit Holding Register      */
    cyg_uint32  BRGR;              /* Baud Rate Generator Register   */
    cyg_uint32  RTOR;              /* Receiver Timeout Register      */
    cyg_uint32  TTGR;              /* Transmitter Timeguard Register */
} EASYCAN_USART_REGS;

/****************************************************************************
* PIO controller block PER, PDR, PSR, OER, ODR, OSR, SODR, CODR, ODSR,
*                      PDSR, MDER, MDDR, MDSR, SR, IER, IDR, IMR
****************************************************************************/
#define SCK                (0x01 << 16)  // SCK
#define TXD                (0x01 << 17)  // TXD
#define RXD                (0x01 << 18)  // RXD

/****************************************************************************
* PMC controller block ECR, DCR, PMSR
****************************************************************************/
#define PIO                (0x01 << 0)   // PIO
#define USART              (0x01 << 1)   // USART

/****************************************************************************
* Control register  CR
****************************************************************************/
#define SWRST              (0x01 << 0)   // USART software reset
#define RSTRX              (0x01 << 2)   // Reset receiver
#define RSTTX              (0x01 << 3)   // Reset transmitter
#define RXEN               (0x01 << 4)   // Receiver enable
#define RXDIS              (0x01 << 5)   // Receiver disable
#define TXEN               (0x01 << 6)   // Transmitter enable
#define TXDIS              (0x01 << 7)   // Transmitter disable
#define RSTSTA             (0x01 << 8)   // Reset status bits
#define STTBRK             (0x01 << 9)   // Start break
#define STPBRK             (0x01 << 10)  // Stop break
#define STTTO              (0x01 << 11)  // Start timeout
#define SENDA              (0x01 << 12)  // Send address

/****************************************************************************
* Mode register  MR
****************************************************************************/
#define USCLKS             (0x03 << 4)   // Clock selection mask
#define USCLKS_MCKI        (0x00 << 4)   // Internal clock MCKI
#define USCLKS_MCKI_8      (0x01 << 4)   // Internal clock MCKI/8
#define USCLKS_SCK         (0x02 << 4)   // External clock

#define CHRL               (0x03 << 6)   // Byte length
#define CHRL_5             (0x00 << 6)   // Five bits
#define CHRL_6             (0x01 << 6)   // Six bits
#define CHRL_7             (0x02 << 6)   // Seven bits
#define CHRL_8             (0x03 << 6)   // Heigh bits

#define SYNC               (0x01 << 8)   // Synchronous mode
#define ASYNC              (0x00 << 8)   // Asynchronous mode

#define PAR                (0x07 << 9)   // Parity mode
#define PAR_EVEN           (0x00 << 9)   // Even parity
#define PAR_ODD            (0x01 << 9)   // Odd parity
#define PAR_SPACE          (0x02 << 9)   // Space parity (forced to 0)
#define PAR_MARK           (0x03 << 9)   // Mark parity (forced to 1)
#define PAR_NO             (0x04 << 9)   // No parity
#define PAR_MULTIDROP      (0x06 << 9)   // Multi drop parity
 
#define IDLE               (0x01 << 10)  // Idle (J1708 Protocol)
#define IDLEFLAG           (0x01 << 11)  // Idle Flag (J1708 Protocol)

#define NBSTOP             (0x03 << 12)  // Stop bit number
#define NBSTOP_1           (0x00 << 12)  // 1 stop bit
#define NBSTOP_15          (0x01 << 12)  // 1.5 stop bit
#define NBSTOP_2           (0x02 << 12)  // 2 stop bit

#define CHMODE             (0x03 << 14)  // Channel mode
#define CHMODE_NORMAL      (0x00 << 14)  // Normal channel
#define CHMODE_AUTO        (0x01 << 14)  // Automatic echo channel
#define CHMODE_LOCAL       (0x02 << 14)  // Local loopback channel
#define CHMODE_REMOTE      (0x03 << 14)  // Remote loopback channel

#define MODE9              (0x01 << 17)  // 9 bit mode
#define MODE8              (0x00 << 17)  // 8 bit mode
#define CLKO               (0x01 << 18)  // Clock output
#define CLKI               (0x00 << 18)  // Clock input

/****************************************************************************
* Channel Status and Interrupt registers  IER, IDR, IMR, SR
****************************************************************************/
#define RXRDY              (0x01 << 0)   // Receiver ready
#define TXRDY              (0x01 << 1)   // Transmitter ready
#define RXBRK              (0x01 << 2)   // Receiver break
#define ENDRX              (0x01 << 3)   // End of receiver PDC transfer
#define ENDTX              (0x01 << 4)   // End of transmitter PDC transfer
#define USOVRE             (0x01 << 5)   // Overrun error
#define FRAME              (0x01 << 6)   // Framing error
#define PARE               (0x01 << 7)   // Parity error
#define TIMEOUT            (0x01 << 8)   // Receiver time out
#define TXEMPTY            (0x01 << 9)   // Transmitter empty

/****************************************************************************
* Time out 
****************************************************************************/
#define TRANSMIT_TIMEOUT   0xFF
#define RECEIVE_TIMEOUT    0xFF
#define US_BDR_9600        1

#define EASYCAN_USART0_BASE        0xFFFA8000
#define EASYCAN_USART1_BASE        0xFFFAC000
#define EASYCAN_USART2_BASE        0xFFFB0000


static unsigned char select_word_length[] = {
    CHRL_5,    // 5 bits / word (char)
    CHRL_6,
    CHRL_7,
    CHRL_8
};

static unsigned char select_stop_bits[] = {
    0,
    NBSTOP_1,	// 1 stop bit
    NBSTOP_15,	// 1.5 stop bit
    NBSTOP_2		// 2 stop bits
};

static unsigned char select_parity[] = {
    PAR_NO,	// No parity
    PAR_EVEN,	// Even parity
    PAR_ODD,	// Odd parity
    PAR_MARK,	// Mark parity
    PAR_SPACE,	// Space parity
};

/*
Baud Rate = Selected Clock  (32.768Mhz)
	    --------------
	       16 x CD (table below)
*/

static unsigned short select_baud[] = {
    0,	    // Unused
    40960,  // 50
    27307,  // 75
    18618,  // 110
    15227,  // 134.5
    13653,  // 150
    10240,  // 200
    6827,   // 300
    3413,   // 600
    1707,   // 1200
    1138,   // 1800
    853,    // 2400
    569,    // 3600
    427,    // 4800
    284,    // 7200
    213,    // 9600
    142,    // 14400
    107,    // 19200
    53,	    // 38400
    36,	    // 57600
    18,	    // 115200
    9,	    // 230400
};

#endif // CYGONCE_ARM_EASYCAN_SERIAL_H
