/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtSetSensitive()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

extern char *event_names[];

/*
** Registered procedure Proc
*/
void XtEVT_Proc(w, client_data, event, continue_to_dispatch)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *continue_to_dispatch;
{
	sprintf(ebuf, "ERROR: Event %s invoked XtEVT_Proc", event_names[event->type]);
	tet_infoline(ebuf);
	tet_result(TET_FAIL);
	exit(0);
}

/* procedure XtTMO_Proc to be invoked */
void XtTMO_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	exit(0);
}


#define T_XtSetSensitive	1
char    *TestName = "XtSetSensitive";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Boolean status;
Widget rowcolw_good;
Widget labelw_good;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtSetSensitive-1.(A)");
	report_assertion("When sensitive is True a successful call to void");
	report_assertion("XtSetSensitive(w, sensitive) shall set the sensitive field");
	report_assertion("of the widget w to True.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tstsenstv1", "XtSetSensitive");
	tet_infoline("PREP: Create rowcolw_good widget in boxw1 widget");
	rowcolw_good = (Widget) CreateRowColWidget(boxw1);
	tet_infoline("PREP: Create labelw_good widget in rowcolw_good widget");
	labelw_good = (Widget)CreateLabelWidget("Hello", rowcolw_good);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Set Sensitivity of labelw_good widget to True.");
	XtSetSensitive(labelw_good, True);
	tet_infoline("TEST: Labelw_good sensitivity is set to True");
	status = XtIsSensitive(labelw_good);
	check_dec(True, status, "XtIsSensitive");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.365516 */
/* End of included file Mdefcode.tmc.365516 */

static void t002(){

Boolean status;
Widget rowcolw_good;
Widget labelw_good;
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtSetSensitive-2.(A)");
	report_assertion("When sensitive is True a successful call to void");
	report_assertion("XtSetSensitive(w, sensitive) shall set the sensitive field");
	report_assertion("of the widget w to False.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tstsenstv2", "XtSetSensitive");
	tet_infoline("PREP: Create rowcolw_good widget in boxw1 widget");
	rowcolw_good = (Widget) CreateRowColWidget(boxw1);
	tet_infoline("PREP: Create labelw_good widget in rowcolw_good widget");
	labelw_good = (Widget)CreateLabelWidget("Hello", rowcolw_good);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Set Sensitivity of labelw_good widget to False.");
	XtSetSensitive(labelw_good, False);
	tet_infoline("TEST: Labelw_good sensitivity is set to False");
	status = XtIsSensitive(labelw_good);
	check_dec(False, status, "XtIsSensitive");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.365516 */
/* End of included file Mdefcode.tmc.365516 */

/* Including from file Mdefcode.tmc.365516 */
static void t003(){

pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtSetSensitive-3.(B)");
	report_assertion("A successful call to void XtSetSensitive(w, sensitive)");
	report_assertion("shall call the set_values procedures of the specified");
	report_assertion("widget's class and its superclasses in");
	report_assertion("superclass-to-subclass order.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.365516 */

/* Including from file Mdefcode.tmc.365516 */
static void t004(){

pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtSetSensitive-4.(B)");
	report_assertion("A successful call to void XtSetSensitive(w, sensitive) when");
	report_assertion("the widget w has any non-NULL set_values_hook fields shall");
	report_assertion("call the procedures specified by those fields immediately");
	report_assertion("following the call to corresponding set_values procedure.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.365516 */

static void t005(){

Boolean status;
Widget rowcolw_good;
Widget labelw_good;
Boolean ancestor_sensitive;
pid_t pid2;
pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtSetSensitive-5.(A)");
	report_assertion("When sensitive is True, the class of the widget is a");
	report_assertion("subclass of Composite, and the widget's ancestor_sensitive");
	report_assertion("field is True a call to void XtSetSensitive(w, sensitive)");
	report_assertion("shall set the ancestor_sensitive of each child widget to");
	report_assertion("True and set the ancestor_sensitive field of each normal");
	report_assertion("descendant that is now sensitive to True.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tstsenstv3", "XtSetSensitive");
	tet_infoline("PREP: Create rowcolw_good widget in boxw1 widget");
	rowcolw_good = (Widget) CreateRowColWidget(boxw1);
	tet_infoline("PREP: Create labelw_good widget in rowcolw_good widget");
	labelw_good = (Widget)CreateLabelWidget("Hello", rowcolw_good);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Set ancestor_sensitive of labelw_good to False.");
	XtVaSetValues(rowcolw_good, XtNancestorSensitive, True, NULL);
				XtVaSetValues(rowcolw_good, XtNsensitive, False, NULL);
	XtVaSetValues(labelw_good, XtNancestorSensitive, False, NULL);
	tet_infoline("PREP: Set Sensitivity of parent rowcolw_good widget to True.");
	XtSetSensitive(rowcolw_good, True);
	tet_infoline("TEST: Rowcolw_good sensitivity is set to True");
	status = XtIsSensitive(rowcolw_good);
	check_dec(True, status, "XtIsSensitive");
	tet_infoline("TEST: Child widget labelw_good ancestor_sensitive is set to True");
	XtVaGetValues(labelw_good, XtNancestorSensitive, &ancestor_sensitive, NULL);
	if (ancestor_sensitive != True) {
		sprintf(ebuf, "ERROR: %s %s %d", "Expected child's ancestor_sensitivity to True(%d), Received", True, ancestor_sensitive);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.365516 */
/* End of included file Mdefcode.tmc.365516 */

static void t006(){

Boolean status;
Widget rowcolw_good;
Widget labelw_good;
Boolean ancestor_sensitive;
int event_mask;
pid_t pid2;
pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtSetSensitive-6.(A)");
	report_assertion("When sensitive is False and the class of the widget is a");
	report_assertion("subclass of Composite a call to void XtSetSensitive(w,");
	report_assertion("sensitive) shall recursively traverse down the children tree");
	report_assertion("and set ancestor_sensitive field of each widget to False.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tstsenstv4", "XtSetSensitive");
	tet_infoline("PREP: Create rowcolw_good widget in boxw1 widget");
	rowcolw_good = (Widget) CreateRowColWidget(boxw1);
	tet_infoline("PREP: Create labelw_good widget in rowcolw_good widget");
	labelw_good = (Widget)CreateLabelWidget("Hello", rowcolw_good);
	tet_infoline("PREP: Register XtEVT_Proc to handle events to rowcolw_good");
	event_mask = ( KeyPressMask | KeyRelease | ButtonPressMask |
			ButtonReleaseMask);
	XtAddEventHandler(rowcolw_good,
		 event_mask,
		 False,
		 XtEVT_Proc,
		 (XtPointer)NULL
		 );
	tet_infoline("TEST: Ancestor_sensitive of labelw_good is True.");
	ancestor_sensitive = 0;
	XtVaGetValues(labelw_good, XtNancestorSensitive, &ancestor_sensitive, NULL);
	if (ancestor_sensitive != True) {
		sprintf(ebuf, "ERROR: Expected %s of %d, got %d", XtNancestorSensitive, True, ancestor_sensitive);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("PREP: Set Sensitivity of parent rowcolw_good widget to False.");
	XtSetSensitive(rowcolw_good, False);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Rowcolw_good sensitivity is set to False");
	status = XtIsSensitive(rowcolw_good);
	check_dec(False, status, "rowcolw_good sensitivity");
	tet_infoline("TEST: Labelw_good sensitivity is set to False");
	status = XtIsSensitive(labelw_good);
	check_dec(False, status, "labelw_good sensitivity");
	tet_infoline("TEST: Child widget labelw_good ancestor_sensitive is set to FDalse");
	XtVaGetValues(labelw_good, XtNancestorSensitive,
			&ancestor_sensitive, NULL);
	if (ancestor_sensitive != False) {
			sprintf(ebuf, "ERROR: Incorrect %s, wanted %d got %d", XtNancestorSensitive, False, ancestor_sensitive);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("PREP: Register timeout procedure");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc, topLevel);
	tet_infoline("TEST: Rowcolw_good widget does not respond to events");
	send_event(rowcolw_good, ButtonPress, ButtonPressMask, TRUE);
	send_event(rowcolw_good, ButtonRelease, ButtonReleaseMask,TRUE);
	send_event(rowcolw_good, KeyPress, KeyPressMask, TRUE);
	send_event(rowcolw_good, KeyRelease, KeyReleaseMask, TRUE);
	XtAppMainLoop(app_ctext);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.365516 */
/* End of included file Mdefcode.tmc.365516 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
