/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   int
 *   XtGrabPointer()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

static void
analyse_events(w, w1)
Widget w, w1;
{
	XtAppContext app_context;
	Display *display;
	XEvent loop_event;
	Widget widget;
	int ret_value;
	Window window;
	widget = XtParent(w);
	app_context = XtWidgetToApplicationContext(w);
	display = XtDisplay(w);
	window = XtWindow(w);
	for (;;) {
	 XtAppNextEvent(app_context, &loop_event);
	 if (loop_event.type == Expose && loop_event.xexpose.window == window){
		tet_infoline("TEST: Grab the pointer.");
		ret_value = XtGrabPointer(w, True, FocusChangeMask, GrabModeAsync, GrabModeAsync, window, None, CurrentTime);
		if (ret_value != GrabSuccess) {
			sprintf(ebuf, "ERROR: XtGrabPointer Call Failed, return value = %d", ret_value);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
		}
		exit(0);
	 }
	 XSync(display, False);
	 XtDispatchEvent(&loop_event);
	} /* end for */
}


#define T_XtGrabPointer	1
char    *TestName = "XtGrabPointer";



static int 	ValueReturn;

int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Widget test_widget;
int status;
int ret_value;
Display *display;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtGrabPointer-1.(A)");
	report_assertion("When the widget widget is realized a successful call to int");
	report_assertion("XtGrabPointer(widget, owner_events, event_mask,");
	report_assertion("pointer_mode, keyboard_mode, confine_to, cursor, time) shall");
	report_assertion("call XGrabPointer to make an active grab of the pointer for");
	report_assertion("the specified widget.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tgrbpoint1", "XtGrabPointer");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	analyse_events(panedw, rowcolw);
	LKROF(pid2, AVSXTTIMEOUT-10);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.364356 */
/* End of included file Mdefcode.tmc.364356 */

static void t002(){

Window window;
int ret_value;
Widget labelw_good;
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtGrabPointer-2.(A)");
	report_assertion("A call to int XtGrabPointer(widget, owner_events,");
	report_assertion("event_mask, pointer_mode, keyboard_mode, confine_to, cursor,");
	report_assertion("time) when the widget widget is not realized shall not");
	report_assertion("activate the pointer grab and shall return GrabNotViewable.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tgrbpoint2", "XtGrabPointer");
	tet_infoline("PREP: Create labelw_good widget in boxw1 widget");
	labelw_good = (Widget) CreateLabelWidget("Hello", boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Try grabbing pointer widget not realized");
	XtUnrealizeWidget(labelw_good);
	ret_value = XtGrabPointer(labelw_good,True,KeyPress,
		 GrabModeAsync, GrabModeAsync, None,
		 None, CurrentTime);
	tet_infoline("TEST: Return value is GrabNotViewable.");
	check_dec((long)GrabNotViewable, ret_value, "GrabNotViewable");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.364356 */
/* End of included file Mdefcode.tmc.364356 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
