/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtGetApplicationNameAndClass()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;


#define T_XtGetApplicationNameAndClass	1
char    *TestName = "XtGetApplicationNameAndClass";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Display *display_good;
String name_good, class_good;
int argcount = 0;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtGetApplicationNameAndClass-1.(A)");
	report_assertion("A call to void XtGetApplicationNameAndClass(display,");
	report_assertion("name_return, class_return) shall return the application name");
	report_assertion("and the application class passed to XtDisplayInitialize for");
	report_assertion("the display display in name_return and class_return");
	report_assertion("respectively.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tgtapnacl1", "XtGetApplicationNameAndClass");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get the application name and class");
	display_good = XtDisplay(topLevel);
	XtGetApplicationNameAndClass(display_good, &name_good, &class_good );
	tet_infoline("TEST: Name and class are valid.");
	check_str("VSW5 X Toolkit Tests", name_good, "Name of Application");
	check_str("Tgtapnacl1", class_good, "Class of Application");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.362208 */
/* End of included file Mdefcode.tmc.362208 */

/* Including from file Mdefcode.tmc.362208 */
static void t002(){

pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtGetApplicationNameAndClass-2.(B)");
	report_assertion("The contents of name_return and class_return on a call to");
	report_assertion("void XtGetApplicationNameAndClass(display, name_return,");
	report_assertion("class_return) when the display display was never");
	report_assertion("initialized.");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.362208 */

/* Including from file Mdefcode.tmc.362208 */
static void t003(){

pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtGetApplicationNameAndClass-3.(B)");
	report_assertion("The contents of name_return and class_return on a call to");
	report_assertion("void XtGetApplicationNameAndClass(display, name_return,");
	report_assertion("class_return) when the display display has been closed.");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.362208 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
