/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtInstallAllAccelerators()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

extern char *event_names[];

void XtACT_Proc(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	avs_set_event(1,1);
	tet_infoline("TEST: Accelerator is invoked in source widget rowcolw");
	if (w != rowcolw) {
		tet_infoline("ERROR: Accelerator not invoked on correct widget");
		tet_result(TET_FAIL);
	}
	exit(0);
}


#define T_XtInstallAllAccelerators	1
char    *TestName = "XtInstallAllAccelerators";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

pid_t pid2;
int status;
XtAccelerators accelerator;
static char accel_good[] = "#override \n\
	<ButtonPress>:	XtACT_Proc()";
static XtActionsRec actions[] = {
	 {"XtACT_Proc",	(XtActionProc)XtACT_Proc},
};
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtInstallAllAccelerators-1.(A)");
	report_assertion("A successful call to void");
	report_assertion("XtInstallAccelerators(destination, source) shall merge the");
	report_assertion("accelerators specified by the XtNaccelerators resource value");
	report_assertion("for the widget source and all its descendants into the");
	report_assertion("translation table of the widget destination such that event");
	report_assertion("sequences that occur in the destination widget will cause");
	report_assertion("the source widget or its descendant's accelerator actions to");
	report_assertion("be executed when the specified widget is sensitive.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tinaaclrt1", "XtInstallAllAccelerators");
	tet_infoline("PREP: Register action table.");
	XtAppAddActions(app_ctext, actions, 1);
	tet_infoline("PREP: Parse accelerator table.");
	accelerator = XtParseAcceleratorTable(accel_good);
	if (accelerator == (XtAccelerators)NULL) {
		sprintf(ebuf, "ERROR: Expected not NULL");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	/*
	** install acclerator on rowcolw widget
	*/
	tet_infoline("PREP: Set accelerator table for rowcolw.");
	XtVaSetValues(rowcolw, XtNaccelerators, accelerator, (char *)NULL);
	tet_infoline("PREP: Install all accelerators from rowcolw to boxw1");
	XtInstallAllAccelerators(boxw1, rowcolw);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send event to boxw1 to invoke accelerator");
	send_event(boxw1, ButtonPress, ButtonPressMask, TRUE);
	XtAppMainLoop(app_ctext);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Accelerator was invoked.");
	status = avs_get_event(1);
	check_dec(1, status, "XtACT_Proc invoked status");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.361116 */
/* End of included file Mdefcode.tmc.361116 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
