/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XChangeWindowAttributes(display, w, valuemask, attributes)
 *   Display	*display;
 *   Window	w;
 *   unsigned long	valuemask;
 *   XSetWindowAttributes	*attributes;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XChangeWindowAttributes	1
char    *TestName = "XChangeWindowAttributes";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w


/*
 * Arguments to the XChangeWindowAttributes function
 */
static Display	*display;
static Window	w;
static unsigned long	valuemask;
static XSetWindowAttributes	*attributes;



static XSetWindowAttributes	Atts;
static Window  parent;
static int     x = 50;
static int     y = 60;
static unsigned int    border_width = 2;
static int     depth;
static Visual  *visual;


#include	"X11/cursorfont.h"


static int
checkatts(setatts, getatts, vmask)
XSetWindowAttributes	*setatts;
XWindowAttributes	*getatts;
unsigned long 	vmask;
{
int 	pass = 0, fail = 0;

	/*
	 * Maybe we should alway check everything??? (No vmask)
	 */
	if ((vmask&CWBitGravity) && setatts->bit_gravity != getatts->bit_gravity) {
		report("bit_gravity got %s, expected %s",
			bitgravityname(getatts->bit_gravity),
			bitgravityname(setatts->bit_gravity));
		FAIL;
	} else
		CHECK;

	if ((vmask&CWWinGravity) && setatts->win_gravity != getatts->win_gravity) {
		report("window_gravity got %s, expected %s",
			wingravityname(getatts->win_gravity),
			wingravityname(setatts->win_gravity));
		FAIL;
	} else
		CHECK;

	if ((vmask&CWBackingStore) && setatts->backing_store != getatts->backing_store) {
		report("backing_store got %s, expected %s",
			backingstorename(getatts->backing_store),
			backingstorename(setatts->backing_store));
		FAIL;
	} else
		CHECK;

	if ((vmask&CWBackingPlanes) && setatts->backing_planes != getatts->backing_planes) {
		report("backing_planes got 0x%x, expected 0x%x",
			getatts->backing_planes,
			setatts->backing_planes);
		FAIL;
	} else
		CHECK;

	if (setatts->backing_pixel != getatts->backing_pixel) {
		report("backing_pixel got 0x%x, expected 0x%x",
			getatts->backing_pixel,
			setatts->backing_pixel);
		FAIL;
	} else
		CHECK;

	if ((vmask&CWSaveUnder) && setatts->save_under != getatts->save_under) {
		report("save_under got %s, expected %s",
			boolname(getatts->save_under),
			boolname(setatts->save_under));
		FAIL;
	} else
		CHECK;

	if ((vmask&CWEventMask) && setatts->event_mask != getatts->your_event_mask) {
		report("event_mask got %s, expected %s",
			eventmaskname(getatts->your_event_mask),
			eventmaskname(setatts->event_mask));
		FAIL;
	} else
		CHECK;

	if ((vmask&CWDontPropagate) && setatts->do_not_propagate_mask != getatts->do_not_propagate_mask) {
		report("do_not_propagate_mask got %s, expected %s",
			eventmaskname(getatts->do_not_propagate_mask),
			eventmaskname(setatts->do_not_propagate_mask));
		FAIL;
	} else
		CHECK;

	if ((vmask&CWOverrideRedirect) && setatts->override_redirect != getatts->override_redirect) {
		report("override_redirect got %s, expected %s",
			boolname(getatts->override_redirect),
			boolname(setatts->override_redirect));
		FAIL;
	} else
		CHECK;

	if ((vmask&CWColormap) && setatts->colormap != getatts->colormap) {
		report("colormap got 0x%x, expected 0x%x",
			getatts->colormap,
			setatts->colormap);
		FAIL;
	} else
		CHECK;

	if (fail == 0 && pass == 10)
		return(0);
	else {
		if (fail)
			return(fail);
		else
			delete("Path check error in checkatts");
	}
	return(-1);
}




static void
setinonly()
{
	w = iponlywin(Dsp);
}


#define XCWA_NORMAL	0
#define XCWA_DEFCOLMAP	1
#define	XCWA_GRAVITY	2
#define XCWA_VISDEPTH	3

static Window
makeinout(mio_parent, mio_visual, mio_depth, mio_mode)
Window mio_parent;
Visual *mio_visual;
int	mio_depth;
int	mio_mode;
{
	Display	*mio_display;
	int	mio_x, mio_y;
	unsigned int	mio_width, mio_height;
	unsigned int	mio_border_width;
	unsigned int	mio_class;
	unsigned long	mio_valuemask;
	XSetWindowAttributes	*mio_aptr;
	XSetWindowAttributes	mio_a;
	

/* If we are passed a parent of None, then we need to set it ourselves. */
	if(mio_parent == None)
	{
		mio_parent = DRW(Dsp);
	}

	mio_display = Dsp;
	mio_x = 50;
	mio_y = 60;
	mio_width = 20;
	mio_height = 17;
	mio_border_width = 2;
	mio_class = InputOutput;
	mio_valuemask = 0;
	mio_aptr = &mio_a;

	switch(mio_mode)
	{
		case	XCWA_DEFCOLMAP:
			mio_valuemask = CWColormap;
			mio_a.colormap = makecolmap(mio_display, mio_visual, AllocNone);
			break;

		case	XCWA_GRAVITY:
			mio_valuemask = CWWinGravity;
			mio_a.win_gravity = NorthWestGravity;
			break;

                /*
                 * This new case is used whenever a window is to be created
                 * which has a different visual/depth than the parent window.
                 * It will ensure that all required window attributes are set
                 * to prevent a BadMatch error on window creation.
                 */
		case    XCWA_VISDEPTH:
			mio_valuemask = CWBorderPixel | CWColormap;
			mio_a.border_pixel = 0;
			mio_a.colormap = makecolmap(mio_display, mio_visual, 
						AllocNone);
			break;

		case	XCWA_NORMAL:
		default:
			break;
	}
	return(XCreateWindow(mio_display, mio_parent, mio_x, mio_y, mio_width,
			mio_height, mio_border_width, mio_depth, mio_class,
			mio_visual, mio_valuemask, mio_aptr));
}


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	w = DRW(Dsp);
	valuemask = 0;
	attributes = &Atts;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

XWindowAttributes	getatts;
Colormap	cm;
Cursor		curs;
int 	n;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XChangeWindowAttributes-1.(A)");
	report_assertion("A call to XChangeWindowAttributes changes the window");
	report_assertion("attributes specified in valuemask to the values in the");
	report_assertion("attributes structure.");

	report_strategy("Create window with default attributes.");
	report_strategy("Change the window attributes to non-default values.");
	report_strategy("Get the window attributes with XGetWindowAttributes.");
	report_strategy("Verify that they are the same as the ones set.");

	tpstartup();
	setargs();
	cm = XCreateColormap(display, DRW(display), DefaultVisual(display, DefaultScreen(display)), AllocNone);
	curs = XCreateFontCursor(display, XC_coffee_mug);

	attributes->bit_gravity = SouthEastGravity;
	attributes->win_gravity = EastGravity;
	attributes->backing_store = WhenMapped;
	attributes->backing_planes = 0xaaaaaaaa;
	attributes->backing_pixel = 1;
	attributes->save_under = True;
	attributes->event_mask = PropertyChangeMask;
	attributes->do_not_propagate_mask = KeyPressMask;
	attributes->override_redirect = True;
	attributes->colormap = cm;
	attributes->cursor = curs;

	valuemask = CWBitGravity|CWWinGravity|CWBackingStore|CWBackingPlanes|
		CWBackingPixel|CWSaveUnder|CWEventMask|CWDontPropagate|
		CWOverrideRedirect|CWColormap|CWCursor;

	w = makeinout( DRW(display), (Visual *) CopyFromParent,
			CopyFromParent, XCWA_NORMAL);

	startcall(display);
	if (isdeleted())
		return;
	XChangeWindowAttributes(display, w, valuemask, attributes);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XGetWindowAttributes(display, w, &getatts);
	if (isdeleted())
		return;

	XDestroyWindow(display, w);

	n = checkatts(attributes, &getatts, valuemask);
	if (n > 0) {
		report("There %s %d incorrect attribute%s", 
					(n>1)?"were":"was", n, (n>1)?"s":"");
		FAIL;
	} else if (n < 0) {
		/* already reported a path check error in checkatts */
		return;
	} else
		CHECK;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

XEvent event;
XVisualInfo	*vp;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XChangeWindowAttributes-2.(A)");
	report_assertion("When the background is changed, then the window contents do");
	report_assertion("not change.");

	report_strategy("Create a window.");
	report_strategy("Set the background-pixmap");
	report_strategy("Map window over a plain background.");
	report_strategy("Change background-pixmap to a patterned tile.");
	report_strategy("Verify that background has not changed.");

	tpstartup();
	setargs();
	for(resetvinf(VI_WIN); nextvinf(&vp); ) {
		Pixmap	pm;
		parent = makedrawable(display, vp);

		w = makeinout(parent, (Visual *)CopyFromParent,
				CopyFromParent, XCWA_NORMAL);

		XSelectInput(display, w, ExposureMask);
		pm = makepixm(display,vp);
		XSetWindowBackgroundPixmap(display, w, pm);
		XMapWindow(display, w);
					/* Wait for window to be exposed */
		XWindowEvent(display,w,ExposureMask, &event);

		valuemask = CWBackPixmap;
		attributes->background_pixmap = maketile(display, w);

		startcall(display);
		if (isdeleted())
			return;
		XChangeWindowAttributes(display, w, valuemask, attributes);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if ( isdeleted() )
			continue;

		PIXCHECK(display, parent);

	}

	if (getevent(display, &event) != 0)
		delete("Unexpected event: %s", eventname(event.type));
	else
		CHECKPASS(nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

struct	area	child_pos;
unsigned int tile_width, tile_height, t3_border_width;
Pixmap	bpm, tpm;
XVisualInfo	*vp;
XImage	*i_before;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XChangeWindowAttributes-3.(A)");
	report_assertion("When the border is changed or the background set such that");
	report_assertion("the border tile origin changes, then the border is");
	report_assertion("repainted.");

	report_strategy("Create a window.");
	report_strategy("Set the border-pixmap");
	report_strategy("Map window over a patterned background.");
	report_strategy("Change border-pixmap ");
	report_strategy("Verify that border has changed by pixel checking.");
	report_strategy("Create a window, with no border, and a tiled background.");
	report_strategy("Create a child window, with a parent relative background and a border pixmap.");
	report_strategy("Map windows.");
	report_strategy("Save image.");
	report_strategy("Change the child window background causing the border pixmap to be retiled");
	report_strategy("because the border_tile origin will change.");
	report_strategy("Verify the border changed.");

	tpstartup();
	setargs();
	t3_border_width = 10;

/* This tests the border changing, but not the second condition */
	for(resetvinf(VI_WIN); nextvinf(&vp); ) {
		parent = makedrawable(display,vp);

		w = makeinout(parent, (Visual *)CopyFromParent,
				CopyFromParent, XCWA_NORMAL);

		XMapWindow(display,w);
		bpm = makepixm(display, vp);
		XSetWindowBorderPixmap(display, w, bpm);

		attributes->border_pixmap = maketile(display,parent);
		valuemask = CWBorderPixmap;

		startcall(display);
		if (isdeleted())
			return;
		XChangeWindowAttributes(display, w, valuemask, attributes);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if ( isdeleted() )
			continue;

		PIXCHECK(display, parent);

/* Now check change of background causes border retiling */
	
/* Make a 1 border width parent, with tpm as the tile */

		parent = makewin(display, vp);
		XUnmapWindow(display, parent);

		tpm = maketile(display, parent);
		getsize(display, tpm, &tile_width, &tile_height);

		valuemask = CWBackPixmap;
		attributes->background_pixmap = tpm;
		w = parent;
		startcall(display);
		if (isdeleted())
			return;
		XChangeWindowAttributes(display, w, valuemask, attributes);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		XMapWindow(display, parent);

 /*This numerical offset is the amount we expect the border pm to move by */
		child_pos.x = tile_width + 2; 
		child_pos.y = tile_height+ 2;	

		while(child_pos.x <= t3_border_width) {
			child_pos.x += tile_width;
		}
		while(child_pos.y <= t3_border_width) {
			child_pos.y += tile_height;
		}
		child_pos.width = 30;
		child_pos.height= 30;

		w = crechild(display, parent, &child_pos);
		XUnmapWindow(display, w);
		XSetWindowBorderWidth(display, w, t3_border_width);
		valuemask = CWBorderPixmap | CWBackPixmap;
		attributes->background_pixmap = ParentRelative;
		attributes->border_pixmap = tpm;

		startcall(display);
		if (isdeleted())
			return;
		XChangeWindowAttributes(display, w, valuemask, attributes);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		XMapWindow(display, w);
		XSync(display,True);

		i_before = savimage(display, parent);
		valuemask = CWBackPixmap;
		attributes->background_pixmap = tpm;
		startcall(display);
		if (isdeleted())
			return;
		XChangeWindowAttributes(display, w, valuemask, attributes);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
/* Window contents are expected to have changed */
		if(diffsavimage(display, parent, i_before))
		{
			report("Changing the border tile origin by changing");
			report("the background pixmap from ParentRelative");
			report("did not cause a border retiling.");
			FAIL;
		}
		else
			CHECK;
	
	}

	CHECKPASS(nvinf()*2);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.359072 */
static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XChangeWindowAttributes-4.(B)");
	report_assertion("When the background-pixmap attribute of a root window is");
	report_assertion("set to None, then the default background pixmap is");
	report_assertion("restored.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.359072 */

/* Including from file Mdefcode.tmc.359072 */
static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XChangeWindowAttributes-5.(B)");
	report_assertion("When the background-pixmap attribute of a root window is");
	report_assertion("set to ParentRelative, then the default background pixmap");
	report_assertion("is restored.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.359072 */

/* Including from file Mdefcode.tmc.359072 */
static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XChangeWindowAttributes-6.(B)");
	report_assertion("When the border-pixmap attribute of a root window is set to");
	report_assertion("CopyFromParent, then the default border pixmap is restored.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.359072 */

static void t007(){

XWindowAttributes	before,after;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XChangeWindowAttributes-7.(A)");
	report_assertion("When the win-gravity attribute is changed, then the current");
	report_assertion("position of the window is not changed.");

	report_strategy("Create window");
	report_strategy("Ascertain window position by calling XGetWindowAttributes");
	report_strategy("Change win-gravity by calling XChangeWindowAttributes");
	report_strategy("Ascertain window position by calling XGetWindowAttributes");
	report_strategy("Verify window position is unchanged.");

	tpstartup();
	setargs();
	w = makeinout((Drawable)None, (Visual *)CopyFromParent,
		CopyFromParent, XCWA_GRAVITY);

	XGetWindowAttributes(display, w, &before);

	valuemask = CWWinGravity;
	attributes->win_gravity = SouthWestGravity;

	startcall(display);
	if (isdeleted())
		return;
	XChangeWindowAttributes(display, w, valuemask, attributes);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XGetWindowAttributes(display, w, &after);

	if( (before.x != after.x) || (before.y != before.y) )
	{
		report("Changing win_gravity changed window positon");
		report("Before: x=%d y=%d", before.x, before.y);
		report("After : x=%d y=%d", after.x, after.y);
		FAIL;
	}
	else
		CHECK;

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

Colormap cm;
XEvent	ev;
int	events;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XChangeWindowAttributes-8.(A)");
	report_assertion("When the colormap attribute of a window is changed, then a");
	report_assertion("ColormapNotify event is generated.");

	report_strategy("Create window");
	report_strategy("Select ColormapNotify event");
	report_strategy("Create Colormap for the window");
	report_strategy("Change the window colormap by calling XChangeWindowAttributes");
	report_strategy("Verify that a ColormapNotify event was generated");

	tpstartup();
	setargs();
	w = makeinout((Drawable)None, (Visual *)CopyFromParent,
		CopyFromParent, XCWA_NORMAL);

	XSelectInput(display, w, ColormapChangeMask);

	cm = makecolmap(display,
		XDefaultVisual( display, XDefaultScreen(display) ),
		AllocNone);

	valuemask = CWColormap;
	attributes->colormap = cm;

	startcall(display);
	if (isdeleted())
		return;
	XChangeWindowAttributes(display, w, valuemask, attributes);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	events = getevent(display, &ev);

	if (events != 1)
	{
		report("Expected one event on the event queue (ColormapNotify)");
		report("Got: %d events.", events);
		report("The first event was of type %s", eventname(ev.type));
		FAIL;
	}
	else
	if( ev.type != ColormapNotify )
	{
		report("Unexpected event received upon changing Colormap");
		report("Expecting: ColormapNotify");
		report("Received:  %s", eventname(ev.type));
		FAIL;
	}
	else
		CHECK;

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

int	num;
Display *client1;
Display *client2;
XEvent	event;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XChangeWindowAttributes-9.(A)");
	report_assertion("When more than one client sets a mask other than");
	report_assertion("SubstructureRedirectMask, ResizeRedirectMask, and");
	report_assertion("ButtonPressMask in the event-mask attribute, then the");
	report_assertion("selected events are delivered to each such client.");

	report_strategy("Create client1.");
	report_strategy("Create window with client1.");
	report_strategy("Select MapNotify events with client1 on this window.");
	report_strategy("Create client2.");
	report_strategy("Select MapNotify events with client2 on this window.");
	report_strategy("Map window.");
	report_strategy("Verify that client1 received a single MapNotify event for this window.");
	report_strategy("Verify that client1 received no other events.");
	report_strategy("Verify that client2 received a single MapNotify event for this window.");
	report_strategy("Verify that client2 received no other events.");

	tpstartup();
	setargs();
/* Create client1. */
	client1 = opendisplay();
	if (client1 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
/* Create window with client1. */
	w = mkwin(client1, (XVisualInfo *) NULL, (struct area *) NULL, False);
/* Select MapNotify events with client1 on this window. */
	valuemask = CWEventMask;
	attributes->event_mask = StructureNotifyMask;
	BASIC_STARTCALL(client1);
	XChangeWindowAttributes(client1, w, valuemask, attributes);
	BASIC_ENDCALL(client1, Success);
/* Create client2. */
	client2 = opendisplay();
	if (client2 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
/* Select MapNotify events with client2 on this window. */
	valuemask = CWEventMask;
	attributes->event_mask = StructureNotifyMask;
	BASIC_STARTCALL(client2);
	XChangeWindowAttributes(client2, w, valuemask, attributes);
	BASIC_ENDCALL(client2, Success);
/* Map window. */
	XSync(client1, True);
	XSync(client2, True);
	XMapWindow(client1, w);
	XSync(client1, False);
	XSync(client2, False);
/* Verify that client1 received a single MapNotify event for this window. */

	if((num = getevent(client1, &event)) == 0)
	{
		report("No events were delivered to client1.");
		report("Expecting a single MapNotify event.");
		FAIL;
	}
	else
	if (event.type != MapNotify)
	{
		report("Selected event was not delivered to client1.");
		report("Delivered event was: %s", eventname(event.type));
		FAIL;
	}
	else
		CHECK;
/* Verify that client1 received no other events. */
	if (num > 1) {
		report("Unexpected events were delivered to client1.");
		report("Expecting a single MapNotify event.");
		report("Got %d events", num);
		FAIL;
	}
	else
		CHECK;
/* Verify that client2 received a single MapNotify event for this window. */
	if((num = getevent(client2, &event)) == 0)
	{
		report("No events were delivered to client2.");
		report("Expecting a single MapNotify event.");
		FAIL;
	}
	else
	if (event.type != MapNotify)
	{
		report("Selected event was not delivered to client2.");
		report("Delivered event was: %s", eventname(event.type));
		FAIL;
	}
	else
		CHECK;
/* Verify that client2 received no other events. */
	if (num > 1) {
		report("Unexpected events were delivered to client2.");
		report("Expecting a single MapNotify event.");
		report("Got %d events", num);
		FAIL;
	}
	else
		CHECK;

	CHECKPASS(6);
	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

Display *client1;
Display *client2;
XWindowAttributes attrs;
int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XChangeWindowAttributes-10.(A)");
	report_assertion("When the event-mask attribute is changed, then the");
	report_assertion("event-mask attribute does not change for other clients.");

	report_strategy("Create client1.");
	report_strategy("Create window with client1.");
	report_strategy("Select NoEventMask events with client1 on this window.");
	report_strategy("Call XGetWindowAttributes to get event mask for client1 for window.");
	report_strategy("Verify event mask is as expected.");
	report_strategy("Create client2.");
	report_strategy("Select ALLEVENTS events with client2 on this window.");
	report_strategy("Call XGetWindowAttributes to get event mask for client2 for window.");
	report_strategy("Verify event mask is as expected.");
	report_strategy("Call XGetWindowAttributes to get event mask for client1 for window.");
	report_strategy("Verify event mask has not changed.");
	report_strategy("Select KeyPressMask events with client1 on this window.");
	report_strategy("Call XGetWindowAttributes to get event mask for client1 for window.");
	report_strategy("Verify event mask is as expected.");
	report_strategy("Call XGetWindowAttributes to get event mask for client2 for window.");
	report_strategy("Verify event mask has not changed.");

	tpstartup();
	setargs();
/* Create client1. */
	client1 = opendisplay();
	if (client1 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
/* Create window with client1. */
	w = mkwin(client1, (XVisualInfo *) NULL, (struct area *) NULL, False);
/* Select NoEventMask events with client1 on this window. */
	valuemask = CWEventMask;
	attributes->event_mask = NoEventMask;
	display = client1;

	startcall(display);
	if (isdeleted())
		return;
	XChangeWindowAttributes(display, w, valuemask, attributes);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Call XGetWindowAttributes to get event mask for client1 for window. */
	if (!XGetWindowAttributes(client1, w, &attrs)) {
		delete("A call to XGetWindowAttributes failed.");
		return;
	}
	else
		CHECK;
/* Verify event mask is as expected. */
	if (attrs.your_event_mask != NoEventMask) {
		delete("Unexpected event mask value.");
		return;
	}
	else
		CHECK;
/* Create client2. */
	client2 = opendisplay();
	if (client2 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
/* Select ALLEVENTS events with client2 on this window. */
	valuemask = CWEventMask;
	attributes->event_mask = ALLEVENTS;
	display = client2;

	startcall(display);
	if (isdeleted())
		return;
	XChangeWindowAttributes(display, w, valuemask, attributes);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Call XGetWindowAttributes to get event mask for client2 for window. */
	if (!XGetWindowAttributes(client2, w, &attrs)) {
		delete("A call to XGetWindowAttributes failed.");
		return;
	}
	else
		CHECK;
/* Verify event mask is as expected. */
	if (attrs.your_event_mask != ALLEVENTS) {
		delete("Unexpected event mask value.");
		return;
	}
	else
		CHECK;
/* Call XGetWindowAttributes to get event mask for client1 for window. */
	if (!XGetWindowAttributes(client1, w, &attrs)) {
		delete("A call to XGetWindowAttributes failed.");
		return;
	}
	else
		CHECK;
/* Verify event mask has not changed. */
	if (attrs.your_event_mask != NoEventMask) {
		report("Event mask incorrect.");
		FAIL;
	}
	else
		CHECK;
/* Select KeyPressMask events with client1 on this window. */
	valuemask = CWEventMask;
	attributes->event_mask = KeyPressMask;
	display = client1;

	startcall(display);
	if (isdeleted())
		return;
	XChangeWindowAttributes(display, w, valuemask, attributes);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Call XGetWindowAttributes to get event mask for client1 for window. */
	if (!XGetWindowAttributes(client1, w, &attrs)) {
		delete("A call to XGetWindowAttributes failed.");
		return;
	}
	else
		CHECK;
/* Verify event mask is as expected. */
	if (attrs.your_event_mask != KeyPressMask) {
		delete("Unexpected event mask value.");
		return;
	}
	else
		CHECK;
/* Call XGetWindowAttributes to get event mask for client2 for window. */
	if (!XGetWindowAttributes(client2, w, &attrs)) {
		delete("A call to XGetWindowAttributes failed.");
		return;
	}
	else
		CHECK;
/* Verify event mask has not changed. */
	if (attrs.your_event_mask != ALLEVENTS) {
		report("Event mask incorrect.");
		FAIL;
	}
	else
		CHECK;

	CHECKPASS(12);

	tpcleanup();
	pfcount(pass, fail);
}

static void t011(){

Window		altroot;
Cursor		cursor;
Bool		samedefcursor;
int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion XChangeWindowAttributes-11.(B)");
	report_assertion("When the cursor attribute of a root window is changed to");
	report_assertion("None, then the default cursor is restored.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If extended testing is required:");
	report_strategy("  If the server supports two screens with the same default cursor:");
	report_strategy("    Set the root window cursor to a non-default cursor.");
	report_strategy("    Verify that the cursor was set correctly.");
	report_strategy("    Warp the pointer into the root window.");
	report_strategy("    Verify that the current cursor is that of the root window.");
	report_strategy("    Warp the pointer to the alternate root window.");
	report_strategy("    Verify that the current cursor is not the same as that of the default root window.");
	report_strategy("    Reset the cursor of the root window to the default cursor using XChangeWindowAttributes.");
	report_strategy("    Verify that the current cursor is the same as that of the default root window.");
	report_strategy("  Otherwise :");
	report_strategy("    Set the root window cursor to a non-default cursor.");
	report_strategy("    Verify that the cursor was set correctly.");
	report_strategy("    Warp the pointer to the root window.");
	report_strategy("    Verify that the current cursor is that of the root window.");
	report_strategy("    Reset the cursor of the root window to the default cursor using XChangeWindowAttributes.");
	report_strategy("    Verify that the root window cursor is no longer the non-default cursor.");

	tpstartup();
	setargs();
	/* If extended testing is required: */
	if(noext(0))
		return;

	if(config.alt_screen != -1) {
		warppointer(display, DRW(display), 0,0);
		altroot = RootWindow(display, config.alt_screen);
		samedefcursor = spriteiswin(display, altroot);
	}

		/* If the server supports two screens with the same default cursor: */
	if(config.alt_screen != -1 && samedefcursor) {

			/* Set the root window cursor to a non-default cursor. */
		cursor = makecur(display);
		w = DRW(display);
		XDefineCursor(display, w, cursor);
		
			/* Verify that the cursor was set correctly. */
		if(curofwin(display, cursor, w) == False) {
			delete("XDefineCursor() did not set the root window's cursor correctly.");
			return;
		} else
			CHECK;

			/* Warp the pointer into the root window. */
		warppointer(display, w, 0,0);

			/* Verify that the current cursor is that of the root window. */
		if(spriteiswin(display, w) == False) {
			delete("Current cursor is not that of the root window.");
			return;
		} else
			CHECK;

			/* Warp the pointer to the alternate root window. */
		warppointer(display, altroot, 0,0);

			/* Verify that the current cursor is not the same as that of the default root window. */
		if(spriteiswin(display, DRW(display)) != False) {
			delete("The alternate root window's cursor was not set to the default cursor.");
			return;
		} else
			CHECK;

			/* Reset the cursor of the root window to the default cursor using xname. */
		valuemask = CWCursor;
		attributes->cursor = None;
		startcall(display);
		if (isdeleted())
			return;
		XChangeWindowAttributes(display, w, valuemask, attributes);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

			/* Verify that the current cursor is the same as that of the default root window. */
		if(spriteiswin(display, DRW(display)) == False) {
			report("Root window's cursor was not set to the default cursor.");
			FAIL;
		} else
			CHECK;

	 	CHECKPASS(4);
	} else {

		/* Otherwise : */

			/* Set the root window cursor to a non-default cursor. */
		cursor = makecur2(display);
		w = DRW(display);
		XDefineCursor(display, w, cursor);

			/* Verify that the cursor was set correctly. */
		if(curofwin(display, cursor, w) == False) {
			delete("XDefineCursor() did not set the root window's cursor correctly.");
			return;
		} else
			CHECK;

			/* Warp the pointer to the root window. */
		warppointer(display, w, 0,0);

			/* Verify that the current cursor is that of the root window. */
		if(spriteiswin(display, w) == False) {
			delete("Current cursor is not that of the root window.");
			return;
		} else
			CHECK;

			/* Reset the cursor of the root window to the default cursor using xname. */
		valuemask = CWCursor;
		attributes->cursor = None;
		startcall(display);
		if (isdeleted())
			return;
		XChangeWindowAttributes(display, w, valuemask, attributes);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

			/* Verify that the root window cursor is no longer the non-default cursor. */
		if(curofwin(display, cursor, w) != False) {
			report("%s() did not set the root window's cursor to the default cursor.", TestName);
			FAIL;
		} else
			CHECK;

		CHECKUNTESTED(3);
	}

	tpcleanup();
	pfcount(pass, fail);
}

static void t012(){

Display *client1;
Display *client2;
XWindowAttributes attrs;
unsigned long dont_all;
int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion XChangeWindowAttributes-12.(A)");
	report_assertion("When the do-not-propagate-mask attribute is changed, then");
	report_assertion("the change is effective for all clients.");

	report_strategy("Create client1.");
	report_strategy("Create window with client1.");
	report_strategy("Call XGetWindowAttributes to get do-not-propagate-mask for client1 for window.");
	report_strategy("Verify do-not-propagate-mask is as expected.");
	report_strategy("Create client2.");
	report_strategy("Call XGetWindowAttributes to get do-not-propagate-mask for client2 for window.");
	report_strategy("Verify do-not-propagate-mask is as expected.");
	report_strategy("Set do-not-propagate-mask to KeyPressMask events with client1 on this window.");
	report_strategy("Call XGetWindowAttributes to get do-not-propagate-mask for client1 for window.");
	report_strategy("Verify do-not-propagate-mask has changed.");
	report_strategy("Call XGetWindowAttributes to get do-not-propagate-mask for client2 for window.");
	report_strategy("Verify do-not-propagate-mask has changed.");

	tpstartup();
	setargs();
	dont_all = ALLEVENTS & (!0xffffc0b0);	/* This defines the
							SETofDEVICEEVENT */

/* Create client1. */
	client1 = opendisplay();
	if (client1 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
/* Create window with client1. */
	w = mkwin(client1, (XVisualInfo *) NULL, (struct area *) NULL, False);
	valuemask = CWDontPropagate;
	attributes->do_not_propagate_mask = dont_all;
	display = client1;

	startcall(display);
	if (isdeleted())
		return;
	XChangeWindowAttributes(display, w, valuemask, attributes);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Call XGetWindowAttributes to get do-not-propagate-mask for client1 for window. */
	if (!XGetWindowAttributes(client1, w, &attrs)) {
		delete("A call to XGetWindowAttributes failed.");
		return;
	}
	else
		CHECK;
/* Verify do-not-propagate-mask is as expected. */
	if (attrs.do_not_propagate_mask != dont_all) {
		delete("Unexpected do-not-propagate-mask value.");
		report("Expecting: %s", eventmaskname(dont_all));
		report("Got: %s", eventmaskname(attrs.do_not_propagate_mask));
		return;
	}
	else
		CHECK;
/* Create client2. */
	client2 = opendisplay();
	if (client2 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
/* Call XGetWindowAttributes to get do-not-propagate-mask for client2 for window. */
	if (!XGetWindowAttributes(client2, w, &attrs)) {
		delete("A call to XGetWindowAttributes failed.");
		return;
	}
	else
		CHECK;
/* Verify do-not-propagate-mask is as expected. */
	if (attrs.do_not_propagate_mask != dont_all) {
		delete("Unexpected do-not-propagate-mask value.");
		report("Expecting: %s", eventmaskname(dont_all));
		report("Got: %s", eventmaskname(attrs.do_not_propagate_mask));
		return;
	}
	else
		CHECK;

/* Set do-not-propagate-mask to KeyPressMask events with client1 on this window. */
	valuemask = CWDontPropagate;
	attributes->do_not_propagate_mask = KeyPressMask;
	display = client1;

	startcall(display);
	if (isdeleted())
		return;
	XChangeWindowAttributes(display, w, valuemask, attributes);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Call XGetWindowAttributes to get do-not-propagate-mask for client1 for window. */
	if (!XGetWindowAttributes(client1, w, &attrs)) {
		delete("A call to XGetWindowAttributes failed.");
		return;
	}
	else
		CHECK;
/* Verify do-not-propagate-mask has changed. */
	if (attrs.do_not_propagate_mask != KeyPressMask) {
		report("Incorrect do-not-propagate-mask.");
		report("Expecting: %s", eventmaskname(KeyPressMask));
		report("Got: %s", eventmaskname(attrs.do_not_propagate_mask));
		FAIL;
	}
	else
		CHECK;
/* Call XGetWindowAttributes to get do-not-propagate-mask for client2 for window. */
	if (!XGetWindowAttributes(client2, w, &attrs)) {
		delete("A call to XGetWindowAttributes failed.");
		return;
	}
	else
		CHECK;
/* Verify do-not-propagate-mask has changed. */
	if (attrs.do_not_propagate_mask != KeyPressMask) {
		report("Incorrect do-not-propagate-mask.");
		report("Expecting: %s", eventmaskname(KeyPressMask));
		report("Got: %s", eventmaskname(attrs.do_not_propagate_mask));
		FAIL;
	}
	else
		CHECK;

	CHECKPASS(10);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file ../XCreateWindow/commattr.mc */
static void t013(){

XVisualInfo	*vp;
int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion XChangeWindowAttributes-13.(A)");
	report_assertion("When the background-pixmap attribute is set to None and the");
	report_assertion("background_pixel attribute is not being set at the same");
	report_assertion("time, then the window has no defined background.");

	report_strategy("Set background-pixmap attribute to None.");
	report_strategy("Map window over a patterned background.");
	report_strategy("Verify that contents of the window are the same as the parent's.");

	tpstartup();
	setargs();

	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		parent = makedrawable(display, vp);
		pattern(display, parent);

		visual = vp->visual;
		depth  = vp->depth;
		valuemask = CWBackPixmap;
		attributes->background_pixmap = None;

		w = makeinout( parent , visual, depth, XCWA_NORMAL );
		startcall(display);
		if (isdeleted())
			return;
		XChangeWindowAttributes(display, w, valuemask, attributes);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		XMapWindow(display, w);
		if (isdeleted())
			continue;
		/*
		 * Use pixmap checking here because we want to check the border
		 * to prove that the window is really there, but transparent.
		 */
		PIXCHECK(display, parent);
	}

	CHECKPASS(nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

static void t014(){

Pixmap	pm;
int 	pass = 0, fail = 0;

 	report_purpose(14);

	report_assertion("Assertion XChangeWindowAttributes-14.(A)");
	report_assertion("When the background-pixmap attribute is set to");
	report_assertion("ParentRelative, then each time the background pixmap is");
	report_assertion("required it is taken from the parent window at the time that");
	report_assertion("it is required, with the background tile origin aligned with");
	report_assertion("the origin of the parent window.");

	report_strategy("Set background-pixmap to ParentRelative.");
	report_strategy("For a variety of parent backgrounds");
	report_strategy("  Clear child window.");
	report_strategy("  Verify that background changes to that set for the parent.");

	tpstartup();
	setargs();
	visual = CopyFromParent;
	depth = CopyFromParent;
	valuemask = CWBackPixmap;
	attributes->background_pixmap = ParentRelative;

	parent = defdraw(display, VI_WIN);
	w = makeinout(parent, visual, depth, XCWA_NORMAL);
	XMapWindow(display, w);
	startcall(display);
	if (isdeleted())
		return;
	XChangeWindowAttributes(display, w, valuemask, attributes);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	pm = maketile(display, parent);
	XSetWindowBackgroundPixmap(display, parent, pm);
	XClearWindow(display, w);

	if (checktile(display, w, (struct area *)0, -x-border_width, -y-border_width, pm))
		CHECK;
	else {
		report("ParentRelative check failed for 'maketile' background");
		FAIL;
	}

	pm = XCreatePixmap(display, parent, 10, 17, (int)getdepth(display, w));
	dclear(display, pm);
	pattern(display, pm);
	XSetWindowBackgroundPixmap(display, parent, pm);
	XClearWindow(display, w);
	if (checktile(display, w, (struct area *)0, -x-border_width, -y-border_width, pm))
		CHECK;
	else {
		report("ParentRelative check failed for 'pattern' background");
		FAIL;
	}

	XSetWindowBackground(display, parent, W_FG);
	XClearWindow(display, w);
	if (checkarea(display, w, (struct area *)0, W_FG, W_BG, CHECK_ALL))
		CHECK;
	else {
		report("ParentRelative check failed for plain background set to W_FG");
		FAIL;
	}

	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

static void t015(){

Pixmap	pm;
int 	pass = 0, fail = 0;

 	report_purpose(15);

	report_assertion("Assertion XChangeWindowAttributes-15.(A)");
	report_assertion("When both background_pixel and background_pixmap are");
	report_assertion("specified, then background_pixel overrides background_pixmap.");

	report_strategy("Set both the background-pixel attribute and the background-pixmap attribute.");
	report_strategy("Map and clear window to ensure background is refreshed.");
	report_strategy("Verify that background is set to the pixel value.");

	tpstartup();
	setargs();
	parent = defdraw(display, VI_WIN);

	pm = maketile(display, parent);
	attributes->background_pixel = W_FG;
	attributes->background_pixmap = pm;
	valuemask = CWBackPixel|CWBackPixmap;

	/*
	 * For running with window managers during debugging, testing etc.
	 */
	if (config.debug_override_redirect) {
		attributes->override_redirect = True;
		valuemask |= CWOverrideRedirect;
	}

	w = makeinout(parent, (Visual *)CopyFromParent,
		CopyFromParent, XCWA_NORMAL);
	XMapWindow(display, w);
	startcall(display);
	if (isdeleted())
		return;
	XChangeWindowAttributes(display, w, valuemask, attributes);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XClearWindow(display, w);

	if (checkarea(display, w, (struct area *)0, W_FG, W_FG, CHECK_ALL))
		CHECK;
	else {
		report("background pixel did not override background pixmap");
		FAIL;
	}

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t016(){

XVisualInfo	*vp;
static int 	pixlist[] = {
	0, 1, 3, 4, 17, 18, 200, 300, 303,
	0x1234, 0x12345, 0x123456, 0x1234567, 0x12345678};
long	pix;
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(16);

	report_assertion("Assertion XChangeWindowAttributes-16.(A)");
	report_assertion("When background_pixel is specified, then it is truncated to");
	report_assertion("the depth of the window.");

	report_strategy("For each visual");
	report_strategy("  Try variety of background pixel values.");
	report_strategy("  Verify that they are truncated to depth using checkarea.");

	tpstartup();
	setargs();
	visual = CopyFromParent;
	depth = CopyFromParent;

	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		parent = makedrawable(display, vp);

		for (i = 0; i < NELEM(pixlist); i++) {
			pix = pixlist[i];

			visual = vp->visual;
			depth  = vp->depth;
			valuemask = CWBackPixel;
			attributes->background_pixel = pix;

			w = makeinout(parent, visual, depth, XCWA_NORMAL);
			startcall(display);
			if (isdeleted())
				return;
			XChangeWindowAttributes(display, w, valuemask, attributes);
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}
			XMapWindow(display, w);
			XClearWindow(display, w);

			/*
			 * Check the whole background.  If the background was not all
			 * set to the same value then the error message could be
			 * confusing.
			 */
			debug(3, "  pix 0x%x", pix);
			debug(3, "  vp->depth 0x%x", vp->depth);
			debug(3, "  DEPTHMASK(vp->depth) 0x%x", DEPTHMASK(vp->depth));
			if (checkarea(display, w, (struct area *)0, pix&DEPTHMASK(vp->depth), 0, CHECK_ALL))
				CHECK;
			else {
				report("Background pixel was not truncated (value 0x%x)", pix);
				report("  Was 0x%x, expecting 0x%x", getpixel(display, w, 0, 0),
					pix&DEPTHMASK(vp->depth));
				FAIL;
			}
		}
	}

	CHECKPASS(nvinf() * NELEM(pixlist));

	tpcleanup();
	pfcount(pass, fail);
}

static void t017(){

Pixmap	pm;
XVisualInfo	*vp;
int 	pass = 0, fail = 0;

 	report_purpose(17);

	report_assertion("Assertion XChangeWindowAttributes-17.(A)");
	report_assertion("When border_pixmap is CopyFromParent, then the");
	report_assertion("border-pixmap attribute is copied from the parent window.");

	report_strategy("Create parent window.");
	report_strategy("Set parent border-pixmap attribute.");
	report_strategy("Set child window border-pixmap to CopyFromParent.");
	report_strategy("Ensure that window is mapped.");
	report_strategy("Pixmap verify to check that border is correct.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		parent = makedrawable(display, vp);
		pm = maketile(display, parent);
		XSetWindowBorderPixmap(display, parent, pm);

		visual = vp->visual;
		depth = vp->depth;
		valuemask = CWBorderPixmap;
		attributes->border_pixmap = CopyFromParent;

		w = makeinout(parent, visual, depth, XCWA_NORMAL);
		XMapWindow(display, w);
		startcall(display);
		if (isdeleted())
			return;
		XChangeWindowAttributes(display, w, valuemask, attributes);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		PIXCHECK(display, parent);
	}

	CHECKPASS(nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

static void t018(){

XVisualInfo	*vp;
static int 	pixlist[] = {
	0, 1, 3, 4, 17, 18, 200, 300, 303,
	0x1234, 0x12345, 0x123456, 0x1234567, 0x12345678};
long	pix;
long	borderpix;
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(18);

	report_assertion("Assertion XChangeWindowAttributes-18.(A)");
	report_assertion("When border_pixel is specified, then the value is truncated");
	report_assertion("to the depth of the window.");

	report_strategy("For each visual");
	report_strategy("  Set border-pixel to various values.");
	report_strategy("  Read one pixel back from the border.");
	report_strategy("  Verify that this pixel has been truncated to depth of window.");

	tpstartup();
	setargs();
	visual = CopyFromParent;
	depth = CopyFromParent;

	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		parent = makedrawable(display, vp);

		for (i = 0; i < NELEM(pixlist); i++) {
			pix = pixlist[i];

			attributes->border_pixel = pix;
			valuemask = CWBorderPixel;

			w = makeinout(parent, visual, depth, XCWA_NORMAL);
			XMapWindow(display, w);
			startcall(display);
			if (isdeleted())
				return;
			XChangeWindowAttributes(display, w, valuemask, attributes);
			endcall(display);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}
			XClearWindow(display, w);

			borderpix = getpixel(display, w, -1, -1);
			debug(3, "  pix 0x%x", pix);
			debug(3, "  vp->depth 0x%x", vp->depth);
			debug(3, "  DEPTHMASK(vp->depth) 0x%x", DEPTHMASK(vp->depth));
			if (borderpix == (pix & DEPTHMASK(vp->depth)))
				CHECK;
			else {
				report("Border pixel was not truncated (value 0x%x)", pix);
				report("  Was 0x%x, expecting 0x%x", borderpix,
					pix & DEPTHMASK(vp->depth));
				FAIL;
			}
		}
	}

	CHECKPASS(nvinf() * NELEM(pixlist));

	tpcleanup();
	pfcount(pass, fail);
}

static void t019(){

XVisualInfo	*vp;
XWindowAttributes	getatts;
XWindowAttributes	parentatts;
int 	pass = 0, fail = 0;

 	report_purpose(19);

	report_assertion("Assertion XChangeWindowAttributes-19.(A)");
	report_assertion("When colormap is CopyFromParent, then the colormap");
	report_assertion("attribute is copied from the parent window.");

	report_strategy("Set colormap attribute to CopyFromParent.");
	report_strategy("Get attribute values.");
	report_strategy("Verify that colormap is same as for parent.");

	tpstartup();
	setargs();
	depth = CopyFromParent;
	visual = CopyFromParent;

	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		parent = makedrawable(display, vp);
		XGetWindowAttributes(display, parent, &parentatts);

		attributes->colormap = CopyFromParent;
		valuemask = CWColormap;

		w = makeinout(parent, visual, depth, XCWA_NORMAL);
		startcall(display);
		if (isdeleted())
			return;
		XChangeWindowAttributes(display, w, valuemask, attributes);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		XGetWindowAttributes(display, w, &getatts);

		if (getatts.colormap != parentatts.colormap) {
			report("Colormap CopyFromParent: Got 0x%x, expecting 0x%x",
				getatts.colormap, parentatts.colormap);
			FAIL;
		} else
			CHECK;

	}

	CHECKPASS(nvinf());
	tpcleanup();
	pfcount(pass, fail);
}

static void t020(){

Cursor pcur;
int 	pass = 0, fail = 0;

 	report_purpose(20);

	report_assertion("Assertion XChangeWindowAttributes-20.(B)");
	report_assertion("When the cursor attribute is set to None, then the cursor");
	report_assertion("of the parent window is used for the window and any change");
	report_assertion("in the parent window's cursor will cause an immediate change");
	report_assertion("in the window's cursor.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If extended testing is required:");
	report_strategy("  Create a parent window.");
	report_strategy("  Set the parent's cursor to a non-default cursor.");
	report_strategy("  Verify that the parent's cursor was set correctly.");
	report_strategy("  If XCreateWindow:");
	report_strategy("    Create a child window using XChangeWindowAttributes.");
	report_strategy("  Otherwise:");
	report_strategy("    Create and map a child window.");
	report_strategy("    Change the cursor attribute of the window to None using XChangeWindowAttributes.");
	report_strategy("  Warp the pointer to the child window.");
	report_strategy("  Verify that the current cursor is that of the parent.");
	report_strategy("  Verify that the child's cursor was set correctly.");
	report_strategy("  Set the parent's cursor to a different cursor.");
	report_strategy("  Verify that the parent's cursor was set correctly.");
	report_strategy("  Verify that the current cursor has changed to that of the parent.");

	tpstartup();
	setargs();
	/* If extended testing is required: */
	if(noext(0))
		return;

	pcur = makecur(display);
	valuemask = CWCursor;
	attributes->cursor = None;
	x = 10;
	y = 10;

		/* Create a parent window. */
	parent = defwin(display);
	
		/* Set the parent's cursor to a non-default cursor. */
	XDefineCursor(display, parent, pcur);

		/* Verify that the parent's cursor was set correctly. */
	if(curofwin(display, pcur, parent) == False) {
		delete("XDefineCursor() did not set the parent window's cursor correctly.");
		return;
	} else
		CHECK;

		/* Create and map a child window. */
	w = makeinout( parent , visual, depth, XCWA_NORMAL );
	XMapWindow(display, w);
		/* Change the cursor attribute of the window to None using XChangeWindowAttributes. */
	startcall(display);
	if (isdeleted())
		return;
	XChangeWindowAttributes(display, w, valuemask, attributes);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

		/* Warp the pointer to the child window. */
	warppointer(display, w, 0,0);

		/* Verify that the current cursor is that of the parent. */
	if(spriteiswin(display, parent) == False) {	
		report("The cursor used for the child window was not that of its parent.");
		FAIL;
	} else
		CHECK;

		/* Verify that the child's cursor was set correctly. */
	if(curofwin(display, None, w) == False) {
		report("Window's cursor was not set to None.");
		FAIL;
	} else
		CHECK;

	pcur = makecur2(display);

		/* Set the parent's cursor to a different cursor. */
	XDefineCursor(display, parent, pcur);

		/* Verify that the parent's cursor was set correctly. */
	if(curofwin(display, pcur, parent) == False) {
		delete("XDefineCursor() did not set the parent window's cursor correctly.");
		return;
	} else
		CHECK;

		/* Verify that the current cursor has changed to that of the parent. */
	if(spriteiswin(display, parent) == False) {	
		report("The cursor used for the child window was not that of its parent.");
		FAIL;
	} else
		CHECK;

	CHECKPASS(5);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t021(){

int 	pass = 0, fail = 0;

 	report_purpose(21);

	report_assertion("Assertion XChangeWindowAttributes-21.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XChangeWindowAttributes(display, w, valuemask, attributes);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

static void t022(){

int 	pass = 0, fail = 0;

 	report_purpose(22);

	report_assertion("Assertion XChangeWindowAttributes-22.(A)");
	report_assertion("When background_pixmap is not a valid pixmap, None, or");
	report_assertion("ParentRelative, then a BadPixmap error occurs.");

	report_strategy("Call XChangeWindowAttributes with background_pixmap set to an invalid value.");
	report_strategy("Verify that a BadPixmap error occurs.");

	tpstartup();
	setargs();
	seterrdef();


	attributes->background_pixmap = badpixm(display);
	valuemask = CWBackPixmap;

	parent = defdraw(display, VI_WIN);	/* Needed for XCreateWindow? */
	w = makeinout(None, (Visual *)CopyFromParent,
		CopyFromParent, XCWA_NORMAL);
	startcall(display);
	if (isdeleted())
		return;
	XChangeWindowAttributes(display, w, valuemask, attributes);
	endcall(display);
	if (geterr() != BadPixmap) {
		report("Got %s, Expecting BadPixmap", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadPixmap)
		PASS;
	else
		FAIL;	/* Already reported */
	tpcleanup();
	pfcount(pass, fail);
}

static void t023(){

int 	pass = 0, fail = 0;

 	report_purpose(23);

	report_assertion("Assertion XChangeWindowAttributes-23.(A)");
	report_assertion("When border_pixmap is not a valid pixmap or CopyFromParent,");
	report_assertion("then a BadPixmap error occurs.");

	report_strategy("Call XChangeWindowAttributes with border_pixmap set to an invalid value.");
	report_strategy("Verify that a BadPixmap error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	attributes->border_pixmap = badpixm(display);
	valuemask = CWBorderPixmap;

	parent = defdraw(display, VI_WIN);	/* Needed for XCreateWindow? */
	w = makeinout(None, (Visual *)CopyFromParent, CopyFromParent, XCWA_NORMAL);
	startcall(display);
	if (isdeleted())
		return;
	XChangeWindowAttributes(display, w, valuemask, attributes);
	endcall(display);
	if (geterr() != BadPixmap) {
		report("Got %s, Expecting BadPixmap", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadPixmap)
		PASS;
	else
		FAIL;	/* Already reported */
	tpcleanup();
	pfcount(pass, fail);
}

static void t024(){

int 	pass = 0, fail = 0;

 	report_purpose(24);

	report_assertion("Assertion XChangeWindowAttributes-24.(A)");
	report_assertion("When colormap is not a valid Colormap resource or");
	report_assertion("CopyFromParent, then a BadColor error occurs.");

	report_strategy("Call XChangeWindowAttributes with colormap set to an invalid value.");
	report_strategy("Verify that a BadColor error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	attributes->colormap = badcolormap(display, DRW(display)); /* XXX */
	valuemask = CWColormap;

	parent = defdraw(display, VI_WIN);	/* Needed for XCreateWindow? */
	w = makeinout(None, (Visual *)CopyFromParent, CopyFromParent, XCWA_NORMAL);
	startcall(display);
	if (isdeleted())
		return;
	XChangeWindowAttributes(display, w, valuemask, attributes);
	endcall(display);
	if (geterr() != BadColor) {
		report("Got %s, Expecting BadColor", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadColor)
		PASS;
	else
		FAIL;	/* Already reported */
	tpcleanup();
	pfcount(pass, fail);
}

static void t025(){

int 	pass = 0, fail = 0;

 	report_purpose(25);

	report_assertion("Assertion XChangeWindowAttributes-25.(A)");
	report_assertion("When cursor is not a valid Cursor resource or None, then a");
	report_assertion("BadCursor error occurs.");

	report_strategy("Call XChangeWindowAttributes with cursor set to an invalid value.");
	report_strategy("Verify that a BadCursor error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	/* Set to a pixmap */
	attributes->cursor = maketile(display, DRW(display));
	valuemask = CWCursor;

	parent = defdraw(display, VI_WIN);	/* Needed for XCreateWindow? */
	w = makeinout(None, (Visual *)CopyFromParent, CopyFromParent, XCWA_NORMAL);
	startcall(display);
	if (isdeleted())
		return;
	XChangeWindowAttributes(display, w, valuemask, attributes);
	endcall(display);
	if (geterr() != BadCursor) {
		report("Got %s, Expecting BadCursor", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadCursor)
		PASS;
	else
		FAIL;	/* Already reported */
	tpcleanup();
	pfcount(pass, fail);
}

static void t026(){

int 	i;
int 	n;
unsigned long	vals[NM_LEN];
static	unsigned long	validbits[] = {
	CWWinGravity,
	CWEventMask,
	CWDontPropagate,
	CWOverrideRedirect,
	CWCursor,
	};
int 	pass = 0, fail = 0;

 	report_purpose(26);

	report_assertion("Assertion XChangeWindowAttributes-26.(A)");
	report_assertion("When the window has class InputOnly and valuemask contains");
	report_assertion("a bit set other than CWWinGravity, CWEventMask,");
	report_assertion("CWDontPropagate, CWOverrideRedirect and CWCursor, then a");
	report_assertion("BadMatch error occurs.");

	report_strategy("Set value mask to contain invalid bits.");
	report_strategy("Verify in each case, that a BadMatch error occurs.");

	tpstartup();
	setargs();
	seterrdef();
	setinonly();

	n = notmaskmember(validbits, NELEM(validbits), vals);

	for (i = 0; i < n; i++) {

		debug(1, "Trying arg of %d", vals[i]);

		valuemask = vals[i];
		startcall(display);
		if (isdeleted())
			return;
		XChangeWindowAttributes(display, w, valuemask, attributes);
		endcall(display);
		if (geterr() != BadMatch) {
			report("Got %s, Expecting BadMatch", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadMatch)
			CHECK;
		else {
			trace("Value of %d did not give BadMatch", vals[i]);
			FAIL;
		}
	}

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

static void t027(){

Pixmap	pm;
XVisualInfo	*vp;
int 	found = 0;
int 	pass = 0, fail = 0;

 	report_purpose(27);

	report_assertion("Assertion XChangeWindowAttributes-27.(C)");
	report_assertion("If windows with depth other than one are supported: When");
	report_assertion("background_pixmap and the window do not have the same depth,");
	report_assertion("then a BadMatch error occurs.");

	report_strategy("Use depth of 1 for the pixmap.");
	report_strategy("Find a visual not of depth 1.");
	report_strategy("If not such a visual");
	report_strategy("  UNSUPPORTED");
	report_strategy("else");
	report_strategy("  Attempt to set background_pixmap to the depth 1 pixmap.");
	report_strategy("  Verify that a BadMatch error occurs.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		if (vp->depth != 1) {
			found = 1;
			break;
		}
	}

	if (!found) {
		unsupported("Only windows with depth one are supported");
		return;
	}

	depth = vp->depth;
	visual = vp->visual;
	pm = XCreatePixmap(display, DRW(display), 2, 2, 1);
	attributes->background_pixmap = pm;
	valuemask = CWBackPixmap;

	parent = defdraw(display, VI_WIN);
	w = makeinout(None, (Visual *)CopyFromParent, CopyFromParent, XCWA_NORMAL);
	startcall(display);
	if (isdeleted())
		return;
	(void)XChangeWindowAttributes(display, w, valuemask, attributes);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;
	XFreePixmap(display, pm);
	tpcleanup();
	pfcount(pass, fail);
}

static void t028(){

XVisualInfo	*vp;
Pixmap	pm;
int 	*depths;
int 	count;
int 	found = 0;
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(28);

	report_assertion("Assertion XChangeWindowAttributes-28.(C)");
	report_assertion("If multiple screens are supported: When background_pixmap");
	report_assertion("and the window are not created for the same screen, then a");
	report_assertion("BadMatch error occurs.");

	report_strategy("If there is a pixmap depth on the alternate screen that has the same");
	report_strategy("depth as a visual on the test screen then");
	report_strategy("  Create pixmap on alternate screen.");
	report_strategy("  Attempt to set background-pixmap with the pixmap");
	report_strategy("  Verify that a BadMatch error occurs.");
	report_strategy("else");
	report_strategy("  UNSUPPORTED");

	tpstartup();
	setargs();
	if (config.alt_screen == -1) {
		unsupported("No alternate screen supported");
		return;
	}

	depths = XListDepths(display, config.alt_screen, &count);

	for (resetvinf(VI_WIN); (!found && nextvinf(&vp)); ) {
		for (i = 0; i < count; i++) {
			if (depths[i] == vp->depth)
			{
				found = 1;
				break;
			}	
		}
	}

	if (!found) {
		unsupported("Pixmaps of same depth as a window not supported on alt screen");
		return;
	}

	pm = XCreatePixmap(display, RootWindow(display, config.alt_screen),
		2, 3, vp->depth);

	attributes->background_pixmap = pm;
	valuemask = CWBackPixmap;

	parent = defdraw(display, VI_WIN);
	w = makeinout(None, (Visual *)CopyFromParent, CopyFromParent, XCWA_NORMAL);
	startcall(display);
	if (isdeleted())
		return;
	XChangeWindowAttributes(display, w, valuemask, attributes);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;

	XFreePixmap(display, pm);
	tpcleanup();
	pfcount(pass, fail);
}

static void t029(){

XVisualInfo	*vp;
XVisualInfo	*vp2 = 0;
int 	found = 0;
int 	pass = 0, fail = 0;

 	report_purpose(29);

	report_assertion("Assertion XChangeWindowAttributes-29.(C)");
	report_assertion("If multiple window depths are supported: When");
	report_assertion("background_pixmap is ParentRelative and the window and the");
	report_assertion("parent window do not have the same depth, then a BadMatch");
	report_assertion("error occurs.");

	report_strategy("If two different depth windows are supported.");
	report_strategy("  Create window with different depth to parent.");
	report_strategy("  Attempt to set background_pixmap to ParentRelative.");
	report_strategy("  Verify that a BadMatch error occurs.");
	report_strategy("else");
	report_strategy("  UNSUPPORTED.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		if (vp2 == 0) {
			vp2 = vp;
		} else if (vp->depth != vp2->depth) {
			found = 1;
			break;
		}
	}

	if (!found) {
		unsupported("Only one depth of window is supported");
		return;
	}

	parent = makedrawable(display, vp2);
	visual = vp->visual;
	depth = vp->depth;

	attributes->background_pixmap = ParentRelative;
	valuemask = CWBackPixmap;

	w = makeinout(parent, visual, depth, XCWA_VISDEPTH);
	startcall(display);
	if (isdeleted())
		return;
	(void)XChangeWindowAttributes(display, w, valuemask, attributes);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

static void t030(){

Colormap	cm;
XVisualInfo	*vp,*vp1, *vinfo, vi;
int 	count;
int 	found = 0;
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(30);

	report_assertion("Assertion XChangeWindowAttributes-30.(A)");
	report_assertion("When colormap and the window are not created for the same");
	report_assertion("screen, then a BadMatch error occurs.");

	report_strategy("If multiple screens are supported:");
	report_strategy("  Obtain visual information about the alternate screen.");
	report_strategy("  Determine a visual type shared between the main and alternate screen.");
	report_strategy("  Create a colormap on the alternate screen.");
	report_strategy("  Attempt to set the colormap.");
	report_strategy("  Verify that a BadMatch error occurs.");
	report_strategy("else");
	report_strategy("  UNSUPPORTED");

	tpstartup();
	setargs();
	if (config.alt_screen == -1) {
		unsupported("No alternate screen supported");
		return;
	}

	vi.screen = config.alt_screen;
	vinfo = XGetVisualInfo(Dsp, VisualScreenMask, &vi, &count);

	for (resetvinf(VI_WIN); (!found && nextvinf(&vp)); ) {
		for (i = 0; i < count; i++) {
			vp1 = &vinfo[i];
			if (vp1->visual == vp->visual)
			{
				found = 1;
				break;
			}	
		}
	}

	if (!found) {
		unsupported("Cannot create a colormap on the alternate screen of the same visual type as a window on the main screen");
		return;
	}

	cm = XCreateColormap(display, RootWindow(display, config.alt_screen),
			vp1->visual, AllocNone);

	attributes->colormap = cm;
	valuemask = CWColormap;

	w = makeinout(None, (Visual *)CopyFromParent, CopyFromParent, XCWA_NORMAL);

	startcall(display);
	if (isdeleted())
		return;
	XChangeWindowAttributes(display, w, valuemask, attributes);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;

	XFreeColormap(display, cm);
	for(i=0; i<count; i++)
		XFree((char*)&vinfo[i]);
	tpcleanup();
	pfcount(pass, fail);
}

static void t031(){

XWindowAttributes p_attributes;
Colormap	cm;
int 	found = 0;
XVisualInfo	*vp;
int 	pass = 0, fail = 0;

 	report_purpose(31);

	report_assertion("Assertion XChangeWindowAttributes-31.(A)");
	report_assertion("When colormap and the window do not have the same visual");
	report_assertion("type, then a BadMatch error occurs.");

	report_strategy("If two different visual types are supported:");
	report_strategy("  Create colour map of different visual to window.");
	report_strategy("  Attempt to set colourmap to created colour map.");
	report_strategy("  Verify that a BadMatch error occurs.");
	report_strategy("else");
	report_strategy("  UNSUPPORTED.");

	tpstartup();
	setargs();
	/* This is set for XCreateWindow, but not for XChangeWindowAttributes */
	parent = DRW(Dsp);

	XGetWindowAttributes(display, parent, &p_attributes);

	visual = p_attributes.visual;
	depth = p_attributes.depth;

	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		if (vp->visual != visual)
		{
			found = 1;
			break;
		}
	}

	if (!found) {
		unsupported("Only one visual type supported");
		return;
	}


	cm = XCreateColormap(display, DRW(display) , vp->visual, AllocNone);

	attributes->colormap = cm;
	valuemask = CWColormap;

	w = makeinout(parent, visual, depth, XCWA_NORMAL);
	startcall(display);
	if (isdeleted())
		return;
	(void)XChangeWindowAttributes(display, w, valuemask, attributes);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;

	XFreeColormap(display, cm);
	tpcleanup();
	pfcount(pass, fail);
}

static void t032(){

Colormap	cm;
int 	pass = 0, fail = 0;

 	report_purpose(32);

	report_assertion("Assertion XChangeWindowAttributes-32.(A)");
	report_assertion("When colormap is CopyFromParent and the parent window has a");
	report_assertion("colormap of None, then a BadMatch error occurs.");

	report_strategy("Create a window with a colormap.");
	report_strategy("Free the colormap the window.");
	report_strategy("Call function with colormap of CopyFromParent.");
	report_strategy("Verify BadMatch error occurred.");

	tpstartup();
	setargs();
	parent = makeinout( DRW(display),
		XDefaultVisual(display, XDefaultScreen(display) ) ,
		CopyFromParent, XCWA_NORMAL);

	cm = XCreateColormap(display, parent ,
			XDefaultVisual(display, XDefaultScreen(display)),
			AllocNone);

	XSetWindowColormap(display, parent, cm);

	attributes->colormap = CopyFromParent;
	valuemask = CWColormap;

	w = makeinout(parent, (Visual *)CopyFromParent,
		CopyFromParent, XCWA_NORMAL);
	XFreeColormap(display, cm);
	startcall(display);
	if (isdeleted())
		return;
	(void)XChangeWindowAttributes(display, w, valuemask, attributes);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

static void t033(){

int 	pass = 0, fail = 0;

 	report_purpose(33);

	report_assertion("Assertion XChangeWindowAttributes-33.(A)");
	report_assertion("When the window has class InputOnly and border_width is not");
	report_assertion("zero, then a BadMatch error occurs.");

	report_strategy("Set border_width to contain non zero.");
	report_strategy("Verify that a BadMatch error occurs.");

	tpstartup();
	setargs();
	notinuse("%s cannot be used to change the border_width",TestName);
	tpcleanup();
	pfcount(pass, fail);
}

static void t034(){

int	i;
int	n;
unsigned long	vals[NM_LEN];
static	unsigned long	validbits[] = {
	ForgetGravity ,
	NorthWestGravity ,
	NorthGravity ,
	NorthEastGravity ,
	WestGravity ,
	CenterGravity ,
	EastGravity ,
	SouthWestGravity ,
	SouthGravity ,
	SouthEastGravity ,
	StaticGravity };
int 	pass = 0, fail = 0;

 	report_purpose(34);

	report_assertion("Assertion XChangeWindowAttributes-34.(A)");
	report_assertion("When bit_gravity is other than ForgetGravity,");
	report_assertion("NorthWestGravity, NorthGravity, NorthEastGravity,");
	report_assertion("WestGravity, CenterGravity, EastGravity, SouthWestGravity,");
	report_assertion("SouthGravity, SouthEastGravityor StaticGravity, then a");
	report_assertion("BadValue error occurs.");

	report_strategy("Set bit_gravity to a bad value.");
	report_strategy("Verify that BadValue is generated.");

	tpstartup();
	setargs();
	seterrdef();


	w = makeinout(None, (Visual *)CopyFromParent, CopyFromParent, XCWA_NORMAL);
	
	valuemask = CWBitGravity;

	n = notmaskmember(validbits, NELEM(validbits), vals);

	for (i = 0; i < n ; i++)
	{
		debug(1, "Trying bit_gravity of %d", vals[i]);

		attributes->bit_gravity = vals[i];

		startcall(display);
		if (isdeleted())
			return;
		XChangeWindowAttributes(display, w, valuemask, attributes);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if(geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}	

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

static void t035(){

int	i;
int	n;
unsigned long	vals[NM_LEN];
static	unsigned long	validbits[] = {
	UnmapGravity ,
	NorthWestGravity ,
	NorthGravity ,
	NorthEastGravity ,
	WestGravity ,
	CenterGravity ,
	EastGravity ,
	SouthWestGravity ,
	SouthGravity ,
	SouthEastGravity ,
	StaticGravity };
int 	pass = 0, fail = 0;

 	report_purpose(35);

	report_assertion("Assertion XChangeWindowAttributes-35.(A)");
	report_assertion("When win_gravity is other than UnmapGravity,");
	report_assertion("NorthWestGravity, NorthGravity, NorthEastGravity,");
	report_assertion("WestGravity, CenterGravity, EastGravity, SouthWestGravity,");
	report_assertion("SouthGravity, SouthEastGravityor StaticGravity, then a");
	report_assertion("BadValue error occurs.");

	report_strategy("Set win_gravity to a bad value.");
	report_strategy("Verify that BadValue is generated.");

	tpstartup();
	setargs();
	seterrdef();


	w = makeinout(None, (Visual *)CopyFromParent, CopyFromParent, XCWA_NORMAL);
	
	valuemask = CWWinGravity;

	n = notmaskmember(validbits, NELEM(validbits), vals);

	for (i = 0; i < n ; i++)
	{
		debug(1, "Trying win_gravity of %d", vals[i]);

		attributes->win_gravity = vals[i];

		startcall(display);
		if (isdeleted())
			return;
		XChangeWindowAttributes(display, w, valuemask, attributes);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if(geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}	

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

static void t036(){

int	i;
int	n;
long	vals[NM_LEN];
static	int 	validvalues[] = {
	NotUseful,
	WhenMapped,
	Always };
int 	pass = 0, fail = 0;

 	report_purpose(36);

	report_assertion("Assertion XChangeWindowAttributes-36.(A)");
	report_assertion("When backing_store is other than NotUseful, WhenMapped or");
	report_assertion("Always, then a BadValue error occurs.");

	report_strategy("Set backing_store to a bad value.");
	report_strategy("Verify that BadValue is generated.");

	tpstartup();
	setargs();
	seterrdef();


	w = makeinout(None, (Visual *)CopyFromParent, CopyFromParent, XCWA_NORMAL);
	
	valuemask = CWBackingStore;

	n = notmember(validvalues, NELEM(validvalues), vals);

	for (i = 0; i < n ; i++)
	{
		debug(1, "Trying backing_store of %d", vals[i]);

		attributes->backing_store = vals[i];

		startcall(display);
		if (isdeleted())
			return;
		XChangeWindowAttributes(display, w, valuemask, attributes);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if(geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}	

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

static void t037(){

int	i;
int	n;
long	vals[NM_LEN];
static	int 	validvalues[] = {
	True,
	False };
int 	pass = 0, fail = 0;

 	report_purpose(37);

	report_assertion("Assertion XChangeWindowAttributes-37.(A)");
	report_assertion("When save_under is other than True or False, then a");
	report_assertion("BadValue error occurs.");

	report_strategy("Set save_under to a bad value.");
	report_strategy("Verify that BadValue is generated.");

	tpstartup();
	setargs();
	seterrdef();

	w = makeinout(None, (Visual *)CopyFromParent, CopyFromParent, XCWA_NORMAL);
	
	valuemask = CWSaveUnder;

	n = notmember(validvalues, NELEM(validvalues), vals);

	for (i = 0; i < n ; i++)
	{
		debug(1, "Trying save_under of %d", vals[i]);

		attributes->save_under= vals[i];

		startcall(display);
		if (isdeleted())
			return;
		XChangeWindowAttributes(display, w, valuemask, attributes);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if(geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}	

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

static void t038(){

int	i;
int	n;
unsigned long	vals[NM_LEN];
static	unsigned long	validbits[] = {
	NoEventMask ,
	KeyPressMask ,
	KeyReleaseMask ,
	ButtonPressMask ,
	ButtonReleaseMask ,
	EnterWindowMask ,
	LeaveWindowMask ,
	PointerMotionMask ,
	PointerMotionHintMask ,
	Button1MotionMask ,
	Button2MotionMask ,
	Button3MotionMask ,
	Button4MotionMask ,
	Button5MotionMask ,
	ButtonMotionMask ,
	KeymapStateMask ,
	ExposureMask ,
	VisibilityChangeMask ,
	StructureNotifyMask ,
	ResizeRedirectMask ,
	SubstructureNotifyMask ,
	SubstructureRedirectMask ,
	FocusChangeMask ,
	PropertyChangeMask ,
	ColormapChangeMask ,
	OwnerGrabButtonMask };
int 	pass = 0, fail = 0;

 	report_purpose(38);

	report_assertion("Assertion XChangeWindowAttributes-38.(A)");
	report_assertion("When event_mask is other than a bitwise OR of any of");
	report_assertion("NoEventMask, KeyPressMask, KeyReleaseMask,");
	report_assertion("ButtonPressMask, ButtonReleaseMask, EnterWindowMask,");
	report_assertion("LeaveWindowMask, PointerMotionMask, PointerMotionHintMask,");
	report_assertion("Button1MotionMask, Button2MotionMask, Button3MotionMask,");
	report_assertion("Button4MotionMask, Button5MotionMask, ButtonMotionMask,");
	report_assertion("KeymapStateMask, ExposureMask, VisibilityChangeMask,");
	report_assertion("StructureNotifyMask, ResizeRedirectMask,");
	report_assertion("SubstructureNotifyMask, SubstructureRedirectMask,");
	report_assertion("FocusChangeMask, PropertyChangeMask, ColormapChangeMask or");
	report_assertion("OwnerGrabButtonMask, then a BadValue error occurs.");

	report_strategy("Set event_mask to a bad value.");
	report_strategy("Verify that BadValue is generated.");

	tpstartup();
	setargs();
	seterrdef();

	w = makeinout(None, (Visual *)CopyFromParent, CopyFromParent, XCWA_NORMAL);
	
	valuemask = CWEventMask;

	n = notmaskmember(validbits, NELEM(validbits), vals);

	for (i = 0; i < n ; i++)
	{
		debug(1, "Trying event_mask of %d", vals[i]);

		attributes->event_mask = vals[i];

		startcall(display);
		if (isdeleted())
			return;
		XChangeWindowAttributes(display, w, valuemask, attributes);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if(geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}	

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

static void t039(){

int	i;
int	n;
unsigned long	vals[NM_LEN];
static	unsigned long	validbits[] = {
	NoEventMask ,
	KeyPressMask ,
	KeyReleaseMask ,
	ButtonPressMask ,
	ButtonReleaseMask ,
	EnterWindowMask ,
	LeaveWindowMask ,
	PointerMotionMask ,
	PointerMotionHintMask ,
	Button1MotionMask ,
	Button2MotionMask ,
	Button3MotionMask ,
	Button4MotionMask ,
	Button5MotionMask ,
	ButtonMotionMask ,
	KeymapStateMask ,
	ExposureMask ,
	VisibilityChangeMask ,
	StructureNotifyMask ,
	ResizeRedirectMask ,
	SubstructureNotifyMask ,
	SubstructureRedirectMask ,
	FocusChangeMask ,
	PropertyChangeMask ,
	ColormapChangeMask ,
	OwnerGrabButtonMask };
int 	pass = 0, fail = 0;

 	report_purpose(39);

	report_assertion("Assertion XChangeWindowAttributes-39.(A)");
	report_assertion("When do_not_propagate_mask is other than a bitwise OR of");
	report_assertion("any of NoEventMask, KeyPressMask, KeyReleaseMask,");
	report_assertion("ButtonPressMask, ButtonReleaseMask, EnterWindowMask,");
	report_assertion("LeaveWindowMask, PointerMotionMask, PointerMotionHintMask,");
	report_assertion("Button1MotionMask, Button2MotionMask, Button3MotionMask,");
	report_assertion("Button4MotionMask, Button5MotionMask, ButtonMotionMask,");
	report_assertion("KeymapStateMask, ExposureMask, VisibilityChangeMask,");
	report_assertion("StructureNotifyMask, ResizeRedirectMask,");
	report_assertion("SubstructureNotifyMask, SubstructureRedirectMask,");
	report_assertion("FocusChangeMask, PropertyChangeMask, ColormapChangeMask or");
	report_assertion("OwnerGrabButtonMask, then a BadValue error occurs.");

	report_strategy("Set do_not_propagate_mask to a bad value.");
	report_strategy("Verify that BadValue is generated.");

	tpstartup();
	setargs();
	seterrdef();

	w = makeinout(None, (Visual *)CopyFromParent, CopyFromParent, XCWA_NORMAL);
	
	valuemask = CWDontPropagate ;

	n = notmaskmember(validbits, NELEM(validbits), vals);

	for (i = 0; i < n ; i++)
	{
		debug(1, "Trying do_not_propagate_mask of %d", vals[i]);

		attributes->do_not_propagate_mask = vals[i];

		startcall(display);
		if (isdeleted())
			return;
		XChangeWindowAttributes(display, w, valuemask, attributes);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if(geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}	

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

static void t040(){

int	i;
int	n;
long	vals[NM_LEN];
static	int 	validvalues[] = {
	True,
	False };
int 	pass = 0, fail = 0;

 	report_purpose(40);

	report_assertion("Assertion XChangeWindowAttributes-40.(A)");
	report_assertion("When override_redirect is other than True or False, then a");
	report_assertion("BadValue error occurs.");

	report_strategy("Set override_redirect to a bad value.");
	report_strategy("Verify that BadValue is generated.");

	tpstartup();
	setargs();
	seterrdef();

	w = makeinout(None, (Visual *)CopyFromParent, CopyFromParent, XCWA_NORMAL);
	
	valuemask = CWOverrideRedirect;

	n = notmember(validvalues, NELEM(validvalues), vals);

	for (i = 0; i < n ; i++)
	{
		debug(1, "Trying override_redirect of %d", vals[i]);

		attributes->override_redirect= vals[i];

		startcall(display);
		if (isdeleted())
			return;
		XChangeWindowAttributes(display, w, valuemask, attributes);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if(geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}	

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

static void t041(){

Pixmap	pm;
XVisualInfo	*vp;
int 	found = 0;
int 	pass = 0, fail = 0;

 	report_purpose(41);

	report_assertion("Assertion XChangeWindowAttributes-41.(C)");
	report_assertion("If windows with depth other than one are supported: When");
	report_assertion("border_pixmap and the window do not have the same depth,");
	report_assertion("then a BadMatch error occurs.");

	report_strategy("If a window with depth other than one is supported:");
	report_strategy("  Attempt to set border_pixmap with depth one.");
	report_strategy("  Verify that a BadMatch error occurs with a window depth other than one.");
	report_strategy("else");
	report_strategy("  UNSUPPORTED.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		if (vp->depth != 1) {
			found = 1;
			break;
		}
	}

	if (!found) {
		unsupported("Only windows with depth one are supported");
		return;
	}

	parent = makewin(display, vp);
	pm =  XCreatePixmap(display, parent, 1, 1, 1);

	visual = vp->visual;
	depth = vp->depth;
	attributes->border_pixmap = pm ;
	valuemask = CWBorderPixmap;

	w = makeinout(parent, visual, depth, XCWA_NORMAL);
	startcall(display);
	if (isdeleted())
		return;
	(void)XChangeWindowAttributes(display, w, valuemask, attributes);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;

	XFreePixmap(display, pm);
	tpcleanup();
	pfcount(pass, fail);
}

static void t042(){

XVisualInfo	*vp;
XVisualInfo	*vp2 = 0;
int 	found = 0;
int 	pass = 0, fail = 0;

 	report_purpose(42);

	report_assertion("Assertion XChangeWindowAttributes-42.(C)");
	report_assertion("If multiple window depths are supported: When border_pixmap");
	report_assertion("is CopyFromParent, and the window does not have the same");
	report_assertion("depth as the parent window, then a BadMatch error occurs.");

	report_strategy("If two different depth windows are supported.");
	report_strategy("  Create window with different depth to parent.");
	report_strategy("  Attempt to set border_pixmap to CopyFromParent.");
	report_strategy("  Verify that a BadMatch error occurs.");
	report_strategy("else");
	report_strategy("  UNSUPPORTED.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		if (vp2 == 0) {
			vp2 = vp;
		} else if (vp->depth != vp2->depth) {
			found = 1;
			break;
		}
	}

	if (!found) {
		unsupported("Only one depth of window is supported");
		return;
	}

	parent = makedrawable(display, vp2);
	visual = vp->visual;
	depth = vp->depth;

	attributes->border_pixmap = CopyFromParent;
	valuemask = CWBorderPixmap;

	w = makeinout(parent, visual, depth, XCWA_VISDEPTH);
	startcall(display);
	if (isdeleted())
		return;
	(void)XChangeWindowAttributes(display, w, valuemask, attributes);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

static void t043(){

int 	found = 0;
XVisualInfo	*vp;
XVisualInfo	*vp2;
int 	pass = 0, fail = 0;

 	report_purpose(43);

	report_assertion("Assertion XChangeWindowAttributes-43.(A)");
	report_assertion("When colormap is CopyFromParent and the window does not");
	report_assertion("have the same visual type as the parent window, then a");
	report_assertion("BadMatch error occurs.");

	report_strategy("If two different visual types are supported:");
	report_strategy("  Create a parent of one visual type");
	report_strategy("  Attempt to set colourmap to CopyFromParent on window of different visual type.");
	report_strategy("  Verify that a BadMatch error occurs.");
	report_strategy("else");
	report_strategy("  UNSUPPORTED.");

	tpstartup();
	setargs();

	vp2 = 0;

	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		if(vp2 == 0)
		{
			vp2 = vp;
		}
		else if (vp->visual !=  vp2->visual)
		{
			found = 1;
			break;
		}
	}

	if (!found) {
		unsupported("Only one visual type supported");
		return;
	}

	parent = (Window)makedrawable( display, vp2 );

	visual = vp->visual;
	depth  = vp->depth;

	attributes->colormap = CopyFromParent;
	valuemask = CWColormap;

	w = makeinout(parent, visual, depth, XCWA_VISDEPTH);
	startcall(display);
	if (isdeleted())
		return;
	(void)XChangeWindowAttributes(display, w, valuemask, attributes);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}
	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file ../XCreateWindow/commattr.mc */

static void t044(){

Display *client1;
Display *client2;
int 	pass = 0, fail = 0;

 	report_purpose(44);

	report_assertion("Assertion XChangeWindowAttributes-44.(A)");
	report_assertion("When another client has selected with an event mask");
	report_assertion("SubstructureRedirectMask, then on a call to");
	report_assertion("XChangeWindowAttributes with SubstructureRedirectMask bits");
	report_assertion("set in event_mask a BadAccess error occurs.");

	report_strategy("Create window with client1.");
	report_strategy("Select SubstructureRedirectMask event mask with client1 on this window.");
	report_strategy("Create client2.");
	report_strategy("Call XChangeWindowAttributes with an event_mask set to SubstructureRedirectMask using client2");
	report_strategy("on this window.");
	report_strategy("Verify that a BadAccess error was generated.");

	tpstartup();
	setargs();
	client1 = opendisplay();
	if (client1 == (Display *) NULL) {
		delete("Can not open display");
		return;
	} else
		CHECK;

	w = defwin(client1);
	XSelectInput(client1, w, SubstructureRedirectMask);
	XSync(client1, False);

	client2 = opendisplay();
	if (client2 == (Display *) NULL) {
		delete("Can not open display");
		return;
	} else
		CHECK;

	valuemask = CWEventMask;
	attributes->event_mask = SubstructureRedirectMask;
	display = client2;

	startcall(display);
	if (isdeleted())
		return;
	XChangeWindowAttributes(display, w, valuemask, attributes);
	endcall(display);
	if (geterr() != BadAccess) {
		report("Got %s, Expecting BadAccess", errorname(geterr()));
		FAIL;
	}

	if (geterr() != BadAccess) {
		report("A call to %s did not generate a BadAccess error", TestName);
		FAIL;
	} else
		CHECK;

	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

static void t045(){

Display *client1;
Display *client2;
int 	pass = 0, fail = 0;

 	report_purpose(45);

	report_assertion("Assertion XChangeWindowAttributes-45.(A)");
	report_assertion("When another client has selected with an event mask");
	report_assertion("ResizeRedirectMask, then on a call to");
	report_assertion("XChangeWindowAttributes with ResizeRedirectMask bits set in");
	report_assertion("event_mask a BadAccess error occurs.");

	report_strategy("Create client1.");
	report_strategy("Create window with client1.");
	report_strategy("Select ResizeRedirectMask event mask with client1 on this window.");
	report_strategy("Create client2.");
	report_strategy("Call XChangeWindowAttributes with an event_mask of ResizeRedirectMask using client2 on");
	report_strategy("this window.");
	report_strategy("Verify that a BadAccess error was generated.");

	tpstartup();
	setargs();
	client1 = opendisplay();
	if (client1 == (Display *) NULL) {
		delete("Can not open display");
		return;
	} else
		CHECK;

	w = defwin(client1);
	XSelectInput(client1, w, ResizeRedirectMask);
	XSync(client1, False);

	client2 = opendisplay();
	if (client2 == (Display *) NULL) {
		delete("Can not open display");
		return;
	} else
		CHECK;

	valuemask= CWEventMask;
	attributes->event_mask = ResizeRedirectMask ;
	display = client2;
	startcall(display);
	if (isdeleted())
		return;
	XChangeWindowAttributes(display, w, valuemask, attributes);
	endcall(display);
	if (geterr() != BadAccess) {
		report("Got %s, Expecting BadAccess", errorname(geterr()));
		FAIL;
	}

	if (geterr() != BadAccess) {
		report("A call to %s did not generate a BadAccess error", TestName);
		FAIL;
	} else
		CHECK;

	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

static void t046(){

Display *client1;
Display *client2;
int 	pass = 0, fail = 0;

 	report_purpose(46);

	report_assertion("Assertion XChangeWindowAttributes-46.(A)");
	report_assertion("When another client has selected with an event mask");
	report_assertion("ButtonPressMask, then on a call to XChangeWindowAttributes");
	report_assertion("with ButtonPressMask bits set in event_mask a BadAccess");
	report_assertion("error occurs.");

	report_strategy("Create client1.");
	report_strategy("Create window with client1.");
	report_strategy("Select ButtonPressMask event mask with client1 on this window.");
	report_strategy("Create client2.");
	report_strategy("Call XChangeWindowAttributes with event_mask ButtonPressMask using client2 on this window.");
	report_strategy("Verify that a BadAccess error was generated.");

	tpstartup();
	setargs();
	client1 = opendisplay();
	if (client1 == (Display *) NULL) {
		delete("Can not open display");
		return;
	} else
		CHECK;

	w = defwin(client1);
	XSelectInput(client1, w, ButtonPressMask);
	XSync(client1, False);

	client2 = opendisplay();
	if (client2 == (Display *) NULL) {
		delete("Can not open display");
		return;
	} else
		CHECK;

	valuemask= CWEventMask;
	attributes->event_mask = ButtonPressMask ;
	display = client2;
	startcall(display);
	if (isdeleted())
		return;
	XChangeWindowAttributes(display, w, valuemask, attributes);
	endcall(display);
	if (geterr() != BadAccess) {
		report("Got %s, Expecting BadAccess", errorname(geterr()));
		FAIL;
	}

	if (geterr() != BadAccess) {
		report("A call to %s did not generate a BadAccess error", TestName);
		FAIL;
	} else
		CHECK;

	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ t016, 16 },
	{ t017, 17 },
	{ t018, 18 },
	{ t019, 19 },
	{ t020, 20 },
	{ t021, 21 },
	{ t022, 22 },
	{ t023, 23 },
	{ t024, 24 },
	{ t025, 25 },
	{ t026, 26 },
	{ t027, 27 },
	{ t028, 28 },
	{ t029, 29 },
	{ t030, 30 },
	{ t031, 31 },
	{ t032, 32 },
	{ t033, 33 },
	{ t034, 34 },
	{ t035, 35 },
	{ t036, 36 },
	{ t037, 37 },
	{ t038, 38 },
	{ t039, 39 },
	{ t040, 40 },
	{ t041, 41 },
	{ t042, 42 },
	{ t043, 43 },
	{ t044, 44 },
	{ t045, 45 },
	{ t046, 46 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = fontstartup;
void	(*tet_cleanup)() = fontcleanup;
