/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Status
 *   XIconifyWindow(display, w, screen_number)
 *   Display	*display;
 *   Window	w;
 *   int	screen_number;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XIconifyWindow	1
char    *TestName = "XIconifyWindow";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w


/*
 * Arguments to the XIconifyWindow function
 */
static Display	*display;
static Window	w;
static int	screen_number;


static int 	StatusReturn;

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	w = DRW(Dsp);
	screen_number = DefaultScreen(Dsp);
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Status			status;
Atom			wm_change_state;
XEvent			ev, rev;
int			i;
int			nevents = 0;
XVisualInfo		*vp;
unsigned long		event_mask[2];
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XIconifyWindow-1.(A)");
	report_assertion("A call to XIconifyWindow sends a WM_CHANGE_STATE");
	report_assertion("ClientMessage event with a window of w, a format of 32 and");
	report_assertion("a first data element of IconicState to the root window of");
	report_assertion("the screen specified by the screen_number argument using an");
	report_assertion("event mask of SubstructureRedirectMask|");
	report_assertion("SubstructureNotifyMask and returns non-zero.");

	report_strategy("Create a window using XCreateWindow.");
	report_strategy("Obtain the atom for the string \"WM_CHANGE_STATE\" using XInternAtom.");
	report_strategy("Select SubstructureNotify events on the root window with XSelectInput.");
	report_strategy("Generate an event on the root window using XIconifyWindow.");
	report_strategy("Verify that the call returned non-zero.");
	report_strategy("Verify that an event was generated with XNextEvent.");
	report_strategy("Verify that the event type was ClientMessage.");
	report_strategy("Verify that the event window was correct.");
	report_strategy("Verify that the event message_type was WM_CHANGE_STATE.");
	report_strategy("Verify that the event format was 32.");
	report_strategy("Verify that the first data element of the event structure was IconicState.");
	report_strategy("");
	report_strategy("Select SubstructureRedirect events on the root window with XSelectInput.");
	report_strategy("Generate an event on the root window using XIconifyWindow.");
	report_strategy("Verify that the call returned non-zero.");
	report_strategy("Verify that an event was generated with XNextEvent.");
	report_strategy("Verify that the event type was ClientMessage.");
	report_strategy("Verify that the event window was correct.");
	report_strategy("Verify that the event message_type was WM_CHANGE_STATE.");
	report_strategy("Verify that the event format was 32.");
	report_strategy("Verify that the first data element of the event structure was IconicState.");

	tpstartup();
	setargs();
	resetvinf(VI_WIN);
	nextvinf(&vp);
	w = makewin(display, vp);
	screen_number = DefaultScreen(display);

	event_mask[0] = SubstructureNotifyMask;
	event_mask[1] = SubstructureRedirectMask;

	if( (wm_change_state = XInternAtom(display, "WM_CHANGE_STATE", False)) == None) {
		delete("The string \"WM_CHANGE_STATE\" could not be interned.");
		return;
	} else
		CHECK;

	ev.type = ClientMessage;
	ev.xany.display = display;


	ev.xclient.window = w;
	ev.xclient.message_type = wm_change_state;
	ev.xclient.format = 32;
	ev.xclient.data.l[0] = IconicState;
	ev.xclient.data.l[1] = 0;
	ev.xclient.data.l[2] = 0;
	ev.xclient.data.l[3] = 0;
	ev.xclient.data.l[4] = 0;

	for(i=0; i < 2; i++) {

		startcall(display);
		XSelectInput(display, DRW(display), event_mask[i]);
		endcall(display);
	
		if(geterr() != Success) {
			delete("XSelectInput() failed with an event mask of 0x%lx.", event_mask[i]);
			return;
		} else
			CHECK;
	
		startcall(display);
		if (isdeleted())
			return;
		status = XIconifyWindow(display, w, screen_number);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
	
		if(status == 0) {
			delete("%s() returned zero.", TestName);
			return;
		} else
			CHECK;
	
		rev.type = -1;
		if( (nevents = getevent(display, &rev)) == 0 ) {
			report("No event was generated.");
			FAIL;
		} else {
			CHECK;
			if(nevents != 1) {
				delete("There were %d events generated instead of 1.", nevents);
				return;
			} else	{
				CHECK;
	
				rev.xclient.data.l[1] = 0;
				rev.xclient.data.l[2] = 0;
				rev.xclient.data.l[3] = 0;
				rev.xclient.data.l[4] = 0;
	
				if( checkevent(&ev, &rev) != 0 ) {
					FAIL;
				} else
					CHECK;
			}
		}
	}

	CHECKPASS(11);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.364864 */
static void t002(){

int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XIconifyWindow-2.(B)");
	report_assertion("When the atom name (lqWM_CHANGE_STATE(rq cannot be");
	report_assertion("interned, then a call to XIconifyWindow does not send a");
	report_assertion("message and returns zero.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.364864 */

/* Including from file Mdefcode.tmc.364864 */
static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XIconifyWindow-3.(B)");
	report_assertion("When the ClientMessage event cannot be sent, then a call to");
	report_assertion("XIconifyWindow returns zero.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.364864 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
