/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) 1999,2002 The Open Group
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtAppAddConverter()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>
#include <AvsRectObj.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

#ifndef XavsRChar
#define XavsRChar "Char"
#endif
void XtCVT_Proc2(args, num_args, from_val, to_val)
XrmValuePtr args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
{
	char *str = (char *) (from_val->addr);
	static unsigned char i;
 
	/*
	** Convert string to char 
	*/
	avs_set_event(2, 1);
	to_val->size = sizeof (unsigned char);
	to_val->addr = (XtPointer) &i;
	i = *str;
}

void XtCVT_Proc(args, num_args, from_val, to_val)
XrmValuePtr args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
{
	char *str = (char *) (from_val->addr);
	static unsigned char j;
 
	/*
	** Convert string to char 
	*/
	avs_set_event(1, 1);
	to_val->size = sizeof (unsigned char);
	to_val->addr = (XtPointer) &j;
	j = *str;
}

void XtCVT_Proc3(args, num_args, from_val, to_val)
XrmValuePtr args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
{
	avs_set_event(1, avs_get_event(1)+1);
}
#define NUMARGS 8
XtConvertArgRec cargs[NUMARGS];
int argdata[NUMARGS] = {
	0,	/*don't care*/
	2002,
	0,	
	4004,
	0,	
	0,	
	0,	
	8008	
};

void xcap(w, size, value)
Widget w;
Cardinal *size;
XrmValue *value;
{
	avs_set_event(2, avs_get_event(2)+1);
	value->addr = (XtPointer)&argdata[7];
	value->size = sizeof(argdata[7]);
}

void init_args(pchecknum)
int *pchecknum;
{
	cargs[0].address_mode = XtAddress;
	cargs[0].address_id = (XtPointer)pchecknum;
	cargs[0].size = sizeof(XtPointer);

/*XtAddress*/
	cargs[1].address_mode = XtAddress;
	cargs[1].address_id = (XtPointer)&argdata[1];
	cargs[1].size = sizeof(XtPointer);

/*XtBaseOffset*/
	cargs[2].address_mode = XtBaseOffset;
	cargs[2].address_id = (XtPointer)XtOffset(Widget, core.screen);
	cargs[2].size = sizeof(Screen *);

/*XtImmediate*/
	cargs[3].address_mode = XtImmediate;
	cargs[3].address_id = (XtPointer)argdata[3];
	cargs[3].size = sizeof(argdata[3]);

/*XtResourceString*/
	cargs[4].address_mode = XtImmediate;
	cargs[4].address_id = (XtPointer)argdata[4];
	cargs[4].size = sizeof(argdata[4]);

/*XtResourceQuark*/
	cargs[5].address_mode = XtImmediate;
	cargs[5].address_id = (XtPointer)argdata[5];
	cargs[5].size = sizeof(argdata[5]);

/*XtWidgetBaseOffset*/
	cargs[6].address_mode = XtWidgetBaseOffset;
	cargs[6].address_id = (XtPointer)XtOffset(Widget, core.self);
	cargs[6].size = sizeof(Widget);

/*XtProcedureArg*/
	cargs[7].address_mode = XtProcedureArg;
	cargs[7].address_id = (XtPointer)xcap;
	cargs[7].size = sizeof(XtPointer);
}

void XtCVT_ProcA(args, num_args, from_val, to_val)
XrmValuePtr args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
{
int	checknum;

	avs_set_event(1, avs_get_event(1)+1);
	tet_infoline("TEST: Additional arguments passed to converter");
	if (*num_args != NUMARGS) {
		sprintf(ebuf, "ERROR: expected %d arguments, received %d", NUMARGS, *num_args);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
		return;
	}

	checknum = (int)(*(int *)args[0].addr);

	if (checknum == 0) {
		tet_infoline("ERROR: args[0].addr = 0");
		tet_result(TET_FAIL);
		return;
	}
	if (checknum > NUMARGS) {
		sprintf(ebuf, "ERROR: args[0].addr = %d, should be < %d", checknum, NUMARGS);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
		return;
	}

	if (args[checknum].addr == NULL) {
		sprintf(ebuf, "ERROR: args[%d].addr = NULL", checknum);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
		return;
	}

	switch (checknum) {
	case 1:
	case 7:
		if (((int)*(int *)args[checknum].addr) != argdata[checknum]) {
			sprintf(ebuf, "ERROR: expected args[%d].addr to point to %d points to %d", checknum, argdata[checknum], ((int)*(int *)args[checknum].addr));
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
			return;
		}
		break;
	case 2:
		if (((Screen*)*(Screen**)args[checknum].addr) != topLevel->core.screen) {
			sprintf(ebuf, "ERROR: expected args[%d].addr to point to %p points to %p", checknum, topLevel->core.screen, ((Screen*)*(Screen**)args[checknum].addr));
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
			return;
		}
		break;
	case 3:
		if (((int)*(XPointer *)args[checknum].addr) != argdata[checknum]) {
			sprintf(ebuf, "ERROR: expected args[%d].addr to point to %d points to %d", checknum, argdata[checknum], ((int)*(XPointer *)args[checknum].addr));
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
			return;
		}
		break;
	case 6:
		if (((Widget)*(Widget*)args[checknum].addr) != topLevel->core.self) {
			sprintf(ebuf, "ERROR: expected args[%d].addr to point to %p points to %p", checknum, topLevel->core.self, ((Widget)*(Widget*)args[checknum].addr));
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
			return;
		}
		break;
	default:
		sprintf(ebuf, "ERROR: Unknown argument type %d", checknum);
		tet_infoline(ebuf);
		tet_result(TET_UNRESOLVED);
		return;
	}
	return;
}


#define T_XtAppAddConverter	1
char    *TestName = "XtAppAddConverter";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int status;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtAppAddConverter-1.(A)");
	report_assertion("A successful call to void XtAppAddConverter(app_context,");
	report_assertion("from_type, to_type, converter, convert_args, num_args) shall");
	report_assertion("register converter as the procedure that will be called by");
	report_assertion("the Intrinsics to convert a resource value from the");
	report_assertion("representation type from_type to the type to_type in the");
	report_assertion("application context app_context of the calling process.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tapadconv1", "XtAppAddConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT_Proc");
	XtAppAddConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_Proc,
		 (XtConvertArgList)NULL,
		 (Cardinal)0);
	tet_infoline("TEST: Invoke resource converter XtCVT_Proc");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	XtDirectConvert(XtCVT_Proc, (XrmValuePtr)NULL, (Cardinal)0, &from, &to_in_out);
	tet_infoline("TEST: Procedure XtCVT_Proc was invoked");
	status = avs_get_event(1);
	check_dec(1, status, "XtCVT_Proc invocation count");
	tet_infoline("TEST: Converted results");
	check_char('H', *(char *)to_in_out.addr, "conversion result");
	XtCloseDisplay(XtDisplay(topLevel));
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.1980 */
/* End of included file Mdefcode.tmc.1980 */

static void t002(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
char	charret;
XtCacheRef cache_ref_return;
int status;
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtAppAddConverter-2.(A)");
	report_assertion("When more than one converter is registered for the same");
	report_assertion("from_type and to_type by multiple calls to void");
	report_assertion("XtAppAddConverter(app_context, from_type, to_type,");
	report_assertion("converter, convert_args, num_args) the most recently");
	report_assertion("registered converter shall override the previous ones.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tapadconv1", "XtAppAddConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT_Proc2");
	XtAppAddConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_Proc2,
		 (XtConvertArgList)NULL,
		 (Cardinal)0);
	tet_infoline("TEST: Register XtCVT_Proc for same conversion");
	XtAppAddConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_Proc,
		 (XtConvertArgList)NULL,
		 (Cardinal)0);
	tet_infoline("TEST: Invoke conversion");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	to_in_out.addr = &charret;
	to_in_out.size = 1;
	XtConvertAndStore(
		topLevel,
		XtRString,
		&from,
		XavsRChar,
		&to_in_out);
	tet_infoline("TEST: Converted results");
	check_char('H', *(char *)to_in_out.addr, "conversion result");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Procedure XtCVT_Proc2 was not invoked");
	status = avs_get_event(2);
	check_dec(0, status, "XtCVT_Proc2 invocation count");
	tet_infoline("TEST: Procedure XtCVT_Proc was invoked");
	status = avs_get_event(1);
	check_dec(1, status, "XtCVT_Proc invocation count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.1980 */
/* End of included file Mdefcode.tmc.1980 */

static void t003(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int status;
pid_t pid2;
char thechar[2]={0,0};
char *thestring = "Hello";
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtAppAddConverter-3.(A)");
	report_assertion("On a call to void XtAppAddConverter(app_context, from_type,");
	report_assertion("to_type, converter, convert_args, num_args) the converter");
	report_assertion("procedure shall be registered such that the results of a a");
	report_assertion("previous conversion will be reused for subsequent resource");
	report_assertion("requests with the same source value and conversion");
	report_assertion("arguments.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tapadconv1", "XtAppAddConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT_Proc3");
	XtAppAddConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_Proc3,
		 (XtConvertArgList)NULL,
		 (Cardinal)0);
	tet_infoline("TEST: Invoke conversion");
	from.addr = thestring;
	from.size = strlen(thestring)+1;
	to_in_out.addr = thechar;
	to_in_out.size = sizeof(char);
	XtDirectConvert(XtCVT_Proc3, (XrmValuePtr)NULL, (Cardinal)0, &from, &to_in_out);
	tet_infoline("TEST: Invoke conversion again with same arguments");
	from.addr = thestring;
	from.size = strlen(thestring)+1;
	to_in_out.addr = thechar;
	to_in_out.size = sizeof(char);
	XtDirectConvert(XtCVT_Proc3, (XrmValuePtr)NULL, (Cardinal)0, &from, &to_in_out);
	tet_infoline("TEST: Procedure XtCVT_Proc3 was invoked only once");
	status = avs_get_event(1);
	check_dec(1, status, "XtCVT_Proc3 invocation count");
	XtCloseDisplay(XtDisplay(topLevel));
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.1980 */
/* End of included file Mdefcode.tmc.1980 */

static void t004(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int status;
int checknum;
pid_t pid2;
char	charret;
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtAppAddConverter-4.(A)");
	report_assertion("When a converter is registered by a call to void");
	report_assertion("XtAppAddConverter(app_context, from_type, to_type,");
	report_assertion("converter, convert_args, num_args) with the address_mode");
	report_assertion("member of an XtConvertArgRec structure in the list pointed");
	report_assertion("to by convert_args set to XtAddress it shall be called by");
	report_assertion("the Intrinsics with the data pointed to by the address_id");
	report_assertion("field passed as a conversion argument.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tapadconv1", "XtAppAddConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter");
	checknum = 1;
	init_args(&checknum);
	XtAppAddConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		XtCVT_ProcA,
		(XtConvertArgList)cargs,
		(Cardinal)NUMARGS);
	tet_infoline("TEST: Invoke conversion");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	to_in_out.addr = &charret;
	to_in_out.size = 1;
	XtConvertAndStore(
		topLevel,
		XtRString,
		&from,
		XavsRChar,
		&to_in_out
		);
	XtCloseDisplay(XtDisplay(topLevel));
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Converter was invoked");
	status = avs_get_event(1);
	check_dec(1, status, "converter invocation count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.1980 */
/* End of included file Mdefcode.tmc.1980 */

static void t005(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int status;
int checknum;
pid_t pid2;
char	charret;
pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtAppAddConverter-5.(A)");
	report_assertion("When a converter is registered by a call to void");
	report_assertion("XtAppAddConverter(app_context, from_type, to_type,");
	report_assertion("converter, convert_args, num_args) with the address_mode");
	report_assertion("member of an XtConvertArgRec structure in the list pointed");
	report_assertion("to by convert_args set to XtBaseOffset it shall be called by");
	report_assertion("the Intrinsics with the data at an offset of address_id from");
	report_assertion("the base of the widget, in whose context the converter is");
	report_assertion("invoked, passed as a conversion argument.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tapadconv1", "XtAppAddConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter");
	checknum = 2;
	init_args(&checknum);
	XtAppAddConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		XtCVT_ProcA,
		(XtConvertArgList)cargs,
		(Cardinal)NUMARGS);
	tet_infoline("TEST: Invoke conversion");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	to_in_out.addr = &charret;
	to_in_out.size = 1;
	XtConvertAndStore(
		topLevel,
		XtRString,
		&from,
		XavsRChar,
		&to_in_out
		);
	XtCloseDisplay(XtDisplay(topLevel));
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Converter was invoked");
	status = avs_get_event(1);
	check_dec(1, status, "converter invocation count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.1980 */
/* End of included file Mdefcode.tmc.1980 */

static void t006(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
char	charret;
XtCacheRef cache_ref_return;
int status;
int checknum;
pid_t pid2;
pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtAppAddConverter-6.(A)");
	report_assertion("When a converter is registered by a call to void");
	report_assertion("XtAppAddConverter(app_context, from_type, to_type,");
	report_assertion("converter, convert_args, num_args) with the address_mode");
	report_assertion("member of an XtConvertArgRec structure in the list pointed");
	report_assertion("to by convert_args set to XtImmediate it shall be called by");
	report_assertion("the Intrinsics with the data in the address_id field passed");
	report_assertion("as a conversion argument.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tapadconv1", "XtAppAddConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter");
	checknum = 3;
	init_args(&checknum);
	XtAppAddConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		XtCVT_ProcA,
		(XtConvertArgList)cargs,
		(Cardinal)NUMARGS);
	tet_infoline("TEST: Invoke conversion");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	to_in_out.addr = &charret;
	to_in_out.size = 1;
	XtConvertAndStore(
		topLevel,
		XtRString,
		&from,
		XavsRChar,
		&to_in_out
		);
	XtCloseDisplay(XtDisplay(topLevel));
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Converter was invoked");
	status = avs_get_event(1);
	check_dec(1, status, "converter invocation count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.1980 */
/* End of included file Mdefcode.tmc.1980 */

/* Including from file Mdefcode.tmc.1980 */
static void t007(){

pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtAppAddConverter-7.(B)");
	report_assertion("When a converter is registered by a call to void");
	report_assertion("XtAppAddConverter(app_context, from_type, to_type,");
	report_assertion("converter, convert_args, num_args) with the address_mode");
	report_assertion("member of an XtConvertArgRec structure in the list pointed");
	report_assertion("to by convert_args set to XtResourceString it shall be");
	report_assertion("called by the Intrinsics with the value of the resource for");
	report_assertion("the widget named by the string pointed to by address_id");
	report_assertion("passed as a conversion argument.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.1980 */

/* Including from file Mdefcode.tmc.1980 */
static void t008(){

pid_t	pid;

 	report_purpose(8);

	report_assertion("Assertion XtAppAddConverter-8.(B)");
	report_assertion("When a converter is registered by a call to void");
	report_assertion("XtAppAddConverter(app_context, from_type, to_type,");
	report_assertion("converter, convert_args, num_args) with the address_mode");
	report_assertion("member of an XtConvertArgRec structure in the list pointed");
	report_assertion("to by convert_args set to XtResourceQuark it shall be called");
	report_assertion("by the Intrinsics with the value of the resource for the");
	report_assertion("widget, in whose context the converter is invoked, for the");
	report_assertion("resource string specified by the quark value in the");
	report_assertion("address_id field passed as a conversion argument.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.1980 */

static void t009(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
char	charret;
XtCacheRef cache_ref_return;
int status;
int checknum;
pid_t pid2;
Widget test_widget;
pid_t	pid;

 	report_purpose(9);

	report_assertion("Assertion XtAppAddConverter-9.(A)");
	report_assertion("When a converter is registered by a call to void");
	report_assertion("XtAppAddConverter(app_context, from_type, to_type,");
	report_assertion("converter, convert_args, num_args) with the address_mode");
	report_assertion("member of an XtConvertArgRec structure in the list pointed");
	report_assertion("to by convert_args set to XtWidgetBaseOffset it shall be");
	report_assertion("called by the Intrinsics with the data at an offset of");
	report_assertion("address_id in the closest windowed ancestor of the widget in");
	report_assertion("whose context the converter is called, when the widget is");
	report_assertion("not of a subclass of Core, passed as a conversion argument.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tapadconv1", "XtAppAddConverter");
        tet_infoline("PREP: Create AVS RectObj widget");
        test_widget = XtVaCreateManagedWidget("avsro", avsrectObjClass, topLevel, NULL);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter");
	checknum = 7;
	init_args(&checknum);
	XtAppAddConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		XtCVT_ProcA,
		(XtConvertArgList)cargs,
		(Cardinal)NUMARGS);
	tet_infoline("TEST: Invoke conversion");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	to_in_out.addr = &charret;
	to_in_out.size = 1;
	XtConvertAndStore(
		test_widget,
		XtRString,
		&from,
		XavsRChar,
		&to_in_out
		);
	XtCloseDisplay(XtDisplay(topLevel));
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Converter was invoked");
	status = avs_get_event(1);
	check_dec(1, status, "converter invocation count");
	tet_infoline("TEST: function was invoked");
	status = avs_get_event(2);
	check_dec(1, status, "function invocation count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.1980 */
/* End of included file Mdefcode.tmc.1980 */

static void t010(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
char	charret;
XtCacheRef cache_ref_return;
int status;
int checknum;
pid_t pid2;
pid_t	pid;

 	report_purpose(10);

	report_assertion("Assertion XtAppAddConverter-10.(A)");
	report_assertion("When a converter is registered by a call to void");
	report_assertion("XtAppAddConverter(app_context, from_type, to_type,");
	report_assertion("converter, convert_args, num_args) with the address_mode");
	report_assertion("member of an XtConvertArgRec structure in the list pointed");
	report_assertion("to by convert_args set to XtProcedureArg it shall be called");
	report_assertion("by the Intrinsics with the value returned by the function");
	report_assertion("pointed to by the address_id field passed as a conversion");
	report_assertion("argument.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tapadconv1", "XtAppAddConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter");
	checknum = 7;
	init_args(&checknum);
	XtAppAddConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		XtCVT_ProcA,
		(XtConvertArgList)cargs,
		(Cardinal)NUMARGS);
	tet_infoline("TEST: Invoke conversion");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	to_in_out.addr = &charret;
	to_in_out.size = 1;
	XtConvertAndStore(
		topLevel,
		XtRString,
		&from,
		XavsRChar,
		&to_in_out
		);
	XtCloseDisplay(XtDisplay(topLevel));
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Converter was invoked");
	status = avs_get_event(1);
	check_dec(1, status, "converter invocation count");
	tet_infoline("TEST: function was invoked");
	status = avs_get_event(2);
	check_dec(1, status, "function invocation count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.1980 */
/* End of included file Mdefcode.tmc.1980 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
