/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) 1999 The Open Group
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   XtInputId
 *   XtAddInput()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

XtInputId input_ret;
char *msg = "Hello World";
int acount = 0;
FILE *fid;
/*
** Procedure XtTMO_Proc
*/
void XtTMO_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	tet_infoline("ERROR: 5 seconds elapsed without input procedure being called");
	tet_result(TET_FAIL);
	exit(0);
}
/*
** Procedure XtIOP_Proc
*/
void XtIOP_Proc(client_data, source, id)
XtPointer client_data;
int *source;
XtInputId *id;
{
	avs_set_event(1,avs_get_event(1)+1);
	if (acount++ != 0)
		return;
	tet_infoline("TEST: InputID passed to callback matches return from XtAddInput");
	if (*id != input_ret) {
		sprintf(ebuf, "ERROR: InputId passed to callback was %#x, InputId returned by XtAddInput was %#x, should be identical", id, input_ret);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
		return;
	}
	tet_infoline("TEST: Source passed to callback matches that passed to XtAddInput");
	if (*source != fileno(fid)) {
		sprintf(ebuf, "ERROR: Source passed to callback was %#x, source passed to XtAddInput was %#x, should be identical", *source, fileno(fid));
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
		return;
	}
	tet_infoline("TEST: Client data passed to callback matches that passed to XtAddInput");
	if (strncmp(client_data, msg, sizeof(msg)) != 0) {
		sprintf(ebuf, "ERROR: Client_data passed to callback was %s, Client_data passed to XtAddInput was %s, should be identical", client_data, msg);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
		return;
	}
	exit(0);
}


#define T_XtAddInput	1
char    *TestName = "XtAddInput";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

const char *data;
int status = 0;
pid_t pid2;
pid_t pid3;
int pstatus;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtAddInput-1.(A)");
	report_assertion("If the implementation is POSIX-based: A successful call to");
	report_assertion("XtInputId XtAddInput(source, condition, proc, client_data)");
	report_assertion("when condition is XtInputReadMask shall register proc as the");
	report_assertion("procedure that will be called for the default application");
	report_assertion("context of the calling process when the file descriptor");
	report_assertion("source has data to be read and return an identifier for it.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

if (config.posix_system != 0) {
	FORK(pid3);
	avs_set_event(1, 0);
	avs_xt_hier_def("Taddinput1", "XtAddInput");
	data = outfile("data1");
	FORK(pid2);
	sprintf(ebuf, "PREP: Open file %s for read", data);
	tet_infoline(ebuf);
	if (( fid = (FILE *)fopen(data, "w+")) == NULL ) {
		sprintf(ebuf, "ERROR: Could not open file %s", data);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Register file as an input source");
	input_ret = XtAddInput(fileno(fid), (XtPointer)XtInputReadMask, XtIOP_Proc, (XtPointer)msg);
	tet_infoline("TEST: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	/*
	** during idle time file should be read, exit after 5 seconds
	*/
	tet_infoline("TEST: Start XtMainLoop, stop with timeout after 5 seconds");
	XtAddTimeOut((unsigned long)5000, XtTMO_Proc, topLevel);
	tet_infoline("TEST: Loop for events");
	XtMainLoop();
	LKROF(pid2, AVSXTTIMEOUT-4);
	unlink(data);
	KROF3(pid3, pstatus, AVSXTTIMEOUT-2);
        if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
        }
	else {
		tet_infoline("TEST: Input procedure was invoked");
		status = avs_get_event(1);
		check_dec(1, status, "XtIOP_Proc invoked status");
		tet_result(TET_PASS);
	}
}else {
        tet_infoline("INFO: Not configured as a POSIX system");
        tet_result(TET_UNSUPPORTED);
}

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3220 */
/* End of included file Mdefcode.tmc.3220 */

static void t002(){

const char *data;
int status = 0;
pid_t pid2;
pid_t pid3;
int pstatus;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtAddInput-2.(C)");
	report_assertion("If the implementation is POSIX-based: A successful call to");
	report_assertion("XtInputId XtAddInput(source, condition, proc, client_data)");
	report_assertion("when condition is XtInputWriteMask shall register proc as");
	report_assertion("the procedure that will be called when the file descriptor");
	report_assertion("source is ready for writing.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

if (config.posix_system != 0) {
	FORK(pid3);
	avs_set_event(1, 0);
	avs_xt_hier_def("Taddinput1", "XtAddInput");
	data = outfile("data1");
	FORK(pid2);
	sprintf(ebuf, "PREP: Open file %s for write", data);
	tet_infoline(ebuf);
	if (( fid = (FILE *)fopen(data, "w+")) == NULL ) {
		sprintf(ebuf, "ERROR: Could not open file %s", data);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Register file as an input source");
	input_ret = XtAddInput(fileno(fid), (XtPointer)XtInputWriteMask, XtIOP_Proc, (XtPointer)msg);
	tet_infoline("TEST: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	/*
	** during idle time file should be ready, exit after 5 seconds
	*/
	tet_infoline("TEST: Start XtMainLoop, stop with timeout after 5 seconds");
	XtAddTimeOut((unsigned long)5000, XtTMO_Proc, topLevel);
	tet_infoline("TEST: Loop for events");
	XtMainLoop();
	LKROF(pid2, AVSXTTIMEOUT-4);
	unlink(data);
	KROF3(pid3, pstatus, AVSXTTIMEOUT-2);
        if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
        }
	else {
		tet_infoline("TEST: Input procedure was invoked");
		status = avs_get_event(1);
		check_dec(1, status, "XtIOP_Proc invoked status");
		tet_result(TET_PASS);
	}
}else {
        tet_infoline("INFO: Not configured as a POSIX system");
        tet_result(TET_UNSUPPORTED);
}

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3220 */
/* End of included file Mdefcode.tmc.3220 */

/* Including from file Mdefcode.tmc.3220 */
static void t003(){

pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtAddInput-3.(D)");
	report_assertion("If the implementation is POSIX-based: A successful call to");
	report_assertion("XtInputId XtAddInput(source, condition, proc, client_data)");
	report_assertion("when condition is XtInputExceptMask shall register proc as");
	report_assertion("the procedure that will be called when the file descriptor");
	report_assertion("source has exception data.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3220 */

/* Including from file Mdefcode.tmc.3220 */
static void t004(){

pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtAddInput-4.(D)");
	report_assertion("If the implementation is POSIX-based: A call to XtInputId");
	report_assertion("XtAddInput(source, condition, proc, client_data) when");
	report_assertion("condition is some combination of XtInputReadMask,");
	report_assertion("XtInputWriteMask, and XtInputExceptMask shall be the");
	report_assertion("equivalent of separate calls to XtAppAddInput for each");
	report_assertion("option specified in condition.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3220 */

static void t005(){

const char *data;
int status = 0;
pid_t pid2;
pid_t pid3;
int pstatus;
pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtAddInput-5.(C)");
	report_assertion("If the implementation is POSIX-based: A successful call to");
	report_assertion("XtInputId XtAddInput(source, condition, proc, client_data)");
	report_assertion("shall cause client_data to be passed to proc when it is");
	report_assertion("invoked.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

if (config.posix_system != 0) {
	FORK(pid3);
	avs_set_event(1, 0);
	avs_xt_hier_def("Taddinput1", "XtAddInput");
	data = outfile("data1");
	FORK(pid2);
	sprintf(ebuf, "PREP: Open file %s for read", data);
	tet_infoline(ebuf);
	if (( fid = (FILE *)fopen(data, "w+")) == NULL ) {
		sprintf(ebuf, "ERROR: Could not open file %s", data);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Register file as an input source");
	input_ret = XtAddInput(fileno(fid), (XtPointer)XtInputReadMask, XtIOP_Proc, (XtPointer)msg);
	tet_infoline("TEST: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	/*
	** during idle time file should be read, exit after 5 seconds
	*/
	tet_infoline("TEST: Start XtMainLoop, stop with timeout after 5 seconds");
	XtAddTimeOut((unsigned long)5000, XtTMO_Proc, topLevel);
	tet_infoline("TEST: Loop for events");
	XtMainLoop();
	LKROF(pid2, AVSXTTIMEOUT-4);
	unlink(data);
	KROF3(pid3, pstatus, AVSXTTIMEOUT-2);
        if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
        }
	else {
		tet_infoline("TEST: Input procedure was invoked");
		status = avs_get_event(1);
		check_dec(1, status, "XtIOP_Proc invoked status");
		tet_result(TET_PASS);
	}
}else {
        tet_infoline("INFO: Not configured as a POSIX system");
        tet_result(TET_UNSUPPORTED);
}

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3220 */
/* End of included file Mdefcode.tmc.3220 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
