/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) 2004 The Open Group
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   String
 *   XtNew()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

char *array;

void XtEM_Proc(str, str2, str3, str4, str5, car)
String str, str2, str3, str4, *str5;
Cardinal *car;
{
	XtFree(array);
	avs_set_event(1,1);
}


#define T_XtNew	1
char    *TestName = "XtNew";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Widget topLevel;
char *ptr;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtNew-1.(A)");
	report_assertion("A call to type *XtNew(type) shall allocate storage for a");
	report_assertion("new instance of type type and return a pointer to the");
	report_assertion("allocated storage.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	tet_infoline("PREP: Initialize toolkit, Open display and Create topLevel root widget");
	topLevel = (Widget) avs_xt_init("Tnew1", NULL, 0);
	tet_infoline("PREP: Set up the XtToolkitError handler");
	app_ctext = XtWidgetToApplicationContext(topLevel);
	XtAppSetErrorMsgHandler(app_ctext, xt_handler);
	tet_infoline("TEST: XtNew shall allocate storage for type");
	ptr = XtNew(char);
	/*actually will likely get a SIGSEGV if there's a problem*/
	*ptr = 2;
	if (*ptr != 2) {
		tet_infoline("ERROR: Storage not allocated correctly");
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2548 */
/* End of included file Mdefcode.tmc.2548 */

static void t002(){

Widget topLevel;
size_t num;
int status;
char *ptr;
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtNew-2.(A)");
	report_assertion("When there is insufficient memory to allocate storage for");
	report_assertion("the new instance of type type a call to type *XtNew(type)");
	report_assertion("shall issue an allocError error and return NULL.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	tet_infoline("PREP: Initialize toolkit, Open display and Create topLevel root widget");
	topLevel = (Widget) avs_xt_init("Tnew2", NULL, 0);
	tet_infoline("PREP: Set up the XtToolkitError handler");
	app_ctext = XtWidgetToApplicationContext(topLevel);
	XtAppSetErrorMsgHandler(app_ctext, &XtEM_Proc);
	tet_infoline("PREP: Malloc available memory");
	num = mem_limit();
	array = (char *) XtCalloc(num, 4);
	tet_infoline("TEST: XtNew shall call XtErrorMsg");
	ptr = XtNew(char);
	status = avs_get_event(1);
	if (status != 1) {
		tet_infoline("ERROR: Error message handler was not called");
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2548 */
/* End of included file Mdefcode.tmc.2548 */

/* Including from file Mdefcode.tmc.2548 */
static void t003(){

pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtNew-3.(B)");
	report_assertion("The order and contiguity of the storage allocated by");
	report_assertion("successive calls to type *XtNew(type).");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.2548 */

/* Including from file Mdefcode.tmc.2548 */
static void t004(){

pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtNew-4.(B)");
	report_assertion("A successful call to type *XtNew(type) shall return a");
	report_assertion("pointer to an object that is disjoint from any other object.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.2548 */

/* Including from file Mdefcode.tmc.2548 */
static void t005(){

pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtNew-5.(B)");
	report_assertion("The pointer returned by a successful call to type");
	report_assertion("*XtNew(type) shall point to the lowest byte address of the");
	report_assertion("allocated space.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.2548 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
