/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   XtAppContext
 *   XtDisplayToApplicationContext()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

/*
** XtEMH_Proc
*/
void XtEMH_Proc(str, str2, str3, str4, str5, car)
String str, str2, str3, str4, *str5;
Cardinal *car;
{
	avs_set_event(1, 1);
	exit(0);
}


#define T_XtDisplayToApplicationContext	1
char    *TestName = "XtDisplayToApplicationContext";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

XtAppContext app_ctext_good;
Display *display_good;
Widget labelw_good;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtDisplayToApplicationContext-1.(A)");
	report_assertion("A successful call to XtAppContext");
	report_assertion("XtDisplayToApplicationContext(display) shall return the");
	report_assertion("application context in which the display display was");
	report_assertion("initialized.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tdispltac1", "XtDisplayToApplicationContext");
	tet_infoline("PREP: Create label widget `Hello' in boxw1 widget");
	labelw_good = (Widget) CreateLabelWidget("Hello", boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get the display pointer for label widget `Hello' ");
	if ( ( display_good = XtDisplay(labelw_good) ) == NULL ) {
		sprintf(ebuf, "ERROR: Expected valid display pointer returned NULL");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Check the application context is valid");
	 app_ctext_good = XtDisplayToApplicationContext(display_good);
	 if (app_ctext_good == NULL) {
		sprintf(ebuf, "ERROR: Expected valid application context Received NULL");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2708 */
/* End of included file Mdefcode.tmc.2708 */

static void t002(){

Display *display;
pid_t pid2;
int invoked = 0;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtDisplayToApplicationContext-2.(A)");
	report_assertion("A call to XtAppContext");
	report_assertion("XtDisplayToApplicationContext(display) when display is not");
	report_assertion("an Intrinsics initialized display shall issue an error");
	report_assertion("message.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tdispltac1", "XtDisplayToApplicationContext");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Register XtEMH_Proc to be called on error");
	tet_infoline("PREP: conditions");
	XtAppSetErrorMsgHandler(app_ctext, XtEMH_Proc);
	tet_infoline("TEST: Display unknown returns error");
	XtDisplayToApplicationContext(display);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Error handler was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtEMH_Proc invoked status");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2708 */
/* End of included file Mdefcode.tmc.2708 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
