/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Status
 *   XGetWindowAttributes(display, w, window_attributes_return)
 *   Display *display;
 *   Window w;
 *   XWindowAttributes *window_attributes_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XGetWindowAttributes	1
char    *TestName = "XGetWindowAttributes";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w


/*
 * Arguments to the XGetWindowAttributes function
 */
static Display *display;
static Window w;
static XWindowAttributes *window_attributes_return;


static int 	StatusReturn;

XWindowAttributes w_a;

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	w = 0;
	window_attributes_return = &w_a;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	w = ErrdefWindow;
}

static void t001(){

Window parent;
int x, y, depth;
unsigned int width, height, border_width, class;
XVisualInfo *vinf;
Visual *visual;
unsigned long valuemask;
XSetWindowAttributes attributes;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XGetWindowAttributes-1.(A)");
	report_assertion("A call to XGetWindowAttributes on an existing window w");
	report_assertion("returns True, and the current attributes for the specified");
	report_assertion("window w to the window_attributes_return structure.");

	report_strategy("Create a colormap.");
	report_strategy("Install a colormap.");
	report_strategy("Create a window.");
	report_strategy("Call XGetWindowAttributes to obtain the window attributes.");
	report_strategy("Verify the window attributes were returned as expected.");

	tpstartup();
	setargs();
/* Create a window. */
	resetvinf(VI_WIN);
	if( !nextvinf(&vinf) ) {
		delete("nextvinf call returned false");
		return;
	} else
		CHECK;

	parent = DefaultRootWindow(Dsp);
	x = 5;
	y = 10;
	width = 15;
	height = 20;
	border_width = 3;
	depth = vinf->depth;
	class = InputOutput;
	visual= vinf->visual;
	valuemask = CWBitGravity | CWWinGravity | CWBackingStore |
		CWBackingPlanes | CWBackingPixel | CWSaveUnder | CWColormap |
		CWOverrideRedirect | CWBorderPixel;

	attributes.bit_gravity = NorthGravity;
	attributes.win_gravity = SouthGravity;
	attributes.backing_store = WhenMapped;
	attributes.backing_planes= 3;
	attributes.backing_pixel = 1;
	attributes.save_under = True;

        /*
         * Create a colormap of the correct visual type, since there are
         * no guarantees that the selected visual is the default visual.
	 * Install the colormap to ensure that we can test the
	 * map_installed value
         */
	attributes.colormap = makecolmap(display, vinf->visual, AllocNone);
	XInstallColormap( display, attributes.colormap );

        /*
         * Set the window border pixel also, since it is possible that the
         * window visual does not match that of it's parent (the root),
         * causing a BadMatch error since the default border pixmap is
         * CopyFromParent.
         */
        attributes.border_pixel = 0;

	attributes.override_redirect = True;

	w = XCreateWindow(display, parent, x, y, width, height, border_width,
			depth, class, visual, valuemask, &attributes);
	regid(display, (union regtypes *)&w, REG_WINDOW);

/* Call xname to obtain the window attributes. */
	startcall(display);
	if (isdeleted())
		return;
	StatusReturn = XGetWindowAttributes(display, w, window_attributes_return);
	endcall(display);
	if (StatusReturn == 0) {
		report("Status returned was %d", StatusReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify the window attributes were returned as expected. */
#ifdef TESTING
	x--; y--; width--; height--; class--; depth--;
	attributes.bit_gravity = EastGravity;
	attributes.win_gravity = WestGravity;
	attributes.backing_store = NotUseful;
	attributes.backing_planes= 5;
	attributes.backing_pixel = 0;
	attributes.save_under = False;
	attributes.colormap = CopyFromParent;
	attributes.all_event_masks = StructureNotifyMask;
	attributes.your_event_mask = StructureNotifyMask;
	attributes.do_not_propagate_mask = StructureNotifyMask;
	attributes.override_redirect = False;
#endif
	if (w_a.x != x || w_a.y != y) {
		FAIL;
		report("%s did not return expected x,y coordinates", TestName);
		trace("Expected x=%d, y=%d", x, y);
		trace("Returned x=%d, y=%d", w_a.x, w_a.y);
	} else
		CHECK;

	if (w_a.width != width) {
		FAIL;
		report("%s did not return expected width", TestName);
		trace("Expected width=%u", width);
		trace("Returned width=%u", w_a.width);
	} else
		CHECK;

	if (w_a.height != height) {
		FAIL;
		report("%s did not return expected height", TestName);
		trace("Expected height=%u", height);
		trace("Returned height=%u", w_a.height);
	} else
		CHECK;

	if (w_a.border_width != border_width) {
		FAIL;
		report("%s did not return expected border width", TestName);
		trace("Expected border_width=%u", border_width);
		trace("Returned border_width=%u", w_a.border_width);
	} else
		CHECK;

	if (w_a.depth != depth) {
		FAIL;
		report("%s did not return expected depth", TestName);
		trace("Expected depth=%d", depth);
		trace("Returned depth=%d", w_a.depth);
	} else
		CHECK;

	if (XVisualIDFromVisual(w_a.visual) != XVisualIDFromVisual(visual)) {
		FAIL;
		report("%s did not return expected visual", TestName);
		trace("Expected visual=%d", XVisualIDFromVisual(visual));
		trace("Returned visual=%d", XVisualIDFromVisual(w_a.visual));
	} else
		CHECK;

	if (w_a.root != parent) {
		FAIL;
		report("%s did not return expected root window", TestName);
		trace("Expected root window=%d", parent);
		trace("Returned root window=%d", w_a.root);
	} else
		CHECK;

	if (w_a.class != class) {
		FAIL;
		report("%s did not return expected class", TestName);
		trace("Expected class=%u", class);
		trace("Returned class=%u", w_a.class);
	} else
		CHECK;

	if  (w_a.bit_gravity != attributes.bit_gravity) {
		FAIL;
		report("%s did not return expected bit gravity", TestName);
		trace("Expected bit_gravity=%s",
			 bitgravityname(attributes.bit_gravity));
		trace("Returned bit_gravity=%s",
			 bitgravityname(w_a.bit_gravity));
	} else
		CHECK;

	if  (w_a.win_gravity != attributes.win_gravity) {
		FAIL;
		report("%s did not return expected win gravity", TestName);
		trace("Expected win_gravity=%s",
			 wingravityname(attributes.win_gravity));
		trace("Returned win_gravity=%s",
			 wingravityname(w_a.win_gravity));
	} else
		CHECK;

	if  (w_a.backing_store != attributes.backing_store) {
		FAIL;
		report("%s did not return expected backing store", TestName);
		trace("Expected backing_store=%s",
			 backingstorename(attributes.backing_store));
		trace("Returned backing_store=%s",
			 backingstorename(w_a.backing_store));
	} else
		CHECK;

	if (w_a.backing_planes != attributes.backing_planes) {
		FAIL;
		report("%s did not return expected backing planes", TestName);
		trace("Expected backing_planes=%u", attributes.backing_planes);
		trace("Returned backing_planes=%u", w_a.backing_planes);
	} else
		CHECK;

	if (w_a.backing_pixel != attributes.backing_pixel) {
		FAIL;
		report("%s did not return expected backing pixel", TestName);
		trace("Expected backing_pixel=%u", attributes.backing_pixel);
		trace("Returned backing_pixel=%u", w_a.backing_pixel);
	} else
		CHECK;

	if (w_a.save_under != attributes.save_under) {
		FAIL;
		report("%s did not return expected save under", TestName);
		trace("Expected save_under=%s",
			 boolname(attributes.save_under));
		trace("Returned save_under=%s",
			 boolname(w_a.save_under));
	} else
		CHECK;

	if (w_a.colormap != attributes.colormap) {
		FAIL;
		report("%s did not return expected colormap", TestName);
		trace("Expected colormap=%d", attributes.colormap);
		trace("Returned colormap=%d", w_a.colormap);
	} else
		CHECK;

	if (w_a.map_installed != True) {
		FAIL;
		report("%s did not return expected map_installed", TestName);
		trace("Expected map_installed=%s",
			 boolname(True));
		trace("Returned map_installed=%s",
			 boolname(w_a.map_installed));
	} else
		CHECK;

	if (w_a.map_state != IsUnmapped ) {
		FAIL;
		report("%s did not return expected map_state", TestName);
		trace("Expected map_state=%s",
			 mapstatename(IsUnmapped));
		trace("Returned map_state=%s",
			 mapstatename(w_a.map_state));
	} else
		CHECK;

	if (w_a.all_event_masks != NoEventMask ) {
		FAIL;
		report("%s did not return expected all_event_masks", TestName);
		trace("Expected all_event_masks=%s",
			 eventmaskname(NoEventMask));
		trace("Returned all_event_masks=%s",
			 eventmaskname((unsigned long)w_a.all_event_masks));
	} else
		CHECK;

	if (w_a.your_event_mask != NoEventMask ) {
		FAIL;
		report("%s did not return expected your_event_mask", TestName);
		trace("Expected your_event_mask=%s",
			 eventmaskname(NoEventMask));
		trace("Returned your_event_mask=%s",
			 eventmaskname((unsigned long)w_a.your_event_mask));
	} else
		CHECK;

	if (w_a.do_not_propagate_mask != NoEventMask ) {
		FAIL;
		report("%s did not return expected do_not_propagate_mask",
			TestName);
		trace("Expected do_not_propagate_mask=%s",
			 eventmaskname(NoEventMask));
		trace("Returned do_not_propagate_mask=%s",
			 eventmaskname((unsigned long)w_a.do_not_propagate_mask));
	} else
		CHECK;

	if (w_a.override_redirect != True) {
		FAIL;
		report("%s did not return expected override_redirect",
			TestName);
		trace("Expected override_redirect=%s",
			boolname(attributes.override_redirect));
		trace("Returned override_redirect=%s",
			boolname(w_a.override_redirect));
	} else
		CHECK;

	if (w_a.screen != DefaultScreenOfDisplay(display) ) {
		FAIL;
		report("%s did not return expected screen pointer",
			TestName);
	} else
		CHECK;
		
	CHECKPASS(23);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.320 */
static void t002(){

int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XGetWindowAttributes-2.(B)");
	report_assertion("When XGetWindowAttributes is called, then a BadDrawable");
	report_assertion("error can occur.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.320 */

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XGetWindowAttributes-3.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	StatusReturn = XGetWindowAttributes(display, w, window_attributes_return);
	endcall(display);
	if (StatusReturn != 0) {
		report("Status returned was %d", StatusReturn);
		FAIL;
	}
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
