/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XrmStringToBindingQuarkList(string, bindings_return, quarks_return)
 *   char *string;
 *   XrmBindingList bindings_return;
 *   XrmQuarkList quarks_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XrmStringToBindingQuarkList	1
char    *TestName = "XrmStringToBindingQuarkList";

/*
 * Defines for different argument types
 */


/*
 * Arguments to the XrmStringToBindingQuarkList function
 */
static char *string;
static XrmBindingList bindings_return;
static XrmQuarkList quarks_return;


#define XSTBQL_MAX_RETURN 10
static XrmBinding xstbql_bret[XSTBQL_MAX_RETURN];
static XrmQuark xstbql_qret[XSTBQL_MAX_RETURN];

static char *xstbql_s1[]={
	"xstbql_test",
	"einse",
	"zwei",
	"drei",
	"vier",
	"funf",};

static char *xstbql_s1prefix[]={
	"*",
	".",
	"*",
	".",
	"*",
	"."};

static int xstbql_ns1=NELEM(xstbql_s1);

static char *xstbql_s2[]={
	"xstbql_test2",
	"Binkleys",
	"Dads",
	"1972",
	"Ford",
	"Pinto"};

static char *xstbql_s2sep[]={
	"*",
	".",
	"*",
	"*",
	".",
	""};

static int xstbql_ns2=NELEM(xstbql_s2);

static char *xstbql_s4[]={
	"xstbql_test2",
	"hazel",
	"wal",
	"coco",
	"pea"};

static char *xstbql_s4prefix[]={
	".",
	"*",
	".",
	"*",
	"."};

static int xstbql_ns4=NELEM(xstbql_s4);


static char *xstbql_s5[]={
	"xstbql_test5.",
	"Calvin*",
	"Hobbes",
	};
static int xstbql_ns5=NELEM(xstbql_s5);

static void
xstbqlclear(value)
XrmQuark value;
{
	int i;

/* Clear the return arrays, to avoid rogue results. */
	for(i=0; i<XSTBQL_MAX_RETURN; i++) 
	{
		xstbql_qret[i]=value;
		xstbql_bret[i]=XrmBindTightly; /* Have to use a value. */
	}

}


static
xstbqlname(value, ptr)
XrmBinding value;
char *ptr;
{
	if(value==XrmBindTightly) {
		strcpy(ptr, "XrmBindTightly");
	} else
	if(value==XrmBindLoosely) {
		strcpy(ptr, "XrmBindLoosely");
	} else
		sprintf(ptr, "UNKNOWN(%d)", (int)value);
}
		

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	string = 0;
	bindings_return = (XrmBindingList) xstbql_bret;
	quarks_return = (XrmQuarkList) xstbql_qret; 
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int  t;
char *buffer1;
char *buffer2;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XrmStringToBindingQuarkList-1.(A)");
	report_assertion("When string is a valid null-terminated resource name format");
	report_assertion("string, then a call to XrmStringToBindingQuarkList returns a");
	report_assertion("quark list in quarks_return corresponding to the components");
	report_assertion("of string.");

	report_strategy("Create the test string.");
	report_strategy("Call XrmStringToBindingQuarkList to obtain the quark and binding lists.");
	report_strategy("Verify that the quark list returned was as expected.");

	tpstartup();
	setargs();
	buffer1 = (char *)malloc( (size_t)256);
	if (buffer1==(char *)NULL) {
		delete("Could not malloc 256 bytes for buffer1.");
		return;
	} else
		CHECK;

	buffer2 = (char *)malloc( (size_t)4096);
	if (buffer2==(char *)NULL) {
		delete("Could not malloc 4096 bytes for buffer2.");
		return;
	} else
		CHECK;

	*buffer1='\0'; /* Make the buffers empty strings. */
	*buffer2='\0';

/* Create the test string. */
	for(t=0; t<xstbql_ns1; t++) {
		strcat(buffer1, xstbql_s1prefix[t]);
		strcat(buffer1, xstbql_s1[t]);
	}
	trace("Testing with '%s'", buffer1);

	xstbqlclear((XrmQuark)0);

/* Call xname to obtain the quark and binding lists. */
	string= buffer1;
	startcall(Dsp);
	if (isdeleted())
		return;
	XrmStringToBindingQuarkList(string, bindings_return, quarks_return);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

#ifdef TESTING
	xstbql_qret[0]=0;
	xstbql_qret[1]=XrmStringToQuark("TESTING");
#endif

/* Verify that the quark list returned was as expected. */
	for(t=0; t<xstbql_ns1; t++) {
		char *ts;

		ts = XrmQuarkToString( xstbql_qret[t] );
		if (ts == (char *)NULL) {
			FAIL;
			report("Quark array[%d]=%d. Represents: NO STRING (expecting '%s')",
				t, xstbql_qret[t], xstbql_s1[t]);
			strcat(buffer2,"<NO STRING>");
		} else
		{
			if(strcmp(xstbql_s1[t], ts)) {
				FAIL;
				report("Quark array[%d]=%d. Represents: '%s' (expecting '%s')",
					t, xstbql_qret[t], ts, xstbql_s1[t]);
			} else {
				CHECK;
				trace("Quark array[%d]=%d. Represents: '%s' as expected.",
					t, xstbql_qret[t], ts );
			}
			strcat(buffer2, ts);
		}
		strcat(buffer2, " ");
	}

	if (fail) {
		report("%s did not split the string into the quarks as expected",
			TestName);
		report("String passed to %s: '%s'", TestName, buffer1);
		report("Quark array represents: %s", buffer2);
	} else
		CHECK;

	CHECKPASS(2+xstbql_ns1+1);
	free(buffer1);
	free(buffer2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int  t;
char *buffer1;
char *buffer2;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XrmStringToBindingQuarkList-2.(A)");
	report_assertion("On a call to XrmStringToBindingQuarkList, the string is");
	report_assertion("separated into components according to the positions of");
	report_assertion("periods and asterisks.");

	report_strategy("Create the test string.");
	report_strategy("Call XrmStringToBindingQuarkList to obtain quark and binding lists.");
	report_strategy("Verify that the quark list returned was as expected.");

	tpstartup();
	setargs();
	buffer1 = (char *)malloc( (size_t)256);
	if (buffer1==(char *)NULL) {
		delete("Could not malloc 256 bytes for buffer1.");
		return;
	} else
		CHECK;

	buffer2 = (char *)malloc( (size_t)4096);
	if (buffer2==(char *)NULL) {
		delete("Could not malloc 4096 bytes for buffer2.");
		return;
	} else
		CHECK;

	*buffer1='\0'; /* Make the buffers empty strings. */
	*buffer2='\0';

/* Create the test string. */
	for(t=0; t<xstbql_ns2; t++) {
		strcat(buffer1, xstbql_s2[t]);
		strcat(buffer1, xstbql_s2sep[t]);
	}
	trace("Testing with '%s'", buffer1);

	xstbqlclear((XrmQuark)0);

/* Call xname to obtain the quark and binding list. */
	string= buffer1;
	startcall(Dsp);
	if (isdeleted())
		return;
	XrmStringToBindingQuarkList(string, bindings_return, quarks_return);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

#ifdef TESTING
	xstbql_qret[0]=0;
	xstbql_qret[1]=XrmStringToQuark("TESTING");
#endif

/* Verify that the quark list returned was as expected. */
	for(t=0; t<xstbql_ns2; t++) {
		char *ts;

		ts = XrmQuarkToString( xstbql_qret[t] );
		if (ts == (char *)NULL) {
			FAIL;
			report("Quark array[%d]=%d. Represents: NO STRING (expecting '%s')",
				t, xstbql_qret[t], xstbql_s2[t]);
			strcat(buffer2,"<NO STRING>");
		} else
		{
			if(strcmp(xstbql_s2[t], ts)) {
				FAIL;
				report("Quark array[%d]=%d. Represents: '%s' (expecting '%s')",
					t, xstbql_qret[t], ts, xstbql_s2[t]);
			} else {
				CHECK;
				trace("Quark array[%d]=%d. Represents: '%s' as expected.",
					t, xstbql_qret[t], ts );
			}
			strcat(buffer2, ts);
		}
		strcat(buffer2, " ");
	}

	if (fail) {
		report("%s did not split the string into the quarks as expected",
			TestName);
		report("String passed to %s: '%s'", TestName, buffer1);
		report("Quark array represents: '%s'", buffer2);
	} else
		CHECK;

	CHECKPASS(2+xstbql_ns2+1);
	free(buffer1);
	free(buffer2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

char ts[64];
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XrmStringToBindingQuarkList-3.(A)");
	report_assertion("When string does not start with a period or asterisk, then");
	report_assertion("a leading period is assumed.");

	report_strategy("Call XrmStringToBindingQuarkList to obtain quark and binding lists.");
	report_strategy("Verify that the binding was correct .");

	tpstartup();
	setargs();
/* Call xname to obtain quark and binding lists. */
	string = "xstbql_test3";
	startcall(Dsp);
	if (isdeleted())
		return;
	XrmStringToBindingQuarkList(string, bindings_return, quarks_return);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that the binding was correct. */
	if ( xstbql_bret[0] != XrmBindTightly ) {
		FAIL;
		xstbqlname(xstbql_bret[0], ts);
		report("%s did not assume a leading period", TestName);
		report("Returned %s", ts);
		report("Expected XrmBindTightly");
	} else
		CHECK;

	CHECKPASS(1);
	
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int  t;
char *buffer1;
char *buffer2, *buffer3;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XrmStringToBindingQuarkList-4.(A)");
	report_assertion("When string is a valid resource name format string, then a");
	report_assertion("call to XrmStringToBindingQuarkList returns a binding list");
	report_assertion("in bindings_return corresponding to the components of string,");
	report_assertion("with components of string starting with an asterisk set to");
	report_assertion("XrmBindLoosely and other components set to XrmBindTightly.");

	report_strategy("Create the test string.");
	report_strategy("Call XrmStringToBindingQuarkList to obtain the quark and binding lists.");
	report_strategy("Verify that the binding list returned was as expected.");

	tpstartup();
	setargs();
	buffer1 = (char *)malloc( (size_t)256);
	if (buffer1==(char *)NULL) {
		delete("Could not malloc 256 bytes for buffer1.");
		return;
	} else
		CHECK;

	buffer2 = (char *)malloc( (size_t)1024);
	if (buffer2==(char *)NULL) {
		delete("Could not malloc 1024 bytes for buffer2.");
		return;
	} else
		CHECK;

	buffer3 = (char *)malloc( (size_t)1024);
	if (buffer3==(char *)NULL) {
		delete("Could not malloc 1024 bytes for buffer3.");
		return;
	} else
		CHECK;

	*buffer1='\0'; /* Make the buffers empty strings. */
	*buffer2='\0';
	*buffer3='\0';

/* Create the test string. */
	for(t=0; t<xstbql_ns4; t++) {
		strcat(buffer1, xstbql_s4prefix[t]);
		strcat(buffer1, xstbql_s4[t]);
	}
	trace("Testing with '%s'", buffer1);

	xstbqlclear((XrmQuark)0);

/* Call xname to obtain the quark and binding lists. */
	string= buffer1;
	startcall(Dsp);
	if (isdeleted())
		return;
	XrmStringToBindingQuarkList(string, bindings_return, quarks_return);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

#ifdef TESTING
	xstbql_bret[0]=(XrmBinding) -256;
#endif

/* Verify that the binding list returned was as expected. */
	for(t=0; t<xstbql_ns4; t++) {
		char retstr[64], expstr[64];
		XrmBinding expect;

		expect = *(xstbql_s4prefix[t])=='*'? XrmBindLoosely:XrmBindTightly;

		xstbqlname(expect, expstr);
		xstbqlname(xstbql_bret[t], retstr);

		if (xstbql_bret[t] != expect) {
			FAIL;
			report("Binding array[%d]=%s. Expecting %s",
				t, retstr, expstr);
		} else {
			CHECK;
			trace("Binding array[%d]=%s as expected.",
				t, retstr);
		}

		strcat(buffer2, expstr);
		strcat(buffer2, " ");

		strcat(buffer3, retstr);
		strcat(buffer3, " ");
	}

	if (fail) {
		report("%s did not split the string into the bindings as expected",
			TestName);
		report("String passed to %s: '%s'", TestName, buffer1);
		report("Expected bindings: %s", buffer2);
		report("Returned bindings: %s", buffer3);
	} else
		CHECK;

	CHECKPASS(3+xstbql_ns4+1);
	free(buffer1);
	free(buffer2);
	free(buffer3);

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

char *buffer1;
XrmQuark unq;
int t;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XrmStringToBindingQuarkList-5.(A)");
	report_assertion("On a call to XrmStringToBindingQuarkList, the");
	report_assertion("quarks_return list is terminated with a zero.");

	report_strategy("Create the test string.");
	report_strategy("Set return buffer with unique quark value.");
	report_strategy("Call XrmStringToBindingQuarkList to obtain the quark and binding lists.");
	report_strategy("Verify that the quark list was zero terminated.");

	tpstartup();
	setargs();
	buffer1 = (char *)malloc( (size_t)256);
	if (buffer1==(char *)NULL) {
		delete("Could not malloc 256 bytes for buffer1.");
		return;
	} else
		CHECK;

	*buffer1='\0';

/* Create the test string. */
	for(t=0; t<xstbql_ns5; t++) {
		strcat(buffer1, xstbql_s5[t]);
	}
	trace("Testing with '%s'", buffer1);

/* Set return buffer with unique quark value. */
	unq=XrmUniqueQuark();
	xstbqlclear(unq);

/* Call xname to obtain the quark and binding lists. */
	string= buffer1;
	startcall(Dsp);
	if (isdeleted())
		return;
	XrmStringToBindingQuarkList(string, bindings_return, quarks_return);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that the quark list was zero terminated. */
	t=0;
	while(t<XSTBQL_MAX_RETURN
		&& xstbql_qret[t] != unq
		&& xstbql_qret[t] != (XrmQuark)0) {
		t++;
	}

	if (t==XSTBQL_MAX_RETURN) {
		int i;
		FAIL;
		report("%s did not return the quark array as expected.",
			TestName);
		report("At least %d quarks returned.", XSTBQL_MAX_RETURN);
		for (i=0; i<XSTBQL_MAX_RETURN; i++)
			report("Quark array[%d]=%d", i, xstbql_qret[i]);
	} else {
		if (xstbql_qret[t] == unq) {
			FAIL;
			report("%s did not terminate the array with a zero.",
				TestName);
		} else
			CHECK;
	}

	CHECKPASS(2);
	free(buffer1);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.512 */
static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XrmStringToBindingQuarkList-6.(B)");
	report_assertion("The result of a call to XrmStringToBindingQuarkList when");
	report_assertion("string is in an encoding other than the Host Portable");
	report_assertion("Character set.");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.512 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = rmstartup;
void	(*tet_cleanup)() = cleanup;
