/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XChangePointerControl(display, do_accel, do_threshold, accel_numerator, accel_denominator, threshold)
 *   Display	*display;
 *   Bool	do_accel;
 *   Bool	do_threshold;
 *   int 	accel_numerator;
 *   int 	accel_denominator;
 *   int 	threshold;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XChangePointerControl	1
char    *TestName = "XChangePointerControl";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XChangePointerControl function
 */
static Display	*display;
static Bool	do_accel;
static Bool	do_threshold;
static int 	accel_numerator;
static int 	accel_denominator;
static int 	threshold;



static int 	oan, oad;
static int 	othresh;

/*
 * Save the original pointer values for restoring at the end of the test.
 */
static void
saveold()
{
	startup();
	if(Dsp)
		XGetPointerControl(Dsp, &oan, &oad, &othresh);
}

static void
restorepoint()
{
	if(Dsp)
		XChangePointerControl(Dsp, True, True, oan, oad, othresh);
	cleanup();
}



/* Value list for use in test t010 */
static int 	do_accelvallist[] = {
	True,
	False,
};



/* Value list for use in test t011 */
static int 	do_thresholdvallist[] = {
	True,
	False,
};


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	do_accel = False;
	do_threshold = False;
	accel_numerator = 0;
	accel_denominator = 0;
	threshold = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int 	newnum, newden, newthresh;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XChangePointerControl-1.(A)");
	report_assertion("When do_accel is True, then the acceleration of the");
	report_assertion("pointer is set to the fraction accel_numerator over");
	report_assertion("accel_denominator.");

	report_strategy("Set do_accel to True.");
	report_strategy("Set numerator and denominator values.");
	report_strategy("Call XChangePointerControl.");
	report_strategy("Verify that acceleration values have been set.");

	tpstartup();
	setargs();
	do_accel = True;
	accel_numerator = 12;
	accel_denominator = 11;

	startcall(display);
	if (isdeleted())
		return;
	XChangePointerControl(display, do_accel, do_threshold, accel_numerator, accel_denominator, threshold);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XGetPointerControl(display, &newnum, &newden, &newthresh);

	if (newnum == accel_numerator)
		CHECK;
	else {
		report("accel_numerator was %d, expecting %d", newnum, accel_numerator);
		FAIL;
	}
	if (newden == accel_denominator)
		CHECK;
	else {
		report("accel_denominator was %d, expecting %d", newden, accel_denominator);
		FAIL;
	}

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int 	newnum, newden, newthresh;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XChangePointerControl-2.(A)");
	report_assertion("When do_threshold is True, then the threshold is set to");
	report_assertion("the value in the threshold argument.");

	report_strategy("Set do_threshold to True.");
	report_strategy("Set value for threshold.");
	report_strategy("Call XChangePointerControl.");
	report_strategy("Verify that threshold value is set correctly.");

	tpstartup();
	setargs();
	do_threshold = True;
	threshold = 43;

	startcall(display);
	if (isdeleted())
		return;
	XChangePointerControl(display, do_accel, do_threshold, accel_numerator, accel_denominator, threshold);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XGetPointerControl(display, &newnum, &newden, &newthresh);

	if (newthresh == threshold)
		CHECK;
	else {
		report("threshold was %d, expecting %d", newthresh, threshold);
		FAIL;
	}

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

int 	newnum, newden, newthresh;
int 	defnum, defden, defthresh;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XChangePointerControl-3.(A)");
	report_assertion("When threshold is -1, then the threshold is set to the");
	report_assertion("default.");

	report_strategy("Set do_threshold to True.");
	report_strategy("Set threshold to -1.");
	report_strategy("Call XChangePointerControl.");
	report_strategy("Obtain default value for threshold.");
	report_strategy("Set threshold to new value. ");
	report_strategy("Call XChangePointerControl.");
	report_strategy("Verify that threshold value is set correctly.");
	report_strategy("Set threshold to -1.");
	report_strategy("Call XChangePointerControl.");
	report_strategy("Verify that threshold value is set to default value.");

	tpstartup();
	setargs();
	do_threshold = True;
	threshold = -1;

	startcall(display);
	if (isdeleted())
		return;
	XChangePointerControl(display, do_accel, do_threshold, accel_numerator, accel_denominator, threshold);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XGetPointerControl(display, &defnum, &defden, &defthresh);

	threshold = defthresh + 1;

	startcall(display);
	if (isdeleted())
		return;
	XChangePointerControl(display, do_accel, do_threshold, accel_numerator, accel_denominator, threshold);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XGetPointerControl(display, &newnum, &newden, &newthresh);

	if (newthresh == threshold)
		CHECK;
	else {
		report("When setting a non-default threshold value,");
		delete("threshold was %d, expecting %d", newthresh, threshold);
		return;
	}

	threshold = -1;

	startcall(display);
	if (isdeleted())
		return;
	XChangePointerControl(display, do_accel, do_threshold, accel_numerator, accel_denominator, threshold);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XGetPointerControl(display, &newnum, &newden, &newthresh);

	if (newthresh == defthresh)
		CHECK;
	else {
		report("When setting default threshold value,");
		report("threshold was %d, expecting %d", newthresh, defthresh);
		FAIL;
	}

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int 	newnum, newden, newthresh;
int 	defnum, defden, defthresh;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XChangePointerControl-4.(A)");
	report_assertion("When accel_numerator is -1, then the numerator of the");
	report_assertion("acceleration is set to the default.");

	report_strategy("Set do_accel to True.");
	report_strategy("Set numerator to -1.");
	report_strategy("Call XChangePointerControl.");
	report_strategy("Obtain default value for numerator.");
	report_strategy("Set numerator to new value. ");
	report_strategy("Call XChangePointerControl.");
	report_strategy("Verify that numerator value is set correctly.");
	report_strategy("Set numerator to -1.");
	report_strategy("Call XChangePointerControl.");
	report_strategy("Verify that numerator value is set to default value.");

	tpstartup();
	setargs();
	do_accel = True;
	accel_numerator = -1;
	accel_denominator = 11;

	startcall(display);
	if (isdeleted())
		return;
	XChangePointerControl(display, do_accel, do_threshold, accel_numerator, accel_denominator, threshold);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XGetPointerControl(display, &defnum, &defden, &defthresh);

	accel_numerator = defnum + 1;

	startcall(display);
	if (isdeleted())
		return;
	XChangePointerControl(display, do_accel, do_threshold, accel_numerator, accel_denominator, threshold);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XGetPointerControl(display, &newnum, &newden, &newthresh);

	if (newnum == accel_numerator)
		CHECK;
	else {
		report("When setting a non-default numerator value,");
		report("accel_numerator was %d, expecting %d", newnum, accel_numerator);
		FAIL;
	}

	accel_numerator = -1;

	startcall(display);
	if (isdeleted())
		return;
	XChangePointerControl(display, do_accel, do_threshold, accel_numerator, accel_denominator, threshold);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XGetPointerControl(display, &newnum, &newden, &newthresh);

	if (newnum == defnum)
		CHECK;
	else {
		report("When setting default numerator value,");
		report("accel_numerator was %d, expecting %d", newnum, defnum);
		FAIL;
	}

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int 	newnum, newden, newthresh;
int 	defnum, defden, defthresh;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XChangePointerControl-5.(A)");
	report_assertion("When accel_denominator is -1, then the denominator of the");
	report_assertion("acceleration is set to the default.");

	report_strategy("Set do_accel to True.");
	report_strategy("Set denominator to -1.");
	report_strategy("Call XChangePointerControl.");
	report_strategy("Obtain default value for denominator.");
	report_strategy("Set denominator to new value. ");
	report_strategy("Call XChangePointerControl.");
	report_strategy("Verify that denominator value is set correctly.");
	report_strategy("Set denominator to -1.");
	report_strategy("Call XChangePointerControl.");
	report_strategy("Verify that denominator value is set to default value.");

	tpstartup();
	setargs();
	do_accel = True;
	accel_numerator = 12;
	accel_denominator = -1;

	startcall(display);
	if (isdeleted())
		return;
	XChangePointerControl(display, do_accel, do_threshold, accel_numerator, accel_denominator, threshold);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XGetPointerControl(display, &defnum, &defden, &defthresh);

	accel_denominator = defden + 1;

	startcall(display);
	if (isdeleted())
		return;
	XChangePointerControl(display, do_accel, do_threshold, accel_numerator, accel_denominator, threshold);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XGetPointerControl(display, &newnum, &newden, &newthresh);

	if (newden == accel_denominator)
		CHECK;
	else {
		report("When setting a non-default denominator value,");
		report("accel_denominator was %d, expecting %d", newden, accel_denominator);
		FAIL;
	}

	accel_denominator = -1;

	startcall(display);
	if (isdeleted())
		return;
	XChangePointerControl(display, do_accel, do_threshold, accel_numerator, accel_denominator, threshold);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XGetPointerControl(display, &newnum, &newden, &newthresh);

	if (newden == defden)
		CHECK;
	else {
		report("When setting default denominator value,");
		report("accel_denominator was %d, expecting %d", newden, defden);
		FAIL;
	}

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

int 	oldnum, oldden, oldthresh;
int 	newnum, newden, newthresh;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XChangePointerControl-6.(A)");
	report_assertion("When the value of the do_accel or do_threshold arguments");
	report_assertion("are False, then the corresponding parameter is not changed.");

	report_strategy("Get old values of parameters.");
	report_strategy("Call XChangePointerControl with do_accel and do_threshold False.");
	report_strategy("Verify no change to parameters.");

	tpstartup();
	setargs();
	XGetPointerControl(display, &oldnum, &oldden, &oldthresh);

	accel_numerator = oldnum+4;
	accel_denominator = oldden+5;
	threshold = oldthresh+2;

	do_accel = False;
	do_threshold = False;

	startcall(display);
	if (isdeleted())
		return;
	XChangePointerControl(display, do_accel, do_threshold, accel_numerator, accel_denominator, threshold);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XGetPointerControl(display, &newnum, &newden, &newthresh);

	if (newnum == oldnum)
		CHECK;
	else {
		report("accel_numerator was changed when do_accel was False");
		FAIL;
	}
	if (newden == oldden)
		CHECK;
	else {
		report("accel_denominator was changed when do_accel was False");
		FAIL;
	}
	if (newthresh == oldthresh)
		CHECK;
	else {
		report("threshold was changed when do_threshold was False");
		FAIL;
	}

	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XChangePointerControl-7.(A)");
	report_assertion("When threshold is a negative number other than -1, then a");
	report_assertion("BadValue error occurs.");

	report_strategy("Set do_threshold to True.");
	report_strategy("Set threshold to negative value other than -1.");
	report_strategy("Verify BadValue error.");

	tpstartup();
	setargs();
	do_threshold = True;
	threshold = -3;

	startcall(display);
	if (isdeleted())
		return;
	XChangePointerControl(display, do_accel, do_threshold, accel_numerator, accel_denominator, threshold);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadValue)
		PASS;
	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XChangePointerControl-8.(A)");
	report_assertion("When accel_numerator or accel_denominator are negative");
	report_assertion("numbers other than -1, then a BadValue error occurs.");

	report_strategy("Set do_accel to True.");
	report_strategy("Set accel parameters to invalid values.");
	report_strategy("Verify BadValue error.");

	tpstartup();
	setargs();
	do_accel = True;

	accel_denominator = 3;
	accel_numerator = -3;

	startcall(display);
	if (isdeleted())
		return;
	XChangePointerControl(display, do_accel, do_threshold, accel_numerator, accel_denominator, threshold);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadValue)
		CHECK;

	accel_denominator = -3;
	accel_numerator = 2;

	startcall(display);
	if (isdeleted())
		return;
	XChangePointerControl(display, do_accel, do_threshold, accel_numerator, accel_denominator, threshold);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadValue)
		CHECK;

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XChangePointerControl-9.(A)");
	report_assertion("When the accel_denominator argument is zero, then a");
	report_assertion("BadValue error occurs.");

	report_strategy("Set do_accel to True.");
	report_strategy("Set accel_denominator to zero.");
	report_strategy("Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	do_accel = True;
	accel_denominator = 0;
	accel_numerator = 1;

	startcall(display);
	if (isdeleted())
		return;
	XChangePointerControl(display, do_accel, do_threshold, accel_numerator, accel_denominator, threshold);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadValue)
		PASS;
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mval.tmc.376 */
/* End of included file Mval.tmc.376 */

/* Including from file error/EVal.mc */
static void t010(){

#undef	VALUE_ARG
#define	VALUE_ARG do_accel
#undef	VALUE_LIST
#define	VALUE_LIST do_accelvallist
#undef NOTMEMTYPE
#define NOTMEMTYPE 
#undef	NOTMEMBER
#define	NOTMEMBER notmember
int 	i;
int 	n;
NOTMEMTYPE
long	vals[NM_LEN];
int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XChangePointerControl-10.(A)");
	report_assertion("When the value of do_accel is other than True or False,");
	report_assertion("then a BadValue error occurs.");

	report_strategy("Obtain a sequence of values which are not in the list specified by VALUE_LIST.");
	report_strategy("For each value:");
	report_strategy("  Call test function with this value in the VALUE_ARG argument.");
	report_strategy("  Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	n = NOTMEMBER(VALUE_LIST, NELEM(VALUE_LIST), vals);

	for (i = 0; i < n; i++) {

		debug(1, "Trying arg of %d", vals[i]);

		VALUE_ARG = vals[i];
		startcall(display);
		if (isdeleted())
			return;
		XChangePointerControl(display, do_accel, do_threshold, accel_numerator, accel_denominator, threshold);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EVal.mc */

/* Including from file Mval.tmc.376 */
/* End of included file Mval.tmc.376 */

/* Including from file error/EVal.mc */
static void t011(){

#undef	VALUE_ARG
#define	VALUE_ARG do_threshold
#undef	VALUE_LIST
#define	VALUE_LIST do_thresholdvallist
#undef NOTMEMTYPE
#define NOTMEMTYPE 
#undef	NOTMEMBER
#define	NOTMEMBER notmember
int 	i;
int 	n;
NOTMEMTYPE
long	vals[NM_LEN];
int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion XChangePointerControl-11.(A)");
	report_assertion("When the value of do_threshold is other than True or False,");
	report_assertion("then a BadValue error occurs.");

	report_strategy("Obtain a sequence of values which are not in the list specified by VALUE_LIST.");
	report_strategy("For each value:");
	report_strategy("  Call test function with this value in the VALUE_ARG argument.");
	report_strategy("  Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	n = NOTMEMBER(VALUE_LIST, NELEM(VALUE_LIST), vals);

	for (i = 0; i < n; i++) {

		debug(1, "Trying arg of %d", vals[i]);

		VALUE_ARG = vals[i];
		startcall(display);
		if (isdeleted())
			return;
		XChangePointerControl(display, do_accel, do_threshold, accel_numerator, accel_denominator, threshold);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EVal.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = saveold;
void	(*tet_cleanup)() = restorepoint;
