/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XDisableAccessControl(display)
 *   Display	*display;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XDisableAccessControl	1
char    *TestName = "XDisableAccessControl";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XDisableAccessControl function
 */
static Display	*display;


#include        "xthost.h"

XHostAddress    *host = xthosts;

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

XHostAddress	*oldhosts;
XHostAddress	*list;
Display	*newclient;
int 	nhosts;
int 	njunk;
Bool	state;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XDisableAccessControl-1.(B)");
	report_assertion("A call to XDisableAccessControl disables the use of the");
	report_assertion("access control list at each connection setup.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Get current host list.");
	report_strategy("Attempt to remove all hosts from list.");
	report_strategy("If this fails with BadAccess:");
	report_strategy("  Report that this host does not have permission to do this.");
	report_strategy("  (Will not have permission for the next part either).");
	report_strategy("  Result is untested.");
	report_strategy("Disable access control with XDisableAccessControl.");
	report_strategy("Verify that state returned by XListHosts is DisableAccess.");
	report_strategy("Verify that a new connection can be made.");

	tpstartup();
	setargs();
	oldhosts = XListHosts(display, &nhosts, &state);

	if (nhosts == 0)
        {
                CATCH_ERROR(display);
                XAddHost(display, host);
                RESTORE_ERROR(display);
                if (GET_ERROR(display) == BadAccess)
                {
                        report("The client does not have permission to disable the acl");
                        untested("  so this assertion cannot be tested.");
                        return;
                }
        }
	CATCH_ERROR(display);
	XRemoveHosts(display, oldhosts, nhosts);
	RESTORE_ERROR(display);

	if (GET_ERROR(display) == BadAccess) {
		report("The client does not have permission to disable the acl");
		untested("  so this assertion cannot be tested.");
		return;
	}

	startcall(display);
	if (isdeleted())
		return;
	XDisableAccessControl(display);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	list = XListHosts(display, &njunk, &state);
	if (state == DisableAccess)
		CHECK;
	else {
		report("Access control state was not DisableAccess (was %d)", state);
		FAIL;
	}

	newclient = XOpenDisplay(config.display);
	if (newclient != (Display*)0)
		CHECK;
	else {
		report("Connections could not be made to host");
		FAIL;
	}

	CHECKPASS(2);

	CATCH_ERROR(display);
	XAddHosts(display, oldhosts, nhosts);
	XSetAccessControl(display, state);
	RESTORE_ERROR(display);
	XFree((char*)oldhosts);
	XFree((char*)list);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XDisableAccessControl-2.(B)");
	report_assertion("When an attempt is made to disable the use of the access");
	report_assertion("control list from a client that is not authorised in a");
	report_assertion("server-dependent way to do so, then a BadAccess error");
	report_assertion("occurs.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Call XDisableAccessControl.");
	report_strategy("If error occurs.");
	report_strategy("  If error is BadAccess");
	report_strategy("	Report Pass.");
	report_strategy("  else");
	report_strategy("	Report Fail.");
	report_strategy("else");
	report_strategy("  Report client is authorised.");
	report_strategy("  Result is untested.");

	tpstartup();
	setargs();
	startcall(display);
	if (isdeleted())
		return;
	XDisableAccessControl(display);
	endcall(display);

	if (geterr() != Success) {
		if (geterr() == BadAccess)
			PASS;
		else {
			report("Expecting BadAccess, was %s", errorname(geterr()));
			FAIL;
		}
	} else {
		untested("This client is authorised to disable the access list");
		untested("  so the assertion cannot be tested");
	}


	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
