/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1993 by the Hewlett-Packard Company.
* 
* Copyright 1990, 1991 UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the names of HP, and UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  HP, and UniSoft
* make no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   XDeviceState *
 *   XQueryDeviceState(display, device)
 *   Display	*display;
 *   XDevice *device;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XQueryDeviceState	1
char    *TestName = "XQueryDeviceState";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XQueryDeviceState function
 */
static Display	*display;
static XDevice *device;


#define KEYMAPLEN 32
#define VALMAPLEN 6
extern ExtDeviceInfo Devs;
static NumValuators;


devtype(dpy, dev, haskeys, hasbuttons, hasvaluators)
Display *dpy;
XDevice *dev;
int *haskeys, *hasbuttons, *hasvaluators;
{
int i, j, ndevices;
XDeviceInfo *list;
XAnyClassPtr any;

    list = XListInputDevices (dpy, &ndevices);
    for (i=0; i<ndevices; i++,list++)
	{
	if (list->id != dev->device_id)
	    continue;
	*haskeys = False;
	*hasbuttons = False;
	*hasvaluators = False;
	any = (XAnyClassPtr) (list->inputclassinfo);
	for (j=0; j<list->num_classes; j++)
	    {
	    switch (any->class)
		{
		case KeyClass:
		    {
		    if (((XKeyInfo *)any)->num_keys)
			*haskeys=True;
		    break;
		    }
		case ButtonClass:
		    {
		    if (((XButtonInfo *)any)->num_buttons)
			*hasbuttons=True;
		    break;
		    }
		case ValuatorClass:
		    {
		    if (((XValuatorInfo *)any)->num_axes)
			{
			*hasvaluators=True;
			NumValuators = (((XValuatorInfo *)any)->num_axes);
			}
		    break;
		    }
		default:
		    break;
		}
	    any = (XAnyClassPtr) ((char *) any + any->length);
	    }
	}
}


pokedev(display, device)
Display *display;
XDevice *device;
{
int i, j, key1;
XDeviceState *state;
XKeyState *ks;
XButtonState *bs;
XValuatorState *vs;
char *keys;
int *vals;
int axes[256];
int haskeys, hasbuttons, hasvaluators, pass=0, fail=0, count=1;

	devtype(display, device, &haskeys, &hasbuttons, &hasvaluators);
	if (!(haskeys & hasbuttons & hasvaluators))
	    {
	    untested("Extension device has no keys, buttons, or valuators");
	    return;
	    }
/*
	key1 = getkeycode(display);
*/
	key1 = getdevkeycode(display, device);
	if (haskeys)
	    {
	    devicekeyrel (display, device, key1);
	    devicerelkeys (device);
	    }
	if (hasbuttons)
	    {
	    devicebuttonrel (display, device, Button1);
	    devicerelbuttons(device);
	    }
	if (hasvaluators)
	    {
	    int count;
	    int nvals = NumValuators < 6 ? NumValuators : 6;
	    for (i=0; i<nvals; i++)
		axes[i] = 0;
	    for (i=0; i<NumValuators; i+=6) {
	        count = NumValuators-i < 6 ? NumValuators-i : 6;
		SimulateDeviceMotionEvent (display, device, False, count, axes,
		    i);
		XSync(display,0);
		}
	    XSync(display,0);
	    }
	startcall(display);
	if (isdeleted())
		return;
	state = XQueryDeviceState(display, device);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (state)
		CHECK;
	else
	    {
	    report("Expecting Success, got error (NULL state returned).");
	    FAIL;
	    return;
	    }
	ks = (XKeyState *) state->data;
	for (i=0; i<state->num_classes; i++)
	    {
	    if (ks->class == KeyClass)
		{
		for (j=0,keys=ks->keys; j<KEYMAPLEN; j++,keys++)
		    if (*keys != 0)
			{
			report("%s: byte %d of keys was %x, should be 0\n",
			    TestName,j,*keys);
			FAIL;
			}
		    else
			CHECK;
		count += KEYMAPLEN;
		}
	    else if (ks->class == ButtonClass)
		{
		bs = (XButtonState *) ks;
		for (j=0,keys=bs->buttons; j<KEYMAPLEN; j++,keys++)
		    if (*keys != 0)
			{
			report("%s: byte %d of buttons was %x, should be 0\n",
			    TestName,j,*keys);
			FAIL;
			}
		    else
			CHECK;
		count += KEYMAPLEN;
		}
	    else if (ks->class == ValuatorClass)
		{
		vs = (XValuatorState *) ks;
		for (j=0,vals=vs->valuators; j<vs->num_valuators; j++,vals++)
		    if (*vals != 0)
			{
			report("%s: valuator %d was %x, should be 0\n",
			    TestName,j,*vals);
			FAIL;
			}
		    else
			CHECK;
		count += vs->num_valuators;
		}
	    ks = (XKeyState *) ((char *) ks + ks->length);
	    }

	if (haskeys)
	    devicekeypress (display, device, key1);
	if (hasbuttons)
	    devicebuttonpress (display, device, Button1);
	if (hasvaluators)
	    {
	    int nvals = vs->num_valuators < 6 ? vs->num_valuators : 6;
	    for (i=0; i<vs->num_valuators; i++)
		axes[i] = i;
	    SimulateDeviceMotionEvent(display,  device, False,  nvals, axes, 0);
	    XSync(display,0);
	    }
	startcall(display);
	if (isdeleted())
		return;
	state = XQueryDeviceState(display, device);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	ks = (XKeyState *) state->data;
	for (i=0; i<state->num_classes; i++)
	    {
	    if (ks->class == KeyClass)
		{
		for (j=0,keys=ks->keys; j<KEYMAPLEN; j++,keys++)
		    if (j != key1 >> 3 && *keys != 0)
			{
			report("%s: byte %d of keys was %x, should be 0\n",
			    TestName,j,*keys);
			FAIL;
			}
		    else if (j== key1 >> 3 && *keys != 1 << (key1 & 7))
			{
			report("%s: byte %d of keys was %x, should be %x\n",
			    TestName,j,*keys, 1 << (key1 & 7));
			FAIL;
			}
		    else
			CHECK;
		count += KEYMAPLEN;
		}
	    else if (ks->class == ButtonClass)
		{
		bs = (XButtonState *) ks;
		for (j=0,keys=bs->buttons; j<KEYMAPLEN; j++,keys++)
		    if (j != Button1 >> 3 && *keys != 0)
			{
			report("%s: byte %d of buttons was %x, should be 0\n",
			    TestName,j,*keys);
			FAIL;
			}
		    else if (j== Button1 >> 3 && *keys != 1 << (Button1 & 7))
			{
			report("%s: byte %d of buttons was %x, should be %x\n",
			    TestName,j,*keys, 1 << (Button1 & 7));
			FAIL;
			}
		    else
			CHECK;
		count += KEYMAPLEN;
		}
	    else if (ks->class == ValuatorClass)
		{
		int nval = vs->num_valuators < 6 ? vs->num_valuators : 6;
		vs = (XValuatorState *) ks;
		for (j=0,vals=vs->valuators; j<nval; j++,vals++)
		    if (*vals != j)
			{
			report("%s: valuator %d was %x, should be %d\n",
			    TestName,j,*vals,j);
			FAIL;
			}
		    else
			CHECK;
		for (j=nval; j<vs->num_valuators; j++,vals++)
		    if (*vals != 0)
			{
			report("%s: valuator %d was %x, should be 0\n",
			    TestName,j,*vals);
			FAIL;
			}
		    else
			CHECK;
		count += vs->num_valuators;
		}
	    ks = (XKeyState *) ((char *) ks + ks->length);
	    }
	if (haskeys)
	    {
	    devicekeyrel (display, device, key1);
	    devicerelkeys (device);
	    }
	if (hasbuttons)
	    {
	    devicebuttonrel (display, device, Button1);
	    devicerelbuttons(device);
	    }
	if (hasvaluators)
	    {
	    int nvals = vs->num_valuators < 6 ? vs->num_valuators : 6;
	    for (i=0; i<nvals; i++)
		axes[i] = 0;
	    for (i=0; i<vs->num_valuators; i+=6) {
		if (i >= vs->num_valuators - 6)
		    nvals = vs->num_valuators - i;
		SimulateDeviceMotionEvent (display, device, False, nvals, axes,
		    i);
		XSync(display,0);
		}
	    }
	CHECKPASS(count);
}

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	device = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int dmn;
XEventClass classes[2];
Window w;
int axes=1, n, i;
XEvent ev;
XDeviceMotionEvent *d;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XQueryDeviceState-1.(B)");
	report_assertion("A successful call to QueryDeviceState resets the");
	report_assertion("DeviceMotionHint state so that the next motion event");
	report_assertion("generated will be sent to interested clients.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Select DeviceMotionNotify and DevicePointerMotionHint classes.");
	report_strategy("Generate some motion events, verify only one is sent.");
	report_strategy("Now call XQueryDeviceState.");
	report_strategy("Generate some motion events, verify another one is sent.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(ValMask))
	    {
	    untested("%s: Required input extension device not present.\n", 
		TestName);
	    return;
	    }
	if(noext(0))
	    return;
	device = Devs.Valuator;
	DeviceMotionNotify(device, dmn, classes[0]);
	DevicePointerMotionHint(device, unused, classes[1]);
	w = defwin(display);
	XSelectExtensionEvent(display, w, classes, 2);
	warppointer (display, w, 1, 1);

	XSync(display,1);
	for (i=0; i<10; i++)
	    SimulateDeviceMotionEvent(display, device, False, 1, &axes, 0);
	XSync(display,0);

	n = getevent(display, &ev);
	if (n != 1)
	    {
	    report("Expecting one event with DeviceMotionHint, got %d",n);
	    FAIL;
	    }
	else
	    CHECK;
	if (ev.type != dmn)
	    {
	    report("Expecting DeviceMotionNotify event, got event type %d",
		ev.type);
	    FAIL;
	    }
	else
	    CHECK;
	d = (XDeviceMotionEvent *) &ev;
	if (d->is_hint != True)
	    {
	    report("Expecting is_hint = True, was False");
	    FAIL;
	    }
	else
	    CHECK;

	startcall(display);
	if (isdeleted())
		return;
	XQueryDeviceState(display, device);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (geterr() == Success)
		CHECK;
	else
	    {
	    report("Expecting Success, got error\n");
	    FAIL;
	    return;
	    }

	XSync(display,1);
	for (i=0; i<10; i++)
	    SimulateDeviceMotionEvent(display,  device, False,  1, &axes, 0);
	XSync(display,0);

	n = getevent(display, &ev);
	if (n != 1)
	    {
	    report("Expecting one event with DeviceMotionHint, got %d",n);
	    FAIL;
	    }
	else
	    CHECK;
	if (ev.type != dmn)
	    {
	    report("Expecting DeviceMotionNotify event, got event type %d",
		ev.type);
	    FAIL;
	    }
	else
	    CHECK;
	d = (XDeviceMotionEvent *) &ev;
	if (d->is_hint != True)
	    {
	    report("Expecting is_hint = True, was False");
	    FAIL;
	    }
	else
	    CHECK;

	axes=0;
	SimulateDeviceMotionEvent(display,  device, False,  1, &axes, 0);
	XSync(display,1);
	CHECKPASS(7);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XQueryDeviceState-2.(B)");
	report_assertion("A successful call to QueryDeviceState returns the state of");
	report_assertion("the keys, buttons, and valuators on the extension device.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Press some keys.");
	report_strategy("Press some buttons, if the device has any.");
	report_strategy("Move some valuators, if the device has any.");
	report_strategy("Call QueryDeviceState.");
	report_strategy("Check to see if those keys, buttons, and valuators are reported as being down.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: Required input extension device not present.\n", TestName);
	    return;
	    }
	if(noext(0))
	    return;
	device = Devs.Key;
	pokedev (display, device);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XQueryDeviceState-3.(B)");
	report_assertion("A successful call to QueryDeviceState returns the state of");
	report_assertion("the keys, buttons, and valuators on the extension device.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Press some keys.");
	report_strategy("Press some buttons, if the device has any.");
	report_strategy("Move some valuators, if the device has any.");
	report_strategy("Call QueryDeviceState.");
	report_strategy("Check to see if those keys, buttons, and valuators are reported as being down.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: Required input extension device not present.\n", TestName);
	    return;
	    }
	if(noext(0))
	    return;
	device = Devs.Button;
	pokedev (display, device);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XQueryDeviceState-4.(B)");
	report_assertion("A successful call to QueryDeviceState returns the state of");
	report_assertion("the keys, buttons, and valuators on the extension device.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Press some keys.");
	report_strategy("Press some buttons, if the device has any.");
	report_strategy("Move some valuators, if the device has any.");
	report_strategy("Call QueryDeviceState.");
	report_strategy("Check to see if those keys, buttons, and valuators are reported as being down.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(ValMask))
	    {
	    untested("%s: Required input extension device not present.\n", TestName);
	    return;
	    }
	if(noext(0))
	    return;
	device = Devs.Valuator;
	pokedev (display, device);

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XQueryDeviceState-5.(B)");
	report_assertion("A successful call to QueryDeviceState returns the state of");
	report_assertion("the keys, buttons, and valuators on the extension device.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call QueryDeviceState for a device with no keys.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(NKeysMask))
	    {
	    untested("%s: Required input extension device not present.\n", TestName);
	    return;
	    }
	if(noext(0))
	    return;
	device = Devs.NoKeys;
	pokedev (display, device);

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XQueryDeviceState-6.(B)");
	report_assertion("A successful call to QueryDeviceState returns the state of");
	report_assertion("the keys, buttons, and valuators on the extension device.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call QueryDeviceState for a device with no buttons.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(NBtnsMask))
	    {
	    untested("%s: Required input extension device not present.\n", TestName);
	    return;
	    }
	if(noext(0))
	    return;
	device = Devs.NoButtons;
	pokedev (display, device);

	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XQueryDeviceState-7.(B)");
	report_assertion("A successful call to QueryDeviceState returns the state of");
	report_assertion("the keys, buttons, and valuators on the extension device.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call QueryDeviceState for a device with no valuators.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(NValsMask))
	    {
	    untested("%s: Required input extension device not present.\n", TestName);
	    return;
	    }
	if(noext(0))
	    return;
	device = Devs.NoValuators;
	pokedev (display, device);

	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

XDevice nodevice;
int baddevice;
int ximajor, first, err;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XQueryDeviceState-8.(B)");
	report_assertion("A call to XQueryDeviceState will fail with a BadDevice");
	report_assertion("error if an invalid device is specified.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Make the call with an invalid device.");

	tpstartup();
	setargs();
	if (!XQueryExtension (display, INAME, &ximajor, &first, &err))
	    {
	    untested("%s: Input extension not supported.\n", TestName);
	    return;
	    }

	BadDevice (display, baddevice);
	nodevice.device_id = -1;
	device = &nodevice;

	startcall(display);
	if (isdeleted())
		return;
	XQueryDeviceState(display, device);
	endcall(display);
	if (geterr() != baddevice) {
		report("Got %s, Expecting baddevice", errorname(geterr()));
		FAIL;
	}

	if (geterr() == baddevice)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
