// This program is for testing purposes only.
// usage is "[program] owner [u|g] start count
// Exits 0 if owner has subid range starting start, of size count
// Exits 1 otherwise.

#include <config.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdbool.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "defines.h"
#include "prototypes.h"
#include "subordinateio.h"
#include "idmapping.h"

const char *Prog;
FILE *shadow_logfd = NULL;

int main(int argc, char **argv)
{
	char *owner;
	unsigned long start, count;
	bool check_uids;
	Prog = Basename (argv[0]);
	shadow_logfd = stderr;

	if (argc != 5)
		exit(1);

	owner = argv[1];
	check_uids = argv[2][0] == 'u';
	start = strtoul(argv[3], NULL, 10);
	if (start == ULONG_MAX && errno == ERANGE)
		exit(1);
	count = strtoul(argv[4], NULL, 10);
	if (count == ULONG_MAX && errno == ERANGE)
		exit(1);
	if (check_uids) {
		if (have_sub_uids(owner, start, count))
			exit(0);
		exit(1);
	}
	if (have_sub_gids(owner, start, count))
		exit(0);
	exit(1);
}
