static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_color  (fill, _(\"Fill Color\"), \"rgba(0.0,0.0,0.0,0.6)\")          \n"
"  description(_(\"Color of paint to use for filling, use 0 opacity to disable filling\"))\n"
"                                                                              \n"
"property_color  (stroke, _(\"Stroke Color\"), \"rgba(0.0,0.0,0.0,0.0)\")      \n"
"  description(_(\"Color of paint to use for stroking\"))                      \n"
"                                                                              \n"
"property_double (stroke_width,_(\"Stroke width\"), 2.0)                       \n"
"  description (_(\"The width of the brush used to stroke the path\"))         \n"
"  value_range (0.0, 200.0)                                                    \n"
"                                                                              \n"
"property_double (stroke_opacity, _(\"Stroke opacity\"), 1.0)                  \n"
"  description (_(\"Opacity of stroke, note, does not behave like SVG since at the moment stroking is done using an airbrush tool\"))\n"
"  value_range (-2.0, 2.0)                                                     \n"
"                                                                              \n"
"property_double (stroke_hardness, _(\"Hardness\"), 0.6)                       \n"
"  description (_(\"Hardness of the brush, 0.0 for a soft brush, 1.0 for a hard brush\"))\n"
"  value_range (0.0, 1.0)                                                      \n"
"                                                                              \n"
"property_string (fill_rule,_(\"Fill rule\"), \"nonzero\")                     \n"
"  description(_(\"How to determine what to fill (nonzero|evenodd)\"))         \n"
"                                                                              \n"
"property_string (transform,_(\"Transform\"), \"\")                            \n"
"  description(_(\"SVG style description of transform\"))                      \n"
"                                                                              \n"
"property_double (fill_opacity, _(\"Fill opacity\"), 1.0)                      \n"
"  description(_(\"The fill opacity to use\"))                                 \n"
"  value_range (-2.0, 2.0)                                                     \n"
"                                                                              \n"
"property_path (d, _(\"Vector\"), NULL)                                        \n"
"  description (_(\"A GeglVector representing the path of the stroke\"))       \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_NAME     path                                                 \n"
"#define GEGL_OP_C_SOURCE path.c                                               \n"
"                                                                              \n"
"#include \"gegl-plugin.h\"                                                    \n"
"#include \"gegl-path.h\"                                                      \n"
"static void path_changed (GeglPath *path,                                     \n"
"                          const GeglRectangle *roi,                           \n"
"                          gpointer userdata);                                 \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <cairo.h>                                                            \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"typedef struct StampStatic {                                                  \n"
"  gboolean    valid;                                                          \n"
"  const Babl *format;                                                         \n"
"  gfloat     *buf;                                                            \n"
"  gdouble     radius;                                                         \n"
"}StampStatic;                                                                 \n"
"                                                                              \n"
"static void gegl_path_stroke  (GeglBuffer *buffer,                            \n"
"                               const GeglRectangle *clip_rect,                \n"
"                               GeglPath *vector,                              \n"
"                               GeglColor  *color,                             \n"
"                               gdouble     linewidth,                         \n"
"                               gdouble     hardness,                          \n"
"                               gdouble     opacity);                          \n"
"                                                                              \n"
"static void gegl_path_stamp   (GeglBuffer *buffer,                            \n"
"                               const GeglRectangle *clip_rect,                \n"
"                               gdouble     x,                                 \n"
"                               gdouble     y,                                 \n"
"                               gdouble     radius,                            \n"
"                               gdouble     hardness,                          \n"
"                               GeglColor  *color,                             \n"
"                               gdouble     opacity);                          \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_path_stroke (GeglBuffer *buffer,                                         \n"
"                  const GeglRectangle *clip_rect,                             \n"
"                  GeglPath *vector,                                           \n"
"                  GeglColor  *color,                                          \n"
"                  gdouble     linewidth,                                      \n"
"                  gdouble     hardness,                                       \n"
"                  gdouble     opacity)                                        \n"
"{                                                                             \n"
"  gfloat traveled_length = 0;                                                 \n"
"  gfloat need_to_travel = 0;                                                  \n"
"  gfloat x = 0,y = 0;                                                         \n"
"  GeglPathList *iter;                                                         \n"
"  gdouble       xmin, xmax, ymin, ymax;                                       \n"
"  GeglRectangle extent;                                                       \n"
"                                                                              \n"
"  if (!vector)                                                                \n"
"    return;                                                                   \n"
"                                                                              \n"
"  if (!clip_rect)                                                             \n"
"    {                                                                         \n"
"      g_print (\"using buffer extent\\n\");                                   \n"
"      clip_rect = gegl_buffer_get_extent (buffer);                            \n"
"    }                                                                         \n"
"                                                                              \n"
"  iter = gegl_path_get_flat_path (vector);                                    \n"
"  gegl_path_get_bounds (vector, &xmin, &xmax, &ymin, &ymax);                  \n"
"  extent.x = floor (xmin);                                                    \n"
"  extent.y = floor (ymin);                                                    \n"
"  extent.width = ceil (xmax) - extent.x;                                      \n"
"  extent.height = ceil (ymax) - extent.y;                                     \n"
"                                                                              \n"
"  if (!gegl_rectangle_intersect (&extent, &extent, clip_rect))                \n"
"   {                                                                          \n"
"     return;                                                                  \n"
"   }                                                                          \n"
"                                                                              \n"
"  while (iter)                                                                \n"
"    {                                                                         \n"
"      /*fprintf (stderr, \"%c, %i %i\\n\", iter->d.type, iter->d.point[0].x, iter->d.point[0].y);*/\n"
"      switch (iter->d.type)                                                   \n"
"        {                                                                     \n"
"          case 'M':                                                           \n"
"            x = iter->d.point[0].x;                                           \n"
"            y = iter->d.point[0].y;                                           \n"
"            need_to_travel = 0;                                               \n"
"            traveled_length = 0;                                              \n"
"            break;                                                            \n"
"          case 'L':                                                           \n"
"            {                                                                 \n"
"              GeglPathPoint a,b;                                              \n"
"                                                                              \n"
"              gfloat spacing;                                                 \n"
"              gfloat local_pos;                                               \n"
"              gfloat distance;                                                \n"
"              gfloat offset;                                                  \n"
"              gfloat leftover;                                                \n"
"              gfloat radius = linewidth / 2.0;                                \n"
"                                                                              \n"
"                                                                              \n"
"              a.x = x;                                                        \n"
"              a.y = y;                                                        \n"
"                                                                              \n"
"              b.x = iter->d.point[0].x;                                       \n"
"              b.y = iter->d.point[0].y;                                       \n"
"                                                                              \n"
"              spacing = 0.2 * radius;                                         \n"
"                                                                              \n"
"              distance = gegl_path_point_dist (&a, &b);                       \n"
"                                                                              \n"
"              leftover = need_to_travel - traveled_length;                    \n"
"              offset = spacing - leftover;                                    \n"
"                                                                              \n"
"              local_pos = offset;                                             \n"
"                                                                              \n"
"              if (distance > 0)                                               \n"
"                for (;                                                        \n"
"                     local_pos <= distance;                                   \n"
"                     local_pos += spacing)                                    \n"
"                  {                                                           \n"
"                    GeglPathPoint spot;                                       \n"
"                    gfloat ratio = local_pos / distance;                      \n"
"                    gfloat radius = linewidth/2;                              \n"
"                                                                              \n"
"                    gegl_path_point_lerp (&spot, &a, &b, ratio);              \n"
"                                                                              \n"
"                    gegl_path_stamp (buffer, clip_rect,                       \n"
"                      spot.x, spot.y, radius, hardness, color, opacity);      \n"
"                                                                              \n"
"                    traveled_length += spacing;                               \n"
"                  }                                                           \n"
"                                                                              \n"
"              need_to_travel += distance;                                     \n"
"                                                                              \n"
"              x = b.x;                                                        \n"
"              y = b.y;                                                        \n"
"            }                                                                 \n"
"                                                                              \n"
"            break;                                                            \n"
"          case 'u':                                                           \n"
"            g_error (\"stroking uninitialized path\\n\");                     \n"
"            break;                                                            \n"
"          case 's':                                                           \n"
"            break;                                                            \n"
"          default:                                                            \n"
"            g_error (\"can't stroke for instruction: %i\\n\", iter->d.type);  \n"
"            break;                                                            \n"
"        }                                                                     \n"
"      iter=iter->next;                                                        \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_path_stamp (GeglBuffer *buffer,                                          \n"
"                 const GeglRectangle *clip_rect,                              \n"
"                 gdouble     x,                                               \n"
"                 gdouble     y,                                               \n"
"                 gdouble     radius,                                          \n"
"                 gdouble     hardness,                                        \n"
"                 GeglColor  *color,                                           \n"
"                 gdouble     opacity)                                         \n"
"{                                                                             \n"
"  gfloat col[4];                                                              \n"
"  StampStatic s = {FALSE,}; /* there should be a cache of stamps,             \n"
"                               note that stamps are accessed in multiple threads\n"
"                             */                                               \n"
"                                                                              \n"
"  GeglRectangle temp;                                                         \n"
"  GeglRectangle roi;                                                          \n"
"                                                                              \n"
"  roi.x = floor(x-radius);                                                    \n"
"  roi.y = floor(y-radius);                                                    \n"
"  roi.width = ceil (x+radius) - floor (x-radius);                             \n"
"  roi.height = ceil (y+radius) - floor (y-radius);                            \n"
"                                                                              \n"
"  gegl_color_get_pixel (color, babl_format (\"RGBA float\"), col);            \n"
"                                                                              \n"
"  /* bail out if we wouldn't leave a mark on the buffer */                    \n"
"  if (!gegl_rectangle_intersect (&temp, &roi, clip_rect))                     \n"
"    {                                                                         \n"
"      return;                                                                 \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (s.format == NULL)                                                       \n"
"    s.format = babl_format (\"RaGaBaA float\");                               \n"
"                                                                              \n"
"  if (s.buf == NULL ||                                                        \n"
"      s.radius != radius)                                                     \n"
"    {                                                                         \n"
"      if (s.buf != NULL)                                                      \n"
"        g_free (s.buf);                                                       \n"
"      /* allocate a little bit more, just in case due to rounding errors and  \n"
"       * such */                                                              \n"
"      s.buf = g_malloc (4*4* (roi.width + 2 ) * (roi.height + 2));            \n"
"      s.radius = radius;                                                      \n"
"      s.valid = TRUE;                                                         \n"
"    }                                                                         \n"
"  g_assert (s.buf);                                                           \n"
"                                                                              \n"
"  gegl_buffer_get (buffer, &roi, 1.0, s.format, s.buf, 0, GEGL_ABYSS_NONE);   \n"
"                                                                              \n"
"  {                                                                           \n"
"    gint u, v;                                                                \n"
"    gint i=0;                                                                 \n"
"                                                                              \n"
"    gfloat radius_squared = radius * radius;                                  \n"
"    gfloat inner_radius_squared = (radius * hardness)*(radius * hardness);    \n"
"    gfloat soft_range = radius_squared - inner_radius_squared;                \n"
"                                                                              \n"
"    for (v= roi.y; v < roi.y + roi.height ; v++)                              \n"
"    {                                                                         \n"
"      gfloat vy2 = (v-y)*(v-y);                                               \n"
"      for (u= roi.x; u < roi.x + roi.width; u++)                              \n"
"        {                                                                     \n"
"          gfloat o = (u-x) * (u-x) + vy2;                                     \n"
"                                                                              \n"
"          if (o < inner_radius_squared)                                       \n"
"             o = col[3];                                                      \n"
"          else if (o < radius_squared)                                        \n"
"            {                                                                 \n"
"              o = (1.0 - (o-inner_radius_squared) / (soft_range)) * col[3];   \n"
"            }                                                                 \n"
"          else                                                                \n"
"            {                                                                 \n"
"              o=0.0;                                                          \n"
"            }                                                                 \n"
"         if (o!=0.0)                                                          \n"
"           {                                                                  \n"
"             gint c;                                                          \n"
"             o = o*opacity;                                                   \n"
"             for (c=0;c<4;c++)                                                \n"
"               s.buf[i*4+c] = (s.buf[i*4+c] * (1.0-o) + col[c] * o);          \n"
"           }                                                                  \n"
"         i++;                                                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  }                                                                           \n"
"  gegl_buffer_set (buffer, &roi, 0, s.format, s.buf, 0);                      \n"
"  g_free (s.buf);                                                             \n"
"}                                                                             \n"
"                                                                              \n"
"static void path_changed (GeglPath *path,                                     \n"
"                          const GeglRectangle *roi,                           \n"
"                          gpointer userdata)                                  \n"
"{                                                                             \n"
"  GeglRectangle rect = *roi;                                                  \n"
"  GeglProperties    *o   = GEGL_PROPERTIES (userdata);                        \n"
"  /* invalidate the incoming rectangle */                                     \n"
"                                                                              \n"
"  rect.x -= o->stroke_width/2;                                                \n"
"  rect.y -= o->stroke_width/2;                                                \n"
"  rect.width += o->stroke_width;                                              \n"
"  rect.height += o->stroke_width;                                             \n"
"                                                                              \n"
"  gegl_operation_invalidate (userdata, &rect, FALSE);                         \n"
"};                                                                            \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"R'aG'aB'aA float\"));\n"
"  if (o->transform && o->transform[0] != '\\0')                               \n"
"    {                                                                         \n"
"      GeglMatrix3 matrix;                                                     \n"
"      gegl_matrix3_parse_string (&matrix, o->transform);                      \n"
"      gegl_path_set_matrix (o->d, &matrix);                                   \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglProperties    *o       = GEGL_PROPERTIES (operation);                   \n"
"  GeglRectangle  defined = { 0, 0, 512, 512 };                                \n"
"  GeglRectangle *in_rect;                                                     \n"
"  gdouble        x0, x1, y0, y1;                                              \n"
"                                                                              \n"
"  in_rect =  gegl_operation_source_get_bounding_box (operation, \"input\");   \n"
"                                                                              \n"
"  gegl_path_get_bounds (o->d, &x0, &x1, &y0, &y1);                            \n"
"  defined.x      = x0 - o->stroke_width/2;                                    \n"
"  defined.y      = y0 - o->stroke_width/2;                                    \n"
"  defined.width  = x1 - x0 + o->stroke_width;                                 \n"
"  defined.height = y1 - y0 + o->stroke_width;                                 \n"
"                                                                              \n"
"  if (in_rect)                                                                \n"
"    {                                                                         \n"
"      gegl_rectangle_bounding_box (&defined, &defined, in_rect);              \n"
"    }                                                                         \n"
"                                                                              \n"
"  return defined;                                                             \n"
"}                                                                             \n"
"                                                                              \n"
"static void gegl_path_cairo_play (GeglPath *path,                             \n"
"                                    cairo_t *cr);                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  if (input)                                                                  \n"
"    {                                                                         \n"
"      gegl_buffer_copy (input, result, GEGL_ABYSS_NONE,                       \n"
"                        output, result);                                      \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      gegl_buffer_clear (output, result);                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (o->fill_opacity > 0.0001 && o->fill)                                    \n"
"    {                                                                         \n"
"      gdouble color[4] = {0, 0, 0, 0};                                        \n"
"      gegl_color_get_pixel (o->fill, babl_format (\"R'G'B'A double\"), color);\n"
"      color[3] *= o->fill_opacity;                                            \n"
"                                                                              \n"
"      if (color[3] > 0.001)                                                   \n"
"        {                                                                     \n"
"          static GMutex mutex = { 0, };                                       \n"
"          cairo_t *cr;                                                        \n"
"          cairo_surface_t *surface;                                           \n"
"          guchar *data;                                                       \n"
"                                                                              \n"
"          g_mutex_lock (&mutex);                                              \n"
"          data = gegl_buffer_linear_open (output, result, NULL, babl_format (\"B'aG'aR'aA u8\"));\n"
"          surface = cairo_image_surface_create_for_data (data,                \n"
"                                                         CAIRO_FORMAT_ARGB32, \n"
"                                                         result->width,       \n"
"                                                         result->height,      \n"
"                                                         result->width * 4);  \n"
"          cr = cairo_create (surface);                                        \n"
"          cairo_translate (cr, -result->x, -result->y);                       \n"
"                                                                              \n"
"          if (g_str_equal (o->fill_rule, \"evenodd\"))                        \n"
"            {                                                                 \n"
"              cairo_set_fill_rule (cr, CAIRO_FILL_RULE_EVEN_ODD);             \n"
"            }                                                                 \n"
"                                                                              \n"
"          gegl_path_cairo_play (o->d, cr);                                    \n"
"          cairo_set_source_rgba (cr, color[0], color[1], color[2], color[3]); \n"
"          cairo_fill (cr);                                                    \n"
"                                                                              \n"
"          g_mutex_unlock (&mutex);                                            \n"
"          gegl_buffer_linear_close (output, data);                            \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_object_set_data (G_OBJECT (operation), \"path-radius\", GINT_TO_POINTER((gint)(o->stroke_width+1)/2));\n"
"                                                                              \n"
"  if (o->stroke_width > 0.1 && o->stroke_opacity > 0.0001)                    \n"
"    {                                                                         \n"
"      gegl_path_stroke (output, result,                                       \n"
"                                o->d,                                         \n"
"                                o->stroke,                                    \n"
"                                o->stroke_width,                              \n"
"                                o->stroke_hardness,                           \n"
"                                o->stroke_opacity);                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void foreach_cairo (const GeglPathItem *knot,                          \n"
"                           gpointer              cr)                          \n"
"{                                                                             \n"
"  switch (knot->type)                                                         \n"
"    {                                                                         \n"
"      case 'M':                                                               \n"
"        cairo_move_to (cr, knot->point[0].x, knot->point[0].y);               \n"
"        break;                                                                \n"
"      case 'L':                                                               \n"
"        cairo_line_to (cr, knot->point[0].x, knot->point[0].y);               \n"
"        break;                                                                \n"
"      case 'C':                                                               \n"
"        cairo_curve_to (cr, knot->point[0].x, knot->point[0].y,               \n"
"                            knot->point[1].x, knot->point[1].y,               \n"
"                            knot->point[2].x, knot->point[2].y);              \n"
"        break;                                                                \n"
"      case 'z':                                                               \n"
"        cairo_close_path (cr);                                                \n"
"        break;                                                                \n"
"      default:                                                                \n"
"        g_print (\"%s uh?:%c\\n\", G_STRLOC, knot->type);                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void gegl_path_cairo_play (GeglPath *path,                             \n"
"                                    cairo_t *cr)                              \n"
"{                                                                             \n"
"  gegl_path_foreach_flat (path, foreach_cairo, cr);                           \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglNode *detect (GeglOperation *operation,                            \n"
"                         gint           x,                                    \n"
"                         gint           y)                                    \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  cairo_t *cr;                                                                \n"
"  cairo_surface_t *surface;                                                   \n"
"  gchar *data = \"     \";                                                    \n"
"  gboolean result = FALSE;                                                    \n"
"                                                                              \n"
"  surface = cairo_image_surface_create_for_data ((guchar*)data,               \n"
"                                                 CAIRO_FORMAT_ARGB32,         \n"
"                                                 1,1,4);                      \n"
"  cr = cairo_create (surface);                                                \n"
"  gegl_path_cairo_play (o->d, cr);                                            \n"
"  cairo_set_line_width (cr, o->stroke_width);                                 \n"
"                                                                              \n"
"                                                                              \n"
"  if (o->stroke_width > 0.1 && o->stroke_opacity > 0.0001)                    \n"
"    result = cairo_in_stroke (cr, x, y);                                      \n"
"                                                                              \n"
"  if (!result)                                                                \n"
"    {                                                                         \n"
"      if (o->d)                                                               \n"
"        {                                                                     \n"
"          gdouble r,g,b,a;                                                    \n"
"          gegl_color_get_rgba (o->fill, &r,&g,&b,&a);                         \n"
"          if (a * o->fill_opacity>0.8)                                        \n"
"            result = cairo_in_fill (cr, x, y);                                \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"                                                                              \n"
"  cairo_destroy (cr);                                                         \n"
"                                                                              \n"
"  if (result)                                                                 \n"
"    return operation->node;                                                   \n"
"                                                                              \n"
"  return NULL;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"  const gchar *composition =                                                  \n"
"    \"<gegl>\"                                                                \n"
"    \"<node operation='gegl:crop' width='200' height='200'/>\"                \n"
"    \"<node operation='gegl:over'>\"                                          \n"
"    \"<node operation='gegl:translate' x='40' y='40'/>\"                      \n"
"    \"<node operation='gegl:path'>\"                                          \n"
"    \"  <params>\"                                                            \n"
"    \"    <param name='fill'>rgba(1,1,1,0.2)</param>\"                        \n"
"    \"    <param name='stroke'>rgba(0,0,1,0.5)</param>\"                      \n"
"    \"    <param name='stroke-hardness'>0.0</param>\"                         \n"
"    \"    <param name='stroke-width'>8.0</param>\"                            \n"
"    \"    <param name='d'>\"                                                  \n"
"    \"M0,50 C0,78 24,100 50,100 C77,100 100,78 100,50 C100,45 99,40 98,35 C82,35 66,35 50,35 C42,35 35,42 35,50 C35,58 42,65 50,65 C56,65 61,61 64,56 C67,51 75,55 73,60 C69,  69 60,75 50,75 C36,75 25,64 25,50 C25,36 36,25 50,25 L93,25 C83,9 67,0 49,0 C25,0 0,20 0,50   z\"\n"
"    \"                    </param>\"                                          \n"
"    \"  </params>\"                                                           \n"
"    \"</node>\"                                                               \n"
"    \"</node>\"                                                               \n"
"    \"<node operation='gegl:checkerboard' color1='rgb(0.25,0.25,0.25)' color2='rgb(0.75,0.75,0.75)'/>\"\n"
"    \"</gegl>\";                                                              \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process = process;                                            \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->detect = detect;                                           \n"
"  /*operation_class->no_cache = TRUE;*/                                       \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",           \"gegl:path\",                                        \n"
"    \"title\",          _(\"Render Path\"),                                   \n"
"    \"categories\",     \"render\",                                           \n"
"    \"reference-hash\", \"eba13d16fba3284ceee264073ebfa356\",                 \n"
"    \"reference-composition\", composition,                                   \n"
"    \"description\" , _(\"Renders a brush stroke\"),                          \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"#endif                                                                        \n"
;
