static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (alpha, _(\"Alpha\"), 1.2)                                    \n"
"    ui_range    (0.0, 4.0)                                                    \n"
"property_double (scale, _(\"Scale\"), 1.8)                                    \n"
"    ui_range    (0.0, 20.0)                                                   \n"
"                                                                              \n"
"property_double (zoff,  _(\"Z offset\"), -1)                                  \n"
"    ui_range    (-1.0, 8.0)                                                   \n"
"                                                                              \n"
"property_int (n, _(\"Iterations\"), 3)                                        \n"
"  value_range     (0, 20)                                                     \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_RENDER                                                  \n"
"#define GEGL_OP_NAME     noise_perlin                                         \n"
"#define GEGL_OP_C_SOURCE noise-perlin.c                                       \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include \"perlin/perlin.c\"                                                  \n"
"#include \"perlin/perlin.h\"                                                  \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"Y float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle result = {-10000000, -10000000, 20000000, 20000000};          \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  gfloat     *out_pixel = out_buf;                                            \n"
"  gint        x = roi->x; /* initial x                   */                   \n"
"  gint        y = roi->y; /*           and y coordinates */                   \n"
"                                                                              \n"
"                                                                              \n"
"  while (n_pixels--)                                                          \n"
"    {                                                                         \n"
"      gfloat val;                                                             \n"
"                                                                              \n"
"      val = PerlinNoise3D ((double) (x)/50.0,                                 \n"
"                           (double) (y)/50.0,                                 \n"
"                           (double) o->zoff, o->alpha, o->scale,              \n"
"                           o->n);                                             \n"
"      *out_pixel = val * 0.5 + 0.5;                                           \n"
"      out_pixel ++;                                                           \n"
"                                                                              \n"
"      /* update x and y coordinates */                                        \n"
"      x++;                                                                    \n"
"      if (x>=roi->x + roi->width)                                             \n"
"        {                                                                     \n"
"          x=roi->x;                                                           \n"
"          y++;                                                                \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointRenderClass *point_render_class;                          \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  point_render_class = GEGL_OPERATION_POINT_RENDER_CLASS (klass);             \n"
"                                                                              \n"
"  point_render_class->process = process;                                      \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->no_cache = TRUE;                                           \n"
"  operation_class->get_cached_region = NULL;                                  \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",               \"gegl:perlin-noise\",                            \n"
"    \"title\",              _(\"Perlin Noise\"),                              \n"
"    \"categories\",         \"render\",                                       \n"
"    \"position-dependent\", \"true\",                                         \n"
"    \"description\", _(\"Perlin noise generator\"),                           \n"
"    NULL);                                                                    \n"
"                                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
