static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 1995 Spencer Kimball and Peter Mattis                            \n"
" * Copyright 1996 Torsten Martinsen                                           \n"
" * Copyright 2000 Tim Copperfield <timecop@japan.co.jp>                       \n"
" * Copyright 2012 Maxime Nicco <maxime.nicco@gmail.com>                       \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_int  (holdness, _(\"Holdness\"), 2)                                  \n"
"  value_range (1, 8)                                                          \n"
"                                                                              \n"
"property_double (hue_distance, _(\"Hue\"), 3.0)                               \n"
"  value_range   (0.0, 180.0)                                                  \n"
"                                                                              \n"
"property_double (saturation_distance, _(\"Saturation\"), 0.04)                \n"
"  value_range   (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_double (value_distance, _(\"Value\"), 0.04)                          \n"
"  value_range   (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_seed   (seed, _(\"Random seed\"), rand)                              \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_NAME     noise_hsv                                            \n"
"#define GEGL_OP_C_SOURCE noise-hsv.c                                          \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <stdio.h>                                                            \n"
"#include <math.h>                                                             \n"
"#include <stdlib.h>                                                           \n"
"                                                                              \n"
"static gfloat                                                                 \n"
"randomize_value (gfloat      now,                                             \n"
"                 gfloat      min,                                             \n"
"                 gfloat      max,                                             \n"
"                 gboolean    wraps_around,                                    \n"
"                 gfloat      rand_max,                                        \n"
"                 gint        holdness,                                        \n"
"                 gint        x,                                               \n"
"                 gint        y,                                               \n"
"                 gint        n,                                               \n"
"                 GeglRandom *rand)                                            \n"
"{                                                                             \n"
"  gint    flag, i;                                                            \n"
"  gfloat rand_val, new_val, steps;                                            \n"
"                                                                              \n"
"  steps = max - min;                                                          \n"
"  rand_val = gegl_random_float (rand, x, y, 0, n++);                          \n"
"                                                                              \n"
"  for (i = 1; i < holdness; i++)                                              \n"
"  {                                                                           \n"
"    gfloat tmp = gegl_random_float (rand, x, y, 0, n++);                      \n"
"    if (tmp < rand_val)                                                       \n"
"      rand_val = tmp;                                                         \n"
"  }                                                                           \n"
"                                                                              \n"
"  flag = (gegl_random_float (rand, x, y, 0, n) < 0.5) ? -1 : 1;               \n"
"  new_val = now + flag * fmod (rand_max * rand_val, steps);                   \n"
"                                                                              \n"
"  if (new_val < min)                                                          \n"
"  {                                                                           \n"
"    if (wraps_around)                                                         \n"
"      new_val += steps;                                                       \n"
"    else                                                                      \n"
"      new_val = min;                                                          \n"
"  }                                                                           \n"
"                                                                              \n"
"  if (max < new_val)                                                          \n"
"  {                                                                           \n"
"    if (wraps_around)                                                         \n"
"      new_val -= steps;                                                       \n"
"    else                                                                      \n"
"      new_val = max;                                                          \n"
"  }                                                                           \n"
"                                                                              \n"
"  return new_val;                                                             \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\", babl_format (\"HSVA float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"HSVA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o  = GEGL_PROPERTIES (operation);                           \n"
"  GeglRectangle whole_region;                                                 \n"
"  gint i;                                                                     \n"
"  gint x, y;                                                                  \n"
"                                                                              \n"
"  gfloat   * GEGL_ALIGNED in_pixel;                                           \n"
"  gfloat   * GEGL_ALIGNED out_pixel;                                          \n"
"                                                                              \n"
"  gfloat    hue, saturation, value, alpha;                                    \n"
"                                                                              \n"
"  in_pixel      = in_buf;                                                     \n"
"  out_pixel     = out_buf;                                                    \n"
"                                                                              \n"
"  x = roi->x;                                                                 \n"
"  y = roi->y;                                                                 \n"
"                                                                              \n"
"  whole_region = *(gegl_operation_source_get_bounding_box (operation, \"input\"));\n"
"                                                                              \n"
"  for (i = 0; i < n_pixels; i++)                                              \n"
"  {                                                                           \n"
"    /* n is independent from the roi, but from the whole image */             \n"
"    gint n = (3 * o->holdness + 4) * (x + whole_region.width * y);            \n"
"                                                                              \n"
"    hue        = in_pixel[0];                                                 \n"
"    saturation = in_pixel[1];                                                 \n"
"    value      = in_pixel[2];                                                 \n"
"    alpha      = in_pixel[3];                                                 \n"
"                                                                              \n"
"    /* there is no need for scattering hue of desaturated pixels here */      \n"
"    if ((o->hue_distance > 0) && (saturation > 0))                            \n"
"      hue = randomize_value (hue, 0.0, 1.0, TRUE, o->hue_distance / 360.0,    \n"
"                             o->holdness, x, y, n, o->rand);                  \n"
"                                                                              \n"
"    n += o->holdness + 1;                                                     \n"
"    /* desaturated pixels get random hue before increasing saturation */      \n"
"    if (o->saturation_distance > 0) {                                         \n"
"      if (saturation == 0)                                                    \n"
"        hue = gegl_random_float_range (o->rand, x, y, 0, n, 0.0, 1.0);        \n"
"      saturation = randomize_value (saturation, 0.0, 1.0, FALSE,              \n"
"                                    o->saturation_distance, o->holdness,      \n"
"                                    x, y, n+1, o->rand);                      \n"
"    }                                                                         \n"
"                                                                              \n"
"    n += o->holdness + 2;                                                     \n"
"    if (o->value_distance > 0)                                                \n"
"      value = randomize_value (value, 0.0, 1.0, FALSE, o->value_distance,     \n"
"                               o->holdness, x, y, n, o->rand);                \n"
"                                                                              \n"
"    out_pixel[0] = hue;                                                       \n"
"    out_pixel[1] = saturation;                                                \n"
"    out_pixel[2] = value;                                                     \n"
"    out_pixel[3] = alpha;                                                     \n"
"                                                                              \n"
"    in_pixel  += 4;                                                           \n"
"    out_pixel += 4;                                                           \n"
"                                                                              \n"
"    x++;                                                                      \n"
"    if (x >= roi->x + roi->width)                                             \n"
"      {                                                                       \n"
"        x = roi->x;                                                           \n"
"        y++;                                                                  \n"
"      }                                                                       \n"
"  }                                                                           \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *point_filter_class;                          \n"
"                                                                              \n"
"  operation_class    = GEGL_OPERATION_CLASS (klass);                          \n"
"  point_filter_class = GEGL_OPERATION_POINT_FILTER_CLASS (klass);             \n"
"                                                                              \n"
"  operation_class->prepare = prepare;                                         \n"
"  point_filter_class->process = process;                                      \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",       \"gegl:noise-hsv\",                                       \n"
"    \"title\",      _(\"Add HSV Noise\"),                                     \n"
"    \"categories\", \"noise\",                                                \n"
"    \"description\", _(\"Randomize hue, saturation and value independently\"),\n"
"      NULL);                                                                  \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
