static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2016 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"//#include <glib/gi18n-lib.h>                                                 \n"
"#define _(a) (a)                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (dampness, _(\"Dampness\"), 0.95)                             \n"
"    description (_(\"The value represents the contribution of the past to the new frame.\"))\n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_NO_SOURCE                                                     \n"
"#define GEGL_OP_NAME     vhsfix                                               \n"
"#define GEGL_OP_C_SOURCE vhsfix.c                                             \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"#define TEMP_BUFS 5                                                           \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  GeglBuffer *acc[TEMP_BUFS];                                                 \n"
"  int         uninitialized;                                                  \n"
"} Priv;                                                                       \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"init (GeglProperties *o)                                                      \n"
"{                                                                             \n"
"  Priv         *priv = (Priv*)o->user_data;                                   \n"
"  GeglRectangle extent = {0,0,1024,1024};                                     \n"
"                                                                              \n"
"  g_assert (priv == NULL);                                                    \n"
"                                                                              \n"
"  priv = g_new0 (Priv, 1);                                                    \n"
"  o->user_data = (void*) priv;                                                \n"
"                                                                              \n"
"  for (int i=0;i< TEMP_BUFS;i++)                                              \n"
"    priv->acc[i] = gegl_buffer_new (&extent, babl_format (\"RGBA float\"));   \n"
"  priv->uninitialized = 1;                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RGBA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#include <stdio.h>                                                            \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o;                                                          \n"
"  Priv           *p;                                                          \n"
"                                                                              \n"
"  o = GEGL_PROPERTIES (operation);                                            \n"
"  p = (Priv*)o->user_data;                                                    \n"
"  if (p == NULL)                                                              \n"
"    init (o);                                                                 \n"
"  p = (Priv*)o->user_data;                                                    \n"
"                                                                              \n"
"  {                                                                           \n"
"    gint pixels = result->width * result->height;                             \n"
"    gfloat *acc[TEMP_BUFS];                                                   \n"
"    gfloat *buf;                                                              \n"
"    gint i;                                                                   \n"
"    gfloat totdiff = 0.0;                                                     \n"
"    int x, y;                                                                 \n"
"    int last_set[8192]={0,};                                                  \n"
"    for (i = 0; i < TEMP_BUFS; i++)                                           \n"
"      acc[i] = g_new (gfloat, pixels * 4);                                    \n"
"    buf = g_new (gfloat, pixels * 4);                                         \n"
"                                                                              \n"
"    if (p->uninitialized)                                                     \n"
"    {                                                                         \n"
"      gegl_buffer_get (input, result, 1.0, babl_format (\"RGBA float\"), buf, GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);\n"
"      for (i = 0; i<TEMP_BUFS; i++)                                           \n"
"      {                                                                       \n"
"        gegl_buffer_set (p->acc[i], result, 0, babl_format (\"RGBA float\"), buf, GEGL_AUTO_ROWSTRIDE);\n"
"        gegl_buffer_get (input, result, 1.0, babl_format (\"RGBA float\"), acc[i], GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);\n"
"      }                                                                       \n"
"      p->uninitialized = 0;                                                   \n"
"    }                                                                         \n"
"    else                                                                      \n"
"    {                                                                         \n"
"                                                                              \n"
"    for (i = TEMP_BUFS-1; i > 0; i--)                                         \n"
"    {                                                                         \n"
"      gegl_buffer_get (p->acc[i-1], result, 1.0, babl_format (\"RGBA float\"), acc[i], GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);\n"
"      gegl_buffer_set (p->acc[i], result, 0, babl_format (\"RGBA float\"), acc[i], GEGL_AUTO_ROWSTRIDE);\n"
"    }                                                                         \n"
"                                                                              \n"
"    gegl_buffer_get (input, result, 1.0, babl_format (\"RGBA float\"), acc[0], GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);\n"
"    gegl_buffer_get (input, result, 1.0, babl_format (\"RGBA float\"), buf, GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);\n"
"    gegl_buffer_set (p->acc[0], result, 0, babl_format (\"RGBA float\"), acc[0], GEGL_AUTO_ROWSTRIDE);\n"
"    }                                                                         \n"
"                                                                              \n"
"    for (i=0;i<pixels;i++)                                                    \n"
"      {                                                                       \n"
"        gint c;                                                               \n"
"        for (c=0;c<4;c++)                                                     \n"
"        {                                                                     \n"
"          int t;                                                              \n"
"          float avg[4] = {0,0,0,0};                                           \n"
"          float avg2[4] = {0,0,0,0};                                          \n"
"                                                                              \n"
"          for (t = 2; t < TEMP_BUFS; t++)                                     \n"
"            avg[c] += acc[t][i*4+c];                                          \n"
"          avg[c] /= (TEMP_BUFS);                                              \n"
"                                                                              \n"
"          for (t = 1; t < TEMP_BUFS-2; t++)                                   \n"
"            avg2[c] += acc[t][i*4+c];                                         \n"
"          avg2[c] /= (TEMP_BUFS - 1 - 2);                                     \n"
"                                                                              \n"
"#define ACC(a) acc[a][i*4+c]                                                  \n"
"          if (fabs (ACC(0) - avg[c]) > 0.05)                                  \n"
"            ACC(0) = avg2[c];                                                 \n"
"        }                                                                     \n"
"      }                                                                       \n"
"                                                                              \n"
"    i = 0;                                                                    \n"
"                                                                              \n"
"    for (y = result->y; y < result->y + result->height-1; y++)                \n"
"      for (x = result->x; x < result->x + result->width; x++)                 \n"
"      {                                                                       \n"
"        int c;                                                                \n"
"        float diff = 0;                                                       \n"
"        for (c = 0; c < 3; c++)                                               \n"
"          if (acc[0][i * 4 + c] != buf[i * 4 + c])                            \n"
"          {                                                                   \n"
"            diff+=fabs(acc[0][i * 4 + c] - buf[i * 4 + c]) *                  \n"
"                  fabs(acc[0][i * 4 + c] - buf[i * 4 + c]);                   \n"
"          }                                                                   \n"
"        diff = sqrtf (diff);                                                  \n"
"        if (diff > 0.02f)                                                     \n"
"        {                                                                     \n"
"          if (last_set[x] < 1) /* permit up to two pixels wide artifacts */   \n"
"          {                                                                   \n"
"            if (y > 1)                                                        \n"
"            for (c = 0; c < 4; c++)                                           \n"
"              buf[i * 4 + c] = acc[0][i * 4 + c] * 0.2 + buf[(i-result->width) * 4 + c] * 0.4 + buf[(i-result->width) * 4 + c] * 0.4;\n"
"            else                                                              \n"
"            for (c = 0; c < 4; c++)                                           \n"
"              buf[i * 4 + c] = acc[0][i * 4 + c];                             \n"
"            last_set[x]++;                                                    \n"
"          }                                                                   \n"
"          else if (last_set[x] > 1)                                           \n"
"          {                                                                   \n"
"            if (y > 1)                                                        \n"
"            for (c = 0; c < 4; c++)                                           \n"
"              buf[i * 4 + c] = acc[0][i * 4 + c] * 0.2 + buf[(i-result->width) * 4 + c] * 0.4 + buf[(i-result->width) * 4 + c] * 0.4;\n"
"                                                                              \n"
"            else                                                              \n"
"            for (c = 0; c < 4; c++)                                           \n"
"              buf[i * 4 + c] = acc[0][i * 4 + c];                             \n"
"            last_set[x] = 0;                                                  \n"
"          }                                                                   \n"
"        }                                                                     \n"
"        else                                                                  \n"
"        {                                                                     \n"
"          last_set[x]++;                                                      \n"
"        }                                                                     \n"
"        i++;                                                                  \n"
"      }                                                                       \n"
"                                                                              \n"
"    /* if reset, refetch buf .. and set scene-change flag */                  \n"
"                                                                              \n"
"    totdiff = 0;                                                              \n"
"    i = 0;                                                                    \n"
"    for (y = result->y; y < result->y + result->height; y++)                  \n"
"      for (x = result->x; x < result->x + result->width; x++)                 \n"
"      {                                                                       \n"
"        int c;                                                                \n"
"        float diff = 0;                                                       \n"
"        for (c = 0; c < 3; c++)                                               \n"
"          diff+=fabs(acc[0][i * 4 + c] - acc[1][i * 4 + c]) *                 \n"
"                fabs(acc[0][i * 4 + c] - acc[1][i * 4 + c]);                  \n"
"        if (diff != 0.0)                                                      \n"
"          totdiff += sqrtf (diff);                                            \n"
"        i++;                                                                  \n"
"      }                                                                       \n"
"    totdiff /= i;                                                             \n"
"                                                                              \n"
"    if (totdiff > 0.04)                                                       \n"
"    {                                                                         \n"
"      gegl_buffer_get (input, result, 1.0, babl_format (\"RGBA float\"), buf, GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);\n"
"      p->uninitialized = 1;                                                   \n"
"    }                                                                         \n"
"                                                                              \n"
"    gegl_buffer_set (output, result, 0, babl_format (\"RGBA float\"), buf, GEGL_AUTO_ROWSTRIDE);\n"
"    for (i = 0; i < TEMP_BUFS; i++)                                           \n"
"      g_free (acc[i]);                                                        \n"
"    g_free (buf);                                                             \n"
"  }                                                                           \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"finalize (GObject *object)                                                    \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (object);                               \n"
"                                                                              \n"
"  if (o->user_data)                                                           \n"
"    {                                                                         \n"
"      Priv *p = (Priv*)o->user_data;                                          \n"
"                                                                              \n"
"      for (int i=0;i< TEMP_BUFS;i++)                                          \n"
"        {                                                                     \n"
"          g_object_unref (p->acc[i]);                                         \n"
"          p->acc[i] = NULL;                                                   \n"
"        }                                                                     \n"
"                                                                              \n"
"      g_free (o->user_data);                                                  \n"
"      o->user_data = NULL;                                                    \n"
"    }                                                                         \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->finalize (object);                   \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  G_OBJECT_CLASS (klass)->finalize = finalize;                                \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process = process;                                            \n"
"  operation_class->prepare = prepare;                                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:vhsfix\",                                         \n"
"    \"title\",       _(\"vhs glitch fixer\"),                                 \n"
"    \"categories\" , \"video\",                                               \n"
"    \"description\", _(\"fixes vhs digitization glitches\"),                  \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
