static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * This program is free software: you can redistribute it and/or modify       \n"
" * it under the terms of the GNU General Public License as published by       \n"
" * the Free Software Foundation; either version 3 of the License, or          \n"
" * (at your option) any later version.                                        \n"
" *                                                                            \n"
" * This program is distributed in the hope that it will be useful,            \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              \n"
" * GNU General Public License for more details.                               \n"
" *                                                                            \n"
" * You should have received a copy of the GNU General Public License          \n"
" * along with this program.  If not, see <http://www.gnu.org/licenses/>.      \n"
" *                                                                            \n"
" * Author: Jef Poskanzer.                                                     \n"
" *                                                                            \n"
" * GEGL Port: Thomas Manni <thomas.manni@free.fr>                             \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"enum_start (gegl_edge_algo)                                                   \n"
"   enum_value (GEGL_EDGE_SOBEL,    \"sobel\",    N_(\"Sobel\"))               \n"
"   enum_value (GEGL_EDGE_PREWITT,  \"prewitt\",  N_(\"Prewitt compass\"))     \n"
"   enum_value (GEGL_EDGE_GRADIENT, \"gradient\", N_(\"Gradient\"))            \n"
"   enum_value (GEGL_EDGE_ROBERTS,  \"roberts\",  N_(\"Roberts\"))             \n"
"   enum_value (GEGL_EDGE_DIFFERENTIAL, \"differential\", N_(\"Differential\"))\n"
"   enum_value (GEGL_EDGE_LAPLACE,  \"laplace\",  N_(\"Laplace\"))             \n"
"enum_end (GeglEdgeAlgo)                                                       \n"
"                                                                              \n"
"property_enum (algorithm, _(\"Algorithm\"),                                   \n"
"               GeglEdgeAlgo, gegl_edge_algo,                                  \n"
"               GEGL_EDGE_SOBEL)                                               \n"
"  description (_(\"Edge detection algorithm\"))                               \n"
"                                                                              \n"
"property_double (amount, _(\"Amount\"), 2.0)                                  \n"
"    description (_(\"Edge detection amount\"))                                \n"
"    value_range (1.0, 10.0)                                                   \n"
"    ui_range    (1.0, 10.0)                                                   \n"
"                                                                              \n"
"property_enum (border_behavior, _(\"Border behavior\"),                       \n"
"               GeglAbyssPolicy, gegl_abyss_policy,                            \n"
"               GEGL_ABYSS_CLAMP)                                              \n"
"  description (_(\"Edge detection behavior\"))                                \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_NAME        edge                                              \n"
"#define GEGL_OP_C_SOURCE    edge.c                                            \n"
"                                                                              \n"
"#include <math.h>                                                             \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static inline gfloat                                                          \n"
"edge_sobel (gfloat *pixels, gdouble amount)                                   \n"
"{                                                                             \n"
"  const gint v_kernel[9] = { -1,  0,  1,                                      \n"
"                             -2,  0,  2,                                      \n"
"                             -1,  0,  1 };                                    \n"
"  const gint h_kernel[9] = { -1, -2, -1,                                      \n"
"                              0,  0,  0,                                      \n"
"                              1,  2,  1 };                                    \n"
"                                                                              \n"
"  gint i;                                                                     \n"
"  gfloat v_grad, h_grad;                                                      \n"
"                                                                              \n"
"  for (i = 0, v_grad = 0.0f, h_grad = 0.0f; i < 9; i++)                       \n"
"    {                                                                         \n"
"      v_grad += v_kernel[i] * pixels[i];                                      \n"
"      h_grad += h_kernel[i] * pixels[i];                                      \n"
"    }                                                                         \n"
"                                                                              \n"
"  return sqrt (v_grad * v_grad * amount +                                     \n"
"               h_grad * h_grad * amount);                                     \n"
"}                                                                             \n"
"                                                                              \n"
"static inline gfloat                                                          \n"
"edge_prewitt (gfloat *pixels, gdouble amount)                                 \n"
"{                                                                             \n"
"  gint k;                                                                     \n"
"  gfloat max;                                                                 \n"
"  gfloat m[8];                                                                \n"
"                                                                              \n"
"  m[0] =   pixels[0] +   pixels[1] + pixels[2]                                \n"
"         + pixels[3] - 2*pixels[4] + pixels[5]                                \n"
"         - pixels[6] -   pixels[7] - pixels[8];                               \n"
"  m[1] =   pixels[0] +   pixels[1] + pixels[2]                                \n"
"         + pixels[3] - 2*pixels[4] - pixels[5]                                \n"
"         + pixels[6] -   pixels[7] - pixels[8];                               \n"
"  m[2] =   pixels[0] +   pixels[1] - pixels[2]                                \n"
"         + pixels[3] - 2*pixels[4] - pixels[5]                                \n"
"         + pixels[6] +   pixels[7] - pixels[8];                               \n"
"  m[3] =   pixels[0] -   pixels[1] - pixels[2]                                \n"
"         + pixels[3] - 2*pixels[4] - pixels[5]                                \n"
"         + pixels[6] +   pixels[7] + pixels[8];                               \n"
"  m[4] = - pixels[0] -   pixels[1] - pixels[2]                                \n"
"         + pixels[3] - 2*pixels[4] + pixels[5]                                \n"
"         + pixels[6] +   pixels[7] + pixels[8];                               \n"
"  m[5] = - pixels[0] -   pixels[1] + pixels[2]                                \n"
"         - pixels[3] - 2*pixels[4] + pixels[5]                                \n"
"         + pixels[6] +   pixels[7] + pixels[8];                               \n"
"  m[6] = - pixels[0] +   pixels[1] + pixels[2]                                \n"
"         - pixels[3] - 2*pixels[4] + pixels[5]                                \n"
"         - pixels[6] +   pixels[7] + pixels[8];                               \n"
"  m[7] =   pixels[0] +   pixels[1] + pixels[2]                                \n"
"         - pixels[3] - 2*pixels[4] + pixels[5]                                \n"
"         - pixels[6] -   pixels[7] + pixels[8];                               \n"
"                                                                              \n"
"  for (k = 0, max = 0.0f; k < 8; k++)                                         \n"
"    if (max < m[k])                                                           \n"
"      max = m[k];                                                             \n"
"                                                                              \n"
"  return amount * max;                                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static inline gfloat                                                          \n"
"edge_gradient (gfloat *pixels, gdouble amount)                                \n"
"{                                                                             \n"
"  const gint v_kernel[9] = { 0,  0,  0,                                       \n"
"                             0,  4, -4,                                       \n"
"                             0,  0,  0 };                                     \n"
"  const gint h_kernel[9] = { 0,  0,  0,                                       \n"
"                             0, -4,  0,                                       \n"
"                             0,  4,  0 };                                     \n"
"                                                                              \n"
"  gint i;                                                                     \n"
"  gfloat v_grad, h_grad;                                                      \n"
"                                                                              \n"
"  for (i = 0, v_grad = 0.0f, h_grad = 0.0f; i < 9; i++)                       \n"
"    {                                                                         \n"
"      v_grad += v_kernel[i] * pixels[i];                                      \n"
"      h_grad += h_kernel[i] * pixels[i];                                      \n"
"    }                                                                         \n"
"                                                                              \n"
"  return  sqrt (v_grad * v_grad * amount +                                    \n"
"                h_grad * h_grad * amount);                                    \n"
"}                                                                             \n"
"                                                                              \n"
"static inline gfloat                                                          \n"
"edge_roberts (gfloat *pixels, gdouble amount)                                 \n"
"{                                                                             \n"
"  const gint v_kernel[9] = { 0,  0,  0,                                       \n"
"                             0,  4,  0,                                       \n"
"                             0,  0, -4 };                                     \n"
"  const gint h_kernel[9] = { 0,  0,  0,                                       \n"
"                             0,  0,  4,                                       \n"
"                             0, -4,  0 };                                     \n"
"  gint i;                                                                     \n"
"  gfloat v_grad, h_grad;                                                      \n"
"                                                                              \n"
"  for (i = 0, v_grad = 0.0f, h_grad = 0.0f; i < 9; i++)                       \n"
"    {                                                                         \n"
"      v_grad += v_kernel[i] * pixels[i];                                      \n"
"      h_grad += h_kernel[i] * pixels[i];                                      \n"
"    }                                                                         \n"
"                                                                              \n"
"  return sqrt (v_grad * v_grad * amount +                                     \n"
"               h_grad * h_grad * amount);                                     \n"
"}                                                                             \n"
"                                                                              \n"
"static inline gfloat                                                          \n"
"edge_differential (gfloat *pixels, gdouble amount)                            \n"
"{                                                                             \n"
"  const gint v_kernel[9] = { 0,  0,  0,                                       \n"
"                             0,  2, -2,                                       \n"
"                             0,  2, -2 };                                     \n"
"  const gint h_kernel[9] = { 0,  0,  0,                                       \n"
"                             0, -2, -2,                                       \n"
"                             0,  2,  2 };                                     \n"
"  gint i;                                                                     \n"
"  gfloat v_grad, h_grad;                                                      \n"
"                                                                              \n"
"  for (i = 0, v_grad = 0.0f, h_grad = 0.0f; i < 9; i++)                       \n"
"    {                                                                         \n"
"      v_grad += v_kernel[i] * pixels[i];                                      \n"
"      h_grad += h_kernel[i] * pixels[i];                                      \n"
"    }                                                                         \n"
"                                                                              \n"
"  return sqrt (v_grad * v_grad * amount +                                     \n"
"               h_grad * h_grad * amount);                                     \n"
"}                                                                             \n"
"                                                                              \n"
"static inline gfloat                                                          \n"
"edge_laplace (gfloat *pixels, gdouble amount)                                 \n"
"{                                                                             \n"
"  const gint kernel[9] = { 1,  1,  1,                                         \n"
"                           1, -8,  1,                                         \n"
"                           1,  1,  1 };                                       \n"
"  gint i;                                                                     \n"
"  gfloat grad;                                                                \n"
"                                                                              \n"
"  for (i = 0, grad = 0.0f; i < 9; i++)                                        \n"
"    grad += kernel[i] * pixels[i];                                            \n"
"                                                                              \n"
"  return grad * amount;                                                       \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglOperationAreaFilter *area = GEGL_OPERATION_AREA_FILTER (operation);     \n"
"                                                                              \n"
"  const Babl *input_f = gegl_operation_get_source_format (operation, \"input\");\n"
"  const Babl *format  = babl_format (\"R'G'B' float\");                       \n"
"                                                                              \n"
"  area->left   =                                                              \n"
"  area->right  =                                                              \n"
"  area->top    =                                                              \n"
"  area->bottom = 1;                                                           \n"
"                                                                              \n"
"  if (input_f)                                                                \n"
"    {                                                                         \n"
"      if (babl_format_has_alpha (input_f))                                    \n"
"        format = babl_format (\"R'G'B'A float\");                             \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", format);                   \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle  result = { 0, 0, 0, 0 };                                     \n"
"  GeglRectangle *in_rect;                                                     \n"
"                                                                              \n"
"  in_rect = gegl_operation_source_get_bounding_box (operation, \"input\");    \n"
"  if (in_rect)                                                                \n"
"    {                                                                         \n"
"      result = *in_rect;                                                      \n"
"    }                                                                         \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o      = GEGL_PROPERTIES (operation);                       \n"
"  const Babl     *format = gegl_operation_get_format (operation, \"output\"); \n"
"  gint            components = babl_format_get_n_components (format);         \n"
"  gboolean        has_alpha  = babl_format_has_alpha (format);                \n"
"                                                                              \n"
"  gfloat *src_buff;                                                           \n"
"  gfloat *dst_buff;                                                           \n"
"  GeglRectangle rect;                                                         \n"
"  gint x, y, ix, iy, b, idx;                                                  \n"
"                                                                              \n"
"  rect = gegl_operation_get_required_for_output (operation, \"input\", roi);  \n"
"                                                                              \n"
"  src_buff = g_new (gfloat, rect.width * rect.height * components);           \n"
"  dst_buff = g_new0 (gfloat, roi->width * roi->height * components);          \n"
"                                                                              \n"
"  gegl_buffer_get (input, &rect, 1.0, format, src_buff,                       \n"
"                   GEGL_AUTO_ROWSTRIDE, o->border_behavior);                  \n"
"                                                                              \n"
"  for (y = 0; y < roi->height; y++)                                           \n"
"    {                                                                         \n"
"      iy = y + 1;                                                             \n"
"      for (x = 0; x < roi->width; x++)                                        \n"
"        {                                                                     \n"
"          ix = x + 1;                                                         \n"
"          for (b = 0; b < 3; b++)                                             \n"
"            {                                                                 \n"
"                                                                              \n"
"#define SRCPIX(X,Y,B) src_buff[((X) + (Y) * rect.width) * components + B]     \n"
"                                                                              \n"
"              gfloat window[9];                                               \n"
"              window[0] = SRCPIX(ix - 1, iy - 1, b);                          \n"
"              window[1] = SRCPIX(ix, iy - 1, b);                              \n"
"              window[2] = SRCPIX(ix + 1, iy - 1, b);                          \n"
"              window[3] = SRCPIX(ix - 1, iy, b);                              \n"
"              window[4] = SRCPIX(ix, iy, b);                                  \n"
"              window[5] = SRCPIX(ix + 1, iy, b);                              \n"
"              window[6] = SRCPIX(ix - 1, iy + 1, b);                          \n"
"              window[7] = SRCPIX(ix, iy + 1, b);                              \n"
"              window[8] = SRCPIX(ix + 1, iy + 1, b);                          \n"
"                                                                              \n"
"              idx = (x + y * roi->width) * components + b;                    \n"
"                                                                              \n"
"              switch (o->algorithm)                                           \n"
"                {                                                             \n"
"                  default:                                                    \n"
"                  case GEGL_EDGE_SOBEL:                                       \n"
"                    dst_buff[idx] = edge_sobel (window, o->amount);           \n"
"                    break;                                                    \n"
"                                                                              \n"
"                  case GEGL_EDGE_PREWITT:                                     \n"
"                    dst_buff[idx] = edge_prewitt (window, o->amount);         \n"
"                    break;                                                    \n"
"                                                                              \n"
"                  case GEGL_EDGE_GRADIENT:                                    \n"
"                    dst_buff[idx] = edge_gradient (window, o->amount);        \n"
"                    break;                                                    \n"
"                                                                              \n"
"                  case GEGL_EDGE_ROBERTS:                                     \n"
"                    dst_buff[idx] = edge_roberts (window, o->amount);         \n"
"                    break;                                                    \n"
"                                                                              \n"
"                  case GEGL_EDGE_DIFFERENTIAL:                                \n"
"                    dst_buff[idx] = edge_differential (window, o->amount);    \n"
"                    break;                                                    \n"
"                                                                              \n"
"                  case GEGL_EDGE_LAPLACE:                                     \n"
"                    dst_buff[idx] = edge_laplace (window, o->amount);         \n"
"                    break;                                                    \n"
"                }                                                             \n"
"            }                                                                 \n"
"                                                                              \n"
"          if (has_alpha)                                                      \n"
"            dst_buff[idx + 1] = SRCPIX(ix, iy, 3);                            \n"
"        }                                                                     \n"
"#undef SRCPIX                                                                 \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_buffer_set (output, roi, level, format, dst_buff, GEGL_AUTO_ROWSTRIDE);\n"
"                                                                              \n"
"  g_free (src_buff);                                                          \n"
"  g_free (dst_buff);                                                          \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process             = process;                                \n"
"  operation_class->prepare          = prepare;                                \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->opencl_support   = FALSE;                                  \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:edge\",                                           \n"
"    \"title\",       _(\"Edge Detection\"),                                   \n"
"    \"categories\",  \"edge-detect\",                                         \n"
"    \"license\",     \"GPL3+\",                                               \n"
"    \"description\", _(\"Several simple methods for detecting edges\"),       \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
