static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2008 Jan Heller <jan.heller (at) matfyz.cz>                      \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#define LOWEST_TEMPERATURE     1000                                           \n"
"#define HIGHEST_TEMPERATURE   12000                                           \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (original_temperature, _(\"Original temperature\"), 6500)     \n"
"  description(_(\"Estimated temperature of the light source in Kelvin \"      \n"
"                \"the image was taken with.\"))                               \n"
"  value_range (LOWEST_TEMPERATURE, HIGHEST_TEMPERATURE)                       \n"
"  ui_meta     (\"unit\", \"kelvin\")                                          \n"
"                                                                              \n"
"property_double (intended_temperature, _(\"Intended temperature\"), 6500)     \n"
"  description(_(\"Corrected estimation of the temperature of the light \"     \n"
"                \"source in Kelvin.\"))                                       \n"
"  value_range (LOWEST_TEMPERATURE, HIGHEST_TEMPERATURE)                       \n"
"  ui_meta     (\"unit\", \"kelvin\")                                          \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_NAME     color_temperature                                    \n"
"#define GEGL_OP_C_SOURCE color-temperature.c                                  \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static const gfloat rgb_r55[3][12];                                           \n"
"                                                                              \n"
"static void                                                                   \n"
"convert_k_to_rgb (gfloat  temperature,                                        \n"
"                  gfloat *rgb)                                                \n"
"{                                                                             \n"
"  gint channel;                                                               \n"
"                                                                              \n"
"  if (temperature < LOWEST_TEMPERATURE)                                       \n"
"    temperature = LOWEST_TEMPERATURE;                                         \n"
"                                                                              \n"
"  if (temperature > HIGHEST_TEMPERATURE)                                      \n"
"    temperature = HIGHEST_TEMPERATURE;                                        \n"
"                                                                              \n"
"  /* Evaluation of an approximation of the Planckian locus in linear RGB space\n"
"   * by rational functions of degree 5 using Horner's scheme                  \n"
"   * f(x) =  (p1*x^5 + p2*x^4 + p3*x^3 + p4*x^2 + p5*x + p6) /                \n"
"   *            (x^5 + q1*x^4 + q2*x^3 + q3*x^2 + q4*x + q5)                  \n"
"   */                                                                         \n"
"  for (channel = 0; channel < 3; channel++)                                   \n"
"    {                                                                         \n"
"      gfloat nomin, denom;                                                    \n"
"      gint   deg;                                                             \n"
"                                                                              \n"
"      nomin = rgb_r55[channel][0];                                            \n"
"      for (deg = 1; deg < 6; deg++)                                           \n"
"        nomin = nomin * temperature + rgb_r55[channel][deg];                  \n"
"                                                                              \n"
"      denom = rgb_r55[channel][6];                                            \n"
"      for (deg = 1; deg < 6; deg++)                                           \n"
"        denom = denom * temperature + rgb_r55[channel][6 + deg];              \n"
"                                                                              \n"
"      rgb[channel] = nomin / denom;                                           \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  const Babl *format = babl_format (\"RGBA float\");                          \n"
"  gegl_operation_set_format (operation, \"input\", format);                   \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"finalize (GObject *object)                                                    \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (object);                               \n"
"                                                                              \n"
"  if (o->user_data)                                                           \n"
"    {                                                                         \n"
"      g_free (o->user_data);                                                  \n"
"      o->user_data = NULL;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->finalize (object);                   \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"notify (GObject    *object,                                                   \n"
"        GParamSpec *pspec)                                                    \n"
"{                                                                             \n"
"  if (strcmp (pspec->name, \"original-temperature\") == 0 ||                  \n"
"      strcmp (pspec->name, \"intended-temperature\") == 0)                    \n"
"    {                                                                         \n"
"      GeglProperties *o = GEGL_PROPERTIES (object);                           \n"
"                                                                              \n"
"      /* one of the properties has changed,                                   \n"
"       * invalidate the preprocessed coefficients                             \n"
"       */                                                                     \n"
"      if (o->user_data)                                                       \n"
"        {                                                                     \n"
"          g_free (o->user_data);                                              \n"
"          o->user_data = NULL;                                                \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (G_OBJECT_CLASS (gegl_op_parent_class)->notify)                          \n"
"    G_OBJECT_CLASS (gegl_op_parent_class)->notify (object, pspec);            \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static gfloat *                                                               \n"
"preprocess (GeglProperties *o)                                                \n"
"{                                                                             \n"
"  gfloat *coeffs = g_new (gfloat, 3);                                         \n"
"  gfloat  original_temperature_rgb[3];                                        \n"
"  gfloat  intended_temperature_rgb[3];                                        \n"
"                                                                              \n"
"  convert_k_to_rgb (o->original_temperature, original_temperature_rgb);       \n"
"  convert_k_to_rgb (o->intended_temperature, intended_temperature_rgb);       \n"
"                                                                              \n"
"  coeffs[0] = original_temperature_rgb[0] / intended_temperature_rgb[0];      \n"
"  coeffs[1] = original_temperature_rgb[1] / intended_temperature_rgb[1];      \n"
"  coeffs[2] = original_temperature_rgb[2] / intended_temperature_rgb[2];      \n"
"                                                                              \n"
"  return coeffs;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"/* GeglOperationPointFilter gives us a linear buffer to operate on            \n"
" * in our requested pixel format                                              \n"
" */                                                                           \n"
"static gboolean                                                               \n"
"process (GeglOperation       *op,                                             \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties   *o         = GEGL_PROPERTIES (op);                         \n"
"  gfloat       *in_pixel  = in_buf;                                           \n"
"  gfloat       *out_pixel = out_buf;                                          \n"
"  const gfloat *coeffs    = o->user_data;                                     \n"
"                                                                              \n"
"  in_pixel = in_buf;                                                          \n"
"  out_pixel = out_buf;                                                        \n"
"                                                                              \n"
"  if (! coeffs)                                                               \n"
"    {                                                                         \n"
"      coeffs = o->user_data = preprocess (o);                                 \n"
"    }                                                                         \n"
"                                                                              \n"
"  while (n_pixels--)                                                          \n"
"    {                                                                         \n"
"      out_pixel[0] = in_pixel[0] * coeffs[0];                                 \n"
"      out_pixel[1] = in_pixel[1] * coeffs[1];                                 \n"
"      out_pixel[2] = in_pixel[2] * coeffs[2];                                 \n"
"      out_pixel[3] = in_pixel[3];                                             \n"
"                                                                              \n"
"      in_pixel += 4;                                                          \n"
"      out_pixel += 4;                                                         \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#include \"opencl/gegl-cl.h\"                                                 \n"
"#include \"opencl/color-temperature.cl.h\"                                    \n"
"                                                                              \n"
"static GeglClRunData *cl_data = NULL;                                         \n"
"                                                                              \n"
"/* OpenCL processing function */                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *op,                                          \n"
"            cl_mem               in_tex,                                      \n"
"            cl_mem               out_tex,                                     \n"
"            size_t               global_worksize,                             \n"
"            const GeglRectangle *roi,                                         \n"
"            int                  level)                                       \n"
"{                                                                             \n"
"  /* Retrieve a pointer to GeglProperties structure which contains all the    \n"
"   * chanted properties                                                       \n"
"   */                                                                         \n"
"                                                                              \n"
"  GeglProperties   *o         = GEGL_PROPERTIES (op);                         \n"
"  const gfloat *coeffs    = o->user_data;                                     \n"
"                                                                              \n"
"  cl_int cl_err = 0;                                                          \n"
"                                                                              \n"
"  if (! coeffs)                                                               \n"
"    {                                                                         \n"
"      coeffs = o->user_data = preprocess (o);                                 \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    {                                                                         \n"
"      const char *kernel_name[] = {\"gegl_color_temperature\", NULL};         \n"
"      cl_data = gegl_cl_compile_and_build (color_temperature_cl_source, kernel_name);\n"
"    }                                                                         \n"
"                                                                              \n"
"  if (!cl_data) return 1;                                                     \n"
"                                                                              \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 0, sizeof(cl_mem),    (void*)&in_tex);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 1, sizeof(cl_mem),    (void*)&out_tex);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 2, sizeof(cl_float),  (void*)&coeffs[0]);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 3, sizeof(cl_float),  (void*)&coeffs[1]);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 4, sizeof(cl_float),  (void*)&coeffs[2]);\n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueNDRangeKernel(gegl_cl_get_command_queue (),          \n"
"                                        cl_data->kernel[0], 1,                \n"
"                                        NULL, &global_worksize, NULL,         \n"
"                                        0, NULL, NULL);                       \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  return FALSE;                                                               \n"
"                                                                              \n"
"error:                                                                        \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GObjectClass                  *object_class;                                \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *point_filter_class;                          \n"
"  gchar                         *composition = \"<?xml version='1.0' encoding='UTF-8'?>\"\n"
"    \"<gegl>\"                                                                \n"
"    \"<node operation='gegl:color-temperature'>\"                             \n"
"    \"  <params>\"                                                            \n"
"    \"    <param name='intended-temperature'>12000</param>\"                  \n"
"    \"  </params>\"                                                           \n"
"    \"</node>\"                                                               \n"
"    \"<node operation='gegl:load'>\"                                          \n"
"    \"  <params>\"                                                            \n"
"    \"    <param name='path'>standard-input.png</param>\"                     \n"
"    \"  </params>\"                                                           \n"
"    \"</node>\"                                                               \n"
"    \"</gegl>\";                                                              \n"
"                                                                              \n"
"  object_class       = G_OBJECT_CLASS (klass);                                \n"
"  operation_class    = GEGL_OPERATION_CLASS (klass);                          \n"
"  point_filter_class = GEGL_OPERATION_POINT_FILTER_CLASS (klass);             \n"
"                                                                              \n"
"  object_class->finalize = finalize;                                          \n"
"  object_class->notify   = notify;                                            \n"
"                                                                              \n"
"  operation_class->prepare = prepare;                                         \n"
"                                                                              \n"
"  point_filter_class->process    = process;                                   \n"
"  point_filter_class->cl_process = cl_process;                                \n"
"                                                                              \n"
"  operation_class->opencl_support = TRUE;                                     \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:color-temperature\",                              \n"
"    \"title\",       _(\"Color Temperature\"),                                \n"
"    \"categories\",  \"color\",                                               \n"
"    \"description\", _(\"Change the color temperature of the image, from an assumed original color temperature to an intended one.\"),\n"
"    \"reference-composition\", composition,                                   \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"/* Coefficients of rational functions of degree 5 fitted per color channel to \n"
" * the linear RGB coordinates of the range 1000K-12000K of the Planckian locus\n"
" * with the 20K step. Original CIE-xy data from                               \n"
" *                                                                            \n"
" * http://www.aim-dtp.net/aim/technology/cie_xyz/k2xy.txt                     \n"
" *                                                                            \n"
" * converted to the linear RGB space assuming the ITU-R BT.709-5/sRGB primaries\n"
" */                                                                           \n"
"static const gfloat rgb_r55[3][12] =                                          \n"
"{                                                                             \n"
"  {                                                                           \n"
"     6.9389923563552169e-01,  2.7719388100974670e+03,                         \n"
"     2.0999316761104289e+07, -4.8889434162208414e+09,                         \n"
"    -1.1899785506796783e+07, -4.7418427686099203e+04,                         \n"
"     1.0000000000000000e+00,  3.5434394338546258e+03,                         \n"
"    -5.6159353379127791e+05,  2.7369467137870544e+08,                         \n"
"     1.6295814912940913e+08,  4.3975072422421846e+05                          \n"
"  },                                                                          \n"
"  {                                                                           \n"
"     9.5417426141210926e-01,  2.2041043287098860e+03,                         \n"
"    -3.0142332673634286e+06, -3.5111986367681120e+03,                         \n"
"    -5.7030969525354260e+00,  6.1810926909962016e-01,                         \n"
"     1.0000000000000000e+00,  1.3728609973644000e+03,                         \n"
"     1.3099184987576159e+06, -2.1757404458816318e+03,                         \n"
"    -2.3892456292510311e+00,  8.1079012401293249e-01                          \n"
"  },                                                                          \n"
"  {                                                                           \n"
"    -7.1151622540856201e+10,  3.3728185802339764e+16,                         \n"
"    -7.9396187338868539e+19,  2.9699115135330123e+22,                         \n"
"    -9.7520399221734228e+22, -2.9250107732225114e+20,                         \n"
"     1.0000000000000000e+00,  1.3888666482167408e+16,                         \n"
"     2.3899765140914549e+19,  1.4583606312383295e+23,                         \n"
"     1.9766018324502894e+22,  2.9395068478016189e+18                          \n"
"  }                                                                           \n"
"};                                                                            \n"
"                                                                              \n"
"#endif                                                                        \n"
;
