static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2011 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"enum_start (gegl_vignette_shape)                                              \n"
"  enum_value (GEGL_VIGNETTE_SHAPE_CIRCLE,  \"circle\",  N_(\"Circle\"))       \n"
"  enum_value (GEGL_VIGNETTE_SHAPE_SQUARE,  \"square\",  N_(\"Square\"))       \n"
"  enum_value (GEGL_VIGNETTE_SHAPE_DIAMOND, \"diamond\", N_(\"Diamond\"))      \n"
"enum_end (GeglVignetteShape)                                                  \n"
"                                                                              \n"
"property_enum (shape, _(\"Vignette shape\"),                                  \n"
"    GeglVignetteShape, gegl_vignette_shape,                                   \n"
"    GEGL_VIGNETTE_SHAPE_CIRCLE)                                               \n"
"                                                                              \n"
"property_color (color, _(\"Color\"), \"black\")                               \n"
"    description (_(\"Defaults to 'black', you can use transparency here to erase portions of an image\"))\n"
"                                                                              \n"
"property_double (radius, _(\"Radius\"), 1.2)                                  \n"
"    description (_(\"How far out vignetting goes as portion of half image diagonal\"))\n"
"    value_range (0.0, 3.0)                                                    \n"
"    ui_meta     (\"unit\", \"relative-distance\")                             \n"
"                                                                              \n"
"property_double (softness, _(\"Softness\"), 0.8)                              \n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_double (gamma, _(\"Gamma\"), 2.0)                                    \n"
"    description (_(\"Falloff linearity\"))                                    \n"
"    value_range (1.0, 20.0)                                                   \n"
"                                                                              \n"
"property_double (proportion, _(\"Proportion\"), 1.0)                          \n"
"    description(_(\"How close we are to image proportions\"))                 \n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_double (squeeze, _(\"Squeeze\"), 0.0)                                \n"
"    description ((\"Aspect ratio to use, -0.5 = 1:2, 0.0 = 1:1, 0.5 = 2:1, \" \n"
"              \"-1.0 = 1:inf 1.0 = inf:1, this is applied after \"            \n"
"              \"proportion is taken into account, to directly use \"          \n"
"              \"squeeze factor as proportions, set proportion to 0.0.\"))     \n"
"    value_range (-1.0, 1.0)                                                   \n"
"                                                                              \n"
"property_double (x, _(\"Center X\"), 0.5)                                     \n"
"    ui_range    (0, 1.0)                                                      \n"
"    ui_meta     (\"unit\", \"relative-coordinate\")                           \n"
"    ui_meta     (\"axis\", \"x\")                                             \n"
"                                                                              \n"
"property_double (y, _(\"Center Y\"), 0.5)                                     \n"
"    ui_range    (0, 1.0)                                                      \n"
"    ui_meta     (\"unit\", \"relative-coordinate\")                           \n"
"    ui_meta     (\"axis\", \"y\")                                             \n"
"                                                                              \n"
"property_double (rotation, _(\"Rotation\"), 0.0)                              \n"
"    value_range (0.0, 360.0)                                                  \n"
"    ui_meta     (\"unit\", \"degree\") /* XXX: change to radians */           \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_C_SOURCE vignette.c                                           \n"
"#define GEGL_OP_NAME     vignette                                             \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\", babl_format (\"RaGaBaA float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RaGaBaA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"/* conversion function mapping between scale and aspect                       \n"
" *                                                                            \n"
" * -1.0 = 0.0                                                                 \n"
" * -0.5 = 0.5                                                                 \n"
" *  0.0 = 1.0                                                                 \n"
" *  0.5 = 2.0                                                                 \n"
" *  1.0 = infinity                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"static float                                                                  \n"
"aspect_to_scale (float aspect)                                                \n"
"{                                                                             \n"
"  if (aspect == 0.0)                                                          \n"
"    return 1.0;                                                               \n"
"  else if (aspect > 0.0)                                                      \n"
"    return tan(aspect * (G_PI/2)) + 1;                                        \n"
"  else /* (aspect < 0.0) */                                                   \n"
"    return 1.0/(tan((-aspect) * (G_PI/2)) + 1);                               \n"
"}                                                                             \n"
"                                                                              \n"
"#if 0                                                                         \n"
"static float                                                                  \n"
"scale_to_aspect (float scale)                                                 \n"
"{                                                                             \n"
"  if (scale == 1.0)                                                           \n"
"    return 0.0;                                                               \n"
"  else if (scale > 1.0)                                                       \n"
"    return atan (scale-1) / (G_PI/2);                                         \n"
"  else /* scale < 1.0 */                                                      \n"
"    return -atan(1.0/scale- 1) / (G_PI/2);                                    \n"
"}                                                                             \n"
"#endif                                                                        \n"
"                                                                              \n"
"#include \"opencl/gegl-cl.h\"                                                 \n"
"                                                                              \n"
"#include \"opencl/vignette.cl.h\"                                             \n"
"                                                                              \n"
"static GeglClRunData * cl_data = NULL;                                        \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *operation,                                   \n"
"            cl_mem               in_tex,                                      \n"
"            cl_mem               out_tex,                                     \n"
"            size_t               global_worksize,                             \n"
"            const GeglRectangle *roi,                                         \n"
"            gint                 level)                                       \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  gfloat      scale;                                                          \n"
"  gfloat      radius0, radius1;                                               \n"
"  gint        roi_x, roi_y,x;                                                 \n"
"  gint        midx, midy;                                                     \n"
"  GeglRectangle *bounds = gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  gfloat length = hypot (bounds->width, bounds->height)/2;                    \n"
"  gfloat rdiff;                                                               \n"
"  gfloat cost, sint;                                                          \n"
"  gfloat      color[4];                                                       \n"
"                                                                              \n"
"  scale = bounds->width / (1.0 * bounds->height);                             \n"
"  scale = scale * (o->proportion) + 1.0 * (1.0-o->proportion);                \n"
"  scale *= aspect_to_scale (o->squeeze);                                      \n"
"  length = (bounds->width/2.0);                                               \n"
"                                                                              \n"
"  if (scale > 1.0)                                                            \n"
"    length /= scale;                                                          \n"
"                                                                              \n"
"  gegl_color_get_pixel (o->color, babl_format (\"RGBA float\"), color);       \n"
"                                                                              \n"
"  for (x=0; x<3; x++)   /* premultiply */                                     \n"
"    color[x] *= color[3];                                                     \n"
"                                                                              \n"
"  radius0 = o->radius * (1.0-o->softness);                                    \n"
"  radius1 = o->radius;                                                        \n"
"  rdiff = radius1-radius0;                                                    \n"
"  if (fabs (rdiff) < 0.0001)                                                  \n"
"    rdiff = 0.0001;                                                           \n"
"                                                                              \n"
"  midx = bounds->x + bounds->width * o->x;                                    \n"
"  midy = bounds->y + bounds->height * o->y;                                   \n"
"                                                                              \n"
"  roi_x = roi->x;                                                             \n"
"  roi_y = roi->y;                                                             \n"
"                                                                              \n"
"  /* constant for all pixels */                                               \n"
"  cost = cos(-o->rotation * (G_PI*2/360.0));                                  \n"
"  sint = sin(-o->rotation * (G_PI*2/360.0));                                  \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    {                                                                         \n"
"      const char *kernel_name[] = {\"vignette_cl\",NULL};                     \n"
"      cl_data = gegl_cl_compile_and_build (vignette_cl_source, kernel_name);  \n"
"    }                                                                         \n"
"  if (!cl_data) return TRUE;                                                  \n"
"                                                                              \n"
"  {                                                                           \n"
"  const size_t gbl_size[2] = {roi->width, roi->height};                       \n"
"                                                                              \n"
"  gint   shape = (gint) o->shape;                                             \n"
"  gfloat gamma = o->gamma;                                                    \n"
"                                                                              \n"
"  cl_int cl_err = 0;                                                          \n"
"  cl_float4 f_color;                                                          \n"
"  f_color.s[0] = color[0];                                                    \n"
"  f_color.s[1] = color[1];                                                    \n"
"  f_color.s[2] = color[2];                                                    \n"
"  f_color.s[3] = color[3];                                                    \n"
"                                                                              \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 0,  sizeof(cl_mem),   (void*)&in_tex);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 1,  sizeof(cl_mem),   (void*)&out_tex);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 2,  sizeof(cl_float4),(void*)&f_color);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 3,  sizeof(cl_float), (void*)&scale);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 4,  sizeof(cl_float), (void*)&cost);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 5,  sizeof(cl_float), (void*)&sint);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 6,  sizeof(cl_int),   (void*)&roi_x);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 7,  sizeof(cl_int),   (void*)&roi_y);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 8,  sizeof(cl_int),   (void*)&midx);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 9,  sizeof(cl_int),   (void*)&midy);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 10, sizeof(cl_int),   (void*)&shape);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 11, sizeof(cl_float), (void*)&gamma);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 12, sizeof(cl_float), (void*)&length);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 13, sizeof(cl_float), (void*)&radius0);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 14, sizeof(cl_float), (void*)&rdiff);\n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueNDRangeKernel(gegl_cl_get_command_queue (),          \n"
"                                       cl_data->kernel[0], 2,                 \n"
"                                       NULL, gbl_size, NULL,                  \n"
"                                       0, NULL, NULL);                        \n"
"  CL_CHECK;                                                                   \n"
"  }                                                                           \n"
"                                                                              \n"
"  return  FALSE;                                                              \n"
"                                                                              \n"
"error:                                                                        \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  gfloat     *in_pixel =  in_buf;                                             \n"
"  gfloat     *out_pixel = out_buf;                                            \n"
"  gfloat      scale;                                                          \n"
"  gfloat      radius0, radius1;                                               \n"
"  gint        x, y;                                                           \n"
"  gint        midx, midy;                                                     \n"
"  GeglRectangle *bounds = gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"  gfloat length = hypot (bounds->width, bounds->height)/2;                    \n"
"  gfloat rdiff;                                                               \n"
"  gfloat cost, sint;                                                          \n"
"  gfloat costy, sinty;                                                        \n"
"                                                                              \n"
"  gfloat      color[4];                                                       \n"
"                                                                              \n"
"  scale = bounds->width / (1.0 * bounds->height);                             \n"
"  scale = scale * (o->proportion) + 1.0 * (1.0-o->proportion);                \n"
"                                                                              \n"
"  scale *= aspect_to_scale (o->squeeze);                                      \n"
"                                                                              \n"
"  length = (bounds->width/2.0);                                               \n"
"                                                                              \n"
"  if (scale > 1.0)                                                            \n"
"    length /= scale;                                                          \n"
"                                                                              \n"
"  gegl_color_get_pixel (o->color, babl_format (\"RGBA float\"), color);       \n"
"                                                                              \n"
"  for (x=0; x<3; x++)   /* premultiply */                                     \n"
"    color[x] *= color[3];                                                     \n"
"                                                                              \n"
"  radius0 = o->radius * (1.0-o->softness);                                    \n"
"  radius1 = o->radius;                                                        \n"
"  rdiff = radius1-radius0;                                                    \n"
"  if (fabs (rdiff) < 0.0001)                                                  \n"
"    rdiff = 0.0001;                                                           \n"
"                                                                              \n"
"  midx = bounds->x + bounds->width * o->x;                                    \n"
"  midy = bounds->y + bounds->height * o->y;                                   \n"
"                                                                              \n"
"  x = roi->x;                                                                 \n"
"  y = roi->y;                                                                 \n"
"                                                                              \n"
"  /* constant for all pixels */                                               \n"
"  cost = cos(-o->rotation * (G_PI*2/360.0));                                  \n"
"  sint = sin(-o->rotation * (G_PI*2/360.0));                                  \n"
"                                                                              \n"
"  /* constant per scanline */                                                 \n"
"  sinty = sint * (y-midy) - midx;                                             \n"
"  costy = cost * (y-midy) + midy;                                             \n"
"                                                                              \n"
"  while (n_pixels--)                                                          \n"
"    {                                                                         \n"
"      gfloat strength = 0.0;                                                  \n"
"      gfloat u, v;                                                            \n"
"#if 0                                                                         \n"
"      u = cost * (x-midx) - sint * (y-midy) + midx;                           \n"
"      v = sint * (x-midx) + cost * (y-midy) + midy;                           \n"
"      /* optimized out of innerscanline loop */                               \n"
"#endif                                                                        \n"
"      u = cost * (x-midx) - sinty;                                            \n"
"      v = sint * (x-midx) + costy;                                            \n"
"                                                                              \n"
"      if (length == 0.0)                                                      \n"
"        strength = 0.0;                                                       \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          switch (o->shape)                                                   \n"
"          {                                                                   \n"
"            case GEGL_VIGNETTE_SHAPE_CIRCLE:                                  \n"
"              strength = hypot ((u-midx) / scale, v-midy);      break;        \n"
"            case GEGL_VIGNETTE_SHAPE_SQUARE:                                  \n"
"              strength = MAX(ABS(u-midx) / scale, ABS(v-midy)); break;        \n"
"            case GEGL_VIGNETTE_SHAPE_DIAMOND:                                 \n"
"              strength = ABS(u-midx) / scale + ABS(v-midy);     break;        \n"
"          }                                                                   \n"
"          strength /= length;                                                 \n"
"          strength = (strength-radius0) / rdiff;                              \n"
"        }                                                                     \n"
"                                                                              \n"
"      if (strength<0.0)                                                       \n"
"        strength = 0.0;                                                       \n"
"      if (strength>1.0)                                                       \n"
"        strength = 1.0;                                                       \n"
"                                                                              \n"
"      if (o->gamma > 0.9999 && o->gamma < 2.0001)                             \n"
"        strength *= strength;  /* fast path for default gamma */              \n"
"      else if (o->gamma != 1.0)                                               \n"
"        strength = powf(strength, o->gamma); /* this gamma factor is          \n"
"                                              * very expensive..              \n"
"                                              */                              \n"
"                                                                              \n"
"      out_pixel[0]=in_pixel[0] * (1.0-strength) + color[0] * strength;        \n"
"      out_pixel[1]=in_pixel[1] * (1.0-strength) + color[1] * strength;        \n"
"      out_pixel[2]=in_pixel[2] * (1.0-strength) + color[2] * strength;        \n"
"      out_pixel[3]=in_pixel[3] * (1.0-strength) + color[3] * strength;        \n"
"                                                                              \n"
"      out_pixel += 4;                                                         \n"
"      in_pixel  += 4;                                                         \n"
"                                                                              \n"
"      /* update x and y coordinates */                                        \n"
"      if (++x>=roi->x + roi->width)                                           \n"
"        {                                                                     \n"
"          x=roi->x;                                                           \n"
"          y++;                                                                \n"
"          sinty = sint * (y-midy) - midx;                                     \n"
"          costy = cost * (y-midy) + midy;                                     \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *point_filter_class;                          \n"
"                                                                              \n"
"  operation_class    = GEGL_OPERATION_CLASS (klass);                          \n"
"  point_filter_class = GEGL_OPERATION_POINT_FILTER_CLASS (klass);             \n"
"                                                                              \n"
"  operation_class->prepare        = prepare;                                  \n"
"  operation_class->no_cache       = TRUE;                                     \n"
"  operation_class->opencl_support = TRUE;                                     \n"
"                                                                              \n"
"  point_filter_class->process    = process;                                   \n"
"  point_filter_class->cl_process = cl_process;                                \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",               \"gegl:vignette\",                                \n"
"    \"title\",              _(\"Vignette\"),                                  \n"
"    \"position-dependent\", \"true\",                                         \n"
"    \"categories\",         \"render:photo\",                                 \n"
"    \"description\", _(\"Applies a vignette to an image. Simulates the luminance \"\n"
"                     \"fall off at the edge of exposed film, and some other \"\n"
"                     \"fuzzier border effects that can naturally occur with \"\n"
"                     \"analog photography\"),                                 \n"
"  NULL);                                                                      \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
